         title   Rich Text Word Editor
         comment '================================================================|'
         comment '* WordEdit V1.0 uses RICHED20.DLL V3                            *'
         comment '* Copyright (c) 2000-2001 Ewayne L. Wagner, All Rights Reserved.*'
         comment '* Unless you can improve on the program and send me             *'
         comment '* the changes. yooper@kalamazoo.net                             *'
         comment '================================================================|'
         .586
         .model  flat, STDCALL
            option   casemap: none   ; case sensitive
            include  \MASM32V1\include\Windows.inc
            include  \MASM32V1\include\WordEdit.inc
            include  \MASM32V1\include\USER32.inc
            include  \MASM32V1\include\KERNEL32.inc
            include  \MASM32V1\include\GDI32.inc
            include  \MASM32V1\include\COMCTL32.inc
            include  \MASM32V1\include\COMDLG32.inc
            include  \MASM32V1\include\TAPI32.inc
            include  \MASM32V1\include\WINMM.inc
            include  \MASM32V1\include\WINSPOOL.inc
            include  \MASM32V1\include\SHELL32.inc
            include  \MASM32V1\include\ADVAPI32.inc
;   include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\lib\USER32.lib
         includelib  \MASM32V1\lib\KERNEL32.lib
         includelib  \MASM32V1\lib\GDI32.lib
         includelib  \MASM32V1\lib\COMCTL32.lib
         includelib  \MASM32V1\lib\COMDLG32.lib
         includelib  \MASM32V1\lib\TAPI32.lib
         includelib  \MASM32V1\lib\WINMM.lib
         includelib  \MASM32V1\lib\WINSPOOL.lib
         includelib  \MASM32V1\lib\SHELL32.lib
         includelib  \MASM32V1\lib\ADVAPI32.lib

         .list

MsgBox   MACRO   Resource:req, Title:=<ERROR>, Flags:=<MB_OK or MB_ICONEXCLAMATION>
         mov     eax, Resource
         lea     ebx, Title
         mov     ecx, Flags
        call     ErrorMsg
         ENDM

MOVmw    MACRO Var1, Var2
         lea     esi, Var2
         lea     edx, Var1
         REPEAT     2
            mov     al, [esi]
            mov     [edx], al
            inc     esi
            inc     edx
         ENDM
         ENDM

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

;========================================================================|
;*  DATA                                                                 *
;========================================================================|
           .data
;
; Simple Text (all others are in the resource file)
;
szNULL       db      0
pTitle       db      'Word Editor And Print Program V2 - ',0
szHelp       db      'WordEdit.HLP',0
szSetup      db      'Setup',0  
szWordEdit   db      'WordEdit.exe',0
szCallDLL    db      'EWCallDLL.exe',0
class        db      'Word Editor V2',0
EditPT       db      'EDIT',0
;richedit     db      'RichEdit',0
;RichEdDLL    db      'RICHED32.DLL',0
richedit     db      'RichEdit20A',0
RichEdDLL    db      'RICHED20.DLL',0

ToolClass    db      'ToolbarWindow32',0
combobox     db      'COMBOBOX',0
listbox      db      'LISTBOX',0
Butt         db      'BUTTON',0
Stat         db      'STATIC',0

Libname      db      'splash.dll',0
ProcName     db      'Delay',0

buttxt1      db      'Goto Line',0
buttxt2      db      'Assemble',0
ERROR        db      'ERROR',0
statcls      db      'msctls_statusbar32',0
szFR         db      'Find And Replace',0
szOpenTitle  db      'Open File',0
szSaveTitle  db      'Save File As',0
szSel        db      'Selection',0
szFootF      db      '$#',0
szAll        db      'All',0
Butt1        db      'Jump',0
Butt2        db      'Topic',0
Butt3        db      'Border',0
Butt4        db      'BitMap',0

szFilter     db      164 dup(0)
szALL        db      'All Files',0,'*.*',0,0

szTXT        db      'Text Files & Rich Text Files',0,'*.TXT;*.RTF',0,
                     'Asm Files & Inc Files & RC Files',0,'*.ASM;*.INC;*.RC',0,
                     'All Files',0,'*.*',0,0

szExt        db      '*.txt',0
FontMS       db      'MS Sans Serif',0  ;'Arial',0
FontCN       db      'Courier New',0
FontName     db      64 dup(0)
szUntitled   db      '(Untitled)',0

szHCW        db      'This RTF file has been formatted for the'
             db      0Dh,0Ah
             db      'Help Workshop and there has been changes to the file.'
             db      0Dh,0Ah
             db      "The control code's have been dropped, the program will"
             db      0Dh,0Ah
             db      "attempt to reinstate the Help Workshop's control code's."
             db      0Dh,0Ah,0Dh,0Ah
             db      "If you have problem's compiling the Help file it's posible"
             db      0Dh,0Ah
             db      "that some of the control code's were not reinstated."
             db      0Dh,0Ah
             db      "So far the success rate has been 100 %, but there's"
             db      0Dh,0Ah
             db      'always the first time.'
             db      0Dh,0Ah,0Dh,0Ah
             db      'Do you wish to continue?',0

NoRTF        db      'You need to open a RTF file first.',0
NoHTML       db      'This is not a HTML type file.'
             db      0Dh,0Ah
             db      '   Do you wish to continue?',0
FindEnd      db      'There Are No More Matches.'
             db      0Dh,0Ah
             db      'Would You Like To Restart From The'
TopBot       db      ' Top? '
             db      0
Top          db      ' Top? '
Bot          db      ' Bot? '
;
dmsg         equ     $
dmo          db      2 dup(?)
             db      '-'
dda          db      2 dup(?)
             db      '-'
dyr          db      4 dup(?)
             db      '   ',0
tmsg         equ     $
tmsghour     db      2 dup(?)
             db      ':'
tmsgmin      db      2 dup(?)
             db      ':'
tmsgsec      db      2 dup(?)
             db      ' '
tmsgampm     db      '?' ;'A'/'P'
             db      'M',0
Page1        equ     $ 
             db      'Page '
num          db      2 dup(?),0

fsmsg        db      'File Size: = '
Fsize        db      8 dup(0),0

LdataR       db      'Row: '
cnt1         db      5 dup(?)
             db      '  of  '
cnt2         db      5 dup(?)
             db      0

LdataC       db      'Col: '
cnt3         db      4 dup(?)
             db      '  of  '
cnt4         db      4 dup(?)
             db      0

mmsg         db      'X: '
mmsgx        db      4 dup(0)
             db      '   Y: '
mmsgy        db      4 dup(0)
             db      0
;
lmsg         db      'Line '
lmsgline     db      '---- Col '
lmsgcol      db      '----',0
;
; Static Buffers
;
Misc         db      40 dup(?)
Zeros        db      32 dup('0'),0
Space1       db      256 dup(' '),0
Space2       db      40 dup(' '),0
LineBuff     db      256 dup(?),0
szWork       db      256 dup(?),0
szBuff       db      256 dup(?),0
;
szFind       db      100 dup(0),0
szRep        db      100 dup(0),0
;
szSaving     db      'File modified: ',0
szSelect     db      'Selected Text!',0
Head         db      256 dup(0),0
PathName     db      256 dup(0),0
FileName     db      64 dup(0),0
RootDir      db      100 dup(0),0
CurDir       db      100 dup(0),0
ExtType      db      4 dup(?),0
;
parts        dd      SBPARTS dup(0)
;
szFons       db      'Courier;Fixedsys;Modern;MS Sans Serif;MS Serif;Roman;Small Fonts;System;Terminal;Signet Roundhand;Terminal Font for the IBM 8514;',0
szSize       db      '2,3,4,5,6,7,8,9,10,11,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,',
                     '50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,',0
szColor      db      'White,Black,Maroon,Green,DarkGn,Brown,Orange,Olive,Navy,Purple,Teal,Gray,Silver,',
                     'Red,Lime,Yellow,Blue,BlueLt,Fuchsia,Aqua,',0
NumRange     db      '4.0,3.875,3.750,3.625,3.500,3.375,3.250,3.125,3.0,2.875,2.750,2.625,2.500,2.375,2.250,2.125,2.0,',
                     '1.875,1.750,1.625,1.500,1.375,1.250,1.125,1.0,0.875,0.750,0.625,0.500,0.375,0.250,0.0,',0
SuperPoint   db      '180,170,160,150,140,130,120,110,100,90,80,70,60,50,40,30,20,10,',0
SubPoint     db      '-180,-170,-160,-150,-140,-130,-120,-110,-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,',0
ScriptSize   db      '100%,95%,90%,85%,80%,75%,70%,65%,60%,55%,50%,45%,40%,35%,30%,',0
ComboColor   dd      00ffffffh,00000000h,00000080h,00008000h,00004000h,00004080h,000080ffh,00008080h
             dd      00800000h,00800080h,00808000h,00808080h,00c0c0c0h,000000ffh,0000ff00h,0000ffffh
             dd      00ff0000h,00ff8000h,00ff00ffh,00ffff00h
ComboEnd     dd      0   ; N O T E Don't move or remove
;
; Assorted handles
;
hWnd         dd      0
hWndStat     dd      0
hWndTool     dd      0
hWndToolF    dd      0
hMiscTool    dd      0
hToolBarH    dd      0
hCFont       dd      0
hCSize       dd      0
hCColor      dd      0
hSel         dd      0
hAll         dd      0
hKey         dd      0 
hREdit       dd      0
lpRichEdit   dd      0
hREdDll      dd      0
hInst        dd      0
hMenu        dd      0
hSMenu       dd      0
hAccel       dd      0
hFRDlg       dd      0
hEdit        dd      0
hFile        dd      0
hReg         dd      0
hFont        dd      0
cFont        dd      0
pFont        dd      0
sFont        dd      0
hiMem        dd      0
hpMem        dd      0
fpMem        dd      0
hsMem        dd      0
fsMem        dd      0
hMnem        dd      0
hAscii       dd      0
hAsciibox    dd      0
lpAsciibox   dd      0
hPopUp       dd      0
hSUDlg       dd      0
hListML      dd      0
hListMR      dd      0
hListIL      dd      0
hListIR      dd      0
hRule        dd      0
hRULER       dd      0
hMemDC       dd      0
hBrush       dd      0
hHandL       dd      0
hHandR       dd      0
lpRuler      dd      0
lpRulerPos   dd      0
;
; Misc storage
;
CommandLine  dd      0
sMemSize     dd      65535
bytesread    dd      0
ExitCode     dd      0
MultInst     dd      0
fiMem        dd      0
hDC          dd      0
HoldT        dd      0
PL           dd      0
RuleOn       dd      1
RTF          dd      0
OA           dd      0
cnt          dd      0
pw           dd      0
ph           dd      0
XP           dd      0
YP           dd      0
UpdateSel    dd      0
UpdateAll    dd      1
TopLineP     dd      0
Ind          db      '.25',0
LIndO        db      5 dup(' '),0
RIndO        db      5 dup(' '),0

Prev         dd      0
sw1          dd      0
sw2          dd      0
sw3          dd      0
Len          dd      0
PrtHead      dd      1
PrtColor     dd      0
Sel          dd      0
RNum10       REAL10  ?
RTwips1000   REAL10  1.44
RTwips0      REAL10  1361.25 ;1440.0
RPixInch     REAL10  90.75   ;92.75
RPixTwip     REAL10  15.867768595  ;15.5256
SizeU        REAL10  0.85
SizeD        REAL10  0.85
PointU       dd      90
PointD       dd      -90
savL         dd      0
savT         dd      0
savR         dd      0
savB         dd      0
FRFlags      dd      0
OpnFlag      dd      0

w1           dd      0
w2           dd      0
w3           dd      0
w4           dd      0
w5           dd      0
w6           dd      0
w7           dd      0
NH           dd      0
seax         dd      0
secx         dd      0
Hold         dd      0
Conv         db      10 dup(?),0
 
PH           dd      2
pX           dd      0
pY           dd      30 ;10
mL           dd      0  ;75
mT           dd      0  ;75
mR           dd      0  ;75
mB           dd      0  ;75
iL           dd      0
iR           dd      0
idML         dd      31
idMR         dd      31
savML        dd      0
savMR        dd      0

BytesO       dd      0

;
CustClrs     dd      16 dup(?)
;
;Setup
TabStops    dd      32 dup(?)
Patn        db      '*.*',0

;Registry entries
szFonts     db      'SOFTWARE\Microsoft\Windows\CurrentVersion\Fonts',0
szFontsNT   db      'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts',0
szRedit     db      'Word Editor V2',0
szREGSZ     db      'REG_SZ',0
szStrtup    db      'Startup',0
szLeft      db      'Pos1 Left',0
szTop       db      'Pos2 Top',0
szRight     db      'Pos3 Right',0
szBottom    db      'Pos4 Bottom',0
szFont      db      'Font',0
szPoint     db      'Point',0
szEffects   db      'Effects',0
szMask      db      'Mask',0
szSaveWhen  db      '[SaveSettings]',0
szSetFlags  db      '[Settings Flags]',0
szWordWrap  db      '[Word Wrap]',0
szMaxWin    db      '[Max Win on start]',0
szHWSName   db      '[Help Workshop]',0
szAthName   db      '[Author Name]',0

szMult      db      'MultipleInstances',0
rTS1        db      '[Tab Stop 01]',0
rTS2        db      '[Tab Stop 02]',0
rTS3        db      '[Tab Stop 03]',0
rTS4        db      '[Tab Stop 04]',0
rTS5        db      '[Tab Stop 05]',0
rTS6        db      '[Tab Stop 06]',0
rTS7        db      '[Tab Stop 07]',0
rTS8        db      '[Tab Stop 08]',0
rTS9        db      '[Tab Stop 09]',0
rTS10       db      '[Tab Stop 10]',0
rF1         db      '[F1 Col. Pos]',0
rF2         db      '[F2 Col. Pos]',0
rF3         db      '[F3 Col. Pos]',0
rF4         db      '[F4 Col. Pos]',0
rSP         db      '[Shift Space]',0
rST         db      '[Shift To Cl]',0
rTC         db      '[C1 Text Color...]',0
rTBGC       db      '[C2 TextBG Color.]',0
rBC         db      '[C3 BG Color.....]',0

SaveWhen    dd      1
SetFlags    dd      0fh
MaxWin      dd      0
WWrap       dd      1

sTS         dd      0
sSPACE      dd      0
TS1         dd      7
TS2         dd      9
TS3         dd      10
TS4         dd      18
TS5         dd      20
TS6         dd      25
TS7         dd      30
TS8         dd      35
TS9         dd      40
TS10        dd      45
Pos1        dd      7
Pos2        dd      9
Pos3        dd      10
Pos4        dd      18
SPACE       dd      5
SHIFT       dd      10
TextC       dd      00808000h
TextBGC     dd      00ffffffh
BackGC      dd      00ffffffh
PointSize   dd      0

;Syntax
TextBG       dd      1
SBook        dd      0
EBook        dd      0
HBook        dd      0
SPos         dd      0
EPos         dd      0
FileOff      dd      0
Lnum         dd      0
Llen         dd      0
Ltot         dd      0
CurPos       dd      0
SavPos       dd      0
SavPosL      dd      0
SavPosR      dd      0
Clear        db      256 dup(' '),0

dash         db      ' - ',0
SlashB       db      '\',0
SP1          db      ' ',0
Per          db      '.',0
szColon      db      ';',0 
HT           db      09h,0              
;
fFind        dd      0
;
tempword     dd      0
;
xPerInch     dd      0
yPerInch     dd      0
;
 
lpType       dd      0
lpcbData     dd      0
lpdwDisp     dd      0
lpcValues    dd      0
lpcbValueName dd     0

dwAttr       dd      0
MenuCnt      dd      0
FirstTime    dd      1
HG           dd      0
osvBN        dd      0
ChgFC        dd      0

tb       TBBUTTON    <0,IDM_NEW,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <1,IDM_OPEN,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <2,IDM_SAVE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <3,IDM_CUT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <4,IDM_COPY,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <5,IDM_PASTE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <6,IDM_DEL,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <7,IDM_UNDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <8,IDM_REDO,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <9,IDM_LEFT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <10,IDM_CENTER,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <11,IDM_RIGHT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <12,IDM_BOLD,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <13,IDM_ITALIC,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <14,IDM_UNDERLINE,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <15,IDM_UNDERLINE2,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <16,IDM_INDR,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <17,IDM_INDL,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <18,IDM_PRINT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <19,IDM_EWEDIT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
tbb      TBBUTTON    <20,IDM_EXIT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
tbl      equ         $-tbb

tbf      TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
         TBBUTTON    <0,IDM_FINDTEXT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <1,IDM_FINDNEXT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <2,IDM_FINDPREV,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
         TBBUTTON    <3,IDM_REPLACETEXT,TBSTATE_ENABLED,TBSTYLE_BUTTON,0,0>
tbbf     TBBUTTON    <0,0,TBSTATE_ENABLED,TBSTYLE_SEP,0,0>
tbf2     equ         $-tbbf

;
; Structure storage
;
stin     STARTUPINFO     <?>
prin PROCESS_INFORMATION <?>
ms       MEMORYSTATUS    <?> ; Memory status
msg      MSG             <?> ; GetMessage/DispatchMessage structure
doci     DOCINFO         <?> ; Docinfo (printing support)
ofn      OPENFILENAME    <?> ; Open file common dialog structure
psd      PAGESETUPDLG    <?> ; Page setup common dialog structure
pd       PRINTDLG        <?> ; print common dialog structure
time     SYSTEMTIME      <?> ; For GetLocalTime
rect     RECT            <?> ; Rectangle
tm       TEXTMETRIC      <?> ; Text Metrics
wc       WNDCLASSEX      <?> ; Window class (RegisterClass) structure
EditS    EDITSTREAM      <?> ; For EM_STREAMIN/EM_STREAMOUT
charF    CHARFORMAT2     <?> ; For EM_GETCHARFORMAT/EM_SETCHARFORMAT
cf       CHOOSEFONT      <?> ; Keep CHOOSFONT/LOGFONT together (Choose Font comm dlg)
lf       LOGFONT         <?> ; For CreateFontIndirect
cc       CHOOSECOLOR     <?> ; Chose Color comm dlg
pf       PARAFORMAT2     <0> ; For EM_SETPARAFORMAT
ft       FINDTEXT        <>  ; For EM_EXGETSEL/EM_EXSETSEL
;ftX      FINDTEXTEX      <>  ; For EM_EXGETSEL/EM_EXSETSEL
fr       FORMATRANGE     <0> ; For EM_FORMATRANGE
osv      OSVERSIONINFO   <>
tbab     TBADDBITMAP     <>
cr       CHARRANGE       <?> ; Character range

;stxt     SETTEXTEX       <>
dis      DRAWITEMSTRUCT  <?>
Crect    RECT            <?> ; Rectangle
pt       POINT           <>
;========================================================================|
;*  CODE                                                                 *
;========================================================================|
         .code
start:

      INVOKE     LoadLibrary, addr Libname   ; Splash screen
      .if !eax
            jmp     NoLib
      .endif
        push     eax                         ; Module handle 
        push     4                           ; Delay value
      INVOKE     GetProcAddress, eax, ADDR ProcName
      .if !eax
            jmp     NoProc
      .endif
        call     eax

NoProc:
         pop     eax
      INVOKE     FreeLibrary, eax

NoLib:
      INVOKE     GetCommandLine
         mov     CommandLine, eax
        call     ParseCommandLine
        call     InitCommonControls          ; Initialize the common ctrl lib
      INVOKE     LoadLibrary, ADDR RichEdDLL ;Load the RichEd20.dll
         mov     hREdDll, eax
      INVOKE     GetModuleHandle, 0          ; Get hmod (in eax)
         mov     hInst, eax                  ; hInst is same as HMODULE
findcls:
      INVOKE     FindWindow, offset class, 0
          or     eax, eax
          jz     regclass
          or     MultInst, 1                 ; More then one instance of prog loaded

regclass:
      INVOKE     WinMain, hInst, NULL, CommandLine, SW_SHOWDEFAULT
      INVOKE     ExitProcess, msg.wParam

;===========================================================|
;* Initialize the WndClass structure and register our class *
;===========================================================|
WinMain PROC     hinst:DWORD, hPrevInst:DWORD, CmdLine:DWORD, CmdShow:DWORD
         mov     wc.cbSize, sizeof WNDCLASSEX    
         mov     wc.style, CS_HREDRAW or CS_VREDRAW or CS_GLOBALCLASS
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
       MOVmd     wc.hInstance, hInst
      INVOKE     LoadIcon, hInst, IDI_ICON1
         mov     wc.hIcon, eax
         mov     wc.hIconSm, eax
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
;         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.hbrBackground,COLOR_BTNFACE+1
         mov     wc.lpszMenuName, 0
         mov     wc.lpszClassName, offset class
      INVOKE     RegisterClassEx, offset wc

;=======================
; Get our menu resources
;=======================
      INVOKE     LoadMenu, hInst, IDR_MENU1
         mov     hMenu, eax
      INVOKE     LoadMenu, hInst, IDR_MENU2   
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenu, eax

;=======================
; Create the main window
;=======================
      INVOKE     RegQuery, offset szLeft, CW_USEDEFAULT
         mov     rect.left, eax
      INVOKE     RegQuery, offset szTop, CW_USEDEFAULT
         mov     rect.top, eax
      INVOKE     RegQuery, offset szBottom, CW_USEDEFAULT
         mov     rect.bottom, eax
      INVOKE     RegQuery, offset szRight, CW_USEDEFAULT
         mov     rect.right, eax
;         add     rect.bottom, 5
         cmp     eax, CW_USEDEFAULT
         jne     CalcWH
         mov     ebx, eax
         jmp     CreWin
CalcWH:  mov     eax, rect.bottom
         sub     eax, rect.top
         mov     ebx, rect.right
         sub     ebx, rect.left
CreWin:
      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, offset class, offset pTitle,
                 WS_OVERLAPPEDWINDOW or WS_VISIBLE,
                 rect.left, rect.top, ebx, eax, 0, hMenu, hInst, 0
         mov     hWnd, eax
      INVOKE     lstrcpy, addr FontName, addr FontCN

;==================================================
; Show the window and go into message dispatch loop
;==================================================
      INVOKE     RegQuery, offset szMaxWin, MaxWin
         mov     MaxWin, eax
      .if eax
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_CHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWMAXIMIZED
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_UNCHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      .endif
      INVOKE     UpdateWindow, hWnd
      INVOKE     LoadAccelerators, hInst, IDR_ACCEL
         mov     hAccel, eax

BeginLoop:
      INVOKE     GetMessage, offset msg, 0, 0, 0
         cmp     ax, 0
          je     EndLoop
      INVOKE     TranslateAccelerator, hWnd, hAccel, offset msg
         cmp     eax, 0
         jne     BeginLoop
      INVOKE     IsDialogMessage, hFRDlg, offset msg
         cmp     eax, 0
         jne     BeginLoop
      INVOKE     IsDialogMessage, hSUDlg, offset msg
         cmp     eax, 0
         jne     BeginLoop
      INVOKE     TranslateMessage, offset msg

;**** changes keyboard del key to menu del key ****
;.if msg.wParam == 2eh
;INVOKE     PeekMessage, offset msg, hWnd, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE	
;INVOKE     PostMessage, hWnd, WM_COMMAND, IDM_DEL, 0
;jmp     BeginLoop
;.endif
;**********************************************

      INVOKE     DispatchMessage, offset msg
         jmp     BeginLoop
EndLoop:
         ret
WinMain  ENDP
NoLoad:
;========================================================================|
;*  WNDPROC                                                              *
;========================================================================|
WndProc  PROC    uses ebx edi esi hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
         mov     eax, wmsg
         cmp     eax, WM_TIMER
          je     wmtimer
         cmp     eax, WM_SIZE
          je     wmsize
         cmp     eax, WM_CREATE
          je     wmcreate
         cmp     eax, WM_COMMAND
          je     wmcommand
         cmp     eax, WM_DESTROY
          je     wmdestroy
         cmp     eax, WM_NOTIFY
          je     wmnotify
         cmp     eax, WM_MENUSELECT
          je     wmmenuselect
         cmp     eax, WM_SETFOCUS
          je     wmsetfocus
         cmp     eax, WM_TRACKCURSOR      ; = 1025
          je     wmtrackcursor
         cmp     eax, WM_QUERYENDSESSION
          je     wmqueryendsession
         cmp     eax, WM_CLOSE
          je     wmclose
         cmp     eax, WM_INITMENUPOPUP
          je     wminitmenupopup
         cmp     eax, WM_OPENCOMMANDARGS  ; = 1026
          je     idmopenB
         cmp     eax, WM_PAINT
          je     wmpaint
         cmp     eax, WM_DRAWITEM
          je     wmdrawitem
         jmp     defwndproc

wmcommand:
         mov     eax, wparam
        cwde                              ; Only low word contains command
         mov     w1, eax
         jmp     BranchTo

IDCMD    dd idmnew,idmopen,idmopenhex,idmnew,idmsave,idmsaveas,idmpagesu,idmprintprev,idmprint,idmsavesettings
         dd wmclose,idmcut,idmcopy,idmpaste,idmdelete,idmundo,idmredo,idmfind,idmfindnext,idmfindprev,idmreplace
         dd idmreplacenext,idmshiftr,idmshiftl,idmshiftto,idmpos1,idmpos2,idmpos3,idmpos4,idmgotoline,idmselall
         dd idmqfont,idmfont,idmbold,idmitalic,idmunderline,idmunderline2,idmstrikeout,idmbullet,idmnumber
         dd idmparclear,idmleft,idmcenter,idmright,idmview,idmmargin,idmindr,idmindl,idmsupersub,idmsuperscript
         dd idmsubscript,idmnorscript,idmwwrap,idmrtfon,idmrtfoff,idmsettabs,idmconv,idmhtml,idmsetup,idmbooks
         dd idmbookr,idmprthead,idmascii,idmcalctb,idmhelp,idmabout,idmversion,idmewedit,idmmax

BranchTo:
      .if eax > 6000 && eax < 6070
            sub     eax, 6001
           imul     eax, 4
            jmp     IDCMD[eax]
      .endif

;--------------- [File name list from the file menu MRU] --------------- 
      .if eax > 1400 && eax < 1411
           push     eax
         INVOKE     CheckSav, hwnd
         INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
         INVOKE     lstrcpy, addr szWork, addr PathName
            pop     eax
         INVOKE     GetRegPath, eax, addr szRedit
         INVOKE     lstrcpy, addr PathName, eax
         INVOKE     lstrcpy, addr szBuff, addr PathName
            mov     ecx, lengthof szALL
            mov     esi, offset szALL
             or     w5, 1
             or     OA, 1
            jmp     DoOpen
      .endif

      .if eax > 80 && eax < 86
            jmp     idmcombos
      .endif

;---------- [Help Generate Stuff] ----------
      .if eax == 90    ; Toggle Toolbar
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, eax, 0
         .if !Toggle || Toggle == 10 
            INVOKE     HelpGenerate, hwnd, hInst, addr richedit, hFont, 11
         .else
            INVOKE     HelpGenerate, hwnd, hInst, addr richedit, hFont, 10
         .endif
            and     HideDlg, 0
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, 91, 0
            jmp     return0
      .endif

      .if eax == 91                                         ; Hide or Show Help Gen Dialogs
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, 91, 0
      .endif

      .if eax == 92                                         ; Close Help Gen session
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, IDCANCEL, 0
      .endif

      .if eax == 94                                         ; Update Parent Window from Help Gen
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, IDOK, 1
      .endif

      .if eax > B0 && eax < B6                              ; Complete Jumps, Topics, Borders, & BitMaps
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, w1, 0
      .endif

      .if eax > B9 && eax <= B11                            ; Semi-Auto Jumps & Topics 
         INVOKE     SendMessage, lparam, TB_GETSTATE, eax, 0
            mov     w2, eax
         INVOKE     CheckDlgButton, hHelpGen, w1, w2        ; Sets the appropiate check box
         INVOKE     SendMessage, lparam, TB_ISBUTTONCHECKED, w1, 0
            mov     ebx, w1
         .if ebx == B10
              inc     ebx
         .else
              dec     ebx
         .endif
         .if eax && w2
               mov     w2, 0
            INVOKE     CheckDlgButton, hHelpGen, ebx, w2    ; Sets the appropiate check box
         .else
               mov     w2, 1
            INVOKE     CheckDlgButton, hHelpGen, ebx, w2    ; Sets the appropiate check box
         .endif
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, w1, 0
      .endif

      .if eax >= cb1 && eax <= cb3
         INVOKE     SendMessage, lparam, BM_GETCHECK, 0, 0
            mov     w2, eax
         INVOKE     CheckDlgButton, hHelpGen, w1, w2        ; w1 Sets the appropiate check box
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, w1, 0
      .endif

      .if eax == 89                                         ; Resets Semi-Auto Jumps & Topics 
         INVOKE     SendMessage, hHelpGen, WM_COMMAND, w1, 0
      .endif

      .if wparam == 4000 || wparam == 8000
         .if hHelpGen                                       ; Already open
               jmp     return0
         .endif
         .if PathName == 0
            INVOKE    MessageBox, NULL, addr NoRTF, addr ERROR, MB_OK or MB_ICONEXCLAMATION
               jmp     return0
         .endif
         .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f' || RTF == 0
            INVOKE    MessageBox, NULL, addr NoRTF, addr ERROR, MB_OK or MB_ICONEXCLAMATION
               jmp     return0
         .endif
      INVOKE     CheckSav, hwnd
      .if OpnFlag == IDCANCEL
            ret
      .elseif OpnFlag == IDNO
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
             or     OA, 1
           call     OpenFileA
      .endif
         INVOKE     CreateWinRTF, hwnd, hInst, addr richedit, hFont, 0
             or     HG, 1
             or     OA, 1
           call     OpenFileA
         .if wparam == 4000
            INVOKE     HelpGenerate, hwnd, hInst, addr richedit, hFont, 0
         .else
            INVOKE     HelpGenerate, hwnd, hInst, addr richedit, hFont, 1
         .endif
            jmp     return0
      .endif
         jmp     defwndproc


wmdrawitem:
      .if wparam == 83
            mov     esi, lparam
            mov     edi, offset dis
            mov     ecx, sizeof dis
            rep     movsb

         .if dis.itemID != -1
            INVOKE     SendMessage, hCColor, CB_GETLBTEXT, dis.itemID, addr szBuff
               mov     Len, eax
            INVOKE     GetTextMetrics, dis.hdc, addr tm
               mov     eax, dis.rcItem.bottom
               add     eax, dis.rcItem.top
               sub     eax, tm.tmHeight
               shr     eax, 1
               mov     YP, eax

; No ODS_FOCUS or ODS_COMBOBOXEDIT
            .if dis.itemState == ODS_SELECTED
               INVOKE     CreateSolidBrush, 00800000h
                  mov     hBrush, eax
               INVOKE     FillRect, dis.hdc, addr dis.rcItem, eax
               INVOKE     SetTextColor, dis.hdc, 00ffffffh
               INVOKE     SetBkColor, dis.hdc, 00800000h
            .else
               INVOKE     CreateSolidBrush, 00ffffffh
                  mov     hBrush, eax
               INVOKE     FillRect, dis.hdc, addr dis.rcItem, eax
               INVOKE     SetTextColor, dis.hdc, dis.itemData
               INVOKE     SetBkColor, dis.hdc, 00ffffffh
            .endif        
               add     dis.rcItem.left, 15
            INVOKE     TextOut, dis.hdc, dis.rcItem.left, YP, addr szBuff, Len
               sub     dis.rcItem.left, 14
               mov     dis.rcItem.right, 14
               add     dis.rcItem.top, 1
               sub     dis.rcItem.bottom, 1
               mov     ebx, dis.itemID
            INVOKE     SetBkColor, dis.hdc, dword ptr ComboColor[ebx*4]
            INVOKE     DrawText, dis.hdc, addr Clear, 6, addr dis.rcItem, DT_LEFT or DT_SINGLELINE
            INVOKE     DeleteObject, hBrush
         .endif
            mov     dis.itemState, ODS_DEFAULT
            jmp     return0
      .endif
 
wmpaint:
            MOVmd     rect.left, SavPosL
              add     rect.left, 3

;      .if osvBN > 1111 && hRule
;            MOVmd     rect.left, SavPosL
;            MOVmd     rect.right, SavPosR
;              add     rect.left, 6
;             call     BuildRuler
;      .endif
         jmp     defwndproc

idmcombos:
      .if eax == 81          ; Font Name
         INVOKE     SendMessage, hCFont, CB_GETDROPPEDSTATE, 0, 0
         .if eax
            INVOKE     SendMessage, hCFont, CB_GETCURSEL, 0, 0
            INVOKE     SendMessage, hCFont, CB_GETLBTEXT, eax, addr szWork ; FontName
            INVOKE     GetWindowText, hCColor, addr szBuff, 20
            INVOKE     SendMessage, hCColor, CB_FINDSTRING, -1, addr szBuff
             MOVmd     w5, ComboColor[eax*4]
            INVOKE     SetFocus, hREdit
            INVOKE     ColorFontDlg, 0, 0, 0, 333
         .endif
      .endif
      .if eax == 82          ; Font Size
         INVOKE     SendMessage, hCSize, CB_GETDROPPEDSTATE, 0, 0
         .if eax
            INVOKE     SendMessage, hCSize, CB_GETCURSEL, 0, 0
            INVOKE     SendMessage, hCSize, CB_GETLBTEXT, eax, addr szBuff
               mov     w1, 0
            INVOKE     AsciiBase, addr szBuff, addr w1, 10  ; PointSize
               mov     eax, w1
              imul     eax, 20
               mov     charF.yHeight, eax
            INVOKE     GetWindowText, hCFont, addr szWork, 64
            INVOKE     GetWindowText, hCColor, addr szBuff, 20
            INVOKE     SendMessage, hCColor, CB_FINDSTRING, -1, addr szBuff
             MOVmd     w5, ComboColor[eax*4]
            INVOKE     SetFocus, hREdit
            INVOKE     ColorFontDlg, 0, 0, 0, 333
         .endif
      .endif
      .if eax == 83          ; Font Color
         INVOKE     SendMessage, hCColor, CB_GETDROPPEDSTATE, 0, 0
         .if eax
            INVOKE     SendMessage, hCColor, CB_GETCURSEL, 0, 0
             MOVmd     w5, ComboColor[eax*4]
            INVOKE     GetWindowText, hCFont, addr szWork, 64
            INVOKE     ColorFontDlg, 0, 0, 0, 333
            INVOKE     SetFocus, hREdit
         .endif
      .endif
      .if eax == 84          ; Selection
         INVOKE     SendMessage, hSel, BM_GETCHECK, 0, 0    ; Gets check state
            mov     UpdateSel, eax
            xor     UpdateAll, eax
         INVOKE     SetFocus, hREdit
      .endif
      .if eax == 85          ; All
         INVOKE     SendMessage, hAll, BM_GETCHECK, 0, 0    ; Gets check state
            mov     UpdateAll, eax
            xor     UpdateSel, eax
         INVOKE     SetFocus, hREdit
      .endif
         jmp     return0

idmnew:
      INVOKE     StartNewDocument, hwnd
      INVOKE     SendMessage, hREdit, WM_SETTEXT, 0, offset szNULL
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
         mov     byte ptr PathName, 0
        call     SetTitle
         jmp     return0

idmopen:
         mov     ecx, lengthof szTXT
         mov     esi, offset szTXT
         jmp     DoOpen
idmopenB:
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
          or     OA, 1
         jmp     DoOpen
DoOpen:
         mov     edi, offset szFilter
         rep     movsb
        call     OpenFileA 
         jmp     return0

idmopenhex:
;call     BuildRuler
         jmp     return0

idmsave:
         and     sw1, 0
        call     SaveFile
         jmp     return0
idmsaveas:
          or     sw1, 1
        call     SaveFile
         jmp     return0

idmprint:
        call     PrintProc
         jmp     return0

idmpagesu:
        call     DoPageSU
         jmp     return0

idmprintprev:
         jmp     return0

idmsavesettings:
      INVOKE     CheckMenuItem, hMenu, IDM_SAVESETTINGS, MF_BYCOMMAND
         and     SaveWhen, 0
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_SAVESETTINGS, MF_CHECKED
             or     SaveWhen, 1
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_SAVESETTINGS, MF_UNCHECKED
      .endif
         jmp     return0

idmexit:
      INVOKE     SendMessage, hwnd, WM_CLOSE, 0, 0
         jmp     return0

idmcut:
      INVOKE     SendMessage, hREdit, WM_CUT, 0 ,0
         jmp     return0

idmcopy:
      INVOKE     SendMessage, hREdit, WM_COPY, 0 ,0
         jmp     return0


idmpaste:
      INVOKE     GetActiveWindow
      .if eax == hFRDlg                        ; Paste to find or replace dialog
         INVOKE     GetDlgItem, hFRDlg, EditF  ; Get handle of edit box
         INVOKE     SendMessage, eax, WM_PASTE, 0 ,0
      .else
         INVOKE     SendMessage, hREdit, WM_PASTE, 0 ,0
      .endif
       MOVmd     EBook, SBook
        call     EnableDisableToolbar
         jmp     return0

idmundo:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     ChgFC, eax

UnDo:
      INVOKE     SendMessage, hREdit, EM_UNDO, 0, 0
        call     EnableDisableToolbar
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      INVOKE     SendMessage, hREdit, EM_EXLINEFROMCHAR, 0, cr.cpMax
      .if cr.cpMin == 0 && Ltot == eax
          MOVmd     cr.cpMax, cr.cpMin
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
         INVOKE     SendMessage, hWndTool, TB_GETSTATE, IDM_UNDO, 0
         .if eax
               jmp     UnDo
         .endif
      .endif
        call     SetInfoForCombos
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, ChgFC, 0
         jmp     return0

idmredo:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     ChgFC, eax

ReDo:
      INVOKE     SendMessage, hREdit, EM_REDO, 0, 0
        call     EnableDisableToolbar
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      INVOKE     SendMessage, hREdit, EM_EXLINEFROMCHAR, 0, cr.cpMax
      .if cr.cpMin == 0 && Ltot == eax
          MOVmd     cr.cpMax, cr.cpMin
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
         INVOKE     SendMessage, hWndTool, TB_GETSTATE, IDM_REDO, 0
         .if eax
               jmp     ReDo
         .endif
      .endif
        call     SetInfoForCombos
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, ChgFC, 0
         jmp     return0

idmdelete:
      .if hFRDlg > 0
            jmp     return0
      .endif
      INVOKE     SendMessage, hREdit, WM_CLEAR, 0 ,0
         CALL    EnableDisableToolbar
         jmp     return0

idmfind:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         mov     eax, offset FindReplace
      INVOKE     CreateDialogParam, hInst, IDD_FIND, hwnd, eax, 0
         cmp     eax, -1          ; Canceled?
          je     return0          ; yes, then return
      INVOKE     SetDlgItemText, hFRDlg, EditF, addr szFind
        call     EnableDisableToolbar
         jmp     return0

idmfindnext:
         and     Prev, 0
         mov     FRFlags, 1
         mov     ft.chrg.cpMax, -1
idmfindnext1:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      .if !Prev 
         add     cr.cpMin, 1
      .endif
       MOVmd     ft.chrg.cpMin, cr.cpMin
         lea     eax, offset szFind
         mov     ft.lpstrText, eax
      INVOKE     Find, hwnd, 1, FRFlags, ft.lpstrText, Prev
        call     EnableDisableToolbar
         jmp     return0

idmfindprev:
         mov     Prev, 1
         and     FRFlags, 0
         mov     ft.chrg.cpMax, 0
         jmp     idmfindnext1

idmreplace:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         mov     eax, offset FindReplace
      INVOKE     CreateDialogParam, hInst, IDD_FINDREPLACE, hwnd, eax, 0
         cmp     eax,IDCANCEL
          je     return0
      INVOKE     SetDlgItemText, hFRDlg, EditF, addr szFind
         jmp     return0

idmreplacenext:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szRep
      INVOKE     Find, hwnd, 1, FRFlags, ft.lpstrText, Prev
        call     EnableDisableToolbar
         jmp     return0

idmshiftr:
         mov     Misc, 'R'
        call     Shift
         jmp     return0
idmshiftl:
         mov     Misc, 'L'
        call     Shift
         jmp     return0
idmshiftto:
         mov     Misc, 'S'
        call     Shift
         jmp     return0

idmpos1:
       MOVmd     w5, Pos1
        call     Column
         jmp     return0
idmpos2:
       MOVmd     w5, Pos2
        call     Column
         jmp     return0
idmpos3:
       MOVmd     w5, Pos3
        call     Column
         jmp     return0
idmpos4:
       MOVmd     w5, Pos4
        call     Column
         jmp     return0

idmgotoline:
          or     sw2, 1
         mov     eax, offset CommonDlg
         mov     ebx, IDD_GOTOLINE
         jmp     DialogBox

idmselall:
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
         mov     SBook, 0
         mov     EBook, 1
        call     EnableDisableToolbar
      INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, -100000
         jmp     return0

idmqfont:
        call     Font
        call     GetInfoForCombos
         jmp     return0
idmfont:
         mov     eax, offset ColorFontDlg
         mov     ebx, IDD_FONT
         jmp     CreateDlg

idmbold:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.dwEffects
         xor     eax, CFE_BOLD
         mov     charF.dwEffects, eax
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
        call     EnableDisableToolbar
         jmp     return0

idmitalic:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.dwEffects
         xor     eax, CFE_ITALIC
         mov     charF.dwEffects, eax
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
        call     EnableDisableToolbar
         jmp     return0

idmunderline:

      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.dwEffects
         xor     eax, CFE_UNDERLINE
         mov     charF.dwEffects, eax
         mov     charF.dwMask, CFM_UNDERLINETYPE

      INVOKE     CheckMenuItem, hMenu, IDM_UNDERLINE, MF_BYCOMMAND
      .if eax == MF_CHECKED
            xor     eax, eax
      .else
            mov     eax, CFU_UNDERLINE
      .endif
         mov     charF.bUnderlineType, al  ;CFU_UNDERLINE
        test     eax, CFU_UNDERLINE
      INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE
        test     eax, -4  ; Force unequal
      INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE2

      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
         jmp     return0


idmunderline2:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.dwEffects
         xor     eax, CFE_UNDERLINE
         mov     charF.dwEffects, eax
         mov     charF.dwMask, CFM_UNDERLINETYPE

      .if charF.bUnderlineType == CFU_UNDERLINEDOUBLE
            xor     eax, eax
      .else
         mov     eax, CFU_UNDERLINEDOUBLE
      .endif
         mov     charF.bUnderlineType, al  ; CFU_UNDERLINEDOUBLE
        test     eax, CFU_UNDERLINEDOUBLE  ; jz if not equal
      INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE2
        test     eax, -4  ; Force unequal 
      INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE

      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
         jmp     return0

idmstrikeout:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.dwEffects
         xor     eax, CFE_STRIKEOUT
         mov     charF.dwEffects, eax
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
        call     EnableDisableToolbar
         jmp     return0

idmbullet:
         mov     pf.dwMask, PFM_NUMBERING or PFM_OFFSET
         mov     ax, PFN_BULLET
         mov     pf.wNumbering, ax  ; PFN_BULLET
         mov     pf.dxOffset, 300
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         mov     pf.dwMask, 0
         jmp     return0

idmnumber:
         mov     pf.dwMask, PFM_NUMBERING or PFM_OFFSET or PFM_NUMBERINGSTYLE or PFM_NUMBERINGSTART
         mov     pf.wNumbering, 2       ; 2 = Arabic numbers  3 = let L/C  4 = let U/C  5 = roman L/C  6 = roman U/C
         mov     pf.dxOffset, 300
         mov     pf.wNumberingStart, 1  ; Start number doesn't work
         mov     pf.wNumberingStyle, 200  ;100h = (1)  200h = 1.  300 = 1  8000h = Roman numerals Period doesn't work
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         mov     pf.dwMask, 0
         jmp     return0

idmparclear:
         mov     pf.dwMask, PFM_NUMBERING or PFM_OFFSET
         mov     pf.wNumbering, 0
         mov     pf.dxOffset, 0
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         mov     pf.dwMask, 0
         jmp     return0

idmleft:
         mov     pf.dwMask, PFM_ALIGNMENT
         mov     pf.wAlignment, PFA_LEFT
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
        call     EnableDisableToolbar
         jmp     return0

idmcenter:
         mov     pf.dwMask, PFM_ALIGNMENT
         mov     pf.wAlignment, PFA_CENTER
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
        call     EnableDisableToolbar
         jmp     return0

idmright:
         mov     pf.dwMask, PFM_ALIGNMENT
         mov     pf.wAlignment, PFA_RIGHT
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
        call     EnableDisableToolbar
         jmp     return0

idmmargin:
         mov     eax, offset MarIndDlg
         mov     ebx, IDD_MARGIN
         jmp     CreateDlg
idmindr:
         add     iL, 341
         mov     pf.dwMask, PFM_STARTINDENT or PFM_RIGHTINDENT ;PFM_OFFSETINDENT
       MOVmd     pf.dxStartIndent, iL
       MOVmd     pf.dxRightIndent, iR
         INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         jmp     return0
idmindl:
      .if iL >= 341
            sub     iL, 341
      .endif
         mov     pf.dwMask, PFM_STARTINDENT or PFM_RIGHTINDENT ;PFM_OFFSETINDENT
       MOVmd     pf.dxStartIndent, iL
       MOVmd     pf.dxRightIndent, iR
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         jmp     return0

idmview:
         mov     eax, offset ViewDlg
         mov     ebx, IDD_VIEW
         jmp     CreateDlg

idmsupersub:
         mov     eax, offset SuperSubDlg
         mov     ebx, IDD_SUPERSUB
         jmp     CreateDlg

idmsuperscript:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     charF.dwMask, CFM_OFFSET or CFM_SIZE
       MOVmd     charF.yOffset, PointU ;120 ;50
         fld     SizeU
        fstp     RNum10 
         jmp     SuperSub
idmsubscript:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     charF.dwMask, CFM_OFFSET or CFM_SIZE
       MOVmd     charF.yOffset, PointD ;-80 ;-70
         fld     SizeD
        fstp     RNum10 
         jmp     SuperSub
SuperSub:
        Push     PointSize
       finit
        fild     PointSize
         fld     RNum10
        fmul     ST(0), ST(1)
       fistp     charF.yHeight
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
         pop     charF.yHeight
        call     EnableDisableToolbar
         jmp     return0

idmnorscript:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     charF.dwMask, CFM_OFFSET
         mov     charF.yOffset, 0
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
        call     EnableDisableToolbar
         jmp     return0

idmmax:
         and     MaxWin, 0 
      INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_CHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWMAXIMIZED
            mov     MaxWin, 1
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_UNCHECKED
         INVOKE     ShowWindow, hWnd, SW_RESTORE
      .endif
         jmp     return0

idmwwrap:
        call     WordWrap
         jmp     return0

idmrtfon:
      INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_UNCHECKED
             or     RTF, 1
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_UNCHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_CHECKED
      .endif
          or     OA, 1
        call     OpenFileA 
         jmp     return0

idmrtfoff:
      INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_UNCHECKED
            and     RTF, 0      
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_UNCHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
      .endif
          or     OA, 1
        call     OpenFileA 
         jmp     return0

idmsettabs:
        call     TabStop
         jmp     return0

idmconv:
         mov     eax, offset ConvTabs
         mov     ebx, IDD_CONVERT
         jmp     CreateDlg

idmhtml:
        call     HTML
         jmp     return0

idmsetup:
         mov     w7, 0
         mov     eax, offset Setup
         mov     ebx, IDD_SETUP
         jmp     CreateDlg

idmbooks:
      INVOKE     SendMessage, hREdit, EM_GETSEL, offset HBook, 0
         jmp     return0
idmbookr:
      INVOKE     SendMessage, hREdit, EM_SETSEL, HBook, HBook
         jmp     return0

idmprthead:
         mov     sw2, 6
         mov     eax, offset CommonDlg
         mov     ebx, IDD_PRTHEAD
         jmp     DialogBox

idmewedit:
      INVOKE     lstrcpy, offset Misc, offset RootDir
      INVOKE     lstrcat, offset Misc, offset szWordEdit
      INVOKE     WinExec, offset Misc, SW_SHOWNORMAL     ; Exec a program
         jmp     return0

idmascii:
        push     0
        push     offset AsciiDlg
        push     hwnd
        push     IDD_ASCII
        push     hInst
        call     CreateDialogParam
         mov     hAscii, eax
      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, ADDR EditPT, 0,
                 WS_CHILD or WS_VISIBLE or ES_CENTER, 39, 32, 22, 20, hAscii, IDM_ASCII, hInst, 0
         mov     hAsciibox, eax
      INVOKE     SetFocus, eax
      INVOKE     SetWindowLong, hAsciibox, GWL_WNDPROC, AsciiProc
         mov     lpAsciibox, eax
         jmp     return0

idmcalctb:
      .if lparam == 0
         INVOKE     lstrcpy, ADDR szWork, ADDR RootDir
         INVOKE     lstrcat, ADDR szWork, ADDR szCallDLL
         INVOKE     GetStartupInfo, ADDR stin
         INVOKE     CreateProcess, ADDR szWork, 0, 0, 0, FALSE,\
                    NORMAL_PRIORITY_CLASS, 0, 0 , ADDR stin, ADDR prin
      .endif
      INVOKE     GetExitCodeProcess, prin.hProcess, ADDR ExitCode
         jmp     return0

DialogBox:                          ; Modal dialog box
      INVOKE     DialogBoxParam, hInst, ebx, hwnd, eax, 0
         jmp     return0

CreateDlg:                          ; Modeless dialog box 
      INVOKE     CreateDialogParam, hInst, ebx, hwnd, eax, 0
         jmp     return0

idmhelp:
      INVOKE     lstrcpy, offset szWork, offset RootDir
      INVOKE     lstrcat, offset szWork, offset szHelp
      INVOKE     WinHelp, hwnd, offset szWork, HELP_CONTENTS, 0  ;HELP_FINDER, 0
         jmp     return0
idmabout:
         mov     eax, offset AbVerDlg
         mov     ebx, IDD_ABOUT
         jmp     DialogBox
idmversion:
         mov     eax, offset AbVerDlg
         mov     ebx, IDD_VERSION
         jmp     DialogBox

wminitmenupopup:
         mov     eax, lparam
         cmp     eax, 0           ; Index 0 = file menu
          je     FileMenu
         cmp     eax, 1           ; Index 1 = edit menu
          je     EditMenu
         cmp     eax, 2           ; Index 2 = format menu
          je     FormatMenu
         jmp     return0
FileMenu:
         jmp     return0

EditMenu:
      INVOKE     EnableDisableEditMenu, wparam
        call     EnableDisableToolbar
         jmp     return0
FormatMenu:
      INVOKE     UpdateFormatMenuItems, hwnd
         jmp     return0

wmsetfocus:
        test     hREdit, -1
          jz     focus1
      INVOKE     SetFocus, hREdit
         jmp     return0
focus1: INVOKE    SetFocus, hwnd
         jmp     return0

wmnotify:
         mov     ebx, lparam    ; Get pointer to NMHDR
         mov     eax, (NMHDR ptr [ebx]).code
         cmp     eax, TTN_NEEDTEXT
          je     ttnneedtext
         cmp     eax, TBN_QUERYDELETE
          je     tbnquerydelete
         cmp     eax, TBN_GETBUTTONINFO
          je     tbngetbuttoninfo
         cmp     eax, TBN_QUERYINSERT
          je     tbnqueryinsert
         cmp     eax, TBN_TOOLBARCHANGE
          je     tbntoolbarchange
         cmp     eax, EN_MSGFILTER
          je     enmsgfilter
         cmp     eax, EN_SELCHANGE
          je     enselchange
         cmp     eax, EN_DROPFILES
          je     endropfiles
;cmp     eax, EN_REQUESTRESIZE
;je      enrequestresize
         jmp     defwndproc

endropfiles:
         mov     ebx, lparam    ; Address of ENDROPFILES structure
      INVOKE     DragQueryFile, (ENDROPFILES ptr [ebx]).hDrop, 0, offset PathName, lengthof PathName
         cmp     eax, 0         ; Chars from DragQueryFile <= 0
         jle     return0        ; Return 0 to ignore the drop
      INVOKE     PostMessage, hwnd, WM_OPENCOMMANDARGS, 0, 0 ;open droped file
         jmp     return1        ; Return 1 to accept the drop

enmsgfilter:
         mov     ebx, lparam    ; Get pointer to msgfilter
         mov     eax, (MSGFILTER ptr [ebx]).msg
         cmp     eax, WM_MOUSEMOVE
          je     return0        ; Dont want these
enselchange:
      INVOKE     PostMessage, hwnd, WM_TRACKCURSOR, 0, 0
         jmp     return0

tbnquerydelete:
         jmp     return1

tbngetbuttoninfo:
         jmp     return0

tbnqueryinsert:
         jmp     return1

tbncusthelp:
         jmp     defwndproc

tbntoolbarchange:
;Tell the toolbar to size itself
      INVOKE     SendMessage, hWndTool, TB_AUTOSIZE, 0, 0
         jmp     defwndproc

ttnneedtext:
         mov     eax, (NMHDR ptr [ebx]).idFrom ; Resource id
;Load the tip from STRINGTABLE
      INVOKE     LoadString, hInst, eax, offset szBuff, lengthof szBuff
         mov     ebx, lparam    ; Buffer addr
         mov     (TOOLTIPTEXT ptr [ebx]).lpszText, offset szBuff
         jmp     return0

wmcreate:
         mov     osv.dwOSVersionInfoSize, sizeof OSVERSIONINFO
      INVOKE     GetVersionEx, addr osv
         mov     eax, osv.dwBuildNumber ;dwPlatformId
         and     eax, 0000ffffh  ; Low = BN, High = Major & Minor 
         mov     osvBN, eax
                 ; 950  = Win95
                 ; 1111 = Win95 OSR2
                 ; 1998 = Win98
                 ; 1381 = WinNT v4
                 ; 2195 = Win2K

        call     Initialize      ; loads the registry

;=============================
; Create the status bar window
;=============================
         mov     hWndStat, 0     ; Zero handle
      INVOKE     CreateWindowEx, 0, offset statcls, offset szNULL, WS_CHILD or WS_BORDER or WS_VISIBLE or SBS_SIZEGRIP,\
                 0, 0, 0, 0, hwnd, ID_STATUSBAR, hInst, 0  
         cmp     eax, 0          ;handle null?
         jne     creatok         ;yes continue
         MsgBox  ERROR_CREATE_STATUSBAR
         jmp     wmcrexit
creatok:
         mov     hWndStat, eax   ;save the handle to statusbar
;===================
; Create the toolbar
;===================
      INVOKE     CreateToolbarEx, hwnd, WS_CHILD or WS_BORDER or WS_VISIBLE or\
                 TBSTYLE_TOOLTIPS or CCS_ADJUSTABLE or TBSTYLE_FLAT,\
                 ID_TOOLBAR, 21, hInst, IDB_TOOLBAR, offset tb, 28, 16, 15, 16, 15, tbl
         cmp     eax, 0          ; handle null?
         jne     tbok            ; yes continue
         MsgBox  ERROR_CREATE_TOOLBAR
         jmp     wmcrexit
tbok:
         mov     hWndTool, eax   ; save the handle to toolbar
        call     EnableDisableToolbar

;------------------------ Combo Boxes] ------------------------
      INVOKE     CreateWindowEx, 0, addr ToolClass, 0,
                 WS_CHILD or WS_VISIBLE or CCS_NOPARENTALIGN or\
                 CCS_NORESIZE,
                 0,24,1200,28,hwnd,80,hInst,NULL
         mov     hMiscTool, eax

      INVOKE     CreateWindowEx, 0, offset combobox, 0,
                 WS_VSCROLL or WS_VISIBLE or WS_CHILD or CBS_HASSTRINGS or\
                 CBS_DROPDOWN or CBS_SORT,
                 3,3,150,210, hMiscTool, 81, hInst, 0
         mov     hCFont, eax

      INVOKE     CreateWindowEx, 0, offset combobox, 0,
                 WS_VSCROLL or WS_VISIBLE or WS_CHILD or CBS_HASSTRINGS or\
                 CBS_DROPDOWN,
                 155,3,40,210, hMiscTool, 82, hInst, 0
         mov     hCSize, eax

      INVOKE     CreateWindowEx, 0, offset combobox, 0,
                 WS_VSCROLL or WS_VISIBLE or WS_CHILD or CBS_HASSTRINGS or\
                 CBS_DROPDOWN or CBS_OWNERDRAWFIXED,
                 197,3,72,210, hMiscTool, 83, hInst, 0 ;60
         mov     hCColor, eax

      INVOKE     lstrcpy, addr lf.lfFaceName, addr FontMS
         mov     lf.lfHeight, 7 ;-11
         mov     lf.lfWeight, 500
      INVOKE     CreateFontIndirect, ADDR lf
         mov     cFont, eax

;------------ [Set the fonts and size the ComboBoxes] ------------ 
      INVOKE     SendMessage, hCFont, WM_SETFONT, cFont, 1
      INVOKE     SendMessage, hCSize, WM_SETFONT, cFont, 1
      INVOKE     SendMessage, hCColor, WM_SETFONT, cFont, 1
      INVOKE     SendMessage, hCFont, CB_SETITEMHEIGHT, -1, 14
      INVOKE     SendMessage, hCFont, CB_SETITEMHEIGHT, 0, 13
      INVOKE     SendMessage, hCSize, CB_SETITEMHEIGHT, -1, 14
      INVOKE     SendMessage, hCSize, CB_SETITEMHEIGHT, 0, 13
      INVOKE     SendMessage, hCColor, CB_SETITEMHEIGHT, -1, 14
      INVOKE     SendMessage, hCColor, CB_SETITEMHEIGHT, 0, 13

;------------ [Open the font registry and get the number of fonts] ------------ 
      .if osvBN != 1381  ; Not NT
         INVOKE     RegOpenKeyEx, HKEY_LOCAL_MACHINE, offset szFonts, 0, KEY_QUERY_VALUE, addr hKey
      .else
         INVOKE     RegOpenKeyEx, HKEY_LOCAL_MACHINE, offset szFontsNT, 0, KEY_QUERY_VALUE, addr hKey
      .endif
      INVOKE     RegQueryInfoKey, hKey,0,0,0,0,0,0, addr lpcValues, 0,0,0,0
         mov     w3, 0

;------------ [Extract fonts from the registry and write to the ComboBox] ------------ 
Fon:
      .while lpcValues           ; lpcValues = num of fonts in the registry
         sub     lpcValues, 1
         mov     lpcbValueName, 50
      INVOKE     RegEnumValue, hKey, w3, addr szBuff, addr lpcbValueName, 0, addr szREGSZ, 0, 0
         add     w3, 1
         mov     eax, lpcbValueName
         sub     eax, 10
      .if szBuff[eax+1] != 'T'   ; Exclude non true type fonts
            jmp     Fon
      .endif
      INVOKE     lstrcpyn, addr szBuff, addr szBuff, eax
      INVOKE     lstrcpy, addr szWork, addr szBuff
      INVOKE     SendMessage, hCFont, CB_ADDSTRING, 0, addr szBuff
      .endw

;------------ [Create a memory block to write the sorted fonts to] ------------ 
      INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, 100000, 0
         mov     hpMem, eax
      INVOKE     HeapAlloc, hpMem, HEAP_GENERATE_EXCEPTIONS, 100000
         mov     fpMem, eax
         mov     w5, eax
         mov     cnt, 0
      INVOKE     SendMessage, hCFont, CB_GETCOUNT, 0, 0
         mov     w6, eax

      .while w6 > 0              ; w6 = num of fonts in the combobox
      INVOKE     SendMessage, hCFont, CB_GETLBTEXT, cnt, addr szBuff
         sub     w6, 1
         add     cnt, 1
         mov     eax, w5
      .if eax == fpMem
         INVOKE     lstrcpy, fpMem, addr szBuff
      .else
         INVOKE     lstrcat, fpMem, addr szBuff
      .endif
         INVOKE     lstrcat, fpMem, addr szColon
         mov     w5, 0
      .endw
      INVOKE     lstrcat, fpMem, addr szFons   ; Add non true type fonts
         add     cnt, 11 ;10                       ; Additional fonts num
      INVOKE     SendMessage, hCFont, CB_RESETCONTENT, 0, 0
         mov     esi, fpMem
         xor     eax, eax

;------------ [Write the sorted fonts from memory back to the ComboBox deleting dupes] ------------ 
Getlen:
      .if byte ptr[esi+eax] == 3bh
            mov     Len, eax
            add     Len, 1 
            sub     cnt, 1       ; cnt = num of fonts in memory
         INVOKE     lstrcpyn, addr szBuff, esi, Len
         INVOKE     CompareString, LOCALE_USER_DEFAULT, NORM_IGNORECASE, addr szBuff, 11, addr szWork, 11
            cmp     eax, 2
             je     Dupe
         INVOKE     lstrcpy, addr szWork, addr szBuff
         INVOKE     SendMessage, hCFont, CB_ADDSTRING, 0, addr szBuff
Dupe:
            add     esi, Len
            xor     eax, eax
            jmp     Getlen
      .elseif cnt == 0
            jmp     GetOut
      .endif
         inc     eax
         jmp     Getlen

GetOut:
      INVOKE     HeapDestroy, hpMem

      INVOKE     LoadList, hCSize, offset szSize, 4444
      INVOKE     LoadList, hCColor, offset szColor, 4444

        call     GetInfoForCombos

      INVOKE     CreateWindowEx, NULL, addr Butt, addr szSel,
                 WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,
                 271,1,70,12, hMiscTool, 84, hInst, 0 ;259
         mov     hSel, eax
      INVOKE     SendMessage, eax, WM_SETFONT, cFont, 1

      INVOKE     CreateWindowEx, NULL, addr Butt, addr szAll,
                 WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,
                 271,13,40,12, hMiscTool, 85, hInst, 0 ;259
         mov     hAll, eax
      INVOKE     SendMessage, eax, WM_SETFONT, cFont, 1
      .if UpdateSel == 1
         INVOKE     SendMessage, hSel, BM_SETCHECK, BST_CHECKED, 0   ; Sets UpdateSel to checked
      .endif
      .if UpdateAll == 1
         INVOKE     SendMessage, hAll, BM_SETCHECK, BST_CHECKED, 0   ; Sets UpdateAll to checked
      .endif

;================================
; Create the find/replace toolbar
;================================
      INVOKE     CreateWindowEx, 0, addr ToolClass, 0,
                 WS_CHILD or WS_VISIBLE or TBSTYLE_TOOLTIPS or CCS_NOPARENTALIGN or CCS_NORESIZE or\
                 TBSTYLE_FLAT,
                 342,-2,110,24, hMiscTool, 2088, hInst, NULL ;330
         mov     hWndToolF, eax

       MOVmd     tbab.hInst, hInst
         mov     tbab.nID, IDB_TOOLBARF
      INVOKE     SendMessage, hWndToolF, TB_BUTTONSTRUCTSIZE, tbf2, 0
      INVOKE     SendMessage, hWndToolF, TB_ADDBITMAP, 4, addr tbab
      INVOKE     SendMessage, hWndToolF, TB_ADDBUTTONS, 6, addr tbf
        call     EnableDisableToolbar

;=========================================
; Create a RULER and RULER handle windows
;=========================================
      INVOKE     CreateWindowEx, 0, addr ToolClass, 0,
                 WS_CHILD or WS_VISIBLE or CCS_NOPARENTALIGN or\
                 CCS_NORESIZE,
                 0,52,1200,15,hwnd,55,hInst,NULL
         mov     hRule, eax
;      .if osvBN > 1111
         INVOKE     SetWindowLong, hRule, GWL_WNDPROC, RulePosProc
            mov     lpRulerPos, eax
;      .endif 

;DSPValue hWnd, SavPosL
;DSPValue hWnd, SavPosR
      INVOKE     CreateWindowEx,0, ADDR Stat,0,
                 WS_CHILD or WS_VISIBLE or WS_BORDER or SS_GRAYRECT or WS_DLGFRAME,
                 SavPosL,0,6,11,hRule,56,hInst,NULL ;SavPosL,57,6,11
         mov     hHandL, eax

      INVOKE     CreateWindowEx,0, ADDR Stat,0,
                 WS_CHILD or WS_VISIBLE or WS_BORDER or SS_GRAYRECT or WS_DLGFRAME,
                 SavPosR,0,6,11,hRule,57,hInst,NULL
         mov     hHandR, eax

;======================
; Create an EDIT window
;======================

         mov     w4, WS_CHILD or WS_VISIBLE or ES_LEFT or ES_MULTILINE or ES_NOHIDESEL or\
                 ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or ES_AUTOVSCROLL or WS_TABSTOP ;or WS_CLIPCHILDREN or WS_CLIPSIBLINGS
      .if !WWrap
            or      w4, WS_HSCROLL or ES_AUTOHSCROLL
      .endif
      INVOKE     CreateWin, WS_EX_CLIENTEDGE, ADDR richedit, w4,
                 0, 0, 0, 0, hwnd, ID_EDITWINDOW

;============================================
; Tell edit window what notifications to send
;============================================
      INVOKE     SendMessage, hREdit, EM_SETEVENTMASK, 0, ENM_CHANGE or ENM_SELCHANGE or ENM_MOUSEEVENTS or ENM_KEYEVENTS or ENM_DROPFILES
;=================================
; Tell edit window to accept drops
;=================================
      INVOKE     DragAcceptFiles, hREdit, TRUE

;=======================================================================
; Determine state of initial document; new or open file specified as arg
;=======================================================================
        test     PathName, 0ffh
          jz     wmcrnew
      INVOKE     PostMessage, hwnd, WM_OPENCOMMANDARGS, 0, 0 ; From file type association or cmd
         jmp     wmcrargs

wmcrnew:
      INVOKE     PostMessage, hwnd, WM_COMMAND, IDM_NEW, 0   ; WHEN COMMENTED OUT DISABLES UNDO  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

wmcrargs:
;=====================
; Finally, setup timer
;=====================
      INVOKE     SetTimer, hwnd, ID_TIMER1, 100, 0 ; Timer every second
;==============
; Initalization
;==============
         mov     ofn.lStructSize, sizeof ofn
         mov     eax, hWnd
         mov     ofn.hwndOwner, eax
         mov     eax, hInst
         mov     ofn.hInstance, eax
         mov     charF.cbSize, sizeof charF
         mov     eax, lf.lfWeight
         mov     charF.wWeight, ax
         mov     pf.cbSize, sizeof pf
         mov     pf.dySpaceAfter, 0
         mov     pf.dyLineSpacing, 0
      INVOKE     GetSubMenu, hMenu, 0       ; Get handle to 1st sub menu
      INVOKE     GetMenuItemCount, eax      ; Get count of items in the sub menu
         mov     MenuCnt, eax               ; Menu count for ProcessMRUFiles 
      .if SaveWhen
         INVOKE     CheckMenuItem, hMenu, IDM_SAVESETTINGS, MF_CHECKED
      .endif
      .if WWrap
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_CHECKED
      .endif
        call     SetCharFormatting
      INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
      INVOKE     lstrcpy, offset LIndO, offset Ind
      INVOKE     lstrcpy, offset RIndO, offset Ind
      INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
      INVOKE     ProcessMRUFiles, hwnd, 1, MenuCnt, 0, addr szRedit
          or     RTF, 1

wmcrexit:
         jmp     return0

wmtimer:
         cmp     wparam, ID_TIMER1 ; Is it our timer?
         jne     wmtimex           ; No, then exit
        call     fmtime            ; Format and display the time
wmtimex:
         jmp     return0

wmsize:
         cmp     hWndStat, 0     ; Is status valid?
          jz     wmsizex         ; No, then exit
         mov     eax, lparam     ; Height/width of new window
         mov     ebx, eax
         and     ebx, 0000ffffh  ; ebx = LOWORD(lparam) = width
;mov     w3, ebx
;DSPValue hWnd, w3, 1, 'm'        ; = 233
         shr     eax, 16         ; eax = HIWORD(lparam) = height
        push     TRUE            ; Repaint is true
        push     eax             ; Height
        push     ebx             ; Width
        push     eax             ; y
        push     0               ; x
        push     hWndStat        ; Handle to statusbar
        call     MoveWindow      ; Adjust window
         mov     eax, lparam     ; Get width
        cwde                     ; Lowword
         shr     eax, 2          ; /4
         mov     ecx, eax        ; Save factor
         mov     parts, eax      ; Mmake part 1 1/4 the width
         add     eax, ecx
         mov     [parts+4], eax  ; and also part2, .. etc
         add     eax, ecx
         mov     [parts+8], eax
         mov     [parts+12], -1  ; The last part extends to the end

      INVOKE     SendMessage, hWndStat, SB_SETPARTS, SBPARTS, offset parts
         cmp     hWndTool, 0     ; Is there a valid toolbar?
          jz     wmsizex         ; No, then exit
      INVOKE     SendMessage, hWndTool, TB_AUTOSIZE, 0, 0
      INVOKE     SendMessage, hMiscTool, TB_AUTOSIZE, 0, 0
      INVOKE     SendMessage, hToolBarH, TB_AUTOSIZE, 0, 0

;==============================
; Move and size the EDIT window
;==============================
      INVOKE     GetWindowRect, hWndTool, offset rect ;rectangle of toolbar
         mov     eax, rect.bottom
         sub     eax, rect.top
        push     eax             ; Save height of toolbar
      INVOKE     GetWindowRect, hWndStat, offset rect ;rectangle of statusbar
         mov     eax, rect.bottom
         sub     eax, rect.top   ; eax = height of statusbar
         pop     edx             ; edx = height of toolbar
         mov     ebx, lparam     ; Width of new client area
         and     ebx, 0ffffh     ; ebx = width
         mov     ecx, lparam
         shr     ecx, 16         ; Height of new client area
         sub     ecx, eax        ; Edit window - size of statusbar
         add     edx, 38
         sub     ecx, edx        ; and - size of toolbar
      INVOKE     MoveWindow, hREdit, 0, edx, ebx, ecx, TRUE

      INVOKE     GetClientRect, hREdit, offset rect
         mov     rect.left, 15
         mov     rect.top, 4
         sub     rect.bottom, 4
       MOVmd     savL, rect.left
       MOVmd     savT, rect.top
       MOVmd     savB, rect.bottom

      INVOKE     SendMessage, hREdit, EM_SETRECT, 0, offset rect
      INVOKE     SendMessage, hREdit, EM_GETRECT, 0, offset rect
       MOVmd     savR, rect.right
         sub     savR, 4

      .if FirstTime
            sub     rect.left, 1
          MOVmd     SavPosL, rect.left
          MOVmd     SavPosR, rect.right
            and     FirstTime, 0
      .else
          MOVmd     rect.left, SavPosL
         .if PL == 0 && !mR
             MOVmd     SavPosR, rect.right
         .elseif PL == 1
               mov     eax, SavPosR
            .if eax > rect.right
                MOVmd     SavPosR, rect.right
            .else
                  mov     ebx, 764
               .if ebx < rect.right && !savMR
                     mov     SavPosR, 764
               .endif
            .endif

         .elseif PL == 2
               mov     eax, SavPosR
            .if eax > rect.right
                MOVmd     SavPosR, rect.right
            .else
                  mov     ebx, 991
               .if ebx < rect.right && !savMR
                     mov     SavPosR, 991
               .endif
            .endif
         .endif
          MOVmd     rect.right, SavPosR
            add     rect.left, 4
            mov     rect.top, 4
;            sub     rect.bottom, 4
         INVOKE     SendMessage, hREdit, EM_SETRECT, 0, offset rect
            sub     rect.left, 5;4
         .if PL || !savML
               add     rect.left, 4
         .endif
      .endif
;DSPValue hWnd, rect.left, 1, 't'
;DSPValue hWnd, rect.bottom, 1, 'm'
         call     BuildRuler

      .if MultInst == 1
         INVOKE     ShowWindow, hWnd, SW_RESTORE
      .endif

wmsizex:
         jmp     return0

;---------- [Disply a menu string on the status bar] ----------
wmmenuselect:
         mov     eax, wparam
         and     eax, 0ffff0000h
         cmp     eax, 0ffff0000h  ; Special case, menu canceled
         jne     wmms1
         mov     eax, lparam
         cmp     eax, 0
         jne     wmms1
      INVOKE     lstrcpy, addr szBuff, addr fsmsg  ;Display bytes read when exiting from menu
         jmp     wmms2
wmms1:   mov     eax, wparam
        cwde
         add     eax, 10000       ; Resource base #
      INVOKE     LoadString, hInst, eax, offset szBuff, lengthof szBuff
         cmp     eax, 0
         jne     wmms2
        push     offset fsmsg
         jmp     wmms3
wmms2:  push     offset szBuff
wmms3:  push     SBPART_MESSAGE1
        push     SB_SETTEXT
        push     hWndStat
        call     SendMessage
         jmp     return0

wmtrackcursor:
        call     EnableDisableToolbar
         jmp     return0

wmclose:
      INVOKE     CheckSav, hwnd
         cmp     eax, IDCANCEL
          je     return0
      INVOKE     DestroyWindow, hwnd
         jmp     return0

wmqueryendsession:
      INVOKE    CheckSav, hwnd
         cmp    eax, IDCANCEL
          je    return0
         jmp    return1

defwndproc:
      INVOKE     DefWindowProc, hwnd, wmsg, wparam, lparam
         jmp     finish

wmdestroy:
      INVOKE     KillTimer, hwnd, ID_TIMER1
      INVOKE     WinHelp, hwnd, offset szHelp, HELP_QUIT, 0
      .if !SaveWhen
         INVOKE     RegSet, offset szSaveWhen, SaveWhen
            jmp     ShutDown
      .endif
        call     RegSave

ShutDown:
      INVOKE     PostQuitMessage, 0
         jmp     return0

return1: mov     eax, 1
         jmp     finish
return0: xor     eax, eax
finish:  ret
WndProc  ENDP

;========================================================================|
;*  CREATE WINDOW PROCEDURE                                              *
;========================================================================|
CreateWin PROC   StyleEX:DWORD,classN:DWORD,Style:DWORD,x:DWORD,y:DWORD,wd:DWORD,ht:DWORD,hwnd:DWORD,ID:DWORD
       ;INVOKE     CreateWindowEx, 0, classN, 0, Style, x, y, wd, ht, hwnd, ID, hInst, 0
       INVOKE     CreateWindowEx, StyleEX, classN, 0, Style, x, y, wd, ht, hwnd, ID, hInst, 0
         cmp     eax, 0          ; Create go ok?
         jne     winok           ; yes continue
         MsgBox  ERROR_CREATE_EDITWINDOW
         jmp     CreateRet
winok:
         mov     hREdit, eax
      INVOKE     SetWindowLong, hREdit, GWL_WNDPROC, RichEditProc
         mov     lpRichEdit, eax
      INVOKE     SendMessage, hREdit, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
      INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 2000000
      INVOKE     lstrcpy, ADDR lf.lfFaceName, ADDR FontName
         mov     lf.lfHeight, 40
         mov     lf.lfWeight, 600
      INVOKE     CreateFontIndirect, ADDR lf
         mov     pFont,eax
         mov     lf.lfHeight, -12
         mov     lf.lfWeight, 500
      INVOKE     CreateFontIndirect, ADDR lf
         mov     hFont, eax
INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1
CreateRet:
         ret
CreateWin ENDP

;================================================================|
;  Center a child window within a parent    eax = child handle   |
;================================================================|
CenterChild PROC  uses ebx edx
LOCAL    hWndChild:DWORD, hWndParent:DWORD

         mov     hWndChild, eax   ; Save child handle
      INVOKE     GetParent, eax   ; Get parents handle
       MOVmd     hWndParent, hREdit
      INVOKE     GetWindowRect, hWndParent, offset rect
         mov     eax, rect.bottom
         sub     eax, rect.top    ; Parent height
         shr     eax, 1           ; Divide parent height by 2
         mov     YP, eax          ; Save half parent height
         mov     eax, rect.right
         sub     eax, rect.left   ; Parent width
         shr     eax, 1           ; Divide parent width by 2
         mov     XP, eax          ; Save half parent width
      INVOKE     GetWindowRect, hWndChild, offset rect
      INVOKE     ClientToScreen, hWndParent, offset XP
         mov     ebx, rect.right
         sub     ebx, rect.left
         mov     ecx, ebx         ; Child width 
         shr     ebx, 1           ; Divide child width by 2
         sub     XP, ebx          ; Sub half child width from half parent width = new x position

         mov     ebx, rect.bottom
         sub     ebx, rect.top
         mov     edx, ebx         ; Child height
         shr     ebx, 1           ; Divide child height by 2
;sub     YP, 12
         sub     YP, ebx          ; Sub half child height from half parent height = new y position

      INVOKE     MoveWindow, hWndChild, XP, YP, ecx, edx, TRUE
         ret
CenterChild ENDP

;========================================================================|
;*  INITIALIZATION PROCEDURE                                             *
;========================================================================|
Initialize PROC
LOCAL    hRegK:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegK, offset lpdwDisp
         mov     lpcbData, 4
         mov     eax, offset szSetFlags
         lea     ebx, SetFlags
      INVOKE     RegQueryValueEx, hRegK, eax, 0, offset lpType, ebx, offset lpcbData
         cmp     eax, 0
          je     NotFirst
      INVOKE     lstrlen, offset FontName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegK, offset szFont, 0, REG_SZ, offset FontName, lpcbData
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName

      INVOKE     RegSet, offset szSaveWhen, SaveWhen
      INVOKE     RegSet, offset szSetFlags, SetFlags
      INVOKE     RegSet, offset szWordWrap, WWrap

NotFirst:
         mov     lpcbData, 50
      INVOKE     RegQueryValueEx, hRegK, offset szFont, 0, offset lpType, offset FontName, offset lpcbData
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
      INVOKE     RegQuery, offset szSaveWhen, SaveWhen
         mov     SaveWhen, eax
      INVOKE     RegQuery, offset szSetFlags, SetFlags
         mov     SetFlags, eax
      INVOKE     RegQuery, offset szWordWrap, WWrap
         mov     WWrap, eax

         mov     ecx, 16
         lea     eax, offset rTS1
         mov     w5, eax
         lea     eax, TS1
         mov     w6, eax
      .while (ecx)
            mov     lpcbData, 4
           push     ecx
         INVOKE     RegQueryValueEx, hRegK, w5, 0, offset lpType, w6, offset lpcbData
            pop     ecx
            add     w5, 14
            add     w6, 4
            dec     ecx
      .endw

      INVOKE     RegQuery, offset rTC, TextC
         mov     TextC, eax
      INVOKE     RegQuery, offset rTBGC, TextBGC
         mov     TextBGC, eax
      INVOKE     RegQuery, offset rBC, BackGC
         mov     BackGC, eax
      INVOKE     RegQuery, offset szPoint, PointSize
         mov     PointSize, eax

         mov     lpcbData, 150
      INVOKE     RegQueryValueEx, hRegK, offset szHWSName, 0, offset lpType, offset szHWS, offset lpcbData
      INVOKE     RegQueryValueEx, hRegK, offset szAthName, 0, offset lpType, offset szAth, offset lpcbData

      INVOKE     RegCloseKey, hRegK

call     TabStop
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
           ret
Initialize ENDP

;========================================================================|
;*  SETUP DIALOG PROCEDURE                                               *
;=========================================================================
Setup PROC  uses ebx edi  hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
LOCAL    savedi:DWORD, savesi:DWORD

       MOVmd     hSUDlg, hdlg
         cmp     wmsg, WM_COMMAND   ; Is message a WM_COMMAND?
         jne     ThatsAll           ; No, then just return
      .if NH == 0
         INVOKE     GetDlgItem, hdlg, rb21                        ;Get print heading yes check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ;Sets print heading yes to checked
      .else
         INVOKE     GetDlgItem, hdlg, rb22                        ;Get print heading no check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ;Sets print heading no to checked
      .endif
         mov     eax, wparam
         and     eax, 0000ffffh
      .if eax == IDHELP
         INVOKE     lstrcpy, offset szWork, offset RootDir
         INVOKE     lstrcat, offset szWork, offset szHelp
         INVOKE     WinHelp, hWnd, addr szWork, HELP_KEY, addr szSetup
      .endif 
      .if eax == 1500 && w7 == 0        ; Tabs & F1-F4 keys
            mov     edi, tb1
            xor     esi, esi
            mov     ecx, 14
TabS:       mov     secx, ecx 
         INVOKE     SetDlgItemInt, hdlg, edi, TS1[esi], 0
            mov     ecx, secx
            inc     edi
            add     esi, 4
         loopnz     TabS

            mov     eax, 1599
            add     eax, SPACE
         INVOKE     GetDlgItem, hdlg, eax
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ;Sets SHIFT spaces
         INVOKE     SetDlgItemInt, hdlg, SH, SHIFT, 0
             or     w7, 1
         MOVmd      sSPACE, SPACE
      .elseif eax > 1599 && eax < 1620  ; Spaces
            mov     sSPACE, eax
            sub     sSPACE, 1599
      .endif
         mov     eax, wparam
         cmp     eax, REPLACE          
          je     Update
         mov     eax, wparam
         cmp     eax, rb21
          je     B21
         cmp     eax, rb22
          je     B22
         cmp     eax, IDCANCEL
          je     Destroy
         jmp     ThatsAll
B21:
         and     NH, 0
      INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0    ;Sets print heading yes to checked
      INVOKE     GetDlgItem, hdlg, rb22                           ;Get handle print heading no check
      INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0  ;Sets print heading no to unchecked
         jmp     ThatsAll
B22:
          or     NH, 1
      INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0    ; Sets print heading no to checked
      INVOKE     GetDlgItem, hdlg, rb21                           ; Get handle print heading yes check
      INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0  ; Sets print heading yes to unchecked
         jmp     ThatsAll

Update:
       MOVmd     SPACE, sSPACE
      INVOKE     GetDlgItemInt, hdlg, SH, 0, 0
         mov     SHIFT, eax

         mov     edi, tb1
         xor     esi, esi
         mov     ecx, 14
TabG:   push     ecx 
      INVOKE     GetDlgItemInt, hdlg, edi, 0, 0
         pop     ecx
         mov     TS1[esi], eax
         inc     edi
         add     esi, 4
      loopnz     TabG

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0,
                 KEY_WRITE or KEY_READ, 0, offset hReg, offset lpdwDisp
         mov     ecx, 16
         lea     eax, offset rTS1
         mov     w5, eax
         lea     eax, TS1
         mov     w6, eax
      .while (ecx)
           push     ecx
         INVOKE     RegSetValueEx, hReg, w5, 0, REG_DWORD, w6, 4
            pop     ecx
            add     w5, 14
            add     w6, 4
            dec     ecx
      .endw
      INVOKE     RegCloseKey, hReg
        call     TabStop
        call     Initialize
Destroy:
      INVOKE     DestroyWindow, hdlg    ;end the dialog
         mov     eax, TRUE              ;return
         jmp     SelectRet              ;with TRUE
ThatsAll:
         mov     eax, FALSE             ;return with FALSE
SelectRet:
         ret                            ;return
Setup ENDP

;========================================================================|
;* BuildRuler Procedure                                                  *
;========================================================================|
BuildRuler PROC
LOCAL    hRuleDC:DWORD, ChkR
.if !hRule
ret
.endif
         mov     rect.top, 0 ;10
       MOVmd     rect.bottom, rect.top  
         add     rect.bottom, 12
        push     rect.left
        push     rect.right
        push     rect.top
        push     rect.bottom

      INVOKE     SendMessage, hREdit, EM_GETRECT, 0, offset rect
         pop     rect.bottom
         pop     rect.top
       MOVmd     ChkR, rect.right

       MOVmd     rect.left, savL
       MOVmd     rect.right, savR
      INVOKE     GetDC, hRule
         mov     hRuleDC, eax
      INVOKE     CreateSolidBrush, 00a0a0a0h           ; Build a solid color brush
         mov     hBrush, eax

add     rect.right, 10
      INVOKE     FillRect, hRuleDC, offset rect, eax   ; Fill the rectangle with the brush
         pop     rect.right
         pop     rect.left
         mov     eax, ChkR
      .if rect.right > eax
            mov     rect.right, eax
      .endif
         add     rect.top, 1
         mov     eax, rect.right
         sub     eax, rect.left
         mov     w2, eax

      INVOKE     LoadBitmap, hInst, IDB_RULER          ; Load the ruler bitmap
         mov     hRULER, eax                           ; Handle of the bitmat

      INVOKE     ReleaseDC, hRule, hRuleDC
      INVOKE     GetDC, hRule
         mov     hRuleDC, eax                          ; Handle of the rule DC
      INVOKE     CreateCompatibleDC, eax               ; Create a compatible dc in memory
         mov     hMemDC, eax

      INVOKE     SelectObject, hMemDC, hRULER          ; Select the ruler bitmap into the dc
      INVOKE     BitBlt, hRuleDC, 14, rect.top, 1000, 10, hMemDC, 0, 0, SRCAND ; Copy the bitmap
;DSPValue hWnd, 1111

         mov     eax, rect.left
         mov     ebx, eax
add     ebx, 2
         sub     eax, 14
      INVOKE     BitBlt, hRuleDC, ebx, rect.top, w2, 10, hMemDC, eax, 0, SRCCOPY ; Copy the bitmap ;w1
;DSPValue hWnd, 2222

         mov     eax, rect.left
         add     eax, w2
         mov     ebx, eax
         sub     ebx, 14
      INVOKE     BitBlt, hRuleDC, eax, rect.top, 1000, 10, hMemDC, ebx, 0, SRCAND ; Copy the bitmap
;DSPValue hWnd, 3333

      INVOKE     ReleaseDC, hRule, hRuleDC             ; Release the DC for hRule 
      INVOKE     DeleteDC, hMemDC                      ; Delete the memory dc
      INVOKE     DeleteObject, hBrush
      INVOKE     DeleteObject, hRULER
       MOVmd     SavPosL, rect.left
       MOVmd     SavPosR, rect.right
         sub     SavPosL, 3 ;6

      .if SavPosL < 10 || SavPosL > 7fffffffh
            mov     SavPosL, 10
            and     w4, 0
      .endif
         mov     eax, savR
      .if eax <= SavPosR
            mov     SavPosR, eax
            sub     eax, 1
         .if eax <= rect.right && w5 == 5
               and     w4, 0
         .endif
      .endif
      INVOKE     MoveWindow, hHandL, SavPosL, 0, 6, 11, TRUE
      INVOKE     MoveWindow, hHandR, SavPosR, 0, 6, 11, TRUE
      INVOKE     RedrawWindow, hHandL, 0, 0, RDW_FRAME or RDW_INVALIDATE or RDW_UPDATENOW or RDW_ALLCHILDREN
      INVOKE     RedrawWindow, hHandR, 0, 0, RDW_FRAME or RDW_INVALIDATE or RDW_UPDATENOW or RDW_ALLCHILDREN
         ret                                           ; Return to caller
BuildRuler ENDP

;========================================================================|
;* Rule Pos Procedure - RulePosProc is a Sub Class                       *
;========================================================================|
RulePosProc PROC  hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
LOCAL    Center:DWORD

      INVOKE     CallWindowProc, lpRulerPos, hwnd, wmsg, wparam, lparam

      .if wmsg == WM_PAINT
           call     BuildRuler
            ret
      .endif

      .if wmsg == WM_NCHITTEST
;         INVOKE     SetCapture, hRule    ; Capture the mouse
            and     w5, 0
      .endif
      .if RuleOn == 0
            jmp     EndIt
      .endif
      .if wmsg == WM_NCHITTEST || wmsg == WM_LBUTTONDOWN || wmsg == WM_LBUTTONUP || wmsg == WM_MOUSEMOVE
         .if wmsg == WM_MOUSEMOVE
               mov     eax, lparam
               shr     eax, 16
            .if eax > 10
                  and     w4, 0
            .endif
         .endif
         .if wmsg == WM_LBUTTONUP
               and     w4, 0
         .endif
         .if wmsg == WM_LBUTTONDOWN
               or      w4, 1
         .endif
         .if w4 == 1 && wmsg == WM_MOUSEMOVE || wmsg == WM_LBUTTONDOWN
               xor     edx, edx
               mov     eax, savR
               sub     eax, savL
               mov     ebx, 2
               div     ebx
               mov     Center, eax
               mov     eax, lparam       ; Get the x
              cwde                       ; position in loword(lparam)
               mov     ecx, eax
         .if eax < 12 || eax > 7fffffffh  ;10
               and     w4, 0
               jmp     EndIt
         .endif

               cmp     eax, Center
               ja      DoRight

            .if eax != SavPos
                  sub     eax, 2
            .else
                  jmp     EndIt
            .endif
               mov     SavPosL, eax

            .if PL == 0
                  mov     eax, savR
            .elseif PL == 1
                  mov     eax, 768 ;764
            .else
                  mov     eax, 995 ;991
            .endif
            .if SavPosR > eax
                  mov     SavPosR, eax
            .endif
               jmp     BuildEm

DoRight:
               mov     w5, 5
            .if eax != SavPos
                  sub     eax, 2
            .else
                  jmp     EndIt
            .endif
            .if SavPosL < 30 && PL > 0
                  mov     SavPosL, 30
            .endif
               mov     SavPosR, eax

               mov     eax, savR
            .if eax < SavPosR
;                  mov     SavPosR, eax
;                  jmp     EndIt
            .endif
               jmp     BuildEm
         .endif
      .endif
         jmp     EndIt

BuildEm:
sub     SavPosL, 4
         mov     SavPos, ecx
      INVOKE     DestroyWindow, hHandL
      INVOKE     CreateWindowEx,0, ADDR Stat,0,
                 WS_CHILD or WS_VISIBLE or WS_BORDER or SS_GRAYRECT or WS_DLGFRAME,
                 SavPosL,0,6,11,hRule,56,hInst,NULL  ; Left handle
         mov     hHandL, eax
add     SavPosL, 1

      INVOKE     DestroyWindow, hHandR
      INVOKE     CreateWindowEx,0, ADDR Stat,0,
                 WS_CHILD or WS_VISIBLE or WS_BORDER or SS_GRAYRECT or WS_DLGFRAME,
                 SavPosR,0,6,11,hRule,57,hInst,NULL  ; Right handle
         mov     hHandR, eax

       MOVmd     rect.left, SavPosL
       MOVmd     rect.right, SavPosR
       MOVmd     rect.top, savT
       MOVmd     rect.bottom, savB
         add     rect.left, 8
      INVOKE     SendMessage, hREdit, EM_SETRECT, 0, ADDR rect
sub     rect.left, 2
       MOVmd     mL, SavPosL
         sub     mL, 8
      .if mL > 23 && mL < 80000000h
          finit
           fild     mL
            fld     RPixTwip          ;Needs to be 15.867768595
           fmul     ST(0), ST(1)
          fistp     mL
            sub     mL, 360
      .else
            mov     mL, 0
            mov     savML, 0
      .endif

         mov     eax, 785             ; 8.5"
      .if SavPosR < 764               ; 8.25"
         sub     eax, SavPosR
         mov     mR, eax
          finit
           fild     mR
            fld     RPixTwip          ; Needs to be 15.867768595
           fmul     ST(0), ST(1)
          fistp     mR
            sub     mR, 360
      .else
            mov     mR, 0
            mov     savMR, 0
      .endif

EndIt:
;        call     ReleaseCapture       ; Release the mouse
Endit1:
         ret                          ; Return to caller
RulePosProc ENDP

;========================================================================|
;*  TAB STOP DIALOG PROCEDURE                                            *
;========================================================================|
TabStop PROC
LOCAL    N:DWORD
         mov     pf.cbSize, sizeof pf
         mov     pf.dwMask, PFM_TABSTOPS
         mov     pf.cTabCount, MAX_TAB_STOPS
      INVOKE     lstrcpy, offset pf.rgxTabs, offset TabStops
         xor     eax, eax
         xor     edx, edx
         and     N, 0
         mov     ecx, 32
TabW:    mov     eax, TS1[edx]
      .if edx > 36
            add     N, 5
            mov     eax, TS1[36]
            add     eax, N
      .endif 
         mov     TabStops[edx], eax
      .if eax > 0 
            dec     eax
      .endif
         mov     ebx, eax
        imul     ebx, 104 ;105  ;(8 = 105) (9 = 105) (10 = 120) (11 = 135) (12 = 150) twips
         mov     pf.rgxTabs[edx], ebx
         add     edx, 4
      loopnz     TabW

; This is for Help Gen, EM_SETPARAFORMAT generates a bunch of tx.... statements
; if using user defined tab stops, working on the problem!
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            ret
      .endif

      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
         ret
TabStop ENDP

;=========================================================================
;* CommonDlg Print heading and Find Line PROC                            *
;=========================================================================
CommonDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
push     ebx
         cmp     wmsg, WM_INITDIALOG   ; If message is INITDIALOG then
         jne     @1                    ; check wmsg
      INVOKE     GetDlgItem, hdlg, IDC_EDIT1
      INVOKE     SetFocus, eax
         cmp     sw2, 6
         jne     DlgDone
      INVOKE     GetDlgItem, hdlg, cb1                                 ; Get handle PrtHead
      .if PrtHead == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets PrtHead to checked
      .else
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0    ; Sets PrtHead to unchecked
      .endif
      INVOKE     GetDlgItem, hdlg, cb2                                 ; Get handle PrtColor
      .if PrtColor == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets PrtColor to checked
      .else
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0    ; Sets PrtColor to unchecked
      .endif
      .if PH
            mov     eax, rb1
            add     eax, PH
            dec     eax
         INVOKE     GetDlgItem, hdlg, eax                              ; Get handle Heading Type
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets Heading Type to checked
      .endif
         jmp     DlgDone               ; Go and return
@1:      cmp     wmsg, WM_COMMAND      ; Is message a WM_COMMAND?
         jne     DlgDone               ; No, then just return
         mov     eax, wparam           ; Otherwise, see if it's OK or CANCEL
         cmp     eax, IDCANCEL         ; That was pressed
          je     CancleIt              ; and if not either of these
         cmp     eax, IDOK             ; then just
         jne     DlgDone               ; return
         cmp     sw2, 6
          je     Heading
      INVOKE     GetDlgItemInt, hdlg, IDC_EDIT1, 0, 0
         dec     eax
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, eax, 0
         mov     ecx, eax
         inc     ecx
      INVOKE     SendMessage, hREdit, EM_SETSEL, eax, ecx
      INVOKE     SetFocus, hREdit
         jmp     CancleIt
Heading:
         mov     PH, 0
         and     PrtHead, 0
         and     PrtColor, 0
      INVOKE     IsDlgButtonChecked, hdlg, cb1
         mov     PrtHead, eax
      INVOKE     IsDlgButtonChecked, hdlg, cb2
         mov     PrtColor, eax
      INVOKE     lstrcpy, offset Head, offset Space1
      INVOKE     GetDlgItemText, hdlg, IDC_EDIT1, offset szBuff, lengthof szBuff
      INVOKE     IsDlgButtonChecked, hdlg, rb1
      .if eax
            mov     PH, 1
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb2
      .if eax
            mov     PH, 2
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb3
      .if eax
            mov     PH, 3
      .endif
      INVOKE     lstrlen, offset szBuff
      .if eax || PH > 0
         .if eax
            INVOKE     lstrcpy, offset Head, offset szBuff
         .elseif PH == 1
            INVOKE     lstrcpy, offset Head, offset Space1
         .elseif PH == 2
            INVOKE     lstrcpy, offset Head, offset FileName
         .elseif PH == 3
            INVOKE     lstrcpy, offset Head, offset PathName
         .endif
      .endif        
CancleIt:
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE             ; Return
         jmp     DlgRet                ; with TRUE
DlgDone:
         mov     eax, FALSE            ; Return with FALSE
DlgRet:
pop     ebx
         ret                           ; Return
CommonDlg ENDP

;=========================================================================
;* CHANGE FONT PROCEDURE                                                 *
;=========================================================================
Font  PROC
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
      INVOKE     GetDC, hWnd
        push     eax
      INVOKE     GetDeviceCaps, eax, LOGPIXELSY  ; = 96
         mov     tempword, eax
         pop     eax
      INVOKE     ReleaseDC, hWnd, eax
         mov     eax, charF.yHeight              ; =  0
         mul     tempword
         mov     ecx, 1440
         div     ecx
         neg     eax                
         mov     lf.lfHeight, eax                ; = -12
         mov     lf.lfWeight, FW_NORMAL
        test     charF.dwEffects, CFE_BOLD
          jz     NocfBold
         mov     lf.lfWeight, FW_BOLD
NocfBold:
         mov     lf.lfItalic, FALSE
        test     charF.dwEffects, CFE_ITALIC
          jz     NocfItal
         mov     lf.lfItalic, TRUE
NocfItal:
         mov     lf.lfUnderline, FALSE
        test     charF.dwEffects, CFE_UNDERLINE
          jz     NocfUndl
         mov     lf.lfUnderline, TRUE
NocfUndl:
         mov     lf.lfStrikeOut, FALSE
        test     charF.dwEffects, CFE_STRIKEOUT
          jz     NocfStrk
         mov     lf.lfStrikeOut, TRUE
NocfStrk:
         mov     al, charF.bCharSet
         mov     lf.lfCharSet, al
         mov     al, charF.bPitchAndFamily
         mov     lf.lfPitchAndFamily, al
         mov     eax, charF.crTextColor
         mov     cf.rgbColors, eax
      INVOKE     lstrcpy, addr lf.lfFaceName, addr charF.szFaceName
         mov     cf.lStructSize, sizeof cf
       MOVmd     cf.hwndOwner, hWnd
       MOVmd     cf.hInstance, hInst
         mov     cf.lpLogFont, offset lf
         mov     cf.Flags, CF_SCREENFONTS or CF_INITTOLOGFONTSTRUCT or CF_FORCEFONTEXIST or CF_EFFECTS
      INVOKE     ChooseFont, offset cf ; Invoke common ChooseFont dialog
         cmp     eax, FALSE
          je     FontRet
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     charF.dwEffects, 0    ; Reset the effects, they will all be specified
          or     charF.dwMask, CFM_STRIKEOUT
         mov     al, lf.lfStrikeOut
         cmp     al, FALSE
          je     nostrik
          or     charF.dwEffects, CFE_STRIKEOUT
nostrik:
          or     charF.dwMask, CFM_ITALIC
         mov     al, lf.lfItalic
         cmp     al, FALSE
          je     noital
          or     charF.dwEffects, CFE_ITALIC
noital:
          or     charF.dwMask, CFM_UNDERLINE
         mov     al, lf.lfUnderline
         cmp     al, FALSE
          je     nounder
         xor     charF.dwEffects, CFE_UNDERLINE
nounder:
          or     charF.dwMask, CFM_BOLD
         mov     eax, lf.lfWeight
         cmp     eax, FW_BOLD        ; 400 = FW_NORMAL 700 = FW_BOLD
          jl     nobold
          or     charF.dwEffects, CFE_BOLD
nobold:
         mov     eax, cf.rgbColors
         mov     charF.crTextColor, eax
       MOVmd     charF.crBackColor, TextBGC
         mov     al, lf.lfCharSet
         mov     charF.bCharSet, al
         mov     al, lf.lfPitchAndFamily
         mov     charF.bPitchAndFamily, al
         mov     eax, cf.iPointSize
         shl     eax, 1              ; Convert from 1/10 pt to twips (which is points*20)
         mov     charF.yHeight, eax
         mov     PointSize, eax

      .if charF.bCharSet == 0ffh  ; Terminal font
;            mov     charF.bCharSet, 0
;            mov     charF.bPitchAndFamily, 0
      .endif

          or     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR or CFM_BACKCOLOR
      INVOKE     lstrcpy, addr FontName, addr lf.lfFaceName
       MOVmd     TextC, cf.rgbColors
      INVOKE     lstrcpy, addr charF.szFaceName, addr lf.lfFaceName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, addr charF
      INVOKE     CreateFontIndirect, ADDR lf
         mov     hFont,eax
        call     EnableDisableToolbar
FontRet:
         ret                         ; Return
Font    ENDP

;=========================================================================
;* COLOR PROCEDURE                                                       *
;=========================================================================
Color    PROC
         mov     cc.lStructSize, sizeof cc
       MOVmd     cc.hwndOwner, hWnd
       MOVmd     cc.hInstance, hInst
         mov     cc.lpCustColors, offset CustClrs
         mov     cc.Flags, CC_FULLOPEN or CC_RGBINIT          
      INVOKE     ChooseColor, ADDR cc
         ret
Color    ENDP

;=========================================================================
;*  Color And Font DIALOG PROCEDURE                                      *
;=========================================================================
ColorFontDlg PROC  uses ebx  hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
LOCAL    hEDC:DWORD
LOCAL    rectD:RECT

      .if lparam == 333   ; From Toolbar
         INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
            mov     ChgFC, eax
            jmp     SetColors
      .endif
         cmp     wmsg, WM_INITDIALOG
         jne     NotInit

         and     sw3, 0
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     ChgFC, eax

      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
         mov     eax, charF.yHeight
         shr     eax, 1
         mov     cf.iPointSize, eax
       MOVmd     TextC, charF.crTextColor

;      INVOKE     lstrcpy, addr FontName, addr charF.szFaceName
      INVOKE     SetDlgItemText, hdlg, E1, addr charF.szFaceName
      INVOKE     GetDlgItem, hdlg, sb1                                 ; Get UpdateSel check
      .if UpdateSel == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets UpdateSel to checked
      .endif
      INVOKE     GetDlgItem, hdlg, sb2                                 ; Get UpdateAll check
      .if UpdateAll == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets UpdateAll to checked
      .endif
      INVOKE     GetDlgItem, hdlg, cb1                                 ; Get text BG check
      .if TextBG == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets text BG to checked
      .else
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0    ; Sets text BG to unchecked
      .endif

NotInit:
         cmp     wmsg, WM_COMMAND
         jne     OutPut
         and     sw1, 0
         mov     sw3, 1
         mov     eax, wparam

      .if eax == sb1                                              ; Apply To A Selection
         INVOKE     IsDlgButtonChecked, hdlg, sb1
            mov     UpdateSel, eax
         .if eax
               mov    UpdateAll, 0
         .endif
         INVOKE     SendMessage, hSel, BM_SETCHECK, UpdateSel, 0  ; Sets hSel to UpdateSel
         INVOKE     SendMessage, hAll, BM_SETCHECK, UpdateAll, 0  ; Sets hAll to UpdateAll
            jmp     SetColors 
      .elseif eax == sb2                                          ; Apply To All
         INVOKE     IsDlgButtonChecked, hdlg, sb2
            mov     UpdateAll, eax
         .if eax
               mov    UpdateSel, 0
         .endif
         INVOKE     SendMessage, hSel, BM_SETCHECK, UpdateSel, 0  ; Sets hSel to UpdateSel
         INVOKE     SendMessage, hAll, BM_SETCHECK, UpdateAll, 0  ; Sets hAll to UpdateAll
            jmp     SetColors 
      .elseif eax == cb1                                          ; Enable Text and BG Color
         INVOKE     GetDlgItem, hdlg, cb1                         ; Get text BG
         INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0           ; Gets check state
            mov     TextBG, eax
            jmp     SetColors
      .elseif eax == cb3                                          ; Make Text BG The Same As The BG Color
          MOVmd     TextBGC, BackGC
            mov     sw1, 10
            jmp     SetColors
      .elseif eax == B1                                           ; Font Face and Size
            jmp     FontS
      .elseif eax > B1 && eax < B5                                ; Color buttons
            mov     ebx, eax
            sub     ebx, B0
            mov     sw1, ebx
            jmp     TextCL
      .endif
         cmp     eax, IDCANCEL
         jne     OutPut

CancelOut:
         and     sw3, 0
      INVOKE     EndDialog, hdlg, wparam
      INVOKE     SetFocus, hREdit
         mov     eax, TRUE
         jmp     ColorFontRet

SetColors:
       MOVmd     w1, cf.rgbColors
      .if TextBG == 0
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00ffffffh
         .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f'
               mov     charF.crTextColor, 0
         .endif
            mov     charF.crBackColor, 00ffffffh
      .else
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
         .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f'
             MOVmd     charF.crTextColor, TextC
         .endif
          MOVmd     charF.crBackColor, TextBGC
      .endif
 mov       charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR or CFM_BACKCOLOR
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
       MOVmd     charF.crTextColor, TextC
      .if lparam == 333   ; From Toolbar
         INVOKE     lstrcpy, addr charF.szFaceName, addr szWork
          MOVmd     charF.crTextColor, w5
      .endif
      .if UpdateSel || ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
      .else
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
      .endif
       MOVmd     cf.rgbColors, w1
         cmp     sw1, 10
          je     OutPut             ; Making BG and text bg the same
         jmp     Pass

FontS:
        CALL     Font
;       MOVmd     TextC, cf.rgbColors
;      INVOKE     CreateFontIndirect, ADDR lf
;         mov     hFont, eax
;      INVOKE     lstrcpy, ADDR FontName, ADDR lf.lfFaceName
      INVOKE     SetDlgItemText, hdlg, E1, offset FontName
      INVOKE     SetFocus, hdlg
         jmp     DoTextColor      

TextCL:
         mov     ecx, sw1
         sub     ecx, 2
        imul     ecx, 4
       MOVmd     cc.rgbResult, TextC[ecx]
        call     Color
         cmp     eax, FALSE         ; Cancel'ed or error occurred
          je     OutPut
      INVOKE     lstrcpy, ADDR lf.lfFaceName, ADDR FontName
      INVOKE     CreateFontIndirect, ADDR lf
      .if sw1 == 4
          MOVmd      BackGC, cc.rgbResult
            jmp      DoBackGC
      .elseif sw1 > 1 && sw1 < 4
            mov     ecx, sw1 
            sub     ecx, 2
           imul     ecx, 4
          MOVmd     TextC[ecx], cc.rgbResult
         .if sw1 == 2  || sw1 == 3
               jmp     DoTextColor
         .endif
            jmp     OutPut
      .endif

DoTextColor:
       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, TextBGC

;   mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR or CFM_BACKCOLOR
      .if charF.dwEffects == CFM_BACKCOLOR
            mov     charF.dwEffects, 0
      .endif
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
      .if UpdateSel || ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f'
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, offset charF
      .else
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
      .endif

        call     GetInfoForCombos

DoBackGC:
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC

OutPut:
         cmp     sw3, 0
          je     Pass
      INVOKE     GetDlgItem, hdlg, E1
         mov     hEdit, eax
        test     eax, eax
          jz     Pass
      INVOKE     GetClientRect, hEdit, addr rectD
      INVOKE     GetDC, hEdit
         mov     hEDC, eax

;      INVOKE     SelectObject, hEDC, eax
      INVOKE     SetTextColor, hEDC, TextC
      INVOKE     SetBkColor, hEDC, BackGC
         mov     rectD.left, 150
      INVOKE     DrawText, hEDC, ADDR Clear, -1, ADDR rectD, DT_LEFT or DT_SINGLELINE

      .if cf.iPointSize == 0
            mov     eax, PointSize
            shr     eax, 1
            mov     cf.iPointSize, eax
      .endif
      INVOKE     BaseAscii, cf.iPointSize, offset Misc, 0, 10, 0, 0, 1 ;0
      .if Misc == '0'
            mov     Misc, '9'
            mov     Misc + 1, ' '
      .endif
      .if cf.iPointSize < 100
            mov     al, Misc
            mov     Misc + 1, al
            mov     Misc, ' '
      .else
            mov     Misc + 2, ' '
      .endif
         mov     rectD.left, 152
      INVOKE     DrawText, hEDC, ADDR Misc, -1, ADDR rectD, DT_LEFT or DT_SINGLELINE

      INVOKE     ReleaseDC, hEdit, hEDC
      INVOKE     GetDlgItem, hdlg, E2
         mov     hEdit, eax
        test     eax, eax
          jz     Pass
      INVOKE     GetClientRect, hEdit, addr rectD
      INVOKE     GetDC, hEdit
         mov     hEDC, eax
      INVOKE     SetBkColor, hEDC, TextC
         mov     rectD.left, 150
      INVOKE     DrawText, hEDC, ADDR Clear, -1, ADDR rectD, DT_LEFT or DT_SINGLELINE

      INVOKE     ReleaseDC, hEdit, hEDC
      INVOKE     GetDlgItem, hdlg, E3
         mov     hEdit, eax
        test     eax, eax
          jz     Pass
      INVOKE     GetClientRect, hEdit, addr rectD
      INVOKE     GetDC, hEdit
         mov     hEDC, eax
      INVOKE     SetBkColor, hEDC, TextBGC
         mov     rectD.left, 150
      INVOKE     DrawText, hEDC, ADDR Clear, -1, ADDR rectD, DT_LEFT or DT_SINGLELINE

      INVOKE     ReleaseDC, hEdit, hEDC
      INVOKE     GetDlgItem, hdlg, E4
         mov     hEdit, eax
        test     eax, eax
          jz     Pass
      INVOKE     GetClientRect, hEdit, addr rectD
      INVOKE     GetDC, hEdit
         mov     hEDC, eax
      INVOKE     SetBkColor, hEDC, BackGC
         mov     rectD.left, 150
      INVOKE     DrawText, hEDC, ADDR Clear, -1, ADDR rectD, DT_LEFT or DT_SINGLELINE

      INVOKE     ReleaseDC, hEdit, hEDC

Pass:
         mov     eax, FALSE
ColorFontRet:
      .if PathName == 0
         INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
      .endif
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, ChgFC, 0
         ret
ColorFontDlg ENDP

;=========================================================================
;* Get Information for ComboBoxes procedures                             *
;=========================================================================
GetInfoForCombos PROC  uses ebx edx

         xor     edx, edx
         mov     eax, PointSize
         mov     ebx, 20
         div     ebx
      INVOKE     BaseAscii, eax, addr Misc, 0, 10, 0, 0, 1

         xor     edx, edx
         lea     ebx, ComboColor
         lea     eax, ComboEnd
         sub     eax, ebx
         mov     ebx, 4
         div     ebx
         mov     ecx, eax       ; Number of ComboBox colors
         mov     ebx, TextC
      .while ecx
            mov     eax, ecx
            dec     eax
         .if ComboColor+[eax*4] == ebx
            INVOKE     SendMessage, hCColor, CB_GETLBTEXT, eax, addr szBuff
            .break
         .endif
            dec     ecx
      .endw
      .if sw2 == 9
            ret
      .endif
      INVOKE     SendMessage, hCFont, CB_SELECTSTRING, -1, addr charF.szFaceName
      INVOKE     SendMessage, hCSize, CB_SELECTSTRING, -1, addr Misc
      INVOKE     SendMessage, hCColor, CB_SELECTSTRING, -1, addr szBuff
         ret
GetInfoForCombos ENDP

;=========================================================================
;* Set Information for ComboBoxes procedures                             *
;=========================================================================
SetInfoForCombos PROC  uses ebx edx
      INVOKE     EnableDisableEditMenu, hMenu
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
      INVOKE     SendMessage, hCFont, CB_SELECTSTRING, -1, addr charF.szFaceName
         xor     edx, edx 
         mov     eax, charF.yHeight
         mov     ebx, 20
         div     ebx
      INVOKE     BaseAscii, eax, addr szBuff, 0, 10, 0, 0, 1
      INVOKE     SendMessage, hCSize, CB_SELECTSTRING, -1, addr szBuff
         mov     eax, charF.crTextColor
        push     TextC
         mov     TextC, eax
         mov     sw2, 9   
        call     GetInfoForCombos
         and     sw2, 0
         pop     TextC
      INVOKE     SendMessage, hCColor, CB_SELECTSTRING, -1, addr szBuff
         ret
SetInfoForCombos ENDP

;=========================================================================
;* RICH EDIT PROCEDURE - RICH EDIT IS A SUB CLASS                        *
;=========================================================================
RichEditProc PROC  hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

      INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam

      .if wmsg == WM_LBUTTONDOWN
         INVOKE     EnableDisableEditMenu, hMenu
           call     SetInfoForCombos

         .if Jump
            INVOKE     HelpGen, hHelpGen, WM_COMMAND, B1, 44
         .endif
         .if Topic
            INVOKE     HelpGen, hHelpGen, WM_COMMAND, B2, 44
         .endif

      .endif

      .if wmsg == WM_LBUTTONUP || wmsg == WM_KEYUP
         INVOKE     EnableDisableEditMenu, hMenu
         INVOKE     lstrcpy, offset LineBuff, offset Clear

      INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
         mov     TopLineP, eax

         INVOKE     SendMessage, hREdit, EM_GETSEL, offset SBook, offset EBook
;         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
         INVOKE     SendMessage, hREdit, EM_GETLINECOUNT, 0, 0    ;returns # lines + 1
            dec     eax
            mov     Ltot, eax
         INVOKE     SendMessage, hREdit, EM_GETSEL, offset SPos, offset EPos
            mov     eax, SPos
            sub     EPos, eax
         INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
            mov     FileOff, eax
         INVOKE     SendMessage, hREdit, EM_EXLINEFROMCHAR, 0, FileOff
            mov     Lnum, eax
         INVOKE     SendMessage, hREdit, EM_GETLINE, Lnum, offset LineBuff
            mov     Llen, eax
            mov     eax, FileOff
         .if eax > SPos
               and     SPos, 0
               mov     ebx, EPos
            .if EPos > 2 
                  sub     ebx, 2
            .endif
               mov     Llen, ebx
         .else
               sub     SPos, eax
         .endif
            add     SPos, 1
            mov     eax, EPos
         .if eax > Llen
               sub     Lnum, 1
         .endif
         .if Llen == 0
               and     SPos, 1
         .endif
            add     Lnum, 1
         .if Llen >= 1
               sub     Llen, 1
         .endif
Countem:
         INVOKE     BaseAscii, Lnum, offset cnt1, 5, 10, 0, 1, 0
         INVOKE     BaseAscii, Ltot, offset cnt2, 5, 10, 0, 1, 0
            mov     eax, SBook
         .if eax != EBook               ; If selection zero out column's
               mov     SPos, 0
               mov     Llen, 0
         .endif
         INVOKE     BaseAscii, SPos, offset cnt3, 4, 10, 0, 1, 0
         INVOKE     BaseAscii, Llen, offset cnt4, 4, 10, 0, 1, 0

NoCol:
         INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE2, offset LdataR
         INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MOUSEMOVE, offset LdataC
            jmp     MoveIt
      .endif
      .if wmsg == WM_MOUSEMOVE
            and     MultInst, 0
            jmp     MoveIt             
      .endif
      .if wmsg == WM_VSCROLL
         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            inc     eax
            mov     Lnum, eax
         INVOKE     SendMessage, hREdit, EM_GETLINECOUNT, 0, 0
            dec     eax
            mov     Ltot, eax
            mov     SPos, 0
            mov     Llen, 0
            jmp     Countem
      .endif
      .if wmsg == WM_RBUTTONUP
            jmp     PopUp
      .endif
         jmp     ThatsAll

PopUp:
      INVOKE     EnableDisableEditMenu, hMenu
      INVOKE     GetWindowRect,hWnd,ADDR rect
         mov     eax, lparam        ; x/y pos of window
         mov     ebx, eax
         and     ebx, 0000ffffh     ; ebx = LOWORD(lparam) = x pos
         shr     eax, 16            ; eax = HIWORD(lparam) = y pos
         add     ebx, rect.left
         add     eax, rect.top
         mov     XP, ebx            ; x position
         mov     YP, eax            ; y position
         add     XP, 10 
         add     YP, 70
      INVOKE     TrackPopupMenu, hSMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, XP, YP, 0, hWnd, ADDR rect
        jmp      ThatsAll

MoveIt:
      INVOKE     GetFocus
      .if eax == hREditW
;         INVOKE     SetFocus, hWnd
      .endif

ThatsAll:
         ret
RichEditProc ENDP

;=========================================================================
;*  Find / Replace dialog proc                                           *
;=========================================================================
FindReplace PROC    uses ebx edi esi hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

      .if wmsg == WM_INITDIALOG      ; If message is INITDIALOG then
            mov     sw1, 0
            mov     eax, hdlg
            mov     hFRDlg, eax
         INVOKE     GetDlgItem, hdlg, EditF  ; Get handle of edit box
           push     eax                      ; Save handle of edit1
         INVOKE     SetFocus, eax            ; Set focus to this field
            pop     eax
         INVOKE     SendMessage, eax, EM_LIMITTEXT, 100, 0 ; Limit text size
         INVOKE     GetDlgItem, hdlg, EditR
         INVOKE     SendMessage, eax, EM_LIMITTEXT, 100, 0 ; Limit text size
         INVOKE     SetDlgItemText, hdlg, EditF, addr szFind
         INVOKE     SetDlgItemText, hdlg, EditR, addr szRep
         INVOKE     GetDlgItem, hdlg, rb2    ; Get search down check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets find down to checked
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
            and     FRFlags, 0
            jmp     FRDone
      .endif
         cmp     wmsg, WM_COMMAND
         jne     FRDone

      .if wparam == FIND || wparam == REPLACE || wparam == REPLACEALL
            jmp     FRText
      .endif
         cmp     wparam, IDCANCEL
          je     CloseIt
         jmp     FRDone

FRText:
         and     FRFlags, 0
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      INVOKE     GetDlgItemText, hdlg, EditF, addr szFind, 100
       MOVmd     ft.chrg.cpMin, cr.cpMin
         mov     ft.chrg.cpMax, -1
         lea     eax, offset szFind
         mov     ft.lpstrText, eax

      .if wparam != FIND    
        INVOKE      GetDlgItemText, hdlg, EditR, addr szRep, 100
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, cb1
      .if eax
             or     FRFlags, FR_WHOLEWORD
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, cb2
      .if eax
             or     FRFlags, FR_MATCHCASE
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb1
      .if eax
            mov     Prev, 1
            mov     ft.chrg.cpMax, 0
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb2
      .if eax
            mov     Prev, 0
             or     FRFlags, FR_DOWN
      .endif
      .if wparam == FIND
        INVOKE     Find, hWnd, 0, FRFlags, ft.lpstrText, Prev
          call     EnableDisableToolbar
      .endif

Again:
      .if wparam != FIND
         INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szRep
         INVOKE     GetMenu, hWnd        ; Enable the replace next command
         INVOKE     EnableMenuItem, eax, IDM_REPLACENEXT, MF_BYCOMMAND or MF_ENABLED
           call     EnableDisableToolbar
         .if Prev
               sub     ft.chrg.cpMin, 1
         .else
               add     ft.chrg.cpMin, 1
         .endif
         INVOKE     Find, hWnd, 0, FRFlags, ft.lpstrText, Prev
         .if eax != 1                    ; All done
               mov     eax, cr.cpMin
               mov     cr.cpMax, eax
            INVOKE     lstrlen, addr szRep
               add     cr.cpMax, eax
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
               jmp     FRDone
         .endif 
         .if wparam == REPLACEALL
               jmp     Again
         .endif
      .endif
         jmp     FRDone

CloseIt:
      INVOKE     EndDialog, hdlg, wparam ; End the dialog with wparam as return
         mov     eax, TRUE               ; Return
         and     hFRDlg, 0
         jmp     FRRet                   ; with TRUE
FRDone:
         mov     eax, FALSE              ; Return with FALSE
FRRet:
         ret                             ; Return
FindReplace  ENDP

;=========================================================================
;* FindProc returns TRUE or FALSE based on finding FText                 *
;=========================================================================
Find    PROC     hwnd:DWORD, Next:DWORD, Flags:DWORD, FText:DWORD, Up:DWORD
      INVOKE     lstrlen, FText
         mov     Len, eax

Loop1:
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FRFlags, offset ft
         cmp     eax, -1                 ; Nothing found?
         jne     FoundIt
      .if Up == 0
         INVOKE     lstrcpyn, offset TopBot, offset Top, 6
      .else
         INVOKE     lstrcpyn, offset TopBot, offset Bot, 6
      .endif
      INVOKE     MessageBox, NULL, offset FindEnd, offset szFR, MB_YESNO or MB_ICONQUESTION or MB_TASKMODAL
         cmp     eax, IDNO
          je     Find0
      .if Up == 0
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
      .else
;         INVOKE     SendMessage, hREdit, EM_SETSEL, bytesread, bytesread
            mov     eax, bytesread
            mov     ft.chrg.cpMin, eax
            mov     ft.chrg.cpMax, 0
      .endif
         jmp     Loop1

FoundIt:
      .if eax == ft.chrg.cpMin && Up == 0
            add     ft.chrg.cpMin, 1
            jmp     Loop1
      .endif
         mov     cr.cpMin, eax
         mov     ft.chrg.cpMin, eax
         add     eax, Len
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
      INVOKE     SendMessage, hREdit, EM_GETSEL, offset SBook, offset EBook
      INVOKE     GetMenu, hwnd
      INVOKE     EnableMenuItem, eax, IDM_FINDNEXT, MF_BYCOMMAND or MF_ENABLED
         mov     eax, TRUE
         jmp     FindX
Find0:   mov     eax, FALSE
FindX:   ret
Find    ENDP

;========================================================================|
;*  COLUMN PROCEDURE F1 thru F4 Position                                 *
;========================================================================|
Column   PROC
      INVOKE     SendMessage, hREdit, EM_GETSEL, offset SPos, 0  ;Current pos
         mov     ecx, w5
         sub     ecx, CurPos
         add     SPos, ecx
         inc     ecx
         mov     eax, Llen
         inc     eax     
      .if eax >= w5
            jmp     Set
      .endif
      INVOKE     lstrcpyn, offset szWork, offset Clear, ecx
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, offset szWork
Set:  INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, SPos
         ret
Column   ENDP

;========================================================================|
;*  SHIFT PROCEDURE                                                      *
;========================================================================|
Shift    PROC
         and     sw1, 0 
      INVOKE     SendMessage, hREdit, EM_GETSEL, offset SPos, offset EPos  ; Current pos
Again:
         mov     eax, SPos
         add     eax, 255
         mov     EPos, eax
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, EPos
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, offset szWork
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, SPos
         mov     al, 0dh               ;carrage return
         mov     edi, offset szWork  ;start address in input buffer
         mov     ecx, [bytesread]
         sub     ecx, SPos             ;bytes left to analyze
         cld                           ;increment edi
         repnz   scasb                 ;repeat until byte = al(13)
         mov     ecx, edi
         sub     ecx, offset szWork
         mov     EPos, ecx
      INVOKE     lstrcpyn, offset LineBuff, offset szWork, ecx
         cmp     sw1, 1
          je     ShiftL
      .if Misc == 'S'
            mov     eax, SHIFT
            mov     ecx, CurPos
         .if eax > ecx
               sub      eax, ecx
               jmp      ShiftR
         .else
               sub      ecx, eax
               sub      SPos, ecx
                or      sw1, 1
               jmp      Again 
         .endif
      .endif
      .if Misc == 'R'
            mov     eax, SPACE
ShiftR:
         INVOKE     lstrcpyn, offset szWork, offset Clear, eax
         INVOKE     lstrcat, offset szWork, offset SP1
         INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, SPos
            jmp     Replace
      .endif
      .if Misc == 'L'
            mov     ecx, SPACE             ;Increments
ShiftL:
            mov     edi, offset LineBuff   ;start address in input buffer
Loop1:
            cmp     byte ptr[edi], 20h
             je     Cont
            cmp     byte ptr[edi], 09h
            jne     GotEm
Cont:
            inc     edi
            dec     ecx
             jz     GotEm
            jmp     Loop1
GotEm:
            mov     ecx, SPos
            add     EPos, ecx
         INVOKE     lstrcpy, offset szWork, edi
         INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, EPos
      .endif
Replace:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, offset szWork
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      INVOKE     SendMessage, hREdit, EM_GETSEL, offset SBook, offset EBook
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
         mov     FileOff, eax
      INVOKE     SendMessage, hREdit, EM_EXLINEFROMCHAR, 0, FileOff
         mov     Lnum, eax
      INVOKE     SendMessage, hREdit, EM_GETLINE, Lnum, offset LineBuff
         mov     Llen, eax
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, SPos
NoMore:
         ret
Shift    ENDP

;=========================================================================
;* HTML to TEXT Converter Dialog Procedure                               *
;=========================================================================
HTML     PROC
      .if ExtType == 'h' && ExtType + 1 == 't' && ExtType + 2 == 'm'
            jmp     htmlOK
      .else   
         INVOKE     MessageBox, NULL, offset NoHTML, offset pTitle, MB_YESNO or MB_ICONQUESTION or MB_TASKMODAL
            cmp     eax, IDNO
             je     GetOut
      .endif
htmlOK:
      INVOKE     lstrcpy, ADDR szWork, ADDR PathName
        call     readp
         mov     cr.cpMin, 0
         mov     cr.cpMax, -1
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
        call     BuildfsMem 
         mov     esi, fpMem
         mov     edi, fsMem
         mov     ecx, bytesread
         mov     sw1, 0
         mov     sw2, 0
      .while (ecx)
            mov     al, byte ptr[esi]
         .if al == '<'
            .if word ptr[esi+1] == '-!'
                  or      sw2, 1
            .endif
                or     sw1, 1
               jmp     NoCopy
         .endif
         .if al == '>'
            .if word ptr[esi-2] == '--'
                  and     sw2, 0
            .endif
               and     sw1, 0
               jmp     NoCopy
         .endif
            .if sw1 == 0 && sw2 == 0
               .if al == 0dh && edi > fsMem
                  .if byte ptr[edi-2] == 0dh
                       inc     esi
                       dec     ecx
                       jmp     NoCopy
                  .endif
               .endif
                  mov     byte ptr[edi], al
                  inc     edi
            .endif
NoCopy:
            inc     esi
            dec     ecx
      .endw
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, fsMem
      INVOKE     GlobalUnlock, fpMem
      INVOKE     GlobalFree, hpMem
         mov     hpMem, 0
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0
GetOut:
         ret
HTML     ENDP

;========================================================================|
;*  CONVERT TAB STOPS DIALOG PROCEDURE                                   *
;========================================================================|
ConvTabs PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
         cmp     wmsg, WM_INITDIALOG   ;if message is INITDIALOG then
         jne     NotInit
         and     sw1, 0
         and     cnt, 0
         jmp     ConvDone
NotInit:
         cmp     wmsg, WM_COMMAND
         jne     ConvDone
         mov     eax, wparam
         cmp     eax, IDCONVERT
          je     Convit
         cmp     eax, IDFINDTS
          je     Findit
         cmp     eax, REPLACE
          je     Replaceit
         cmp     eax, IDUNDO
          je     Undo
         cmp     eax, IDSETUP
          je     CallSetup
         cmp     eax, IDCANCEL
         jne     ConvDone
Endit:
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE
         jmp     ConvRet
Findit:
      .if sw1 == 0
             or     sw1, 1
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
            lea     eax, offset HT
            mov     ft.lpstrText, eax
            mov     FRFlags, 1
      .endif

LFind:
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FRFlags, offset ft
         cmp     eax, -1                 ;nothing found?
          je     ConvDone
         mov     cr.cpMin, eax
         add     eax, 1
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
        push     cr.cpMin
         add     cr.cpMin, 1
       MOVmd     ft.chrg.cpMin, cr.cpMin
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
         pop     ecx
         sub     ecx, eax
         inc     ecx
         xor     edx, edx
         mov     eax, TabStops[edx]
      .while (ecx >= eax)
            add     edx, 4
            mov     eax, TabStops[edx]
      .endw
         sub     eax, ecx
         inc     eax
      INVOKE     lstrcpyn, offset szBuff, offset Clear, eax
      .if w5 == 5
            jmp     Replaceit
      .endif
         jmp     ConvDone
Replaceit:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, offset szBuff
         add     cnt, 1
      INVOKE     BaseAscii, cnt, offset Conv, 0, 10, 0, 0, 1
      INVOKE     SetDlgItemText, hdlg, IDC_EDIT1, offset Conv
      .if w5 == 5
         jmp     LFind
      .endif
         jmp     ConvDone
Convit:
         mov     sw1, 0
         mov     w5, 5
         jmp     Findit
Undo:
          or     OA, 1
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
        call     OpenFileA
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
         and     w5, 0  
         and     cnt, 0
      INVOKE     SetDlgItemText, hdlg, IDC_EDIT1, offset cnt
         and     sw1, 0
call     TabStop
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
         jmp     ConvDone
CallSetup:
         mov     w7, 0
      INVOKE     CreateDialogParam, hInst, IDD_SETUP, hWnd, offset Setup, 0
         jmp     ConvDone
ConvDone:
         mov     eax, FALSE
ConvRet:
         ret
ConvTabs ENDP

;========================================================================|
;* ABOUT AND VERSION DIALOG BOX PROCEDURE                                *
;========================================================================|
AbVerDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push     ebx
      .if wmsg == WM_INITDIALOG
         mov     ms.dwLength, sizeof ms
      INVOKE     GlobalMemoryStatus, offset ms
      INVOKE     BaseAscii, ms.dwTotalPhys, offset szBuff, 10, 10, 1, 0, 1
      INVOKE     SetDlgItemText, hdlg, E2, offset szBuff
      INVOKE     BaseAscii, ms.dwAvailPhys, offset szBuff, 10, 10, 1, 0, 1
      INVOKE     SetDlgItemText, hdlg, E3, offset szBuff
      INVOKE     BaseAscii, ms.dwMemoryLoad, offset szBuff, 2, 10, 0, 0, 1
      INVOKE     SetDlgItemText, hdlg, E4, offset szBuff
         mov     eax, hdlg
        call     CenterChild

      .elseif wmsg != WM_COMMAND    ; See if msg is a command
         jmp     AbVerDone
      .endif
         mov     eax, wparam        ; Otherwise, see if it's OK or CANCEL
         cmp     eax, IDOK          ; That was pressed
          je     @@1                ; and if not get out
         jmp     AbVerDone
@@1:    push     wparam             ; Terminate with wparam as the return
        push     hdlg               ; handle of the dialog
        call     EndDialog          ; end the dialog
         mov     eax, TRUE          ; return
         jmp     AbVerRet           ; with TRUE
AbVerDone:
         mov     eax, FALSE         ; Return with FALSE
AbVerRet:
         pop     ebx
         ret                        ; Return
AbVerDlg ENDP

;========================================================================|
;*  esi = input string pointer ecx = len get before call                 *
;*  returns string converted to lower case                               *
;========================================================================|
LowerCase PROC
        push     esi                ; Save pointer
         mov     edi, esi           ; dest = source
struplp: lodsb                      ; Get byte in al
         cmp     al, 'A'            ; Convert
          jl     strupst            ; only
         cmp     al, 'Z'            ; A-Z
          jg     strupst            ; to upper case
         ;and     al, 0dfh           ;and off lower case bit
         add      al, 20h           ; Add 20h to upper case bit
strupst: stosb                      ; store al
         loop    struplp            ; for length of string
         pop     esi                ; Restore string ptr
         ret                        ; Return to caller
LowerCase ENDP

;========================================================================|
;* Display View Dialog Procedure                                         *
;========================================================================|
ViewDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
      .if wmsg == WM_INITDIALOG
         .if RuleOn
            INVOKE     GetDlgItem, hdlg, sb1                           ; Get Ruler check
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Ruler to checked
         .endif
          MOVmd     w1, sb2
            mov     eax, PL
            add     w1, eax
         INVOKE     GetDlgItem, hdlg, w1                               ; Get View check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets View to checked
      .endif
      .if wmsg != WM_COMMAND     ; See if msg is a command
            jmp     ViewDone
      .endif
         mov     eax, wparam     ; Otherwise, see if its CANCEL
         cmp     eax, IDCANCEL   ; That was pressed
          je     CancelOut       ; and if not either of these

      INVOKE     IsDlgButtonChecked, hdlg, sb1    ; Enable ruler controls
      .if eax
             or     RuleOn, 1
      .else
            and     RuleOn, 0
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb2    ; Normal view
      .if eax
            mov     PL, 0
            mov     sw2, 8
            mov     idML, 31
            mov     idMR, 31
            mov     savML, 0
            mov     savMR, 0
         INVOKE     MarIndDlg, hInst, IDD_MARGIN, hWnd, offset MarIndDlg
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb3    ; Portait view
      .if eax
            mov     PL, 1
            mov     sw2, 8
         INVOKE     MarIndDlg, hInst, IDD_MARGIN, hWnd, offset MarIndDlg
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb4    ; Landscape view
      .if eax
            mov     PL, 2
            mov     sw2, 8
         INVOKE     MarIndDlg, hInst, IDD_MARGIN, hWnd, offset MarIndDlg
      .endif
         jmp     ViewDone

CancelOut:
        push     wparam             ; Terminate with wparam as the return
        push     hdlg               ; Handle of the dialog
        call     EndDialog          ; End the dialog
         mov     eax, TRUE          ; Return
         jmp     ViewRet            ; with TRUE
ViewDone:
         mov     eax, FALSE         ; Return with FALSE
ViewRet:
         ret                        ; Return to caller
ViewDlg ENDP

;========================================================================|
;* Set Superscript and Subscript Values Dialog Procedure                 *
;========================================================================|
SuperSubDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push     ebx
      .if wmsg == WM_INITDIALOG
         INVOKE     CreateListWin, 54, 45, 62, 22, hdlg
            mov     hListML, eax    ; Save the handle to listbox
         INVOKE     LoadList, eax, offset ScriptSize, 3
         INVOKE     CreateListWin, 142, 45, 62, 22, hdlg
            mov     hListMR, eax    ; Save the handle to listbox
         INVOKE     LoadList, eax, offset ScriptSize, 3
         INVOKE     CreateListWin, 54, 115, 62, 22, hdlg
            mov     hListIL, eax    ; Save the handle to listbox
         INVOKE     LoadList, eax, offset SuperPoint, 9
         INVOKE     CreateListWin, 142, 115, 62, 22, hdlg
            mov     hListIR, eax    ; Save the handle to listbox
         INVOKE     LoadList, eax, offset SubPoint, 9
      .elseif wmsg != WM_COMMAND    ; See if msg is a command
            jmp     SuperSubDone
      .endif
         mov     eax, wparam     ; Otherwise, see if its CANCEL
         cmp     eax, IDCANCEL   ; That was pressed
          je     CancelOut       ; and if not either of these
         cmp     eax, B1
         jne     SuperSubDone

      INVOKE     SendMessage, hListML, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListML, LB_GETTEXT, eax, offset szBuff
      .if byte ptr szBuff != '1'
            mov     byte ptr Misc, 2eh
         INVOKE     lstrcpyn, offset Misc + 1, offset szBuff, eax
      .else
         INVOKE     lstrcpyn, offset Misc, offset szBuff, 2
      .endif
        call     AsciiToFloat 
       finit
         fld     RNum10
        fstp     SizeU
      INVOKE     SendMessage, hListMR, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListMR, LB_GETTEXT, eax, offset szBuff
      .if byte ptr szBuff != '1'
            mov     byte ptr Misc, 2eh
         INVOKE     lstrcpyn, offset Misc + 1, offset szBuff, eax
      .else
         INVOKE     lstrcpyn, offset Misc, offset szBuff, 2
      .endif
        call     AsciiToFloat 
       finit
         fld     RNum10
        fstp     SizeD
      INVOKE     SendMessage, hListIL, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListIL, LB_GETTEXT, eax, offset szBuff
         inc     eax
      INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
        call     AsciiToFloat 
       finit
         fld     RNum10
       fistp     PointU
      INVOKE     SendMessage, hListIR, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListIR, LB_GETTEXT, eax, offset szBuff
         inc     eax
      INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
        call     AsciiToFloat 
       finit
         fld     RNum10
       fistp     PointD
         jmp     SuperSubDone

CancelOut:
        push     wparam             ; Terminate with wparam as the return
        push     hdlg               ; handle of the dialog
        call     EndDialog          ; end the dialog
         mov     eax, TRUE          ; Return
         jmp     SuperSubRet        ; with TRUE
SuperSubDone:
         mov     eax, FALSE         ; Return with FALSE
SuperSubRet:
         pop     ebx
         ret                        ; Return to caller
SuperSubDlg ENDP

;========================================================================|
;* Margin and Indent Dialog Procedure                                    *
;========================================================================|
MarIndDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push     ebx   
      .if sw2 == 8  ; From view menu
            and     sw2, 0
          MOVmd     rect.left, savL
          MOVmd     rect.top, savT
          MOVmd     rect.right, savR
          MOVmd     rect.bottom, savB
         .if PL == 0
             MOVmd     mL, savML
             MOVmd     mR, savMR
               jmp     ZeroMar
         .endif  
         .if PL == 1
             MOVmd     mL, savML
             MOVmd     mR, savMR
               jmp     SetSb1 ;SetMar
         .endif  
         .if PL == 2
             MOVmd     mL, savML
             MOVmd     mR, savMR
               jmp     SetSb2 ;SetMar
         .endif  
      .endif 
      .if wmsg == WM_INITDIALOG
         INVOKE     GetDlgItem, hdlg, sb4                           ; Get UpdateSel check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets UpdateSel to checked
         .if PL == 1
             MOVmd     w1, sb1
         .elseif PL == 2
             MOVmd     w1, sb2
         .else
             MOVmd     w1, sb3
         .endif
         INVOKE     GetDlgItem, hdlg, w1                            ; Get View check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets View to checked

         INVOKE     CreateListWin, 46, 115, 62, 22, hdlg
            mov     hListML, eax      ; Save the handle to listbox
         INVOKE     LoadList, eax, offset NumRange, 31
         INVOKE     CreateListWin, 142, 115, 62, 22, hdlg
            mov     hListMR, eax      ; Save the handle to listbox
         INVOKE     LoadList, eax, offset NumRange, 31
         INVOKE     CreateListWin, 270, 115, 62, 22, hdlg
            mov     hListIL, eax      ; Save the handle to listbox
         INVOKE     LoadList, eax, offset NumRange, 31
         INVOKE     CreateListWin, 366, 115, 62, 22, hdlg
            mov     hListIR, eax      ; Save the handle to listbox
         INVOKE     LoadList, eax, offset NumRange, 31
         INVOKE     SendMessage, hListML, LB_SETTOPINDEX, idML, 0
         INVOKE     SendMessage, hListMR, LB_SETTOPINDEX, idMR, 0
      .elseif wmsg != WM_COMMAND
            jmp     MarIndDone
      .endif
@1:
         mov     eax, wparam          ; Otherwise, see if its CANCEL
         cmp     eax, IDCANCEL        ; That was pressed
          je     CancelOut            ; and if not either of these
         cmp     eax, B2
          je     DoIndent
         cmp     eax, B1
         jne     MarIndDone
       MOVmd     rect.left, savL
       MOVmd     rect.top, savT
       MOVmd     rect.right, savR
       MOVmd     rect.bottom, savB
      INVOKE     IsDlgButtonChecked, hdlg, sb3
      .if eax
         INVOKE     SendMessage, hListML, LB_GETTOPINDEX, 0, 0
            mov     idML, eax                  
         INVOKE     SendMessage, hListML, LB_GETTEXT, eax, offset szBuff
            inc     eax
         INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
           call     AsciiToFloat 
          finit
            fld     RNum10
            fld     RPixInch  ;90.75
           fmul     ST(0), ST(1)
          fistp     mL

         INVOKE     SendMessage, hListMR, LB_GETTOPINDEX, 0, 0
            mov     idMR, eax                  
         INVOKE     SendMessage, hListMR, LB_GETTEXT, eax, offset szBuff
            inc     eax
         INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
           call     AsciiToFloat 
          finit
            fld     RNum10
            fld     RPixInch  ;90.75
           fmul     ST(0), ST(1)
          fistp     mR
          MOVmd     savML, mL
          MOVmd     savMR, mR
ZeroMar:
         .if !mR
               mov     savMR, 0
         .endif
         .if !mL && !mR
               mov     PL, 0   
               mov     rect.left, 11
               jmp     SetMargins
         .endif

SetMar:
         .if mL < 23
               mov     mL, 22 ;23
         .endif
            mov     eax, mL
            add     eax, mR
         .if PL == 0
               mov     ebx, 953
         .endif
         .if PL == 1
               mov     ebx, 730 ;727  ; Don't change
         .endif    
         .if PL == 2
               mov     ebx, 957 ;953  ; Don't change
         .endif
            sub     ebx, eax
            mov     w1, ebx
            add     mL, 2
          MOVmd     rect.left, mL
            add     rect.left, 11
            mov     eax, rect.left
            add     eax, w1
            add     eax, 45
         .if !PL
               add     eax, 4
         .endif
            mov     rect.right, eax
         .if mL < 22
               add     rect.right, 22
         .endif
         .if mR < 22
               sub     rect.right, 22
         .endif
            jmp     SetMargins
      .endif
 
      INVOKE     IsDlgButtonChecked, hdlg, sb1
SetSb1:
      .if eax
         mov     PL, 1
         mov     w1, 734 ;731
         mov     eax, 32 ;33
         jmp     GotIt
      .endif


      INVOKE     IsDlgButtonChecked, hdlg, sb2
SetSb2:
      .if eax
         mov     PL, 2
         mov     w1, 961 ;958
         mov     eax, 32 ;33
         jmp     GotIt
      .endif
         jmp     MarIndDone

GotIt:
         mov     rect.left, eax
         add     eax, w1
         mov     rect.right, eax
         jmp     SetMargins

SetMargins:
         add     rect.left, 5 ;2
      INVOKE     SendMessage, hREdit, EM_SETRECT, 0, ADDR rect
         sub     rect.left, 5 ;2
      .if PL
            add     rect.left, 3
      .endif
;DSPValue hWnd, rect.left, 1, 't'
;DSPValue hWndStat, rect.right, 1, 's'
        call     BuildRuler

      .if mL > 23
          finit
           fild     mL
            fld     RPixTwip   ;needs to be 15.867768595
           fmul     ST(0), ST(1)
          fistp     mL
            sub     mL, 360
      .else
            mov     mL, 0 
      .endif
      .if mR > 23
          finit
           fild     mR
            fld     RPixTwip   ;needs to be 15.867768595
           fmul     ST(0), ST(1)
          fistp     mR
            sub     mR, 360
      .else
            mov     mR, 0 
      .endif
;        call     BuildRuler
         jmp     MarIndDone

DoIndent:
      INVOKE     SendMessage, hListIL, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListIL, LB_GETTEXT, eax, offset szBuff
         inc     eax
      INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
        call     AsciiToFloat
       finit
         fld     RNum10
         fld     RTwips0  ;1440
        fmul     ST(0), ST(1)
       fistp     iL

      INVOKE     SendMessage, hListIR, LB_GETTOPINDEX, 0, 0
      INVOKE     SendMessage, hListIR, LB_GETTEXT, eax, offset szBuff
         inc     eax
      INVOKE     lstrcpyn, offset Misc, offset szBuff, eax
        call     AsciiToFloat 
       finit
         fld     RNum10
         fld     RTwips0  ;1400
        fmul     ST(0), ST(1)
       fistp     iR
         mov     pf.dwMask, PFM_STARTINDENT or PFM_RIGHTINDENT ;PFM_OFFSETINDENT
       MOVmd     pf.dxStartIndent, iL
       MOVmd     pf.dxRightIndent, iR
      INVOKE     IsDlgButtonChecked, hdlg, sb5
      .if eax
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
         INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
         INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      .else
         INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, offset pf
      .endif
;        call     BuildRuler
         jmp     MarIndDone

CancelOut:
        push     wparam               ;terminate with wparam as the return
        push     hdlg                 ;handle of the dialog
        call     EndDialog            ;end the dialog
         mov     eax, TRUE            ;return
         jmp     MarIndRet            ;with TRUE

MarIndDone:
         mov     eax, FALSE           ;return with FALSE
MarIndRet:
         pop     ebx
         ret                          ;return to caller
MarIndDlg ENDP

;========================================================================|
;* CreateListWin Dialog Procedure                                        *
;========================================================================|
CreateListWin PROC  Lx:DWORD, Ly:DWORD, Lw:DWORD, Lh:DWORD, hdlg:DWORD
         INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, offset listbox, 0, WS_VSCROLL or\
                    WS_VISIBLE or WS_BORDER or WS_CHILD or\
                    LBS_HASSTRINGS or LBS_NOINTEGRALHEIGHT or LBS_DISABLENOSCROLL,
                    Lx, Ly, Lw, Lh, hdlg, 55555, hInst, 0
         ret                          ;return to caller
CreateListWin ENDP

;========================================================================|
;* LoadListBox Dialog Procedure                                          *
;========================================================================|
LoadList PROC  hList:DWORD, Input:DWORD, Default:DWORD
         mov     esi, Input
         xor     eax, eax
         mov     cnt, 0
Getlen:
      .if byte ptr[esi+eax] == 2ch
            mov     Len, eax
            add     Len, 1 
            add     cnt, 1
         .if cnt > 0 ;20
            INVOKE     lstrcpyn, offset Misc, esi, Len
            .if Default == 4444
               INVOKE     SendMessage, hList, CB_ADDSTRING, 0, offset Misc
            .else
               INVOKE     SendMessage, hList, LB_ADDSTRING, 0, offset Misc
            .endif
         .endif
            add     esi, Len
            xor     eax, eax
            jmp     Getlen
      .elseif byte ptr[esi+eax] == 0h
         INVOKE     SendMessage, hList, LB_SETTOPINDEX, Default, 0
            jmp     @1
      .endif
         inc     eax
         jmp     Getlen
@1:
         ret                          ; Return to caller
LoadList ENDP

;========================================================================|
;* ASCII Box Procedure - ASCII Win is a Sub Class                        *
;========================================================================|
AsciiProc   PROC  hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
       .if wmsg == WM_CHAR
           MOVmd     w4, wmsg
       ;.elseif wmsg == WM_KEYDOWN
           ;MOVmd     w4, wmsg
          INVOKE     BaseAscii, wparam, offset szBuff, 0, 10, 0, 0, 1
          INVOKE     BaseAscii, wparam, offset Misc, 0, 16, 0, 0, 1
          INVOKE     SendMessage, hAsciibox, EM_SETSEL, 0, -1
       .endif
       INVOKE        CallWindowProc, lpAsciibox, hwnd, wmsg, wparam, lparam
            ret
AsciiProc   ENDP

;========================================================================|
;*  ASCII DIALOG PROCEDURE                                               *
;========================================================================|
AsciiDlg PROC    hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
         cmp     wmsg, WM_COMMAND
         jne     AsciiDone
         mov     eax, wparam
         cwde
      .if eax ==  IDM_ASCII && w4 == WM_CHAR
         INVOKE     SetDlgItemText, hdlg, E1, offset szBuff
         INVOKE     SetDlgItemText, hdlg, E2, offset Misc
            jmp     AsciiDone
      .endif  
         cmp     eax, IDCANCEL
         jne     AsciiDone
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE
         jmp     AsciiRet
AsciiDone:
         and     w4, 0
         mov     eax, FALSE
AsciiRet:
         ret
AsciiDlg ENDP

;=========================================================================|
;     Converts ascii string of Dec, Hex, Oct or Bin to a REAL10 value.    |
;=========================================================================|
AsciiToFloat PROC
LOCAL    Min:DWORD, Base:DWORD 
      pushad
         and     Min, 0
         mov     Base, 10     
      INVOKE     lstrlen, ADDR Misc ; Input
         cmp     eax, 0
          je     GetOut
         xor     ecx, ecx

         mov     edx, offset Misc
      .while (eax)
      .if byte ptr [edx] == 2eh
            mov     byte ptr [edx], 2eh
      .elseif byte ptr [edx] == 2dh
            or     Min, 1
      .else
            sub     byte ptr [edx], 30h
      .endif
         inc     ecx
         inc     edx
         dec     eax
      .endw
      .if ecx == 0
            inc     ecx
      .endif    
         mov     ebx, offset Misc  ; Ascii string
         mov     esi, ebx
         add     esi, ecx          ; Set esi at the end of Buff
         dec     esi
      .if Min == 1
            dec     ecx
            inc     ebx
      .endif 
       finit
        fldz                       ; Initialize ST(0) = 0
Loop1:                             ; Loop before the decimal point
         xor     eax, eax          ; Set eax=0 for later
         mov     al, byte ptr[ebx]
         inc     ebx
         cmp     al, '.'
          je     Loop2
         mov     Hold, eax         ; Set Hold to number for loading
        fild     Base              ; Load base for adding next digit
       fmulp     ST(1), ST         ; ST(1)=ST(1)*ST & pop ST(0)
        fild     Hold              ; Load Hold integer to ST(0)
       faddp     ST(1), ST         ; ST(1)=ST(1)+ST & pop ST(0)
        loop     Loop1             ; Next part of loop
        fldz                       ; Load a zero for decimal places
         jmp     NoMore            ; No more characters
Loop2:                             ; Now esi is used for an index
        fldz                       ; Load another zero for the decimal portion
Loop3:                             ; The actual loop after the decimal point
         dec     ecx
          jz     NoMore            ; if out of characters or last one was a '.'
         mov     al, byte ptr[esi] ; get next character   *******************
         dec     esi
         mov     Hold,eax          ; Store to Hold
        fild     Hold              ; Load Hold
       faddp     ST(1), ST         ; Add new char to old value
        fild     Base              ; Load base
       fdivp     ST(1), ST         ; Divide by base to retain decimal
         jmp     Loop3
NoMore:
       faddp     ST(1), ST         ; Add integer & decimal
      .if Min == 1
           fchs
      .endif
        fstp     tbyte ptr[RNum10] ; Store real
GetOut:
       popad
         ret
AsciiToFloat ENDP

;========================================================================|
; Converts a Dec, Hex, Oct or Bin ascii string to a 32 bit num value.    |
;========================================================================|
AsciiBase PROC Input:DWORD, Output:DWORD, Base: DWORD
      pushad
mov     w6, 0
         mov     esi, Input
         mov     edi, Output
      INVOKE     lstrlen, Input
         xor     ecx, ecx
      .while (eax)
         .if byte ptr[esi+ecx] > 60h
               sub     byte ptr[esi+ecx], 57h
         .elseif byte ptr[esi+ecx] > 40h
               sub     byte ptr[esi+ecx], 37h
         .else
               xor     byte ptr[esi+ecx], 30h
         .endif
            dec     eax
            inc     ecx
      .endw
         mov     ebx, 1
         mov     esi, Input
         add     esi, ecx
         dec     esi
         xor     edx, edx
      .while (ecx)
            mov     al, byte ptr[esi]            ; Extract byte for conversion
            and     eax, 000000ffh
           imul     eax, ebx
            add     dword ptr[edi], eax          ; Accumulate output
           imul     ebx, Base
            dec     esi
            dec     ecx 
      .endw
       popad
          ret
AsciiBase ENDP

;=========================================================================|
;  Converts a 32 bit num value to a Dec, Hex, Oct or Bin ascii string.    |
;=========================================================================|
;INVOKE     BaseAscii, cnt, offset num, 2, 10, 0, 1, 0
BaseAscii PROC InPut:DWORD, OutPut:DWORD, LEN:DWORD, Base:DWORD, Comma:DWORD, Fill:DWORD, TermA:DWORD
LOCAL    LBuff[32]: BYTE

      pushad
         xor     esi, esi
         mov     eax, InPut                ; Input
         mov     ebx, OutPut
         mov     byte ptr [ebx], '0'
      .while (eax)
            xor     edx, edx
            div     Base                   ; Base 10, 16, 8, 2
         .if dl > 9h
               add     dl, 37h             ; Convert to hex ASCII
         .else
               add     dl, 30h             ; Convert to dec ASCII
         .endif
            mov     LBuff[esi], dl
            inc     esi
         .if Comma == 1 && Base == 10 && eax > 0
            .if esi == 3 || esi == 7 || esi == 11
                  mov     LBuff[esi], 2ch  ; Insert commas
                  inc     esi
            .endif
         .endif
      .endw
         xor     edi, edi
         mov     ecx, esi
      .if LEN > ecx && Fill == 1           ; Zero fill
            xor     eax, eax
         .while (eax < LEN)
               mov     byte ptr [ebx+eax], '0'
               inc     eax
         .endw
            sub     LEN, ecx
            add     edi, LEN
      .endif
      .while (ecx)
            mov     al, byte ptr LBuff[esi-1]
            mov     byte ptr [ebx+edi], al
            inc     edi
            dec     esi
            dec     ecx
      .endw
      .if TermA
         mov     byte ptr [ebx+edi], 0h
      .endif
       popad
          ret
BaseAscii ENDP

;=========================================================================
;*  Format the time and send it to the status bar                        *
;=========================================================================
fmtime   PROC
LOCAL            hEDC:DWORD
      INVOKE     BaseAscii, cnt, offset num, 2, 10, 0, 1, 0
         cmp     hWndStat, 0       ;valid statusbar?
          jz     ftimex            ;no, then exit
        push     offset time       ;get the local
        call     GetLocalTime      ;time from win32
       MOVmw     HoldT, time.wDay
      INVOKE     BaseAscii, HoldT, offset dda, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wMonth
      INVOKE     BaseAscii, HoldT, offset dmo, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wYear
      INVOKE     BaseAscii, HoldT, offset dyr, 2, 10, 0, 1, 0
         mov     byte ptr[tmsgampm],'A' ;default to AM
         cmp     time.wHour,  12        ;>12?
         jle     AM                     ;it's AM
         mov     byte ptr[tmsgampm],'P' ;reset to PM
         sub     time.wHour, 12         ;-12
AM:    MOVmw     HoldT, time.wHour
      INVOKE     BaseAscii, HoldT, offset tmsghour, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wMinute
      INVOKE     BaseAscii, HoldT, offset tmsgmin, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wSecond
      INVOKE     BaseAscii, HoldT, offset tmsgsec, 2, 10, 0, 1, 0
      INVOKE     GetDC, hWndStat
         mov     hEDC, eax
      INVOKE     SetTextColor, hEDC, 0000ff00h
      INVOKE     SetBkColor, hEDC, 00000000h
         mov     ebx, parts
        imul     ebx, 3
         add     ebx, 2
      INVOKE     TextOut, hEDC, ebx, 3, ADDR Clear, 63
      INVOKE     lstrlen, offset tmsg
         add     ebx, 85
      .if parts < 200
            sub     ebx, 35
      .endif
      INVOKE     TextOut, hEDC, ebx, 3, offset tmsg, eax
      INVOKE     ReleaseDC, hWndStat, hEDC
ftimex:  ret
fmtime   ENDP

;=========================================================================
;*  Generate error message                                               *
;*  eax = message # to display                                           *
;*  ebx = Title                                                          *
;*  ecx = MessageBox Flags                                               *
;=========================================================================
ErrorMsg PROC
        push     ecx
        push     ebx               ; Save these for after LoadString call
        push     lengthof szWork   ; Size of our buffer
        push     offset szWork     ; Buffer to load string into
        push     eax               ; Resource #
        push     hInst             ; Instance
        call     LoadString        ; Load the tip from STRINGTABLE
         cmp     eax, 0            ; Did we get a string?
         jne     Error1            ; yes, continue
         lea     eax, szNULL       ; null string
Error1: push     offset szWork
        push     0
        call     MessageBox
         ret
ErrorMsg ENDP

;========================================================================|
;*  Enable or disable the items in the toolbar                           *
;========================================================================|
EnableDisableToolbar PROC
      INVOKE     EnableDisableEditMenu, hMenu
      INVOKE     UpdateFormatMenuItems, hWnd
         ret
EnableDisableToolbar ENDP

;========================================================================|
;*  Enable or disable the items in the edit menu and toolbar             *
;========================================================================|
EnableDisableEditMenu PROC wparam:DWORD
      INVOKE     SendMessage, hREdit, EM_CANUNDO, 0, 0
         cmp     eax, TRUE
         jne     EdMu1
         mov     tempword, MF_ENABLED
         jmp     EdMu2
EdMu1:   mov     tempword, MF_GRAYED
EdMu2:
      INVOKE     EnableMenuItem, wparam, IDM_UNDO, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_UNDO, tempword
         xor     tempword, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_UNDO, tempword
      INVOKE     SendMessage, hREdit, EM_CANREDO, 0, 0
         cmp     eax, TRUE
         jne     EdMu3
         mov     tempword, MF_ENABLED
         jmp     EdMu4
EdMu3:   mov     tempword, MF_GRAYED
EdMu4:
      INVOKE     EnableMenuItem, wparam, IDM_REDO, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_REDO, tempword
         xor     tempword, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_REDO, tempword
      INVOKE     IsClipboardFormatAvailable, CF_TEXT
         cmp     eax, TRUE
         jne     EdMu5
         mov     tempword, MF_ENABLED
         jmp     EdMu6
EdMu5:   mov     tempword, MF_GRAYED
EdMu6:
      INVOKE     EnableMenuItem, wparam, IDM_PASTE, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_PASTE, tempword
         xor     tempword, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_PASTE, tempword
         mov     eax, SBook
         cmp     eax, EBook         ; If no selection then gray otherwise enable
          je     EdMu7
         mov     tempword, MF_ENABLED
         jmp     EdMu8
EdMu7:   mov     tempword, MF_GRAYED
EdMu8:
      INVOKE     EnableMenuItem, wparam, IDM_CUT, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_CUT, tempword
      INVOKE     EnableMenuItem, wparam, IDM_COPY, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_COPY, tempword
      INVOKE     EnableMenuItem, wparam, IDM_DEL, tempword
      INVOKE     EnableMenuItem, hSMenu, IDM_DEL, tempword
      INVOKE     EnableMenuItem, wparam, IDM_FINDNEXT, tempword
      INVOKE     EnableMenuItem, wparam, IDM_FINDPREV, tempword
         xor     tempword, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_CUT, tempword
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_COPY, tempword
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_DEL, tempword
      INVOKE     SendMessage, hWndToolF, TB_ENABLEBUTTON, IDM_FINDNEXT, tempword
      INVOKE     SendMessage, hWndToolF, TB_ENABLEBUTTON, IDM_FINDPREV, tempword
         ret
EnableDisableEditMenu ENDP

;========================================================================|
;*  Checks or Unchecks the menu item and toolbar based on the flags      *
;========================================================================|
UpdateFormatMenuItems PROC hwnd:DWORD
      INVOKE     SendMessage, hREdit, EM_GETPARAFORMAT, 0, offset pf
         cmp     pf.wAlignment, PFA_LEFT
          je     FoMu1
         xor     al, al
         jmp     FoMu2
FoMu1:   and     pf.wAlignment, PFA_LEFT
FoMu2:
      INVOKE     CheckUncheck, hwnd, IDM_LEFT
         cmp     pf.wAlignment, PFA_CENTER
          je     FoMu3
         xor     al, al
         jmp     FoMu4
FoMu3:   and     pf.wAlignment, PFA_CENTER
FoMu4:
      INVOKE     CheckUncheck, hwnd, IDM_CENTER
         cmp     pf.wAlignment, PFA_RIGHT
          je     FoMu5
         xor     al, al
         jmp     FoMu6
FoMu5:   and     pf.wAlignment, PFA_RIGHT
FoMu6:
      INVOKE     CheckUncheck, hwnd, IDM_RIGHT
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
        test     charF.dwEffects, CFE_BOLD
      INVOKE     CheckUncheck, hwnd, IDM_BOLD
        test     charF.dwEffects, CFE_ITALIC
      INVOKE     CheckUncheck, hwnd, IDM_ITALIC

      .if charF.bUnderlineType != CFU_UNDERLINEDOUBLE
           test     charF.dwEffects, CFE_UNDERLINE
         INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE
      .endif

         xor     eax, eax
      .if charF.bUnderlineType == CFU_UNDERLINEDOUBLE
            mov     al, charF.bUnderlineType
      .endif
        test     eax, CFU_UNDERLINEDOUBLE
        push     eax
      INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE2
         pop      eax
      .if eax
           test     eax, -4   ; Force unmatch
         INVOKE     CheckUncheck, hwnd, IDM_UNDERLINE
      .endif

        test     charF.dwEffects, CFE_STRIKEOUT
      INVOKE     CheckUncheck, hwnd, IDM_STRIKEOUT
         mov     eax, charF.yOffset
         cmp     eax, 0
         jg      FoMu7                   ; If greater than zero, then superscript
         xor     al, al                  ; Set the zero flag to indicate unchecked
FoMu7:
      INVOKE     CheckUncheck, hwnd, IDM_SUPERSCRIPT
         mov     eax, charF.yOffset
         cmp     eax, 0
          jl     FoMu8                   ; If less than zero, then is subscript
         xor     al, al                  ; Set the zero flag to indicate unchecked
FoMu8:
      INVOKE     CheckUncheck, hwnd, IDM_SUBSCRIPT
         mov     eax, 1
         mov     ebx, charF.yOffset
         cmp     ebx, 0
          je     FoMu9                   ; If equal to zero, then is norscript
         xor     al, al                  ; Set the zero flag to indicate unchecked
FoMu9:
         cmp     eax, 0
      INVOKE     CheckUncheck, hwnd, IDM_NORSCRIPT
         ret
UpdateFormatMenuItems ENDP

;========================================================================|
;*  Checks or Unchecks the menu item based on the flags                  *
;========================================================================|
CheckUncheck PROC hwnd:DWORD, MenuID:DWORD
         mov     ebx, MF_UNCHECKED or MF_BYCOMMAND
         mov     edx, FALSE
          jz     NotEqual
         mov     ebx, MF_CHECKED or MF_BYCOMMAND
         mov     edx, TRUE
NotEqual:
        push     edx             ;Last arg of SendMessage
      INVOKE     GetMenu, hwnd
      INVOKE     CheckMenuItem, eax, MenuID, ebx
         pop     edx
      INVOKE     SendMessage, hWndTool, TB_CHECKBUTTON, MenuID, edx
         ret
CheckUncheck ENDP

;========================================================================|
;*  Parses the command line and extracts the exe root dir and if         *
;*  available builds a full path name , file name, ext name and filling  *
;*  in the needed ofn words                                              *
;========================================================================|
ParseCommandLine PROC  uses edi
      INVOKE     lstrlen, CommandLine          ;Saved address of commandline
         mov     ecx, eax
         mov     edi, CommandLine              ;Saved address of commandline
      .if byte ptr[edi] == 22h
            jmp     GetRoot
      .endif
         sub     ecx, 2
         add     edi, 2
         mov     eax, 3ah                      ;Look for colon in commandline
       repnz     scasb
       jecxz     GetRoot                       ;Not from command or association
         add     ecx, 2
         sub     edi, 2
         mov     Len, ecx                      ;Save length of arg
        push     edi
      INVOKE     lstrcpy, offset PathName, edi ;Copy PathName
         pop     edi
         mov     ecx, Len
         mov     eax, 2eh                      ;Look for period in commandline
       repnz     scasb
        push     eax
      INVOKE     lstrcpy, offset ExtType, edi  ;Copy ExtType
         pop     eax
         mov     ofn.nFileExtension, ax
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase                     ;Convert to lowercase
      INVOKE     lstrlen, offset PathName
         lea     edi, PathName
         add     edi, eax
      .while (eax)
         .if byte ptr[edi] == 5ch              ;\
              .break 
         .endif
            dec     eax
            dec     edi
      .endw
         add     edi, 1
      INVOKE     lstrcpy, offset FileName, edi ;Copy FileName
GetRoot:
      INVOKE     lstrlen, CommandLine
         mov     edi, CommandLine
         add     edi, eax
         sub     edi, Len
      .while (eax)
         .if byte ptr[edi] == 5ch              ;\
              .break 
         .endif
            dec     eax
            dec     edi
      .endw
         add     edi, 2
         sub     edi, CommandLine
        push     edi
      INVOKE     lstrcpy, offset szWork, CommandLine
         pop     edi
         mov     eax, offset szWork
      .if szWork == 22h                        ;"
            inc     eax
            dec     edi
      .endif
      INVOKE     lstrcpyn, offset RootDir, eax, edi ;Copy RootDir
         ret
ParseCommandLine ENDP

;=========================================================================
;* Sets the initial characteristics to font=courier new, black, 9pt      *
;=========================================================================
SetCharFormatting PROC
      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, offset hReg, offset lpdwDisp

      INVOKE     RegQuery, offset rTC, TextC
         mov     charF.crTextColor, eax
         mov     TextC, eax
      INVOKE     RegQuery, offset rTBGC, TextBGC
         mov     charF.crBackColor, eax
         mov     TextBGC, eax
      INVOKE     RegQuery, offset rBC, BackGC
         mov     BackGC, eax
      INVOKE     RegQuery, offset szPoint, 180
.if !eax
      mov      eax, 180
.endif
         mov     charF.yHeight, eax
         mov     PointSize, eax
      INVOKE     RegQuery, offset szMask,\
                 CFM_OFFSET or CFM_BOLD or CFM_ITALIC or CFM_UNDERLINE or CFM_UNDERLINETYPE or\
                 CFM_STRIKEOUT or CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     charF.dwMask, eax
      INVOKE     RegQuery, offset szEffects, 0
         mov     charF.dwEffects, eax
      INVOKE     RegCloseKey, hReg
         mov     eax, BackGC
        test     PathName, 0ffh
         jnz     NotNew
         mov     charF.crBackColor, 0ffffffh
         mov     eax, 0ffffffh

NotNew:
      .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f'
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, eax
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
;call     GetInfoForCombos
      .endif
;call     GetInfoForCombos
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
      INVOKE     SetFocus, hREdit
         ret
SetCharFormatting ENDP

;=========================================================================
;* Set the title string in the main window                               *
;=========================================================================
SetTitle PROC
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
        push     eax
      INVOKE     lstrcpy, offset szBuff, offset pTitle
         cmp     PathName, 0
          je     NoFile
      INVOKE     lstrcat, offset szBuff, offset PathName
         jmp     TestDirty
NoFile:
      INVOKE     lstrcat, offset szBuff, offset szUntitled
TestDirty:
         pop     eax
         cmp     eax, FALSE
          je     NotDirty
      INVOKE     lstrlen, offset szBuff
         mov     dword ptr[szBuff+eax], 'HC  '
NotDirty:
      INVOKE     SetWindowText, hWnd, offset szBuff
Endit:
         ret
SetTitle ENDP

;========================================================================|
;*  Check if the file needs saving and prompt user for action            *
;========================================================================|
CheckSav PROC hwnd:DWORD
         and     OpnFlag, 0
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
      .if eax == 0
;            mov    eax, 0
      .else
         MsgBox     ERROR_SAVE_BEFORE_QUIT, szSaving,\
                    MB_YESNOCANCEL or MB_ICONEXCLAMATION or MB_SYSTEMMODAL  ;MB_APPLMODAL
         .if eax == IDYES
            INVOKE     SendMessage, hwnd, WM_COMMAND, IDM_SAVE, 0
               mov     eax, IDYES
         .elseif eax == IDNO
            INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
            .if PathName != 0
                 push     OA
                   or     OA, 1
                 call     OpenFileA
                  pop     OA
            .endif
               mov     eax, IDNO
         .else
               mov     eax, IDCANCEL
         .endif
      .endif
         mov     OpnFlag, eax
      ret
CheckSav ENDP

;=========================================================================
;*  StartNewDocument                                                     *
;=========================================================================
StartNewDocument PROC hwnd:DWORD
      INVOKE     CheckSav, hwnd
      .if OpnFlag == IDCANCEL ;!OpnFlag
            ret
      .endif
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
;        call     EnableDisableToolbar
;        ;;call    SetTitle
;        call     SetCharFormatting
         ret
StartNewDocument ENDP

;=========================================================================
;* Open file procedure                                                   *
;=========================================================================
OpenFileA  PROC
      INVOKE     StartNewDocument, hWnd
;         cmp     OpnFlag, 0
;          je     EndOpenA
      .if OpnFlag == IDCANCEL ;!OpnFlag
            jmp     EndOpenA
      .endif
         cmp     OA, 1
          je     OpenAssoc
      .if OA == 2
            mov     ofn.lpstrInitialDir, 0
            mov     PathName, 0
            jmp     PastSet
      .endif

      INVOKE     GetCurrentDirectory, lengthof CurDir, offset CurDir

         mov     ofn.lpstrDefExt, offset szExt
         mov     ofn.lpstrInitialDir, offset CurDir
PastSet:
         mov     ofn.lpstrFile, offset PathName
         mov     ofn.nMaxFile, lengthof PathName
         mov     ofn.lpstrFilter, offset szFilter
         mov     ofn.lpstrFileTitle, offset FileName
         mov     ofn.nMaxFileTitle, lengthof FileName
         mov     ofn.lpstrTitle, offset szOpenTitle
         mov     ofn.Flags, OFN_PATHMUSTEXIST or OFN_FILEMUSTEXIST
      INVOKE     GetOpenFileName, offset ofn
         cmp     eax, FALSE       ; Cancel'ed or error occurred
          je     EndOpen
         cmp     sw1, 4           ; From executable
          je     EndOpen

OpenAssoc:                        ; From file association or cmd line
      INVOKE     GetFileAttributes, addr PathName
         cmp     eax, 0ffffffffh
          je     operr
         mov     dwAttr, eax

      INVOKE     SetFileAttributes, addr PathName, FILE_ATTRIBUTE_ARCHIVE ; In case the file is read only

      INVOKE     CreateFile, ADDR PathName,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL

         cmp     eax, -1          ; Error?
         jne     opcrok

operr:
      MsgBox     ERROR_CREATE_FILE
      .if w5                    ; From menu file list
         INVOKE     ProcessMRUFiles, hWnd, 1, MenuCnt, addr PathName, addr szRedit  ; Delete the list file name
         INVOKE     lstrcpy, addr PathName, addr szWork
      .endif
         jmp     EndOpen

opcrok:
         mov     hFile, eax
         mov     EditS.dwCookie, eax
         mov     EditS.pfnCallback, offset EditStreamRead
         mov     EditS.dwError, 0
      INVOKE     SetFileAttributes, addr PathName, dwAttr

      INVOKE     lstrlen, ADDR PathName
      .if PathName[eax-5] == 2eh
            dec     eax
      .endif
      INVOKE     lstrcpy, ADDR ExtType, ADDR PathName[eax-3]
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase          ; Convert to lowercase for compare
         cmp     RTF, 0
          je     opntxt

      .if HG        ; Help Generator Work Window
         INVOKE     SendMessage, hREditW, EM_STREAMIN, SF_TEXT, offset EditS
         INVOKE     CloseHandle, hFile
         INVOKE     SendMessage, hREditW, EM_SETMODIFY, FALSE, 0
         INVOKE     SendMessage, hREditW, EM_EMPTYUNDOBUFFER, 0, 0
            and     HG, 0
            and     OA, 0
            ret
      .endif

      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            mov      w2, 00ffffffh  
            jmp      opnrtf
      .endif

opntxt:
      INVOKE     SendMessage, hAll, BM_SETCHECK, BST_CHECKED, 0    ; Sets UpdateAll to checked
      INVOKE     SendMessage, hSel, BM_SETCHECK, BST_UNCHECKED, 0  ; Sets UpdateSel to unchecked
      INVOKE     SendMessage, hREdit, EM_STREAMIN, SF_TEXT, offset EditS
         mov     UpdateAll, 1
         and     UpdateSel, 0
         mov     TextBG, 1
       MOVmd     w2, BackGC
         jmp     opnclos

opnrtf:
      INVOKE     SendMessage, hSel, BM_SETCHECK, BST_CHECKED, 0    ; Sets UpdateSel to checked
      INVOKE     SendMessage, hAll, BM_SETCHECK, BST_UNCHECKED, 0  ; Sets UpdateAll to unchecked
      INVOKE     SendMessage, hREdit, EM_STREAMIN, SF_RTF, offset EditS
        push     eax
         mov     UpdateSel, 1
         and     UpdateAll, 0
         and     TextBG, 0
      INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
         mov     ebx, TopLineP
         sub     ebx, eax
      INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, ebx ; Scroll parent to org pos
         pop     eax

opnclos:
         mov     bytesread, eax
      INVOKE     CloseHandle, hFile
       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, TextBGC
       MOVmd     charF.yHeight, PointSize
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
      .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f' || RTF == 0
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
      .endif
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, w2
      INVOKE     BaseAscii, bytesread, offset Fsize, 8, 10, 1, 0, 1
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, offset fsmsg
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
        call     SetTitle
      INVOKE     SetFocus, hREdit
      INVOKE     ProcessMRUFiles, hWnd, 0, MenuCnt, addr PathName, addr szRedit

EndOpen:
        call     EnableDisableToolbar
        call     SetCharFormatting
        call     SetInfoForCombos
      INVOKE     RichEditProc, hREdit, WM_LBUTTONUP, 0, 0
      INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0

EndOpenA:
         and     OA, 0
         and     sw1, 0
         and     w5, 0
           ret
OpenFileA  ENDP

;=========================================================================
;* Edit Stream In Callback procedure - read from a file                  *
;=========================================================================
EditStreamRead PROC uses ebx edi esi dwCookie:DWORD, pbBuff, cb, pcb
      INVOKE     ReadFile, dwCookie, pbBuff, cb, pcb, 0
         mov     ebx, pcb
         mov     eax, [ebx]          ; Get count read so far
         cmp     eax, cb             ; compare to amount needed
          jg     EditRet             ; if read <= size, then more to read later
         mov     eax, 0              ; otherwise, file completely read
EditRet: ret
EditStreamRead ENDP

;=========================================================================
;* Edit Stream In Callback procedure - read from memory to a control     *
;=========================================================================
EditStreamRead4 PROC  uses ebx esi edi  dwCookie:DWORD, pbBuff, cb, pcb
         mov     ecx, cb             ; Block size for this callback
      .if BytesO > ecx
            sub     BytesO, ecx      ; BytesO = total bytes to read
      .else
            mov     ecx, BytesO
            and     BytesO, 0
      .endif
         mov     eax, pcb
         mov     dword ptr[eax], ecx ; Actual bytes read for this callback
         mov     esi, dwCookie       ; Input
         add     esi, Hold           ; Apply offset to the input buffer
         mov     edi, pbBuff         ; OutPut, doesn't need the offset??
         add     Hold, ecx           ; Hold = accum offset for input buffer
         rep     movsb
      .if !BytesO
            mov     eax, 0           ; Must return Zero for it to work
      .else
            mov     eax, 0 ;1        ; Must return Zero for it to work
      .endif
EditRet: ret
EditStreamRead4 ENDP

;=========================================================================
;* Save file procedure                                                   *
;=========================================================================
SaveFile PROC

      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
            lea     eax, offset szFootF
            mov     ft.lpstrText, eax
            mov     ebx, FR_DOWN or FR_MATCHCASE
         INVOKE     SendMessage, hREdit, EM_FINDTEXT, ebx, addr ft
         .if eax != -1
            INVOKE    MessageBox, NULL, addr szHCW, addr class, MB_YESNO or MB_ICONWARNING
            .if eax == IDNO
                  jmp     EndSave
            .else
               INVOKE     RepairRTF, hWnd, hInst, hFont
               .if hHelpGen
                      or     HG, 1
                      or     OA, 1
                    call     OpenFileA
               .endif
                  jmp     EndSave
            .endif
         .endif
      .endif
         cmp     sw1, 1
          je     SaveAs
         mov     al, PathName
         cmp     al, 0
         jne     dosave2
         mov     ofn.Flags, OFN_PATHMUSTEXIST or OFN_FILEMUSTEXIST
         jmp     dosave1
SaveAs:
         mov     ofn.Flags, OFN_OVERWRITEPROMPT or OFN_CREATEPROMPT
dosave1:
      .if PathName == 0
         INVOKE     lstrcpy, addr PathName, addr RootDir
         INVOKE     lstrcat, addr PathName, addr Patn
      .endif
         mov     ofn.lStructSize, sizeof ofn
         mov     eax, hWnd
         mov     ofn.hwndOwner, eax
         mov     eax, hInst
         mov     ofn.hInstance, eax
         mov     ofn.lpstrFilter, offset szFilter
         mov     ofn.lpstrFile, offset PathName
         mov     ofn.nMaxFile, lengthof PathName
         mov     ofn.lpstrInitialDir, 0
         mov     ofn.lpstrTitle, offset szSaveTitle
         mov     ofn.lpstrDefExt, 0  ;offset szExt
      INVOKE     GetSaveFileName, offset ofn
         cmp     eax, FALSE               ;Cancel'ed or error occurred
          je     EndSave

dosave2:
         mov     dwAttr, FILE_ATTRIBUTE_ARCHIVE
      INVOKE     GetFileAttributes, addr PathName
         cmp     eax, 0ffffffffh
          je     crFile  ;saverr
         mov     dwAttr, eax
      INVOKE     SetFileAttributes, addr PathName, FILE_ATTRIBUTE_ARCHIVE ; In case the file is read only

crFile:

      INVOKE     CreateFile, ADDR PathName,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
         cmp     eax, -1                  ;Error?
         jne     savcrok

saverr:
      MsgBox     ERROR_CREATE_FILE
         jmp     EndSave

savcrok:
         mov     hFile, eax
         mov     EditS.dwCookie, eax
         mov     EditS.dwError, 0
         mov     EditS.pfnCallback, offset EditStreamWrite
         cmp     RTF, 0
          je     savtxt
      INVOKE     lstrlen, ADDR PathName
      INVOKE     lstrcpy, ADDR ExtType, ADDR PathName[eax-3]
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase                ;Convert to lowercase for compare
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            jmp      savrtf
      .endif
savtxt:
      .if sw1 == 3       ; From work window
         INVOKE     SendMessage, hREditW, EM_STREAMOUT, SF_TEXT, offset EditS
      .elseif sw1 == 4   ; From repair window
         INVOKE     SendMessage, hREditF, EM_STREAMOUT, SF_TEXT, offset EditS
      .else
         INVOKE     SendMessage, hREdit, EM_STREAMOUT, SF_TEXT, offset EditS
      .endif
         mov     bytesread, eax
         jmp     savclose
savrtf:
      INVOKE     SendMessage, hREdit, EM_STREAMOUT, SF_RTF, offset EditS
         mov     bytesread, eax
      .if hHelpGen
         INVOKE     SendMessage,  hREdit, EM_SETMODIFY, FALSE, 0
             or     HG, 1
             or     OA, 1
           call     OpenFileA
      .endif

savclose:
      INVOKE     CloseHandle, hFile

      INVOKE     SetFileAttributes, addr PathName, dwAttr

        call     EnableDisableToolbar
      INVOKE     SendMessage,  hREdit, EM_SETMODIFY, FALSE, 0
      .if sw2 == 1                ; From backup dir
         INVOKE     lstrcpy, offset CurDir, offset LineBuff
         INVOKE     lstrcpy, offset PathName, offset szWork
         INVOKE     SetCurrentDirectory, offset CurDir
      .endif
        call     SetTitle
      INVOKE     BaseAscii, bytesread, offset Fsize, 8, 10, 1, 0, 1
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, offset fsmsg
EndSave:
         and     sw1, 0
         and     sw2, 0
         ret
SaveFile ENDP

;=========================================================================
;* Edit Stream Out Callback procedure - write to a file                  * 
;=========================================================================
EditStreamWrite PROC dwCookie:DWORD, pbBuff, cb, pcb
      INVOKE     WriteFile, dwCookie, pbBuff, cb, pcb, 0
         mov     eax, 0              ; File completely read
         ret
EditStreamWrite ENDP

;=========================================================================
;* Edit Stream Out Callback procedure - write to memory from a control   *
;=========================================================================
EditStreamWrite4 PROC  uses ebx esi edi  dwCookie:DWORD, pbBuff, cb, pcb
;      INVOKE     CopyMemory, dwCookie, pbBuff, cb
         mov     ecx, cb             ; Block size for this callback
         mov     ebx, ecx
         mov     edi, dwCookie       ; Output
         add     edi, Hold           ; Apply offset to the output buffer
         mov     esi, pbBuff         ; InPut, doesn't need the offset??
         rep     movsb
         mov     eax, pcb            ; Pointer to pcb
         mov     dword ptr[eax], ebx ; Actual bytes written for this callback
         add     Hold, ebx           ; Hold = accum offset for input buffer
         mov     eax, 0              ; Must return zero
         ret
EditStreamWrite4 ENDP

;=========================================================================
;* Word Wrap procedure                                                   *
;=========================================================================
WordWrap PROC
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
      .if eax
            and     sw1, 0
           call     SaveFile
      .endif

      INVOKE     DestroyWindow, hREdit
      INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_BYCOMMAND
         and     WWrap, 0
      .if eax == MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_UNCHECKED
         INVOKE     CreateWin, WS_EX_CLIENTEDGE, ADDR richedit, WS_CHILD or WS_VISIBLE or ES_LEFT or ES_MULTILINE or\
                    ES_NOHIDESEL or ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or WS_HSCROLL or\
                    ES_AUTOVSCROLL or ES_AUTOHSCROLL or WS_TABSTOP,
                    0, 0, 0, 0, hWnd, ID_EDITWINDOW
      .else
            or      WWrap, 1
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_CHECKED
         INVOKE     CreateWin, WS_EX_CLIENTEDGE, ADDR richedit, WS_CHILD or WS_VISIBLE or ES_LEFT or ES_MULTILINE or\
                    ES_NOHIDESEL or ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or\
                    ES_AUTOVSCROLL or WS_TABSTOP,
                    0, 0, 0, 0, hWnd, ID_EDITWINDOW
      .endif

      INVOKE     SendMessage, hREdit, EM_SETEVENTMASK, 0, ENM_CHANGE or ENM_SELCHANGE or\
                 ENM_MOUSEEVENTS or ENM_KEYEVENTS or ENM_DROPFILES

      INVOKE     GetClientRect, hWnd, ADDR rect
         add     rect.top, 65
         sub     rect.bottom, 87
      INVOKE     MoveWindow, hREdit, rect.left, rect.top, rect.right, rect.bottom, TRUE
         mov     rect.left, 11
         sub     rect.top, 61
         sub     rect.bottom, 8
      INVOKE     SendMessage, hREdit, EM_SETRECT, 0, offset rect
      INVOKE     SetFocus, hREdit
        test     PathName, 0ffh
          jz     WordWrapRet
          or     OA, 1
        call     OpenFileA
WordWrapRet:
         ret
WordWrap ENDP

;=========================================================================
;* Read file for selected text or ini file procedure                     *
;=========================================================================
readp   PROC
      .if hpMem > 0
         INVOKE     GlobalUnlock, fpMem
         INVOKE     GlobalFree, hpMem
            mov     hpMem, 0
      .endif
      INVOKE     CreateFile, ADDR szWork,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,\
                 NULL
         mov     hFile,eax
      INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, sMemSize
         mov     hpMem, eax
      INVOKE     GlobalLock, hpMem
         mov     fpMem, eax
      INVOKE     ReadFile, hFile, fpMem, sMemSize, ADDR bytesread, NULL
      INVOKE     CloseHandle, hFile
         ret
readp   ENDP

;=========================================================================
;* Build Small Memory File procedure                                     *
;=========================================================================
BuildfsMem  PROC     STDCALL
      .if hsMem > 0
         INVOKE     GlobalUnlock, fsMem
         INVOKE     GlobalFree, hsMem
            mov     hsMem, 0
      .endif
         INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, sMemSize
            mov     hsMem, eax
         INVOKE     GlobalLock, hsMem            
            mov     fsMem, eax
            ret
BuildfsMem  ENDP

;=========================================================================
;* Page Setup Dialog Procedure                                           *
;=========================================================================
DoPageSU PROC
         mov     psd.lStructSize, sizeof psd
        push     hWnd
         pop     psd.hwndOwner
        push     hInst
         pop     psd.hInstance
         mov     psd.Flags, PSD_MARGINS or PSD_INTHOUSANDTHSOFINCHES or PSD_DISABLEPAPER or PSD_DISABLEPRINTER
      INVOKE     PageSetupDlg, offset psd
         cmp     eax,0
          jz     NSU
       finit
         mov     al, psd.rtMargin[0]
         mov     ah, psd.rtMargin[1]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mL
         mov     al, psd.rtMargin[4]
         mov     ah, psd.rtMargin[5]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mT
         mov     al, psd.rtMargin[8]
         mov     ah, psd.rtMargin[9]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mR
         mov     al, psd.rtMargin[12]
         mov     ah, psd.rtMargin[13]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mB
         sub     mL, 360
         sub     mT, 360
         sub     mR, 360
         sub     mB, 302
NSU:
         ret
DoPageSU ENDP

;=========================================================================
;* Build print heading procedure                                         *
;=========================================================================
HeadProc PROC
      INVOKE     BaseAscii, cnt, offset num, 2, 10, 0, 1, 0
      INVOKE     lstrcpy, ADDR LineBuff, ADDR Space1
      INVOKE     lstrcpy, ADDR LineBuff, ADDR Head 
      INVOKE     lstrcat, ADDR LineBuff, ADDR Space1
         lea     eax, LineBuff
         mov     ecx, 97 ;110
         sub     ecx, 33
         add     eax, ecx
      .if PH <= 1
            add     eax, 26
            jmp     PageNum
      .endif
      INVOKE     lstrcpyn, eax, offset dmsg, 11
         add     eax, 10
      INVOKE     lstrcpyn, eax, offset Space2, 10
         add     eax, 2
      INVOKE     lstrcpyn, eax, offset tmsg, 12
         add     eax, 11
      INVOKE     lstrcpyn, eax, offset Space2, 10
         add     eax, 3
PageNum: 
      INVOKE     lstrcpyn, eax, offset Page1, 8
      INVOKE     lstrlen, ADDR LineBuff
         mov     Len, eax
         ret
HeadProc ENDP

;=========================================================================
;* Print document procedure                                              *
;=========================================================================
PrintProc PROC
LOCAL    Chg: DWORD, TextSize
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
         mov     sw2, 6
      INVOKE     DialogBoxParam, hInst, IDD_PRTHEAD, hWnd, offset CommonDlg, 0
        push     cf.rgbColors
         mov     cf.rgbColors, 0
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00ffffffh
         pop     cf.rgbColors
         cmp     PrtColor, 1
          je     StartPrt
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
      INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
;          or     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     charF.crTextColor, 0
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
StartPrt:
         mov     cnt, 0
         mov     pd.lStructSize, sizeof pd
         mov     eax, hWnd
         mov     pd.hwndOwner, eax
         mov     eax, hInst
         mov     pd.hInstance, eax
         ;mov     pd.Flags, PD_RETURNDC or PD_NOSELECTION or PD_PRINTSETUP
         mov     pd.Flags, PD_RETURNDC
      INVOKE     PrintDlg, offset pd
         cmp     eax, FALSE
          je     PrtRet
         mov     eax, pd.Flags
         mov     ebx, eax
         and     ebx, 000000ffh
         mov     Sel, ebx
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
         mov     eax, cr.cpMax
      .if eax > cr.cpMin && Sel != 1
         MsgBox  ERROR_NO_SELECTION, szSelect, MB_YESNO or MB_ICONQUESTION
            cmp     eax, IDNO
             je     PrtRet
      .endif
         mov     doci.cbSize, sizeof doci
         mov     doci.lpszDocName, offset pTitle
         mov     doci.lpszOutput, 0
         mov     doci.fwType, 0
         mov     eax, pd.hDC
         mov     fr.hdc, eax
         mov     fr.hdcTarget, eax  ;0
      INVOKE     GetDeviceCaps, fr.hdc, LOGPIXELSX ;Number of pixels per logical inch along the screen width.
         mov     xPerInch, eax
      INVOKE     GetDeviceCaps, fr.hdc, LOGPIXELSY ;Number of pixels per logical inch along the screen height.
         mov     yPerInch, eax
         mov     eax, mL             ;Min is 360
         mov     rect.left, eax
         mov     eax, mT             ;Min is 360
         mov     rect.top, eax
      .if PrtHead
            add     rect.top, 420 ;360
      .endif
      INVOKE     GetDeviceCaps, fr.hdc, HORZRES    ;Width, in pixels, of the screen.
         mov     ecx, 1440
         mul     ecx
         div     xPerInch
         mov     rect.right, eax
         mov     eax, mR             ;Min is 360
         sub     rect.right, eax
      INVOKE     GetDeviceCaps, fr.hdc, VERTRES    ;Height, in raster lines, of the screen.
         mov     ecx, 1440
         mul     ecx
         div     yPerInch
         mov     rect.bottom, eax
         mov     eax, mB             ;Min is 302
         sub     rect.bottom, eax
         mov     ecx, 16
         mov     edi, offset fr.rcPage
         mov     esi, offset rect
         cld
         rep     movsb
;INVOKE     SetMapMode, pd.hDC, MM_TEXT
      INVOKE     StartDoc, pd.hDC, offset doci
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
         mov     eax, cr.cpMin
         mov     ebx, cr.cpMax
      .if ebx > eax && Sel == 1
            mov     fr.chrg.cpMin, eax
            mov     fr.chrg.cpMax, ebx
            mov     TextSize, ebx
      .else
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
            mov     cr.cpMin, 0
            mov     cr.cpMax, -1
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, offset cr
          MOVmd     fr.chrg.cpMin, cr.cpMin
            mov     fr.chrg.cpMax, -1
          MOVmd     TextSize, cr.cpMax 
            mov     cr.cpMin, 0
            mov     cr.cpMax, 0
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, offset cr
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      .endif

prtloop:
      INVOKE     StartPage, pd.hDC
         cmp     eax, 0
         jle     prtabort
      .if PrtHead
            add     cnt, 1
           call     HeadProc 
         INVOKE     SelectObject, pd.hDC, pFont
         INVOKE     TextOut, pd.hDC, pX, pY, offset LineBuff, Len     ;Print heading line
      .endif
         mov     ecx, 16
         mov     esi, offset rect
         mov     edi, offset fr.rc                                    ;Actual print page dimensions
         cld
         rep     movsb
      INVOKE     SendMessage, hREdit, EM_FORMATRANGE, TRUE, offset fr ;Print page
         mov     fr.chrg.cpMin, eax
      INVOKE     EndPage, pd.hDC
         cmp     eax, 0
         jle     prtabort
         mov     eax, fr.chrg.cpMin
         cmp     eax, 0
         jle     prtdone
         cmp     eax, TextSize
          jl     prtloop

prtdone:
      INVOKE     SendMessage, hREdit, EM_FORMATRANGE, 0, 0
      INVOKE     EndDoc, pd.hDC
      INVOKE     DeleteDC, pd.hDC
         jmp     PrtRet
prtabort:
      INVOKE     AbortDoc, fr.hdc
PrtRet:
      .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f' || RTF == 0
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
          MOVmd     charF.crTextColor, TextC
         INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, offset charF
      .endif
       MOVmd     EBook, SBook
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         ret
PrintProc ENDP

;========================================================================|
;*  Registry Save                                                        *
;========================================================================|
RegSave PROC
LOCAL    hRegK:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegK, offset lpdwDisp

      INVOKE     RegSet, offset szSaveWhen, SaveWhen
      INVOKE     RegSet, offset szSetFlags, SetFlags
      INVOKE     RegSet, offset szWordWrap, WWrap
      INVOKE     RegSet, offset szMaxWin, MaxWin

        call     GetDesktopWindow
      INVOKE     GetWindowRect, eax, offset rect
        push     rect.right
      INVOKE     GetWindowRect, hWnd, offset rect
         pop     eax
         cmp     eax, rect.right
         jle     NoSavePos
      INVOKE     RegSet, offset szLeft, rect.left
      INVOKE     RegSet, offset szRight, rect.right
      INVOKE     RegSet, offset szTop, rect.top
      INVOKE     RegSet, offset szBottom, rect.bottom

NoSavePos:
      INVOKE     lstrlen, offset szHWS
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegK, offset szHWSName, 0, REG_SZ, offset szHWS, lpcbData
      INVOKE     RegSetValueEx, hRegK, offset szAthName, 0, REG_SZ, offset szAth, lpcbData
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            jmp      SkipFormat
      .endif
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, offset charF
      INVOKE     lstrlen, offset FontName  ;charF.szFaceName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegK, offset szFont, 0, REG_SZ, offset FontName, lpcbData
      INVOKE     RegSet, offset szPoint, PointSize ;charF.yHeight
      INVOKE     RegSet, offset szMask, charF.dwMask
      INVOKE     RegSet, offset szEffects, charF.dwEffects

      INVOKE     RegSet, offset rTC, TextC
      INVOKE     RegSet, offset rTBGC, TextBGC
      INVOKE     RegSet, offset rBC, BackGC

SkipFormat:
      INVOKE     RegCloseKey, hRegK
         ret
RegSave ENDP

;=========================================================================
;* Return the integer value in eax from the registry                     *
;=========================================================================
RegQuery PROC   szValueName:DWORD, Default:DWORD
      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0, KEY_WRITE or KEY_READ, 0, offset hReg, offset lpdwDisp
         mov     lpcbData, 4
         mov     eax, szValueName
         lea     ebx, Default
      INVOKE     RegQueryValueEx, hReg, eax, 0, offset lpType, ebx, offset lpcbData
      INVOKE     RegCloseKey, hReg
         mov     eax, Default
         ret
RegQuery ENDP

;=========================================================================
;* Sets the specified value in the registry                              *
;=========================================================================
RegSet PROC szValueName:DWORD, Value:DWORD
      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, offset szRedit, 0, offset szREGSZ, 0, KEY_WRITE or KEY_READ, 0, offset hReg, offset lpdwDisp
         mov     lpcbData, 4
         mov     eax, szValueName
         lea     ebx, Value
      INVOKE     RegSetValueEx, hReg, eax, 0, REG_DWORD, ebx, lpcbData
      INVOKE     RegCloseKey, hReg
         ret
RegSet ENDP
         end     start
;DSPValue hWnd, eax, 1, 'm'
;INVOKE     MessageBox,NULL, addr pTitle, addr pTitle, MB_OK

