; GetSeg library 1.0 [03/05/01]
; GetSegStr function
; Extracts a segment from a string
; By Digital Monkey (dmonkey@edsamail.com.ph)

.386
.model flat, STDCALL

; INCLUDE FILES
include		\masm32\include\kernel32.inc
include		\masm32\include\windows.inc
include         \masm32\include\masm32.inc
; LIBRARY
includelib	\masm32\lib\kernel32.lib
includelib      \masm32\lib\masm32.lib



GetSegStr PROTO :DWORD,:DWORD,:BYTE,:DWORD


.code

GetSegStr proc in_str:DWORD, seg_num:DWORD, delim:BYTE, out_str:DWORD
LOCAL dummy_str[1024]:BYTE
                 
invoke lstrcpyn, ADDR dummy_str, [in_str], 1024  ; Copy in_str contents to dummy_str
                                               ; take note of the 1024 byte read limit
invoke lstrcat, ADDR dummy_str, ADDR delim ; add delimiting character
                                           ; to the last part of the string     
                                           ; to count the last segment
mov al, delim
lea edi, dummy_str
mov ecx, sizeof dummy_str

mov ebx, 0     ; keeps the end index
mov edx, 0
jmp dscan

reload:         ; reload till segment is reached
mov edx, ebx    ; keeps the start read index
inc edx
inc ebx
dscan:
dec ecx     ; decrease counter
cmp byte ptr dummy_str[edx], NULL ; checks if scasb goes beyond the string
je error

scasb       ; scan for delimiting character
je found    ; found delimiting character?

inc ebx     ; no, increase base pointer (array's index)
jmp dscan   ; scan for delimiting character again

found:      ; found delimiting character
dec seg_num     ;
cmp seg_num, 0  ; is it our segment?
jne reload  ; no, reload

        ; technique that eliminates the last characters from the delimiting
        ; character next to our delimiting character to end of string

mov al, NULL
lea edi, dummy_str[ebx] ; clean unneeded portion
mov ecx, ebx
rep stosb


error:     ; segment out of range
; to access field, use dummy_str[edx]
invoke lstrcpy, [out_str], ADDR dummy_str[edx]
ret
GetSegStr endp
end
