; GetSeg library 1.0
; GetSegCount function


.386
.model flat, STDCALL

; INCLUDE FILES
include		\masm32\include\kernel32.inc
include		\masm32\include\windows.inc

; LIBRARY
includelib	\masm32\lib\kernel32.lib


GetSegCount PROTO :DWORD,:BYTE

.code
GetSegCount proc in_str:DWORD, delim:BYTE
LOCAL dummy_str[1024]:BYTE
LOCAL ctr:DWORD
xor ebx, ebx
mov ctr, 0

invoke lstrcpyn, ADDR dummy_str, [in_str], 1024  ; Copy in_str contents to dummy_str
invoke lstrcat, ADDR dummy_str, ADDR delim ; add delimiting character
                                           ; to the last part of the string     
                                           ; to count the last segment
mov al, delim
lea edi, dummy_str
mov ecx, sizeof dummy_str

reload:     ; reload 
add ctr, 1
dscan:
inc ebx
cmp byte ptr dummy_str[ebx], NULL ; checks if scasb goes beyond the string
je Done                          ; terminator

scasb       ; scan for delimiting character
je reload    ; Found delimiting character?
jmp dscan

Done:  ; Done scanning!
mov eax, ctr

ret
GetSegCount endp

end
