; Example3.asm: A Simple Random Password Generator (8 characters)

.386
.model flat, STDCALL

; INCLUDE FILES
include		\masm32\include\kernel32.inc
include		\masm32\include\windows.inc
include         \masm32\include\user32.inc
include         getseg.inc  ; Our include file

; LIBRARY
includelib	\masm32\lib\kernel32.lib
includelib      \masm32\lib\user32.lib
includelib      getseg.lib  ; Our include file

; random number generating function
Random PROTO :DWORD,:DWORD

.data
msg_caption     db "Random password generator",0
my_data         db "a:b:c:d:e:f:g:h:i:j:k:l:m:n:o:p:q:r:s:"
                db "t:u:v:w:x:y:z:A:B:C:D:E:F:G:H:I:J:K:L:"
                db "M:N:O:P:Q:R:S:T:U:V:W:X:Y:Z:0:1:2:3:4:"
                db "5:6:7:8:9",0   ; The table where you would get the characters

out_data        db 123 dup(0) ; where GetSegStr would place it's output
pass_out        db 123 dup(0) ; would hold random password
ctr             dd 0    ; loop counter
.code
start:

Passloop:

invoke Random, 1,62                                     ; random number generator function 
invoke GetSegStr, ADDR my_data, eax, ":", ADDR out_data ; get a random character from the table
invoke lstrcat, ADDR pass_out, ADDR out_data            ; add character to pass_out
invoke Sleep, 10 ; for random numgen function (GetTickCount)
add ctr, 1       ; increment loop counter
cmp ctr, 8       ; does pass_out contain 8 characters already?
jne Passloop     ; nah, add some more random character
Done:

; Display randomly generated password
invoke MessageBox, NULL, ADDR pass_out, ADDR msg_caption, MB_OK


; got this random number generator function from some masm board posting

Random PROC first:DWORD,second:DWORD
LOCAL rand:DWORD

invoke GetTickCount
mov rand, eax

mov ebx,second
sub ebx,first
inc ebx
xor edx,edx
mov eax,rand
div ebx
add rand,eax
add edx,first
mov eax,edx
ret

Random ENDP

invoke ExitProcess,0
end start
