;Example4: Reading by line from a file
;          *reads only up to 1024 bytes     
.386
.model flat, STDCALL

; INCLUDE FILES
include		\masm32\include\kernel32.inc
include		\masm32\include\windows.inc
include         \masm32\include\user32.inc
include         getseg.inc

; LIBRARY
includelib	\masm32\lib\kernel32.lib
includelib      \masm32\lib\user32.lib
includelib      getseg.lib


.data
msg_caption     db "GetSeg Library",0
err_msg         db "Error opening file!",0
file_data       db 1024 dup(0)    ; input
out_data        db 1024 dup(0)    ; output
file_name       db "ex4.txt",0    ; our file to read
f_handle        dd 0    ; file handle
seg_count       dd 0    ; holds file_data segment count
ctr             dd 0    ; counter for our while loop

.code
start:
invoke _lopen, ADDR file_name, OF_READ ; open our file for reading
cmp eax, -1   ; does it exist?
je error      ; nope
mov f_handle, eax   ; yep, store handle to f_handle

invoke _lread, f_handle, ADDR file_data, 1024  ; read file (1024 byte limit)
invoke _lclose, f_handle   ; close handle

invoke GetSegCount, ADDR file_data, 10 ; count the segments with carriage
                                       ; return (10h) as delimiting character
mov seg_count, eax ; store count to seg_count

.WHILE seg_count>1 ; loop to display the lines
inc ctr            ; starting from the top
invoke GetSegStr, ADDR file_data, ctr, 10, ADDR out_data ; get em
invoke MessageBox, NULL, ADDR out_data, ADDR msg_caption, MB_OK ; display em
dec seg_count  ; decrease counter
.ENDW


invoke ExitProcess,0 ; done!
error: ; error
invoke MessageBox, NULL, ADDR err_msg, NULL, MB_OK+MB_ICONWARNING
invoke ExitProcess, 0
end start
