;---------------------------------------;
;	DDRAW include file					;
;										;
;	Author :  Ewald Snel				;
;	Copyright (C) 1999, Diamond Crew	;
;										;
;	http://here.is/diamond/				;
;---------------------------------------;


STDMETHOD	MACRO	name, argl :VARARG
LOCAL @tmp_a
LOCAL @tmp_b

@tmp_a	TYPEDEF PROTO argl
@tmp_b	TYPEDEF PTR @tmp_a
name		@tmp_b		?
ENDM

DDINVOKE	MACRO	func, this, arglist :VARARG
	mov			eax , [this]
	mov			eax , [eax]

	IFB <arglist>
		INVOKE [IDirectDrawVtbl. func][eax], this
	ELSE
		INVOKE [IDirectDrawVtbl. func][eax], this, arglist
	ENDIF
ENDM

DDSINVOKE	MACRO	func, this, arglist :VARARG
	mov			eax , [this]
	mov			eax , [eax]

	IFB <arglist>
		INVOKE [IDirectDrawSurfaceVtbl. func][eax], this
	ELSE
		INVOKE [IDirectDrawSurfaceVtbl. func][eax], this, arglist
	ENDIF
ENDM



DirectDrawCreate		PROTO :DWORD, :DWORD, :DWORD
DirectDrawCreateClipper	PROTO :DWORD, :DWORD, :DWORD
DirectDrawEnumerateA	PROTO :DWORD, :DWORD
DirectDrawEnumerate		EQU		<DirectDrawEnumerateA>

EXTERNDEF	C CLSID_DirectDraw:GUID
EXTERNDEF	C CLSID_DirectDrawClipper:GUID
EXTERNDEF	C IID_IDirectDraw:GUID
EXTERNDEF	C IID_IDirectDrawSurface:GUID
EXTERNDEF	C IID_IDirectDrawPalette:GUID
EXTERNDEF	C IID_IDirectDrawClipper:GUID

LPDIRECTDRAW			TYPEDEF		PTR IDirectDraw
LPDIRECTDRAWSURFACE		TYPEDEF		PTR IDirectDrawSurface
LPDIRECTDRAWPALETTE		TYPEDEF		PTR IDirectDrawPalette
LPDIRECTDRAWCLIPPER		TYPEDEF		PTR IDirectDrawClipper
LPDDFXROP				TYPEDEF		PTR DDFXROP
LPDDSURFACEDESC			TYPEDEF		PTR DDSURFACEDESC
LPDDSURFACEDESC2		TYPEDEF		PTR DDSURFACEDESC2
LPDDCAPS				TYPEDEF		PTR DDCAPS
LPDDBLTFX				TYPEDEF		PTR DDBLTFX
LPDDSCAPS				TYPEDEF		PTR DDSCAPS
LPDDSCAPS2				TYPEDEF		PTR DDSCAPS2
LPDDCOLORKEY			TYPEDEF		PTR DDCOLORKEY
LPDDOVERLAYFX			TYPEDEF		PTR DDOVERLAYFX
LPDDPIXELFORMAT			TYPEDEF		PTR DDPIXELFORMAT
LPDDBLTBATCH			TYPEDEF		PTR DDBLTBATCH

; windows defines
LPRECT					TYPEDEF		PTR RECT
LPPALETTEENTRY			TYPEDEF		PTR PALETTEENTRY
LPRGNDATA				TYPEDEF		PTR RGNDATA


DDCOLORKEY	STRUC
	dwColorSpaceLowValue		DWORD		?
	dwColorSpaceHighValue		DWORD		?
DDCOLORKEY	ENDS


DDBLTFX		STRUC
	dwSize						DWORD		?
	dwDDFX						DWORD		?
	dwROP						DWORD		?
	dwDDROP						DWORD		?
	dwRotationAngle				DWORD		?
	dwZBufferOpCode				DWORD		?
	dwZBufferLow				DWORD		?
	dwZBufferHigh				DWORD		?
	dwZBufferBaseDest			DWORD		?
	dwZDestConstBitDepth		DWORD		?
UNION
	dwZDestConst				DWORD		?
	lpDDSZBufferDest			LPDIRECTDRAWSURFACE		?
ENDS
	dwZSrcConstBitDepth			DWORD		?
UNION
	dwZSrcConst					DWORD		?
	lpDDSZBufferSrc				LPDIRECTDRAWSURFACE		?
ENDS
	dwAlphaEdgeBlendBitDepth	DWORD		?
	dwAlphaEdgeBlend			DWORD		?
	dwReserved					DWORD		?
	dwAlphaDestConstBitDepth	DWORD		?
UNION
	dwAlphaDestConst			DWORD		?
	lpDDSAlphaDest				LPDIRECTDRAWSURFACE		?
ENDS
	dwAlphaSrcConstBitDepth		DWORD		?
UNION
	dwAlphaSrcConst				DWORD		?
	lpDDSAlphaSrc				LPDIRECTDRAWSURFACE		?
ENDS
UNION
	dwFillColor					DWORD		?
	dwFillDepth					DWORD		?
	lpDDSPattern				LPDIRECTDRAWSURFACE		?
ENDS
	ddckDestColorkey			DDCOLORKEY		<>
	ddckSrcColorkey				DDCOLORKEY		<>
DDBLTFX		ENDS


DDSCAPS		STRUC
	dwCaps			DWORD		?
DDSCAPS		ENDS

DDSCAPS2	STRUC
	dwCaps    	DWORD    ?      
    dwCaps2		DWORD    ?       
    dwCaps3		DWORD    ?       
    dwCaps4		DWORD    ?        
DDSCAPS2	ENDS

DDCAPS		STRUC
	dwSize							DWORD		?
	dwCaps							DWORD		?
	dwCaps2							DWORD		?
	dwCKeyCaps						DWORD		?
	dwFXCaps						DWORD		?
	dwFXAlphaCaps					DWORD		?
	dwPalCaps						DWORD		?
	dwSVCaps						DWORD		?
	dwAlphaBltConstBitDepths		DWORD		?
	dwAlphaBltPixelBitDepths		DWORD		?
	dwAlphaBltSurfaceBitDepths		DWORD		?
	dwAlphaOverlayConstBitDepths	DWORD		?
	dwAlphaOverlayPixelBitDepths	DWORD		?
	dwAlphaOverlaySurfaceBitDepths	DWORD		?
	dwZBufferBitDepths				DWORD		?
	dwVidMemTotal					DWORD		?
	dwVidMemFree					DWORD		?
	dwMaxVisibleOverlays			DWORD		?
	dwCurrVisibleOverlays			DWORD		?
	dwNumFourCCCodes				DWORD		?
	dwAlignBoundarySrc				DWORD		?
	dwAlignSizeSrc					DWORD		?
	dwAlignBoundaryDest				DWORD		?
	dwAlignSizeDest					DWORD		?
	dwAlignStrideAlign				DWORD		?
	dwRops							DWORD		8 DUP (?)
	ddsCaps							DDSCAPS		<>
	dwMinOverlayStretch				DWORD		?
	dwMaxOverlayStretch				DWORD		?
	dwMinLiveVideoStretch			DWORD		?
	dwMaxLiveVideoStretch			DWORD		?
	dwMinHwCodecStretch				DWORD		?
	dwMaxHwCodecStretch				DWORD		?
	dwReserved1						DWORD		?
	dwReserved2						DWORD		?
	dwReserved3						DWORD		?
	dwSVBCaps						DWORD		?
	dwSVBCKeyCaps					DWORD		?
	dwSVBFXCaps						DWORD		?
	dwSVBRops						DWORD		8 DUP (?)
	dwVSBCaps						DWORD		?
	dwVSBCKeyCaps					DWORD		?
	dwVSBFXCaps						DWORD		?
	dwVSBRops						DWORD		8 DUP (?)
	dwSSBCaps						DWORD		?
	dwSSBCKeyCaps					DWORD		?
	dwSSBFXCaps						DWORD		?
	dwSSBRops						DWORD		8 DUP (?)
	dwReserved4						DWORD		?
	dwReserved5						DWORD		?
	dwReserved6						DWORD		?
DDCAPS		ENDS


DDOVERLAYFX		STRUC
	dwSize						DWORD		?
	dwAlphaEdgeBlendBitDepth	DWORD		?
	dwAlphaEdgeBlend			DWORD		?
	dwReserved					DWORD		?
	dwAlphaDestConstBitDepth	DWORD		?
UNION
	dwAlphaDestConst			DWORD		?
	lpDDSAlphaDest				LPDIRECTDRAWSURFACE		?
ENDS
	dwAlphaSrcConstBitDepth		DWORD		?
UNION
	dwAlphaSrcConst				DWORD		?
	lpDDSAlphaSrc				LPDIRECTDRAWSURFACE		?
ENDS
	dckDestColorkey				DDCOLORKEY		<>
	dckSrcColorkey				DDCOLORKEY		<>
	dwDDFX						DWORD		?
	dwFlags						DWORD		?
DDOVERLAYFX		ENDS


DDPIXELFORMAT	STRUC
	dwSize				DWORD		?
	dwFlags				DWORD		?
	dwFourCC			DWORD		?
UNION
	dwRGBBitCount		DWORD		?
	dwYUVBitCount		DWORD		?
	dwZBufferBitDepth	DWORD		?
	dwAlphaBitDepth		DWORD		?
ENDS
UNION
	dwRBitMask			DWORD		?
	dwYBitMask			DWORD		?
ENDS
UNION
	dwGBitMask			DWORD		?
	dwUBitMask			DWORD		?
ENDS
UNION
	dwBBitMask			DWORD		?
	dwVBitMask			DWORD		?
ENDS
UNION
	dwRGBAlphaBitMask	DWORD		?
	dwYUVAlphaBitMask	DWORD		?
ENDS
DDPIXELFORMAT	ENDS


DDSURFACEDESC	STRUC
	dwSize				DWORD		?
	dwFlags				DWORD		?
	dwHeight			DWORD		?
	dwWidth				DWORD		?
	lPitch				DWORD		?
	dwBackBufferCount	DWORD		?
UNION
	dwMipMapCount		DWORD		?
	dwZBufferBitDepth	DWORD		?
	dwRefreshRate		DWORD		?
ENDS
	dwAlphaBitDepth		DWORD		?
	dwReserved			DWORD		?
	lpSurface			DWORD		?
	ddckCKDestOverlay	DDCOLORKEY		<>
	ddckCKDestBlt		DDCOLORKEY		<>
	ddckCKSrcOverlay	DDCOLORKEY		<>
	ddckCKSrcBlt		DDCOLORKEY		<>
	ddpfPixelFormat		DDPIXELFORMAT	<>
	ddsCaps				DDSCAPS			<>
DDSURFACEDESC	ENDS


DDSURFACEDESC2	STRUC 
	dwSize				DWORD		?
	dwFlags				DWORD		?
	dwHeight			DWORD		?
	dwWidth				DWORD		?
UNION    
	lPitch				DWORD		?
    dwLinearSize		DWORD		?
ENDS
    dwBackBufferCount	DWORD		?
UNION
	dwMipMapCount		DWORD		?
	dwRefreshRate		DWORD		?
ENDS
	dwAlphaBitDepth		DWORD		?
	dwReserved			DWORD		?
	lpSurface			DWORD		?
UNION
	ddckCKDestOverlay   DDCOLORKEY		<>
    dwEmptyFaceColor	DWORD		?
ENDS
    ddckCKDestBlt		DDCOLORKEY		<>    
    ddckCKSrcOverlay	DDCOLORKEY		<>    
    ddckCKSrcBlt		DDCOLORKEY		<>
    ddpfPixelFormat		DDPIXELFORMAT	<> 
    ddsCaps				DDSCAPS2		<>      
    dwTextureStage		DWORD		?
DDSURFACEDESC2 ENDS


DDBLTBATCH	STRUC
	lprDest			LPRECT		?
	lpDDSSrc		LPDIRECTDRAWSURFACE		?
	lprSrc			LPRECT		?
	dwFlags			DWORD		?
	lpDDBltFx		LPDDBLTFX	?
DDBLTBATCH	ENDS




IDirectDrawVtbl	STRUC
	; IUnknown methods
	STDMETHOD	QueryInterface, :PTR IDirectDraw, :PTR, :PTR PTR
	STDMETHOD	AddRef, :PTR IDirectDraw
	STDMETHOD	Release, :PTR IDirectDraw
	; IDirectDraw methods
	STDMETHOD	Compact, :PTR IDirectDraw
	STDMETHOD	CreateClipper, :PTR IDirectDraw, :DWORD, :PTR LPDIRECTDRAWCLIPPER, :PTR IUnknown
	STDMETHOD	CreatePalette, :PTR IDirectDraw, :DWORD, :LPPALETTEENTRY, :PTR LPDIRECTDRAWPALETTE, :PTR IUnknown
	STDMETHOD	CreateSurface, :PTR IDirectDraw, :LPDDSURFACEDESC, :PTR LPDIRECTDRAWSURFACE, :PTR IUnknown
	STDMETHOD	DuplicateSurface, :PTR IDirectDraw, :LPDIRECTDRAWSURFACE, :PTR LPDIRECTDRAWSURFACE
	STDMETHOD	EnumDisplayModes, :PTR IDirectDraw, :DWORD, :LPDDSURFACEDESC, :PTR , :PTR
	STDMETHOD	EnumSurfaces, :PTR IDirectDraw, :DWORD, :LPDDSURFACEDESC, :PTR , :PTR
	STDMETHOD	FlipToGDISurface, :PTR IDirectDraw
	STDMETHOD	GetCaps, :PTR IDirectDraw, :LPDDCAPS, :LPDDCAPS
	STDMETHOD	GetDisplayMode, :PTR IDirectDraw, :LPDDSURFACEDESC
	STDMETHOD	GetFourCCCodes, :PTR IDirectDraw, :PTR DWORD, :PTR DWORD
	STDMETHOD	GetGDISurface, :PTR IDirectDraw, :PTR LPDIRECTDRAWSURFACE
	STDMETHOD	GetMonitorFrequency, :PTR IDirectDraw, :DWORD
	STDMETHOD	GetScanLine, :PTR IDirectDraw, :DWORD
	STDMETHOD	GetVerticalBlankStatus, :PTR IDirectDraw, :PTR SWORD
	STDMETHOD	Initialize, :PTR IDirectDraw, :PTR GUID
	STDMETHOD	RestoreDisplayMode, :PTR IDirectDraw
	STDMETHOD	SetCooperativeLevel, :PTR IDirectDraw, :HWND, :DWORD
	STDMETHOD	SetDisplayMode, :PTR IDirectDraw, :DWORD, :DWORD, :DWORD
	STDMETHOD	WaitForVerticalBlank, :PTR IDirectDraw, :DWORD, :PTR
IDirectDrawVtbl	ENDS


IDirectDrawPaletteVtbl	STRUC
	; IUnknown methods
	STDMETHOD	QueryInterface, :PTR IDirectDrawPalette, :PTR, :PTR PTR
	STDMETHOD	AddRef, :PTR IDirectDrawPalette
	STDMETHOD	Release, :PTR IDirectDrawPalette
	; IDirectDrawPalette methods
	STDMETHOD	GetCaps, :PTR IDirectDrawPalette, :PTR DWORD
	STDMETHOD	GetEntries, :PTR IDirectDrawPalette, :DWORD, :DWORD, :DWORD, :LPPALETTEENTRY
	STDMETHOD	Initialize, :PTR IDirectDrawPalette, :LPDIRECTDRAW, :DWORD, :LPPALETTEENTRY
	STDMETHOD	SetEntries, :PTR IDirectDrawPalette, :DWORD, :DWORD, :DWORD, :LPPALETTEENTRY
IDirectDrawPaletteVtbl	ENDS


IDirectDrawClipperVtbl	STRUC
	; IUnknown methods
	STDMETHOD	QueryInterface, :PTR IDirectDrawClipper, :PTR, :PTR PTR
	STDMETHOD	AddRef, :PTR IDirectDrawClipper
	STDMETHOD	Release, :PTR IDirectDrawClipper
	; IDirectDrawClipper methods
	STDMETHOD	GetClipList, :PTR IDirectDrawClipper, :LPRECT, :LPRGNDATA, :PTR DWORD
	STDMETHOD	GetHWnd, :PTR IDirectDrawClipper, :PTR HWND
	STDMETHOD	Initialize, :PTR IDirectDrawClipper, :LPDIRECTDRAW, :DWORD
	STDMETHOD	IsClipListChanged, :PTR IDirectDrawClipper, :PTR SWORD
	STDMETHOD	SetClipList, :PTR IDirectDrawClipper, :LPRGNDATA, :DWORD
	STDMETHOD	SetHWnd, :PTR IDirectDrawClipper, :DWORD, :HWND
IDirectDrawClipperVtbl	ENDS


IDirectDrawSurfaceVtbl	STRUC
	; IUnknown methods
	STDMETHOD	QueryInterface, :PTR IDirectDrawSurface, :PTR, :PTR PTR
	STDMETHOD	AddRef, :PTR IDirectDrawSurface
	STDMETHOD	Release, :PTR IDirectDrawSurface
	; IDirectDrawSurface methods
	STDMETHOD	AddAttachedSurface, :PTR IDirectDrawSurface, :LPDIRECTDRAWSURFACE
	STDMETHOD	AddOverlayDirtyRect, :PTR IDirectDrawSurface, :LPRECT
	STDMETHOD	Blt, :PTR IDirectDrawSurface, :LPRECT, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD, :LPDDBLTFX
	STDMETHOD	BltBatch, :PTR IDirectDrawSurface, :LPDDBLTBATCH, :DWORD, :DWORD
	STDMETHOD	BltFast, :PTR IDirectDrawSurface, :DWORD, :DWORD, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD
	STDMETHOD	DeleteAttachedSurface, :PTR IDirectDrawSurface, :DWORD, :LPDIRECTDRAWSURFACE
	STDMETHOD	EnumAttachedSurfaces, :PTR IDirectDrawSurface, :PTR , :PTR
	STDMETHOD	EnumOverlayZOrders, :PTR IDirectDrawSurface, :DWORD, :PTR , :PTR
	STDMETHOD	Flip, :PTR IDirectDrawSurface, :LPDIRECTDRAWSURFACE, :DWORD
	STDMETHOD	GetAttachedSurface, :PTR IDirectDrawSurface, :LPDDSCAPS, :PTR LPDIRECTDRAWSURFACE
	STDMETHOD	GetBltStatus, :PTR IDirectDrawSurface, :DWORD
	STDMETHOD	GetCaps, :PTR IDirectDrawSurface, :LPDDSCAPS
	STDMETHOD	GetClipper, :PTR IDirectDrawSurface, :PTR LPDIRECTDRAWCLIPPER
	STDMETHOD	GetColorKey, :PTR IDirectDrawSurface, :DWORD, :LPDDCOLORKEY
	STDMETHOD	GetDC, :PTR IDirectDrawSurface, :PTR HDC
	STDMETHOD	GetFlipStatus, :PTR IDirectDrawSurface, :DWORD
	STDMETHOD	GetOverlayPosition, :PTR IDirectDrawSurface, :PTR DWORD, :PTR DWORD
	STDMETHOD	GetPalette, :PTR IDirectDrawSurface, :PTR LPDIRECTDRAWPALETTE
	STDMETHOD	GetPixelFormat, :PTR IDirectDrawSurface, :LPDDPIXELFORMAT
	STDMETHOD	GetSurfaceDesc, :PTR IDirectDrawSurface, :LPDDSURFACEDESC
	STDMETHOD	Initialize, :PTR IDirectDrawSurface, :LPDIRECTDRAW, :LPDDSURFACEDESC
	STDMETHOD	IsLost, :PTR IDirectDrawSurface
	STDMETHOD	mLock, :PTR IDirectDrawSurface, :LPRECT, :LPDDSURFACEDESC, :DWORD, :PTR 
	STDMETHOD	ReleaseDC, :PTR IDirectDrawSurface, :HDC
	STDMETHOD	Restore, :PTR IDirectDrawSurface
	STDMETHOD	SetClipper, :PTR IDirectDrawSurface, :LPDIRECTDRAWCLIPPER
	STDMETHOD	SetColorKey, :PTR IDirectDrawSurface, :DWORD, :LPDDCOLORKEY
	STDMETHOD	SetOverlayPosition, :PTR IDirectDrawSurface, :SDWORD, :SDWORD
	STDMETHOD	SetPalette, :PTR IDirectDrawSurface, :LPDIRECTDRAWPALETTE
	STDMETHOD	Unlock, :PTR IDirectDrawSurface, :PTR 
	STDMETHOD	UpdateOverlay, :PTR IDirectDrawSurface, :LPRECT, :LPDIRECTDRAWSURFACE, :LPRECT, :DWORD, :LPDDOVERLAYFX
	STDMETHOD	UpdateOverlayDisplay, :PTR IDirectDrawSurface, :DWORD
	STDMETHOD	UpdateOverlayZOrder, :PTR IDirectDrawSurface, :DWORD, :LPDIRECTDRAWSURFACE
IDirectDrawSurfaceVtbl	ENDS


IDirectDraw				STRUC
	lpVtbl		DWORD		?
IDirectDraw				ENDS

IDirectDrawPalette		STRUC
	lpVtbl		DWORD		?
IDirectDrawPalette		ENDS

IDirectDrawClipper		STRUC
	lpVtbl		DWORD		?
IDirectDrawClipper		ENDS

IDirectDrawSurface		STRUC
	lpVtbl		DWORD		?
IDirectDrawSurface		ENDS



; Direct Draw Capability Flags
DDSD_CAPS				EQU		000000001h
DDSD_HEIGHT				EQU		000000002h
DDSD_WIDTH				EQU		000000004h
DDSD_PITCH				EQU		000000008h
DDSD_BACKBUFFERCOUNT	EQU		000000020h
DDSD_ZBUFFERBITDEPTH	EQU		000000040h
DDSD_ALPHABITDEPTH		EQU		000000080h
DDSD_PIXELFORMAT		EQU		000001000h
DDSD_CKDESTOVERLAY		EQU		000002000h
DDSD_CKDESTBLT			EQU		000004000h
DDSD_CKSRCOVERLAY		EQU		000008000h
DDSD_CKSRCBLT			EQU		000010000h
DDSD_MIPMAPCOUNT		EQU		000020000h
DDSD_REFRESHRATE		EQU		000040000h
DDSD_ALL				EQU		00007f9eeh		; all input field are valid

; DIRECTDRAWSURFACE CAPABILITY FLAGS
DDSCAPS_3D					EQU		000000001h
DDSCAPS_ALPHA				EQU		000000002h
DDSCAPS_BACKBUFFER			EQU		000000004h
DDSCAPS_COMPLEX				EQU		000000008h
DDSCAPS_FLIP				EQU		000000010h
DDSCAPS_FRONTBUFFER			EQU		000000020h
DDSCAPS_OFFSCREENPLAIN		EQU		000000040h
DDSCAPS_OVERLAY				EQU		000000080h
DDSCAPS_PALETTE				EQU		000000100h
DDSCAPS_PRIMARYSURFACE		EQU		000000200h
DDSCAPS_PRIMARYSURFACELEFT	EQU		000000400h
DDSCAPS_SYSTEMMEMORY		EQU		000000800h
DDSCAPS_TEXTURE				EQU		000001000h
DDSCAPS_3DDEVICE			EQU		000002000h
DDSCAPS_VIDEOMEMORY			EQU		000004000h
DDSCAPS_VISIBLE				EQU		000008000h
DDSCAPS_WRITEONLY			EQU		000010000h
DDSCAPS_ZBUFFER				EQU		000020000h
DDSCAPS_OWNDC				EQU		000040000h
DDSCAPS_LIVEVIDEO			EQU		000080000h
DDSCAPS_HWCODEC				EQU		000100000h
DDSCAPS_MODEX				EQU		000200000h
DDSCAPS_MIPMAP				EQU		000400000h
DDSCAPS_ALLOCONLOAD			EQU		004000000h

; DIRECTDRAW DRIVER CAPABILITY FLAGS
DDCAPS_3D					EQU		000000001h
DDCAPS_ALIGNBOUNDARYDEST	EQU		000000002h
DDCAPS_ALIGNSIZEDEST		EQU		000000004h
DDCAPS_ALIGNBOUNDARYSRC		EQU		000000008h
DDCAPS_ALIGNSIZESRC			EQU		000000010h
DDCAPS_ALIGNSTRIDE			EQU		000000020h
DDCAPS_BLT					EQU		000000040h
DDCAPS_BLTQUEUE				EQU		000000080h
DDCAPS_BLTFOURCC			EQU		000000100h
DDCAPS_BLTSTRETCH			EQU		000000200h
DDCAPS_GDI					EQU		000000400h
DDCAPS_OVERLAY				EQU		000000800h
DDCAPS_OVERLAYCANTCLIP		EQU		000001000h
DDCAPS_OVERLAYFOURCC		EQU		000002000h
DDCAPS_OVERLAYSTRETCH		EQU		000004000h
DDCAPS_PALETTE				EQU		000008000h
DDCAPS_PALETTEVSYNC			EQU		000010000h
DDCAPS_READSCANLINE			EQU		000020000h
DDCAPS_STEREOVIEW			EQU		000040000h
DDCAPS_VBI					EQU		000080000h
DDCAPS_ZBLTS				EQU		000100000h
DDCAPS_ZOVERLAYS			EQU		000200000h
DDCAPS_COLORKEY				EQU		000400000h
DDCAPS_ALPHA				EQU		000800000h
DDCAPS_COLORKEYHWASSIST		EQU		001000000h
DDCAPS_NOHARDWARE			EQU		002000000h
DDCAPS_BLTCOLORFILL			EQU		004000000h
DDCAPS_BANKSWITCHED			EQU		008000000h
DDCAPS_BLTDEPTHFILL			EQU		010000000h
DDCAPS_CANCLIP				EQU		020000000h
DDCAPS_CANCLIPSTRETCHED		EQU		040000000h
DDCAPS_CANBLTSYSMEM			EQU		080000000h

; DIRECTDRAW FX ALPHA CAPABILITY FLAGS
DDFXALPHACAPS_BLTALPHAEDGEBLEND			EQU		000000001h
DDFXALPHACAPS_BLTALPHAPIXELS			EQU		000000002h
DDFXALPHACAPS_BLTALPHAPIXELSNEG			EQU		000000004h
DDFXALPHACAPS_BLTALPHASURFACES			EQU		000000008h
DDFXALPHACAPS_BLTALPHASURFACESNEG		EQU		000000010h
DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND		EQU		000000020h
DDFXALPHACAPS_OVERLAYALPHAPIXELS		EQU		000000040h
DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG		EQU		000000080h
DDFXALPHACAPS_OVERLAYALPHASURFACES		EQU		000000100h
DDFXALPHACAPS_OVERLAYALPHASURFACESNEG	EQU		000000200h

; DIRECTDRAW FX CAPABILITY FLAGS
DDFXCAPS_BLTARITHSTRETCHY		EQU		000000020h
DDFXCAPS_BLTARITHSTRETCHYN		EQU		000000010h
DDFXCAPS_BLTMIRRORLEFTRIGHT		EQU		000000040h
DDFXCAPS_BLTMIRRORUPDOWN		EQU		000000080h
DDFXCAPS_BLTROTATION			EQU		000000100h
DDFXCAPS_BLTROTATION90			EQU		000000200h
DDFXCAPS_BLTSHRINKX				EQU		000000400h
DDFXCAPS_BLTSHRINKXN			EQU		000000800h
DDFXCAPS_BLTSHRINKY				EQU		000001000h
DDFXCAPS_BLTSHRINKYN			EQU		000002000h
DDFXCAPS_BLTSTRETCHX			EQU		000004000h
DDFXCAPS_BLTSTRETCHXN			EQU		000008000h
DDFXCAPS_BLTSTRETCHY			EQU		000010000h
DDFXCAPS_BLTSTRETCHYN			EQU		000020000h
DDFXCAPS_OVERLAYARITHSTRETCHY	EQU		000040000h
DDFXCAPS_OVERLAYARITHSTRETCHYN	EQU		000000008h
DDFXCAPS_OVERLAYSHRINKX			EQU		000080000h
DDFXCAPS_OVERLAYSHRINKXN		EQU		000100000h
DDFXCAPS_OVERLAYSHRINKY			EQU		000200000h
DDFXCAPS_OVERLAYSHRINKYN		EQU		000400000h
DDFXCAPS_OVERLAYSTRETCHX		EQU		000800000h
DDFXCAPS_OVERLAYSTRETCHXN		EQU		001000000h
DDFXCAPS_OVERLAYSTRETCHY		EQU		002000000h
DDFXCAPS_OVERLAYSTRETCHYN		EQU		004000000h
DDFXCAPS_OVERLAYMIRRORLEFTRIGHT	EQU		008000000h
DDFXCAPS_OVERLAYMIRRORUPDOWN	EQU		010000000h

; DIRECTDRAW STEREO VIEW CAPABILITIES
DDSVCAPS_ENIGMA		EQU		000000001h
DDSVCAPS_FLICKER	EQU		000000002h
DDSVCAPS_REDBLUE	EQU		000000004h
DDSVCAPS_SPLIT		EQU		000000008h

; DIRECTDRAWPALETTE CAPABILITIES
DDPCAPS_4BIT				EQU		000000001h
DDPCAPS_8BITENTRIES			EQU		000000002h
DDPCAPS_8BIT				EQU		000000004h
DDPCAPS_INITIALIZE			EQU		000000008h
DDPCAPS_PRIMARYSURFACE		EQU		000000010h
DDPCAPS_PRIMARYSURFACELEFT	EQU		000000020h
DDPCAPS_ALLOW256			EQU		000000040h
DDPCAPS_VSYNC				EQU		000000080h
DDPCAPS_1BIT				EQU		000000100h
DDPCAPS_2BIT				EQU		000000200h

; DIRECTDRAW BITDEPTH CONSTANTS
DDBD_1		EQU		000004000h
DDBD_2		EQU		000002000h
DDBD_4		EQU		000001000h
DDBD_8		EQU		000000800h
DDBD_16		EQU		000000400h
DDBD_24		EQU		000000200h
DDBD_32		EQU		000000100h

; DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS
DDCKEY_COLORSPACE	EQU		000000001h
DDCKEY_DESTBLT		EQU		000000002h
DDCKEY_DESTOVERLAY	EQU		000000004h
DDCKEY_SRCBLT		EQU		000000008h
DDCKEY_SRCOVERLAY	EQU		000000010h

; DIRECTDRAW COLOR KEY CAPABILITY FLAGS
DDCKEYCAPS_DESTBLT					EQU		000000001h
DDCKEYCAPS_DESTBLTCLRSPACE			EQU		000000002h
DDCKEYCAPS_DESTBLTCLRSPACEYUV		EQU		000000004h
DDCKEYCAPS_DESTBLTYUV				EQU		000000008h
DDCKEYCAPS_DESTOVERLAY				EQU		000000010h
DDCKEYCAPS_DESTOVERLAYCLRSPACE		EQU		000000020h
DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV	EQU		000000040h
DDCKEYCAPS_DESTOVERLAYONEACTIVE		EQU		000000080h
DDCKEYCAPS_DESTOVERLAYYUV			EQU		000000100h
DDCKEYCAPS_SRCBLT					EQU		000000200h
DDCKEYCAPS_SRCBLTCLRSPACE			EQU		000000400h
DDCKEYCAPS_SRCBLTCLRSPACEYUV		EQU		000000800h
DDCKEYCAPS_SRCBLTYUV				EQU		000001000h
DDCKEYCAPS_SRCOVERLAY				EQU		000002000h
DDCKEYCAPS_SRCOVERLAYCLRSPACE		EQU		000004000h
DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV	EQU		000008000h
DDCKEYCAPS_SRCOVERLAYONEACTIVE		EQU		000010000h
DDCKEYCAPS_SRCOVERLAYYUV			EQU		000020000h
DDCKEYCAPS_NOCOSTOVERLAY			EQU		000040000h

; DIRECTDRAW PIXELFORMAT FLAGS
DDPF_ALPHAPIXELS		EQU		000000001h
DDPF_ALPHA				EQU		000000002h
DDPF_FOURCC				EQU		000000004h
DDPF_PALETTEINDEXED4	EQU		000000008h
DDPF_PALETTEINDEXEDTO8	EQU		000000010h
DDPF_PALETTEINDEXED8	EQU		000000020h
DDPF_RGB				EQU		000000040h
DDPF_COMPRESSED			EQU		000000080h
DDPF_RGBTOYUV			EQU		000000100h
DDPF_YUV				EQU		000000200h
DDPF_ZBUFFER			EQU		000000400h
DDPF_PALETTEINDEXED1	EQU		000000800h
DDPF_PALETTEINDEXED2	EQU		000001000h

; DIRECTDRAW ENUMSURFACES FLAGS
DDENUMSURFACES_ALL			EQU		000000001h
DDENUMSURFACES_MATCH		EQU		000000002h
DDENUMSURFACES_NOMATCH		EQU		000000004h
DDENUMSURFACES_CANBECREATED	EQU		000000008h
DDENUMSURFACES_DOESEXIST	EQU		000000010h

; DIRECTDRAW ENUMDISPLAYMODES FLAGS
DDEDM_REFRESHRATES		EQU		000000001h

; DIRECTDRAW SETCOOPERATIVELEVEL FLAGS
DDSCL_FULLSCREEN		EQU		000000001h
DDSCL_ALLOWREBOOT		EQU		000000002h
DDSCL_NOWINDOWCHANGES	EQU		000000004h
DDSCL_NORMAL			EQU		000000008h
DDSCL_EXCLUSIVE			EQU		000000010h
DDSCL_ALLOWMODEX		EQU		000000040h

; DIRECTDRAW BLT FLAGS
DDBLT_ALPHADEST					EQU		000000001h
DDBLT_ALPHADESTCONSTOVERRIDE	EQU		000000002h
DDBLT_ALPHADESTNEG				EQU		000000004h
DDBLT_ALPHADESTSURFACEOVERRIDE	EQU		000000008h
DDBLT_ALPHAEDGEBLEND			EQU		000000010h
DDBLT_ALPHASRC					EQU		000000020h
DDBLT_ALPHASRCCONSTOVERRIDE		EQU		000000040h
DDBLT_ALPHASRCNEG				EQU		000000080h
DDBLT_ALPHASRCSURFACEOVERRIDE	EQU		000000100h
DDBLT_ASYNC						EQU		000000200h
DDBLT_COLORFILL					EQU		000000400h
DDBLT_DDFX						EQU		000000800h
DDBLT_DDROPS					EQU		000001000h
DDBLT_KEYDEST					EQU		000002000h
DDBLT_KEYDESTOVERRIDE			EQU		000004000h
DDBLT_KEYSRC					EQU		000008000h
DDBLT_KEYSRCOVERRIDE			EQU		000010000h
DDBLT_ROP						EQU		000020000h
DDBLT_ROTATIONANGLE				EQU		000040000h
DDBLT_ZBUFFER					EQU		000080000h
DDBLT_ZBUFFERDESTCONSTOVERRIDE	EQU		000100000h
DDBLT_ZBUFFERDESTOVERRIDE		EQU		000200000h
DDBLT_ZBUFFERSRCCONSTOVERRIDE	EQU		000400000h
DDBLT_ZBUFFERSRCOVERRIDE		EQU		000800000h
DDBLT_WAIT						EQU		001000000h
DDBLT_DEPTHFILL					EQU		002000000h

; BLTFAST FLAGS
DDBLTFAST_NOCOLORKEY		EQU		000000000h
DDBLTFAST_SRCCOLORKEY		EQU		000000001h
DDBLTFAST_DESTCOLORKEY		EQU		000000002h
DDBLTFAST_WAIT				EQU		000000010h

; FLIP FLAGS
DDFLIP_WAIT		EQU		000000001h

; DIRECTDRAW SURFACE OVERLAY FLAGS
DDOVER_ALPHADEST				EQU		000000001h
DDOVER_ALPHADESTCONSTOVERRIDE	EQU		000000002h
DDOVER_ALPHADESTNEG				EQU		000000004h
DDOVER_ALPHADESTSURFACEOVERRIDE	EQU		000000008h
DDOVER_ALPHAEDGEBLEND			EQU		000000010h
DDOVER_ALPHASRC					EQU		000000020h
DDOVER_ALPHASRCCONSTOVERRIDE	EQU		000000040h
DDOVER_ALPHASRCNEG				EQU		000000080h
DDOVER_ALPHASRCSURFACEOVERRIDE	EQU		000000100h
DDOVER_HIDE						EQU		000000200h
DDOVER_KEYDEST					EQU		000000400h
DDOVER_KEYDESTOVERRIDE			EQU		000000800h
DDOVER_KEYSRC					EQU		000001000h
DDOVER_KEYSRCOVERRIDE			EQU		000002000h
DDOVER_SHOW						EQU		000004000h
DDOVER_ADDDIRTYRECT				EQU		000008000h
DDOVER_REFRESHDIRTYRECTS		EQU		000010000h
DDOVER_REFRESHALL				EQU		000020000h
DDOVER_DDFX						EQU		000080000h

; DIRECTDRAWSURFACE LOCK FLAGS
DDLOCK_SURFACEMEMORYPTR	EQU		000000000h
DDLOCK_WAIT				EQU		000000001h
DDLOCK_EVENT			EQU		000000002h
DDLOCK_READONLY			EQU		000000010h
DDLOCK_WRITEONLY		EQU		000000020h

; DIRECTDRAWSURFACE BLT FX FLAGS
DDBLTFX_ARITHSTRETCHY	EQU		000000001h
DDBLTFX_MIRRORLEFTRIGHT	EQU		000000002h
DDBLTFX_MIRRORUPDOWN	EQU		000000004h
DDBLTFX_NOTEARING		EQU		000000008h
DDBLTFX_ROTATE180		EQU		000000010h
DDBLTFX_ROTATE270		EQU		000000020h
DDBLTFX_ROTATE90		EQU		000000040h
DDBLTFX_ZBUFFERRANGE	EQU		000000080h
DDBLTFX_ZBUFFERBASEDEST	EQU		000000100h

; DIRECTDRAWSURFACE OVERLAY FX FLAGS
DDOVERFX_ARITHSTRETCHY		EQU		000000001h
DDOVERFX_MIRRORLEFTRIGHT	EQU		000000002h
DDOVERFX_MIRRORUPDOWN		EQU		000000004h

; DIRECTDRAW WAITFORVERTICALBLANK FLAGS
DDWAITVB_BLOCKBEGIN			EQU		000000001h
DDWAITVB_BLOCKBEGINEVENT	EQU		000000002h
DDWAITVB_BLOCKEND			EQU		000000004h

; DIRECTDRAW GETFLIPSTATUS FLAGS
DDGFS_CANFLIP		EQU		000000001h
DDGFS_ISFLIPDONE	EQU		000000002h

; DIRECTDRAW GETBLTSTATUS FLAGS
DDGBS_CANBLT		EQU		000000001h
DDGBS_ISBLTDONE		EQU		000000002h

; DIRECTDRAW ENUMOVERLAYZORDER FLAGS
DDENUMOVERLAYZ_BACKTOFRONT	EQU		000000000h
DDENUMOVERLAYZ_FRONTTOBACK	EQU		000000001h

; DIRECTDRAW UPDATEOVERLAYZORDER FLAGS
DDOVERZ_SENDTOFRONT		EQU		000000000h
DDOVERZ_SENDTOBACK		EQU		000000001h
DDOVERZ_MOVEFORWARD		EQU		000000002h
DDOVERZ_MOVEBACKWARD	EQU		000000003h
DDOVERZ_INSERTINFRONTOF	EQU		000000004h
DDOVERZ_INSERTINBACKOF	EQU		000000005h


; DIRECTDRAW RETURN CODES

; Issued by: DirectDraw Commands and all callbacks
DD_OK				EQU		0		; Status is OK

; DIRECTDRAW ENUMCALLBACK RETURN VALUES
DDENUMRET_CANCEL	EQU		0		; stop the enumeration
DDENUMRET_OK		EQU		1		; continue the enumeration

; DIRECTDRAW ERRORS
DDERR_ALREADYINITIALIZED		EQU		088760005h
DDERR_CANNOTATTACHSURFACE		EQU		08876000ah
DDERR_CANNOTDETACHSURFACE		EQU		088760014h
DDERR_CURRENTLYNOTAVAIL			EQU		088760028h
DDERR_EXCEPTION					EQU		088760037h
DDERR_GENERIC					EQU		080004005h
DDERR_HEIGHTALIGN				EQU		08876005ah
DDERR_INCOMPATIBLEPRIMARY		EQU		08876005fh
DDERR_INVALIDCAPS				EQU		088760064h
DDERR_INVALIDCLIPLIST			EQU		08876006eh
DDERR_INVALIDMODE				EQU		088760078h
DDERR_INVALIDOBJECT				EQU		088760082h
DDERR_INVALIDPARAMS				EQU		080070057h
DDERR_INVALIDPIXELFORMAT		EQU		088760091h
DDERR_INVALIDRECT				EQU		088760096h
DDERR_LOCKEDSURFACES			EQU		0887600a0h
DDERR_NO3D						EQU		0887600aah
DDERR_NOALPHAHW					EQU		0887600b4h
DDERR_NOCLIPLIST				EQU		0887600cdh
DDERR_NOCOLORCONVHW				EQU		0887600d2h
DDERR_NOCOOPERATIVELEVELSET		EQU		0887600d4h
DDERR_NOCOLORKEY				EQU		0887600d7h
DDERR_NOCOLORKEYHW				EQU		0887600dch
DDERR_NODIRECTDRAWSUPPORT		EQU		0887600deh
DDERR_NOEXCLUSIVEMODE			EQU		0887600e1h
DDERR_NOFLIPHW					EQU		0887600e6h
DDERR_NOGDI						EQU		0887600f0h
DDERR_NOMIRRORHW				EQU		0887600fah
DDERR_NOTFOUND					EQU		0887600ffh
DDERR_NOOVERLAYHW				EQU		088760104h
DDERR_NORASTEROPHW				EQU		088760118h
DDERR_NOROTATIONHW				EQU		088760122h
DDERR_NOSTRETCHHW				EQU		088760136h
DDERR_NOT4BITCOLOR				EQU		08876013ch
DDERR_NOT4BITCOLORINDEX			EQU		08876013dh
DDERR_NOT8BITCOLOR				EQU		088760140h
DDERR_NOTEXTUREHW				EQU		08876014ah
DDERR_NOVSYNCHW					EQU		08876014fh
DDERR_NOZBUFFERHW				EQU		088760154h
DDERR_NOZOVERLAYHW				EQU		08876015eh
DDERR_OUTOFCAPS					EQU		088760168h
DDERR_OUTOFMEMORY				EQU		08007000eh
DDERR_OUTOFVIDEOMEMORY			EQU		08876017ch
DDERR_OVERLAYCANTCLIP			EQU		08876017eh
DDERR_OVERLAYCOLORKEYONLYONEACTIVE	EQU	088760180h
DDERR_PALETTEBUSY				EQU		088760183h
DDERR_COLORKEYNOTSET			EQU		088760190h
DDERR_SURFACEALREADYATTACHED	EQU		08876019ah
DDERR_SURFACEALREADYDEPENDENT	EQU		0887601a4h
DDERR_SURFACEBUSY				EQU		0887601aeh
DDERR_CANTLOCKSURFACE			EQU		0887601b3h
DDERR_SURFACEISOBSCURED			EQU		0887601b8h
DDERR_SURFACELOST				EQU		0887601c2h
DDERR_SURFACENOTATTACHED		EQU		0887601cch
DDERR_TOOBIGHEIGHT				EQU		0887601d6h
DDERR_TOOBIGSIZE				EQU		0887601e0h
DDERR_TOOBIGWIDTH				EQU		0887601eah
DDERR_UNSUPPORTED				EQU		080004001h
DDERR_UNSUPPORTEDFORMAT			EQU		0887601feh
DDERR_UNSUPPORTEDMASK			EQU		088760208h
DDERR_VERTICALBLANKINPROGRESS	EQU		088760219h
DDERR_WASSTILLDRAWING			EQU		08876021ch
DDERR_XALIGN					EQU		088760230h
DDERR_INVALIDDIRECTDRAWGUID		EQU		088760231h
DDERR_DIRECTDRAWALREADYCREATED	EQU		088760232h
DDERR_NODIRECTDRAWHW			EQU		088760233h
DDERR_PRIMARYSURFACEALREADYEXISTS	EQU	088760234h
DDERR_NOEMULATION				EQU		088760235h
DDERR_REGIONTOOSMALL			EQU		088760236h
DDERR_CLIPPERISUSINGHWND		EQU		088760237h
DDERR_NOCLIPPERATTACHED			EQU		088760238h
DDERR_NOHWND					EQU		088760239h
DDERR_HWNDSUBCLASSED			EQU		08876023ah
DDERR_HWNDALREADYSET			EQU		08876023bh
DDERR_NOPALETTEATTACHED			EQU		08876023ch
DDERR_NOPALETTEHW				EQU		08876023dh
DDERR_BLTFASTCANTCLIP			EQU		08876023eh
DDERR_NOBLTHW					EQU		08876023fh
DDERR_NODDROPSHW				EQU		088760240h
DDERR_OVERLAYNOTVISIBLE			EQU		088760241h
DDERR_NOOVERLAYDEST				EQU		088760242h
DDERR_INVALIDPOSITION			EQU		088760243h
DDERR_NOTAOVERLAYSURFACE		EQU		088760244h
DDERR_EXCLUSIVEMODEALREADYSET	EQU		088760245h
DDERR_NOTFLIPPABLE				EQU		088760246h
DDERR_CANTDUPLICATE				EQU		088760247h
DDERR_NOTLOCKED					EQU		088760248h
DDERR_CANTCREATEDC				EQU		088760249h
DDERR_NODC						EQU		08876024ah
DDERR_WRONGMODE					EQU		08876024bh
DDERR_IMPLICITLYCREATED			EQU		08876024ch
DDERR_NOTPALETTIZED				EQU		08876024dh
DDERR_UNSUPPORTEDMODE			EQU		08876024eh
DDERR_NOMIPMAPHW				EQU		08876024fh
DDERR_INVALIDSURFACETYPE		EQU		088760250h
DDERR_DCALREADYCREATED			EQU		08876026ch
DDERR_CANTPAGELOCK				EQU		088760280h
DDERR_CANTPAGEUNLOCK			EQU		088760294h
DDERR_NOTPAGELOCKED				EQU		0887602a8h
DDERR_NOTINITIALIZED			EQU		0800401f0h



