TITLE Senf's Intel JPEG Library Demo (also uses Direct Draw)
; Senf - 03.04.2001

.586
.MODEL FLAT, STDCALL
OPTION CASEMAP:NONE

;*************************************************************************
; INCLUDES & LIBRARIES
;*************************************************************************
INCLUDE \masm32\include\windows.inc
INCLUDE \masm32\include\gdi32.inc
INCLUDE \masm32\include\kernel32.inc
INCLUDE \masm32\include\user32.inc
INCLUDE include\ddraw.inc							; Direct Draw Include File by The Diamond Crew
INCLUDE	include\ijl.inc								; Intel JPEG Library Include File by Senf :P
INCLUDELIB \masm32\lib\gdi32.lib
INCLUDELIB \masm32\lib\kernel32.lib
INCLUDELIB \masm32\lib\user32.lib
INCLUDELIB lib\ddraw.lib							; Direct Draw Library
INCLUDELIB lib\ijl15.lib							; Intel JPEG Library v1.5

;*************************************************************************
; PROTOTYPES
;*************************************************************************
WinMain		PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc		PROTO :DWORD,:DWORD,:DWORD,:DWORD
LoadJPEG2Surface	PROTO :DWORD,:LPDIRECTDRAWSURFACE

;*************************************************************************
; MACROS    
;*************************************************************************
FATAL	MACRO	msg
	LOCAL @@msg
	.DATA
	@@msg	db	msg, 0
	.CODE
	invoke	MessageBox, hWnd, ADDR @@msg, ADDR szDisplayName, MB_OK
	invoke	ExitProcess, 0
ENDM

;*************************************************************************
; CONSTANTS
;*************************************************************************
.CONST
PF_555			EQU					1
PF_565			EQU					2

;*************************************************************************
; DATA SEGMENT
;*************************************************************************
.DATA
szClassName		db					"Senf IJL v1.5 Demo", 0						; class name
szDisplayName	db					"Senf's Intel JPEG Library v1.5 Demo", 0	; window name
IconName		db 					"SenfIJLIcon", 0							; icon name
JPEGFile		db					"senfijl.jpg", 0							; the JPEG file
SenfSays		db					"That's all, folks !!!", 13, 10
				db					"I hope this stuff is useful. If not, who cares ?!? :P", 13, 10, 13, 10
				db					"Greetings go to:", 13, 10
				db					"Iczelion, hutch, oVeRFLoW, trudel, dhartmei, u_schall,", 13, 10
				db					"NeHe, zack123, kOBoLd29A, all the ppl in #win32asm,", 13, 10
				db					"#informatik & #assembler", 0
ddwidth			dd 						640		; display mode width
ddheight		dd 						480		; display mode height
ddbpp			dd 						16 		; display mode color depth
PixelFormat		dd						PF_555	; 16bit color format, 5bits for each color RGB

jcprops			JPEG_CORE_PROPERTIES	<>		; Intel JPEG Library Object

.DATA?
hWnd			HWND				?			; surface window
lpDD			LPDIRECTDRAW		?			; DDraw object
lpDDSPrimary	LPDIRECTDRAWSURFACE	?			; DDraw primary surface
ddsd			DDSURFACEDESC		<?>			; DDraw surface descriptor
ddscaps			DDSCAPS				<?>			; DDraw capabilities
ddpf			DDPIXELFORMAT		<?>			; DDraw pixel format
hDC				dd					?			; device context handle
hDCImage		dd					?			; image device context
bm				BITMAP 				<?>			; bitmap structure
hBitmap			dd					?			; bitmap handle
hjbuffer16		dd					?			; handle to 16bit JPEG image buffer 
hjbuffer24		dd					?			; handle to 24bit JPEG image buffer
jbuffer16		dd					?			; 16bit buffer for JPEG image data 
jbuffer24		dd					?			; 24bit buffer for JPEG image data
jbufsize24		dd					?			; size of jbuffer24
keystate		db					256 DUP(?)	; key flags

;*************************************************************************
; CODE SEGMENT
;*************************************************************************
.CODE
Start:
	invoke	GetModuleHandle, NULL
	invoke	WinMain, eax, NULL, NULL, SW_SHOWDEFAULT
	invoke	ExitProcess, eax

;*************************************************************************
; WinMain
;*************************************************************************
WinMain	PROC	hInst:DWORD, hPrevInst:DWORD, CmdLine:DWORD, CmdShow:DWORD
LOCAL	wc:WNDCLASSEX, msg:MSG, devmode:DEVMODE, dwStyle:DWORD
	mov   	wc.cbSize, SIZEOF WNDCLASSEX
	mov   	wc.style, CS_HREDRAW OR CS_VREDRAW
	mov   	wc.lpfnWndProc, OFFSET WndProc
	mov   	wc.cbClsExtra, NULL
	mov   	wc.cbWndExtra, 0 
	push  	hInst
	pop   	wc.hInstance
	invoke	GetStockObject, BLACK_BRUSH
	mov		wc.hbrBackground, eax
	mov		wc.lpszMenuName, 0
	mov   	wc.lpszClassName, OFFSET szClassName
	invoke	LoadIcon, hInst, ADDR IconName
	mov   	wc.hIcon, eax
	mov   	wc.hIconSm, NULL
	invoke 	LoadCursor, NULL, IDC_ARROW
	mov   	wc.hCursor, eax
	invoke 	RegisterClassEx, ADDR wc	
	
	mov		dwStyle, WS_CAPTION+WS_BORDER+WS_OVERLAPPED+WS_SYSMENU+WS_MINIMIZEBOX+WS_MAXIMIZEBOX

	; Create window at following size
	invoke	CreateWindowEx, 0, ADDR szClassName, ADDR szDisplayName, WS_POPUP, 0, 0, ddwidth, ddheight, \ 
			NULL, NULL, hInst, NULL
	mov		hWnd, eax

	invoke	SetFocus, hWnd																; set focus on window
	invoke	ShowCursor, FALSE															; hide mouse cursor

	; Initialize display
	INVOKE	DirectDrawCreate, NULL, ADDR lpDD, NULL										; create Direct Draw Object
	.IF eax !=DD_OK
		FATAL "Couldn't init DirectDraw"
	.ENDIF

	DDINVOKE	SetCooperativeLevel, lpDD, hWnd, DDSCL_EXCLUSIVE OR DDSCL_FULLSCREEN 	; set cooperative level
	.IF eax !=DD_OK
		FATAL "Couldn't set DirectDraw cooperative level"
	.ENDIF

	DDINVOKE	SetDisplayMode, lpDD, ddwidth, ddheight, ddbpp							; set display mode
	.IF eax !=DD_OK
		FATAL "Couldn't set display mode"
	.ENDIF

	; create primary surface 
	mov		ddsd.dwSize, SIZEOF DDSURFACEDESC											; surface infos
	mov		ddsd.dwFlags, DDSD_CAPS 
	mov		ddsd.ddsCaps.dwCaps, DDSCAPS_PRIMARYSURFACE OR DDSCAPS_VIDEOMEMORY
	DDINVOKE	CreateSurface, lpDD, ADDR ddsd, ADDR lpDDSPrimary, NULL					; create primary surface
	.IF eax !=DD_OK
		FATAL "Couldn't create primary surface"
	.ENDIF

	; get pixel format of primary surface (PF_555, PF_565 or something special)
	mov		ddpf.dwSize, SIZEOF DDPIXELFORMAT
	DDSINVOKE	GetPixelFormat, lpDDSPrimary, ADDR ddpf									; get pixel format
	mov		eax, ddpf.dwGBitMask
	shr		eax, 5
	cmp		eax, 31																		; 555 format ?
	jne		@PF565																		; no, then maybe 565
@PF555:																					; it's 555
	mov		PixelFormat, PF_555															; 555-pixel format
	jmp		@LoadJPEG      																; jump to JPEG loading 
@PF565:																			
	cmp		eax, 63																		; 565 format ?
	jne		@PixelFormatError															; no, then abort program
	mov		PixelFormat, PF_565															; 565-pixel format
	jmp		@LoadJPEG       															; jump to JPEG loading
@PixelFormatError:																		; wrong pixel format detected
	FATAL "Wrong pixel format"															; quit program with error msg

@LoadJPEG:	
	invoke	LoadJPEG2Surface, ADDR JPEGFile, lpDDSPrimary								; load JPEG to primary surface
		
	invoke	ShowWindow, hWnd, CmdShow													; show the window

	; Loop until PostQuitMessage is sent
	.WHILE TRUE
		invoke	PeekMessage, ADDR msg, NULL, 0, 0, PM_REMOVE							; check for msg
		.IF eax != 0
			.IF msg.message == WM_QUIT
				invoke	PostQuitMessage, msg.wParam
				.BREAK
			.ELSE
				invoke	TranslateMessage, ADDR msg
				invoke	DispatchMessage, ADDR msg
			.ENDIF
		.ELSE
			invoke	GetFocus															; get focus
			.IF eax == hWnd
				mov		ddsd.dwSize, SIZEOF DDSURFACEDESC
				mov		ddsd.dwFlags, DDSD_PITCH
				.WHILE TRUE
					DDSINVOKE	mLock, lpDDSPrimary, NULL, ADDR ddsd, DDLOCK_WAIT, NULL	; lock surface
					.BREAK .IF eax==DD_OK
					.IF eax == DDERR_SURFACELOST										; is surface lost ?
						DDSINVOKE	Restore, lpDDSPrimary								; yes, then restore primary surface
						; reload the content of the surface
						invoke	LoadJPEG2Surface, ADDR JPEGFile, lpDDSPrimary			; load JPEG to primary surface
				.ELSE
					FATAL "Couldn't lock surface"
					.ENDIF
				.ENDW
				DDSINVOKE	Unlock, lpDDSPrimary, ddsd.lpSurface						; unlock primary surface
											
				; check keystate
				.IF [keystate+VK_ESCAPE]												; <ESC> pressed ?
					invoke	SendMessage, hWnd, WM_DESTROY, NULL, NULL 					; send WM_DESTROY										; quit proggy
				.ENDIF
			.ENDIF
		.ENDIF
	.ENDW
	
	DDINVOKE RestoreDisplayMode, lpDD													; restore display mode
	.IF eax != DD_OK
		FATAL "Couldn't restore displaymode"
	.ENDIF

	invoke	DestroyWindow, hWnd															; destroy the window
	.IF eax == NULL
		FATAL "Couldn't destroy window"
	.ENDIF

	.IF lpDD != NULL
		.IF lpDDSPrimary != NULL
			DDSINVOKE	Release, lpDDSPrimary											; release primary surface
			mov		lpDDSPrimary, NULL
		.ENDIF

		DDINVOKE	Release, lpDD														; release Direct Draw Object
		mov		lpDD, NULL
	.ENDIF

	LRETURN	msg.wParam
WinMain		ENDP

;*************************************************************************
; LoadBitmap2Surface
;-------------------------------------------------------------------------
; Loads a bitmap from a file and draws it on a DDraw surface
;*************************************************************************
LoadJPEG2Surface	PROC	Filename:DWORD, Surface:LPDIRECTDRAWSURFACE
	; initalize Intel JPEG Library
	invoke	ijlInit, ADDR jcprops						; Intel JPEG Library initialization
	.IF eax != IJL_OK
		FATAL "Couldn't init Intel JPEG Library"
	.ENDIF
	
	; open JPEG file
	mov		eax, Filename
	mov		jcprops.JPGFile, eax
	invoke	ijlRead, ADDR jcprops, IJL_JFILE_READPARAMS	; read parameters of JPEG file
	.IF eax != IJL_OK
		FATAL "Couldn't open JPEG file"
	.ENDIF
	
	; calculate size of buffer to hold 24bit image date & allocate memory
	; determine the required size of 24bit buffer	
	mov		eax, jcprops.JPGWidth			; width of JPEG to eax
	add		eax, 7
	mov		ebx, 24							; bits per plane to ebx (24bit)
	mul		ebx								; multiply
	add		eax, 7							; add 7
	shr		eax, 3							; division by 8
	mov		ebx, jcprops.JPGHeight			; heigt of JPEG to eax
	mul		ebx
	mov		jbufsize24, eax
	invoke	GlobalAlloc, GHND, eax
	.IF	eax==FALSE
		FATAL	"Not enough memory available"
	.ELSE
		mov		hjbuffer24, eax				; handle to allocated memory
	.ENDIF
	invoke	GlobalLock, eax
	mov		jbuffer24, eax					; pointer to buffer

	; determine the required size of 16bit buffer	
	mov		eax, jcprops.JPGWidth			; width of JPEG to eax
	add		eax, 7
	mov		ebx, 16							; bits per plane to ebx (16bit)
	mul		ebx								; multiply
	add		eax, 7							; add 7
	shr		eax, 3							; division by 8
	mov		ebx, jcprops.JPGHeight			; heigt of JPEG to eax
	mul		ebx

	invoke	GlobalAlloc, GHND, eax
	.IF	eax==FALSE
		FATAL	"Not enough memory available"
	.ELSE
		mov		hjbuffer16, eax				; handle to allocated memory
	.ENDIF
	invoke	GlobalLock, eax
	mov		jbuffer16, eax					; pointer to buffer

	; fill DIB portion of the JPEG object 
	push	jcprops.JPGWidth				
	pop		jcprops.DIBWidth				; DIBWidth <- JPGWidth
	push	jcprops.JPGHeight				; implies a bottom-up DIB
	pop		jcprops.DIBHeight 				; DIBHeight <- JPGHeight
	mov		jcprops.DIBChannels, 3			; 3 channels
	mov		jcprops.DIBColor, IJL_BGR		; colors are in reversed order BGR instead of RGB 

	; calculate DIBPadBytes
	mov		eax, jcprops.JPGWidth			; JPEG width to eax
	mov		ebx, 3          				; number of channels to ebx
	mul		ebx								; multiply width with number of channels
	push	eax								; store this value (IJL_DIB_UWIDTH)
	
	add		eax, IJL_DIB_ALIGN				; add IJL_DIB_ALIGN
	mov		ebx, IJL_DIB_ALIGN
	not		ebx
	and		eax, ebx          				; AND with IJL_DIB_ALIGN
											; eax holds IJL_DIB_AWIDTH
	pop		ebx								; restore IJL_DIB_UWIDTH to ebx
	sub		eax, ebx						; calculate IJL_DIB_PAD_BYTES
	mov		jcprops.DIBPadBytes, eax  		; store value

	push	jbuffer24						; push 24bit jpeg buffer address 
	pop		jcprops.DIBBytes				; pop address

	mov		eax, jcprops.JPGChannels		; JPGChannels to eax
	.IF	eax==1								; is it 1 ?
		mov		jcprops.JPGColor, IJL_G		; yes, then JPGColor is grayscale color space 
  	.ELSEIF eax==3							; is it 3 ?
 		mov		jcprops.JPGColor, IJL_YCBCR ; yes, then JPGColor is luminance-chrominance color space
    .ELSE
		; This catches everything else, but no color twist will be
    	; performed by the IJL
    	mov		jcprops.DIBColor, IJL_OTHER
    	mov		jcprops.JPGColor, IJL_OTHER
    .ENDIF

	; Read in image from file
	invoke	ijlRead, ADDR jcprops, IJL_JFILE_READWHOLEIMAGE
	.IF eax != IJL_OK
		FATAL	"Couldn't read JPEG file"
	.ENDIF

	; convert 24bit color -> 16bit color 
	push	jbuffer24					; jbuffer24 address to esi
	pop		esi
	push	jbuffer16					; jubffer16 address to edi
	pop		edi
	mov		edx, jbufsize24				; 24bit buffer size to edx
	add		edx, esi					; caluclate end offset of jbuffer24
@ConvertColors:
	xor		eax, eax					; delete eax
	xor		ebx, ebx					; delete ebx
	xor		ecx, ecx					; delete ecx
	mov		al, BYTE PTR[esi]			; R to al
	mov		bl, BYTE PTR[esi+1]			; G to bl
	mov		cl, BYTE PTR[esi+2]			; B to cl
	.IF	PixelFormat==PF_555				; is pixel format PF_555, then ...
		shr		eax, 3
		shr		ebx, 3
		shl		ebx, 5
		shr		ecx, 3
		shl		ecx, 10
		or		ax, bx
		or		ax, cx
	.ELSEIF	PixelFormat==PF_565			; is pixel format PF_565, then ...
		shr		eax, 3
		shr		ebx, 2
		shl		ebx, 5
		shr		ecx, 3
		shl		ecx, 11
		or		eax, ebx
		or		eax, ecx
	.ENDIF
	stosw								; store 16bit color value to jbuffer16
	add		esi, 3						; increase jpointer to jbuffer24
	cmp		esi, edx					; end of jbuffer24 rechead ?
	jb		@ConvertColors				; no, then once again

	; create the bitmap and get a handle to it
	invoke	CreateBitmap, jcprops.JPGWidth, jcprops.JPGHeight, 1, 16, jbuffer16
	.IF	eax==NULL
		FATAL "Couln't create bitmap from image"
	.ELSE
		mov		hBitmap, eax												; save handle of bitmap
	.ENDIF

    invoke	CreateCompatibleDC, NULL										; create image device context
    mov		hDCImage, eax													; save dc handle
    invoke	SelectObject, hDCImage, hBitmap									; select bitmap
	invoke	GetObject, hBitmap, SIZEOF bm, ADDR bm							; get bitmap dimensions
    DDSINVOKE	GetDC, Surface, ADDR hDC									; get device context of DDraw surface
   	invoke	BitBlt, hDC, 0, 0, bm.bmWidth, bm.bmHeight, hDCImage, 0, 0, SRCCOPY	; blit the bitmap to the DDraw surface
    DDSINVOKE	ReleaseDC, Surface, hDC										; release DDraw device context
    invoke	DeleteDC, hDCImage												; delete bitmap dc
	invoke	DeleteObject, hBitmap											; delete bitmap
	
	; free memory of JPEG buffers
	invoke	GlobalUnlock, jbuffer24											; 24bit buffer
	invoke	GlobalFree, hjbuffer24
	invoke	GlobalUnlock, jbuffer16											; 16bit buffer
	invoke	GlobalFree, hjbuffer16

	; release Intel JPEG Library Object
	invoke	ijlFree, ADDR jcprops											; free Intel JPEG Library 

	ret
LoadJPEG2Surface	ENDP

;*************************************************************************
; WndProc
;-------------------------------------------------------------------------
; Window procedure
;*************************************************************************
WndProc	PROC	hWin:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	mov		eax, uMsg											; uMsg to eax
	.IF eax==WM_KEYDOWN
		mov		ebx, wParam										; wParam to ebx
		mov		BYTE PTR [keystate+ebx], TRUE					; set key flag in buffer
    .ELSEIF eax==WM_KEYUP
		mov		ebx, wParam										; wParam to ebx
		mov		BYTE PTR [keystate+ebx], FALSE					; clear key flag in buffer
    .ELSEIF	eax==WM_LBUTTONDOWN									; left mouse button pressed ?
    	invoke	SendMessage, hWnd, WM_DESTROY, NULL, NULL		; send WM_DESTROY
    .ELSEIF eax==WM_DESTROY
		invoke	ShowCursor, TRUE								; show mouse cursor
		invoke	MessageBox, hWnd, ADDR SenfSays, ADDR szDisplayName, MB_OK
		invoke	PostQuitMessage, NULL							; quit program
	.ELSE
		invoke	DefWindowProc, hWin, uMsg, wParam, lParam		
	.ENDIF
		
	ret
WndProc		ENDP

END Start

