DECLARE SUB REMOVE (filename AS STRING)
DECLARE FUNCTION BaseName$ (filename AS STRING)
DECLARE FUNCTION UniqueName$ (filename AS STRING, ext AS STRING)
DECLARE FUNCTION OpenSource% (filename AS STRING)
DECLARE FUNCTION OpenOutput% (filename AS STRING)
DECLARE FUNCTION OpenBinary% (filename AS STRING)

    DIM SHARED errvalue AS INTEGER

        CLS
        COLOR 4
        PRINT STRING$(80, 196)
        COLOR 15
        PRINT TAB(32); "CALL ABSOLUTE ASSEMBLER"
        COLOR 4
        PRINT STRING$(80, 196)
        COLOR 7
        PRINT
        PRINT "  This program accepts assembly source code filenames and processes them into"
        PRINT "  DATA statements that can be put into an array for use with CALL ABSOLUTE."
        PRINT "  You will be given a choice of whether to use bytes, words (INTEGERs), or"
        PRINT "  long values when creating the DATA statements for you."
        PRINT
        PRINT "  This program requires ML.EXE to compile the assembly source code files.  If"
        PRINT "  you do not already have this program, instructions for downloading can be"
        PRINT "  found at http://www.easystreet.com/~jkirwan/pctools.html."
        PRINT
        PRINT

    DIM i AS INTEGER, count AS INTEGER
    DIM b AS LONG, b0 AS STRING * 1, b1 AS INTEGER
    DIM fmt AS STRING, fc AS INTEGER, fs AS INTEGER
    DIM srcfile AS STRING, srcunit AS INTEGER
    DIM comfile AS STRING, comunit AS INTEGER
    DIM basfile AS STRING, basunit AS INTEGER
    DIM objfile AS STRING, lstfile AS STRING, mapfile AS STRING

        INPUT "Source filename? ", srcfile
        LET srcfile = LTRIM$(RTRIM$(UCASE$(srcfile)))
        DO WHILE srcfile <> ""
            LET srcunit = OpenSource(srcfile)
            IF srcunit > 0 THEN
                CLOSE srcunit
                INPUT "Byte, Word, or Long format (B, W, L)? ", fmt
                LET fmt = LEFT$(LTRIM$(RTRIM$(UCASE$(fmt))) + "W", 1)
                IF INSTR("BWL", fmt) < 1 THEN
                    LET fmt = "W"
                END IF
                SELECT CASE fmt
                CASE "B"
                    LET fs = 2
                    LET fc = 11
                CASE "W"
                    LET fs = 4
                    LET fc = 8
                CASE "L"
                    LET fs = 8
                    LET fc = 5
                END SELECT
                LET lstfile = BaseName(srcfile) + ".LST"
                LET mapfile = BaseName(srcfile) + ".MAP"
                LET objfile = UniqueName(srcfile, ".OBJ")
                LET comfile = UniqueName(srcfile, ".COM")
                PRINT
                SHELL "ML /AT /Sa /Fl" + lstfile + " /Fo" + objfile + " /Fe" + comfile + " /Fm" + mapfile + " /Ta" + srcfile
                PRINT
                REMOVE objfile
                LET comunit = OpenSource(comfile)
                IF comunit > 0 THEN
                    CLOSE comunit
                    LET basfile = UniqueName(srcfile, ".DAT")
                    LET basunit = OpenOutput(basfile)
                    LET comunit = OpenBinary(comfile)
                    LET count = 0
                    FOR i = 1 TO LOF(comunit) STEP fs \ 2
                        IF fmt = "B" THEN
                            GET comunit, , b0
                            LET b = ASC(b0)
                        ELSEIF fmt = "W" THEN
                            GET comunit, , b1
                            LET b = CLNG(b1) AND &HFFFF&
                        ELSE
                            GET comunit, , b
                        END IF
                        IF count >= fc THEN
                            PRINT #basunit, ""
                            PRINT #basunit, "        DATA ";
                            LET count = 0
                        ELSEIF count > 0 THEN
                            PRINT #basunit, ", ";
                        ELSE
                            PRINT #basunit, "        DATA ";
                        END IF
                        PRINT #basunit, "&H"; RIGHT$(STRING$(fs - 1, 48) + HEX$(b), fs);
                        LET count = count + 1
                    NEXT i
                    CLOSE basunit
                    CLOSE comunit
                    COLOR 2
                    PRINT "  Generated data file is "; CHR$(34); basfile; CHR$(34)
                    COLOR 7
                ELSE
                    COLOR 14
                    PRINT "  Error in assembly process.  No DATA generated."
                    COLOR 7
                END IF
                REMOVE comfile
            ELSE
                COLOR 14
                PRINT "  Can't find '"; srcfile; "'.  Please retry the name."
                COLOR 7
            END IF
            PRINT
            INPUT "Source filename? ", srcfile
            LET srcfile = LTRIM$(RTRIM$(UCASE$(srcfile)))
        LOOP

        END

ErrorHandler:
        LET errvalue = ERR
        RESUME NEXT
        END

FUNCTION BaseName$ (filename AS STRING)

    DIM idx AS INTEGER

        LET idx = INSTR(filename, ".")
        IF idx <= 0 THEN
            LET idx = LEN(filename) + 1
        END IF

        LET BaseName = LEFT$(filename, idx - 1)

END FUNCTION

FUNCTION OpenBinary% (filename AS STRING)

    DIM unit AS INTEGER

        LET unit = FREEFILE
        LET errvalue = 0
        ON ERROR GOTO ErrorHandler
        OPEN filename FOR BINARY AS unit
        ON ERROR GOTO 0

        IF errvalue = 0 THEN
            LET OpenBinary = unit
        ELSE
            LET OpenBinary = -1
        END IF

END FUNCTION

FUNCTION OpenOutput% (filename AS STRING)

    DIM unit AS INTEGER

        LET unit = FREEFILE
        LET errvalue = 0
        ON ERROR GOTO ErrorHandler
        OPEN filename FOR OUTPUT AS unit
        ON ERROR GOTO 0

        IF errvalue = 0 THEN
            LET OpenOutput = unit
        ELSE
            LET OpenOutput = -1
        END IF

END FUNCTION

FUNCTION OpenSource% (filename AS STRING)

    DIM unit AS INTEGER

        LET unit = FREEFILE
        LET errvalue = 0
        ON ERROR GOTO ErrorHandler
        OPEN filename FOR INPUT AS unit
        ON ERROR GOTO 0

        IF errvalue = 0 THEN
            LET OpenSource = unit
        ELSE
            LET OpenSource = -1
        END IF

END FUNCTION

SUB REMOVE (filename AS STRING)

    DIM unit AS INTEGER

        LET unit = OpenSource(filename)
        IF unit > 0 THEN
            CLOSE unit
            KILL filename
        END IF

END SUB

FUNCTION UniqueName$ (filename AS STRING, ext AS STRING)

    DIM unit AS INTEGER, count AS INTEGER
    DIM pathname AS STRING, newname AS STRING

        LET pathname = BaseName(filename)

        LET count = 0
        LET newname = pathname + ext
        LET unit = OpenSource(newname)
        DO WHILE unit > 0
            CLOSE unit
            IF count > 9 THEN
                LET UniqueName = ""
                EXIT FUNCTION
            END IF
            LET newname = pathname + LEFT$(ext, 3) + CHR$(48 + count)
            LET unit = OpenSource(newname)
            LET count = count + 1
        LOOP

        LET UniqueName = newname

END FUNCTION
