
;   File:   reverse.asm
;   Author: Jonathan Dale Kirwan
;
;   Creation Date:  Mon 14-Feb-2000 18:14:39
;   Last Modified:  Mon 14-Feb-2000 18:46:29
;
;
;   DESCRIPTION
;
;   This file demostrates the use of the ABSOLUTE.BAS program, providing a
;   short demonstration of using assembly code with QBASIC's CALL ABSOLUTE
;   method.  The code below demostrates how to reverse the bytes in a string.
;
;
;   MODIFICATIONS
;
;   Original source.

.MODEL      MEDIUM, BASIC
.386
.CODE


;   --------------------------------------------------------------------------
;   ReverseStr
;   --------------------------------------------------------------------------
;
;   This routine reverses the order of the characters in the given string.
;   To do this, it accepts two parameters: the length of the string to be
;   reversed and the address of the string's character buffer.  To call this
;   routine from BASIC, use something like the following:
;
;       DEF SEG = VARSEG(array(1))
;       CALL ABSOLUTE(LEN(s$), SADD(s$), VARPTR(array(1)))
;       DEF SEG
;
;   The values in array() will have to be set up from the DATA statements
;   that were generated by ABSOLUTE.BAS, of course.  The contents of s$
;   will be reversed, then.

ReverseStr      PROC    strlen:PTR WORD, strofs:PTR WORD

            ; Get the length of the string into CX.  Since CALL ABSOLUTE
            ; passes the offset of the location holding the string length,
            ; we have to get the address, then use the address to get the
            ; value.

                mov     bx, strlen      ; put offset of length into BX
                mov     cx, [bx]        ; put length into CX

            ; Get the pointer to the string's data into BX.

                mov     bx, strofs      ; put offset of string's offset into BX
                mov     bx, [bx]        ; replace BX with actual string offset

            ; Compute a pointer to the end of the string + 1 into DI.  This
            ; is done by adding the string's length to the string's offset.

                mov     di, bx
                add     di, cx

            ; Reversal is performed by swapping the first character and the
            ; last one, then the second character and the next to the last
            ; one, etc., until the pointers meet in the middle.  When there
            ; there are less than 2 characters remaining, we are done.  DI
            ; starts out one position past the end of the string, so it
            ; must be moved backwards before being used.  BX already points
            ; to the first character, so it is advanced after being used.
            ; CX is reduced by 2, each loop, since we swap two characters
            ; at a time.

                .WHILE (cx > 1)
                  dec     di            ; backup DI now
                  mov     al, [di]      ; get the tail char into AL
                  xchg    al, [bx]      ; exchange it with the head char
                  mov     [di], al      ; move the head char to the tail
                  inc     bx            ; advance BX now
                  sub     cx, 2         ; finished another 2, more?
                .ENDW

                ret

ReverseStr      ENDP

                END
