'
'   File:   variable.bas
'   Creation Date:  Sun 18-Jul-2004 02:10:34        Jonathan D. Kirwan
'   Last Modified:  Sun 18-Jul-2004 11:51:01        Initial version.
'
'   Copyright (C) 2004 Jonathan Dale Kirwan, All Rights Reserved
'
'
'   DESCRIPTION
'
'   This module provides support for variables.
'
'
'   MODIFICATIONS
'
'   No modifications.
'
'
'   COPYRIGHT NOTICE
'
'   Jonathan Dale Kirwan grants you a non-transferable, non-exclusive,
'   royalty-free worldwide license to use, copy, modify, prepare deriva-
'   tive works of and distribute this software, subject to your agreement
'   that you acquire no ownership right, title, or interest in this soft-
'   ware and your agreement that this software is research work which is
'   provided 'as is', where Jonathan Dale Kirwan disclaims all warranties
'   with regard to this software, including all implied warranties of
'   merchantability and fitness of purpose.  In no event shall Jonathan
'   Dale Kirwan be liable for any direct, indirect, consequential or
'   special damages or any damages whatsoever resulting from loss of use,
'   data or profits, whether in an action of contract, negligence or
'   other tortious action, arising out of or in connection with the use
'   or performance of this software.

'$INCLUDE: 'TABLE.BI'
'$INCLUDE: 'VARIABLE.BI'

CONST MAXVARS% = 1000
CONST MAXHEAD% = 210

    REDIM SHARED vartbl(0 TO 0) AS SYMBOLENTRY
    REDIM SHARED varval(1 TO 1) AS DOUBLE

        END

FUNCTION GetValue# (text AS STRING, idx AS INTEGER)

    DIM value AS DOUBLE

        LET idx = FindEntry(text, vartbl())
        IF idx > 0 THEN
            LET value = varval(idx)
        ELSE
            LET value = 0#
        END IF

    LET GetValue = value

END FUNCTION

SUB InitValues

        REDIM vartbl(0 TO MAXVARS) AS SYMBOLENTRY
        InitEntries MAXVARS, MAXHEAD, vartbl()
        REDIM varval(1 TO MAXVARS) AS DOUBLE

END SUB

SUB SetValue (text AS STRING, value AS DOUBLE)

    DIM idx AS INTEGER

        LET idx = AddEntry(text, vartbl())
        IF idx > 0 THEN
            LET varval(idx) = value
        END IF

END SUB
