#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>

#ifdef	XCOM1
#	define	HWNDVA	0x00479B60
#elif	XCOM2
#	define	HWNDVA	0x00495EE0
#else
#error Define either "XCOM1" or "XCOM2"
#endif


#define	ghwnd	(*((HWND *) HWNDVA))

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Defines and typedefs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
enum	Command { CMD_OPEN, CMD_CLOSE, CMD_START, CMD_STOP };

typedef unsigned char u8;
typedef unsigned int u32;

typedef struct CommandStruct {
	enum Command	cmd;
	char			*str;
} CommandStruct;

typedef struct Patch {
	u32		ofs;
	void	*targ;
} Patch;

#define	EXPORT	__declspec(dllexport)



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Prototypes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
static	DWORD WINAPI musicThread(LPVOID parm);

// I don't really need to export anything as all stuff is handled
// on DllMain - but I need the protos, and... why not :).
EXPORT	BOOL	music_load(char *file);
EXPORT	BOOL	music_stop(void);
EXPORT	BOOL	music_start(void);
EXPORT	BOOL	music_closeall(void);


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Global data
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
static	HINSTANCE			ghInst;

static	HANDLE				evtWorker;
static	CRITICAL_SECTION	csWorker;
static	CommandStruct		cmd;


#ifdef XCOM1
static	Patch	patches[] = {
	{ 0x0045DF40, music_load },
	{ 0x0045DFC0, music_stop },
	{ 0x0045DFE0, music_start },
	{ 0x0045E000, music_closeall },
	{ 0, 0 }
};
#elif XCOM2
static	Patch	patches[] = {
	{ 0x004675F0, music_load },
	{ 0x00467670, music_stop },
	{ 0x00467690, music_start },
	{ 0x004676B0, music_closeall },
	{ 0, 0 }
};
#endif

void applyPatches(void)
{
	int		i;
	Patch	*p;
	DWORD	old;
	u32		imm;

	i=0;
	while(patches[i].ofs != 0) {
		p = &patches[i];
		VirtualProtect((LPVOID) p->ofs, 5, PAGE_READWRITE, &old);

		imm = ((u32) p->targ) - (p->ofs + 5);
		*((u8 *) p->ofs) = 0xE9;
		*((u32 *) (p->ofs+1)) = imm;

		VirtualProtect((LPVOID) p->ofs, 5, old, &old);
		i++;
	}
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	DWORD	tid;

	switch(fdwReason) {
		case DLL_PROCESS_ATTACH: {
			InitializeCriticalSection(&csWorker);
			evtWorker = CreateEvent(NULL, FALSE, FALSE, NULL);

			applyPatches();

			// create worker thread and wait for it to initialize
			CreateThread(NULL, 0, musicThread, NULL, 0, &tid);
		}

		case DLL_PROCESS_DETACH: {
		}
	}

	return TRUE;
}



/*
DWORD WINAPI musicThread(LPVOID parm)
  This is the "worker thread" that sends out all those pesky MCI strings.
  It sits in an infinite loop, waiting for the evtWorker event to be fired.
  Then it acts on the Worker Command "packet".
*/
static DWORD WINAPI musicThread(LPVOID parm)
{
	char	buf[256];
	// signal that we're ready
	SetEvent(evtWorker);

	// enter work loop
	while(1) {
		WaitForSingleObject(evtWorker, INFINITE);
		EnterCriticalSection(&csWorker);

		switch(cmd.cmd) {
		case CMD_STOP:
			mciSendString("stop MUSIC", NULL, 0, NULL);
			break;

		case CMD_START:
			mciSendString("play MUSIC notify", NULL, 0, ghwnd);
			break;

		case CMD_CLOSE:
			mciSendString("close all", NULL, 0, NULL);
			break;

		case CMD_OPEN:
			wsprintf(buf, "open %s type sequencer alias MUSIC", cmd.str);
			mciSendString("close all", NULL, 0, NULL);
			mciSendString(buf, NULL, 0, NULL);
			mciSendString("play MUSIC from 0 notify", NULL, 0, ghwnd);
			break;
		}
		LeaveCriticalSection(&csWorker);
	}
}



/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Threads and wrapper functions that passes on stuff to the
MCI worker thread. Damn MCI is a pile of crap.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static	DWORD WINAPI threadGeneric(LPVOID parm)
{
	EnterCriticalSection(&csWorker);
	cmd.cmd = (enum Command) parm;
	cmd.str = NULL;
	LeaveCriticalSection(&csWorker);
	SetEvent(evtWorker);
	return 0;
}
static DWORD WINAPI threadOpen(LPVOID parm)
{
	EnterCriticalSection(&csWorker);
	cmd.cmd = CMD_OPEN;
	cmd.str = (char *) parm;
	LeaveCriticalSection(&csWorker);
	SetEvent(evtWorker);
	return 0;
}

BOOL	music_stop(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_STOP, 0, &tid);
	return	TRUE;
}

BOOL	music_start(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_START, 0, &tid);
	return	TRUE;
}

BOOL	music_closeall(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_CLOSE, 0, &tid);
	return	TRUE;
}

BOOL	music_load(char *file)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadOpen, (LPVOID) file, 0, &tid);
	return TRUE;
}
