BITS	32
ORG		00000000h					; as good as anything...
%include "../win32.inc"

;
; Patch code for 9x,nt,2k,xp.
;
;XCOM: UFO defense (aka   UFO: Enemy Unknown) windows version loader, by f0dder.
;That's f0dder@yahoo.com , http://f0dder.cjb.net, http://f0dder.has it.
;All rights desrever ;), 2001/12/17.
;
; This code will be written at the program entrypoint. It's job is to allocate
; a chunk of memory, copy the patch helper code, and apply the patch. All code
; must be position-independant. First code part (__entry) VirtualAlloc's space,
; moves "patch helper code" there, and patches the main program memory. Then it
; signals to the patcher that it's done, so stuff can be cleaned up, and the
; main thread can be resumed. Loader patches this code with EventHandle...
;
; I do register preservation even though it shouldn't really be necessary (the
; code is executed at entrypoint, at which time win32 gives no guarantee as to
; register content)... but why not, really ;).
;



;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; EQUs and such
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%ifdef XCOM1
LOADLIBRARY		equ 00469048h		; address of LoadLibrary import
VIRTALLOC		equ	0046902Ch		; address of VirtualAlloc import
GETMODULEHANDLE	equ	004690B8h		; address of GetModuleHandle import
GETPROCADDRESS	equ 004690C4h		; address of GetProcAddress import

PATCHOFS		equ 0042FF2Fh		; where the "call patchhelper" is put
SURFACEOFS		equ	00478604h		; lpDDSurface2 - the object we call
SZDDSURFDESC	equ	108				; sizeof(DDSURFACEDESC)
%elifdef XCOM2
LOADLIBRARY		equ 0047305Ch		; address of LoadLibrary import
VIRTALLOC		equ	004730FCh		; address of VirtualAlloc import
GETMODULEHANDLE	equ	004730D8h		; address of GetModuleHandle import
GETPROCADDRESS	equ 004730E0h		; address of GetProcAddress import

PATCHOFS		equ 004335DFh		; where the "call patchhelper" is put
SURFACEOFS		equ	00494964h		; lpDDSurface2 - the object we call
SZDDSURFDESC	equ	108				; sizeof(DDSURFACEDESC)
%else
%error Define either "XCOM1" or "XCOM2"
%endif

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; code
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
__entry:
	; this is the alloc-and-relocate entrypoint. At entry the 
	push		dword 0DEADBEEFh	; patched by loader to push EventHandle.
	mpush		ebx, ecx, edx, esi, edi, ebp

	stdcall		dword [VIRTALLOC], dword NULL, dword 4096, dword MEM_COMMIT, dword PAGE_EXECUTE_READWRITE

	; "assemble" patch
	mov			ebx, eax
	sub			ebx, (PATCHOFS + 5)
	mov			[PATCHOFS + 0], byte 0E8h		; call
	mov			[PATCHOFS + 1], ebx
	mov			[PATCHOFS + 5], word 9090h		; two nops

	; move patch in place - we have to use the delta trick here.
	call		.delta
.delta:
	pop			ebp
	sub			ebp, .delta

	lea			esi, [ebp + __patchHelper]
	mov			edi, eax
	mov			ecx, (__patchHelperEnd - __patchHelper)
	rep			movsb

%ifndef NOMUSFIX
	; NT/2k/XP music fix
	lea			eax, [ebp + szMusFixDll]
	stdcall		dword [LOADLIBRARY], eax
%endif

	; Get KERNEL32!SetEvent address
	lea			eax, [ebp + szKernel32]
	stdcall		dword [GETMODULEHANDLE], eax
	lea			ebx, [ebp + szSetEvent]
	stdcall		dword [GETPROCADDRESS], eax, ebx
	; call KERNEL32!SetEvent to signal loader we're done
	mpop		ebx, ecx, edx, esi, edi, ebp
	call		eax					; event handle is already on stack :P
	jmp			$					; we're done.

szKernel32	db "KERNEL32.DLL", 0
szSetEvent	db "SetEvent", 0
%ifndef NOMUSFIX
szMusFixDll	db "musfix.dll", 0
%endif

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; The patch helper. This is the code that makes it all click :).
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
__patchHelper:
	pushad
	; allocate stack space for the DDSURFDESC
	sub		esp, SZDDSURFDESC
	mov		dword [esp], SZDDSURFDESC

	; call the GetSurfaceDesc method
	; eax = lpDDSurface (this)
	; ebx = lpDDSurface->vtable
	mov		eax, [SURFACEOFS]		; lpDDSurface
	mov		ebx, [eax]				; lpDDSurface->vtable
	push	esp						; &ddsurfdesc
	push	eax						; DDSurface
	call	dword [ebx + 0x0058]	; lpDDSurfaceDesc->vtable[GetSurfaceDesc]

	mov		eax, [esp + 16]			; ddsurf.lPitch
	add		esp, SZDDSURFDESC		; clean up stack

	sub		eax, 320
	mov		dl, 200
	xor		ecx, ecx
.yloop:
	; yloop handles one full line
	mov		cl, 320/4
	rep		movsd
	add		edi, eax				; advance dest to next line
	dec		dl
	jnz		.yloop

	popad
	ret
__patchHelperEnd:
