

;   QUITE, QUITE not so simple ANSI/text viewer
;
;   Coded by IcEDraGoN [MiB]
;

    DOSSEG
    .MODEL SMALL
    .STACK 200h
    .DATA

;===- Data -===

BufferSeg   dw  0

ErrMsgOpen  db  "Error opening $"
FNamePtr    dw  0
FileHandle  dw  0
LastPage    dd  0                       ;0 is required for filename 
                                        ;(displays a space)
FileSize    dd 0

Screen1     db  4000 dup(?)
FileIndex   dd  0
Psp         dw  0
include         key.inc         

; 00 black
; 01 blue                                          7  6  5  4  3  2  1  0
; 02 green                                         |  |  |  |  |  |  |  |
; 03 blue-green                                    |  |  |  |  |  \---------  foreground
; 04 red                                           |  |  |  |  \------------  intensity
; 05 cyan                                          |  \---------------------  background
; 06 magenta                                       \------------------------  blinking  
; 07 dark-grey
; 08 light grey
; 09 light blue
; 10 light green
; 11 light blue-green
; 12 light red
; 13 light cyan
; 14 light brown
; 15 white

StatusBar   db " ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16
            db " ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24
            db " ",23," ",23," ",23," ",23," ",23," ",23," ",23," ",23," ",23," ",23
            db " ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31
            db " ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31," ",31
            db " ",23," ",23," ",23," ",23," ",23," ",23," ",23,"'",23," ",23," ",23
            db " ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24," ",24
            db " ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16," ",16


StatusBar2  db "                  "
            db "[aNSi-VieW 1.0- done by iCeDRaGoN/MiB '99]                      aNSi-VieW displays"
            db " DOS-ANSI files, which have an additional attribute byte after each char byte."
            db " You can use the tool ASTAN for converting ASCII-Text files into this format."
            db "         Full source code in ASM available at the MiB-Homepage. Greetz go out"
            db " to:     +CrueHead   Pero   +iNCuBuS  cTT    MEXELITE   +FraVia  ......      "
            db "                                                                             ",0
StatusPtr   dw 0       
DelayCount  db 0
ScrollMode  db 0



    .CODE
    .386
    Ideal
    jumps
    

extrn _Set_New_Int9:proc
extrn _Set_Old_Int9:proc


MACRO WaitVRetrace    
                LOCAL   VRetrace,NoVRetrace
                mov     dx,03dah
VRetrace:       in      al,dx
                test    al,00001000b
                jnz     VRetrace
NoVRetrace:     in      al,dx
                test    al,00001000b
                jz      NoVRetrace
ENDM

;===- Subroutines -===

PROC Readfirst NEAR

    push    ds
    mov     ax,3d00h    ;open file (ah=3dh)
    mov     dx, [FNamePtr]
    mov     ds, [Psp]
    int     21h
    jc      OpenError
    pop     ds
    mov     [FileHandle],ax       ;move the file handle into bx
    mov     bx, ax
    mov     dx,offset Screen1
    mov     ah,3fh
    mov     cx,0F00h       ;read first page
    int     21h

    ret

OpenError:
    pop     ds
    mov     ah,9
    mov     dx,offset ErrMsgOpen
    int     21h

    ret
ENDP Readfirst

PROC ReadNext NEAR
    
    push    ax
    push    bx
    push    dx

    xor     ax, ax
    mov     bx, [FileHandle]
    mov     dx,offset Screen1
    mov     ah,3fh
    mov     cx,0F00h       ;read first page
    int     21h

    pop     dx
    pop     bx
    pop     ax
    
    ret
ENDP ReadNext

PROC GetFileSize NEAR

    push    ax
    push    bx
    push    cx
    push    dx

    xor     ax, ax
    mov     ah,42h      ;find out the size of the file
    mov     bx,[FileHandle]
    xor     cx,cx
    xor     dx,dx
    mov     al,2
    int     21h
    mov     [word low FileSize],ax
    mov     [word high FileSize],dx ;load data into filesize

    mov     eax, [FileSize]

    sub     eax, 3840

    mov     [LastPage], eax
    pop     dx
    pop     cx
    pop     bx
    pop     ax

    ret

ENDP GetFileSize

PROC MovePtr NEAR

    push    ax
    push    bx
    push    cx
    push    dx

    xor     ax, ax
    mov     ah,42h      ;find out the size of the file
    mov     bx,[FileHandle]
    xor     cx,cx
    xor     dx,dx
    mov     dx,[word low FileIndex]
    mov     cx,[word high FileIndex]
    int     21h

    pop     dx
    pop     cx
    pop     bx
    pop     ax

    ret

ENDP MovePtr

PROC ShowScreen NEAR

    push    ax
    push    cx
    push    di
    push    si

    mov     ax,0b800h               ; dump status bar to screen
    mov     es,ax
    xor     di,di
    mov     si,offset Screen1
    mov     cx, 2000
    rep     movsw

    mov     di, 0F00h
    mov     si,offset StatusBar
    mov     cx, 80
    rep     movsw

    pop     si
    pop     di
    pop     cx
    pop     ax

    ret


ENDP ShowScreen

PROC ShowScreen2 NEAR

    push    ax
    push    cx
    push    di
    push    si

    mov     ax,0b800h               ; dump status bar to screen
    mov     es,ax
    xor     di,di
    mov     si,offset Screen1
    mov     cx, 1920
    rep     movsw


    mov     di, 0F00h
    inc     [DelayCount]
    cmp     [DelayCount], 15
    jne     GoAhead
    mov     [DelayCount], 0
    inc     [StatusPtr]

GoAhead:
    mov     si, [StatusPtr]
    lodsb
    cmp     al, 0
    jne     GoOn
    mov     si, offset StatusBar2
    mov     [StatusPtr], si
    lodsb
GoOn:
    mov     cx, 80
MoveLoop:
    mov     [es:di], al
    lodsb
    cmp     al, 0
    jne     GoOn2
    mov     si, offset StatusBar2
    lodsb
GoOn2:
    add     di, 2
    dec     cx
    cmp     cx, 0
    jnz     MoveLoop

    pop     si
    pop     di
    pop     cx
    pop     ax

    ret


ENDP ShowScreen2

;===- Main Program -===

START:
    mov     ax, @DATA
    mov     ds,ax
    mov     [Psp],es                ; Save the PSP address.
    call    _Set_New_Int9
    mov     ax,0003h
    int     10h
    mov     ax,0100h                ; hide the cursor
    mov     cx,0800h
    int     10h
    mov     ah, 03
    mov     al, 05                  ;set the typematic rate/delay
    mov     bh, 03                  ;set repeat delay to 1000ms
    mov     bl, 1Fh                 ;set rate to 2.0
    int     16h


GetFileName:    mov     es,[Psp]                ; Parse  the Command line...
                mov     si,80h
                mov     al,[es:si]
                mov     bl,al
                xor     bh,bh
                inc     bx
                mov     [byte ptr es:si+bx],0   ; make AsciiZ filename.
ScanName:       inc     si
                mov     al,[es:si]
                test    al,al
                je      Exit
                cmp     al,20h
                je      ScanName                ; scan start of name.
                mov     di,si
ScanPeriod:     inc     si
                mov     al,[es:si]
                cmp     al,'.'                  ; if period NOT found,
                je      LoadFile                ; then add a .MOD extension.
                test    al,al
                jne     ScanPeriod

SetExt:         mov     [Byte Ptr es:si+0],'.'
                mov     [Byte Ptr es:si+1],'A'
                mov     [Byte Ptr es:si+2],'N'
                mov     [Byte Ptr es:si+3],'S'
                mov     [Byte Ptr es:si+4],0


LoadFile:
    mov     [FNamePtr], di
    mov     [FileIndex], 0
    call    Readfirst               ;read first page
    call    GetFileSize             
    call    MovePtr                 ;set pointer to start
    call    ReadNext                ;read page
    call    ShowScreen              ;display

; check pressed keys

    get_key: 
                cmp     [cs:_keys+kSPACE],1     ; cursor up?
                je      key_space
                cmp     [cs:_keys+kUARROW],1     ; cursor up?
                je      key_up
                cmp     [cs:_keys+kKEYPAD8],1    ; cursur up?
                je      key_up
                cmp     [cs:_keys+kDARROW],1     ; cursor down?
                je      key_down
                cmp     [cs:_keys+kKEYPAD2],1    ; cursor down?
                je      key_down
                cmp     [cs:_keys+kPGUP],1       ; pgup?
                je      key_pgup
                cmp     [cs:_keys+kPGDN],1       ; pgdn?
                je      key_pgdn
                cmp     [cs:_keys+kHOME],1       ; home?
                je      key_home
                cmp     [cs:_keys+kEND],1        ; end?
                je      key_end
                cmp     [cs:_keys+kESC],1        ; esc?
                je      exit
                cmp     [ScrollMode],0
                jne     ShowStatusBar
                mov     [DelayCount],0
ShowStatusBar:
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key






key_space:      
                cmp     [ScrollMode],1
                jne     Set1
                mov     [ScrollMode],0
                jmp     get_key
Set1:
                mov     [ScrollMode],1
                jmp     get_key



key_up:         cmp     [FileIndex],0           ; at top?
                je      get_key                ; if so, jump
                jl      key_home
                sub     [FileIndex], 160             
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                WaitVRetrace
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key

key_down:
                mov     edx, [LastPage]
                cmp     [FileIndex], edx
                je      get_key
                jg      key_end
                add     [FileIndex], 160
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                WaitVRetrace
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key

key_pgdn:
                mov     edx, [LastPage]
                cmp     [FileIndex], edx
                je      get_key
                jg      key_end
                add     [FileIndex], 3840
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key


key_pgup:
                cmp     [FileIndex],0           ; at top?
                je      get_key                ; if so, jump
                jl      key_home
                sub     [FileIndex], 3840             
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key


key_home:       cmp     [FileIndex],0
                je      get_key
                mov     [FileIndex],0
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key
                
key_end:
                mov     edx, [LastPage]
                cmp     [FileIndex], edx
                je      get_key

                mov     [FileIndex], edx
                call    MovePtr
                call    ReadNext
                WaitVRetrace
                call    ShowScreen2
                jmp     get_key
                
                
exit:
    call    _Set_Old_Int9
    mov     ax,0003h                ; text mode 3
    int     10h
    mov     bx,[FileHandle]
    mov     ah,3eh
    int     21h
    mov     ax,4c00h                ; exit
    int     21h



END START
