    DOSSEG
    .MODEL SMALL
    .STACK 200h
    .DATA

;===- Data -===

BufferSeg    dw  0

ErrMsgOpen   db  "Error opening `"
AsciiName    db  "ANSI.TXT",0,8,"'$"     ;8 is a delete character
ErrMsgWrite  db  "Error writing file","$"
AnsiName     db  "ANSI.ans",0
ErrMsgCreate db  "Error creating file","$"
FileHandle   dw  0
FileHandle2  dw  0
LastPage     dw  0
WriteByte    db  0
ReadByte     db  0
ColorByte    db  0Fh
FileSize     dw  0
CharsLeft    db  0

Screen1      db  4000 dup(?)
FileIndex    dw  0
FileIndex2   dw  0

include         key.inc         

; 00 black
; 01 blue                                          7  6  5  4  3  2  1  0
; 02 green                                         |  |  |  |  |  |  |  |
; 03 blue-green                                    |  |  |  |  |  \---------  foreground
; 04 red                                           |  |  |  |  \------------  intensity
; 05 cyan                                          |  \---------------------  background
; 06 magenta                                       \------------------------  blinking  
; 07 light grey
; 08 dark-grey
; 09 light blue
; 10 light green
; 11 light blue-green
; 12 light red
; 13 light cyan
; 14 light brown
; 15 white



    .CODE
    Ideal
    jumps



MACRO WaitVRetrace    
                LOCAL   VRetrace,NoVRetrace
                mov     dx,03dah
VRetrace:       in      al,dx
                test    al,00001000b
                jnz     VRetrace
NoVRetrace:     in      al,dx
                test    al,00001000b
                jz      NoVRetrace
ENDM

;===- Subroutines -===

PROC OpenFile NEAR

    mov     ax,3d00h    ;open file (ah=3dh)
    mov     dx,offset AsciiName
    int     21h
    jc      OpenError
    mov     [FileHandle],ax       ;move the file handle into bx


;    mov     ah,3eh
;    int     21h             ;close the file

    ret

OpenError:
    mov     ah,9
    mov     dx,offset ErrMsgOpen
    int     21h

    ret
ENDP OpenFile

PROC WriteFile NEAR

    mov     bx,[FileHandle2]
    mov     dx,offset WriteByte
    mov     ah,40h
    mov     cx,01h
    int     21h
    cmp     [CharsLeft], 64
    jl      Test1
    mov     [ColorByte], 08
    jmp     WriteColor

Test1:
    cmp     [CharsLeft], 48
    jl      Test2
    mov     [ColorByte], 07 
    jmp     WriteColor

Test2:
    cmp     [CharsLeft], 32
    jl      Test3
    mov     [ColorByte], 15 
    jmp     WriteColor

Test3:
    cmp     [CharsLeft], 16
    jl      Test4
    mov     [ColorByte], 07 
    jmp     WriteColor
                          
Test4:
    mov     [ColorByte], 08 

WriteColor:
    mov     bx,[FileHandle2]
    mov     dx,offset ColorByte
    mov     ah,40h
    mov     cx,01h
    int     21h

    cmp     cx,ax
    jne     WriteError
    ret

WriteError:
    mov     ah,9
    mov     dx,offset ErrMsgWrite
    int     21h
    ret



ENDP WriteFile

PROC CreateFile

    mov     ah,3ch
    mov     dx,offset AnsiName
    mov     cx,0        ;no attributes
    int     21h
    jc      CreateError

    mov     [FileHandle2],ax

    ret

CreateError:
    mov     ah,9
    mov     dx,offset ErrMsgCreate
    int     21h
    ret

ENDP CreateFile





PROC ReadNext NEAR
    
    push    bx
    push    dx

    xor     ax, ax
    mov     bx, [FileHandle]
    mov     dx,offset ReadByte
    mov     ah,3fh
    mov     cx,01h       ;read byte
    int     21h

    pop     dx
    pop     bx
    
    ret
ENDP ReadNext

PROC MovePtr1 NEAR

    push    ax
    push    bx
    push    cx
    push    dx

    xor     ax, ax
    mov     ah,42h     
    mov     bx,[FileHandle]
    xor     cx,cx
    xor     dx,dx
    add     dx, [FileIndex]
    int     21h

    pop     dx
    pop     cx
    pop     bx
    pop     ax

    ret

ENDP MovePtr1

PROC MovePtr2 NEAR

    push    ax
    push    bx
    push    cx
    push    dx

    xor     ax, ax
    mov     ah,42h     
    mov     bx,[FileHandle2]
    xor     cx,cx
    xor     dx,dx
    add     dx, [FileIndex2]
    int     21h

    pop     dx
    pop     cx
    pop     bx
    pop     ax
    ret

ENDP MovePtr2


;===- Main Program -===

START:
    mov     ax, @DATA
    mov     ds,ax

    call OpenFile
    call CreateFile
    mov  [CharsLeft], 80
    
ReadLoop:
    call ReadNext
    cmp  ax, 0h
    je   exit

;check for 0d 0a
    cmp  [ReadByte], 020h
    jge  IsChar

    cmp  [ReadByte], 0Dh
    jne  NextRead

    call ReadNext
    cmp  ax, 0h
    je   exit

    cmp  [ReadByte], 0Ah
    jne  NextRead

    mov  [WriteByte], 020h
    xor  cx, cx
    mov  cl, [CharsLeft]
FillLine:
    push cx
    call WriteFile
    pop  cx
    dec  cl
    cmp  cl, 0 
    jnz  FillLine
    mov  [CharsLeft], 80
    jmp  ReadLoop


IsChar:
    mov  al, [ReadByte]
    mov  [WriteByte], al
    jmp  Write


Write:
    call WriteFile
    dec  [CharsLeft]
    cmp  [CharsLeft], 0
    jnz  NextRead
    mov  [CharsLeft], 80

NextRead:
    jmp  ReadLoop
                
                
exit:
    mov  [WriteByte], 020h
    xor  cx, cx
    mov  cl, [CharsLeft]
FillLine2:
    push cx
    call WriteFile
    pop  cx
    dec  cl
    cmp  cl, 0 
    jnz  FillLine2

    mov     bx,[FileHandle]
    mov     ah,3eh
    int     21h
    mov     bx,[FileHandle2]
    mov     ah,3eh
    int     21h

    mov     ax,4c00h                ; exit
    int     21h



END START
