;Sparkle v1.0
;Written by Cruehead as the fouth part of the 1999 +HCU strainer
;TASM version

.386
locals
jumps
.model flat,STDCALL
include win32.inc           
L equ <LARGE>

ID_TIMER		EQU 1

;-------------------------------------------
; .-.-.- Begining of the DATA segment -.-.-.
;-------------------------------------------

.data

BrushHwnd		 dd 0
PenHwnd			 dd 0
MyHwnd		 	 dd 0
MyDC			 dd 0

colourvalue		 dd 0
count2			 dd 0
counter			 dd 0
seed			 dd 0

msg              MSGSTRUCT   <?>
wc               WNDCLASS    <?>
RC				 RECT	     <?>

szNULL   		 db 0
ymenu    		 dd 0

hInst            dd 0
hMenu            dd 0
hDlg             dd 0

szTitleName      db 'Sparkles, sparkles everywhere!',0
szClassName      db 'ASMCLASS32',0

Colours			 dd 000ff3131h					;Blue
				 dd 000ff9595h					;Light blue
				 dd 000ffffffh					;White
				 dd 0000000c6h					;Red
				 dd 0008a8affh					;Light red
				 dd 000ffffffh					;White
				 dd 00000a800h					;Green
				 dd 00015ff15h					;Light green
				 dd 000ffffffh					;White
				 dd 0001562ffh					;Orange (the colour, not the fruit)
				 dd 0006f9dffh					;Light orange
				 dd 000ffffffh					;White

EllipsePara1	 db 011h,011h,00Eh,00Eh			;Here we save the parameters that we use 
				 db 012h,012h,00Dh,00Eh			;for the first ellipse
				 db 014h,013h,00Ch,00Dh			;We use four parameters for every time we call			
				 db 015h,014h,00Bh,00Ch			;the function, that's why I divided them
				 db 016h,015h,009h,00Bh			;like this
				 db 017h,016h,008h,00Ah
				 db 019h,016h,007h,009h
				 db 01Ah,017h,006h,008h
				 db 019h,016h,007h,009h
				 db 017h,016h,008h,00Ah
				 db 016h,015h,009h,00Bh
				 db 015h,014h,00Bh,00Ch
				 db 014h,013h,00Ch,00Dh
				 db 012h,012h,00Dh,00Eh
				 db 011h,011h,00Eh,00Eh

EllipsePara2	 db 012h,011h,00Eh,00Fh			;Same as above, but this time it's parameters
				 db 013h,012h,00Dh,00Eh			;for another ellipse
				 db 014h,013h,00Bh,00Dh
				 db 015h,014h,00Ah,00Ch
				 db 017h,014h,009h,00Bh
				 db 018h,015h,008h,00Ah
				 db 017h,014h,009h,00Bh
				 db 015h,014h,00Ah,00Ch
				 db 014h,013h,00Bh,00Dh
				 db 013h,012h,00Dh,00Eh
				 db 012h,011h,00Eh,00Fh

EllipsePara3	 db 012h,011h,00Dh,00Fh			;And once again...parameters for the
				 db 013h,012h,00Ch,00Eh			;third ellipse
				 db 015h,012h,00Bh,00Dh
			 	 db 016h,013h,00Ah,00Ch
				 db 015h,012h,00Bh,00Dh
				 db 013h,012h,00Ch,00Eh
				 db 012h,011h,00Dh,00Fh

MoveToExPara	 db 0Fh,0Dh						;The parameters we'll need for the
				 db 0Bh,0Fh						;"MoveToEx" function
				 db 0Fh,0Dh
				 db 0Ah,0Fh
				 db 0Fh,0Ch
				 db 09h,0Fh
				 db 0Fh,0Bh
				 db 08h,0Fh
				 db 0Fh,0Ah
				 db 06h,0Fh
				 db 0Fh,09h
				 db 05h,0Fh
				 db 0Fh,08h
				 db 04h,0Fh
				 db 0Fh,07h
				 db 03h,0Fh
				 db 0Fh,08h
				 db 04h,0Fh
				 db 0Fh,09h
				 db 05h,0Fh
				 db 0Fh,0Ah
				 db 06h,0Fh
				 db 0Fh,0Bh
				 db 08h,0Fh
				 db 0Fh,0Ch
				 db 09h,0Fh
				 db 0Fh,0Dh
				 db 0Ah,0Fh
				 db 0Fh,0Dh
				 db 0Bh,0Fh

LineToPara		 db 00fh,012h					;Parameters that are used with the
				 db 014h,00fh					;"LineToPara" function
				 db 00fh,013h
				 db 015h,00fh
				 db 00fh,014h
				 db 017h,00fh
				 db 00fh,015h
				 db 018h,00fh
				 db 00fh,016h
				 db 019h,00fh
				 db 00fh,017h
				 db 01ah,00fh
				 db 00fh,017h
				 db 01ch,00fh
				 db 00fh,018h
				 db 01dh,00fh
				 db 00fh,017h
				 db 01ch,00fh
				 db 00fh,017h
				 db 01ah,00fh
				 db 00fh,016h
				 db 019h,00fh
				 db 00fh,015h
				 db 018h,00fh
				 db 00fh,014h
				 db 017h,00fh
				 db 00fh,013h
				 db 015h,00fh
				 db 00fh,012h
				 db 014h,00fh
				 
;--------------------------------------------------------------------------------------
;                       .-.-.- Code Segment starts here -.-.-.
;--------------------------------------------------------------------------------------
;
; Dont care to much for code that's undocumented, as they really havnt got anything
; to do with the real interesting part (the sparkle code that is)...If you're interested
; in Win32 ASM coding then I suppose it might be interesting to check out those
; functions as well...
;
;--------------------------------------------------------------------------------------
.code

start:
        push    L 0
        call    GetModuleHandle         
        mov     [hInst], eax            
                                        
        push    L 0
        push    offset szClassName
        call    FindWindow              ;More than one program opened?
        or      eax,eax                 
        jz      reg_class               
        ret                             

reg_class:

        mov     [wc.clsStyle], CS_HREDRAW + CS_VREDRAW + CS_GLOBALCLASS
        mov     [wc.clsLpfnWndProc], offset WndProc
        mov     [wc.clsCbClsExtra], 0
        mov     [wc.clsCbWndExtra], 0

        mov     eax, [hInst]
        mov     [wc.clsHInstance], eax

        push    L IDC_ARROW             
        push    L 0
        call    LoadCursor
        mov     [wc.clsHCursor], eax

        mov     [wc.clsHbrBackground], COLOR_BACKGROUND
        mov     dword ptr [wc.clsLpszClassName], offset szClassName

        push    offset wc
        call    RegisterClass

        push    L 0                      		
        push    [hInst]                  		
        push    L 0                      		
        push    L 0                      		
        push    L 290          			 		
        push    L 280          			 		
        push    L 150                    		
        push    L 170                    		
        push    L WS_OVERLAPPEDWINDOW    		
        push    offset szTitleName       		
        push    offset szClassName       		
        push    L 0	 		 			 		
        call    CreateWindowEx
        mov     [MyHwnd], eax

		push	[MyHwnd]
		call	GetDC							;Get a Device Context for drawing purposes
		mov		MyDC,eax						;We need one if we want to draw anything!
												
		push    offset DrawProc
        push    35              				;A 35 ms timer
        push    ID_TIMER		        		;Timer ID
        push    [MyHwnd]   				        ;Hwnd
        call    SetTimer						;We'll use a timer to draw/remove anything
												;on the screen.
        push    L SW_SHOWNORMAL
        push    [MyHwnd]
        call    ShowWindow

        push    [MyHwnd]
        call    UpdateWindow

		add esp,12

        call    GetTickCount					;Initialize seed value
        mov     seed, eax						;Used to decide where on the screen we shall
												;draw the sparkle.

		call	random							;Value returned in eax as well as in
												;the variabel 'seed' is a random number

		and		al,00fh							;We delete everything in AL (which contains
												;a random number) except the low part of it.
												;That means that we'll have a value from 0-F
												;saved in AL, and that's used when we choose
												;a colour

		call	ChooseColour					;Chooses one of four colour. The decision is
												;made by using the value in AL.
												;Output returned in ebx (a value from 0-3)
												
		lea		ebx,[ebx*2+ebx]					;Multiply ebx with three
		shl		ebx,2							;and multiply this with 4
												;So, bascily, ebx is multiplyed with 12.

		mov		colourvalue,ebx					;And saved away in a variable. 
												;Why? Becuase it's used as a pointer in the
												;"Colours" variable that hold all the colour
												;values

;-----------------------------------------------------

msg_loop:
        push    L 0
        push    L 0
        push    L 0
        push    offset msg
        call    GetMessage

        cmp     ax, 0
        je      end_loop

        push    offset msg
        call    TranslateMessage

        push    offset msg
        call    DispatchMessage

        jmp     msg_loop

end_loop:
        push    [msg.msWPARAM]
        call    ExitProcess             

;-----------------------------------------------------

WndProc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
        push    esi
        push    edi
        push    ebx
		LOCAL   theDC:DWORD

        cmp     [wmsg], WM_DESTROY
        je      wmdestroy
        cmp     [wmsg], WM_SIZE
        je      wmsize
        cmp     [wmsg], WM_CREATE
        je      wmcreate
        jmp     defwndproc

wmcreate:
        mov     eax, 0
        jmp     finish

defwndproc:
        push    [lparam]
        push    [wparam]
        push    [wmsg]
        push    [hwnd]
        call    DefWindowProc
        jmp     finish

wmdestroy:

		push	[MyDC]							;We get to here when we quit, and then we
		push	[MyHwnd]						;have to delete the DC so that Windows
		call	ReleaseDC						;will deallocate memory for it

        push    ID_TIMER						;We have to destory the timer as well
        push    [MyHwnd]
        call    KillTimer

        push    L 0
        call    PostQuitMessage
        mov     eax, 0
        jmp     finish
wmsize:
        mov     eax, 0
        jmp     finish
        
finish:
        pop     ebx     						;Remember we must restore these registers
        pop     edi     						;because the OS need them
        pop     esi
        ret
WndProc          endp

DrawProc proc
		pusha									;Just to make sure that we dont mess with
												;any registers that the OS wants to use.

		call	RemoveOldPaint					;Remove what we have just painted
		mov		ebx,colourvalue

		inc		counter
		cmp		counter,15						;Have we drawn every bit of the sparkle?
		jne		DrawSparkle						;If not, lets draw again

		mov		counter,0						;used as an innerloop counter

		call	random							;Fetch a random number, returned in EAX
		and		al,00fh
		call	ChooseColour					;Choose a colour

		lea		ebx,[ebx*2+ebx]
		shl		ebx,2
		mov		colourvalue,ebx					;Multiply EBX with 12 (you recognize this
												;I hope...It's exactly that same as I have
												;already described above)

		DrawSparkle:
		push	dword ptr Colours[ebx]			;ebx points to a colour value in the "colours"
		push	0								;variable
		push	PS_SOLID
		call	CreatePen						;Here we say that will use the colour above
		mov		PenHwnd,eax						;as the pen (that is used to draw the lines
												;on the outermost ellipse)
		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject					;Select the pen into the device context

		push	eax								;Delete the previous saved pen in the
		call	DeleteObject					;device context to deallocate memory

		push	dword ptr Colours[ebx]			;Create a colour to fill the outermost ellipse
		call	CreateSolidBrush
		mov		BrushHwnd,eax

		push	[BrushHwnd]
		push	[MyDC]
		call	SelectObject					;Select the brush we just created in the 
												;device context.

		push	eax								;And as usuall, delete the previous brush
		call	DeleteObject

		call	DrawEllipse1					;Draws the first ellipse
		mov		ebx,colourvalue

		cmp		counter,2						;Are we going to draw another ellipse?
		jb		NoMoreEllipses					;If we are, dont take the jump
												;It all depends on how many times we have gone
												;through this loop

		cmp		counter,13						;The same question here...
		ja		NoMoreEllipses

		cmp		counter,4						;Here we decide what colour this ellipse will
		jae		PushOtherColour					;have. As above, it depends on how many times
												;we have gone through the loop

		cmp		counter,10						;Same question here...
		ja		PushOtherColour

		push	dword ptr Colours[ebx+8]		;Use a white colour for the pen
		push	0
		push	PS_SOLID
		call	CreatePen
		mov		PenHwnd,eax

		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax
		call	DeleteObject

		push	dword ptr Colours[ebx+8]		;Use a white colour for the brush
		call	CreateSolidBrush
		mov		BrushHwnd,eax
		jmp		GoHere
		
		PushOtherColour:

		push	dword ptr Colours[ebx+4]		;Use a light shade of the colour for the pen
		push	0
		push	PS_SOLID
		call	CreatePen
		mov		PenHwnd,eax

		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax
		call	DeleteObject

    	push	dword ptr Colours[ebx+4]		;Use a light shade of the colour for the brush
		call	CreateSolidBrush
		mov		BrushHwnd,eax

		GoHere:

		push	[BrushHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax
		call	DeleteObject

		call	DrawEllipse2					;Draws the second ellipse
		mov		ebx,colourvalue

		cmp		counter,4						;Once more, the question is - shall we draw
		jb		NoMoreEllipses					;another ellipse?

		cmp		counter,10						;Same question
		ja		NoMoreEllipses

		push	dword ptr Colours[ebx+8]		;Create a white pen for the third ellipse
		call	CreateSolidBrush
		mov		BrushHwnd,eax					

		push	[BrushHwnd]
		push	[MyDC]
		call	SelectObject		

		push	eax
		call	DeleteObject

		push	dword ptr Colours[ebx+8]		;Create a white brush for the third ellipse
		push	0
		push	PS_SOLID
		call	CreatePen
		mov		PenHwnd,eax

		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax
		call	DeleteObject

		call	DrawEllipse3					;Draw the third ellipse
		mov		ebx,colourvalue

		NoMoreEllipses:

		push	0ffffffh						;Create a white pen, used for drawing lines
		push	0
		push	PS_SOLID		
		call	CreatePen
		mov		PenHwnd,eax

		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax
		call	DeleteObject

		call	DrawLines						;Draws the lines in the ellipse(es)
		mov		ebx,colourvalue

		push	[BrushHwnd]
		call	DeleteObject

		push	[PenHwnd]						;We have to clean up the mess we created
		call	DeleteObject					;before we quit

		popa									;Restore the registers
		ret	
DrawProc endp

;----------------------------------------------------------------
; Here comes all the functions that are called from the main code
;----------------------------------------------------------------

ChooseColour:
		cmp		al,03h							;If AL 0-3 then we'll use a blue colour
		ja		notblue
		mov		ebx,0
		jmp		gotcolour
		notblue:
		cmp		al,07h							;If AL 4-7 then we'll use a red colour
		ja		notred
		mov		ebx,1
		jmp		gotcolour
		notred:
		cmp		al,0bh							;If Al 8-11 then we'll use a green colour
		ja		notgreen
		mov		ebx,2
		jmp		gotcolour
		notgreen:
		mov		ebx,3							;If Al is non of the above (that means that
		gotcolour:								;AL must be 12-15) then we'll use 
												;an orange colour

												;The value in ebx represent the colour.
												;0 - blue
												;1 - red
												;2 - green
												;3 - orange
ret

DrawEllipse1:
		xor		eax,eax
		mov		ebx,counter						;Multiply with four, as there are four
		shl		ebx,2							;parameters
		mov		edx,seed						;Use the lower part of SEED once again to
		and		edx,0ffh						;decide where on the screen we shall draw
		mov		al,byte ptr EllipsePara1[ebx]   ;EBX is a pointer in the "EllipsePara1" varaible
		add		ax,dx							;that points to the parameter that we'll use.
		push	eax
		mov		al,byte ptr EllipsePara1[ebx+1]	;Get the second parameter
		add		ax,dx							;add DX to AX in order to draw the sparkle
		push	eax								;on a random place on the screen
		mov		al,byte ptr EllipsePara1[ebx+2] ;Get the third parameter
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara1[ebx+3] ;Get the fourth parameter
		add		ax,dx
		push	eax
		push	[MyDC]							;Push the Devide Context
		call	Ellipse							;And draw the ellipse!
ret

DrawEllipse2:
		xor		eax,eax							;Look at the comments on "DrawEllipse1" 
		mov		ebx,counter						;as the functions are pretty much the same
		sub		ebx,2							;just different parameters
		shl		ebx,2
		mov		edx,seed
		and		edx,0ffh
		mov		al,byte ptr EllipsePara2[ebx]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara2[ebx+1]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara2[ebx+2]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara2[ebx+3]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	Ellipse
ret

DrawEllipse3:
		xor		eax,eax							;Look at the comments on "DrawEllipse1"
		mov		ebx,counter						;As the functions are pretty much the same
		sub		ebx,4							;just different parameters
		shl		ebx,2
		mov		edx,seed
		and		edx,0ffh
		mov		al,byte ptr EllipsePara3[ebx]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara3[ebx+1]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara3[ebx+2]
		add		ax,dx
		push	eax
		mov		al,byte ptr EllipsePara3[ebx+3]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	Ellipse
ret

RemoveOldPaint:
		push	0ffffffh
		push	0
		push	PS_SOLID
		call	CreatePen
		mov		PenHwnd,eax

		push	[PenHwnd]
		push	[MyDC]
		call	SelectObject

		push	eax		
		call	DeleteObject					;Everytime we select a new object we have
												;to delete the old one, otherwise windows
												;wont deallocate memory!
		push	0c0c0c0h					
		Call	CreateSolidBrush
		mov		BrushHwnd,eax

		mov		edx,seed
		and		edx,0ffh						;the low part of the "seed" variable is used
												;as "where on screen will we draw". That way
												;we get the sparkles to move around.
		mov		RC.left,edx
		mov		RC.top,edx
		add		dx,020h
		mov		RC.right,edx
		mov		RC.bottom,edx
	
		push	[BrushHwnd]						;Handle for the brush
		push	offset RC
		push	[MyDC]
		call	FillRect						;Fill a rectange with the background value
												;Thus removing anything we might have painted
												;there before.
ret

DrawLines:
		xor		eax,eax
		mov		ebx,counter	
		lea		ebx,[ebx*2]
		shl		ebx,1							;Multiply with four as there are two
		push	0								;parameters for each "MoveToEx" function
		mov		edx,seed						;and there are 2 MoveToEx functions
		and		edx,0ffh
		mov		al,byte ptr MoveToExPara[ebx]
		add		ax,dx
		push	eax
		mov		al,byte ptr MoveToExPara[ebx+1]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	MoveToEx

		xor		eax,eax
		mov		ebx,counter
		shl		ebx,2							;Same as above, multiply with four as
		mov		edx,seed						;there are two parameters for each "LineTo"
		and		edx,0ffh						;function, and there are 2 of them
		mov		al,byte ptr LineToPara[ebx]
		add		ax,dx
		push	eax
		mov		al,byte ptr LineToPara[ebx+1]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	LineTo

		xor		eax,eax							;Here begins the second "MoveToEx" function
		mov		ebx,counter	
		lea		ebx,[ebx*2]
		shl		ebx,1
		push	0
		mov		edx,seed
		and		edx,0ffh
		mov		al,byte ptr MoveToExPara[ebx+2]
		add		ax,dx		
		push	eax
		mov		al,byte ptr MoveToExPara[ebx+3]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	MoveToEx

		xor		eax,eax							;Here begins the second "LineTo" function
		mov		ebx,counter
		shl		ebx,2
		mov		edx,seed
		and		edx,0ffh
		mov		al,byte ptr LineToPara[ebx+2]
		add		ax,dx
		push	eax
		mov		al,byte ptr LineToPara[ebx+3]
		add		ax,dx
		push	eax
		push	[MyDC]
		call	LineTo
ret

;Used to choose colour, and to draw the sparkle
;on a somewhat random place on the screen

random:											;Ok, I stole the begining of this routine from
		mov     eax, 214013						;another program. Sorry, but I cant remember
        imul    seed							;the name of it. Anyway, this routine returnes
		xor		edx,edx							;a random value in the variable "seed", as well
        add     eax, 2531011					;as in EAX.
		cmp		al,0e2h							
		jb		noproblemo						
		add		al,01eh							;Just a small fix, otherwise it wouldnt look
		noproblemo:								;very nice...dont worry (be happy :)) about it
        mov     seed, eax
        ret
ret

public WndProc
end start
