/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     LEXYY.C                                      */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0                                          */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Lexycal analyzer                             */
/*                                                        */
/* Create:   06.08.1996 21:39:20                          */
/* Update:   19.08.1998 17:17:30                          */
/*                                                        */
/* Revision: 2.0   19.08.1998 17:17:30 2.0 release        */
/* Revision: 1.1a   13.08.1997 13:34:04 Russian charset   */
/*           bug fixed.                                   */
/* Revision: 1.1   26.08.1996 14:29:40 Special charset    */
/*           added.                                       */
/* Revision: 1.0   06.08.1996 21:39:20 Initial revision   */
/*           (implemented in cRARk 1.5)                   */
/*--------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "y.tab.h"
#include "yaccdef.h"
//#include "pcl.h"

#define ret(r) { letter[0] = c; letter[1] = '\0';\
                 yylval.set = letter;  return (r); }


yylex()
{
  int c, c1;
  int i = 0;
  int sign;
  long lval;
  static char letter[max (MAXPATHLEN + 1, 257)];     /* maybe file name */

  while ( (c = getc(yyin)) == ' ' || c == '\t');

  if (c == '#') {
   if ((c = getc(yyin)) == '#') {
     if ((c1 = getc(yyin)) == '\n') return (TBREAK);
     else ungetc(c1, yyin);
   }
  while ( c != '\n' && c != EOF) c = getc(yyin);
  }

  if (c == EOF) return (F_EOF);

  if (c == '$') {
    c = getc(yyin);
    if (c == 'A') return (S_EUPPER);
    if (c == 'a') return (S_ELOWER);
    if (c == '1') return (S_DIGITS);
    if (c == '!') return (S_SYMBOLS);
    if (c == 'I') return (S_RUPPER);
    if (c == 'i') return (S_RLOWER);
    if (c == 'o') return (S_USER);
    if (c == 's') return (S_SPECIAL);
    if (c == 'p') return (S_USEDCHARS);
    if (c == 'v') return (S_VOWELS);

    if (c == 'w') return (WORD);
    if (c == 'u') return (USER_WORD);

    if (c == '?') return (ANY_LETTER);

    yyerror ("Invalid macro");
  }

   if (c == '.') {
    c = getc(yyin);
    if (isdigit (c)) goto DIGIT;

     switch (c) {

      case 't': return (W_TRUNC);
      case 'u': return (W_UPPER);
      case 'l': return (W_LOWER);
      case 'c': return (W_CONVERT);
      case 'd': return (W_DUPLICATE);
      case 'j': return (W_COOL);
      case 's': return (W_CONSONANT);
      case 'r': return (W_REVERSE);
      default: yyerror ("Invalid modifier");
     }

    }

    if (c == '\"') {
      i = 0;
      while ((c = getc (yyin)) != '\"') {
        if (c == '\\') c = getc (yyin);
        letter[i++] = c;
      }
      letter[i] = '\0';
      yylval.set = letter; return (QSTRING);
    }


    if (c == '\\') {
      c = getc(yyin);

     if (isxdigit (c)) {
       lval = 0;
       while (isxdigit(c)) {
         lval = lval * 16 + (isdigit(c) ? (toupper(c) - '0') :
                                          (toupper(c) - 'A' + 10));
         c = getc (yyin);
       }

       ungetc (c, yyin);

       if (lval > 0xFF) yyerror ("Invalid hex number");
       c = (int) lval;
     }
     if (c == 0) return (NULL_CHAR);
     ret (LETTER);
    }

    if (c == '(') {
      while ( (c = getc(yyin)) == ' ' || c == '\t');

    if (c == '-') {
      if ((c = getc(yyin)) == ')') { yylval.num = -1; return (NUMBER); }
      sign = -1;
    }
    else sign = 1;

    if (isdigit (c)) {

DIGIT:
     lval = 0;
     while (isdigit(c)) {
       lval = lval * 10 + (c) - '0';
       c = getc (yyin);
     }
     while ( c == ' ' || c == '\t') c = getc (yyin);
     if (c != ')') ungetc (c, yyin);

     if (sign == -1) lval = -lval - 1;
     yylval.num = (int) lval;
//     if (lval == 0) yyerror ("Numbers must be greather than 0");
     return (NUMBER);
    }
    else yyerror ("Invalid number");
    }

    if (c == '?' || c == '[' || c == ']'|| c == '\n' || c == '{' || c == '}'|| c == '*' || c == '=')
       return (c);
    ret (LETTER);
}

