/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     PRECOMP.Y                                    */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0c                                         */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Precompiler for password definition file     */
/*           on YACC                                      */
/*                                                        */
/* Create:   06.08.1996 21:39:20                          */
/* Update:   20.07.1999 20:06:16                          */
/*                                                        */
/* Revision: 2.0c   20.07.1999 20:06:16 check of modifier */
/*           quantity added                               */
/* Revision: 2.0b   04.05.1999 13:47:34 .c(1) not defined */
/*           bug fixed                                    */
/* Revision: 1.1   26.08.1996 14:20:54 Special charset    */
/*           added (implemented in YAAC 0.95).            */
/* Revision: 1.0   06.08.1996 21:39:20 Initial revision   */
/*           (implemented in cRARk 1.5)                   */
/*--------------------------------------------------------*/

%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "maindef.h"
#include "yaccdef.h"
#include "pcl.h"
#include "modif.h"

str_func *f_comp;
int aster_comp;
boolean _used_chars, defined_used_chars;
boolean in_permutation;
int i;
char buf[10];
int national;
%}

%union {
  char          *set;
  int            num;
  str_func      func;

};

%token <num> NUMBER
%token F_EOF
%token WORD USER_WORD S_SPECIAL
%token TBREAK
%token <set> QSTRING
%token <set> LETTER NULL_CHAR
%token <set> ANY_LETTER S_EUPPER S_ELOWER S_DIGITS S_SYMBOLS S_RUPPER S_RLOWER S_USER S_USEDCHARS S_VOWELS
%token <func> W_TRUNC W_UPPER W_LOWER W_COOL W_CONSONANT W_REVERSE W_CONVERT W_DUPLICATE W_USER
%token <func> W_CUT

%type <set>  set sets setl_def
%type <func> modificator word modif1 modificator1 modif1_def
%type <num>  perm_num modif_num
%type <num>  set_def word_def modif_def

%%

/* Whole PDF file */
task: { defined_main_dict = defined_user_dict = defined_used_chars = FALSE; national = 0; }
      definition
      TBREAK
      { line++;
        for (i = 0; i <= 6; i++) {
          strsset (defined_sets[i]); /* for example, spanish */
          strscat (U_QUOT, defined_sets[i]);
        }
        definition_done(); }
      implementation


definition:   { init_set(); }
             lines_def


lines_def:  /*line_def '\n' { line++; } */
          | lines_def line_def '\n' { line++; }

line_def:   word_def '=' QSTRING { if ($1 == WORD) open_dict_file ($3);
                                   else open_user_file ($3); }
          | set_def { i = $1; } '=' set_or_sets_def
           { if (national == 3) {
              national = 0;
              make_upper_lower (U_RLOWER, U_RUPPER, 1);
              make_upper_lower (U_RUPPER, U_RLOWER, 0);
             }
           }
          | modif_def '=' QSTRING
           {
            for (i = 0; i <= 6; i++) strscat (U_QUOT, defined_sets[i]);
            make_convert ($3, $1);
           }
          |

word_def:     WORD        { defined_main_dict = TRUE; $$ = WORD; }
            | USER_WORD   { defined_user_dict = TRUE; $$ = USER_WORD; }

modif_def : '?' modif1_def modif_num { $$ = $3; }

modif1_def:  W_CONVERT

set_or_sets_def:  '['  { memset (defined_sets[i], 0, 256); }
                       sets_def ']'

sets_def:  sets_def setl_def
           { strcat (defined_sets[i], $2);  /* not strscat !!! */
           }  
          |


setl_def:   LETTER    { $$ = $1; }
          | S_EUPPER  { $$ = U_EUPPER; }
          | S_ELOWER  { $$ = U_ELOWER; }
          | S_DIGITS  { $$ = U_DIGITS; }
          | S_SYMBOLS { $$ = U_SPECIAL;}
          | S_RUPPER  { $$ = U_RUPPER; }
          | S_RLOWER  { $$ = U_RLOWER; }
          | S_USER    { $$ = U_USER;   }
          | S_VOWELS  { $$ = U_VOWELS; }
          | '?'       { yyerror ("\'?\' not allowed");   }
          | NULL_CHAR { yyerror ("\'\\0\' not allowed"); }


set_def:      S_EUPPER  { $$ = 1; }
            | S_ELOWER  { $$ = 0; }
            | S_DIGITS  { $$ = 2; }
            | S_SYMBOLS { $$ = 3; }
            | S_RUPPER  { $$ = 5; national |= 1; }
            | S_RLOWER  { $$ = 4; national |= 2; }
            | S_USER    { $$ = 6; }
            | S_USEDCHARS {$$ = 8; defined_used_chars = TRUE;}
            | S_VOWELS  { $$ = 9; }


implementation:
        { i_comp = 0; aster_comp = -1;
         _used_chars = in_permutation = FALSE; }
         lines F_EOF { YYACCEPT; }

lines:   line '\n' { line ++; }
        | line F_EOF
        | lines line '\n' { line ++; }
        | lines line F_EOF

/*   */

line:     { _user_dict = _main_dict = FALSE; }
         wordsets
          { if (aster_comp != -1 && aster_comp != i_comp)
               yyerror ("\'*\' must be at the end");
            process_line ();
            i_comp = 0;
            /*  _main_dict = _user_dict = */ _used_chars = FALSE;
            aster_comp = -1;  }
           |

wordsets :    wordset
            | wordsets wordset

wordset:      word_modif
            | set_or_sets
            | permutation
            | asterisk

word_modif:   word  { if (i_comp == MAX_PASSWORD) yyerror ("Max password length exceeded");
                      if (component[i_comp] == NULL)
                        if ((component[i_comp] = (char *) malloc (256)) == NULL) yyerror ("Out of memory");
                      component[i_comp][0] = C_MODIF;
                      f_comp = (str_func *) &component[i_comp][1];
                      *f_comp++ = $1; }
              modif { f_comp->fnc = NULL; /* make_wordset() uses it */
                      if (_used_chars)
                        strscat (USED_CHARS, make_wordset (component[i_comp]));
                      i_comp++; }

modif:        modif1
            |

modif1:       modificator1        { *f_comp++ = $1; }
            | modif1 modificator1 { if ((char *)f_comp - component[i_comp] > 256 - sizeof (str_func))
                                      yyerror ("Too many modifiers");
                                    else *f_comp++ = $2; }


word:         WORD        { if (!defined_main_dict) yyerror ("Main dictionary not defined");
                            _main_dict = TRUE; $$.fnc = &get_dict_word; }
            | USER_WORD   { if (!defined_user_dict) yyerror ("User dictionary not defined");
                            _user_dict = TRUE; $$.fnc = &get_user_word; }
            | S_SPECIAL NUMBER  { $$.fnc = &get_special; $$.param = $2; }

modificator1: modificator modif_num
              { $$.param = $2;
                if ($2 < 0 && !($1.fnc == &strrtoupper || $1.fnc == &strrtolower ||
                                $1.fnc == &strcut)) yyerror ("Invalid parameter");
                 if ($1.fnc == &strconvert && convert_tables[$2+2] == NULL) {
                   sprintf (buf, ".c(%d)", $2);
                   yymessage ("Error", "not defined", buf);
                 }
              }

modificator:  W_TRUNC     { $$.fnc = &strcut;      }
            | W_UPPER     { $$.fnc = &strrtoupper; }
            | W_LOWER     { $$.fnc = &strrtolower; }
            | W_COOL      { $$.fnc = &strrtocool;  }
            | W_CONSONANT { $$.fnc = &strrshrink;  }
            | W_CONVERT   { $$.fnc = &strconvert;  }
            | W_REVERSE   { $$.fnc = &strrevm;     }
            | W_DUPLICATE { $$.fnc = &strduplicate; }
            | W_USER      { yyerror ("User-defined modifiers not supported yet"); }

modif_num:      NUMBER { $$ = $1;}
            |        { $$ = 0; }

set_or_sets: { if (i_comp == MAX_PASSWORD) yyerror ("Max password length exceeded");
               if (component[i_comp] == NULL)
                 if ((component[i_comp] = (char *) malloc (256)) == NULL) yyerror ("Out of memory");
               component[i_comp][0] = C_SET; }
               set_or_sets1

set_or_sets1:  set { strcpy (component[i_comp++] + 1, $1); }
            | '['  { strcpy (component[i_comp]+1, ""); }
               sets ']' { i_comp++; }

sets:        set  { strscat (component[i_comp]+1, $1); }
          |  sets set  { strscat (component[i_comp]+1, $2); }

set:          S_EUPPER  { $$ = U_EUPPER; if (_used_chars) strscat (USED_CHARS, $$); }
            | S_ELOWER  { $$ = U_ELOWER; if (_used_chars) strscat (USED_CHARS, $$);}
            | S_DIGITS  { $$ = U_DIGITS; if (_used_chars) strscat (USED_CHARS, $$);}
            | S_SYMBOLS { $$ = U_SPECIAL;if (_used_chars) strscat (USED_CHARS, $$); }
            | S_RUPPER  { $$ = U_RUPPER; if (_used_chars) strscat (USED_CHARS, $$);}
            | S_RLOWER  { $$ = U_RLOWER; if (_used_chars) strscat (USED_CHARS, $$);}
            | S_USER    { $$ = U_USER;   if (_used_chars) strscat (USED_CHARS, $$);}
            | '?'       { $$ = U_QUOT;
                          if (_used_chars) strscat (USED_CHARS, $$); }
            | LETTER    { $$ = $1; test_char($$); if (_used_chars) strscat (USED_CHARS, wordtoset ($1)); }
            | NULL_CHAR { component[i_comp][0] |= C_NULL; $$ = ""; }

permutation:  '{'       { if (i_comp != 0) yyerror ("'{' is not a first char");
                          in_permutation = TRUE;
                          if (defined_used_chars == FALSE) {
                            strcpy (USED_CHARS, ""); _used_chars = TRUE; }
                        }
            | '}'       { if (! in_permutation) yyerror ("Unexpected \'}\'");
                          if (i_comp == MAX_PASSWORD) yyerror ("Max password length exceeded");
                         /* if (i_comp == 0) yyerror ("No chars to permute"); */
                          _used_chars = FALSE;
                          in_permutation = FALSE;
                        }

              perm_num {
                         if (component[i_comp] == NULL)
                           if ((component[i_comp] = (char *) malloc (256)) == NULL) yyerror ("Out of memory");
                         component[i_comp][0] = C_PERMUT;
                         component[i_comp][1] = $3;
                         i_comp++;
                        }

perm_num:      NUMBER { $$ = $1;}
            |        { $$ = 1; }


asterisk:    '*'         { if (i_comp == 0 || (! isset (component[i_comp-1])) ) yyerror ("Illegal use of \'*\'");
                           component[i_comp-1][0] |= C_ASTER;
                           aster_comp = i_comp; }


