/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1998                            */
/*                                                        */
/* File:     PCL.C                                        */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0                                          */
/*                                                        */
/* Author:   Eric Young & Pavel Semjanov                  */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Benchmarking and timing routines             */
/*                                                        */
/* Create:   06.08.1998 21:39:20                          */
/* Update:   08.09.1998 18:09:28                          */
/*                                                        */
/* Revision: 2.0   06.08.1998 21:39:20 2.0 release        */
/*--------------------------------------------------------*/

/* crypto/des/speed.c */
/* Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@cryptsoft.com).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@cryptsoft.com).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@cryptsoft.com)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@cryptsoft.com)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

/* 11-Sep-92 Andrew Daviel   Support for Silicon Graphics IRIX added */
/* 06-Apr-92 Luke Brennan    Support for VMS and add extra signal calls */


#ifdef __GNUC__
#include <sys/times.h>
#include <sys/timeb.h>
#else
#include <sys\timeb.h>
#endif

#include "pcl.h"

double Time_F(s, pass)
int s;
UPASS *pass;
	{
	double ret;
static UPASS lpass;

#ifdef TIMES
	static struct tms tstart,tend;

	if (s == START)
		{
                lpass = passwords;
		times(&tstart);
		return(0);
		}
	else
		{
		times(&tend);
		ret=((double)(tend.tms_utime-tstart.tms_utime))/HZ;
                *pass = passwords - lpass;
		return((ret == 0.0)?(0.5/HZ):(ret));
		}
#else /* !times() */
	static struct timeb tstart,tend;
	long i;

	if (s == START)
		{
                lpass = passwords;
		ftime(&tstart);
		return(0);
		}
	else
		{
		ftime(&tend);
		i=(long)tend.millitm-(long)tstart.millitm;
		ret=((double)(tend.time-tstart.time))+((double)i)/1e3;
                *pass = passwords - lpass;
		return((ret == 0.0)?5e-4:ret);
		}
#endif
	}

void benchmark ()
{
double t;
int len;
UPASS lpass;

  psw_chars[0] = '0';
  psw_len = 1;
  len = 1;
  printf ("Brute-force benchmark. Please wait about 10-20 s...\n");
  do {
  Time_F(START, &lpass);
  make_regular (++len, 1, "abcdef");
  t=Time_F(STOP, &lpass);

#ifdef DEBUG

  printf(UPASS_FMT " passwords in %.2f seconds, speed = %.0f, len = %d\n", lpass,  t, lpass/t, len);
#endif

  } while (t < 5);
  printf(UPASS_FMT " %d-chars passwords in %.2f seconds, speed = %.0f p/s\n", lpass,  len,  t, lpass/t);

}

void print_password (mode, right_password)
int mode;
boolean right_password;
{
double t, t1;
static UPASS lpass;
int i;

  t1 = t = Time_F(STOP, &lpass);
  if (mode == GET || right_password) {
   psw_chars[psw_len] = '\0';
   printf ("%s", psw_chars);
  } 
  if (right_password) {
   printf ("\07 - CRC OK\nIn hex (PCL style): ");
   for (i = 0; i < psw_len; i++)
    printf ("\\%02X ", psw_chars[i]);
  }

  printf ("\nPasswords tested = " UPASS_FMT " (time = ", lpass);
  if (t1 > 3600) {
    printf ("%lu:", (unsigned long) (t1 / 3600));
    t1 -= ((unsigned long) (t1 / 3600)) * 3600;
  }
  if (t1 > 60) {
    printf ("%02d:", (int) (t1 / 60));
    t1 -= ((int) (t1 / 60)) * 60;
  }
  printf ("%05.2f, speed = ", t1);
  if (t < 0.1) printf ("*****");
  else printf ("%.0f", lpass/t);

  printf (" p/s)\n");  

  if (mode != GET) printf ("Totally   tested = " UPASS_FMT, passwords);
}
