#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "yaccdef.h"

yyerror(s)
char *s;
{
    yymessage ("Error", s, NULL);
}

yywarning(s, token)
char *s, *token;
{
    yymessage ("Warning", s, token);
}


yymessage(error, s, token)
char *error, *s, *token;
{
    fflush (stdout);
    if (s == NULL) fprintf (stderr, "\nFatal syntax error in line %d\n", line);
    else if (token == NULL) {
      if (line) fprintf(stderr, "%s: %s in line %d\n", error, s, line);
      else fprintf (stderr, "%s: %s", error, s);
    }
    else {
      if (line == 0) fprintf(stderr, "%s: %s \'%s\'\n", error, s, token);
      else fprintf(stderr, "%s: %s \'%s\' in line %d\n", error, s, token, line);
    }
    if (error[0] == 'E') exit (1);
}

