/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     PCL.H                                        */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  1.1a                                         */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Main header file                             */
/*                                                        */
/* Create:   06.08.1996 21:39:20                          */
/* Update:   14.08.1997 00:18:58                          */
/*                                                        */
/* Revision: 1.1a  14.08.1997 00:18:58 Russian charset    */
/*           bug fixed. NO_USER_BRUTE extern added.       */
/* Revision: 1.1   26.08.1996 12:54:56 str_func parameter */
/*           added. DJGPP compatibility added.            */
/* Revision: 1.0   06.08.1996 21:39:20 Initial revision   */
/*           (implemented in cRARk 1.5)                   */
/*--------------------------------------------------------*/

#include "maindef.h"

#define MAX_PASSWORD 32

#define D_EUPPER  "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define D_ELOWER  "abcdefghijklmnopqrstuvwxyz"
#define D_DIGITS  "0123456789"
#define D_RUSPECIAL "{}:\"<>?"
#define D_RLSPECIAL "[];\',./"
#define D_ESPECIAL "~!@#$%^&*()_+`-=\\|"
#define D_SPECIAL  D_ESPECIAL D_RUSPECIAL D_RLSPECIAL
#define D_RUPPER  ""
#define D_RLOWER  ""

/* interface with user's module */

extern char psw_chars[256];         /* password (ending '\0' isn't necessary !!!) */
extern int psw_len;                 /* its length */
extern unsigned long passwords;     /* passwords tested */
extern int NO_USER_BRUTE;           /* set TRUE if standard brute force function used, */
                                    /*    FALSE - your own  */
                                       

void parse_rules_file (char *dict_file, char *user_dict_file, char *rules_file,
                       int _min_psw_len, int _max_psw_len, char *_user_chars);

/* main function. Calls from user's module after command line
processing, all global operation doing etc. Arguments:
  dict_file        - main dictionary filename
  user_dict_file   - user dictionary filename,
  rules_file       - password definition filename,
  min_psw_len, max_psw_len - min & max password lengths
  user_chars        - user defined chars
*/

int test (void);

/* test password function. Must increase "passwords" variable.
   Returns:
     0  - password is correct. In this case
          test() may exit(0) if no more password needed;
     any > 0 - password is not correct;
     -1 - password is not correct and no one (longer)
          password can begin with such chars
*/

void init_brute_force(void);

/* Any global operation before password testing. Called when
   new line of password definition file is processing */

void brute_force (int len, char *charset);

/* User (maybe more efficient) brute force attack instead of
   standard (when '*' encountered in password definition file).
   Called only if NO_USER_BRUTE is NOT defined when compiling.
   Arguments:
       len - current length of psw_chars;
       charset - charset to add to the end of psw_chars;
   Here:
       psw_len - desired length of password.
*/

char *get_special (char *buf, int16 n);

/* Get user defined special charset or words. Called if $s encountered.
   Argumnets:
       buf - already existing char[256] buffer. Get word in this buffer;
       n   - the number of special charset (number after $s).
   Returns:
       buf.
*/

/**********************************************************************/
/* Internal definitions */

/* component types */

#define C_ERROR   0
#define C_NULL    16           /* null char */
#define C_SET     1            /* set of chars */
#define C_MODIF   2            /* word (and modificator) */
#define C_PERMUT  3            /* permutation */
#define C_ASTER   64           /* regular '*' */

#define isset(s) ( (*(s) & 7) == C_SET)
#define isnull(s) ( (*(s) & C_NULL) == C_NULL)
#define ismodif(s) ( (*(s) & 7) == C_MODIF)
#define ispermut(s) ( (*(s) & 7) == C_PERMUT)
#define isregular(s) ( (*(s) & C_ASTER) == C_ASTER)
#define get_perm_number(s) ( (int) s[1])

#define swap(c1, c2)   { register char _cc; _cc = (c1); (c1) = (c2); (c2) = _cc; }


/* type of get word & modifiers function pointer + short int parameter */

struct s_strfunc {
        char * (*fnc) (char *, int16);
        int16  param;
};

typedef struct s_strfunc str_func;


extern char *user_chars;
extern char used_chars[256];
extern char component[MAX_PASSWORD+1][256];
extern int i_comp;
extern boolean _user_dict, _main_dict;

void process_line (void);
void open_dict_file (void);
void open_user_file (void);

void make_password (int, int);
void make_permutations (int, int, int, int, int);
void make_swap (int, int, int, int, int);
void make_delete (int, int, int, int, int);
void make_insert (int, int, int, int, int);
void make_replace (int, int, int, int, int);

void make_regular (int, int, char *);


char *strscat (char *, char *);
char *get_modify_word (char *);
char *mfgets(char *string, int n, FILE *stream);

char *get_dict_word (char *, int16);
char *get_user_word (char *, int16);

char *make_wordset (char *);
char *wordtoset (char *);

char *strrevm  (char *, int16);

char *strcut  (char *, int16);


