#include <windows.h>
#include "res\resource.h"
#include "Debugger.h"

void ShowDisasm(HWND hWnd)
{
    WORD wOpcode;
    char Assembly[50]="",Dasm[128];   
    
    SendMessage(GetDlgItem(hWnd,IDC_DEBUG_INFO),LB_RESETCONTENT,(WPARAM)0,(LPARAM)0);
    
    // Show Disassembly
    for(DWORD iIndex=0;iIndex<FileSize;iIndex+=2)
    {
        wOpcode = Memory[0x200+iIndex];
        wOpcode = (wOpcode<<8)|Memory[0x200+iIndex+1];
        
        Disasm8Chip(wOpcode,Assembly);
        wsprintf(Dasm,"%03X:   %04X    %s",iIndex+0x200,wOpcode,Assembly);
        SendMessage(GetDlgItem(hWnd,IDC_DEBUG_INFO),LB_ADDSTRING,(WPARAM)iIndex,(LPARAM)Dasm);
    }
}

void ShowCPUInformation(HWND hWnd)
{   
    char Dasm[128];
    
    // Current Executing Line
    SendMessage(GetDlgItem(hWnd,IDC_DEBUG_INFO),LB_SETCURSEL,(WPARAM)(CodeIndex-0x200)/2,(LPARAM)NULL);
    
    // Registers
    wsprintf(Dasm,"%04X",Registers[0]);
    SetDlgItemText(hWnd,IDC_V0,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[1]);
    SetDlgItemText(hWnd,IDC_V1,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[2]);
    SetDlgItemText(hWnd,IDC_V2,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[3]);
    SetDlgItemText(hWnd,IDC_V3,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[4]);
    SetDlgItemText(hWnd,IDC_V4,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[5]);
    SetDlgItemText(hWnd,IDC_V5,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[6]);
    SetDlgItemText(hWnd,IDC_V6,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[7]);
    SetDlgItemText(hWnd,IDC_V7,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[8]);
    SetDlgItemText(hWnd,IDC_V8,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[9]);
    SetDlgItemText(hWnd,IDC_V9,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[10]);
    SetDlgItemText(hWnd,IDC_V10,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[11]);
    SetDlgItemText(hWnd,IDC_V11,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[12]);
    SetDlgItemText(hWnd,IDC_V12,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[13]);
    SetDlgItemText(hWnd,IDC_V13,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[14]);
    SetDlgItemText(hWnd,IDC_V14,Dasm);
    
    wsprintf(Dasm,"%04X",Registers[15]);
    SetDlgItemText(hWnd,IDC_V15,Dasm);
    
    wsprintf(Dasm,"%04X",CodeIndex);
    SetDlgItemText(hWnd,IDC_PC,Dasm);
    
    wsprintf(Dasm,"%04X",SP);
    SetDlgItemText(hWnd,IDC_SP,Dasm);
    
    wsprintf(Dasm,"%04X",RegI);
    SetDlgItemText(hWnd,IDC_I,Dasm);
    
    wsprintf(Dasm,"%04X",SoundTimer);
    SetDlgItemText(hWnd,IDC_TIMER,Dasm);
    
    wsprintf(Dasm,"%04X",DelayTimer);
    SetDlgItemText(hWnd,IDC_DELAY,Dasm);
}

BOOL CALLBACK DebugDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
        {
           if(FileSize!=NULL) 
           {
               ShowDisasm(hWnd);
               ShowCPUInformation(hWnd);
           }
        }
        break;
        
        case WM_PAINT:
        {
            return false; //no paint
        }
        break;
        
        case WM_COMMAND:
        {
            switch(wParam) 
            {
              case IDC_OK:
              {
                SendMessage(hWnd,WM_CLOSE,0,0);
              }
              break;

              case IDC_STEP_CPU:
              {
                  if(FileSize!=NULL) 
                  {                  
                      CPU_STEP();
                      ShowCPUInformation(hWnd);
                  }
              }
              break;

            }
        }
        break;

        case WM_CLOSE:
        {
            EndDialog(hWnd,0); // kill dialog
        }
        break;
    }
    return 0;
}