  
#ifndef _CHIP8_DEBUGGER_
#define _CHIP8_DEBUGGER_

#include "res\resource.h"

#define MEMORY_SIZE 0xFFF
#define SCREEN_SIZE 2049
#define MAX_REGS 16
#define MAX_STACK MAX_REGS

typedef unsigned char CHAR8;

extern void    CPU_STEP();
extern CHAR8   Memory[MEMORY_SIZE];   // 0xFFF
extern CHAR8   Screen[SCREEN_SIZE];   // 64x32
extern CHAR8   Registers[MAX_REGS];   // V0,V1..VF
extern DWORD   Stack[MAX_STACK];      // Stack, holds return addresses
extern CHAR8   DelayTimer,SoundTimer; // Timers
extern DWORD   CodeIndex,SP,RegI;     // PC,SP,I


extern DWORD FileSize;
extern void  Disasm8Chip(WORD wOpcode,char *Assembly);

void ShowDisasm(HWND hWnd);
void ShowCPUInformation(HWND hWnd);
BOOL CALLBACK DebugDlgProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);

#endif