#ifndef _DLL_H_
#define _DLL_H_

//////////////////////////////////////////////////////////////////////////
//                         INCLUDES                                     //
//////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <COMMCTRL.H>
#include "Res/resource.h"

// Export Type
#define DLL_EXPORT __declspec(dllexport)


// This is the Plugin Description which will be 
// Shown inside PVDasm
#define PLUGIN_NAME "GBoy Reader" // No More than 128 characters!!

//////////////////////////////////////////////////////////////////////////
//                          MESSAGES                                    //
//////////////////////////////////////////////////////////////////////////

// PLUGIN MESSAGES
#define PI_BASE_MSG 200
#define PI_GETASM WM_USER+PI_BASE_MSG


// PVDasm Control IDs
#define ID_DISASM        1072
#define ID_DEBUG_WINDOW  1060

//////////////////////////////////////////////////////////////////////////
//                          STRUCTS                                     //
//////////////////////////////////////////////////////////////////////////

typedef struct tagPluginInfo{

    HWND* Parent_hWnd;
    BYTE* FilePtr;
    DWORD FileSize;
    bool  DisasmReady;
    bool  LoadedPe;

}PLUGINFO; // Plugin Struct

typedef struct Code_Flow{

    bool Jump;   // Instruction is a Jxx
    bool Call;   // Instruction is a Call

} CODE_FLOW;

typedef struct Decoded{
	
	// Define Decoded instruction struct

    DWORD     Address;       // Current address of decoded instruction
    CODE_FLOW CodeFlow;      // InstructionS: Jump or Call 
    BYTE      OpcodeSize;    // Opcode Size
	BYTE      PrefixSize;    // Size of all prefixes used
    char      Assembly[128]; // Menemonics
    char      Remarks[256];  // Menemonic addons
    char      Opcode[25];    // Opcode Byte forms

} DISASSEMBLY;

//////////////////////////////////////////////////////////////////////////
//                        FUNCTION EXPORTS                              //
//////////////////////////////////////////////////////////////////////////

extern "C" { 
    
    DLL_EXPORT void  InstallDll(PLUGINFO);  
    DLL_EXPORT char* PluginInfo();
};

//////////////////////////////////////////////////////////////////////////
//                           PROTOTYPES                                 //
//////////////////////////////////////////////////////////////////////////

BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
bool CheckGameBoySignature(char *FilePtr);
void Read_Game_Boy_Header(HWND hWnd,HWND hList,char *GB_Pointer);
void OutDebug(HWND hWnd,char* debug,HWND hList);

#endif