#include "Main.h"

HINSTANCE hDllInstance;
BYTE* hFileMappedPtr;
HWND  Main_hWnd;

int WINAPI DllMain(HINSTANCE hInstance,DWORD  reason, LPVOID Reserved)
{
	// Store the instance we get
	hDllInstance = hInstance;

	// Return true, we are ready for hook on the system
	return TRUE;
}

void InstallDll(BYTE *hFileMap,HWND *GuihWnd)
{
    hFileMappedPtr = hFileMap;
    Main_hWnd = *GuihWnd;
    DialogBoxParam(hDllInstance, MAKEINTRESOURCE(IDD_MAIN_PLUGIN), NULL, (DLGPROC)DlgProc,0);
}

char* PluginInfo()
{
    return PLUGIN_NAME;
}

BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) // what are we doing ?
	{ 	 
		case WM_INITDIALOG: 
		{
            char text[128];
            InitCommonControls();
            ShowWindow(hWnd,SW_NORMAL);
            
            wsprintf(text,"Parent HWND:%08X\n\nPlugin HWND: %08X\n\nParent Sent char Array (0x%08X) -> '%c','%c'",Main_hWnd,hWnd,hFileMappedPtr,*hFileMappedPtr,*(hFileMappedPtr+1));
            MessageBox(hWnd,text,PLUGIN_NAME,MB_OK);           
		}
		break;

		case WM_LBUTTONDOWN: 
		{
			ReleaseCapture(); 
			SendMessage(hWnd,WM_NCLBUTTONDOWN,HTCAPTION,0); 
		}
		break;

		case WM_PAINT: // constantly painting the window
		{
			return 0;
		}
		break;
		
        
		case WM_COMMAND:
		{
		   switch(LOWORD(wParam)) // what we press on?
			{
				case IDC_EXIT:
				{
                   SendMessage(hWnd,WM_CLOSE,0,0);
				}
				break;

                case IDC_SENDMSG:
                {
                    char MsgText[50];
                    //Sending Messages To Main Gui
                    SendMessage(Main_hWnd,PI_GETASM,(WPARAM)1337,(LPARAM)&MsgText);
                    MessageBox(hWnd,MsgText,"Message from Parent Works!!",MB_OK); // Return From Gui 
                }
                break;
			}
		}
		break;
        

        case WM_CLOSE: // We colsing the Dialog
        {
          EndDialog(hWnd,0); 
        }
	    break;
	}
	return 0;
}