// Keygen for Haldir's Applied Mathematics CrackMe
// by nucleon / 02.01.2004
//            / 10.02.2004 (slightly optimized)

#include <NTL/ZZ.h>
#include <NTL/lzz_p.h>
#include <NTL/mat_lzz_p.h>

NTL_CLIENT

int main(int argc, char *argv[])
{
   char M3c[11][11] = {
    {0x00, 0x06, 0x03, 0x00, 0x09, 0x0D, 0x05, 0x0A, 0x04, 0x05, 0x05},
    {0x0B, 0x08, 0x0D, 0x06, 0x0C, 0x10, 0x02, 0x07, 0x00, 0x00, 0x0F},
    {0x09, 0x05, 0x03, 0x09, 0x10, 0x01, 0x0E, 0x0D, 0x01, 0x01, 0x08},
    {0x00, 0x04, 0x07, 0x00, 0x0B, 0x07, 0x04, 0x0F, 0x02, 0x03, 0x0F},
    {0x0D, 0x0D, 0x00, 0x07, 0x0D, 0x09, 0x06, 0x0F, 0x0F, 0x00, 0x0D},
    {0x0D, 0x08, 0x01, 0x0F, 0x09, 0x0F, 0x04, 0x02, 0x08, 0x02, 0x08},
    {0x04, 0x0C, 0x0E, 0x04, 0x0E, 0x02, 0x03, 0x03, 0x0E, 0x0C, 0x06},
    {0x0E, 0x06, 0x00, 0x03, 0x0C, 0x10, 0x0D, 0x07, 0x0B, 0x02, 0x02},
    {0x08, 0x00, 0x0A, 0x02, 0x02, 0x0E, 0x0D, 0x08, 0x09, 0x0F, 0x0B},
    {0x08, 0x00, 0x0F, 0x06, 0x06, 0x0E, 0x0E, 0x0D, 0x0C, 0x07, 0x07},
    {0x04, 0x04, 0x06, 0x05, 0x0B, 0x0A, 0x10, 0x08, 0x0F, 0x09, 0x03}};

   char M2c[15][15] = {
    {0x05, 0x02, 0x11, 0x09, 0x16, 0x07, 0x16, 0x13, 0x0A, 0x0D, 0x08, 0x0F, 0x09, 0x10, 0x0F},
    {0x04, 0x09, 0x0E, 0x0A, 0x02, 0x03, 0x0E, 0x16, 0x12, 0x07, 0x03, 0x07, 0x06, 0x02, 0x12},
    {0x14, 0x04, 0x12, 0x11, 0x11, 0x02, 0x0A, 0x0B, 0x09, 0x0B, 0x13, 0x07, 0x14, 0x07, 0x15},
    {0x0E, 0x0F, 0x01, 0x05, 0x05, 0x0E, 0x09, 0x09, 0x01, 0x0B, 0x03, 0x00, 0x0B, 0x14, 0x01},
    {0x13, 0x12, 0x0D, 0x01, 0x08, 0x0A, 0x0F, 0x08, 0x0F, 0x01, 0x08, 0x0A, 0x0F, 0x10, 0x02},
    {0x03, 0x0D, 0x0A, 0x0C, 0x02, 0x11, 0x04, 0x0C, 0x02, 0x16, 0x04, 0x00, 0x0B, 0x12, 0x14},
    {0x0B, 0x0E, 0x11, 0x0D, 0x00, 0x0E, 0x09, 0x07, 0x16, 0x0E, 0x14, 0x14, 0x15, 0x15, 0x05},
    {0x0B, 0x06, 0x0F, 0x08, 0x04, 0x07, 0x16, 0x0D, 0x16, 0x0B, 0x13, 0x03, 0x04, 0x0D, 0x0F},
    {0x10, 0x10, 0x0C, 0x03, 0x10, 0x13, 0x14, 0x04, 0x0D, 0x05, 0x11, 0x07, 0x06, 0x09, 0x0C},
    {0x01, 0x14, 0x15, 0x0A, 0x03, 0x10, 0x13, 0x01, 0x01, 0x0A, 0x0D, 0x0B, 0x0A, 0x0C, 0x0D},
    {0x0A, 0x01, 0x07, 0x0E, 0x06, 0x14, 0x12, 0x05, 0x14, 0x03, 0x10, 0x14, 0x04, 0x13, 0x15},
    {0x16, 0x11, 0x04, 0x0E, 0x04, 0x04, 0x12, 0x00, 0x0D, 0x0C, 0x10, 0x05, 0x00, 0x05, 0x03},
    {0x0B, 0x02, 0x08, 0x12, 0x07, 0x05, 0x04, 0x14, 0x15, 0x09, 0x03, 0x12, 0x13, 0x08, 0x04},
    {0x00, 0x0E, 0x06, 0x10, 0x07, 0x0E, 0x01, 0x15, 0x07, 0x0B, 0x16, 0x10, 0x11, 0x0A, 0x12},
    {0x10, 0x07, 0x0D, 0x11, 0x05, 0x01, 0x15, 0x00, 0x03, 0x10, 0x05, 0x14, 0x01, 0x07, 0x03}};

   char M1c[16][16] = {
    {0x0F, 0x06, 0x14, 0x0D, 0x12, 0x08, 0x0F, 0x05, 0x0F, 0x03, 0x14, 0x05, 0x09, 0x0E, 0x04, 0x07},
    {0x00, 0x02, 0x01, 0x05, 0x0E, 0x11, 0x0E, 0x13, 0x07, 0x11, 0x0C, 0x08, 0x0A, 0x10, 0x0B, 0x0D},
    {0x07, 0x08, 0x0B, 0x06, 0x0C, 0x07, 0x10, 0x05, 0x06, 0x09, 0x08, 0x02, 0x15, 0x0A, 0x04, 0x0D},
    {0x09, 0x00, 0x08, 0x0B, 0x00, 0x00, 0x01, 0x06, 0x11, 0x0E, 0x05, 0x09, 0x0E, 0x15, 0x02, 0x0D},
    {0x0A, 0x05, 0x10, 0x05, 0x03, 0x02, 0x04, 0x0A, 0x09, 0x04, 0x15, 0x15, 0x16, 0x12, 0x0C, 0x15},
    {0x03, 0x0B, 0x11, 0x11, 0x10, 0x08, 0x01, 0x12, 0x06, 0x07, 0x07, 0x0D, 0x0B, 0x07, 0x0E, 0x12},
    {0x16, 0x13, 0x16, 0x10, 0x15, 0x0C, 0x10, 0x13, 0x01, 0x11, 0x09, 0x02, 0x16, 0x02, 0x0D, 0x00},
    {0x07, 0x00, 0x03, 0x10, 0x14, 0x11, 0x03, 0x03, 0x00, 0x12, 0x08, 0x13, 0x05, 0x05, 0x0C, 0x0C},
    {0x08, 0x15, 0x13, 0x05, 0x16, 0x09, 0x07, 0x0A, 0x0D, 0x03, 0x0B, 0x16, 0x15, 0x16, 0x03, 0x06},
    {0x0C, 0x0E, 0x14, 0x04, 0x14, 0x0E, 0x00, 0x0B, 0x02, 0x0B, 0x02, 0x10, 0x08, 0x12, 0x00, 0x0C},
    {0x16, 0x06, 0x0F, 0x0F, 0x05, 0x0F, 0x0C, 0x11, 0x10, 0x10, 0x13, 0x0E, 0x11, 0x0F, 0x01, 0x15},
    {0x05, 0x0D, 0x14, 0x12, 0x06, 0x0A, 0x0D, 0x11, 0x10, 0x02, 0x12, 0x09, 0x07, 0x04, 0x11, 0x00},
    {0x07, 0x0D, 0x02, 0x0B, 0x03, 0x11, 0x0A, 0x16, 0x03, 0x11, 0x05, 0x06, 0x16, 0x15, 0x0F, 0x08},
    {0x16, 0x14, 0x10, 0x09, 0x0B, 0x0B, 0x15, 0x09, 0x05, 0x0F, 0x04, 0x0C, 0x02, 0x00, 0x0E, 0x05},
    {0x0A, 0x02, 0x14, 0x11, 0x03, 0x0A, 0x0F, 0x13, 0x09, 0x05, 0x05, 0x12, 0x0F, 0x16, 0x14, 0x0D},
    {0x0D, 0x0E, 0x0A, 0x05, 0x10, 0x04, 0x0F, 0x0B, 0x0E, 0x0C, 0x08, 0x04, 0x12, 0x08, 0x05, 0x13}};

   zz_p d;
   vec_zz_p r1,r2,r3,x;
   mat_zz_p M1,M2,M3;
   int i,j;
   bool parameter_correct = true;

cout << "Keygen for Haldir's Applied Mathematics CrackMe\n";
cout << "by nucleon / 02.01.2004\n\n";

if (argc==2)                // correct parameter ?
  if (strlen(argv[1])==11)
  {
   for (i=0; i<11; i++)
      if (((unsigned char)argv[1][i] < 0x30) || ((unsigned char)argv[1][i] > 0x39))  // no digit ?
	  {  parameter_correct = false; break; }
  }  else parameter_correct = false;
else parameter_correct = false;

if (parameter_correct)
{ 
   zz_p::init(17);           //compute modulo 17 from now on

   M3.SetDims(11,11);     // initialize M3
   for(i=0; i<11; i++)
     for(j=0; j<11; j++)
       M3[i][j] = M3c[i][j];

   r3.SetLength(11);
   for(i=0; i<11; i++) r3[i] = argv[1][i]-0x30;   // initialize parameters

   solve(d, x, transpose(M3), r3);    // x receives solution vector of M3*x=r3
   cout << "solved linear equation system #3\n" << "x3 = " << x << endl << endl;

// calculate hash value
   unsigned int h = 0x0B;
   unsigned int tmp;
   for(i=0; i<11; i++)
   {
     h = h^((unsigned int)(argv[1][i]-0x30)<<8);
     tmp = h;
     for(j=0; j<8; j++)
        if ((tmp&0x8000)==0)
          tmp = (tmp*2)&0xFFFF;
        else
          tmp = ((tmp*2)^0x1021)&0xFFFF;
     h = tmp;
   }

   for(i=0; i<11; i++)
   {
      h = h^(to_long((rep(x[i])<<8)));
      tmp = h;
      for(j=0; j<8; j++)
        if ((tmp&0x8000)==0)
          tmp = (tmp*2)&0xFFFF;
        else
          tmp = ((tmp*2)^0x1021)&0xFFFF;
     h = tmp;
   }
// hash calculation done

   zz_p::init(23);          // compute modulo 23 from now on

   M2.SetDims(15,15);       // initialize M2
   for(i=0; i<15; i++)
     for(j=0; j<15; j++)
       M2[i][j] = M2c[i][j];

   M1.SetDims(16,16);       // initialize M1
   for(i=0; i<16; i++)
     for(j=0; j<16; j++)
       M1[i][j] = M1c[i][j];

   r2.SetLength(15);
   for(i=0; i<11; i++) r2[i] = x[i];
   r2[11] = (h>>12)&0xF;   // further conditions,
   r2[12] = (h>>8)&0xF;    // extending the 11x15 matrix
   r2[13] = (h>>4)&0xF;    // to a 15x15 matrix
   r2[14] = h&0xF;         //

   solve(d, x, transpose(M2), r2);    // x receives solution vector of M2*x=r2
   cout << "solved linear equation system #2\n" << "x2 = " << x << endl << endl;

   r1.SetLength(16);
   for(i=0; i<15; i++) r1[i] = x[i];
   r1[15] = 0x14;

   solve(d, x, transpose(M1), r1);    // x receives solution vector of M1*x=r1
   cout << "solved linear equation system #1\n" << "x1 = " << x << endl << endl;

// print serial
   cout << "Serial: " << argv[1];
   for(i=0; i<4; i++)
   {
     cout << "-";
     for(j=i*4; j<i*4+4; j++)
       cout << char(to_int(rep(x[j]))+0x41);
   }
   return 0;
}
else
{
   cout << "Usage: keygen <11-digit-decimal-number>\n";
   return 1;
}
}
