.386
.model flat, stdcall
option casemap:none 

include /masm32/include/windows.inc
include /masm32/include/kernel32.inc
include /masm32/include/user32.inc

includelib /masm32/lib/kernel32.lib
includelib /masm32/lib/user32.lib

generateKey PROTO :DWORD
getUserName PROTO

.data
 
szProbMessage                   db "Problem generating serial number, quitting now.",0
szProbCaption                   db "ERROR!  >:(",0
szGoodSerialCaption             db "Generated Serial Number",0
formatString                    db "%u",0

.data?

lpUserName                      dd ?

;************************************************************************************************

.code

start:

invoke getUserName
invoke generateKey, addr lpUserName
invoke ExitProcess, NULL

;************************************************************************************************
;the getUserName procedure is simply used to retrieve the user name passed to the keygen by
;the user as a command line argument...

getUserName PROC

invoke GetCommandLineA
mov dl, 20h
@skip1:					
inc eax
cmp [eax], dl
jne @skip1
@skip2:
inc eax
push eax
pop dword ptr [lpUserName]
ret

getUserName ENDP

;************************************************************************************************
;generateKey is of course the crucial component of the keygen...
;the majority of the code is ripped directly from the crackme itself (with a few very minor
;modifications)

generateKey PROC user_name:DWORD

local buffer[128]: byte
local hex_buff[4]: byte

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;the following is the crucial section of code where the user name is "hashed" into something
;like a checksum that will be compared to a checksum created using the serial number...

MOV ESI,DWORD PTR SS:[lpUserName]           ;  move pointer to user name into esi
PUSH EDI                                    ;  save register on stack
PUSH ESI                                    ;  save register on stack
CALL lstrlenA                               ;  find the length of the user name       
MOV EDI,EAX                                 ;  move the length of the user name into edi
XOR EDX,EDX                                 ;  zero edx (will be used as our loop counter)
TEST EDI,EDI                                ;  make sure that the username is not of 0 length
JLE @quit                                   ;  if so then quit...
AND DWORD PTR [EBP-4],0                     ;  var1 = 0
@loop_start:
MOVSX ECX,BYTE PTR DS:[EDX+ESI]             ;  var2 = hex value of letter from user name
ADD DWORD PTR [EBP-4],ECX                   ;  var1 = var1 + var2
MOV DWORD PTR [EBP-8],ECX                   ;  var3 = var2
ROL DWORD PTR [EBP-4],1                     ;  var1 = var1 ROL 1
MOV EAX,ECX                                 ;  var4 = var2
IMUL EAX,DWORD PTR SS:[EBP-4]               ;  var4 = var4 IMUL var1
MOV DWORD PTR [EBP-4],EAX                   ;  var1 = var4
MOV EAX,DWORD PTR [EBP-8]                   ;  var4 = var3
ADD DWORD PTR [EBP-4],EAX                   ;  var1 = var1 + var4
XOR DWORD PTR [EBP-4],ECX                   ;  var1 = var1 XOR var2
INC EDX                                     ;  increment the loop counter
CMP EDX,EDI                                 ;  compare the value of the loop counter to the lenght of the user name
JL @loop_start                              ;  loop until the end of the user name
CMP DWORD PTR SS:[EBP-4],0                  ;  check that var1 does not have value of zero
JZ @quit                                    ;  jump is almost always taken unless a zero checksum is generated
XOR EAX,EAX

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

;ok so at this point ebp-4 (var1) contains our "checksum" created from the user name.
;we must now perform the following mathematical manipulation in order to arrive at the correct serial:
;correct serial = (((NOT var1) + BADCODE5h) XOR 1337CODE), then transform this hex number to decimal...

mov eax, dword ptr [ebp - 4]
not eax
add eax, 0BADC0DE5h
xor eax, 1337C0DEh

;eax now contains the hexadecimal representation of the correct serial number so let's use:
;int wsprintf(LPTSTR lpOut,LPCTSTR lpFmt,...) api function to format this as a decimal and then pop up a MessageBox
;with the user name as the caption and the correct serial as the message box text...

invoke wsprintf, addr buffer, addr formatString, eax
invoke MessageBoxA, NULL, addr buffer, lpUserName, MB_OK

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

POP EDI                                     ;  restore registers
POP ESI                                     ;  restore registers
RET                                         ;  bye bye :)

@quit:
invoke MessageBoxA, NULL, addr szProbMessage, addr szGoodSerialCaption, MB_OK
ret  

generateKey ENDP

;************************************************************************************************

end start

