////////////////////////////////////
//
// import analyzer for armadillo
// written by AndreaGeddon
//
////////////////////////////////////
#include <windows.h>
#include "data.h"

#define FILE_TARGET		"Armadillo.exe"
#define OFF_START		0x00001000
#define OFF_END			0x00048000
#define EXE_IMAGE_BASE	0x00400000

#define BRIDGE			"bridge.dmp"
#define BRIDGE_BASE		0x00F20000
#define IAT_START		0x00FC3048
#define IAT_END			0x00FC35B4		//first non thunk address

#define CALLS			50				//number of calls in call list

#define RESULT_FILE		"armadillofix.exe"

int WINAPI WinMain(HINSTANCE Instance, HINSTANCE PreInst, LPSTR CmdLine, int CmdShow)
{
	HANDLE TargetFile, BridgeFile, ResultFile;
	DWORD Dword, FileSize, BridgeSize, Address, *Pointer, Thunk, *Bpointer;
	BYTE *TargetBuffer, *BridgeBuffer;
	int i, j;
	HINSTANCE Libraries[3];

	DWORD *IatApi;
	BOOL AddCall;

	//
	// initialize library handles for emulated apis
	//
	Libraries[M_KERNEL32] = LoadLibrary("kernel32.dll");
	Libraries[M_USER32] = LoadLibrary("user32.dll");
	Libraries[M_ADVAPI32] = LoadLibrary("advapi32.dll");

	//
	// open dumped exe file and read it
	//
	TargetFile = CreateFile(FILE_TARGET, GENERIC_READ, FILE_SHARE_READ, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	FileSize = GetFileSize(TargetFile, &Dword);
	TargetBuffer = (BYTE*)malloc(FileSize);
	ReadFile(TargetFile, TargetBuffer, FileSize, &Dword, NULL);

	//
	// open bridge file and read it
	//
	BridgeFile = CreateFile(BRIDGE, GENERIC_READ, FILE_SHARE_READ, NULL,
				OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	BridgeSize = GetFileSize(BridgeFile, &Dword);
	BridgeBuffer = (BYTE*)malloc(BridgeSize);
	ReadFile(BridgeFile, BridgeBuffer, BridgeSize, &Dword, NULL);

	//
	// scan code section to find imports in memory bridge
	//
	for(i = OFF_START; i < (OFF_END - 4); i++)
	{
		Pointer = (DWORD*)&(TargetBuffer[i]);
		Address = *Pointer;
		if((Address >= IAT_START) && (Address < IAT_END) && (Address % 4 == 0))
		{
			//
			// address is in iat and is correctly 4-aligned
			// read thunk from memory bridge
			//
			Address -= BRIDGE_BASE;
			Bpointer = (DWORD*)&(BridgeBuffer[Address]);
			Thunk = *Bpointer;		//we get the import address
			if((Thunk > 0x00E85000) && (Thunk < 0x00EB0000))
			{
				//
				// api is emulated, obtain its pointer
				//
				for(j = 0; j < NUMBER_OF_THUNKS; j++)
				{
					if(Thunk == ThunkData[j].DllThunk)
					{
						Thunk = (DWORD)GetProcAddress(Libraries[ThunkData[j].Module], ThunkData[j].ApiName);
						break;
					}
				}
			}

			//
			// write the thunk in the iat
			//
			for(j = 0; j < NUMBER_OF_THUNKS; j++)
			{
				//
				// determine in which api the address is
				//
				if((Thunk > IatMap[j].ImageBase) && (Thunk < (IatMap[j].ImageBase + IatMap[j].ImageSize)))
				{
					// once located, add the address to the iat entry
					IatApi = (DWORD*)(TargetBuffer + IatMap[j].IatEntry);
					AddCall = TRUE;
					while(*IatApi != 0)
					{
						if(*IatApi == Thunk)
						{
							// api is already present in iat, do nothing
							AddCall = FALSE;
							break;
						}
						IatApi++;
					}
					if(AddCall)
					{
						// api was not found in the iat, add it in the iat array
						*IatApi = Thunk;
					}
					// fix the code to call this iat entry instead that bridge
					*Pointer = (DWORD)((BYTE*)IatApi - TargetBuffer + EXE_IMAGE_BASE);	//VIRTUAL ADDRESS, not RVA
					break;
				}
			}
		}
	}

	//
	// write fixed exe
	//
	ResultFile = CreateFile(RESULT_FILE, GENERIC_READ + GENERIC_WRITE, FILE_SHARE_READ,
				NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	WriteFile(ResultFile, TargetBuffer, FileSize, &Dword, NULL);

	//
	// close handles, free memory and exit
	//
	free(BridgeBuffer);
	free(TargetBuffer);
	CloseHandle(TargetFile);
	CloseHandle(BridgeFile);
	CloseHandle(ResultFile);
	return NULL;
}