//////////////////////////////////////////////////
//
// armadillo 4.20 nanomites core emulator
// written by andreageddon
//
// data used by core.cpp functions
//////////////////////////////////////////////////
#include <windows.h>
#include "core.h"

////////////////////////////////////////////
// block 1
////////////////////////////////////////////
DWORD B1V1 = 0xB8EA996B;
DWORD B1V2 = 0xA27B7849;
DWORD B1V3 = 0xDDC1D886;
DWORD B1V4 = 0xB9E1AC81;
DWORD B1V5 = 0xBA510D2C;
DWORD B1V6 = 0xF61E987;
DWORD B1V7 = 0x6A073847;
DWORD B1V8 = 0x6A23D5FB;
DWORD B1V9 = 0x79D514E2;
DWORD B1V10 = 0x3A612A59;
DWORD B1V11 = 0xB81D9989;
DWORD B1V12 = 0x338F1DEE;
DWORD B1V13 = 0x5217B725;
DWORD B1V14 = 0xD70E4E5A;
DWORD B1V15 = 0xBD3CAC82;
DWORD B1V16 = 0xA8396520;
DWORD B1V17 = 0xE4505EBF;
DWORD B1V18 = 0x6F1A9142;
DWORD B1V19 = 0x2BA925AD;

////////////////////////////////////////////
// block 2
////////////////////////////////////////////

BYTE Block2Func2Data1[] = {
/*0000:*/ 0x00, 0x00, 0x00, 0x00, 0x96, 0x30, 0x07, 0x77, 0x2C, 0x61, 0x0E, 0xEE, 0xBA, 0x51, 0x09, 0x99, 
/*0010:*/ 0x19, 0xC4, 0x6D, 0x07, 0x8F, 0xF4, 0x6A, 0x70, 0x35, 0xA5, 0x63, 0xE9, 0xA3, 0x95, 0x64, 0x9E, 
/*0020:*/ 0x32, 0x88, 0xDB, 0x0E, 0xA4, 0xB8, 0xDC, 0x79, 0x1E, 0xE9, 0xD5, 0xE0, 0x88, 0xD9, 0xD2, 0x97, 
/*0030:*/ 0x2B, 0x4C, 0xB6, 0x09, 0xBD, 0x7C, 0xB1, 0x7E, 0x07, 0x2D, 0xB8, 0xE7, 0x91, 0x1D, 0xBF, 0x90, 
/*0040:*/ 0x64, 0x10, 0xB7, 0x1D, 0xF2, 0x20, 0xB0, 0x6A, 0x48, 0x71, 0xB9, 0xF3, 0xDE, 0x41, 0xBE, 0x84, 
/*0050:*/ 0x7D, 0xD4, 0xDA, 0x1A, 0xEB, 0xE4, 0xDD, 0x6D, 0x51, 0xB5, 0xD4, 0xF4, 0xC7, 0x85, 0xD3, 0x83, 
/*0060:*/ 0x56, 0x98, 0x6C, 0x13, 0xC0, 0xA8, 0x6B, 0x64, 0x7A, 0xF9, 0x62, 0xFD, 0xEC, 0xC9, 0x65, 0x8A, 
/*0070:*/ 0x4F, 0x5C, 0x01, 0x14, 0xD9, 0x6C, 0x06, 0x63, 0x63, 0x3D, 0x0F, 0xFA, 0xF5, 0x0D, 0x08, 0x8D, 
/*0080:*/ 0xC8, 0x20, 0x6E, 0x3B, 0x5E, 0x10, 0x69, 0x4C, 0xE4, 0x41, 0x60, 0xD5, 0x72, 0x71, 0x67, 0xA2, 
/*0090:*/ 0xD1, 0xE4, 0x03, 0x3C, 0x47, 0xD4, 0x04, 0x4B, 0xFD, 0x85, 0x0D, 0xD2, 0x6B, 0xB5, 0x0A, 0xA5, 
/*00A0:*/ 0xFA, 0xA8, 0xB5, 0x35, 0x6C, 0x98, 0xB2, 0x42, 0xD6, 0xC9, 0xBB, 0xDB, 0x40, 0xF9, 0xBC, 0xAC, 
/*00B0:*/ 0xE3, 0x6C, 0xD8, 0x32, 0x75, 0x5C, 0xDF, 0x45, 0xCF, 0x0D, 0xD6, 0xDC, 0x59, 0x3D, 0xD1, 0xAB, 
/*00C0:*/ 0xAC, 0x30, 0xD9, 0x26, 0x3A, 0x00, 0xDE, 0x51, 0x80, 0x51, 0xD7, 0xC8, 0x16, 0x61, 0xD0, 0xBF, 
/*00D0:*/ 0xB5, 0xF4, 0xB4, 0x21, 0x23, 0xC4, 0xB3, 0x56, 0x99, 0x95, 0xBA, 0xCF, 0x0F, 0xA5, 0xBD, 0xB8, 
/*00E0:*/ 0x9E, 0xB8, 0x02, 0x28, 0x08, 0x88, 0x05, 0x5F, 0xB2, 0xD9, 0x0C, 0xC6, 0x24, 0xE9, 0x0B, 0xB1, 
/*00F0:*/ 0x87, 0x7C, 0x6F, 0x2F, 0x11, 0x4C, 0x68, 0x58, 0xAB, 0x1D, 0x61, 0xC1, 0x3D, 0x2D, 0x66, 0xB6, 
/*0100:*/ 0x90, 0x41, 0xDC, 0x76, 0x06, 0x71, 0xDB, 0x01, 0xBC, 0x20, 0xD2, 0x98, 0x2A, 0x10, 0xD5, 0xEF, 
/*0110:*/ 0x89, 0x85, 0xB1, 0x71, 0x1F, 0xB5, 0xB6, 0x06, 0xA5, 0xE4, 0xBF, 0x9F, 0x33, 0xD4, 0xB8, 0xE8, 
/*0120:*/ 0xA2, 0xC9, 0x07, 0x78, 0x34, 0xF9, 0x00, 0x0F, 0x8E, 0xA8, 0x09, 0x96, 0x18, 0x98, 0x0E, 0xE1, 
/*0130:*/ 0xBB, 0x0D, 0x6A, 0x7F, 0x2D, 0x3D, 0x6D, 0x08, 0x97, 0x6C, 0x64, 0x91, 0x01, 0x5C, 0x63, 0xE6, 
/*0140:*/ 0xF4, 0x51, 0x6B, 0x6B, 0x62, 0x61, 0x6C, 0x1C, 0xD8, 0x30, 0x65, 0x85, 0x4E, 0x00, 0x62, 0xF2, 
/*0150:*/ 0xED, 0x95, 0x06, 0x6C, 0x7B, 0xA5, 0x01, 0x1B, 0xC1, 0xF4, 0x08, 0x82, 0x57, 0xC4, 0x0F, 0xF5, 
/*0160:*/ 0xC6, 0xD9, 0xB0, 0x65, 0x50, 0xE9, 0xB7, 0x12, 0xEA, 0xB8, 0xBE, 0x8B, 0x7C, 0x88, 0xB9, 0xFC, 
/*0170:*/ 0xDF, 0x1D, 0xDD, 0x62, 0x49, 0x2D, 0xDA, 0x15, 0xF3, 0x7C, 0xD3, 0x8C, 0x65, 0x4C, 0xD4, 0xFB, 
/*0180:*/ 0x58, 0x61, 0xB2, 0x4D, 0xCE, 0x51, 0xB5, 0x3A, 0x74, 0x00, 0xBC, 0xA3, 0xE2, 0x30, 0xBB, 0xD4, 
/*0190:*/ 0x41, 0xA5, 0xDF, 0x4A, 0xD7, 0x95, 0xD8, 0x3D, 0x6D, 0xC4, 0xD1, 0xA4, 0xFB, 0xF4, 0xD6, 0xD3, 
/*01A0:*/ 0x6A, 0xE9, 0x69, 0x43, 0xFC, 0xD9, 0x6E, 0x34, 0x46, 0x88, 0x67, 0xAD, 0xD0, 0xB8, 0x60, 0xDA, 
/*01B0:*/ 0x73, 0x2D, 0x04, 0x44, 0xE5, 0x1D, 0x03, 0x33, 0x5F, 0x4C, 0x0A, 0xAA, 0xC9, 0x7C, 0x0D, 0xDD, 
/*01C0:*/ 0x3C, 0x71, 0x05, 0x50, 0xAA, 0x41, 0x02, 0x27, 0x10, 0x10, 0x0B, 0xBE, 0x86, 0x20, 0x0C, 0xC9, 
/*01D0:*/ 0x25, 0xB5, 0x68, 0x57, 0xB3, 0x85, 0x6F, 0x20, 0x09, 0xD4, 0x66, 0xB9, 0x9F, 0xE4, 0x61, 0xCE, 
/*01E0:*/ 0x0E, 0xF9, 0xDE, 0x5E, 0x98, 0xC9, 0xD9, 0x29, 0x22, 0x98, 0xD0, 0xB0, 0xB4, 0xA8, 0xD7, 0xC7, 
/*01F0:*/ 0x17, 0x3D, 0xB3, 0x59, 0x81, 0x0D, 0xB4, 0x2E, 0x3B, 0x5C, 0xBD, 0xB7, 0xAD, 0x6C, 0xBA, 0xC0, 
/*0200:*/ 0x20, 0x83, 0xB8, 0xED, 0xB6, 0xB3, 0xBF, 0x9A, 0x0C, 0xE2, 0xB6, 0x03, 0x9A, 0xD2, 0xB1, 0x74, 
/*0210:*/ 0x39, 0x47, 0xD5, 0xEA, 0xAF, 0x77, 0xD2, 0x9D, 0x15, 0x26, 0xDB, 0x04, 0x83, 0x16, 0xDC, 0x73, 
/*0220:*/ 0x12, 0x0B, 0x63, 0xE3, 0x84, 0x3B, 0x64, 0x94, 0x3E, 0x6A, 0x6D, 0x0D, 0xA8, 0x5A, 0x6A, 0x7A, 
/*0230:*/ 0x0B, 0xCF, 0x0E, 0xE4, 0x9D, 0xFF, 0x09, 0x93, 0x27, 0xAE, 0x00, 0x0A, 0xB1, 0x9E, 0x07, 0x7D, 
/*0240:*/ 0x44, 0x93, 0x0F, 0xF0, 0xD2, 0xA3, 0x08, 0x87, 0x68, 0xF2, 0x01, 0x1E, 0xFE, 0xC2, 0x06, 0x69, 
/*0250:*/ 0x5D, 0x57, 0x62, 0xF7, 0xCB, 0x67, 0x65, 0x80, 0x71, 0x36, 0x6C, 0x19, 0xE7, 0x06, 0x6B, 0x6E, 
/*0260:*/ 0x76, 0x1B, 0xD4, 0xFE, 0xE0, 0x2B, 0xD3, 0x89, 0x5A, 0x7A, 0xDA, 0x10, 0xCC, 0x4A, 0xDD, 0x67, 
/*0270:*/ 0x6F, 0xDF, 0xB9, 0xF9, 0xF9, 0xEF, 0xBE, 0x8E, 0x43, 0xBE, 0xB7, 0x17, 0xD5, 0x8E, 0xB0, 0x60, 
/*0280:*/ 0xE8, 0xA3, 0xD6, 0xD6, 0x7E, 0x93, 0xD1, 0xA1, 0xC4, 0xC2, 0xD8, 0x38, 0x52, 0xF2, 0xDF, 0x4F, 
/*0290:*/ 0xF1, 0x67, 0xBB, 0xD1, 0x67, 0x57, 0xBC, 0xA6, 0xDD, 0x06, 0xB5, 0x3F, 0x4B, 0x36, 0xB2, 0x48, 
/*02A0:*/ 0xDA, 0x2B, 0x0D, 0xD8, 0x4C, 0x1B, 0x0A, 0xAF, 0xF6, 0x4A, 0x03, 0x36, 0x60, 0x7A, 0x04, 0x41, 
/*02B0:*/ 0xC3, 0xEF, 0x60, 0xDF, 0x55, 0xDF, 0x67, 0xA8, 0xEF, 0x8E, 0x6E, 0x31, 0x79, 0xBE, 0x69, 0x46, 
/*02C0:*/ 0x8C, 0xB3, 0x61, 0xCB, 0x1A, 0x83, 0x66, 0xBC, 0xA0, 0xD2, 0x6F, 0x25, 0x36, 0xE2, 0x68, 0x52, 
/*02D0:*/ 0x95, 0x77, 0x0C, 0xCC, 0x03, 0x47, 0x0B, 0xBB, 0xB9, 0x16, 0x02, 0x22, 0x2F, 0x26, 0x05, 0x55, 
/*02E0:*/ 0xBE, 0x3B, 0xBA, 0xC5, 0x28, 0x0B, 0xBD, 0xB2, 0x92, 0x5A, 0xB4, 0x2B, 0x04, 0x6A, 0xB3, 0x5C, 
/*02F0:*/ 0xA7, 0xFF, 0xD7, 0xC2, 0x31, 0xCF, 0xD0, 0xB5, 0x8B, 0x9E, 0xD9, 0x2C, 0x1D, 0xAE, 0xDE, 0x5B, 
/*0300:*/ 0xB0, 0xC2, 0x64, 0x9B, 0x26, 0xF2, 0x63, 0xEC, 0x9C, 0xA3, 0x6A, 0x75, 0x0A, 0x93, 0x6D, 0x02, 
/*0310:*/ 0xA9, 0x06, 0x09, 0x9C, 0x3F, 0x36, 0x0E, 0xEB, 0x85, 0x67, 0x07, 0x72, 0x13, 0x57, 0x00, 0x05, 
/*0320:*/ 0x82, 0x4A, 0xBF, 0x95, 0x14, 0x7A, 0xB8, 0xE2, 0xAE, 0x2B, 0xB1, 0x7B, 0x38, 0x1B, 0xB6, 0x0C, 
/*0330:*/ 0x9B, 0x8E, 0xD2, 0x92, 0x0D, 0xBE, 0xD5, 0xE5, 0xB7, 0xEF, 0xDC, 0x7C, 0x21, 0xDF, 0xDB, 0x0B, 
/*0340:*/ 0xD4, 0xD2, 0xD3, 0x86, 0x42, 0xE2, 0xD4, 0xF1, 0xF8, 0xB3, 0xDD, 0x68, 0x6E, 0x83, 0xDA, 0x1F, 
/*0350:*/ 0xCD, 0x16, 0xBE, 0x81, 0x5B, 0x26, 0xB9, 0xF6, 0xE1, 0x77, 0xB0, 0x6F, 0x77, 0x47, 0xB7, 0x18, 
/*0360:*/ 0xE6, 0x5A, 0x08, 0x88, 0x70, 0x6A, 0x0F, 0xFF, 0xCA, 0x3B, 0x06, 0x66, 0x5C, 0x0B, 0x01, 0x11, 
/*0370:*/ 0xFF, 0x9E, 0x65, 0x8F, 0x69, 0xAE, 0x62, 0xF8, 0xD3, 0xFF, 0x6B, 0x61, 0x45, 0xCF, 0x6C, 0x16, 
/*0380:*/ 0x78, 0xE2, 0x0A, 0xA0, 0xEE, 0xD2, 0x0D, 0xD7, 0x54, 0x83, 0x04, 0x4E, 0xC2, 0xB3, 0x03, 0x39, 
/*0390:*/ 0x61, 0x26, 0x67, 0xA7, 0xF7, 0x16, 0x60, 0xD0, 0x4D, 0x47, 0x69, 0x49, 0xDB, 0x77, 0x6E, 0x3E, 
/*03A0:*/ 0x4A, 0x6A, 0xD1, 0xAE, 0xDC, 0x5A, 0xD6, 0xD9, 0x66, 0x0B, 0xDF, 0x40, 0xF0, 0x3B, 0xD8, 0x37, 
/*03B0:*/ 0x53, 0xAE, 0xBC, 0xA9, 0xC5, 0x9E, 0xBB, 0xDE, 0x7F, 0xCF, 0xB2, 0x47, 0xE9, 0xFF, 0xB5, 0x30, 
/*03C0:*/ 0x1C, 0xF2, 0xBD, 0xBD, 0x8A, 0xC2, 0xBA, 0xCA, 0x30, 0x93, 0xB3, 0x53, 0xA6, 0xA3, 0xB4, 0x24, 
/*03D0:*/ 0x05, 0x36, 0xD0, 0xBA, 0x93, 0x06, 0xD7, 0xCD, 0x29, 0x57, 0xDE, 0x54, 0xBF, 0x67, 0xD9, 0x23, 
/*03E0:*/ 0x2E, 0x7A, 0x66, 0xB3, 0xB8, 0x4A, 0x61, 0xC4, 0x02, 0x1B, 0x68, 0x5D, 0x94, 0x2B, 0x6F, 0x2A, 
/*03F0:*/ 0x37, 0xBE, 0x0B, 0xB4, 0xA1, 0x8E, 0x0C, 0xC3, 0x1B, 0xDF, 0x05, 0x5A, 0x8D, 0xEF, 0x02, 0x2D, 
/*0400:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

//////////////////
// block 3
//////////////////

void* Block3Func1Data1[] = {
		Block3Func0,
		Block3Func1,
		Block3Func2,
		Block3Func3,
		Block3Func4,
		Block3Func5,
		Block3Func6,
		Block3Func7,
		Block3Func8,
		Block3Func9,
		Block3FuncA,
		Block3FuncB,
		Block3FuncC,
		Block3FuncD,
		Block3FuncE,
		Block3FuncF
};


//////////////////////
// block 4
//////////////////////

BYTE B3D2_0[] = {
/*00C9F8:*/ 0xC3, 0xB1, 0x04, 0xF2, 0x8B, 0x91, 0x11, 0xF2, 
/*00CA00:*/ 0x99, 0x91, 0x11, 0xF2, 0x8B, 0xA1, 0x11, 0xF2, 0x99, 0xA1, 0x11, 0xF2, 0xDC, 0xA1, 0x13, 0xF2, 
/*00CA10:*/ 0xE8, 0xF1, 0x13, 0xF2, 0xB7, 0x81, 0x15, 0xF2, 0xE0, 0x81, 0x15, 0xF2, 0x8B, 0x91, 0x15, 0xF2, 
/*00CA20:*/ 0xCF, 0x91, 0x15, 0xF2, 0xE0, 0xB1, 0x15, 0xF2, 0xE9, 0xF1, 0x15, 0xF2, 0x89, 0x41, 0x16, 0xF2, 
/*00CA30:*/ 0x98, 0x91, 0x17, 0xF2, 0xBE, 0xF1, 0x17, 0xF2, 0x8D, 0xD1, 0x18, 0xF2, 0xD5, 0xE1, 0x19, 0xF2, 
/*00CA40:*/ 0x98, 0xA1, 0x1B, 0xF2, 0xCE, 0xA1, 0x1B, 0xF2, 0xF3, 0xB1, 0x1B, 0xF2, 0xAC, 0xC1, 0x1B, 0xF2, 
/*00CA50:*/ 0xE9, 0xC1, 0x1B, 0xF2, 0xAC, 0xF1, 0x1B, 0xF2, 0xE9, 0xF1, 0x1D, 0xF2, 0xBD, 0x11, 0x1E, 0xF2, 
/*00CA60:*/ 0xF9, 0x21, 0x1E, 0xF2, 0x8C, 0xD1, 0x1E, 0xF2, 0xA9, 0x61, 0x1F, 0xF2, 0xDD, 0x91, 0x1F, 0xF2, 
/*00CA70:*/ 0xAB, 0xC1, 0x31, 0xF2, 0xE1, 0xC1, 0x32, 0xF2, 0x9E, 0x91, 0x33, 0xF2, 0xE6, 0xB1, 0x33, 0xF2, 
/*00CA80:*/ 0xD2, 0xE1, 0x33, 0xF2, 0xFD, 0xF1, 0x33, 0xF2, 0xF5, 0x81, 0x35, 0xF2, 0xEF, 0xC1, 0x35, 0xF2, 
/*00CA90:*/ 0x97, 0xE1, 0x35, 0xF2, 0x82, 0xA1, 0x36, 0xF2, 0xB8, 0xC1, 0x39, 0xF2, 0xAB, 0xF1, 0x39, 0xF2, 
/*00CAA0:*/ 0x8C, 0x91, 0x3B, 0xF2, 0xAB, 0xC1, 0x3D, 0xF2, 0xCE, 0xE1, 0x3E, 0xF2, 0x8D, 0xA1, 0x3F, 0xF2, 
/*00CAB0:*/ 0xAA, 0xC1, 0x3F, 0xF2, 0xBC, 0x71, 0x50, 0xF2, 0xAA, 0xE1, 0x52, 0xF2, 0xAD, 0x91, 0x53, 0xF2, 
/*00CAC0:*/ 0xBF, 0x91, 0x53, 0xF2, 0xBF, 0xA1, 0x53, 0xF2, 0x99, 0xC1, 0x53, 0xF2, 0xFB, 0x91, 0x55, 0xF2, 
/*00CAD0:*/ 0xB1, 0x91, 0x58, 0xF2, 0x85, 0xF1, 0x5A, 0xF2, 0xD5, 0xB1, 0x5B, 0xF2, 0xF4, 0x91, 0x5C, 0xF2, 
/*00CAE0:*/ 0x8B, 0xC1, 0x5D, 0xF2, 0xF3, 0xE1, 0x5D, 0xF2, 0xD1, 0x21, 0x5F, 0xF2, 0x8B, 0xF1, 0x5F, 0xF2, 
/*00CAF0:*/ 0x8A, 0x81, 0x72, 0xF2, 0xA4, 0x91, 0x72, 0xF2, 0xE8, 0xD1, 0x72, 0xF2, 0xFA, 0xD1, 0x72, 0xF2, 
/*00CB00:*/ 0x8D, 0xC1, 0x73, 0xF2, 0xC9, 0xC1, 0x73, 0xF2, 0xD3, 0xB1, 0x75, 0xF2, 0x9D, 0x21, 0x76, 0xF2, 
/*00CB10:*/ 0x8C, 0xC1, 0x77, 0xF2, 0x8A, 0xB1, 0x78, 0xF2, 0x90, 0xF1, 0x78, 0xF2, 0xC7, 0xF1, 0x78, 0xF2, 
/*00CB20:*/ 0xDB, 0xC1, 0x79, 0xF2, 0xDB, 0xF1, 0x79, 0xF2, 0xAA, 0xA1, 0x7B, 0xF2, 0xE7, 0xD1, 0x7D, 0xF2, 
/*00CB30:*/ 0xB1, 0xE1, 0x7D, 0xF2, 0x99, 0xB1, 0x7E, 0xF2, 0x83, 0xF1, 0x7E, 0xF2, 0x96, 0x81, 0x7F, 0xF2, 
/*00CB40:*/ 0xD2, 0x81, 0x7F, 0xF2, 0xFD, 0xA1, 0x7F, 0xF2, 0x8D, 0xB1, 0x88, 0xF2, 0x9D, 0x91, 0x92, 0xF2, 
/*00CB50:*/ 0xFF, 0xC1, 0x92, 0xF2, 0xF9, 0xB1, 0x93, 0xF2, 0xE2, 0xC1, 0x93, 0xF2, 0xA5, 0x21, 0x96, 0xF2, 
/*00CB60:*/ 0x94, 0xD1, 0x96, 0xF2, 0xF6, 0x81, 0x9A, 0xF2, 0xC4, 0xA1, 0x9B, 0xF2, 0xCD, 0xE1, 0x9B, 0xF2, 
/*00CB70:*/ 0xD7, 0xA1, 0x9D, 0xF2, 0xAF, 0xB1, 0x9D, 0xF2, 0xB5, 0xC1, 0x9D, 0xF2, 0xA5, 0x21, 0x9E, 0xF2, 
/*00CB80:*/ 0xB4, 0xF1, 0x9F, 0xF2, 0x99, 0x71, 0xB1, 0xF2, 0xA9, 0xB1, 0xB1, 0xF2, 0x99, 0x41, 0xB3, 0xF2, 
/*00CB90:*/ 0xBA, 0xB1, 0xB3, 0xF2, 0xCA, 0xE1, 0xB3, 0xF2, 0xF7, 0xF1, 0xB3, 0xF2, 0xB9, 0x51, 0xB4, 0xF2, 
/*00CBA0:*/ 0x86, 0xA1, 0xB5, 0xF2, 0xBB, 0xB1, 0xB5, 0xF2, 0xF6, 0xF1, 0xB5, 0xF2, 0xAE, 0xF1, 0xB6, 0xF2, 
/*00CBB0:*/ 0xA8, 0x81, 0xB7, 0xF2, 0x8F, 0xD1, 0xB7, 0xF2, 0xCA, 0xD1, 0xB9, 0xF2, 0xDE, 0x91, 0xBA, 0xF2, 
/*00CBC0:*/ 0xAE, 0xC1, 0xBA, 0xF2, 0xED, 0x81, 0xBD, 0xF2, 0xC3, 0xA1, 0xBD, 0xF2, 0xF7, 0xF1, 0xBD, 0xF2, 
/*00CBD0:*/ 0xBA, 0x91, 0xD0, 0xF2, 0xA0, 0xD1, 0xD2, 0xF2, 0xB2, 0xE1, 0xD2, 0xF2, 0xF6, 0xE1, 0xD2, 0xF2, 
/*00CBE0:*/ 0xF6, 0xD1, 0xD6, 0xF2, 0xFD, 0x71, 0xD7, 0xF2, 0xC4, 0xF1, 0xD7, 0xF2, 0xA0, 0xE1, 0xD8, 0xF2, 
/*00CBF0:*/ 0xE2, 0x91, 0xD9, 0xF2, 0xAF, 0xD1, 0xD9, 0xF2, 0xBD, 0xE1, 0xD9, 0xF2, 0xDE, 0x81, 0xDB, 0xF2, 
/*00CC00:*/ 0x9B, 0xB1, 0xDD, 0xF2, 0xB2, 0xA1, 0xF1, 0xF2, 0xA3, 0x71, 0xF2, 0xF2, 0x92, 0x81, 0xF2, 0xF2, 
/*00CC10:*/ 0xC3, 0xF1, 0xF3, 0xF2, 0x84, 0x21, 0xF4, 0xF2, 0xC9, 0x51, 0xF6, 0xF2, 0xDB, 0x61, 0xF6, 0xF2, 
/*00CC20:*/ 0xAD, 0x41, 0xF7, 0xF2, 0xE4, 0xA1, 0xF9, 0xF2, 0x86, 0xC1, 0xF9, 0xF2, 0xF7, 0x91, 0xFB, 0xF2, 
/*00CC30:*/ 0x87, 0xF1, 0xFB, 0xF2, 0x97, 0x11, 0xFE, 0xF2, 0xD0, 0xF1, 0xFF, 0xF2, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00CC40:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00CC50:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_1[] = {
/*00D1E8:*/ 0x29, 0xD7, 0x1C, 0x20, 0x49, 0xD4, 0x9A, 0x20, 
/*00D1F0:*/ 0x29, 0xD4, 0xC8, 0x21, 0xC9, 0xD7, 0x8C, 0x22, 0x89, 0xD4, 0x1A, 0x23, 0x89, 0xD7, 0x3E, 0x23, 
/*00D200:*/ 0x51, 0xD4, 0x9E, 0x23, 0x09, 0xD5, 0x2A, 0x28, 0x49, 0xD6, 0x2C, 0x28, 0x49, 0xD4, 0x9C, 0x28, 
/*00D210:*/ 0x89, 0xD5, 0xEC, 0x28, 0x49, 0xD7, 0x08, 0x29, 0xE9, 0xD5, 0xBE, 0x29, 0x99, 0xD7, 0xEC, 0x29, 
/*00D220:*/ 0xA9, 0xD4, 0x2C, 0x2A, 0xA9, 0xD5, 0x08, 0x2B, 0xF9, 0xD6, 0x0E, 0x2B, 0x89, 0xD5, 0x88, 0x2B, 
/*00D230:*/ 0xA9, 0xD4, 0x9C, 0x2B, 0xD1, 0xD5, 0xAA, 0x2B, 0x49, 0xD7, 0xDC, 0x2B, 0x41, 0xD4, 0x18, 0x30, 
/*00D240:*/ 0xE1, 0xD4, 0x1E, 0x30, 0xA1, 0xD6, 0x1C, 0x31, 0xE1, 0xD6, 0x1E, 0x31, 0xE9, 0xD6, 0x5E, 0x31, 
/*00D250:*/ 0x91, 0xD7, 0x68, 0x31, 0xE1, 0xD7, 0xCA, 0x31, 0xA1, 0xD4, 0xCC, 0x31, 0x59, 0xD7, 0xEC, 0x31, 
/*00D260:*/ 0x09, 0xD7, 0xEE, 0x31, 0x61, 0xD6, 0xF8, 0x31, 0xC1, 0xD5, 0xFA, 0x31, 0xE1, 0xD6, 0x1A, 0x32, 
/*00D270:*/ 0x69, 0xD4, 0x6C, 0x32, 0xC9, 0xD6, 0xDA, 0x32, 0x59, 0xD4, 0xEC, 0x32, 0x49, 0xD7, 0x58, 0x33, 
/*00D280:*/ 0xA9, 0xD5, 0xFC, 0x34, 0x29, 0xD4, 0x3A, 0x36, 0x69, 0xD6, 0x2E, 0x38, 0x71, 0xD5, 0x4A, 0x38, 
/*00D290:*/ 0x39, 0xD5, 0x68, 0x38, 0x99, 0xD5, 0x6E, 0x38, 0xE9, 0xD7, 0x7C, 0x38, 0x09, 0xD6, 0xAC, 0x38, 
/*00D2A0:*/ 0x49, 0xD6, 0xAE, 0x38, 0x89, 0xD7, 0xBE, 0x38, 0x81, 0xD4, 0xDA, 0x38, 0x81, 0xD4, 0xFA, 0x38, 
/*00D2B0:*/ 0xF1, 0xD6, 0x18, 0x39, 0xF9, 0xD6, 0x38, 0x39, 0xE1, 0xD5, 0x3C, 0x39, 0x41, 0xD5, 0x5A, 0x39, 
/*00D2C0:*/ 0x69, 0xD4, 0x6E, 0x39, 0xE1, 0xD5, 0x7C, 0x39, 0xB9, 0xD4, 0x8A, 0x39, 0xD1, 0xD6, 0x98, 0x39, 
/*00D2D0:*/ 0x39, 0xD5, 0xB8, 0x39, 0x61, 0xD5, 0xDA, 0x39, 0x59, 0xD5, 0x1E, 0x3A, 0xC9, 0xD7, 0x28, 0x3A, 
/*00D2E0:*/ 0x99, 0xD7, 0x2A, 0x3A, 0x29, 0xD7, 0x2C, 0x3A, 0x89, 0xD4, 0x2E, 0x3A, 0x61, 0xD7, 0x2E, 0x3A, 
/*00D2F0:*/ 0x29, 0xD4, 0x48, 0x3A, 0x89, 0xD7, 0x4A, 0x3A, 0x31, 0xD7, 0x6C, 0x3A, 0xB9, 0xD4, 0x8E, 0x3A, 
/*00D300:*/ 0x99, 0xD5, 0xDA, 0x3A, 0x79, 0xD6, 0xDA, 0x3A, 0xD9, 0xD6, 0xFC, 0x3A, 0x91, 0xD6, 0xFE, 0x3A, 
/*00D310:*/ 0x79, 0xD5, 0x0E, 0x3B, 0x21, 0xD6, 0x48, 0x3B, 0xA9, 0xD4, 0x7E, 0x3B, 0x81, 0xD7, 0x9A, 0x3B, 
/*00D320:*/ 0xD1, 0xD4, 0x9C, 0x3B, 0x49, 0xD5, 0xAE, 0x3B, 0x41, 0xD6, 0xCA, 0x3B, 0xA1, 0xD6, 0xCE, 0x3B, 
/*00D330:*/ 0x81, 0xD4, 0xDE, 0x3B, 0xF9, 0xD5, 0xE8, 0x3B, 0x41, 0xD5, 0xEE, 0x3B, 0x89, 0xD5, 0x3C, 0x60, 
/*00D340:*/ 0x69, 0xD5, 0xA8, 0x61, 0xA9, 0xD5, 0x28, 0x62, 0x59, 0xD6, 0x28, 0x62, 0x69, 0xD7, 0x3C, 0x62, 
/*00D350:*/ 0x11, 0xD6, 0xBA, 0x63, 0x81, 0xD7, 0xCA, 0x68, 0x01, 0xD5, 0x2C, 0x69, 0xA9, 0xD6, 0x2E, 0x69, 
/*00D360:*/ 0x89, 0xD5, 0xAA, 0x69, 0x91, 0xD6, 0xCE, 0x69, 0xA9, 0xD5, 0x0E, 0x6A, 0x89, 0xD7, 0x1E, 0x6A, 
/*00D370:*/ 0xE9, 0xD5, 0x2C, 0x6A, 0x89, 0xD6, 0x8A, 0x6A, 0xE9, 0xD7, 0xDC, 0x6A, 0x69, 0xD6, 0x5E, 0x6B, 
/*00D380:*/ 0x09, 0xD6, 0x9C, 0x6B, 0x99, 0xD4, 0x6A, 0x70, 0x31, 0xD5, 0x68, 0x71, 0x11, 0xD7, 0x78, 0x71, 
/*00D390:*/ 0x91, 0xD4, 0xBA, 0x71, 0x61, 0xD4, 0xBE, 0x71, 0x09, 0xD6, 0xEC, 0x71, 0x91, 0xD5, 0x6A, 0x72, 
/*00D3A0:*/ 0xD9, 0xD6, 0x6C, 0x72, 0xA1, 0xD7, 0x7A, 0x72, 0xC1, 0xD4, 0x9C, 0x72, 0x81, 0xD4, 0xBE, 0x72, 
/*00D3B0:*/ 0x29, 0xD7, 0xDC, 0x72, 0xC9, 0xD7, 0x48, 0x73, 0x61, 0xD7, 0x4E, 0x73, 0xE9, 0xD4, 0xAC, 0x73, 
/*00D3C0:*/ 0x29, 0xD7, 0x5C, 0x74, 0xE9, 0xD5, 0x9C, 0x76, 0x51, 0xD5, 0x1C, 0x78, 0x39, 0xD7, 0x2E, 0x78, 
/*00D3D0:*/ 0xE9, 0xD6, 0x3E, 0x78, 0x21, 0xD4, 0x4A, 0x78, 0x39, 0xD4, 0x4A, 0x78, 0xE9, 0xD5, 0x5A, 0x78, 
/*00D3E0:*/ 0x71, 0xD4, 0x68, 0x78, 0x59, 0xD6, 0x78, 0x78, 0x11, 0xD5, 0x7E, 0x78, 0xF9, 0xD4, 0x8E, 0x78, 
/*00D3F0:*/ 0xA1, 0xD4, 0xAC, 0x78, 0x01, 0xD4, 0xCA, 0x78, 0xF1, 0xD7, 0xCA, 0x78, 0xC9, 0xD6, 0xFE, 0x78, 
/*00D400:*/ 0xE1, 0xD7, 0x1A, 0x79, 0x29, 0xD6, 0x2A, 0x79, 0x81, 0xD6, 0x2C, 0x79, 0xC9, 0xD6, 0x2E, 0x79, 
/*00D410:*/ 0x59, 0xD4, 0x38, 0x79, 0x59, 0xD7, 0x5C, 0x79, 0x71, 0xD6, 0x68, 0x79, 0xF9, 0xD4, 0x7E, 0x79, 
/*00D420:*/ 0x19, 0xD5, 0x8E, 0x79, 0x21, 0xD7, 0x9E, 0x79, 0x49, 0xD6, 0xA8, 0x79, 0x19, 0xD6, 0xCA, 0x79, 
/*00D430:*/ 0x89, 0xD4, 0xDC, 0x79, 0x01, 0xD5, 0xEE, 0x79, 0x29, 0xD7, 0xFE, 0x79, 0x99, 0xD6, 0x08, 0x7A, 
/*00D440:*/ 0xA1, 0xD4, 0x58, 0x7A, 0x71, 0xD6, 0x6C, 0x7A, 0xB9, 0xD4, 0x78, 0x7A, 0xE9, 0xD4, 0x7A, 0x7A, 
/*00D450:*/ 0x21, 0xD7, 0x9A, 0x7A, 0x71, 0xD4, 0x9C, 0x7A, 0x21, 0xD4, 0x9E, 0x7A, 0x09, 0xD6, 0xAE, 0x7A, 
/*00D460:*/ 0x21, 0xD4, 0xBE, 0x7A, 0x51, 0xD5, 0xE8, 0x7A, 0xE1, 0xD5, 0xEE, 0x7A, 0x79, 0xD7, 0x08, 0x7B, 
/*00D470:*/ 0x81, 0xD4, 0x28, 0x7B, 0x61, 0xD7, 0x48, 0x7B, 0x29, 0xD4, 0x4E, 0x7B, 0xB9, 0xD6, 0x58, 0x7B, 
/*00D480:*/ 0xD1, 0xD4, 0x6A, 0x7B, 0x21, 0xD7, 0x6A, 0x7B, 0x31, 0xD7, 0x6A, 0x7B, 0x89, 0xD7, 0x6C, 0x7B, 
/*00D490:*/ 0x59, 0xD6, 0x7C, 0x7B, 0xE9, 0xD5, 0x7E, 0x7B, 0x09, 0xD6, 0x7E, 0x7B, 0x79, 0xD6, 0x9C, 0x7B, 
/*00D4A0:*/ 0x99, 0xD6, 0xB8, 0x7B, 0x21, 0xD5, 0xBA, 0x7B, 0x29, 0xD6, 0xBE, 0x7B, 0xE1, 0xD4, 0xCA, 0x7B, 
/*00D4B0:*/ 0x81, 0xD6, 0xD8, 0x7B, 0x99, 0xD6, 0xD8, 0x7B, 0xC1, 0xD5, 0xDE, 0x7B, 0x01, 0xD7, 0xEA, 0x7B, 
/*00D4C0:*/ 0x11, 0xD7, 0xEA, 0x7B, 0x99, 0xD5, 0xFC, 0x7B, 0x79, 0xD6, 0xFC, 0x7B, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00D4D0:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00D4E0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_2[] = {
/*00DBD8:*/ 0xFB, 0x1C, 0x28, 0x00, 0xA9, 0x00, 0xB8, 0x00, 
/*00DBE0:*/ 0xAB, 0x0C, 0xB8, 0x00, 0xB8, 0x08, 0x38, 0x01, 0xB8, 0x04, 0xB8, 0x01, 0xCB, 0x14, 0xB8, 0x01, 
/*00DBF0:*/ 0xBA, 0x15, 0x08, 0x02, 0xD9, 0x19, 0x18, 0x02, 0xD8, 0x18, 0x28, 0x02, 0xEA, 0x0D, 0x88, 0x02, 
/*00DC00:*/ 0xE9, 0x15, 0xA8, 0x02, 0xEB, 0x19, 0xA8, 0x02, 0xE9, 0x1D, 0xB8, 0x02, 0xAB, 0x19, 0x18, 0x03, 
/*00DC10:*/ 0xDB, 0x04, 0x28, 0x03, 0xF8, 0x15, 0x38, 0x03, 0xB9, 0x0D, 0x98, 0x03, 0xB8, 0x0C, 0xA8, 0x03, 
/*00DC20:*/ 0xC9, 0x18, 0x08, 0x04, 0xB8, 0x0C, 0x18, 0x04, 0xCA, 0x15, 0x38, 0x04, 0xA9, 0x15, 0xA8, 0x04, 
/*00DC30:*/ 0xF9, 0x09, 0xB8, 0x04, 0xDA, 0x0D, 0x08, 0x05, 0xFB, 0x01, 0x98, 0x05, 0xC9, 0x18, 0x08, 0x06, 
/*00DC40:*/ 0xA8, 0x05, 0x18, 0x06, 0xD8, 0x05, 0x28, 0x06, 0xD8, 0x09, 0xA8, 0x06, 0xC9, 0x09, 0x38, 0x07, 
/*00DC50:*/ 0xB8, 0x15, 0x38, 0x07, 0xC8, 0x19, 0x88, 0x07, 0xD9, 0x11, 0xB8, 0x07, 0xFA, 0x1D, 0x18, 0x08, 
/*00DC60:*/ 0xEB, 0x0C, 0x08, 0x09, 0xB9, 0x1C, 0x18, 0x09, 0xAB, 0x08, 0x98, 0x09, 0xBB, 0x1C, 0x98, 0x09, 
/*00DC70:*/ 0xFB, 0x09, 0x38, 0x0A, 0xEB, 0x1D, 0x38, 0x0A, 0xF8, 0x1D, 0x98, 0x0A, 0xF8, 0x00, 0x28, 0x0B, 
/*00DC80:*/ 0xFA, 0x0C, 0x28, 0x0B, 0xFA, 0x00, 0x18, 0x0C, 0x89, 0x14, 0x38, 0x0D, 0xF8, 0x19, 0x08, 0x0E, 
/*00DC90:*/ 0xB9, 0x10, 0x28, 0x0E, 0xFA, 0x04, 0x38, 0x0F, 0xFA, 0x1D, 0xA8, 0x0F, 0xFA, 0x10, 0x18, 0x10, 
/*00DCA0:*/ 0xBB, 0x11, 0x28, 0x10, 0xF9, 0x1D, 0x28, 0x10, 0xBA, 0x14, 0x88, 0x10, 0xB9, 0x0C, 0x18, 0x11, 
/*00DCB0:*/ 0xDB, 0x0D, 0x08, 0x12, 0xFA, 0x18, 0x08, 0x12, 0xD9, 0x09, 0x18, 0x12, 0xBA, 0x0D, 0x18, 0x12, 
/*00DCC0:*/ 0xD9, 0x0D, 0x88, 0x12, 0xB9, 0x0C, 0xA8, 0x12, 0xA9, 0x10, 0x08, 0x13, 0xB8, 0x10, 0x28, 0x13, 
/*00DCD0:*/ 0xAA, 0x15, 0x28, 0x13, 0xBA, 0x14, 0x38, 0x13, 0xA8, 0x15, 0xA8, 0x13, 0xDB, 0x10, 0xB8, 0x13, 
/*00DCE0:*/ 0xB8, 0x1C, 0x18, 0x14, 0xBB, 0x19, 0x38, 0x14, 0xD8, 0x1D, 0x38, 0x14, 0xFA, 0x09, 0x88, 0x14, 
/*00DCF0:*/ 0xBB, 0x1D, 0x18, 0x15, 0xAB, 0x10, 0x88, 0x15, 0xBB, 0x0C, 0x98, 0x15, 0xBB, 0x11, 0x28, 0x16, 
/*00DD00:*/ 0xAB, 0x09, 0xA8, 0x16, 0xDA, 0x00, 0x08, 0x17, 0xD8, 0x11, 0x08, 0x17, 0xDA, 0x1D, 0x08, 0x17, 
/*00DD10:*/ 0xDB, 0x10, 0xB8, 0x17, 0xEB, 0x01, 0xB8, 0x18, 0xB9, 0x19, 0xB8, 0x18, 0xA9, 0x10, 0x08, 0x19, 
/*00DD20:*/ 0xFB, 0x00, 0xA8, 0x1A, 0xF9, 0x04, 0x08, 0x1B, 0xF8, 0x18, 0x38, 0x1B, 0xBB, 0x0C, 0x98, 0x1B, 
/*00DD30:*/ 0xF8, 0x09, 0xB8, 0x1B, 0xF8, 0x0D, 0x28, 0x1D, 0xF9, 0x08, 0x88, 0x1D, 0x8B, 0x04, 0xB8, 0x1D, 
/*00DD40:*/ 0xF8, 0x18, 0x88, 0x1E, 0x89, 0x19, 0x88, 0x1E, 0xDB, 0x01, 0x38, 0x1F, 0xAA, 0x04, 0xA8, 0x80, 
/*00DD50:*/ 0xBA, 0x10, 0xA8, 0x80, 0xFA, 0x18, 0xB8, 0x80, 0xBA, 0x10, 0x18, 0x81, 0xB9, 0x08, 0x38, 0x81, 
/*00DD60:*/ 0xFB, 0x00, 0xA8, 0x81, 0x8A, 0x01, 0xA8, 0x81, 0xEA, 0x15, 0x28, 0x82, 0xDB, 0x05, 0xA8, 0x82, 
/*00DD70:*/ 0xF9, 0x00, 0x28, 0x83, 0xB9, 0x04, 0x08, 0x84, 0xFB, 0x1D, 0x18, 0x84, 0xA8, 0x04, 0x28, 0x84, 
/*00DD80:*/ 0xD9, 0x1C, 0x08, 0x85, 0xC9, 0x00, 0x18, 0x85, 0xFA, 0x0D, 0x18, 0x85, 0xA8, 0x0C, 0x88, 0x85, 
/*00DD90:*/ 0xDA, 0x15, 0xA8, 0x85, 0xDB, 0x14, 0x28, 0x86, 0xAB, 0x10, 0x88, 0x86, 0xA8, 0x08, 0xA8, 0x86, 
/*00DDA0:*/ 0xD9, 0x01, 0xB8, 0x86, 0xB8, 0x14, 0x08, 0x87, 0xF9, 0x19, 0x08, 0x88, 0xBA, 0x09, 0x38, 0x88, 
/*00DDB0:*/ 0xFB, 0x0C, 0x98, 0x88, 0xB8, 0x05, 0x88, 0x89, 0xE9, 0x18, 0xA8, 0x89, 0xFA, 0x1C, 0x28, 0x8A, 
/*00DDC0:*/ 0xF9, 0x00, 0x28, 0x8B, 0xBB, 0x08, 0xB8, 0x8B, 0x88, 0x10, 0xA8, 0x8D, 0xF8, 0x1C, 0xA8, 0x8E, 
/*00DDD0:*/ 0xF9, 0x08, 0x38, 0x8F, 0xFB, 0x19, 0x38, 0x8F, 0xB9, 0x01, 0x18, 0x90, 0xFB, 0x10, 0x18, 0x90, 
/*00DDE0:*/ 0xBB, 0x14, 0x88, 0x90, 0xD8, 0x1C, 0x08, 0x92, 0xE8, 0x14, 0x28, 0x92, 0xAB, 0x1D, 0x38, 0x93, 
/*00DDF0:*/ 0xD9, 0x00, 0x88, 0x93, 0xDA, 0x0D, 0x08, 0x94, 0xFA, 0x1D, 0xA8, 0x94, 0xA8, 0x0D, 0xB8, 0x94, 
/*00DE00:*/ 0xFB, 0x09, 0x38, 0x95, 0xDB, 0x0C, 0x88, 0x95, 0xF8, 0x1D, 0x98, 0x95, 0xDA, 0x18, 0xA8, 0x95, 
/*00DE10:*/ 0xFB, 0x18, 0xB8, 0x95, 0xAB, 0x11, 0x08, 0x96, 0xBB, 0x10, 0x18, 0x96, 0xA9, 0x11, 0x88, 0x96, 
/*00DE20:*/ 0x8B, 0x05, 0x88, 0x97, 0xDA, 0x0D, 0xB8, 0x97, 0xBB, 0x09, 0x88, 0x98, 0xB8, 0x19, 0xB8, 0x98, 
/*00DE30:*/ 0xEA, 0x18, 0x98, 0x99, 0xBB, 0x10, 0xA8, 0x99, 0xF8, 0x1D, 0x28, 0x9A, 0xF8, 0x19, 0xB8, 0x9A, 
/*00DE40:*/ 0xFA, 0x08, 0xB8, 0x9C, 0xFA, 0x11, 0x98, 0x9D, 0xFB, 0x05, 0x08, 0x9E, 0xFB, 0x18, 0x08, 0x9E, 
/*00DE50:*/ 0xF8, 0x15, 0x38, 0x9E, 0xF8, 0x1D, 0x98, 0x9F, 0xF9, 0x1C, 0xA8, 0x9F, 0xF9, 0x14, 0xB8, 0x9F, 
/*00DE60:*/ 0xEB, 0x08, 0xA8, 0xA6, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00DE70:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_3[] = {
/*00E498:*/ 0x5D, 0x86, 0x3F, 0x00, 0x59, 0x97, 0x79, 0x00, 
/*00E4A0:*/ 0x5D, 0x93, 0x7A, 0x00, 0x59, 0x97, 0x5D, 0x01, 0x5D, 0x84, 0xDA, 0x03, 0x59, 0x91, 0xDD, 0x03, 
/*00E4B0:*/ 0x59, 0x87, 0x9E, 0x04, 0x59, 0x80, 0xF8, 0x04, 0x59, 0x93, 0x39, 0x05, 0x5D, 0x93, 0x3B, 0x05, 
/*00E4C0:*/ 0x59, 0x94, 0x3F, 0x05, 0x59, 0x97, 0x3C, 0x06, 0x59, 0x87, 0xBA, 0x07, 0x5D, 0x80, 0xDE, 0x07, 
/*00E4D0:*/ 0x5D, 0x80, 0x9F, 0x08, 0x5D, 0x8C, 0xB8, 0x08, 0x59, 0x8F, 0xFD, 0x08, 0x59, 0x98, 0x3D, 0x09, 
/*00E4E0:*/ 0x5D, 0x82, 0x7A, 0x09, 0x59, 0x81, 0x7F, 0x09, 0x59, 0x88, 0xBF, 0x09, 0x5D, 0x85, 0x38, 0x0A, 
/*00E4F0:*/ 0x5D, 0x87, 0xB9, 0x0A, 0x59, 0x92, 0xDE, 0x0A, 0x59, 0x8D, 0x38, 0x0B, 0x5D, 0x8E, 0x3D, 0x0B, 
/*00E500:*/ 0x59, 0x9F, 0x5B, 0x0B, 0x59, 0x80, 0xB9, 0x0B, 0x59, 0x80, 0xF9, 0x0B, 0x5D, 0x81, 0x1C, 0x0C, 
/*00E510:*/ 0x5D, 0x8E, 0x3C, 0x0C, 0x59, 0x85, 0x7F, 0x0C, 0x59, 0x97, 0x78, 0x0D, 0x59, 0x8E, 0x7A, 0x0D, 
/*00E520:*/ 0x59, 0x85, 0x7B, 0x0D, 0x5D, 0x80, 0x9E, 0x0D, 0x5D, 0x8B, 0xBF, 0x0D, 0x5D, 0x91, 0xFA, 0x0D, 
/*00E530:*/ 0x5D, 0x95, 0xFB, 0x0D, 0x59, 0x90, 0x5A, 0x0E, 0x5D, 0x87, 0x9C, 0x0E, 0x5D, 0x91, 0x7A, 0x20, 
/*00E540:*/ 0x59, 0x90, 0xFE, 0x20, 0x59, 0x85, 0xFB, 0x22, 0x59, 0x85, 0xFF, 0x23, 0x59, 0x91, 0x3D, 0x24, 
/*00E550:*/ 0x59, 0x82, 0xFC, 0x25, 0x5D, 0x85, 0xBC, 0x26, 0x59, 0x81, 0xFB, 0x27, 0x5D, 0x99, 0x3C, 0x28, 
/*00E560:*/ 0x5D, 0x9F, 0xFC, 0x28, 0x59, 0x83, 0x1F, 0x29, 0x59, 0x99, 0x3A, 0x29, 0x5D, 0x85, 0xDD, 0x29, 
/*00E570:*/ 0x5D, 0x80, 0x3E, 0x2A, 0x5D, 0x8B, 0x3B, 0x2B, 0x59, 0x9B, 0xDB, 0x2B, 0x5D, 0x87, 0x1D, 0x2C, 
/*00E580:*/ 0x5D, 0x88, 0x3D, 0x2C, 0x59, 0x86, 0x99, 0x2C, 0x5D, 0x85, 0x9C, 0x2C, 0x5D, 0x86, 0xDB, 0x2C, 
/*00E590:*/ 0x5D, 0x84, 0x5E, 0x2D, 0x5D, 0x8F, 0x7F, 0x2D, 0x5D, 0x82, 0x9E, 0x2D, 0x59, 0x83, 0x1E, 0x2E, 
/*00E5A0:*/ 0x59, 0x87, 0x7F, 0x2E, 0x59, 0x81, 0xDF, 0x2E, 0x59, 0x82, 0xF8, 0x2E, 0x5D, 0x80, 0x3F, 0x2F, 
/*00E5B0:*/ 0x59, 0x86, 0x9D, 0x2F, 0x5D, 0x98, 0xBB, 0x2F, 0x59, 0x87, 0x78, 0x40, 0x5D, 0x97, 0xFC, 0x41, 
/*00E5C0:*/ 0x5D, 0x83, 0x3B, 0x42, 0x59, 0x84, 0x3F, 0x42, 0x5D, 0x83, 0x7F, 0x43, 0x5D, 0x86, 0xF8, 0x43, 
/*00E5D0:*/ 0x5D, 0x9A, 0x3C, 0x44, 0x59, 0x80, 0x7B, 0x44, 0x5D, 0x86, 0x99, 0x44, 0x5D, 0x85, 0x9E, 0x44, 
/*00E5E0:*/ 0x5D, 0x93, 0xBC, 0x44, 0x59, 0x93, 0xBE, 0x44, 0x59, 0x82, 0xFE, 0x45, 0x5D, 0x90, 0xFB, 0x46, 
/*00E5F0:*/ 0x59, 0x9E, 0x3A, 0x48, 0x5D, 0x8F, 0x3C, 0x48, 0x59, 0x8B, 0x3F, 0x48, 0x59, 0x8D, 0xBF, 0x48, 
/*00E600:*/ 0x5D, 0x85, 0xDB, 0x48, 0x5D, 0x86, 0xFC, 0x48, 0x59, 0x8E, 0xFC, 0x49, 0x5D, 0x83, 0x1B, 0x4A, 
/*00E610:*/ 0x5D, 0x92, 0x1F, 0x4A, 0x5D, 0x87, 0x3A, 0x4A, 0x5D, 0x91, 0x58, 0x4A, 0x59, 0x86, 0xBE, 0x4A, 
/*00E620:*/ 0x59, 0x89, 0xBE, 0x4A, 0x5D, 0x83, 0x3F, 0x4B, 0x59, 0x86, 0x9A, 0x4B, 0x59, 0x9F, 0xB8, 0x4B, 
/*00E630:*/ 0x5D, 0x9C, 0xBD, 0x4B, 0x5D, 0x84, 0x18, 0x4C, 0x5D, 0x83, 0x1A, 0x4D, 0x59, 0x88, 0x39, 0x4D, 
/*00E640:*/ 0x5D, 0x80, 0x7D, 0x4D, 0x5D, 0x9B, 0xBE, 0x4D, 0x59, 0x87, 0x5D, 0x4E, 0x5D, 0x86, 0xD9, 0x4E, 
/*00E650:*/ 0x59, 0x85, 0x98, 0x4F, 0x59, 0x86, 0x3F, 0x60, 0x5D, 0x9B, 0x5E, 0x60, 0x59, 0x91, 0xDB, 0x60, 
/*00E660:*/ 0x59, 0x83, 0xF8, 0x60, 0x59, 0x87, 0xF9, 0x60, 0x59, 0x92, 0xFC, 0x60, 0x5D, 0x80, 0xB9, 0x61, 
/*00E670:*/ 0x59, 0x83, 0xFC, 0x61, 0x59, 0x81, 0x59, 0x62, 0x59, 0x95, 0xDA, 0x62, 0x5D, 0x85, 0x7E, 0x63, 
/*00E680:*/ 0x59, 0x8C, 0x9C, 0x63, 0x59, 0x87, 0xFD, 0x63, 0x5D, 0x84, 0xB9, 0x64, 0x59, 0x95, 0xBF, 0x64, 
/*00E690:*/ 0x59, 0x81, 0x18, 0x65, 0x59, 0x9F, 0x1C, 0x65, 0x59, 0x87, 0xF8, 0x65, 0x5D, 0x90, 0x3A, 0x66, 
/*00E6A0:*/ 0x59, 0x80, 0xBA, 0x66, 0x59, 0x80, 0xDA, 0x66, 0x5D, 0x95, 0xFD, 0x66, 0x5D, 0x91, 0xF8, 0x67, 
/*00E6B0:*/ 0x59, 0x85, 0x18, 0x68, 0x5D, 0x82, 0x7C, 0x68, 0x59, 0x83, 0x98, 0x68, 0x59, 0x85, 0x38, 0x6A, 
/*00E6C0:*/ 0x5D, 0x85, 0x3A, 0x6A, 0x5D, 0x8E, 0x3B, 0x6A, 0x59, 0x82, 0x3A, 0x6B, 0x59, 0x8E, 0x3D, 0x6B, 
/*00E6D0:*/ 0x59, 0x87, 0xFD, 0x6B, 0x59, 0x8E, 0x38, 0x6D, 0x59, 0x81, 0x78, 0x6D, 0x59, 0x96, 0xFC, 0x6D, 
/*00E6E0:*/ 0x59, 0x89, 0x3A, 0x6E, 0x59, 0x81, 0x5C, 0x6E, 0x59, 0x83, 0x9D, 0x6E, 0x5D, 0x87, 0xFE, 0x6E, 
/*00E6F0:*/ 0x5D, 0x9C, 0x39, 0x6F, 0x59, 0x82, 0x7F, 0x6F, 0x59, 0x84, 0xDF, 0x6F, 0x59, 0x97, 0xBC, 0x88, 
/*00E700:*/ 0x59, 0x92, 0xBB, 0xAD, 0x59, 0x96, 0x3D, 0xEC, 0x5D, 0x91, 0x3D, 0xED, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00E710:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00E720:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_4[] = {
/*00ED18:*/ 0x96, 0x3C, 0x82, 0xF9, 0x92, 0x5D, 0x82, 0xF9, 
/*00ED20:*/ 0x96, 0x3C, 0x89, 0xF9, 0x82, 0x31, 0x8E, 0xF9, 0x8E, 0xF0, 0x94, 0xF9, 0x96, 0x59, 0x96, 0xF9, 
/*00ED30:*/ 0x9A, 0xF4, 0x98, 0xF9, 0x82, 0xF0, 0x9C, 0xF9, 0x92, 0x31, 0x9D, 0xF9, 0x9E, 0x38, 0xA2, 0xF9, 
/*00ED40:*/ 0x8E, 0x5C, 0xA8, 0xF9, 0x8E, 0xD5, 0xA8, 0xF9, 0x82, 0x31, 0xB2, 0xF9, 0x9A, 0x75, 0xB6, 0xF9, 
/*00ED50:*/ 0x8E, 0x55, 0xBC, 0xF9, 0x8E, 0xF9, 0xBC, 0xF9, 0x96, 0xB5, 0xBE, 0xF9, 0x96, 0x3C, 0xC2, 0xF9, 
/*00ED60:*/ 0x86, 0x7D, 0xC3, 0xF9, 0x96, 0xFD, 0xC4, 0xF9, 0x96, 0x7C, 0xC9, 0xF9, 0x92, 0xF9, 0xD0, 0xF9, 
/*00ED70:*/ 0x96, 0x35, 0xD6, 0xF9, 0x9A, 0x3C, 0xDE, 0xF9, 0x9E, 0xF8, 0xE2, 0xF9, 0x9A, 0xFC, 0xE2, 0xF9, 
/*00ED80:*/ 0x96, 0xFC, 0xEA, 0xF9, 0x8E, 0xF1, 0xEE, 0xF9, 0x82, 0x31, 0xF2, 0xF9, 0x86, 0x3D, 0xF4, 0xF9, 
/*00ED90:*/ 0x86, 0xF4, 0xF4, 0xF9, 0x86, 0x75, 0xF9, 0xF9, 0x8E, 0xF0, 0xFC, 0xF9, 0x82, 0x70, 0xFF, 0xF9, 
/*00EDA0:*/ 0x82, 0x34, 0x82, 0xFB, 0x92, 0x35, 0x88, 0xFB, 0x8A, 0x70, 0x8A, 0xFB, 0x82, 0x59, 0x90, 0xFB, 
/*00EDB0:*/ 0x9E, 0xFD, 0x92, 0xFB, 0x8A, 0x54, 0x98, 0xFB, 0x96, 0xB8, 0x9C, 0xFB, 0x8A, 0xF9, 0x9E, 0xFB, 
/*00EDC0:*/ 0x86, 0x39, 0xA1, 0xFB, 0x82, 0x3D, 0xA1, 0xFB, 0x8E, 0xD9, 0xA4, 0xFB, 0x8A, 0xF8, 0xA4, 0xFB, 
/*00EDD0:*/ 0x82, 0x35, 0xA7, 0xFB, 0x86, 0xB0, 0xAA, 0xFB, 0x82, 0xB4, 0xAA, 0xFB, 0x86, 0x5D, 0xAC, 0xFB, 
/*00EDE0:*/ 0x92, 0xB4, 0xAD, 0xFB, 0x92, 0xB4, 0xB2, 0xFB, 0x92, 0xF4, 0xB2, 0xFB, 0x8E, 0xFD, 0xB6, 0xFB, 
/*00EDF0:*/ 0x86, 0x38, 0xB8, 0xFB, 0x96, 0x30, 0xB9, 0xFB, 0x92, 0x34, 0xB9, 0xFB, 0x9A, 0x55, 0xBA, 0xFB, 
/*00EE00:*/ 0x9A, 0xF0, 0xBA, 0xFB, 0x9E, 0x59, 0xBC, 0xFB, 0x9A, 0xD4, 0xBC, 0xFB, 0x82, 0xF4, 0xBE, 0xFB, 
/*00EE10:*/ 0x96, 0x31, 0xBF, 0xFB, 0x9E, 0x35, 0xC0, 0xFB, 0x86, 0x39, 0xC2, 0xFB, 0x82, 0x3D, 0xC2, 0xFB, 
/*00EE20:*/ 0x86, 0x71, 0xC4, 0xFB, 0x86, 0xDD, 0xC4, 0xFB, 0x8A, 0x38, 0xC7, 0xFB, 0x9E, 0x35, 0xCB, 0xFB, 
/*00EE30:*/ 0x8E, 0xF5, 0xCC, 0xFB, 0x8E, 0x3C, 0xD3, 0xFB, 0x8E, 0x7C, 0xD8, 0xFB, 0x86, 0x70, 0xDD, 0xFB, 
/*00EE40:*/ 0x82, 0x7D, 0xE1, 0xFB, 0x8E, 0xBD, 0xE2, 0xFB, 0x82, 0x34, 0xEA, 0xFB, 0x82, 0xFD, 0xEA, 0xFB, 
/*00EE50:*/ 0x8E, 0x35, 0xEF, 0xFB, 0x8A, 0x38, 0xF0, 0xFB, 0x8E, 0x50, 0xF0, 0xFB, 0x96, 0x39, 0xF2, 0xFB, 
/*00EE60:*/ 0x8E, 0x51, 0xF6, 0xFB, 0x8E, 0x7D, 0xF6, 0xFB, 0x8E, 0x35, 0xFB, 0xFB, 0x8A, 0x34, 0x80, 0xFD, 
/*00EE70:*/ 0x96, 0x35, 0x82, 0xFD, 0x96, 0x3D, 0x84, 0xFD, 0x8A, 0xF5, 0x86, 0xFD, 0x9E, 0x71, 0x8A, 0xFD, 
/*00EE80:*/ 0x86, 0xFC, 0x8E, 0xFD, 0x92, 0x31, 0x96, 0xFD, 0x96, 0x59, 0x96, 0xFD, 0x86, 0x51, 0x97, 0xFD, 
/*00EE90:*/ 0x86, 0x91, 0x97, 0xFD, 0x9A, 0x35, 0xA2, 0xFD, 0x9A, 0x7D, 0xA4, 0xFD, 0x9E, 0xF9, 0xA4, 0xFD, 
/*00EEA0:*/ 0x8A, 0x34, 0xA8, 0xFD, 0x8A, 0xF4, 0xA8, 0xFD, 0x8E, 0x78, 0xAE, 0xFD, 0x82, 0xF9, 0xB4, 0xFD, 
/*00EEB0:*/ 0x92, 0xD4, 0xBE, 0xFD, 0x8E, 0xF8, 0xD2, 0xFD, 0x9E, 0x70, 0xD8, 0xFD, 0x9A, 0xB4, 0xD8, 0xFD, 
/*00EEC0:*/ 0x8A, 0xFD, 0xE3, 0xFD, 0x8A, 0xF5, 0xE5, 0xFD, 0x86, 0x7C, 0xE6, 0xFD, 0x86, 0xF5, 0xE6, 0xFD, 
/*00EED0:*/ 0x8E, 0x70, 0xE8, 0xFD, 0x8E, 0xB0, 0xE8, 0xFD, 0x82, 0x39, 0xEB, 0xFD, 0x86, 0xB4, 0xEB, 0xFD, 
/*00EEE0:*/ 0x96, 0x74, 0xEC, 0xFD, 0x9E, 0xB0, 0xF0, 0xFD, 0x9A, 0xB4, 0xF0, 0xFD, 0x82, 0x30, 0xF4, 0xFD, 
/*00EEF0:*/ 0x82, 0x79, 0xF4, 0xFD, 0x82, 0x31, 0xF9, 0xFD, 0x8A, 0x3D, 0xFC, 0xFD, 0x96, 0x38, 0x83, 0xFF, 
/*00EF00:*/ 0x96, 0x71, 0x88, 0xFF, 0x96, 0xF1, 0x88, 0xFF, 0x8E, 0xFD, 0x8A, 0xFF, 0x8A, 0x1D, 0x93, 0xFF, 
/*00EF10:*/ 0x9E, 0x3C, 0x94, 0xFF, 0x82, 0x34, 0x96, 0xFF, 0x82, 0x99, 0x9B, 0xFF, 0x86, 0x9C, 0x9D, 0xFF, 
/*00EF20:*/ 0x8A, 0x55, 0x9E, 0xFF, 0x8A, 0xF9, 0x9E, 0xFF, 0x9E, 0x75, 0x9F, 0xFF, 0x8A, 0x55, 0xA2, 0xFF, 
/*00EF30:*/ 0x9E, 0x7D, 0xA5, 0xFF, 0x86, 0xF8, 0xAC, 0xFF, 0x8E, 0xFC, 0xB0, 0xFF, 0x8E, 0xF4, 0xB6, 0xFF, 
/*00EF40:*/ 0x9A, 0x71, 0xB7, 0xFF, 0x86, 0xF1, 0xB8, 0xFF, 0x9A, 0x39, 0xBA, 0xFF, 0x9E, 0x7D, 0xBA, 0xFF, 
/*00EF50:*/ 0x8A, 0x31, 0xBB, 0xFF, 0x8E, 0x3C, 0xBB, 0xFF, 0x8E, 0x50, 0xBB, 0xFF, 0x9A, 0x71, 0xBC, 0xFF, 
/*00EF60:*/ 0x86, 0xF0, 0xBE, 0xFF, 0x92, 0x59, 0xBF, 0xFF, 0x86, 0x30, 0xC2, 0xFF, 0x82, 0x34, 0xC2, 0xFF, 
/*00EF70:*/ 0x82, 0x7C, 0xC4, 0xFF, 0x8E, 0xFC, 0xC7, 0xFF, 0x8A, 0x30, 0xCA, 0xFF, 0x86, 0x38, 0xCF, 0xFF, 
/*00EF80:*/ 0x86, 0x5D, 0xCF, 0xFF, 0x86, 0x31, 0xD0, 0xFF, 0x9A, 0xB8, 0xD4, 0xFF, 0x9E, 0xBD, 0xD9, 0xFF, 
/*00EF90:*/ 0x96, 0x38, 0xDC, 0xFF, 0x8A, 0x30, 0xDE, 0xFF, 0x86, 0x30, 0xE1, 0xFF, 0x8A, 0x71, 0xE4, 0xFF, 
/*00EFA0:*/ 0x86, 0x38, 0xF3, 0xFF, 0x86, 0x38, 0xF8, 0xFF, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00EFB0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_5[] = {
/*00F5D8:*/ 0xD3, 0x08, 0x03, 0x01, 0xD3, 0x89, 0x16, 0x01, 
/*00F5E0:*/ 0xD3, 0x06, 0x1A, 0x01, 0xD3, 0x84, 0x1A, 0x01, 0x53, 0x84, 0x1B, 0x01, 0xD3, 0x84, 0x1C, 0x01, 
/*00F5F0:*/ 0x93, 0x86, 0x58, 0x01, 0x93, 0x82, 0x12, 0x05, 0xD3, 0x0E, 0x1B, 0x05, 0x53, 0x8C, 0x1C, 0x05, 
/*00F600:*/ 0x93, 0x02, 0x42, 0x05, 0x53, 0x8E, 0x4C, 0x05, 0x13, 0x0C, 0x5A, 0x05, 0xD3, 0x88, 0x02, 0x09, 
/*00F610:*/ 0x53, 0x07, 0x07, 0x09, 0x93, 0x09, 0x07, 0x09, 0xD3, 0x85, 0x0C, 0x09, 0xD3, 0x8B, 0x17, 0x09, 
/*00F620:*/ 0x93, 0x0A, 0x1A, 0x09, 0xD3, 0x84, 0x45, 0x09, 0x13, 0x05, 0x47, 0x09, 0x13, 0x84, 0x52, 0x09, 
/*00F630:*/ 0x13, 0x84, 0x58, 0x09, 0xD3, 0x08, 0x5A, 0x09, 0x13, 0x01, 0x01, 0x0D, 0x53, 0x0F, 0x04, 0x0D, 
/*00F640:*/ 0x13, 0x0C, 0x07, 0x0D, 0xD3, 0x81, 0x44, 0x0D, 0x93, 0x00, 0x45, 0x0D, 0x13, 0x82, 0x4A, 0x0D, 
/*00F650:*/ 0x13, 0x03, 0x57, 0x0D, 0xD3, 0x00, 0x03, 0x11, 0x53, 0x82, 0x06, 0x11, 0x93, 0x8C, 0x06, 0x11, 
/*00F660:*/ 0xD3, 0x8F, 0x07, 0x11, 0xD3, 0x00, 0x0B, 0x11, 0x13, 0xCB, 0x0B, 0x11, 0xD3, 0x0F, 0x57, 0x11, 
/*00F670:*/ 0x13, 0x83, 0x57, 0x11, 0x93, 0x8A, 0x12, 0x15, 0x53, 0x86, 0x4C, 0x15, 0xD3, 0x88, 0x5A, 0x15, 
/*00F680:*/ 0xD3, 0x0A, 0x5C, 0x15, 0xD3, 0x80, 0x02, 0x19, 0x13, 0x4B, 0x0E, 0x19, 0x53, 0x83, 0x16, 0x19, 
/*00F690:*/ 0xD3, 0x83, 0x17, 0x19, 0x13, 0x8D, 0x17, 0x19, 0xD3, 0x8C, 0x45, 0x19, 0xD3, 0x81, 0x47, 0x19, 
/*00F6A0:*/ 0xD3, 0x0E, 0x4B, 0x19, 0x13, 0x82, 0x4B, 0x19, 0x93, 0x8C, 0x53, 0x19, 0x13, 0x0E, 0x58, 0x19, 
/*00F6B0:*/ 0x13, 0x8C, 0x58, 0x19, 0x53, 0x82, 0x5D, 0x19, 0x93, 0x08, 0x45, 0x1D, 0x93, 0x06, 0x56, 0x1D, 
/*00F6C0:*/ 0x53, 0x08, 0x5A, 0x1D, 0xD3, 0x8D, 0x4F, 0x21, 0x53, 0x0C, 0x5F, 0x21, 0x93, 0x08, 0x04, 0x25, 
/*00F6D0:*/ 0x13, 0x89, 0x12, 0x25, 0xD3, 0x09, 0x5F, 0x25, 0xD3, 0x86, 0x5F, 0x25, 0xD3, 0x0E, 0x57, 0x29, 
/*00F6E0:*/ 0xD3, 0x0E, 0x5F, 0x29, 0x53, 0x88, 0x1E, 0x2D, 0x93, 0x06, 0x46, 0x2D, 0x93, 0x06, 0x4A, 0x2D, 
/*00F6F0:*/ 0x93, 0x84, 0x4E, 0x2D, 0x53, 0x8A, 0x4E, 0x2D, 0xD3, 0x09, 0x58, 0x31, 0xD3, 0x00, 0x1E, 0x35, 
/*00F700:*/ 0xD3, 0x02, 0x4E, 0x35, 0xD3, 0x0F, 0x4E, 0x35, 0x53, 0x02, 0x1E, 0x3D, 0x13, 0x0C, 0x1F, 0x3D, 
/*00F710:*/ 0x93, 0x8C, 0x46, 0x3D, 0x53, 0x82, 0x4E, 0x3D, 0xD3, 0x08, 0x0D, 0x41, 0xD3, 0x87, 0x0D, 0x41, 
/*00F720:*/ 0x13, 0x08, 0x10, 0x41, 0xD3, 0x06, 0x12, 0x41, 0x93, 0x08, 0x1F, 0x41, 0xD3, 0x09, 0x40, 0x41, 
/*00F730:*/ 0xD3, 0x04, 0x46, 0x41, 0xD3, 0x0D, 0x0E, 0x45, 0x93, 0x8F, 0x12, 0x45, 0x93, 0x8D, 0x4E, 0x45, 
/*00F740:*/ 0xD3, 0x02, 0x5C, 0x45, 0x13, 0x04, 0x0A, 0x49, 0x93, 0x88, 0x1A, 0x49, 0x93, 0x8A, 0x42, 0x49, 
/*00F750:*/ 0x13, 0x08, 0x43, 0x49, 0x93, 0x84, 0x53, 0x49, 0x53, 0x08, 0x5B, 0x49, 0x53, 0x08, 0x5D, 0x49, 
/*00F760:*/ 0xD3, 0x8C, 0x4A, 0x4D, 0x93, 0x0E, 0x54, 0x4D, 0x93, 0x0E, 0x5E, 0x4D, 0x93, 0x0E, 0x04, 0x51, 
/*00F770:*/ 0xD3, 0x0E, 0x12, 0x51, 0xD3, 0x0E, 0x16, 0x51, 0x93, 0x02, 0x43, 0x51, 0xD3, 0x08, 0x02, 0x55, 
/*00F780:*/ 0x13, 0x84, 0x04, 0x55, 0xD3, 0x06, 0x15, 0x55, 0x93, 0x0A, 0x4C, 0x55, 0x53, 0x04, 0x4E, 0x55, 
/*00F790:*/ 0x93, 0x88, 0x4E, 0x55, 0xD3, 0x0A, 0x54, 0x55, 0x53, 0x88, 0x55, 0x55, 0x13, 0x86, 0x56, 0x55, 
/*00F7A0:*/ 0x13, 0x04, 0x5E, 0x55, 0x93, 0x04, 0x5F, 0x55, 0x13, 0x01, 0x00, 0x59, 0x53, 0x02, 0x0B, 0x59, 
/*00F7B0:*/ 0x13, 0x0C, 0x0C, 0x59, 0x53, 0x01, 0x14, 0x59, 0x13, 0x8C, 0x52, 0x59, 0x53, 0x00, 0x53, 0x59, 
/*00F7C0:*/ 0x93, 0x8C, 0x55, 0x59, 0x93, 0x09, 0x02, 0x5D, 0x53, 0x0A, 0x02, 0x5D, 0x53, 0x85, 0x02, 0x5D, 
/*00F7D0:*/ 0x93, 0x04, 0x04, 0x5D, 0x93, 0x04, 0x0C, 0x5D, 0x93, 0x07, 0x13, 0x5D, 0x13, 0x06, 0x5F, 0x5D, 
/*00F7E0:*/ 0x93, 0x0D, 0x0F, 0x61, 0x93, 0x03, 0x1E, 0x61, 0xD3, 0x8D, 0x4F, 0x61, 0x13, 0x8D, 0x52, 0x61, 
/*00F7F0:*/ 0x13, 0x07, 0x0E, 0x6D, 0xD3, 0x8A, 0x49, 0x6D, 0x53, 0x08, 0x4E, 0x6D, 0x53, 0x84, 0x0F, 0x71, 
/*00F800:*/ 0x13, 0x8B, 0x4F, 0x71, 0x93, 0x0C, 0x4F, 0x75, 0xD3, 0x8E, 0x53, 0x75, 0x13, 0x09, 0x1E, 0x79, 
/*00F810:*/ 0x53, 0x05, 0x4F, 0x79, 0x13, 0x87, 0x5F, 0x79, 0x13, 0x0F, 0x0E, 0x7D, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00F820:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00F830:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_6[] = {
/*0048:*/ 0x04, 0x0C, 0xFA, 0x00, 0x0C, 0x00, 0x7C, 0x04, 
/*0050:*/ 0x8C, 0x0C, 0xFC, 0x05, 0x0C, 0x08, 0x7C, 0x06, 0x8C, 0x19, 0x7E, 0x07, 0x04, 0x08, 0x7B, 0x08, 
/*0060:*/ 0x0C, 0x10, 0x7C, 0x09, 0x8C, 0x14, 0x7C, 0x09, 0x0C, 0x18, 0x7E, 0x0B, 0x8C, 0x05, 0xFC, 0x0B, 
/*0070:*/ 0x0C, 0x04, 0xFB, 0x0C, 0x8C, 0x11, 0x7B, 0x0E, 0x0C, 0x04, 0x7B, 0x0F, 0x0C, 0x05, 0x78, 0x10, 
/*0080:*/ 0x04, 0x08, 0x7B, 0x10, 0x0C, 0x0D, 0x78, 0x12, 0x8C, 0x14, 0xFC, 0x12, 0x0C, 0x14, 0xFB, 0x19, 
/*0090:*/ 0x0C, 0x08, 0xFC, 0x1D, 0x8C, 0x08, 0x78, 0x1E, 0x0C, 0x08, 0x7C, 0x1E, 0x0C, 0x0C, 0x7E, 0x1E, 
/*00A0:*/ 0x84, 0x18, 0xFB, 0x1E, 0x8C, 0x04, 0xFC, 0x1F, 0x0C, 0x04, 0xFE, 0x1F, 0x8C, 0x08, 0x7A, 0x20, 
/*00B0:*/ 0x8C, 0x1D, 0x78, 0x21, 0x0C, 0x00, 0xFE, 0x21, 0x0C, 0x04, 0x7E, 0x22, 0x04, 0x10, 0xFD, 0x22, 
/*00C0:*/ 0x8C, 0x11, 0x7A, 0x23, 0x04, 0x04, 0xFC, 0x24, 0x0C, 0x1C, 0x7B, 0x26, 0x04, 0x0D, 0x78, 0x29, 
/*00D0:*/ 0x8C, 0x1C, 0x7C, 0x2D, 0x0C, 0x01, 0x7E, 0x2E, 0x0C, 0x18, 0xFE, 0x2E, 0x84, 0x01, 0x7A, 0x33, 
/*00E0:*/ 0x84, 0x09, 0xF9, 0x39, 0x0C, 0x04, 0x7E, 0x3A, 0x04, 0x0C, 0xF8, 0x3E, 0x0C, 0x09, 0x7F, 0x42, 
/*00F0:*/ 0x84, 0x09, 0xFB, 0x44, 0x8C, 0x01, 0xFE, 0x48, 0x8C, 0x0D, 0x7C, 0x49, 0x84, 0x08, 0x7B, 0x4B, 
/*0100:*/ 0x8C, 0x1C, 0xFE, 0x4B, 0x04, 0x05, 0x78, 0x4E, 0x04, 0x05, 0x7C, 0x4E, 0x0C, 0x11, 0xFB, 0x56, 
/*0110:*/ 0x0C, 0x1C, 0xFB, 0x58, 0x04, 0x04, 0xFA, 0x59, 0x8C, 0x08, 0x7E, 0x5D, 0x8C, 0x15, 0xFC, 0x5D, 
/*0120:*/ 0x0C, 0x0C, 0xFA, 0x60, 0x0C, 0x00, 0x7C, 0x61, 0x0C, 0x00, 0xFC, 0x62, 0x04, 0x1D, 0x78, 0x67, 
/*0130:*/ 0x0C, 0x18, 0xFE, 0x6D, 0x04, 0x1C, 0xFA, 0x70, 0x84, 0x0D, 0xFE, 0x71, 0x84, 0x18, 0x78, 0x73, 
/*0140:*/ 0x8C, 0x01, 0x7E, 0x75, 0x0C, 0x04, 0x78, 0x79, 0x0C, 0x04, 0xF8, 0x7A, 0x0C, 0x00, 0xFC, 0x7A, 
/*0150:*/ 0x8C, 0x11, 0xFA, 0x7B, 0x84, 0x1C, 0xFF, 0x7B, 0x0C, 0x1D, 0x7A, 0x83, 0x04, 0x08, 0xF8, 0x84, 
/*0160:*/ 0x84, 0x1D, 0xFC, 0x85, 0x0C, 0x1C, 0xF8, 0x8C, 0x8C, 0x10, 0x78, 0x8D, 0x8C, 0x0D, 0x78, 0x8E, 
/*0170:*/ 0x0C, 0x10, 0xFE, 0x8E, 0x0C, 0x05, 0xFC, 0x8F, 0x0C, 0x05, 0x7C, 0x94, 0x0C, 0x05, 0x7E, 0x94, 
/*0180:*/ 0x8C, 0x0D, 0x78, 0x96, 0x8C, 0x1C, 0x7A, 0x97, 0x0C, 0x05, 0xFC, 0x97, 0x8C, 0x08, 0xF8, 0x99, 
/*0190:*/ 0x0C, 0x0C, 0xFE, 0x99, 0x04, 0x0C, 0xFA, 0xA2, 0x8C, 0x04, 0xFA, 0xA5, 0x0C, 0x15, 0x78, 0xA7, 
/*01A0:*/ 0x0C, 0x0D, 0x7A, 0xA8, 0x8C, 0x14, 0xFA, 0xA8, 0x8C, 0x14, 0xFC, 0xA8, 0x8C, 0x01, 0xF8, 0xA9, 
/*01B0:*/ 0x8C, 0x01, 0xFA, 0xA9, 0x8C, 0x10, 0x7A, 0xAB, 0x84, 0x0D, 0xFE, 0xAE, 0x0C, 0x14, 0xFE, 0xB0, 
/*01C0:*/ 0x0C, 0x0D, 0xF8, 0xB3, 0x04, 0x14, 0x7C, 0xB6, 0x84, 0x15, 0x7C, 0xBA, 0x8C, 0x10, 0xFB, 0xBB, 
/*01D0:*/ 0x8C, 0x04, 0xFC, 0xBD, 0x8C, 0x1D, 0xF8, 0xBE, 0x8C, 0x19, 0xFE, 0xBE, 0x84, 0x18, 0xFB, 0xC1, 
/*01E0:*/ 0x8C, 0x0C, 0xFE, 0xC2, 0x0C, 0x1D, 0xFA, 0xC3, 0x0C, 0x19, 0xFE, 0xC3, 0x84, 0x0C, 0x78, 0xC4, 
/*01F0:*/ 0x0C, 0x01, 0x7F, 0xC4, 0x04, 0x19, 0xF8, 0xC6, 0x8C, 0x05, 0xF9, 0xC7, 0x0C, 0x10, 0xFC, 0xCD, 
/*0200:*/ 0x0C, 0x10, 0x7E, 0xCE, 0x04, 0x09, 0x78, 0xD0, 0x8C, 0x0D, 0x7A, 0xD5, 0x0C, 0x10, 0xFC, 0xD5, 
/*0210:*/ 0x0C, 0x14, 0xFE, 0xD5, 0x8C, 0x18, 0xFE, 0xD7, 0x8C, 0x1D, 0x7A, 0xD8, 0x8C, 0x0C, 0x7A, 0xD9, 
/*0220:*/ 0x0C, 0x08, 0x7E, 0xD9, 0x0C, 0x15, 0xF8, 0xD9, 0x0C, 0x1D, 0xFA, 0xDB, 0x0C, 0x09, 0xFB, 0xDD, 
/*0230:*/ 0x0C, 0x0D, 0xFB, 0xDD, 0x0C, 0x1C, 0x7B, 0xE1, 0x84, 0x15, 0x7C, 0xE1, 0x84, 0x0C, 0xFC, 0xE1, 
/*0240:*/ 0x04, 0x15, 0xF8, 0xE2, 0x0C, 0x18, 0xFB, 0xE2, 0x8C, 0x11, 0x7A, 0xE4, 0x0C, 0x05, 0x7E, 0xE9, 
/*0250:*/ 0x0C, 0x18, 0x7E, 0xEA, 0x0C, 0x10, 0xFC, 0xEB, 0x0C, 0x14, 0x7A, 0xF0, 0x04, 0x15, 0x78, 0xF9, 
/*0260:*/ 0x0C, 0x1C, 0x7B, 0xF9, 0x04, 0x08, 0x78, 0xFA, 0x8C, 0x04, 0xFE, 0xFE, 0x8C, 0x0C, 0x78, 0xFF, 
/*0270:*/ 0x8C, 0x15, 0xFC, 0xFF, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*0280:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_7[] = {
/*0720:*/ 0x36, 0x54, 0x3A, 0x90, 0x32, 0x3E, 0x3E, 0x92, 0x3C, 0xA4, 0x34, 0xA0, 0x38, 0x54, 0x35, 0xA0, 
/*0730:*/ 0x34, 0x9E, 0x38, 0xA0, 0x38, 0xBE, 0x38, 0xA0, 0x38, 0xBE, 0x3D, 0xA0, 0x3C, 0xA4, 0x3E, 0xA0, 
/*0740:*/ 0x32, 0x94, 0x30, 0xA1, 0x3C, 0x3C, 0x35, 0xA1, 0x30, 0xF6, 0x35, 0xA1, 0x3E, 0xAC, 0x38, 0xA1, 
/*0750:*/ 0x30, 0xEE, 0x3B, 0xA1, 0x36, 0x64, 0x3C, 0xA1, 0x32, 0x7E, 0x3C, 0xA1, 0x38, 0xCC, 0x3E, 0xA1, 
/*0760:*/ 0x38, 0x26, 0x3F, 0xA1, 0x38, 0xCC, 0x3F, 0xA1, 0x34, 0x04, 0x30, 0xA2, 0x3E, 0x5C, 0x30, 0xA2, 
/*0770:*/ 0x3A, 0x5E, 0x30, 0xA2, 0x36, 0x7E, 0x30, 0xA2, 0x30, 0xF4, 0x31, 0xA2, 0x38, 0x3C, 0x33, 0xA2, 
/*0780:*/ 0x3C, 0xD4, 0x33, 0xA2, 0x30, 0xEC, 0x33, 0xA2, 0x30, 0xF4, 0x33, 0xA2, 0x32, 0x8E, 0x36, 0xA2, 
/*0790:*/ 0x3E, 0xAE, 0x36, 0xA2, 0x36, 0x7E, 0x39, 0xA2, 0x3A, 0xB4, 0x39, 0xA2, 0x38, 0xD6, 0x3F, 0xA2, 
/*07A0:*/ 0x34, 0xF6, 0x3F, 0xA2, 0x3E, 0x2E, 0x30, 0xA3, 0x3E, 0x36, 0x30, 0xA3, 0x32, 0xE4, 0x33, 0xA3, 
/*07B0:*/ 0x32, 0xFC, 0x35, 0xA3, 0x38, 0x4E, 0x3B, 0xA3, 0x30, 0x9E, 0x3B, 0xA3, 0x38, 0xBC, 0x3B, 0xA3, 
/*07C0:*/ 0x3E, 0xDC, 0x3D, 0xA3, 0x3E, 0x2E, 0x3E, 0xA3, 0x30, 0x6C, 0x3E, 0xA3, 0x32, 0xE4, 0x3E, 0xA3, 
/*07D0:*/ 0x3C, 0x54, 0x3F, 0xA3, 0x3A, 0xDE, 0x3F, 0xA3, 0x30, 0x5E, 0x3A, 0xA8, 0x36, 0xCC, 0x3A, 0xA8, 
/*07E0:*/ 0x32, 0xD6, 0x3A, 0xA8, 0x3E, 0xF6, 0x3A, 0xA8, 0x30, 0x46, 0x3E, 0xA8, 0x3A, 0x86, 0x39, 0xA9, 
/*07F0:*/ 0x38, 0x16, 0x3B, 0xA9, 0x32, 0xA6, 0x36, 0xAA, 0x36, 0x56, 0x38, 0xAA, 0x3A, 0x9C, 0x38, 0xAA, 
/*0800:*/ 0x3E, 0x9E, 0x3A, 0xAA, 0x36, 0xA4, 0x3A, 0xAA, 0x38, 0x14, 0x3B, 0xAA, 0x3E, 0xF4, 0x38, 0xAB, 
/*0810:*/ 0x36, 0xD6, 0x3A, 0xAB, 0x38, 0x7E, 0x3D, 0xAB, 0x36, 0x46, 0x31, 0xB0, 0x32, 0x5C, 0x31, 0xB0, 
/*0820:*/ 0x36, 0xAC, 0x31, 0xB0, 0x3E, 0x7C, 0x32, 0xB0, 0x34, 0x3C, 0x35, 0xB0, 0x38, 0xF6, 0x36, 0xB0, 
/*0830:*/ 0x32, 0x2E, 0x32, 0xB1, 0x36, 0xC6, 0x32, 0xB1, 0x3A, 0x0C, 0x38, 0xB1, 0x38, 0x84, 0x3D, 0xB1, 
/*0840:*/ 0x38, 0x9C, 0x3D, 0xB1, 0x34, 0x54, 0x30, 0xB2, 0x30, 0xA4, 0x30, 0xB2, 0x36, 0xDC, 0x32, 0xB2, 
/*0850:*/ 0x36, 0x2E, 0x35, 0xB2, 0x30, 0xBC, 0x3D, 0xB2, 0x32, 0xB4, 0x33, 0xB3, 0x34, 0xCC, 0x34, 0xB3, 
/*0860:*/ 0x32, 0x46, 0x38, 0xB3, 0x3E, 0x94, 0x3B, 0xB3, 0x38, 0xF4, 0x3B, 0xB3, 0x38, 0x06, 0x3E, 0xB3, 
/*0870:*/ 0x3E, 0x54, 0x3B, 0xB8, 0x30, 0x8E, 0x33, 0xB9, 0x38, 0xB4, 0x35, 0xB9, 0x3E, 0x24, 0x3B, 0xBA, 
/*0880:*/ 0x3E, 0x3C, 0x3B, 0xBA, 0x32, 0x6E, 0x3B, 0xBB, 0x3E, 0x24, 0x39, 0xD1, 0x3E, 0x26, 0x3A, 0xD2, 
/*0890:*/ 0x36, 0xDC, 0x31, 0xE0, 0x3C, 0x9C, 0x32, 0xE0, 0x34, 0x4C, 0x33, 0xE0, 0x3C, 0x6E, 0x35, 0xE0, 
/*08A0:*/ 0x32, 0x2C, 0x36, 0xE0, 0x32, 0x34, 0x36, 0xE0, 0x3E, 0x14, 0x39, 0xE0, 0x30, 0x4E, 0x39, 0xE0, 
/*08B0:*/ 0x30, 0x56, 0x39, 0xE0, 0x3C, 0x6E, 0x39, 0xE0, 0x30, 0xA4, 0x39, 0xE0, 0x36, 0xDC, 0x39, 0xE0, 
/*08C0:*/ 0x34, 0x54, 0x3B, 0xE0, 0x38, 0x9E, 0x3B, 0xE0, 0x3A, 0x0E, 0x3C, 0xE0, 0x3E, 0x14, 0x3C, 0xE0, 
/*08D0:*/ 0x3A, 0x0E, 0x3E, 0xE0, 0x3E, 0x14, 0x3E, 0xE0, 0x34, 0xA6, 0x3E, 0xE0, 0x3E, 0xE6, 0x3F, 0xE0, 
/*08E0:*/ 0x3A, 0xFC, 0x3F, 0xE0, 0x3A, 0x96, 0x30, 0xE1, 0x38, 0xF4, 0x30, 0xE1, 0x3E, 0x7E, 0x31, 0xE1, 
/*08F0:*/ 0x38, 0xF4, 0x31, 0xE1, 0x3C, 0xEE, 0x32, 0xE1, 0x3C, 0xF6, 0x33, 0xE1, 0x3E, 0x8C, 0x39, 0xE1, 
/*0900:*/ 0x30, 0x24, 0x3E, 0xE1, 0x30, 0x3C, 0x3E, 0xE1, 0x3C, 0xEE, 0x3E, 0xE1, 0x3E, 0x8E, 0x31, 0xE2, 
/*0910:*/ 0x30, 0xCC, 0x32, 0xE2, 0x3E, 0x7C, 0x38, 0xE2, 0x32, 0xAE, 0x39, 0xE2, 0x34, 0xD6, 0x39, 0xE2, 
/*0920:*/ 0x38, 0xEE, 0x3B, 0xE2, 0x3C, 0xF4, 0x3B, 0xE2, 0x32, 0x44, 0x3C, 0xE2, 0x38, 0xEE, 0x3C, 0xE2, 
/*0930:*/ 0x38, 0xF6, 0x3C, 0xE2, 0x3E, 0x7C, 0x3D, 0xE2, 0x36, 0xAC, 0x3E, 0xE2, 0x3E, 0xE4, 0x32, 0xE3, 
/*0940:*/ 0x36, 0xC6, 0x33, 0xE3, 0x36, 0xDE, 0x33, 0xE3, 0x36, 0xC6, 0x36, 0xE3, 0x38, 0x6E, 0x38, 0xE3, 
/*0950:*/ 0x30, 0xA6, 0x38, 0xE3, 0x3A, 0xE6, 0x3D, 0xE3, 0x32, 0x2E, 0x3E, 0xE3, 0x38, 0x84, 0x3F, 0xE3, 
/*0960:*/ 0x36, 0x06, 0x39, 0xE8, 0x38, 0xDC, 0x3A, 0xE9, 0x34, 0x0C, 0x30, 0xEA, 0x3E, 0xA6, 0x38, 0xEA, 
/*0970:*/ 0x3A, 0x4E, 0x3A, 0xEA, 0x30, 0x0E, 0x3B, 0xEA, 0x38, 0x34, 0x3B, 0xEA, 0x30, 0x64, 0x3A, 0xEB, 
/*0980:*/ 0x36, 0x7E, 0x31, 0xF0, 0x3A, 0x5E, 0x32, 0xF0, 0x3A, 0xC6, 0x32, 0xF1, 0x3E, 0xDC, 0x32, 0xF1, 
/*0990:*/ 0x32, 0xFC, 0x35, 0xF1, 0x36, 0xFC, 0x32, 0xF2, 0x32, 0x14, 0x38, 0xF2, 0x3E, 0x34, 0x3D, 0xF2, 
/*09A0:*/ 0x3E, 0x5E, 0x32, 0xF3, 0x36, 0x64, 0x32, 0xF3, 0x32, 0x7E, 0x38, 0xF3, 0x36, 0x96, 0x38, 0xF3, 
/*09B0:*/ 0x3C, 0x16, 0x36, 0xF8, 0x30, 0xDC, 0x37, 0xF8, 0x3A, 0x76, 0x3B, 0xF8, 0x30, 0xC4, 0x3B, 0xF8, 
/*09C0:*/ 0x3A, 0xF4, 0x3B, 0xFA, 0x3E, 0xF6, 0x3B, 0xFA, 0x3A, 0x06, 0x3D, 0xFA, 0x3E, 0x84, 0x36, 0xFB, 
/*09D0:*/ 0x3A, 0x9E, 0x3D, 0xFB, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*09E0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_8[] = {
/*0FA8:*/ 0x1F, 0x06, 0x86, 0x0D, 0xAB, 0x05, 0xA6, 0x0D, 
/*0FB0:*/ 0x88, 0x06, 0xA6, 0x0D, 0x2E, 0x06, 0x86, 0x0F, 0x94, 0x06, 0xA4, 0x0F, 0x6E, 0x07, 0xA6, 0x0F, 
/*0FC0:*/ 0x25, 0x07, 0x80, 0x1D, 0x7C, 0x06, 0x82, 0x1D, 0x88, 0x04, 0x84, 0x1D, 0x72, 0x05, 0x86, 0x1D, 
/*0FD0:*/ 0xE4, 0x05, 0x86, 0x1D, 0xBC, 0x04, 0xA4, 0x1D, 0xD8, 0x05, 0xA4, 0x1D, 0xAC, 0x04, 0xA6, 0x1D, 
/*0FE0:*/ 0x9A, 0x07, 0x86, 0x1F, 0xDC, 0x05, 0xA2, 0x1F, 0x79, 0x06, 0xA4, 0x1F, 0x1B, 0x04, 0xA6, 0x1F, 
/*0FF0:*/ 0x3D, 0x06, 0xA4, 0x2D, 0xF4, 0x04, 0xA6, 0x2D, 0x15, 0x06, 0x84, 0x2F, 0xA1, 0x05, 0xA2, 0x2F, 
/*1000:*/ 0x14, 0x06, 0xA4, 0x2F, 0x74, 0x05, 0x84, 0x3D, 0xF4, 0x06, 0x84, 0x3D, 0x24, 0x04, 0xA2, 0x3D, 
/*1010:*/ 0xD8, 0x06, 0xA2, 0x3D, 0x55, 0x05, 0x80, 0x3F, 0xC5, 0x06, 0x80, 0x3F, 0xDD, 0x06, 0x82, 0x3F, 
/*1020:*/ 0xF8, 0x06, 0x82, 0x3F, 0xE0, 0x06, 0x84, 0x3F, 0x29, 0x04, 0x86, 0x3F, 0xB7, 0x04, 0x86, 0x3F, 
/*1030:*/ 0xE0, 0x06, 0x86, 0x3F, 0x20, 0x04, 0xA2, 0x3F, 0xC4, 0x06, 0xA4, 0x3F, 0x44, 0x05, 0xA6, 0x3F, 
/*1040:*/ 0x7C, 0x07, 0x86, 0x45, 0x21, 0x07, 0x80, 0x4D, 0x39, 0x07, 0x80, 0x4D, 0x94, 0x04, 0x84, 0x4D, 
/*1050:*/ 0x39, 0x07, 0x84, 0x4D, 0x1A, 0x04, 0x86, 0x4D, 0x31, 0x07, 0x86, 0x4D, 0xFC, 0x05, 0x84, 0x4F, 
/*1060:*/ 0x51, 0x06, 0x84, 0x4F, 0x4E, 0x05, 0xA0, 0x4F, 0x44, 0x04, 0x80, 0x5D, 0xC5, 0x07, 0xA0, 0x5D, 
/*1070:*/ 0xE8, 0x07, 0xA2, 0x5D, 0x60, 0x04, 0xA4, 0x5D, 0xD0, 0x07, 0x86, 0x5F, 0x8D, 0x07, 0xA0, 0x6D, 
/*1080:*/ 0xA0, 0x07, 0xA0, 0x6D, 0x49, 0x05, 0x82, 0x6F, 0x95, 0x05, 0x82, 0x7D, 0x30, 0x06, 0x82, 0x7D, 
/*1090:*/ 0x0D, 0x06, 0x84, 0x7D, 0x8D, 0x05, 0x86, 0x7D, 0xE0, 0x04, 0xA2, 0x7D, 0x70, 0x07, 0xA2, 0x7D, 
/*10A0:*/ 0xA1, 0x05, 0xA4, 0x7D, 0xA1, 0x05, 0xA6, 0x7D, 0x14, 0x06, 0xA6, 0x7D, 0x1C, 0x06, 0xA6, 0x7D, 
/*10B0:*/ 0x34, 0x06, 0x82, 0x7F, 0x48, 0x07, 0x82, 0x7F, 0xD0, 0x04, 0x86, 0x7F, 0xB4, 0x05, 0x86, 0x7F, 
/*10C0:*/ 0x35, 0x06, 0xA2, 0x7F, 0x35, 0x06, 0xA4, 0x7F, 0xC9, 0x04, 0xA6, 0x7F, 0x25, 0x06, 0xA6, 0x7F, 
/*10D0:*/ 0xDF, 0x05, 0xA2, 0x8D, 0x51, 0x05, 0xA4, 0x8D, 0xA8, 0x07, 0x84, 0x8F, 0x84, 0x07, 0xA2, 0x8F, 
/*10E0:*/ 0x94, 0x07, 0xA4, 0x8F, 0x3D, 0x06, 0x80, 0x9D, 0xF4, 0x04, 0x84, 0x9D, 0xC9, 0x04, 0x86, 0x9D, 
/*10F0:*/ 0xBC, 0x05, 0xA2, 0x9D, 0x11, 0x06, 0xA2, 0x9D, 0xC0, 0x04, 0xA4, 0x9D, 0x39, 0x06, 0x80, 0x9F, 
/*1100:*/ 0xCD, 0x04, 0x82, 0x9F, 0xE0, 0x04, 0x82, 0x9F, 0x8C, 0x05, 0x84, 0x9F, 0xB1, 0x05, 0x84, 0x9F, 
/*1110:*/ 0x21, 0x06, 0x86, 0x9F, 0xB8, 0x05, 0xA2, 0x9F, 0x54, 0x07, 0xA4, 0x9F, 0xAC, 0x04, 0x84, 0xAD, 
/*1120:*/ 0xC6, 0x06, 0x86, 0xAD, 0x85, 0x04, 0x80, 0xAF, 0x4A, 0x05, 0x80, 0xAF, 0x95, 0x04, 0x84, 0xAF, 
/*1130:*/ 0xB0, 0x04, 0x86, 0xAF, 0xCA, 0x06, 0x86, 0xAF, 0x00, 0x05, 0x84, 0xBD, 0xD6, 0x04, 0xA6, 0xBD, 
/*1140:*/ 0xDE, 0x04, 0xA6, 0xBD, 0x39, 0x05, 0x80, 0xBF, 0xB7, 0x05, 0x80, 0xBF, 0xA1, 0x06, 0x80, 0xBF, 
/*1150:*/ 0x70, 0x04, 0x82, 0xBF, 0xB1, 0x06, 0x84, 0xBF, 0x85, 0x06, 0xA0, 0xBF, 0x4A, 0x07, 0xA0, 0xBF, 
/*1160:*/ 0xDA, 0x04, 0xA6, 0xBF, 0xA0, 0x06, 0xA6, 0xBF, 0x4A, 0x04, 0xA0, 0xCD, 0xD4, 0x04, 0xA4, 0xCD, 
/*1170:*/ 0xA8, 0x05, 0xA4, 0xCD, 0xD1, 0x04, 0x86, 0xCF, 0xE5, 0x04, 0xA0, 0xCF, 0x44, 0x05, 0x80, 0xDD, 
/*1180:*/ 0xB8, 0x07, 0x82, 0xDD, 0x36, 0x07, 0x86, 0xDD, 0x8D, 0x07, 0x86, 0xDD, 0x31, 0x04, 0xA2, 0xDD, 
/*1190:*/ 0x78, 0x05, 0xA4, 0xDD, 0x0C, 0x04, 0xA6, 0xDD, 0x29, 0x04, 0xA6, 0xDD, 0x4B, 0x06, 0xA6, 0xDD, 
/*11A0:*/ 0xBC, 0x07, 0x82, 0xDF, 0x7D, 0x05, 0x84, 0xDF, 0x32, 0x07, 0x86, 0xDF, 0x90, 0x07, 0xA2, 0xDF, 
/*11B0:*/ 0x00, 0x04, 0xA4, 0xDF, 0x08, 0x04, 0xA6, 0xDF, 0xDF, 0x05, 0xA6, 0xDF, 0xB8, 0x07, 0xA6, 0xE7, 
/*11C0:*/ 0x95, 0x06, 0xA4, 0xED, 0x10, 0x05, 0x80, 0xEF, 0x34, 0x05, 0xA6, 0xEF, 0x20, 0x07, 0x80, 0xFD, 
/*11D0:*/ 0xA0, 0x04, 0x84, 0xFD, 0x4A, 0x05, 0x86, 0xFD, 0x78, 0x06, 0xA2, 0xFD, 0x3F, 0x04, 0xA6, 0xFD, 
/*11E0:*/ 0xFD, 0x05, 0x80, 0xFF, 0xF5, 0x05, 0x82, 0xFF, 0xC6, 0x06, 0x84, 0xFF, 0xD6, 0x06, 0x86, 0xFF, 
/*11F0:*/ 0xEC, 0x05, 0xA2, 0xFF, 0x7C, 0x06, 0xA4, 0xFF, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*1200:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_9[] = {
/*16E0:*/ 0x63, 0x20, 0x39, 0x04, 0x43, 0x64, 0x58, 0x04, 0x42, 0x60, 0x78, 0x04, 0x40, 0x68, 0x98, 0x04, 
/*16F0:*/ 0x41, 0x6C, 0xB8, 0x04, 0x43, 0xE8, 0xD8, 0x04, 0x60, 0x20, 0xD9, 0x04, 0x61, 0x24, 0xF9, 0x04, 
/*1700:*/ 0x61, 0x2C, 0x19, 0x05, 0x60, 0x34, 0x78, 0x05, 0x63, 0xB4, 0x98, 0x05, 0x40, 0x70, 0xB9, 0x05, 
/*1710:*/ 0x40, 0xB4, 0xD8, 0x05, 0x40, 0x6C, 0xF8, 0x05, 0x42, 0x78, 0xF9, 0x05, 0x40, 0x24, 0xF8, 0x09, 
/*1720:*/ 0x60, 0x20, 0xB9, 0x20, 0x40, 0xF4, 0xB9, 0x20, 0x61, 0x34, 0xF8, 0x20, 0x40, 0x30, 0x39, 0x23, 
/*1730:*/ 0x60, 0xE8, 0x38, 0x24, 0x41, 0xE0, 0x98, 0x24, 0x42, 0xA8, 0x99, 0x24, 0x42, 0xFC, 0x99, 0x24, 
/*1740:*/ 0x62, 0x24, 0xB9, 0x24, 0x42, 0xF0, 0xB9, 0x24, 0x62, 0xE4, 0x18, 0x25, 0x61, 0xF4, 0x99, 0x25, 
/*1750:*/ 0x62, 0xE4, 0xB8, 0x25, 0x60, 0x34, 0xD8, 0x25, 0x60, 0xEC, 0xF8, 0x25, 0x62, 0xF8, 0xF9, 0x25, 
/*1760:*/ 0x42, 0x60, 0x39, 0x28, 0x61, 0xE0, 0x79, 0x28, 0x41, 0xA4, 0xB8, 0x28, 0x41, 0xF4, 0x78, 0x29, 
/*1770:*/ 0x41, 0xBC, 0x99, 0x29, 0x41, 0x7C, 0x58, 0x2C, 0x60, 0xE4, 0x99, 0x2C, 0x42, 0xEC, 0xD9, 0x2C, 
/*1780:*/ 0x42, 0x30, 0x39, 0x2D, 0x42, 0x74, 0x58, 0x2D, 0x43, 0x70, 0x78, 0x2D, 0x40, 0xF0, 0x98, 0x2D, 
/*1790:*/ 0x41, 0xA0, 0xB8, 0x2D, 0x41, 0x64, 0xD9, 0x2D, 0x41, 0xA8, 0x19, 0x40, 0x60, 0x7C, 0x59, 0x41, 
/*17A0:*/ 0x41, 0xF8, 0xD9, 0x41, 0x41, 0xB8, 0x18, 0x44, 0x43, 0xE8, 0x78, 0x44, 0x43, 0xA0, 0x99, 0x44, 
/*17B0:*/ 0x63, 0xA0, 0x99, 0x44, 0x41, 0xB8, 0xB8, 0x44, 0x62, 0xB4, 0xD8, 0x44, 0x43, 0xBC, 0xD8, 0x44, 
/*17C0:*/ 0x60, 0xAC, 0xF9, 0x44, 0x42, 0x64, 0x18, 0x45, 0x41, 0xA0, 0x39, 0x45, 0x63, 0x70, 0xF9, 0x45, 
/*17D0:*/ 0x42, 0xE8, 0xD9, 0x49, 0x63, 0x38, 0x39, 0x4D, 0x61, 0x6C, 0xD8, 0x60, 0x40, 0x34, 0x18, 0x61, 
/*17E0:*/ 0x42, 0x20, 0x19, 0x61, 0x62, 0x78, 0x39, 0x61, 0x41, 0x74, 0x59, 0x61, 0x60, 0xA4, 0x79, 0x61, 
/*17F0:*/ 0x40, 0x38, 0x98, 0x61, 0x42, 0x20, 0xB9, 0x61, 0x41, 0x2C, 0xD9, 0x61, 0x60, 0x70, 0xD9, 0x61, 
/*1800:*/ 0x61, 0x74, 0xF9, 0x61, 0x43, 0xF8, 0x19, 0x64, 0x42, 0xFC, 0x39, 0x64, 0x62, 0xEC, 0x58, 0x64, 
/*1810:*/ 0x42, 0x60, 0x78, 0x64, 0x63, 0xF8, 0xB9, 0x64, 0x61, 0xA4, 0xF9, 0x64, 0x41, 0xF8, 0x19, 0x65, 
/*1820:*/ 0x61, 0xA0, 0x39, 0x65, 0x43, 0xA4, 0x59, 0x65, 0x61, 0xE8, 0x78, 0x65, 0x62, 0x20, 0x79, 0x65, 
/*1830:*/ 0x61, 0x74, 0x99, 0x65, 0x41, 0x68, 0xD8, 0x65, 0x61, 0xE8, 0xD8, 0x65, 0x40, 0x7C, 0xD8, 0x69, 
/*1840:*/ 0x40, 0x20, 0xF8, 0x6C, 0x41, 0x20, 0x18, 0x6D, 0x43, 0x34, 0xB9, 0x6D, 0x63, 0x2C, 0xD8, 0x80, 
/*1850:*/ 0x61, 0x38, 0x19, 0x84, 0x43, 0x30, 0x59, 0x84, 0x41, 0xA8, 0x78, 0x84, 0x42, 0x34, 0xD9, 0x84, 
/*1860:*/ 0x40, 0xF8, 0xF8, 0x84, 0x42, 0x38, 0xF9, 0x84, 0x41, 0x2C, 0x18, 0x85, 0x41, 0xF8, 0x18, 0x85, 
/*1870:*/ 0x42, 0x78, 0x58, 0x85, 0x42, 0xBC, 0x18, 0x8D, 0x63, 0x3C, 0x19, 0xA0, 0x61, 0xA4, 0x38, 0xA0, 
/*1880:*/ 0x61, 0x34, 0xF9, 0xA0, 0x61, 0x3C, 0xB9, 0xA1, 0x61, 0xBC, 0xB9, 0xA1, 0x61, 0x20, 0xF8, 0xA1, 
/*1890:*/ 0x60, 0x28, 0xF8, 0xA1, 0x62, 0xA4, 0x18, 0xA4, 0x63, 0x20, 0x38, 0xA4, 0x61, 0x60, 0x39, 0xA4, 
/*18A0:*/ 0x40, 0xBC, 0x39, 0xA4, 0x63, 0xBC, 0x79, 0xA4, 0x62, 0x7C, 0x98, 0xA4, 0x42, 0xFC, 0x98, 0xA4, 
/*18B0:*/ 0x61, 0xB4, 0x99, 0xA4, 0x43, 0xE0, 0x39, 0xA5, 0x41, 0xF4, 0x98, 0xA5, 0x42, 0xE8, 0x99, 0xA5, 
/*18C0:*/ 0x43, 0xEC, 0xB9, 0xA5, 0x60, 0xEC, 0xF9, 0xA5, 0x41, 0x34, 0x78, 0xA8, 0x41, 0xBC, 0x38, 0xA9, 
/*18D0:*/ 0x40, 0x74, 0x59, 0xAC, 0x41, 0x70, 0x79, 0xAC, 0x41, 0x38, 0x98, 0xAC, 0x41, 0x6C, 0x98, 0xAC, 
/*18E0:*/ 0x42, 0xE4, 0x38, 0xAD, 0x43, 0x70, 0x79, 0xAD, 0x42, 0x30, 0x98, 0xAD, 0x41, 0x20, 0xB9, 0xAD, 
/*18F0:*/ 0x40, 0xE0, 0xF8, 0xAD, 0x42, 0x74, 0xF9, 0xAD, 0x40, 0xE8, 0xF9, 0xC0, 0x63, 0xF4, 0x38, 0xC4, 
/*1900:*/ 0x43, 0x20, 0x98, 0xC4, 0x63, 0xAC, 0xB8, 0xC4, 0x62, 0xB4, 0xD9, 0xC4, 0x61, 0xA4, 0xF8, 0xC4, 
/*1910:*/ 0x42, 0x30, 0x19, 0xC5, 0x41, 0xA0, 0x38, 0xC5, 0x43, 0x7C, 0x78, 0xC5, 0x62, 0xF4, 0x78, 0xC5, 
/*1920:*/ 0x41, 0x3C, 0x79, 0xC5, 0x40, 0x7C, 0x98, 0xC5, 0x60, 0xA8, 0x98, 0xC5, 0x40, 0x24, 0xB8, 0xC5, 
/*1930:*/ 0x60, 0xA4, 0xB8, 0xC5, 0x62, 0xF4, 0xD8, 0xC5, 0x42, 0xA0, 0x39, 0xC9, 0x40, 0x68, 0x18, 0xCC, 
/*1940:*/ 0x63, 0xF4, 0xB9, 0xCC, 0x43, 0x30, 0x39, 0xE0, 0x43, 0x2C, 0x78, 0xE0, 0x63, 0xAC, 0x78, 0xE0, 
/*1950:*/ 0x41, 0x38, 0x79, 0xE0, 0x61, 0xB8, 0x79, 0xE0, 0x61, 0xA0, 0x58, 0xE1, 0x43, 0x34, 0x59, 0xE1, 
/*1960:*/ 0x40, 0x24, 0x78, 0xE1, 0x63, 0xB8, 0x79, 0xE1, 0x62, 0x74, 0xB8, 0xE1, 0x60, 0x70, 0xD8, 0xE1, 
/*1970:*/ 0x40, 0x28, 0xF8, 0xE1, 0x61, 0x74, 0xF8, 0xE1, 0x42, 0x70, 0x18, 0xE4, 0x43, 0xF8, 0x18, 0xE4, 
/*1980:*/ 0x41, 0xB8, 0x19, 0xE4, 0x41, 0x34, 0x39, 0xE4, 0x60, 0x68, 0x39, 0xE4, 0x61, 0xE0, 0x39, 0xE4, 
/*1990:*/ 0x62, 0xB8, 0x59, 0xE4, 0x61, 0xFC, 0x78, 0xE4, 0x43, 0x78, 0xB8, 0xE4, 0x61, 0x7C, 0xD8, 0xE4, 
/*19A0:*/ 0x62, 0x60, 0xD9, 0xE4, 0x61, 0xA4, 0xF8, 0xE4, 0x43, 0x30, 0xF9, 0xE4, 0x62, 0xB8, 0xF9, 0xE4, 
/*19B0:*/ 0x40, 0xA4, 0x18, 0xE5, 0x41, 0xF4, 0x38, 0xE5, 0x63, 0x60, 0x39, 0xE5, 0x40, 0xEC, 0x59, 0xE5, 
/*19C0:*/ 0x43, 0xFC, 0x78, 0xE5, 0x60, 0x60, 0x79, 0xE5, 0x61, 0x74, 0x98, 0xE5, 0x60, 0x70, 0xB8, 0xE5, 
/*19D0:*/ 0x61, 0x3C, 0xD9, 0xE5, 0x41, 0xBC, 0xD9, 0xE5, 0x40, 0xB8, 0xF9, 0xE5, 0x40, 0x3C, 0xB8, 0xEC, 
/*19E0:*/ 0x42, 0x28, 0xB9, 0xEC, 0x42, 0x3C, 0x18, 0xED, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*19F0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_A[] = {
/*2140:*/ 0x51, 0xB7, 0x1F, 0x21, 0xD7, 0xA7, 0x2A, 0x21, 0xD7, 0xAC, 0x53, 0x21, 0xD5, 0xB4, 0x56, 0x21, 
/*2150:*/ 0xD1, 0xB5, 0x56, 0x21, 0x51, 0xAD, 0x5B, 0x21, 0x53, 0xAD, 0x5B, 0x21, 0x51, 0xBE, 0x5C, 0x21, 
/*2160:*/ 0xD3, 0xAC, 0x71, 0x21, 0x51, 0xBF, 0x79, 0x21, 0x53, 0xA6, 0x7B, 0x21, 0x57, 0xAC, 0x7E, 0x21, 
/*2170:*/ 0x53, 0xBE, 0x7E, 0x21, 0x55, 0xBF, 0x7E, 0x21, 0xD1, 0xAC, 0x8D, 0x21, 0xD0, 0xB7, 0x9D, 0x21, 
/*2180:*/ 0xD3, 0xAC, 0xD3, 0x21, 0x55, 0xAC, 0xDB, 0x21, 0xD3, 0xA6, 0xF4, 0x21, 0xD3, 0xAD, 0xF6, 0x21, 
/*2190:*/ 0x57, 0xAD, 0xFE, 0x21, 0xD3, 0xA6, 0x0B, 0x31, 0xD5, 0xA5, 0x13, 0x31, 0xD1, 0xA5, 0x14, 0x31, 
/*21A0:*/ 0xD5, 0xB6, 0x14, 0x31, 0xD1, 0xAF, 0x16, 0x31, 0x51, 0xB7, 0x1C, 0x31, 0x53, 0xBD, 0x3C, 0x31, 
/*21B0:*/ 0x51, 0xB7, 0x45, 0x31, 0xD7, 0xAC, 0x57, 0x31, 0x51, 0xBE, 0x5F, 0x31, 0xD1, 0xAE, 0x6A, 0x31, 
/*21C0:*/ 0xD5, 0xAD, 0x72, 0x31, 0xD5, 0xBE, 0x72, 0x31, 0xD3, 0xBF, 0x75, 0x31, 0x51, 0xAD, 0x7D, 0x31, 
/*21D0:*/ 0x50, 0xAF, 0x93, 0x31, 0x51, 0xAC, 0xA4, 0x31, 0xD1, 0xBD, 0xC8, 0x31, 0xD3, 0xA6, 0xF0, 0x31, 
/*21E0:*/ 0xD7, 0xBF, 0xF5, 0x31, 0xD3, 0xA7, 0xF7, 0x31, 0xD5, 0xA5, 0x1B, 0x61, 0xD2, 0xB7, 0x34, 0x61, 
/*21F0:*/ 0xD5, 0xA7, 0x5A, 0x61, 0xD1, 0xA7, 0x5D, 0x61, 0x55, 0xAC, 0x75, 0x61, 0x53, 0xA7, 0x77, 0x61, 
/*2200:*/ 0xD3, 0xBF, 0x7D, 0x61, 0xD3, 0xBF, 0x86, 0x61, 0x51, 0xBC, 0xB3, 0x61, 0xD1, 0xB6, 0xB9, 0x61, 
/*2210:*/ 0x51, 0xB7, 0xCA, 0x61, 0x51, 0xBE, 0xD7, 0x61, 0xD1, 0xAC, 0xDF, 0x61, 0x51, 0xB4, 0xF7, 0x61, 
/*2220:*/ 0xD3, 0xBE, 0xFA, 0x61, 0xD5, 0xBF, 0xFD, 0x61, 0xD5, 0xBD, 0x1A, 0x71, 0xD3, 0xAE, 0x38, 0x71, 
/*2230:*/ 0xD3, 0xAE, 0x3F, 0x71, 0xD7, 0xBE, 0x5C, 0x71, 0x51, 0xB7, 0x6C, 0x71, 0x55, 0xAC, 0x76, 0x71, 
/*2240:*/ 0x51, 0xAD, 0x76, 0x71, 0x53, 0xBF, 0x76, 0x71, 0xD5, 0xAC, 0x7E, 0x71, 0xD1, 0xBE, 0x7E, 0x71, 
/*2250:*/ 0xD3, 0xBF, 0x7E, 0x71, 0xD1, 0xA4, 0x9F, 0x71, 0x51, 0xBF, 0xA8, 0x71, 0x55, 0xAE, 0xB0, 0x71, 
/*2260:*/ 0xD1, 0xA4, 0xBD, 0x71, 0x51, 0xAF, 0xCC, 0x71, 0x51, 0xB4, 0xD1, 0x71, 0x51, 0xBE, 0xD3, 0x71, 
/*2270:*/ 0x53, 0xAC, 0xF6, 0x71, 0xD1, 0xBE, 0xF9, 0x71, 0xD5, 0xB5, 0xFB, 0x71, 0xD7, 0xB7, 0x06, 0xA1, 
/*2280:*/ 0xD1, 0xAD, 0x1B, 0xA1, 0xD1, 0xAD, 0x1C, 0xA1, 0xD5, 0xBE, 0x1C, 0xA1, 0x51, 0xAD, 0x31, 0xA1, 
/*2290:*/ 0xD1, 0xA7, 0x3B, 0xA1, 0xD1, 0xB5, 0x3B, 0xA1, 0xD1, 0xAD, 0x42, 0xA1, 0x55, 0xA5, 0x50, 0xA1, 
/*22A0:*/ 0x51, 0xAE, 0x52, 0xA1, 0x57, 0xA4, 0x57, 0xA1, 0xD5, 0xB6, 0x58, 0xA1, 0xD1, 0xAE, 0x5A, 0xA1, 
/*22B0:*/ 0xD5, 0xAF, 0x5A, 0xA1, 0xD1, 0xAF, 0x5D, 0xA1, 0xD1, 0xBD, 0x5D, 0xA1, 0x53, 0xAE, 0x70, 0xA1, 
/*22C0:*/ 0x55, 0xAF, 0x70, 0xA1, 0x55, 0xAE, 0x77, 0xA1, 0xD1, 0xAE, 0x78, 0xA1, 0xD3, 0xBD, 0x78, 0xA1, 
/*22D0:*/ 0xD7, 0xA4, 0x7A, 0xA1, 0xD3, 0xB6, 0x7A, 0xA1, 0xD5, 0xB6, 0x7D, 0xA1, 0xD3, 0xBC, 0x7F, 0xA1, 
/*22E0:*/ 0x55, 0xA7, 0x91, 0xA1, 0x55, 0xAD, 0x94, 0xA1, 0x51, 0xBC, 0xD5, 0xA1, 0x55, 0xA5, 0xD7, 0xA1, 
/*22F0:*/ 0x51, 0xBF, 0xEF, 0xA1, 0x53, 0xBD, 0xF0, 0xA1, 0x55, 0xA4, 0xF2, 0xA1, 0x51, 0xB6, 0xF5, 0xA1, 
/*2300:*/ 0xD5, 0xAF, 0xFF, 0xA1, 0xD1, 0xBC, 0x59, 0xB1, 0xD7, 0xBC, 0x59, 0xB1, 0xD1, 0xA4, 0x5B, 0xB1, 
/*2310:*/ 0xD1, 0xB5, 0x61, 0xB1, 0x51, 0xAD, 0x6B, 0xB1, 0x53, 0xB7, 0x71, 0xB1, 0xD1, 0xAE, 0x7B, 0xB1, 
/*2320:*/ 0xD3, 0xAF, 0x7C, 0xB1, 0x51, 0xB6, 0x8D, 0xB1, 0x55, 0xB5, 0x95, 0xB1, 0xD5, 0xA7, 0x9A, 0xB1, 
/*2330:*/ 0xD5, 0xA6, 0x9D, 0xB1, 0x55, 0xAD, 0xB2, 0xB1, 0x55, 0xBF, 0xB5, 0xB1, 0x53, 0xAF, 0xD1, 0xB1, 
/*2340:*/ 0x51, 0xB6, 0xD4, 0xB1, 0x53, 0xAF, 0xD6, 0xB1, 0xD3, 0xAF, 0xD9, 0xB1, 0xD7, 0xB7, 0xDC, 0xB1, 
/*2350:*/ 0xD5, 0xAE, 0xDE, 0xB1, 0x51, 0xB5, 0xE9, 0xB1, 0xD5, 0xBF, 0x17, 0xE1, 0x55, 0xA7, 0x1D, 0xE1, 
/*2360:*/ 0xD1, 0xBD, 0x2D, 0xE1, 0xD5, 0xB5, 0x30, 0xE1, 0xD3, 0xBC, 0x51, 0xE1, 0xD5, 0xA5, 0x54, 0xE1, 
/*2370:*/ 0xD5, 0xAE, 0x56, 0xE1, 0xD1, 0xAF, 0x56, 0xE1, 0x53, 0xA4, 0x5B, 0xE1, 0x57, 0xB6, 0x5C, 0xE1, 
/*2380:*/ 0xD1, 0xBD, 0x73, 0xE1, 0xD5, 0xB6, 0x76, 0xE1, 0xD7, 0xB6, 0x76, 0xE1, 0x51, 0xA5, 0x79, 0xE1, 
/*2390:*/ 0x57, 0xAF, 0xA2, 0xE1, 0xD5, 0xBE, 0xB5, 0xE1, 0x51, 0xBE, 0xBD, 0xE1, 0xD1, 0xA6, 0xCB, 0xE1, 
/*23A0:*/ 0xD1, 0xBF, 0xCE, 0xE1, 0xD1, 0xBC, 0xD1, 0xE1, 0xD3, 0xA4, 0xD4, 0xE1, 0x51, 0xBC, 0xD9, 0xE1, 
/*23B0:*/ 0x53, 0xBD, 0xD9, 0xE1, 0x51, 0xBF, 0xE4, 0xE1, 0xD1, 0xA7, 0xE9, 0xE1, 0xD1, 0xA4, 0xF1, 0xE1, 
/*23C0:*/ 0xD1, 0xAE, 0xF3, 0xE1, 0x53, 0xAF, 0xFC, 0xE1, 0x53, 0xA5, 0xFE, 0xE1, 0xD5, 0xAD, 0x13, 0xF1, 
/*23D0:*/ 0xD3, 0xBE, 0x14, 0xF1, 0xD1, 0xBF, 0x36, 0xF1, 0xD3, 0xAF, 0x55, 0xF1, 0xD7, 0xB6, 0x57, 0xF1, 
/*23E0:*/ 0x53, 0xBD, 0x5A, 0xF1, 0xD5, 0xA4, 0x75, 0xF1, 0x51, 0xBD, 0x78, 0xF1, 0x57, 0xA5, 0x7A, 0xF1, 
/*23F0:*/ 0x53, 0xB7, 0x7A, 0xF1, 0x51, 0xB7, 0x81, 0xF1, 0x51, 0xAE, 0x84, 0xF1, 0x57, 0xA4, 0x86, 0xF1, 
/*2400:*/ 0xD7, 0xBC, 0x8C, 0xF1, 0x53, 0xA7, 0xC7, 0xF1, 0xD3, 0xAD, 0xCD, 0xF1, 0xD5, 0xA4, 0xD7, 0xF1, 
/*2410:*/ 0x53, 0xA5, 0xDF, 0xF1, 0x55, 0xA5, 0xDF, 0xF1, 0x51, 0xB5, 0xE2, 0xF1, 0xD1, 0xAD, 0xE8, 0xF1, 
/*2420:*/ 0xD3, 0xBC, 0xF7, 0xF1, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*2430:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_B[] = {
/*2B30:*/ 0x0E, 0x18, 0x00, 0x92, 0x9C, 0x48, 0x00, 0x92, 0x8F, 0x60, 0x00, 0x92, 0x95, 0x00, 0x01, 0x92, 
/*2B40:*/ 0x1A, 0x70, 0x08, 0x92, 0x97, 0x34, 0x09, 0x92, 0x1D, 0x78, 0x09, 0x92, 0x0C, 0x04, 0x21, 0x92, 
/*2B50:*/ 0x93, 0x2C, 0x21, 0x92, 0x0C, 0x64, 0x21, 0x92, 0x04, 0x68, 0x21, 0x92, 0x14, 0x78, 0x21, 0x92, 
/*2B60:*/ 0x8C, 0x20, 0x28, 0x92, 0x13, 0x58, 0x29, 0x92, 0x02, 0x5C, 0x29, 0x92, 0x0C, 0x7C, 0x29, 0x92, 
/*2B70:*/ 0x0A, 0x18, 0x40, 0x92, 0x9A, 0x54, 0x41, 0x92, 0x82, 0x60, 0x48, 0x92, 0x83, 0x24, 0x49, 0x92, 
/*2B80:*/ 0x9C, 0x18, 0x61, 0x92, 0x0E, 0x48, 0x61, 0x92, 0x0C, 0x64, 0x61, 0x92, 0x92, 0x10, 0x68, 0x92, 
/*2B90:*/ 0x0B, 0x14, 0x68, 0x92, 0x16, 0x1C, 0x68, 0x92, 0x9C, 0x50, 0x68, 0x92, 0x9E, 0x7C, 0x68, 0x92, 
/*2BA0:*/ 0x0A, 0x50, 0x69, 0x92, 0x86, 0x30, 0x89, 0x92, 0x0E, 0x28, 0xA1, 0x92, 0x11, 0x24, 0xA8, 0x92, 
/*2BB0:*/ 0x96, 0x70, 0xA8, 0x92, 0x97, 0x1C, 0xC0, 0x92, 0x18, 0x44, 0xC0, 0x92, 0x13, 0x40, 0xC1, 0x92, 
/*2BC0:*/ 0x0F, 0x38, 0x00, 0x93, 0x1A, 0x3C, 0x00, 0x93, 0x06, 0x40, 0x00, 0x93, 0x04, 0x3C, 0x01, 0x93, 
/*2BD0:*/ 0x95, 0x54, 0x01, 0x93, 0x8D, 0x00, 0x08, 0x93, 0x96, 0x24, 0x08, 0x93, 0x8A, 0x20, 0x20, 0x93, 
/*2BE0:*/ 0x83, 0x08, 0x21, 0x93, 0x9C, 0x2C, 0x21, 0x93, 0x82, 0x34, 0x28, 0x93, 0x15, 0x68, 0x40, 0x93, 
/*2BF0:*/ 0x9A, 0x00, 0x41, 0x93, 0x1A, 0x24, 0x48, 0x93, 0x1A, 0x44, 0x48, 0x93, 0x04, 0x44, 0x49, 0x93, 
/*2C00:*/ 0x93, 0x60, 0x49, 0x93, 0x82, 0x2C, 0x60, 0x93, 0x8E, 0x40, 0x60, 0x93, 0x1E, 0x0C, 0x61, 0x93, 
/*2C10:*/ 0x17, 0x14, 0x61, 0x93, 0x9C, 0x2C, 0x61, 0x93, 0x94, 0x40, 0x61, 0x93, 0x12, 0x60, 0x61, 0x93, 
/*2C20:*/ 0x8F, 0x64, 0x61, 0x93, 0x1E, 0x6C, 0x61, 0x93, 0x84, 0x18, 0x68, 0x93, 0x16, 0x48, 0x68, 0x93, 
/*2C30:*/ 0x07, 0x1C, 0x69, 0x93, 0x87, 0x70, 0x69, 0x93, 0x1E, 0x5C, 0xA0, 0x93, 0x18, 0x40, 0xA1, 0x93, 
/*2C40:*/ 0x9F, 0x24, 0xC0, 0x93, 0x0A, 0x7C, 0xC1, 0x93, 0x9A, 0x28, 0xC8, 0x93, 0x12, 0x48, 0xC8, 0x93, 
/*2C50:*/ 0x0E, 0x1C, 0xE1, 0x93, 0x90, 0x40, 0xE1, 0x93, 0x96, 0x44, 0xE8, 0x93, 0x0E, 0x04, 0xE9, 0x93, 
/*2C60:*/ 0x9F, 0x5C, 0x21, 0x97, 0x1E, 0x00, 0x00, 0xD2, 0x96, 0x60, 0x00, 0xD2, 0x8A, 0x4C, 0x01, 0xD2, 
/*2C70:*/ 0x03, 0x58, 0x01, 0xD2, 0x16, 0x5C, 0x01, 0xD2, 0x95, 0x20, 0x08, 0xD2, 0x04, 0x28, 0x08, 0xD2, 
/*2C80:*/ 0x85, 0x60, 0x09, 0xD2, 0x8D, 0x6C, 0x09, 0xD2, 0x12, 0x0C, 0x20, 0xD2, 0x12, 0x6C, 0x20, 0xD2, 
/*2C90:*/ 0x8B, 0x20, 0x29, 0xD2, 0x82, 0x38, 0x29, 0xD2, 0x92, 0x48, 0x29, 0xD2, 0x0B, 0x4C, 0x29, 0xD2, 
/*2CA0:*/ 0x8E, 0x34, 0x49, 0xD2, 0x9A, 0x6C, 0x60, 0xD2, 0x0F, 0x34, 0x61, 0xD2, 0x86, 0x08, 0x68, 0xD2, 
/*2CB0:*/ 0x92, 0x18, 0x68, 0xD2, 0x1F, 0x3C, 0x69, 0xD2, 0x8E, 0x54, 0x89, 0xD2, 0x9C, 0x20, 0xA0, 0xD2, 
/*2CC0:*/ 0x1E, 0x78, 0xA8, 0xD2, 0x9E, 0x24, 0xA9, 0xD2, 0x0B, 0x64, 0xC0, 0xD2, 0x9B, 0x60, 0xC8, 0xD2, 
/*2CD0:*/ 0x93, 0x6C, 0xC8, 0xD2, 0x8B, 0x70, 0xC8, 0xD2, 0x9E, 0x3C, 0xE1, 0xD2, 0x06, 0x54, 0xE9, 0xD2, 
/*2CE0:*/ 0x06, 0x28, 0x00, 0xD3, 0x12, 0x38, 0x00, 0xD3, 0x07, 0x3C, 0x00, 0xD3, 0x8E, 0x48, 0x00, 0xD3, 
/*2CF0:*/ 0x92, 0x54, 0x00, 0xD3, 0x1E, 0x04, 0x01, 0xD3, 0x14, 0x24, 0x01, 0xD3, 0x04, 0x1C, 0x08, 0xD3, 
/*2D00:*/ 0x1D, 0x44, 0x09, 0xD3, 0x9D, 0x48, 0x09, 0xD3, 0x8D, 0x58, 0x09, 0xD3, 0x12, 0x58, 0x20, 0xD3, 
/*2D10:*/ 0x13, 0x1C, 0x21, 0xD3, 0x8C, 0x54, 0x21, 0xD3, 0x0C, 0x20, 0x29, 0xD3, 0x8D, 0x38, 0x29, 0xD3, 
/*2D20:*/ 0x92, 0x7C, 0x29, 0xD3, 0x1E, 0x04, 0x41, 0xD3, 0x9A, 0x08, 0x41, 0xD3, 0x8A, 0x30, 0x48, 0xD3, 
/*2D30:*/ 0x1A, 0x4C, 0x48, 0xD3, 0x96, 0x4C, 0x48, 0xD3, 0x02, 0x00, 0x49, 0xD3, 0x8B, 0x74, 0x49, 0xD3, 
/*2D40:*/ 0x80, 0x08, 0x60, 0xD3, 0x13, 0x2C, 0x60, 0xD3, 0x86, 0x44, 0x60, 0xD3, 0x04, 0x54, 0x61, 0xD3, 
/*2D50:*/ 0x8A, 0x30, 0x68, 0xD3, 0x1B, 0x38, 0x68, 0xD3, 0x1F, 0x08, 0x69, 0xD3, 0x86, 0x0C, 0x89, 0xD3, 
/*2D60:*/ 0x16, 0x58, 0xA0, 0xD3, 0x82, 0x14, 0xA1, 0xD3, 0x10, 0x14, 0xC0, 0xD3, 0x06, 0x48, 0xC0, 0xD3, 
/*2D70:*/ 0x1E, 0x04, 0xC1, 0xD3, 0x0E, 0x74, 0xC1, 0xD3, 0x17, 0x7C, 0xC1, 0xD3, 0x87, 0x48, 0xC8, 0xD3, 
/*2D80:*/ 0x92, 0x4C, 0xC8, 0xD3, 0x96, 0x54, 0xE0, 0xD3, 0x16, 0x08, 0xE1, 0xD3, 0x0E, 0x14, 0xE1, 0xD3, 
/*2D90:*/ 0x0E, 0x74, 0xE1, 0xD3, 0x0E, 0x6C, 0xE9, 0xD3, 0x8F, 0x58, 0x28, 0xD6, 0x87, 0x18, 0x20, 0xD7, 
/*2DA0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_C[] = {
/*3380:*/ 0xC0, 0xB2, 0xA1, 0x01, 0x43, 0xA3, 0xA2, 0x01, 0x66, 0xB2, 0xA3, 0x01, 0xC6, 0x22, 0xA7, 0x01, 
/*3390:*/ 0xE0, 0x22, 0xAA, 0x01, 0x62, 0x3B, 0xAA, 0x01, 0x63, 0x8B, 0xAE, 0x01, 0xE7, 0x02, 0xA3, 0x11, 
/*33A0:*/ 0xE3, 0x82, 0xA4, 0x11, 0x47, 0x82, 0xA6, 0x11, 0x41, 0xBB, 0xA6, 0x11, 0xE3, 0x8B, 0xAA, 0x11, 
/*33B0:*/ 0xE3, 0x9A, 0xAB, 0x11, 0xC2, 0x1B, 0xAC, 0x11, 0x63, 0x2B, 0xAC, 0x11, 0xE3, 0x33, 0xAC, 0x11, 
/*33C0:*/ 0xE2, 0x2B, 0xAE, 0x11, 0xE2, 0x3A, 0xAE, 0x11, 0x41, 0xA2, 0xA6, 0x21, 0xE0, 0x93, 0xA7, 0x21, 
/*33D0:*/ 0xC2, 0x12, 0xAD, 0x21, 0xE0, 0x32, 0xAF, 0x21, 0xE2, 0x9A, 0xA2, 0x31, 0xE6, 0xA2, 0xA3, 0x31, 
/*33E0:*/ 0xE7, 0x02, 0xA7, 0x31, 0x46, 0x32, 0xA7, 0x31, 0x47, 0x22, 0xAB, 0x31, 0xE1, 0x8A, 0xAE, 0x31, 
/*33F0:*/ 0xC6, 0x8B, 0xAF, 0x31, 0xE7, 0x02, 0xA0, 0x41, 0x67, 0x0A, 0xA1, 0x41, 0x42, 0x1A, 0xA1, 0x41, 
/*3400:*/ 0xE1, 0x2A, 0xA1, 0x41, 0x47, 0x3A, 0xA3, 0x41, 0x60, 0x8A, 0xAA, 0x41, 0xC1, 0xAA, 0xAB, 0x41, 
/*3410:*/ 0x43, 0x1A, 0xAD, 0x41, 0xC7, 0x92, 0xA0, 0x51, 0x61, 0x82, 0xA2, 0x51, 0xC0, 0x1A, 0xA4, 0x51, 
/*3420:*/ 0x43, 0x1A, 0xA6, 0x51, 0xE2, 0x3B, 0xA7, 0x51, 0xC7, 0x22, 0xA8, 0x51, 0xC1, 0x1B, 0xA9, 0x51, 
/*3430:*/ 0xC0, 0x02, 0xAB, 0x51, 0xC2, 0x03, 0xAB, 0x51, 0x61, 0x9A, 0xAD, 0x51, 0x43, 0xAB, 0xAE, 0x51, 
/*3440:*/ 0x62, 0x93, 0xAF, 0x51, 0x23, 0x12, 0xA1, 0x61, 0x46, 0x22, 0xA4, 0x61, 0x42, 0x1A, 0xA5, 0x61, 
/*3450:*/ 0xE2, 0x3A, 0xA9, 0x61, 0x40, 0x12, 0xAA, 0x61, 0xC0, 0xB2, 0xAD, 0x61, 0xE2, 0x82, 0xAE, 0x61, 
/*3460:*/ 0xE2, 0x83, 0xAE, 0x61, 0xE6, 0xAB, 0xAF, 0x61, 0x42, 0x12, 0xA1, 0x71, 0xE1, 0x22, 0xA1, 0x71, 
/*3470:*/ 0xC3, 0x12, 0xA3, 0x71, 0x47, 0x32, 0xA3, 0x71, 0xE3, 0x8A, 0xA6, 0x71, 0x63, 0x93, 0xA6, 0x71, 
/*3480:*/ 0x42, 0xAA, 0xA6, 0x71, 0x65, 0xA2, 0xA9, 0x71, 0xE2, 0x8B, 0xAA, 0x71, 0x60, 0x92, 0xAB, 0x71, 
/*3490:*/ 0xC3, 0xB2, 0xAB, 0x71, 0x41, 0x13, 0xAC, 0x71, 0x60, 0x2A, 0xAD, 0x71, 0x02, 0x82, 0xAD, 0x71, 
/*34A0:*/ 0x43, 0x82, 0xA2, 0x81, 0xC3, 0x8A, 0xA2, 0x81, 0xE0, 0xA2, 0xA2, 0x81, 0xC3, 0x8B, 0xA3, 0x81, 
/*34B0:*/ 0xE7, 0x2A, 0xA7, 0x81, 0xC3, 0x3B, 0xAA, 0x81, 0xC0, 0x8A, 0xAE, 0x81, 0x61, 0xBB, 0xAE, 0x81, 
/*34C0:*/ 0x63, 0x12, 0xA2, 0x91, 0xC0, 0x22, 0xA3, 0x91, 0x66, 0x9A, 0xA7, 0x91, 0x64, 0x83, 0xA8, 0x91, 
/*34D0:*/ 0xE2, 0x1A, 0xAE, 0x91, 0xE6, 0x32, 0xAF, 0x91, 0xE3, 0x12, 0xA3, 0xA1, 0xC6, 0xAB, 0xA5, 0xA1, 
/*34E0:*/ 0x41, 0x82, 0xA6, 0xA1, 0xC7, 0xA2, 0xA7, 0xA1, 0xE0, 0xBA, 0xA9, 0xA1, 0x40, 0x82, 0xAA, 0xA1, 
/*34F0:*/ 0x67, 0x93, 0xAA, 0xA1, 0xE3, 0xA2, 0xAA, 0xA1, 0x46, 0xAB, 0xAB, 0xA1, 0x63, 0x12, 0xAD, 0xA1, 
/*3500:*/ 0x60, 0x1A, 0xAE, 0xA1, 0xE0, 0x12, 0xAF, 0xA1, 0x66, 0x33, 0xAF, 0xA1, 0xC0, 0x8A, 0xA1, 0xB1, 
/*3510:*/ 0xC3, 0x22, 0xAA, 0xB1, 0x60, 0xBA, 0xAD, 0xB1, 0xE3, 0xAA, 0xAE, 0xB1, 0x67, 0x3A, 0xA1, 0xC1, 
/*3520:*/ 0x43, 0x22, 0xA2, 0xC1, 0xE0, 0x02, 0xA3, 0xC1, 0xC2, 0x8A, 0xA6, 0xC1, 0xE3, 0xA2, 0xA6, 0xC1, 
/*3530:*/ 0xC0, 0x9A, 0xA7, 0xC1, 0xC6, 0xB2, 0xA7, 0xC1, 0xC6, 0xAA, 0xA8, 0xC1, 0xE7, 0x82, 0xA9, 0xC1, 
/*3540:*/ 0xC0, 0x92, 0xA9, 0xC1, 0x62, 0xAB, 0xAA, 0xC1, 0x62, 0x12, 0xAD, 0xC1, 0xC1, 0x22, 0xAD, 0xC1, 
/*3550:*/ 0x42, 0x23, 0xAF, 0xC1, 0x41, 0x92, 0xA1, 0xD1, 0x62, 0xBA, 0xA1, 0xD1, 0xC2, 0x92, 0xA3, 0xD1, 
/*3560:*/ 0x42, 0x9B, 0xA3, 0xD1, 0xC5, 0x03, 0xA9, 0xD1, 0x61, 0x13, 0xAA, 0xD1, 0xC0, 0x22, 0xAA, 0xD1, 
/*3570:*/ 0xE3, 0x1A, 0xAB, 0xD1, 0xC3, 0x82, 0xAE, 0xD1, 0x43, 0x8A, 0xAE, 0xD1, 0x43, 0x8B, 0xAE, 0xD1, 
/*3580:*/ 0xE0, 0xBB, 0xAE, 0xD1, 0xE2, 0xAB, 0xAF, 0xD1, 0xE2, 0xBA, 0xAF, 0xD1, 0x62, 0xB3, 0xA0, 0xE1, 
/*3590:*/ 0x23, 0x22, 0xA1, 0xE1, 0x42, 0x92, 0xA3, 0xE1, 0x60, 0x1A, 0xA6, 0xE1, 0x60, 0x0B, 0xA7, 0xE1, 
/*35A0:*/ 0xC7, 0x12, 0xA7, 0xE1, 0x46, 0x1A, 0xAB, 0xE1, 0x61, 0xB2, 0xAD, 0xE1, 0xE2, 0xA2, 0xAE, 0xE1, 
/*35B0:*/ 0x41, 0x3B, 0xA2, 0xF1, 0x41, 0x93, 0xA4, 0xF1, 0x42, 0x9A, 0xA6, 0xF1, 0xE2, 0xBB, 0xAA, 0xF1, 
/*35C0:*/ 0xC1, 0x82, 0xAB, 0xF1, 0x43, 0x8B, 0xAB, 0xF1, 0x43, 0x9B, 0xAB, 0xF1, 0xE0, 0xBA, 0xAB, 0xF1, 
/*35D0:*/ 0xC1, 0x3A, 0xAD, 0xF1, 0x61, 0x13, 0xAE, 0xF1, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*35E0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_D[] = {
/*3BA0:*/ 0x75, 0x28, 0x09, 0x58, 0x24, 0x98, 0x0D, 0x58, 0x34, 0x3A, 0x49, 0x58, 0x2C, 0xB8, 0x49, 0x58, 
/*3BB0:*/ 0x64, 0xBA, 0x6D, 0x58, 0x74, 0x92, 0x79, 0x58, 0x6C, 0x1A, 0x7D, 0x58, 0x35, 0x28, 0x7D, 0x58, 
/*3BC0:*/ 0x3C, 0x10, 0x89, 0x58, 0x34, 0x92, 0x8D, 0x58, 0x24, 0x98, 0x8D, 0x58, 0x2C, 0x12, 0x99, 0x58, 
/*3BD0:*/ 0x25, 0x2A, 0x99, 0x58, 0x7D, 0x88, 0x99, 0x58, 0x35, 0xF8, 0xAD, 0x58, 0x25, 0xAA, 0xB9, 0x58, 
/*3BE0:*/ 0x75, 0x8A, 0xC9, 0x58, 0x25, 0x00, 0xE9, 0x58, 0x25, 0x2A, 0xED, 0x58, 0x7D, 0xA8, 0xED, 0x58, 
/*3BF0:*/ 0x24, 0xE0, 0x19, 0x59, 0x74, 0x9A, 0x1D, 0x59, 0x6C, 0xC2, 0x3D, 0x59, 0x3D, 0x22, 0x49, 0x59, 
/*3C00:*/ 0x6D, 0x7A, 0x59, 0x59, 0x25, 0xA8, 0x59, 0x59, 0x74, 0xB0, 0x99, 0x59, 0x64, 0xB0, 0x9D, 0x59, 
/*3C10:*/ 0x3C, 0x92, 0xBD, 0x59, 0x34, 0x6A, 0xCD, 0x59, 0x75, 0xA0, 0xCD, 0x59, 0x2D, 0x00, 0xD9, 0x59, 
/*3C20:*/ 0x64, 0x32, 0xDD, 0x59, 0x65, 0x82, 0xDD, 0x59, 0x35, 0x88, 0xDD, 0x59, 0x35, 0x70, 0xE9, 0x59, 
/*3C30:*/ 0x2D, 0xF2, 0xE9, 0x59, 0x75, 0x58, 0xF9, 0x59, 0x74, 0x92, 0xF9, 0x59, 0x75, 0xE0, 0x09, 0x5A, 
/*3C40:*/ 0x7C, 0x88, 0x0D, 0x5A, 0x65, 0x32, 0x3D, 0x5A, 0x65, 0x32, 0x49, 0x5A, 0x65, 0x38, 0x4D, 0x5A, 
/*3C50:*/ 0x65, 0x3A, 0x59, 0x5A, 0x3D, 0x30, 0x69, 0x5A, 0x7C, 0x80, 0x69, 0x5A, 0x3C, 0xA0, 0x69, 0x5A, 
/*3C60:*/ 0x65, 0x98, 0x6D, 0x5A, 0x3C, 0xAA, 0x6D, 0x5A, 0x6D, 0x38, 0x7D, 0x5A, 0x25, 0xA2, 0x85, 0x5A, 
/*3C70:*/ 0x7D, 0x92, 0xA9, 0x5A, 0x2D, 0xB2, 0xAD, 0x5A, 0x24, 0x88, 0xB9, 0x5A, 0x3C, 0x00, 0xBD, 0x5A, 
/*3C80:*/ 0x2D, 0xBA, 0xBD, 0x5A, 0x65, 0x32, 0xC9, 0x5A, 0x35, 0x32, 0xCD, 0x5A, 0x7D, 0x9A, 0xCD, 0x5A, 
/*3C90:*/ 0x7C, 0x08, 0xD9, 0x5A, 0x7D, 0xE2, 0xD9, 0x5A, 0x65, 0x30, 0xDD, 0x5A, 0x2D, 0x98, 0xDD, 0x5A, 
/*3CA0:*/ 0x7D, 0xB2, 0xDD, 0x5A, 0x6C, 0x80, 0xED, 0x5A, 0x7C, 0xA8, 0xF9, 0x5A, 0x7D, 0x68, 0xFD, 0x5A, 
/*3CB0:*/ 0x75, 0x9A, 0xFD, 0x5A, 0x7C, 0xD8, 0xFD, 0x5A, 0x25, 0xC0, 0x0D, 0x5B, 0x7C, 0xB8, 0x15, 0x5B, 
/*3CC0:*/ 0x24, 0xA2, 0x49, 0x5B, 0x6C, 0x20, 0x4D, 0x5B, 0x7D, 0xB2, 0x5D, 0x5B, 0x3D, 0x18, 0x79, 0x5B, 
/*3CD0:*/ 0x2D, 0x18, 0x89, 0x5B, 0x35, 0x90, 0x8D, 0x5B, 0x65, 0x9A, 0x8D, 0x5B, 0x3D, 0xAA, 0xA1, 0x5B, 
/*3CE0:*/ 0x7C, 0x78, 0xA9, 0x5B, 0x3D, 0xE8, 0xA9, 0x5B, 0x7D, 0xE8, 0xA9, 0x5B, 0x24, 0xF0, 0xAD, 0x5B, 
/*3CF0:*/ 0x6D, 0xEA, 0xB9, 0x5B, 0x7C, 0x7A, 0xBD, 0x5B, 0x75, 0x30, 0xD9, 0x5B, 0x7C, 0xAA, 0xED, 0x5B, 
/*3D00:*/ 0x2D, 0x68, 0xF9, 0x5B, 0x24, 0x00, 0xFD, 0x5B, 0x3D, 0x12, 0xFD, 0x5B, 0x65, 0xB0, 0xFD, 0x5B, 
/*3D10:*/ 0x64, 0x0A, 0x39, 0x5C, 0x34, 0x2A, 0x49, 0x5C, 0x6D, 0x1A, 0x5D, 0x5C, 0x64, 0x58, 0x5D, 0x5C, 
/*3D20:*/ 0x3C, 0x22, 0x69, 0x5C, 0x34, 0x82, 0x8D, 0x5C, 0x3D, 0xB8, 0x99, 0x5C, 0x2D, 0xB8, 0x9D, 0x5C, 
/*3D30:*/ 0x34, 0x02, 0xAD, 0x5C, 0x24, 0x08, 0xAD, 0x5C, 0x2C, 0x82, 0xCD, 0x5C, 0x3C, 0x80, 0xDD, 0x5C, 
/*3D40:*/ 0x75, 0x3A, 0xE9, 0x5C, 0x6C, 0x02, 0xED, 0x5C, 0x2C, 0x22, 0xED, 0x5C, 0x75, 0x32, 0xF9, 0x5C, 
/*3D50:*/ 0x25, 0x68, 0xFD, 0x5C, 0x7C, 0x5A, 0x09, 0x5D, 0x2D, 0x32, 0x4D, 0x5D, 0x7D, 0x3A, 0x59, 0x5D, 
/*3D60:*/ 0x3D, 0xB2, 0x69, 0x5D, 0x7D, 0xB2, 0x69, 0x5D, 0x24, 0xF2, 0x8D, 0x5D, 0x64, 0x20, 0xC9, 0x5D, 
/*3D70:*/ 0x3C, 0x7A, 0xFD, 0x5D, 0x64, 0x92, 0x3D, 0x5E, 0x74, 0x18, 0x69, 0x5E, 0x75, 0xA0, 0x79, 0x5E, 
/*3D80:*/ 0x6D, 0x28, 0x7D, 0x5E, 0x3D, 0x22, 0x89, 0x5E, 0x2D, 0x28, 0x89, 0x5E, 0x35, 0xAA, 0x89, 0x5E, 
/*3D90:*/ 0x24, 0x1A, 0x8D, 0x5E, 0x7D, 0x0A, 0x99, 0x5E, 0x2C, 0x18, 0xA9, 0x5E, 0x7C, 0x32, 0xA9, 0x5E, 
/*3DA0:*/ 0x6D, 0x80, 0xB9, 0x5E, 0x2C, 0x1A, 0xBD, 0x5E, 0x2D, 0xAA, 0xBD, 0x5E, 0x3C, 0x3A, 0xCD, 0x5E, 
/*3DB0:*/ 0x35, 0x00, 0xD9, 0x5E, 0x3C, 0x62, 0xD9, 0x5E, 0x7D, 0x88, 0xD9, 0x5E, 0x2D, 0xF8, 0xD9, 0x5E, 
/*3DC0:*/ 0x7C, 0x12, 0xDD, 0x5E, 0x2D, 0x88, 0xDD, 0x5E, 0x24, 0x90, 0xDD, 0x5E, 0x64, 0x12, 0xE9, 0x5E, 
/*3DD0:*/ 0x65, 0xA8, 0xED, 0x5E, 0x3C, 0xE8, 0xFD, 0x5E, 0x2C, 0x6A, 0x4D, 0x5F, 0x34, 0xE8, 0x4D, 0x5F, 
/*3DE0:*/ 0x3D, 0x08, 0x79, 0x5F, 0x35, 0xB2, 0x81, 0x5F, 0x7D, 0x70, 0x99, 0x5F, 0x65, 0x70, 0xAD, 0x5F, 
/*3DF0:*/ 0x34, 0xE2, 0xC9, 0x5F, 0x3C, 0x62, 0xD9, 0x5F, 0x75, 0x2A, 0xDD, 0x5F, 0x74, 0xBA, 0xDD, 0x5F, 
/*3E00:*/ 0x74, 0x32, 0xED, 0x5F, 0x65, 0xAA, 0xF9, 0x5F, 0x3C, 0xE2, 0xF9, 0x5F, 0x0D, 0xF0, 0xAD, 0xBA, 
/*3E10:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_E[] = {
/*43F0:*/ 0x1C, 0x18, 0x22, 0x01, 0xBC, 0x1C, 0x3D, 0x01, 0x9C, 0x97, 0x70, 0x01, 0x3C, 0x1E, 0x76, 0x01, 
/*4400:*/ 0x3C, 0x91, 0x76, 0x01, 0x1C, 0x9D, 0x79, 0x01, 0x3C, 0x18, 0x8E, 0x01, 0x9C, 0x1C, 0x90, 0x01, 
/*4410:*/ 0x1C, 0x98, 0x99, 0x01, 0xBC, 0x9C, 0xB0, 0x01, 0x3C, 0x92, 0xB1, 0x01, 0x1C, 0x1A, 0xB6, 0x01, 
/*4420:*/ 0x3C, 0x15, 0xC5, 0x01, 0x3C, 0x95, 0xC5, 0x01, 0x9C, 0x94, 0xD3, 0x01, 0x3C, 0x92, 0xD4, 0x01, 
/*4430:*/ 0x3C, 0x18, 0xDD, 0x01, 0x3C, 0x12, 0xE2, 0x01, 0xBC, 0x1C, 0xE2, 0x01, 0x3C, 0x1D, 0xE3, 0x01, 
/*4440:*/ 0x1C, 0x9D, 0xF5, 0x01, 0x3C, 0x11, 0xFA, 0x01, 0x3C, 0x99, 0x1E, 0x05, 0x1C, 0x14, 0x26, 0x05, 
/*4450:*/ 0xBC, 0x18, 0x28, 0x05, 0x3C, 0x96, 0x29, 0x05, 0x3C, 0x15, 0x30, 0x05, 0x1C, 0x10, 0x4A, 0x05, 
/*4460:*/ 0x3C, 0x19, 0x4C, 0x05, 0x3C, 0x11, 0x5C, 0x05, 0x3C, 0x10, 0x6A, 0x05, 0x9C, 0x10, 0x7D, 0x05, 
/*4470:*/ 0x9C, 0x1C, 0x8C, 0x05, 0x3C, 0x99, 0x93, 0x05, 0x9C, 0x9E, 0x94, 0x05, 0xBC, 0x9D, 0x9A, 0x05, 
/*4480:*/ 0x1C, 0x10, 0xA3, 0x05, 0x3C, 0x19, 0xA4, 0x05, 0xBC, 0x96, 0xA4, 0x05, 0x1C, 0x95, 0xAA, 0x05, 
/*4490:*/ 0x1C, 0x18, 0xB3, 0x05, 0x3C, 0x11, 0xB4, 0x05, 0xBC, 0x90, 0xB5, 0x05, 0xBC, 0x14, 0xEF, 0x05, 
/*44A0:*/ 0x1C, 0x94, 0xF9, 0x05, 0xBC, 0x1C, 0xFF, 0x05, 0xBC, 0x19, 0x11, 0x09, 0x1C, 0x14, 0x1E, 0x09, 
/*44B0:*/ 0x1C, 0x95, 0x28, 0x09, 0xBC, 0x1D, 0x2F, 0x09, 0x3C, 0x9A, 0x3F, 0x09, 0x3C, 0x96, 0x43, 0x09, 
/*44C0:*/ 0x9C, 0x1D, 0x6B, 0x09, 0x9C, 0x98, 0x8A, 0x09, 0x1C, 0x15, 0x92, 0x09, 0x3C, 0x9C, 0x95, 0x09, 
/*44D0:*/ 0x9C, 0x90, 0x9B, 0x09, 0xBC, 0x1D, 0xA3, 0x09, 0x3C, 0x14, 0xB3, 0x09, 0x3C, 0x10, 0xBB, 0x09, 
/*44E0:*/ 0x3C, 0x9D, 0xC6, 0x09, 0x3C, 0x96, 0xCE, 0x09, 0x3C, 0x9E, 0xDE, 0x09, 0x1C, 0x9E, 0xFE, 0x09, 
/*44F0:*/ 0x1C, 0x14, 0x05, 0x0C, 0x1C, 0x18, 0x1A, 0x0D, 0x1C, 0x16, 0x1B, 0x0D, 0x3C, 0x91, 0x78, 0x0D, 
/*4500:*/ 0x1C, 0x10, 0x87, 0x0D, 0x9C, 0x14, 0x8E, 0x0D, 0x9C, 0x94, 0x8E, 0x0D, 0x9C, 0x9C, 0x9E, 0x0D, 
/*4510:*/ 0x1C, 0x96, 0xA1, 0x0D, 0x3C, 0x10, 0xA6, 0x0D, 0x1C, 0x1C, 0xA8, 0x0D, 0x9C, 0x1C, 0xA9, 0x0D, 
/*4520:*/ 0x3C, 0x9C, 0xBF, 0x0D, 0xBC, 0x11, 0xC3, 0x0D, 0x1C, 0x98, 0xC5, 0x0D, 0x1C, 0x99, 0xC5, 0x0D, 
/*4530:*/ 0xBC, 0x19, 0xD3, 0x0D, 0x1C, 0x9A, 0xDD, 0x0D, 0x9C, 0x11, 0xE3, 0x0D, 0x3C, 0x96, 0xE4, 0x0D, 
/*4540:*/ 0xBC, 0x15, 0xFD, 0x0D, 0xBC, 0x10, 0x0D, 0x81, 0x3C, 0x1D, 0x14, 0x81, 0x3C, 0x16, 0x4F, 0x81, 
/*4550:*/ 0x1C, 0x96, 0x58, 0x81, 0x9C, 0x97, 0x58, 0x81, 0x9C, 0x98, 0x86, 0x81, 0xBC, 0x19, 0x90, 0x81, 
/*4560:*/ 0x3C, 0x96, 0xA7, 0x81, 0x3C, 0x98, 0xA7, 0x81, 0xBC, 0x98, 0xA7, 0x81, 0x3C, 0x1D, 0xAF, 0x81, 
/*4570:*/ 0x1C, 0x18, 0xB0, 0x81, 0x1C, 0x19, 0xB1, 0x81, 0x3C, 0x1E, 0xB6, 0x81, 0x3C, 0x95, 0xBF, 0x81, 
/*4580:*/ 0x3C, 0x98, 0xC2, 0x81, 0xBC, 0x18, 0xC3, 0x81, 0x9C, 0x14, 0xCC, 0x81, 0x3C, 0x91, 0xD3, 0x81, 
/*4590:*/ 0xBC, 0x14, 0xDB, 0x81, 0x3C, 0x14, 0xEC, 0x81, 0x1C, 0x91, 0x07, 0x85, 0x3C, 0x11, 0x10, 0x85, 
/*45A0:*/ 0x1C, 0x99, 0x16, 0x85, 0xBC, 0x14, 0x2F, 0x85, 0x1C, 0x15, 0x82, 0x85, 0x1C, 0x9C, 0xA5, 0x85, 
/*45B0:*/ 0x9C, 0x14, 0xB4, 0x85, 0x9C, 0x94, 0xB5, 0x85, 0x3C, 0x99, 0xBB, 0x85, 0x1C, 0x10, 0xBD, 0x85, 
/*45C0:*/ 0x9C, 0x11, 0xBD, 0x85, 0x1C, 0x12, 0xC0, 0x85, 0x9C, 0x9C, 0xC1, 0x85, 0x1C, 0x16, 0xC8, 0x85, 
/*45D0:*/ 0x3C, 0x10, 0xCE, 0x85, 0xBC, 0x93, 0xD6, 0x85, 0x3C, 0x16, 0xDE, 0x85, 0x1C, 0x1E, 0xEE, 0x85, 
/*45E0:*/ 0x1C, 0x9C, 0xF7, 0x85, 0xBC, 0x98, 0x6D, 0x88, 0x1C, 0x9A, 0x37, 0x89, 0x1C, 0x91, 0x3F, 0x89, 
/*45F0:*/ 0x3C, 0x1D, 0x54, 0x89, 0x1C, 0x15, 0x64, 0x89, 0x3C, 0x9A, 0x73, 0x89, 0x3C, 0x91, 0x7A, 0x89, 
/*4600:*/ 0x9C, 0x9A, 0x8C, 0x89, 0x9C, 0x19, 0xA3, 0x89, 0x3C, 0x11, 0xA4, 0x89, 0x3C, 0x90, 0xA5, 0x89, 
/*4610:*/ 0x3C, 0x11, 0xC0, 0x89, 0x1C, 0x99, 0xC7, 0x89, 0x3C, 0x14, 0xC8, 0x89, 0x1C, 0x10, 0xD7, 0x89, 
/*4620:*/ 0x3C, 0x18, 0xE6, 0x89, 0xBC, 0x18, 0xE6, 0x89, 0x1C, 0x14, 0xE8, 0x89, 0xBC, 0x9D, 0xEE, 0x89, 
/*4630:*/ 0x1C, 0x94, 0x7E, 0x8C, 0x3C, 0x9E, 0x02, 0x8D, 0x1C, 0x15, 0x2B, 0x8D, 0x3C, 0x19, 0x40, 0x8D, 
/*4640:*/ 0x1C, 0x1C, 0x5E, 0x8D, 0x9C, 0x1C, 0x80, 0x8D, 0x1C, 0x92, 0x81, 0x8D, 0x9C, 0x18, 0x89, 0x8D, 
/*4650:*/ 0x9C, 0x15, 0x91, 0x8D, 0x3C, 0x9C, 0x97, 0x8D, 0x9C, 0x14, 0xA6, 0x8D, 0x9C, 0x94, 0xA6, 0x8D, 
/*4660:*/ 0x1C, 0x10, 0xAE, 0x8D, 0x9C, 0x10, 0xAF, 0x8D, 0x9C, 0x1C, 0xB7, 0x8D, 0x3C, 0x9E, 0xB8, 0x8D, 
/*4670:*/ 0x9C, 0x9C, 0xD2, 0x8D, 0x3C, 0x10, 0xDC, 0x8D, 0xBC, 0x9C, 0xF2, 0x8D, 0x0D, 0xF0, 0xAD, 0xBA, 
/*4680:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
/*43F0:*/ 0x1C, 0x18, 0x22, 0x01, 0xBC, 0x1C, 0x3D, 0x01, 0x9C, 0x97, 0x70, 0x01, 0x3C, 0x1E, 0x76, 0x01, 
/*4400:*/ 0x3C, 0x91, 0x76, 0x01, 0x1C, 0x9D, 0x79, 0x01, 0x3C, 0x18, 0x8E, 0x01, 0x9C, 0x1C, 0x90, 0x01, 
/*4410:*/ 0x1C, 0x98, 0x99, 0x01, 0xBC, 0x9C, 0xB0, 0x01, 0x3C, 0x92, 0xB1, 0x01, 0x1C, 0x1A, 0xB6, 0x01, 
/*4420:*/ 0x3C, 0x15, 0xC5, 0x01, 0x3C, 0x95, 0xC5, 0x01, 0x9C, 0x94, 0xD3, 0x01, 0x3C, 0x92, 0xD4, 0x01, 
/*4430:*/ 0x3C, 0x18, 0xDD, 0x01, 0x3C, 0x12, 0xE2, 0x01, 0xBC, 0x1C, 0xE2, 0x01, 0x3C, 0x1D, 0xE3, 0x01, 
/*4440:*/ 0x1C, 0x9D, 0xF5, 0x01, 0x3C, 0x11, 0xFA, 0x01, 0x3C, 0x99, 0x1E, 0x05, 0x1C, 0x14, 0x26, 0x05, 
/*4450:*/ 0xBC, 0x18, 0x28, 0x05, 0x3C, 0x96, 0x29, 0x05, 0x3C, 0x15, 0x30, 0x05, 0x1C, 0x10, 0x4A, 0x05, 
/*4460:*/ 0x3C, 0x19, 0x4C, 0x05, 0x3C, 0x11, 0x5C, 0x05, 0x3C, 0x10, 0x6A, 0x05, 0x9C, 0x10, 0x7D, 0x05, 
/*4470:*/ 0x9C, 0x1C, 0x8C, 0x05, 0x3C, 0x99, 0x93, 0x05, 0x9C, 0x9E, 0x94, 0x05, 0xBC, 0x9D, 0x9A, 0x05, 
/*4480:*/ 0x1C, 0x10, 0xA3, 0x05, 0x3C, 0x19, 0xA4, 0x05, 0xBC, 0x96, 0xA4, 0x05, 0x1C, 0x95, 0xAA, 0x05, 
/*4490:*/ 0x1C, 0x18, 0xB3, 0x05, 0x3C, 0x11, 0xB4, 0x05, 0xBC, 0x90, 0xB5, 0x05, 0xBC, 0x14, 0xEF, 0x05, 
/*44A0:*/ 0x1C, 0x94, 0xF9, 0x05, 0xBC, 0x1C, 0xFF, 0x05, 0xBC, 0x19, 0x11, 0x09, 0x1C, 0x14, 0x1E, 0x09, 
/*44B0:*/ 0x1C, 0x95, 0x28, 0x09, 0xBC, 0x1D, 0x2F, 0x09, 0x3C, 0x9A, 0x3F, 0x09, 0x3C, 0x96, 0x43, 0x09, 
/*44C0:*/ 0x9C, 0x1D, 0x6B, 0x09, 0x9C, 0x98, 0x8A, 0x09, 0x1C, 0x15, 0x92, 0x09, 0x3C, 0x9C, 0x95, 0x09, 
/*44D0:*/ 0x9C, 0x90, 0x9B, 0x09, 0xBC, 0x1D, 0xA3, 0x09, 0x3C, 0x14, 0xB3, 0x09, 0x3C, 0x10, 0xBB, 0x09, 
/*44E0:*/ 0x3C, 0x9D, 0xC6, 0x09, 0x3C, 0x96, 0xCE, 0x09, 0x3C, 0x9E, 0xDE, 0x09, 0x1C, 0x9E, 0xFE, 0x09, 
/*44F0:*/ 0x1C, 0x14, 0x05, 0x0C, 0x1C, 0x18, 0x1A, 0x0D, 0x1C, 0x16, 0x1B, 0x0D, 0x3C, 0x91, 0x78, 0x0D, 
/*4500:*/ 0x1C, 0x10, 0x87, 0x0D, 0x9C, 0x14, 0x8E, 0x0D, 0x9C, 0x94, 0x8E, 0x0D, 0x9C, 0x9C, 0x9E, 0x0D, 
/*4510:*/ 0x1C, 0x96, 0xA1, 0x0D, 0x3C, 0x10, 0xA6, 0x0D, 0x1C, 0x1C, 0xA8, 0x0D, 0x9C, 0x1C, 0xA9, 0x0D, 
/*4520:*/ 0x3C, 0x9C, 0xBF, 0x0D, 0xBC, 0x11, 0xC3, 0x0D, 0x1C, 0x98, 0xC5, 0x0D, 0x1C, 0x99, 0xC5, 0x0D, 
/*4530:*/ 0xBC, 0x19, 0xD3, 0x0D, 0x1C, 0x9A, 0xDD, 0x0D, 0x9C, 0x11, 0xE3, 0x0D, 0x3C, 0x96, 0xE4, 0x0D, 
/*4540:*/ 0xBC, 0x15, 0xFD, 0x0D, 0xBC, 0x10, 0x0D, 0x81, 0x3C, 0x1D, 0x14, 0x81, 0x3C, 0x16, 0x4F, 0x81, 
/*4550:*/ 0x1C, 0x96, 0x58, 0x81, 0x9C, 0x97, 0x58, 0x81, 0x9C, 0x98, 0x86, 0x81, 0xBC, 0x19, 0x90, 0x81, 
/*4560:*/ 0x3C, 0x96, 0xA7, 0x81, 0x3C, 0x98, 0xA7, 0x81, 0xBC, 0x98, 0xA7, 0x81, 0x3C, 0x1D, 0xAF, 0x81, 
/*4570:*/ 0x1C, 0x18, 0xB0, 0x81, 0x1C, 0x19, 0xB1, 0x81, 0x3C, 0x1E, 0xB6, 0x81, 0x3C, 0x95, 0xBF, 0x81, 
/*4580:*/ 0x3C, 0x98, 0xC2, 0x81, 0xBC, 0x18, 0xC3, 0x81, 0x9C, 0x14, 0xCC, 0x81, 0x3C, 0x91, 0xD3, 0x81, 
/*4590:*/ 0xBC, 0x14, 0xDB, 0x81, 0x3C, 0x14, 0xEC, 0x81, 0x1C, 0x91, 0x07, 0x85, 0x3C, 0x11, 0x10, 0x85, 
/*45A0:*/ 0x1C, 0x99, 0x16, 0x85, 0xBC, 0x14, 0x2F, 0x85, 0x1C, 0x15, 0x82, 0x85, 0x1C, 0x9C, 0xA5, 0x85, 
/*45B0:*/ 0x9C, 0x14, 0xB4, 0x85, 0x9C, 0x94, 0xB5, 0x85, 0x3C, 0x99, 0xBB, 0x85, 0x1C, 0x10, 0xBD, 0x85, 
/*45C0:*/ 0x9C, 0x11, 0xBD, 0x85, 0x1C, 0x12, 0xC0, 0x85, 0x9C, 0x9C, 0xC1, 0x85, 0x1C, 0x16, 0xC8, 0x85, 
/*45D0:*/ 0x3C, 0x10, 0xCE, 0x85, 0xBC, 0x93, 0xD6, 0x85, 0x3C, 0x16, 0xDE, 0x85, 0x1C, 0x1E, 0xEE, 0x85, 
/*45E0:*/ 0x1C, 0x9C, 0xF7, 0x85, 0xBC, 0x98, 0x6D, 0x88, 0x1C, 0x9A, 0x37, 0x89, 0x1C, 0x91, 0x3F, 0x89, 
/*45F0:*/ 0x3C, 0x1D, 0x54, 0x89, 0x1C, 0x15, 0x64, 0x89, 0x3C, 0x9A, 0x73, 0x89, 0x3C, 0x91, 0x7A, 0x89, 
/*4600:*/ 0x9C, 0x9A, 0x8C, 0x89, 0x9C, 0x19, 0xA3, 0x89, 0x3C, 0x11, 0xA4, 0x89, 0x3C, 0x90, 0xA5, 0x89, 
/*4610:*/ 0x3C, 0x11, 0xC0, 0x89, 0x1C, 0x99, 0xC7, 0x89, 0x3C, 0x14, 0xC8, 0x89, 0x1C, 0x10, 0xD7, 0x89, 
/*4620:*/ 0x3C, 0x18, 0xE6, 0x89, 0xBC, 0x18, 0xE6, 0x89, 0x1C, 0x14, 0xE8, 0x89, 0xBC, 0x9D, 0xEE, 0x89, 
/*4630:*/ 0x1C, 0x94, 0x7E, 0x8C, 0x3C, 0x9E, 0x02, 0x8D, 0x1C, 0x15, 0x2B, 0x8D, 0x3C, 0x19, 0x40, 0x8D, 
/*4640:*/ 0x1C, 0x1C, 0x5E, 0x8D, 0x9C, 0x1C, 0x80, 0x8D, 0x1C, 0x92, 0x81, 0x8D, 0x9C, 0x18, 0x89, 0x8D, 
/*4650:*/ 0x9C, 0x15, 0x91, 0x8D, 0x3C, 0x9C, 0x97, 0x8D, 0x9C, 0x14, 0xA6, 0x8D, 0x9C, 0x94, 0xA6, 0x8D, 
/*4660:*/ 0x1C, 0x10, 0xAE, 0x8D, 0x9C, 0x10, 0xAF, 0x8D, 0x9C, 0x1C, 0xB7, 0x8D, 0x3C, 0x9E, 0xB8, 0x8D, 
/*4670:*/ 0x9C, 0x9C, 0xD2, 0x8D, 0x3C, 0x10, 0xDC, 0x8D, 0xBC, 0x9C, 0xF2, 0x8D, 0x0D, 0xF0, 0xAD, 0xBA, 
/*4680:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B3D2_F[] = {
/*4CB0:*/ 0x65, 0x80, 0x04, 0x48, 0x65, 0x09, 0x05, 0x48, 0x4F, 0x8B, 0x06, 0x48, 0x67, 0x0E, 0x09, 0x48, 
/*4CC0:*/ 0x4D, 0x07, 0x80, 0x48, 0x4F, 0x88, 0x82, 0x48, 0x6C, 0x84, 0x83, 0x48, 0x4C, 0x02, 0x84, 0x48, 
/*4CD0:*/ 0x4D, 0x8F, 0x86, 0x48, 0x67, 0x86, 0x8B, 0x48, 0x6E, 0x81, 0x8C, 0x48, 0x6C, 0x85, 0x8C, 0x48, 
/*4CE0:*/ 0x67, 0x0E, 0x8D, 0x48, 0x65, 0x0B, 0x8E, 0x48, 0x4F, 0x0A, 0x00, 0x4A, 0x4D, 0x87, 0x05, 0x4A, 
/*4CF0:*/ 0x4C, 0x0A, 0x87, 0x4A, 0x4F, 0x87, 0x01, 0x58, 0x6F, 0x02, 0x02, 0x58, 0x6D, 0x04, 0x05, 0x58, 
/*4D00:*/ 0x6D, 0x8D, 0x08, 0x58, 0x6D, 0x07, 0x09, 0x58, 0x6F, 0x03, 0x0D, 0x58, 0x65, 0x07, 0x81, 0x58, 
/*4D10:*/ 0x4E, 0x80, 0x86, 0x58, 0x65, 0x8E, 0x88, 0x58, 0x6F, 0x8B, 0x8B, 0x58, 0x4F, 0x86, 0x8E, 0x58, 
/*4D20:*/ 0x4F, 0x8C, 0x02, 0x5A, 0x6F, 0x0A, 0x05, 0x5A, 0x6D, 0x0C, 0x06, 0x5A, 0x6F, 0x08, 0x0E, 0x5A, 
/*4D30:*/ 0x4C, 0x8E, 0x86, 0x5A, 0x4D, 0x09, 0x01, 0x68, 0x6F, 0x88, 0x02, 0x68, 0x6F, 0x8B, 0x02, 0x68, 
/*4D40:*/ 0x4D, 0x80, 0x0C, 0x68, 0x6D, 0x8F, 0x0E, 0x68, 0x4D, 0x0A, 0x81, 0x68, 0x4F, 0x0F, 0x82, 0x68, 
/*4D50:*/ 0x6F, 0x02, 0x83, 0x68, 0x4F, 0x86, 0x83, 0x68, 0x6C, 0x02, 0x84, 0x68, 0x44, 0x0D, 0x86, 0x68, 
/*4D60:*/ 0x64, 0x89, 0x86, 0x68, 0x6F, 0x89, 0x89, 0x68, 0x65, 0x04, 0x8C, 0x68, 0x4D, 0x08, 0x8E, 0x68, 
/*4D70:*/ 0x65, 0x8C, 0x8E, 0x68, 0x6D, 0x84, 0x01, 0x6A, 0x46, 0x88, 0x04, 0x6A, 0x6F, 0x80, 0x0D, 0x6A, 
/*4D80:*/ 0x4F, 0x05, 0x0E, 0x6A, 0x4F, 0x06, 0x0E, 0x6A, 0x47, 0x8F, 0x0F, 0x6A, 0x4D, 0x8B, 0x83, 0x6A, 
/*4D90:*/ 0x4E, 0x89, 0x87, 0x6A, 0x45, 0x88, 0x8B, 0x6A, 0x4D, 0x0F, 0x84, 0x6E, 0x6D, 0x08, 0x03, 0x78, 
/*4DA0:*/ 0x4D, 0x8C, 0x03, 0x78, 0x6D, 0x08, 0x0B, 0x78, 0x6F, 0x84, 0x0D, 0x78, 0x6F, 0x87, 0x0D, 0x78, 
/*4DB0:*/ 0x67, 0x86, 0x0E, 0x78, 0x6F, 0x0C, 0x0F, 0x78, 0x4F, 0x88, 0x0F, 0x78, 0x4D, 0x8F, 0x0F, 0x78, 
/*4DC0:*/ 0x47, 0x8A, 0x80, 0x78, 0x6E, 0x80, 0x82, 0x78, 0x67, 0x0E, 0x84, 0x78, 0x4D, 0x05, 0x86, 0x78, 
/*4DD0:*/ 0x6C, 0x0D, 0x87, 0x78, 0x4D, 0x8D, 0x88, 0x78, 0x6D, 0x81, 0x8A, 0x78, 0x45, 0x8C, 0x8B, 0x78, 
/*4DE0:*/ 0x4F, 0x02, 0x8E, 0x78, 0x4F, 0x0B, 0x02, 0x7A, 0x64, 0x8F, 0x05, 0x7A, 0x6F, 0x04, 0x8C, 0x7A, 
/*4DF0:*/ 0x4F, 0x80, 0x8C, 0x7A, 0x6D, 0x0A, 0x08, 0xC8, 0x4F, 0x02, 0x0A, 0xC8, 0x6D, 0x0B, 0x0B, 0xC8, 
/*4E00:*/ 0x6F, 0x0D, 0x0C, 0xC8, 0x6F, 0x0E, 0x0C, 0xC8, 0x4F, 0x00, 0x0D, 0xC8, 0x4F, 0x03, 0x0D, 0xC8, 
/*4E10:*/ 0x4F, 0x89, 0x80, 0xC8, 0x4F, 0x88, 0x83, 0xC8, 0x6E, 0x0B, 0x84, 0xC8, 0x4F, 0x8A, 0x84, 0xC8, 
/*4E20:*/ 0x6C, 0x86, 0x85, 0xC8, 0x65, 0x0A, 0x88, 0xC8, 0x6F, 0x87, 0x89, 0xC8, 0x65, 0x09, 0x8C, 0xC8, 
/*4E30:*/ 0x6D, 0x0A, 0x8C, 0xC8, 0x4E, 0x8F, 0x8C, 0xC8, 0x47, 0x03, 0x8D, 0xC8, 0x6E, 0x81, 0x8D, 0xC8, 
/*4E40:*/ 0x6D, 0x81, 0x8E, 0xC8, 0x4F, 0x80, 0x04, 0xCA, 0x6D, 0x01, 0x0F, 0xCA, 0x4E, 0x0C, 0x81, 0xCA, 
/*4E50:*/ 0x67, 0x04, 0x88, 0xCA, 0x4D, 0x0A, 0x01, 0xD8, 0x6F, 0x88, 0x02, 0xD8, 0x6D, 0x06, 0x03, 0xD8, 
/*4E60:*/ 0x47, 0x0D, 0x05, 0xD8, 0x4F, 0x0E, 0x05, 0xD8, 0x45, 0x81, 0x0B, 0xD8, 0x4E, 0x80, 0x0F, 0xD8, 
/*4E70:*/ 0x6E, 0x04, 0x83, 0xD8, 0x4E, 0x0B, 0x85, 0xD8, 0x6E, 0x8F, 0x85, 0xD8, 0x65, 0x04, 0x8C, 0xD8, 
/*4E80:*/ 0x6F, 0x8A, 0x8D, 0xD8, 0x4F, 0x8E, 0x04, 0xDA, 0x4D, 0x8A, 0x08, 0xDA, 0x47, 0x8C, 0x0F, 0xDA, 
/*4E90:*/ 0x4E, 0x01, 0x81, 0xDA, 0x47, 0x05, 0x8A, 0xDA, 0x6D, 0x0E, 0x8C, 0xDA, 0x4F, 0x87, 0x01, 0xE8, 
/*4EA0:*/ 0x45, 0x0A, 0x04, 0xE8, 0x4D, 0x0A, 0x08, 0xE8, 0x4D, 0x80, 0x09, 0xE8, 0x66, 0x07, 0x0A, 0xE8, 
/*4EB0:*/ 0x45, 0x81, 0x0A, 0xE8, 0x65, 0x8C, 0x0B, 0xE8, 0x4D, 0x0B, 0x0F, 0xE8, 0x4F, 0x0D, 0x80, 0xE8, 
/*4EC0:*/ 0x6E, 0x8C, 0x80, 0xE8, 0x6F, 0x00, 0x81, 0xE8, 0x45, 0x81, 0x82, 0xE8, 0x4F, 0x86, 0x82, 0xE8, 
/*4ED0:*/ 0x4C, 0x0C, 0x84, 0xE8, 0x45, 0x80, 0x85, 0xE8, 0x45, 0x83, 0x85, 0xE8, 0x67, 0x8A, 0x8C, 0xE8, 
/*4EE0:*/ 0x6E, 0x06, 0x8D, 0xE8, 0x45, 0x83, 0x8D, 0xE8, 0x4D, 0x00, 0x04, 0xEA, 0x6D, 0x87, 0x04, 0xEA, 
/*4EF0:*/ 0x4F, 0x8D, 0x05, 0xEA, 0x4D, 0x01, 0x0F, 0xEA, 0x4E, 0x8B, 0x81, 0xEA, 0x65, 0x0C, 0x8A, 0xEA, 
/*4F00:*/ 0x65, 0x86, 0x8B, 0xEA, 0x65, 0x80, 0x04, 0xF8, 0x65, 0x83, 0x04, 0xF8, 0x4F, 0x8A, 0x0D, 0xF8, 
/*4F10:*/ 0x65, 0x09, 0x81, 0xF8, 0x45, 0x8E, 0x81, 0xF8, 0x65, 0x81, 0x83, 0xF8, 0x65, 0x82, 0x83, 0xF8, 
/*4F20:*/ 0x67, 0x85, 0x83, 0xF8, 0x44, 0x02, 0x84, 0xF8, 0x67, 0x0D, 0x85, 0xF8, 0x45, 0x8D, 0x85, 0xF8, 
/*4F30:*/ 0x4E, 0x8D, 0x86, 0xF8, 0x6C, 0x84, 0x87, 0xF8, 0x4D, 0x8C, 0x8A, 0xF8, 0x4D, 0x8F, 0x8A, 0xF8, 
/*4F40:*/ 0x45, 0x05, 0x8B, 0xF8, 0x6D, 0x89, 0x04, 0xFA, 0x65, 0x8A, 0x08, 0xFA, 0x66, 0x02, 0x09, 0xFA, 
/*4F50:*/ 0x47, 0x08, 0x0F, 0xFA, 0x6D, 0x89, 0x8C, 0xFA, 0x6F, 0x08, 0x84, 0xFE, 0x0D, 0xF0, 0xAD, 0xBA, 
/*4F60:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE Block4Data1[] = {
0x91, 0x00, 0x00, 0x00,
0xB9, 0x00, 0x00, 0x00,
0xA3, 0x00, 0x00, 0x00,
0x9D, 0x00, 0x00, 0x00,
0xA4, 0x00, 0x00, 0x00,
0x91, 0x00, 0x00, 0x00,
0x8B, 0x00, 0x00, 0x00,
0xAD, 0x00, 0x00, 0x00,
0x94, 0x00, 0x00, 0x00,
0xC2, 0x00, 0x00, 0x00,
0xB9, 0x00, 0x00, 0x00,
0x9C, 0x00, 0x00, 0x00,
0x96, 0x00, 0x00, 0x00,
0x9B, 0x00, 0x00, 0x00,
0xA3, 0x00, 0x00, 0x00,
0xAB, 0x00, 0x00, 0x00,
};

void* Block4Data2[] = {
	B3D2_0,
	B3D2_1,
	B3D2_2,
	B3D2_3,
	B3D2_4,
	B3D2_5,
	B3D2_6,
	B3D2_7,
	B3D2_8,
	B3D2_9,
	B3D2_A,
	B3D2_B,
	B3D2_C,
	B3D2_D,
	B3D2_E,
	B3D2_F
};

//////////////////////
// block 6
//////////////////////

BYTE B6D2_0[] = {
/*00CC60:*/ 0xA8, 0x21, 0x62, 0x44, 0x70, 0xF3, 0x21, 0x92, 0x7B, 0xF8, 0xDA, 0x1E, 0xB2, 0x0E, 0xC0, 0x25, 
/*00CC70:*/ 0x3B, 0x22, 0x07, 0x87, 0x7B, 0x07, 0x82, 0x94, 0x63, 0xD9, 0xBE, 0x5C, 0x0C, 0x31, 0xB7, 0x7D, 
/*00CC80:*/ 0x1E, 0xE6, 0x3B, 0xD2, 0x03, 0x02, 0xB4, 0x2D, 0x38, 0x3C, 0x18, 0x72, 0x6E, 0x35, 0xFA, 0x9F, 
/*00CC90:*/ 0xAB, 0xD1, 0xD3, 0x0E, 0xE0, 0x58, 0x7A, 0x6F, 0x5D, 0x65, 0xB5, 0x0A, 0x72, 0x38, 0xA6, 0x78, 
/*00CCA0:*/ 0xC8, 0xF7, 0x44, 0xFE, 0xB5, 0x99, 0x8F, 0xB7, 0x2D, 0x4B, 0xA5, 0x82, 0xE6, 0xB0, 0xC1, 0x6B, 
/*00CCB0:*/ 0xDE, 0x02, 0x1C, 0xBD, 0x34, 0x33, 0xF7, 0x21, 0x2D, 0x4B, 0xA5, 0x82, 0x8E, 0xB3, 0xD6, 0xCA, 
/*00CCC0:*/ 0x6E, 0xA1, 0xEE, 0x7C, 0x0B, 0x91, 0x90, 0x54, 0xE4, 0x75, 0xCD, 0x29, 0x24, 0x0B, 0x90, 0xBC, 
/*00CCD0:*/ 0x29, 0x78, 0x60, 0x9B, 0x31, 0xDB, 0xF4, 0x11, 0x3F, 0x86, 0x27, 0xB9, 0xC0, 0x94, 0x54, 0xC9, 
/*00CCE0:*/ 0x8F, 0x08, 0x7C, 0x84, 0x1E, 0xAA, 0x3D, 0x3F, 0x3C, 0x6C, 0xB3, 0x5F, 0x3F, 0x86, 0x27, 0xB9, 
/*00CCF0:*/ 0x38, 0x3C, 0x18, 0x72, 0x50, 0x45, 0x07, 0xF0, 0x18, 0x3A, 0x8E, 0x81, 0x32, 0x39, 0x17, 0x0C, 
/*00CD00:*/ 0xD7, 0xAB, 0xF5, 0x95, 0x12, 0xD1, 0x59, 0x1B, 0x57, 0x89, 0xDA, 0xB2, 0x84, 0x8E, 0xCA, 0xB6, 
/*00CD10:*/ 0xDD, 0x87, 0x4E, 0x1D, 0x1E, 0xAA, 0x3D, 0x3F, 0x50, 0xEE, 0xF3, 0x99, 0xD1, 0xC9, 0xD0, 0x2E, 
/*00CD20:*/ 0x55, 0xAF, 0xCB, 0x7D, 0xC9, 0x9A, 0xC6, 0xDD, 0x3D, 0x76, 0x22, 0xB1, 0x30, 0xC5, 0x0D, 0x6C, 
/*00CD30:*/ 0xC9, 0x17, 0xFF, 0x0E, 0x3B, 0x5C, 0x56, 0x54, 0xD2, 0x1D, 0x28, 0xFD, 0x88, 0x59, 0xC4, 0x4D, 
/*00CD40:*/ 0x3E, 0x2C, 0x92, 0xD5, 0x93, 0x60, 0x00, 0x4C, 0xDC, 0xBD, 0x76, 0x19, 0x46, 0xC2, 0x68, 0x74, 
/*00CD50:*/ 0xF9, 0xA8, 0xD0, 0xE2, 0xD8, 0x7C, 0x3C, 0x08, 0x99, 0x7B, 0x6F, 0xC5, 0x3F, 0xF5, 0x3C, 0x3E, 
/*00CD60:*/ 0x78, 0xBE, 0x58, 0x61, 0xBF, 0xB4, 0xD2, 0x8F, 0xA9, 0x86, 0xA4, 0x12, 0x9C, 0xF1, 0x52, 0x83, 
/*00CD70:*/ 0x3A, 0xBA, 0xED, 0xB6, 0x0B, 0x94, 0x45, 0xA7, 0x02, 0x44, 0x8C, 0xB9, 0xC4, 0xC9, 0xED, 0x05, 
/*00CD80:*/ 0xFC, 0x8A, 0x20, 0xF0, 0x0B, 0x91, 0x90, 0x54, 0x69, 0x5E, 0x78, 0x07, 0x4B, 0x70, 0xE9, 0x42, 
/*00CD90:*/ 0xD7, 0xAB, 0xF5, 0x95, 0x43, 0x6C, 0xEF, 0x92, 0xB2, 0x0E, 0xC0, 0x25, 0x3C, 0x6C, 0xB3, 0x5F, 
/*00CDA0:*/ 0x8F, 0x08, 0x7C, 0x84, 0x23, 0xA4, 0x9B, 0x3E, 0xCB, 0x53, 0xD3, 0xFF, 0xA0, 0x18, 0x0B, 0x31, 
/*00CDB0:*/ 0xF0, 0x36, 0x3C, 0x9C, 0x0B, 0xD9, 0x3A, 0x41, 0xB4, 0x69, 0x9F, 0x38, 0x29, 0x78, 0x60, 0x9B, 
/*00CDC0:*/ 0x75, 0x18, 0x6F, 0xB8, 0x4F, 0xA6, 0xC1, 0x11, 0xB4, 0x69, 0x9F, 0x38, 0xA3, 0xAE, 0xC3, 0xFA, 
/*00CDD0:*/ 0x50, 0x45, 0x07, 0xF0, 0xA7, 0x54, 0x4C, 0xAD, 0xC1, 0xF6, 0x2F, 0x66, 0xE0, 0x58, 0x7A, 0x6F, 
/*00CDE0:*/ 0x31, 0xAF, 0x65, 0x25, 0x1B, 0xA6, 0x0E, 0x00, 0x4C, 0x79, 0xC2, 0xEB, 0xA4, 0xCC, 0xA3, 0x0A, 
/*00CDF0:*/ 0x6A, 0xAB, 0x24, 0xB1, 0x7D, 0x8C, 0xFD, 0x17, 0xC6, 0xB3, 0x24, 0x7D, 0x88, 0x5D, 0xD3, 0xB7, 
/*00CE00:*/ 0x06, 0xFD, 0x74, 0x0A, 0xA8, 0x5F, 0xB1, 0x36, 0xFD, 0x2F, 0x14, 0x90, 0x05, 0x6E, 0x54, 0x33, 
/*00CE10:*/ 0x12, 0xE9, 0xB6, 0xBE, 0xE8, 0x2A, 0x38, 0x57, 0x86, 0xBD, 0xE9, 0x78, 0xFC, 0x8A, 0x20, 0xF0, 
/*00CE20:*/ 0x38, 0x6D, 0xFD, 0x2D, 0xA4, 0xCC, 0xA3, 0x0A, 0x7F, 0x7E, 0x86, 0xF1, 0xA8, 0x21, 0x62, 0x44, 
/*00CE30:*/ 0x3E, 0xF1, 0xB5, 0x10, 0x3B, 0x5C, 0x56, 0x54, 0x3E, 0x77, 0xA8, 0x9D, 0x30, 0xD9, 0x62, 0x05, 
/*00CE40:*/ 0xD7, 0xAB, 0xF5, 0x95, 0xFC, 0x8A, 0x20, 0xF0, 0xD5, 0x80, 0xA1, 0x41, 0xDD, 0xB8, 0xF4, 0x8F, 
/*00CE50:*/ 0xF5, 0xF5, 0xB0, 0x30, 0x9C, 0x26, 0xF2, 0x99, 0x75, 0x80, 0x94, 0x83, 0xF6, 0x90, 0xE9, 0xDC, 
/*00CE60:*/ 0x7B, 0x07, 0x82, 0x94, 0x0B, 0x94, 0xDD, 0x44, 0x29, 0x78, 0x60, 0x9B, 0x17, 0x08, 0x0D, 0x3F, 
/*00CE70:*/ 0xBF, 0x9D, 0xDE, 0x0F, 0x55, 0x59, 0xA8, 0xF2, 0x5E, 0x8C, 0x7B, 0xD8, 0xDF, 0xC7, 0x1C, 0x7D, 
/*00CE80:*/ 0xC8, 0xF7, 0x44, 0xFE, 0xDF, 0xC7, 0x1C, 0x7D, 0x77, 0xA4, 0xCE, 0x28, 0xF3, 0x37, 0xA7, 0x4A, 
/*00CE90:*/ 0xAC, 0xD9, 0x82, 0x35, 0x16, 0x42, 0x66, 0x51, 0x42, 0xFA, 0x83, 0x36, 0x55, 0xA1, 0xE1, 0x6B, 
/*00CEA0:*/ 0x70, 0xF3, 0x21, 0x92, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00CEB0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_1[] = {
/*00D4F0:*/ 0x87, 0xE9, 0x8C, 0x3E, 0x0B, 0x91, 0x90, 0x54, 0xAD, 0x45, 0x93, 0x08, 0xA7, 0x54, 0x4C, 0xAD, 
/*00D500:*/ 0xAC, 0xCD, 0x2D, 0x3A, 0x87, 0xA3, 0x0D, 0x5B, 0xB5, 0x0F, 0xE0, 0x5A, 0x4A, 0xEF, 0x3F, 0x65, 
/*00D510:*/ 0x74, 0x48, 0x37, 0x81, 0x22, 0xE4, 0x16, 0xC9, 0x4F, 0xA6, 0xC1, 0x11, 0x53, 0xE5, 0xF5, 0x0D, 
/*00D520:*/ 0xB9, 0xD7, 0x98, 0x99, 0x55, 0xA1, 0xE1, 0x6B, 0xA1, 0x44, 0x3D, 0x80, 0x5B, 0x25, 0xF1, 0x26, 
/*00D530:*/ 0x93, 0x60, 0x00, 0x4C, 0xD7, 0xAB, 0xF5, 0x95, 0x0C, 0x94, 0x6A, 0x6E, 0xAD, 0xBE, 0xFA, 0xE0, 
/*00D540:*/ 0x31, 0xDB, 0xF4, 0x11, 0x77, 0xA4, 0xCE, 0x28, 0x1A, 0x22, 0xCB, 0x38, 0xB9, 0xD8, 0x19, 0x8B, 
/*00D550:*/ 0x3B, 0xE7, 0x29, 0xC7, 0xC9, 0x9A, 0xC6, 0xDD, 0xB9, 0xB0, 0x7A, 0x35, 0x59, 0x72, 0x6E, 0xA4, 
/*00D560:*/ 0x4C, 0x79, 0xC2, 0xEB, 0x44, 0x09, 0xC7, 0xED, 0x44, 0x09, 0xC7, 0xED, 0xE8, 0x83, 0x83, 0x7C, 
/*00D570:*/ 0xAD, 0xD2, 0xB8, 0x48, 0x3F, 0xF5, 0x3C, 0x3E, 0x0B, 0x91, 0x90, 0x54, 0x30, 0x52, 0xB4, 0xEB, 
/*00D580:*/ 0x0B, 0x91, 0x90, 0x54, 0x30, 0x52, 0xB4, 0xEB, 0xAD, 0xBE, 0xFA, 0xE0, 0x01, 0x62, 0x83, 0xE7, 
/*00D590:*/ 0x05, 0x0A, 0xA5, 0xE5, 0x5B, 0x3A, 0xD3, 0x95, 0x0E, 0xFF, 0x87, 0x5A, 0x95, 0xCB, 0x9B, 0xC3, 
/*00D5A0:*/ 0xFC, 0x2C, 0x50, 0x09, 0xC5, 0x3F, 0x56, 0x06, 0x16, 0x31, 0xE8, 0x05, 0xBF, 0xB4, 0xD2, 0x8F, 
/*00D5B0:*/ 0x28, 0x4C, 0x01, 0x90, 0x05, 0x6E, 0x54, 0x33, 0x32, 0x39, 0x17, 0x0C, 0xFC, 0xA4, 0x4A, 0xBD, 
/*00D5C0:*/ 0x91, 0xB3, 0x84, 0xAB, 0xD2, 0x1D, 0x28, 0xFD, 0x58, 0x1F, 0xAC, 0x46, 0xA0, 0x3E, 0xD4, 0xB4, 
/*00D5D0:*/ 0xC8, 0xF7, 0x44, 0xFE, 0x45, 0xCF, 0xD3, 0x8B, 0x04, 0x47, 0x46, 0x11, 0x50, 0xEE, 0xF3, 0x99, 
/*00D5E0:*/ 0x4D, 0x01, 0x6B, 0x7A, 0x16, 0x42, 0x66, 0x51, 0xAE, 0xBA, 0x7D, 0xFF, 0x2D, 0xD1, 0x6B, 0xA4, 
/*00D5F0:*/ 0x22, 0xA7, 0xE7, 0x6E, 0x60, 0x43, 0xCC, 0x0E, 0x74, 0x7A, 0x01, 0x61, 0x52, 0x14, 0xC3, 0xE8, 
/*00D600:*/ 0x5D, 0x65, 0xB5, 0x0A, 0xEC, 0xC6, 0xB5, 0x4C, 0x6F, 0xEE, 0xE7, 0x2D, 0xB2, 0x85, 0x75, 0xC4, 
/*00D610:*/ 0xC9, 0x9A, 0xC6, 0xDD, 0x55, 0xA1, 0xE1, 0x6B, 0x31, 0xEA, 0x4D, 0xAD, 0xBF, 0xB4, 0xD2, 0x8F, 
/*00D620:*/ 0xC9, 0x9A, 0xC6, 0xDD, 0xF0, 0x25, 0xD0, 0x02, 0x57, 0x89, 0xDA, 0xB2, 0x4C, 0x2C, 0x53, 0x9D, 
/*00D630:*/ 0x8D, 0x3B, 0x92, 0xB8, 0x58, 0x1F, 0xAC, 0x46, 0xC8, 0xF7, 0x44, 0xFE, 0x45, 0xCF, 0xD3, 0x8B, 
/*00D640:*/ 0xE2, 0x6D, 0x41, 0xB7, 0xCF, 0x7E, 0x80, 0xB6, 0xA4, 0xCC, 0xA3, 0x0A, 0xE6, 0x05, 0x3C, 0xDF, 
/*00D650:*/ 0xB9, 0xB0, 0x7A, 0x35, 0xFC, 0xB8, 0x3C, 0xEB, 0x7E, 0x03, 0x73, 0x1D, 0xB9, 0xB0, 0x7A, 0x35, 
/*00D660:*/ 0xE0, 0x58, 0x7A, 0x6F, 0xFA, 0xCE, 0xAF, 0xA5, 0x0C, 0x48, 0x3A, 0x3A, 0x3E, 0x77, 0xA8, 0x9D, 
/*00D670:*/ 0xA2, 0xAB, 0xA5, 0xF1, 0x0B, 0x91, 0x90, 0x54, 0xD4, 0xA8, 0xF0, 0xA6, 0x70, 0xF3, 0x21, 0x92, 
/*00D680:*/ 0x53, 0xE5, 0xF5, 0x0D, 0x58, 0x1F, 0xAC, 0x46, 0xC0, 0x94, 0x54, 0xC9, 0x35, 0xC4, 0xB2, 0x1B, 
/*00D690:*/ 0x41, 0x0F, 0x82, 0xFB, 0x7E, 0x03, 0x73, 0x1D, 0xB9, 0xD8, 0x08, 0x6A, 0x34, 0x2E, 0x7D, 0x84, 
/*00D6A0:*/ 0xDF, 0xC7, 0x1C, 0x7D, 0xE6, 0x05, 0x3C, 0xDF, 0x0B, 0x91, 0x90, 0x54, 0x0B, 0xD9, 0x3A, 0x41, 
/*00D6B0:*/ 0x3B, 0xFB, 0x95, 0x81, 0xF7, 0x33, 0x41, 0x1A, 0x76, 0x0E, 0x7F, 0x97, 0x91, 0xAB, 0xA7, 0x58, 
/*00D6C0:*/ 0x69, 0x28, 0xA5, 0xF2, 0x5A, 0x6C, 0x52, 0x04, 0xC8, 0xF7, 0x44, 0xFE, 0x20, 0x2B, 0x8D, 0x19, 
/*00D6D0:*/ 0x15, 0x5D, 0x3E, 0xDE, 0x48, 0x9B, 0x25, 0x2F, 0xD9, 0x27, 0xDA, 0xA5, 0xCF, 0x7E, 0x80, 0xB6, 
/*00D6E0:*/ 0x6C, 0x3C, 0x44, 0x49, 0x1A, 0x22, 0xCB, 0x38, 0xAE, 0xBA, 0x7D, 0xFF, 0xDD, 0xD7, 0x3F, 0x58, 
/*00D6F0:*/ 0x04, 0xEA, 0xA7, 0x28, 0x12, 0xD1, 0x59, 0x1B, 0x7B, 0xF8, 0xDA, 0x1E, 0xD8, 0x7C, 0x3C, 0x08, 
/*00D700:*/ 0xE2, 0x6D, 0x41, 0xB7, 0xF3, 0x37, 0xA7, 0x4A, 0x23, 0xEB, 0x14, 0x0E, 0x45, 0xCF, 0x2B, 0x5E, 
/*00D710:*/ 0xFC, 0xA4, 0x4A, 0xBD, 0xCB, 0xCC, 0xC1, 0xC4, 0x16, 0x42, 0x66, 0x51, 0x22, 0xE4, 0x16, 0xC9, 
/*00D720:*/ 0x7B, 0xF8, 0xDA, 0x1E, 0xAD, 0xC9, 0xB2, 0x04, 0x83, 0xB9, 0x54, 0x82, 0x95, 0xCB, 0x9B, 0xC3, 
/*00D730:*/ 0x4A, 0xDF, 0x4D, 0xF0, 0x20, 0x2B, 0x8D, 0x19, 0x85, 0x5E, 0xED, 0xBB, 0x92, 0x26, 0x3D, 0x12, 
/*00D740:*/ 0x3F, 0xF5, 0x3C, 0x3E, 0x02, 0x44, 0x8C, 0xB9, 0xC4, 0x68, 0xAC, 0x83, 0xC5, 0x21, 0xEF, 0xFE, 
/*00D750:*/ 0x4C, 0x79, 0xC2, 0xEB, 0x8C, 0xBA, 0x04, 0x05, 0x6D, 0x08, 0x98, 0x24, 0x0C, 0x48, 0x3A, 0x3A, 
/*00D760:*/ 0xC3, 0x37, 0xAD, 0x8F, 0x23, 0xA4, 0x9B, 0x3E, 0xE3, 0xA6, 0xD3, 0x18, 0x2F, 0x13, 0xD5, 0xAE, 
/*00D770:*/ 0x30, 0xF7, 0x73, 0xE2, 0x12, 0xE9, 0xB6, 0xBE, 0xA0, 0x4F, 0x6B, 0xA5, 0x74, 0x2F, 0xB8, 0xE3, 
/*00D780:*/ 0x9F, 0x3A, 0xA0, 0xC3, 0x23, 0xA4, 0x9B, 0x3E, 0xE8, 0x83, 0x83, 0x7C, 0x9E, 0xE0, 0xC6, 0x8C, 
/*00D790:*/ 0xC8, 0xF7, 0x44, 0xFE, 0x16, 0xCE, 0xEE, 0xEB, 0x30, 0xC5, 0x0D, 0x6C, 0x52, 0x1B, 0x4B, 0xEE, 
/*00D7A0:*/ 0x88, 0x8D, 0xF5, 0x4B, 0x79, 0xE7, 0x73, 0x3D, 0x92, 0x26, 0x3D, 0x12, 0x12, 0xE9, 0xB6, 0xBE, 
/*00D7B0:*/ 0x48, 0x2F, 0x23, 0x3B, 0x6C, 0x3C, 0x44, 0x49, 0x48, 0xF6, 0x2D, 0x5F, 0xF3, 0x37, 0xA7, 0x4A, 
/*00D7C0:*/ 0x4A, 0xDF, 0x4D, 0xF0, 0x0E, 0xFF, 0x87, 0x5A, 0x9C, 0x26, 0xF2, 0x99, 0x05, 0xAD, 0xAB, 0x34, 
/*00D7D0:*/ 0xD4, 0x56, 0x59, 0x6D, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00D7E0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_2[] = {
/*00DE80:*/ 0x30, 0xC5, 0x0D, 0x6C, 0x5E, 0xAC, 0xB2, 0x86, 0x33, 0xD9, 0x7D, 0xD3, 0x52, 0x1B, 0x4B, 0xEE, 
/*00DE90:*/ 0x22, 0xA2, 0x25, 0xBA, 0xAD, 0x45, 0x93, 0x08, 0x85, 0x9D, 0xF0, 0x35, 0xD2, 0x1D, 0x28, 0xFD, 
/*00DEA0:*/ 0xDD, 0xB8, 0xF4, 0x8F, 0x7A, 0x1A, 0xB6, 0x8B, 0xC2, 0xEF, 0x17, 0x8C, 0x91, 0xB3, 0x84, 0xAB, 
/*00DEB0:*/ 0xA0, 0x4F, 0x6B, 0xA5, 0x00, 0x31, 0x68, 0x11, 0x4C, 0x79, 0xC2, 0xEB, 0x3E, 0x2C, 0x92, 0xD5, 
/*00DEC0:*/ 0x30, 0xC5, 0x0D, 0x6C, 0x95, 0xCB, 0x9B, 0xC3, 0xE6, 0x05, 0x3C, 0xDF, 0xDA, 0x4D, 0x0A, 0x23, 
/*00DED0:*/ 0x06, 0xFF, 0xC3, 0x32, 0xD8, 0x7C, 0x3C, 0x08, 0x30, 0x52, 0xB4, 0xEB, 0xF3, 0x37, 0xA7, 0x4A, 
/*00DEE0:*/ 0x04, 0xDE, 0x4C, 0x7C, 0x18, 0xD8, 0x08, 0x89, 0x50, 0x45, 0x07, 0xF0, 0xE2, 0x6D, 0x41, 0xB7, 
/*00DEF0:*/ 0x58, 0xF3, 0x41, 0xBF, 0x55, 0xA1, 0xE1, 0x6B, 0xFC, 0xB8, 0x3C, 0xEB, 0x28, 0x4C, 0x01, 0x90, 
/*00DF00:*/ 0xD3, 0x37, 0xFF, 0xEE, 0x26, 0xAD, 0xDB, 0x83, 0x87, 0xA3, 0x0D, 0x5B, 0x59, 0x72, 0x6E, 0xA4, 
/*00DF10:*/ 0x93, 0x60, 0x00, 0x4C, 0x0F, 0x10, 0x4F, 0x74, 0x77, 0xF6, 0x5E, 0xC9, 0x48, 0x05, 0x13, 0xBF, 
/*00DF20:*/ 0x76, 0x0E, 0x7F, 0x97, 0xDD, 0x87, 0x4E, 0x1D, 0xE6, 0xC2, 0x63, 0x04, 0xA0, 0x4F, 0x6B, 0xA5, 
/*00DF30:*/ 0x02, 0x44, 0x8C, 0xB9, 0x0C, 0x31, 0xB7, 0x7D, 0x3B, 0x5C, 0x56, 0x54, 0x12, 0x7A, 0x2C, 0xF2, 
/*00DF40:*/ 0x3D, 0x72, 0xD9, 0x4A, 0x1E, 0xE6, 0x3B, 0xD2, 0xE6, 0x1C, 0xB6, 0x87, 0x4B, 0x70, 0xE9, 0x42, 
/*00DF50:*/ 0xCC, 0x79, 0x89, 0x67, 0x05, 0x0A, 0xA5, 0xE5, 0xB2, 0x0E, 0xC0, 0x25, 0x5B, 0x1A, 0x7E, 0x64, 
/*00DF60:*/ 0x9C, 0x08, 0x26, 0xCD, 0xB9, 0xD7, 0x98, 0x99, 0xB2, 0x99, 0xD9, 0x2C, 0xF6, 0x90, 0xE9, 0xDC, 
/*00DF70:*/ 0xDD, 0x61, 0xC6, 0xD6, 0x59, 0xA6, 0x2F, 0x0B, 0x7F, 0x7E, 0x86, 0xF1, 0x43, 0x6C, 0xEF, 0x92, 
/*00DF80:*/ 0x30, 0x52, 0xB4, 0xEB, 0xF4, 0x2A, 0x00, 0x0E, 0xD4, 0x0E, 0x6D, 0x00, 0x9E, 0xE0, 0xC6, 0x8C, 
/*00DF90:*/ 0x7F, 0x7E, 0x86, 0xF1, 0xE8, 0x83, 0x83, 0x7C, 0xC8, 0xF7, 0x44, 0xFE, 0x95, 0xCB, 0x9B, 0xC3, 
/*00DFA0:*/ 0x4D, 0x1E, 0x4D, 0x3C, 0x4D, 0x1E, 0x4D, 0x3C, 0x3B, 0x22, 0x07, 0x87, 0x57, 0x89, 0xDA, 0xB2, 
/*00DFB0:*/ 0x26, 0xF9, 0xB9, 0xC4, 0x51, 0x07, 0x91, 0xBA, 0x3B, 0xFB, 0x95, 0x81, 0x8F, 0x08, 0x7C, 0x84, 
/*00DFC0:*/ 0xCB, 0x41, 0x4C, 0xDA, 0x95, 0xCB, 0x9B, 0xC3, 0xD7, 0xE3, 0xE9, 0x28, 0x1E, 0xAA, 0x3D, 0x3F, 
/*00DFD0:*/ 0x1B, 0xBE, 0xBA, 0x74, 0x8D, 0x09, 0x0F, 0xE5, 0x6A, 0xAB, 0x24, 0xB1, 0x99, 0x45, 0xAA, 0x43, 
/*00DFE0:*/ 0xE2, 0x99, 0xC6, 0x51, 0xAD, 0x45, 0x93, 0x08, 0x1E, 0xAA, 0x3D, 0x3F, 0x9C, 0x26, 0xF2, 0x99, 
/*00DFF0:*/ 0xFC, 0x8A, 0x20, 0xF0, 0xD2, 0x1D, 0x28, 0xFD, 0xC6, 0xB3, 0x24, 0x7D, 0x91, 0xB3, 0x84, 0xAB, 
/*00E000:*/ 0xC2, 0xEF, 0x17, 0x8C, 0x3C, 0x6C, 0xB3, 0x5F, 0x6F, 0xEE, 0xE7, 0x2D, 0x87, 0xA3, 0x0D, 0x5B, 
/*00E010:*/ 0x0C, 0x48, 0x3A, 0x3A, 0x49, 0xE4, 0x72, 0xD0, 0x66, 0x7B, 0xFC, 0x02, 0xD5, 0x80, 0xA1, 0x41, 
/*00E020:*/ 0xA8, 0x21, 0x62, 0x44, 0xFC, 0x8A, 0x20, 0xF0, 0xC3, 0x68, 0x4D, 0xA0, 0x87, 0xA3, 0x0D, 0x5B, 
/*00E030:*/ 0x65, 0xF8, 0xDE, 0x27, 0x6C, 0x4E, 0xC0, 0x23, 0x53, 0xE5, 0xF5, 0x0D, 0x05, 0xAD, 0xAB, 0x34, 
/*00E040:*/ 0xD7, 0x9F, 0x82, 0x50, 0xD4, 0x56, 0x59, 0x6D, 0x9C, 0x26, 0xF2, 0x99, 0x74, 0x2F, 0xB8, 0xE3, 
/*00E050:*/ 0xE9, 0xD6, 0xD1, 0xF2, 0x08, 0xBD, 0xC5, 0x11, 0xDE, 0x02, 0x1C, 0xBD, 0xF5, 0x3F, 0x9F, 0x2A, 
/*00E060:*/ 0xFC, 0xB8, 0x3C, 0xEB, 0x30, 0xF7, 0x73, 0xE2, 0xC2, 0xEF, 0x17, 0x8C, 0x91, 0x24, 0x1D, 0x9F, 
/*00E070:*/ 0x8C, 0xD7, 0x34, 0x6A, 0x9A, 0x17, 0xED, 0x45, 0x4C, 0x79, 0xC2, 0xEB, 0xD4, 0x56, 0x59, 0x6D, 
/*00E080:*/ 0x16, 0xCE, 0xEE, 0xEB, 0x5B, 0x1A, 0x7E, 0x64, 0xA6, 0xAB, 0xA8, 0x1A, 0x82, 0x97, 0x72, 0x52, 
/*00E090:*/ 0x65, 0xF8, 0xDE, 0x27, 0x9D, 0x62, 0x7B, 0x14, 0x63, 0xAE, 0xE3, 0x1C, 0x78, 0xBE, 0x58, 0x61, 
/*00E0A0:*/ 0x60, 0x43, 0xCC, 0x0E, 0x6F, 0x07, 0xE8, 0x61, 0xE2, 0x99, 0xC6, 0x51, 0xC9, 0x17, 0xFF, 0x0E, 
/*00E0B0:*/ 0xE0, 0x9C, 0x6D, 0x48, 0x52, 0xE5, 0x37, 0xD4, 0xE4, 0x75, 0xCD, 0x29, 0xF7, 0x95, 0x36, 0x9E, 
/*00E0C0:*/ 0xFC, 0x2C, 0x50, 0x09, 0xE0, 0x58, 0x7A, 0x6F, 0xE4, 0x4E, 0x30, 0x3A, 0xBF, 0xB4, 0xD2, 0x8F, 
/*00E0D0:*/ 0xCA, 0xE9, 0xF0, 0x51, 0x33, 0xD9, 0x7D, 0xD3, 0xFC, 0xB8, 0x3C, 0xEB, 0xEC, 0x08, 0x7B, 0x79, 
/*00E0E0:*/ 0x92, 0x82, 0xF5, 0xB9, 0x9A, 0x17, 0xED, 0x45, 0xCB, 0x53, 0xD3, 0xFF, 0xCF, 0xC9, 0xD5, 0x98, 
/*00E0F0:*/ 0x37, 0x83, 0x14, 0x26, 0x52, 0x14, 0xC3, 0xE8, 0xEB, 0x76, 0x06, 0x7B, 0xBF, 0xB4, 0xD2, 0x8F, 
/*00E100:*/ 0x8C, 0x7F, 0x26, 0x4A, 0x85, 0x9D, 0xF0, 0x35, 0xB9, 0xB0, 0x7A, 0x35, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00E110:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_3[] = {
/*00E730:*/ 0x15, 0x04, 0x21, 0x64, 0xDD, 0x61, 0xC6, 0xD6, 0xA9, 0x86, 0xA4, 0x12, 0x06, 0xFF, 0xC3, 0x32, 
/*00E740:*/ 0xA0, 0x4F, 0x6B, 0xA5, 0xAD, 0xBE, 0xFA, 0xE0, 0x06, 0x4B, 0xA5, 0x4C, 0xE8, 0x83, 0x83, 0x7C, 
/*00E750:*/ 0x28, 0x4C, 0x01, 0x90, 0xA1, 0xDC, 0x17, 0xE0, 0x2D, 0x75, 0xCC, 0x80, 0x15, 0x5D, 0x3E, 0xDE, 
/*00E760:*/ 0x75, 0x80, 0x94, 0x83, 0xCF, 0x7E, 0x80, 0xB6, 0x11, 0x68, 0xF0, 0x4A, 0xC8, 0xC4, 0xD0, 0xA3, 
/*00E770:*/ 0xFA, 0xCE, 0xAF, 0xA5, 0x85, 0x9D, 0xF0, 0x35, 0x8E, 0x23, 0x09, 0xF3, 0x5D, 0x65, 0xB5, 0x0A, 
/*00E780:*/ 0x89, 0xBB, 0xCE, 0xE7, 0x00, 0xBC, 0x1A, 0xC2, 0xF7, 0x33, 0x41, 0x1A, 0x7E, 0x03, 0x73, 0x1D, 
/*00E790:*/ 0xE2, 0x9F, 0xD6, 0x27, 0x2F, 0x1F, 0xC8, 0xD8, 0xFC, 0x8A, 0x20, 0xF0, 0x69, 0x28, 0xA5, 0xF2, 
/*00E7A0:*/ 0x67, 0x0B, 0x9D, 0x26, 0x43, 0xDF, 0xC5, 0x2E, 0x38, 0x6D, 0xFD, 0x2D, 0x5F, 0xF2, 0xFA, 0xF6, 
/*00E7B0:*/ 0xD8, 0x99, 0x2C, 0xB7, 0x53, 0xE5, 0xF5, 0x0D, 0x38, 0x6D, 0xFD, 0x2D, 0xA4, 0xCC, 0xA3, 0x0A, 
/*00E7C0:*/ 0xAC, 0xD9, 0x20, 0x28, 0xEC, 0x88, 0xC7, 0xDB, 0x63, 0xD9, 0xBE, 0x5C, 0x2B, 0xCE, 0x76, 0xE4, 
/*00E7D0:*/ 0x05, 0xAD, 0xAB, 0x34, 0xBF, 0xB4, 0xD2, 0x8F, 0xD2, 0x1D, 0x28, 0xFD, 0xF5, 0xB7, 0xF4, 0x43, 
/*00E7E0:*/ 0x23, 0xA4, 0x9B, 0x3E, 0x5B, 0x3A, 0xD3, 0x95, 0xE8, 0x83, 0x83, 0x7C, 0x24, 0x0B, 0x90, 0xBC, 
/*00E7F0:*/ 0x28, 0x4C, 0x01, 0x90, 0xC8, 0xF7, 0x44, 0xFE, 0x88, 0x59, 0xC4, 0x4D, 0x0C, 0x31, 0xB7, 0x7D, 
/*00E800:*/ 0x59, 0x03, 0xA8, 0x1A, 0xE3, 0xA6, 0xD3, 0x18, 0x4B, 0x91, 0x59, 0xAA, 0xDF, 0xC7, 0x1C, 0x7D, 
/*00E810:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0x01, 0xD7, 0x5F, 0xC0, 0xE9, 0xD6, 0xD1, 0xF2, 0x08, 0xBD, 0xC5, 0x11, 
/*00E820:*/ 0xEC, 0xC6, 0xB5, 0x4C, 0x05, 0x6E, 0x54, 0x33, 0x28, 0x4C, 0x01, 0x90, 0x50, 0x09, 0xFA, 0x55, 
/*00E830:*/ 0xCE, 0x1C, 0x58, 0x49, 0x00, 0xBC, 0x1A, 0xC2, 0x15, 0x04, 0x21, 0x64, 0x8E, 0x92, 0x63, 0xB0, 
/*00E840:*/ 0x21, 0xD0, 0xE7, 0x04, 0xBC, 0x9B, 0x2F, 0xC1, 0x4D, 0x74, 0xF8, 0x85, 0xFD, 0x70, 0xEB, 0xC1, 
/*00E850:*/ 0x28, 0x4C, 0x01, 0x90, 0x7C, 0x77, 0x4B, 0xD7, 0x70, 0x35, 0xAC, 0xDE, 0xEB, 0x76, 0x06, 0x7B, 
/*00E860:*/ 0x83, 0x55, 0x2F, 0xE2, 0xCB, 0x41, 0x4C, 0xDA, 0xAD, 0xBE, 0xFA, 0xE0, 0x72, 0xCE, 0xA1, 0xE6, 
/*00E870:*/ 0x52, 0x01, 0x30, 0xE2, 0x4A, 0xDF, 0x4D, 0xF0, 0x32, 0xB2, 0x2A, 0xFF, 0x55, 0x59, 0xA8, 0xF2, 
/*00E880:*/ 0xB0, 0xF5, 0x9F, 0x48, 0xD7, 0x9F, 0x82, 0x50, 0x87, 0xA3, 0x0D, 0x5B, 0x10, 0x20, 0x84, 0x97, 
/*00E890:*/ 0x7C, 0xC3, 0x8D, 0xB5, 0x4B, 0x70, 0xE9, 0x42, 0x75, 0x80, 0x94, 0x83, 0x51, 0x07, 0x91, 0xBA, 
/*00E8A0:*/ 0x94, 0xE8, 0xA4, 0xD1, 0x68, 0x0E, 0xC1, 0x03, 0x95, 0xCB, 0x9B, 0xC3, 0x68, 0x36, 0xD9, 0x72, 
/*00E8B0:*/ 0xB9, 0xB0, 0x7A, 0x35, 0x99, 0x45, 0xAA, 0x43, 0xBC, 0x9B, 0x2F, 0xC1, 0x22, 0xE4, 0x16, 0xC9, 
/*00E8C0:*/ 0x9C, 0xF1, 0x52, 0x83, 0xFC, 0xA4, 0x4A, 0xBD, 0xD5, 0x80, 0xA1, 0x41, 0xD9, 0xB8, 0x25, 0xCB, 
/*00E8D0:*/ 0x63, 0xAE, 0xE3, 0x1C, 0x44, 0x09, 0xC7, 0xED, 0x51, 0x07, 0x91, 0xBA, 0xC8, 0xF7, 0x44, 0xFE, 
/*00E8E0:*/ 0x6A, 0xAB, 0x24, 0xB1, 0x75, 0x80, 0x94, 0x83, 0xAD, 0x45, 0x93, 0x08, 0x24, 0x0B, 0x90, 0xBC, 
/*00E8F0:*/ 0x1A, 0xD8, 0xBC, 0x1F, 0x3E, 0x77, 0xA8, 0x9D, 0x3F, 0x86, 0x27, 0xB9, 0xF2, 0xD1, 0x99, 0xBC, 
/*00E900:*/ 0x88, 0x8D, 0xF5, 0x4B, 0x05, 0xAD, 0xAB, 0x34, 0x3B, 0x22, 0x07, 0x87, 0xE8, 0x83, 0x83, 0x7C, 
/*00E910:*/ 0xE0, 0x58, 0x7A, 0x6F, 0xA4, 0xCC, 0xA3, 0x0A, 0xE6, 0x05, 0x3C, 0xDF, 0x44, 0x4C, 0x5D, 0xB4, 
/*00E920:*/ 0x69, 0x28, 0xA5, 0xF2, 0xCE, 0x1C, 0x58, 0x49, 0x38, 0x8D, 0x3D, 0x7F, 0x55, 0xA1, 0xE1, 0x6B, 
/*00E930:*/ 0x59, 0x72, 0x6E, 0xA4, 0xC4, 0x28, 0x18, 0xE6, 0x8E, 0x11, 0x1D, 0xA3, 0x34, 0x2E, 0x7D, 0x84, 
/*00E940:*/ 0x34, 0x2E, 0x7D, 0x84, 0x7E, 0xB6, 0xC1, 0x8E, 0xA7, 0x54, 0x4C, 0xAD, 0xE6, 0x1C, 0xB6, 0x87, 
/*00E950:*/ 0xFD, 0x72, 0xC3, 0xA8, 0x7A, 0x97, 0x8F, 0xDF, 0xCA, 0xE9, 0xF0, 0x51, 0x28, 0x4C, 0x01, 0x90, 
/*00E960:*/ 0x89, 0xBB, 0xCE, 0xE7, 0x35, 0x64, 0xCB, 0xAB, 0x84, 0xE6, 0x91, 0xA6, 0x7E, 0x03, 0x73, 0x1D, 
/*00E970:*/ 0x0A, 0x4A, 0x75, 0x7B, 0xC0, 0x94, 0x54, 0xC9, 0x89, 0xBB, 0xCE, 0xE7, 0xB4, 0x69, 0x9F, 0x38, 
/*00E980:*/ 0x67, 0x0B, 0x9D, 0x26, 0x04, 0xEA, 0xA7, 0x28, 0x52, 0x14, 0xC3, 0xE8, 0x48, 0xF6, 0x2D, 0x5F, 
/*00E990:*/ 0x3F, 0xF5, 0x3C, 0x3E, 0xE6, 0x05, 0x3C, 0xDF, 0xE4, 0x61, 0x1D, 0x38, 0x59, 0x03, 0xA8, 0x1A, 
/*00E9A0:*/ 0x9C, 0x26, 0xF2, 0x99, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00E9B0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_4[] = {
/*00EFC0:*/ 0x9E, 0xE0, 0xC6, 0x8C, 0x33, 0x94, 0x16, 0xD9, 0x8F, 0x08, 0x7C, 0x84, 0x6F, 0x1B, 0x63, 0xB3, 
/*00EFD0:*/ 0xC8, 0xC4, 0xD0, 0xA3, 0xA2, 0x54, 0x67, 0x83, 0x9C, 0x26, 0xF2, 0x99, 0xD8, 0x99, 0x2C, 0xB7, 
/*00EFE0:*/ 0xE6, 0xB0, 0xC1, 0x6B, 0x0C, 0x48, 0x3A, 0x3A, 0x4C, 0x79, 0xC2, 0xEB, 0x85, 0x9D, 0xF0, 0x35, 
/*00EFF0:*/ 0xA0, 0x4F, 0x6B, 0xA5, 0xAD, 0xBE, 0xFA, 0xE0, 0x12, 0xD1, 0x59, 0x1B, 0x3C, 0x6C, 0xB3, 0x5F, 
/*00F000:*/ 0xCF, 0x7E, 0x80, 0xB6, 0x38, 0x6D, 0xFD, 0x2D, 0x65, 0xF8, 0xDE, 0x27, 0xEC, 0xC6, 0xB5, 0x4C, 
/*00F010:*/ 0x48, 0x05, 0x13, 0xBF, 0x15, 0x5D, 0x3E, 0xDE, 0x63, 0xAE, 0xE3, 0x1C, 0x02, 0x44, 0x8C, 0xB9, 
/*00F020:*/ 0x1A, 0x22, 0xCB, 0x38, 0xD4, 0x0E, 0x6D, 0x00, 0x87, 0x35, 0xDF, 0x32, 0x5B, 0x25, 0xF1, 0x26, 
/*00F030:*/ 0xE0, 0x9C, 0x6D, 0x48, 0x9E, 0x3A, 0xCF, 0x5B, 0x59, 0x72, 0x6E, 0xA4, 0x5B, 0x1A, 0x7E, 0x64, 
/*00F040:*/ 0x70, 0x35, 0xAC, 0xDE, 0x01, 0xD7, 0x5F, 0xC0, 0x75, 0x80, 0x94, 0x83, 0xBA, 0x5F, 0x94, 0x98, 
/*00F050:*/ 0xDF, 0xC7, 0x1C, 0x7D, 0x1B, 0xA6, 0x0E, 0x00, 0x86, 0xBD, 0xE9, 0x78, 0x77, 0xA4, 0xCE, 0x28, 
/*00F060:*/ 0x0E, 0xFF, 0x87, 0x5A, 0xF4, 0xE3, 0x73, 0xBE, 0x83, 0xB9, 0x54, 0x82, 0xB2, 0x0E, 0xC0, 0x25, 
/*00F070:*/ 0x7E, 0x03, 0x73, 0x1D, 0x88, 0x8D, 0xF5, 0x4B, 0xC2, 0xEF, 0x17, 0x8C, 0xFC, 0xA4, 0x4A, 0xBD, 
/*00F080:*/ 0xD8, 0x7C, 0x3C, 0x08, 0x33, 0x67, 0x62, 0x42, 0x44, 0x09, 0xC7, 0xED, 0xA8, 0x5F, 0xB1, 0x36, 
/*00F090:*/ 0x0C, 0x48, 0x3A, 0x3A, 0xF2, 0xD1, 0x99, 0xBC, 0xA0, 0x4F, 0x6B, 0xA5, 0x8E, 0xB3, 0xD6, 0xCA, 
/*00F0A0:*/ 0x3D, 0x76, 0x22, 0xB1, 0x34, 0x2E, 0x7D, 0x84, 0x0B, 0x91, 0x90, 0x54, 0x02, 0x6F, 0xC8, 0xEA, 
/*00F0B0:*/ 0x9C, 0x26, 0xF2, 0x99, 0xB6, 0x45, 0x9D, 0x23, 0x16, 0xCE, 0xEE, 0xEB, 0x3B, 0xE7, 0x29, 0xC7, 
/*00F0C0:*/ 0x28, 0x4C, 0x01, 0x90, 0x12, 0xE9, 0xB6, 0xBE, 0xFA, 0xCE, 0xAF, 0xA5, 0x8C, 0xD7, 0x34, 0x6A, 
/*00F0D0:*/ 0x59, 0x03, 0xA8, 0x1A, 0xA9, 0x86, 0xA4, 0x12, 0x24, 0x1A, 0xBF, 0x03, 0xC3, 0x37, 0xAD, 0x8F, 
/*00F0E0:*/ 0x3D, 0x72, 0xD9, 0x4A, 0xD3, 0x81, 0x65, 0xE4, 0xA2, 0x54, 0x67, 0x83, 0x1C, 0xBF, 0x64, 0xE0, 
/*00F0F0:*/ 0x55, 0x59, 0xA8, 0xF2, 0x72, 0xCE, 0xA1, 0xE6, 0x30, 0x52, 0xB4, 0xEB, 0x15, 0x04, 0x21, 0x64, 
/*00F100:*/ 0x34, 0x2E, 0x7D, 0x84, 0x92, 0x26, 0x3D, 0x12, 0x66, 0x7B, 0xFC, 0x02, 0x45, 0xCF, 0xD3, 0x8B, 
/*00F110:*/ 0x53, 0xE5, 0xF5, 0x0D, 0xCC, 0x79, 0x89, 0x67, 0x31, 0xAF, 0x65, 0x25, 0x24, 0x0B, 0x90, 0xBC, 
/*00F120:*/ 0x2D, 0xEA, 0x0D, 0x1D, 0x16, 0xCE, 0xEE, 0xEB, 0x16, 0xCE, 0xEE, 0xEB, 0xC6, 0x71, 0xAD, 0x6F, 
/*00F130:*/ 0x04, 0x47, 0x46, 0x11, 0x0B, 0x91, 0x90, 0x54, 0xD2, 0x1D, 0x28, 0xFD, 0x11, 0x43, 0xBF, 0x52, 
/*00F140:*/ 0x34, 0x2E, 0x7D, 0x84, 0xD7, 0x9F, 0x82, 0x50, 0x0C, 0x48, 0x3A, 0x3A, 0x6C, 0x4E, 0xC0, 0x23, 
/*00F150:*/ 0x22, 0xA2, 0x25, 0xBA, 0x52, 0x01, 0x30, 0xE2, 0x01, 0xFF, 0x73, 0x9C, 0x27, 0xC0, 0xD0, 0x4C, 
/*00F160:*/ 0xE6, 0x1C, 0xB6, 0x87, 0x3D, 0x33, 0x64, 0x8E, 0x01, 0xD7, 0x5F, 0xC0, 0xFC, 0xB8, 0x3C, 0xEB, 
/*00F170:*/ 0x8D, 0xCA, 0x5F, 0x62, 0xF4, 0xE3, 0x73, 0xBE, 0x70, 0x6E, 0x67, 0xDF, 0x16, 0xCE, 0xEE, 0xEB, 
/*00F180:*/ 0x0A, 0x4A, 0x75, 0x7B, 0x59, 0x03, 0xA8, 0x1A, 0x8E, 0x92, 0x63, 0xB0, 0xBD, 0x8A, 0x9F, 0xA9, 
/*00F190:*/ 0x46, 0x7A, 0x21, 0x47, 0x76, 0x0E, 0x7F, 0x97, 0x48, 0x2F, 0x23, 0x3B, 0x88, 0x8D, 0xF5, 0x4B, 
/*00F1A0:*/ 0xD2, 0x93, 0xE6, 0x24, 0xDF, 0xC7, 0x1C, 0x7D, 0x7E, 0xB6, 0xC1, 0x8E, 0xD8, 0x2F, 0x7E, 0xCA, 
/*00F1B0:*/ 0x5F, 0xF2, 0xFA, 0xF6, 0x01, 0x62, 0x83, 0xE7, 0x16, 0xCE, 0xEE, 0xEB, 0x15, 0x5D, 0x3E, 0xDE, 
/*00F1C0:*/ 0x44, 0x09, 0xC7, 0xED, 0xA8, 0x21, 0x62, 0x44, 0x2D, 0xC1, 0xCA, 0x89, 0x63, 0xD9, 0xBE, 0x5C, 
/*00F1D0:*/ 0x0A, 0x4A, 0x75, 0x7B, 0x8D, 0x3B, 0x92, 0xB8, 0x95, 0xCB, 0x9B, 0xC3, 0x9C, 0x9C, 0x45, 0xA8, 
/*00F1E0:*/ 0x53, 0xE5, 0xF5, 0x0D, 0x74, 0x7A, 0x01, 0x61, 0xD0, 0x4A, 0x7A, 0xFE, 0x12, 0x45, 0xB9, 0xF4, 
/*00F1F0:*/ 0x88, 0x5D, 0xD3, 0xB7, 0x78, 0xBE, 0x58, 0x61, 0x7F, 0x7E, 0x86, 0xF1, 0x6C, 0x4E, 0xC0, 0x23, 
/*00F200:*/ 0x02, 0x44, 0x8C, 0xB9, 0x8E, 0xB3, 0xD6, 0xCA, 0x0F, 0x10, 0x4F, 0x74, 0x44, 0x09, 0xC7, 0xED, 
/*00F210:*/ 0x3B, 0x5C, 0x56, 0x54, 0x12, 0x7A, 0x2C, 0xF2, 0x8E, 0x23, 0x09, 0xF3, 0x4F, 0xA6, 0xC1, 0x11, 
/*00F220:*/ 0x9F, 0x3A, 0xA0, 0xC3, 0x05, 0x6E, 0x54, 0x33, 0x0B, 0x91, 0x90, 0x54, 0x3E, 0xF1, 0xB5, 0x10, 
/*00F230:*/ 0x4C, 0x79, 0xC2, 0xEB, 0x85, 0x9D, 0xF0, 0x35, 0xFF, 0x15, 0x89, 0x5E, 0xA4, 0xCC, 0xA3, 0x0A, 
/*00F240:*/ 0x53, 0xE5, 0xF5, 0x0D, 0xF0, 0x36, 0x3C, 0x9C, 0x59, 0x6B, 0x25, 0xE6, 0xDD, 0x61, 0xC6, 0xD6, 
/*00F250:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_5[] = {
/*00F840:*/ 0x3F, 0x71, 0x9A, 0x6A, 0x59, 0xA6, 0x2F, 0x0B, 0x51, 0x07, 0x91, 0xBA, 0x7C, 0xC3, 0x8D, 0xB5, 
/*00F850:*/ 0x8F, 0x08, 0x7C, 0x84, 0xFC, 0xA4, 0x4A, 0xBD, 0x7C, 0xC3, 0x8D, 0xB5, 0x77, 0xF6, 0x5E, 0xC9, 
/*00F860:*/ 0xD8, 0x99, 0x2C, 0xB7, 0x59, 0xA6, 0x2F, 0x0B, 0x8D, 0xCA, 0x5F, 0x62, 0xC0, 0x00, 0x3D, 0xCA, 
/*00F870:*/ 0xE0, 0x58, 0x7A, 0x6F, 0x48, 0x2F, 0x23, 0x3B, 0x05, 0xAD, 0xAB, 0x34, 0xB4, 0x69, 0x9F, 0x38, 
/*00F880:*/ 0xC3, 0x37, 0xAD, 0x8F, 0x17, 0x08, 0x0D, 0x3F, 0xFD, 0x68, 0x02, 0x03, 0x65, 0xF8, 0xDE, 0x27, 
/*00F890:*/ 0xDD, 0x87, 0x4E, 0x1D, 0xDE, 0x02, 0x1C, 0xBD, 0xB4, 0x69, 0x9F, 0x38, 0x2F, 0x13, 0xD5, 0xAE, 
/*00F8A0:*/ 0xAD, 0x45, 0x93, 0x08, 0xA8, 0xB8, 0x38, 0x0A, 0x63, 0xAE, 0xE3, 0x1C, 0x0A, 0x4A, 0x75, 0x7B, 
/*00F8B0:*/ 0x10, 0x20, 0x84, 0x97, 0x55, 0xAF, 0xCB, 0x7D, 0x7E, 0xB6, 0xC1, 0x8E, 0xC0, 0x94, 0x54, 0xC9, 
/*00F8C0:*/ 0x23, 0xA4, 0x9B, 0x3E, 0xBB, 0x4B, 0x29, 0x9F, 0x31, 0xAF, 0x65, 0x25, 0x3B, 0x5C, 0x56, 0x54, 
/*00F8D0:*/ 0xA8, 0x21, 0x62, 0x44, 0xFD, 0x72, 0xC3, 0xA8, 0xD8, 0x2F, 0x7E, 0xCA, 0xC9, 0x17, 0xFF, 0x0E, 
/*00F8E0:*/ 0x70, 0x6E, 0x67, 0xDF, 0x7C, 0x77, 0x4B, 0xD7, 0xDF, 0xC7, 0x1C, 0x7D, 0x51, 0xE1, 0x15, 0xDD, 
/*00F8F0:*/ 0x5B, 0x1A, 0x7E, 0x64, 0xD2, 0x93, 0xE6, 0x24, 0x91, 0xB3, 0x84, 0xAB, 0xF3, 0xF7, 0xB5, 0x7E, 
/*00F900:*/ 0x28, 0x4C, 0x01, 0x90, 0x5F, 0xF2, 0xFA, 0xF6, 0xD9, 0xB8, 0x25, 0xCB, 0x35, 0x64, 0xCB, 0xAB, 
/*00F910:*/ 0x02, 0x44, 0x8C, 0xB9, 0xE6, 0xD3, 0x65, 0xF8, 0x6F, 0xEE, 0xE7, 0x2D, 0x9E, 0xD8, 0xF8, 0x66, 
/*00F920:*/ 0x2F, 0x67, 0xDA, 0xAC, 0x67, 0xA2, 0xA9, 0x96, 0x53, 0xE5, 0xF5, 0x0D, 0x93, 0x60, 0x00, 0x4C, 
/*00F930:*/ 0x3C, 0x6C, 0xB3, 0x5F, 0xA7, 0x54, 0x4C, 0xAD, 0xC4, 0xC9, 0xED, 0x05, 0x55, 0xA1, 0xE1, 0x6B, 
/*00F940:*/ 0x58, 0xF3, 0x41, 0xBF, 0x3B, 0xFB, 0x95, 0x81, 0x04, 0xEA, 0xA7, 0x28, 0x72, 0xCE, 0xA1, 0xE6, 
/*00F950:*/ 0xC8, 0xC4, 0xD0, 0xA3, 0x35, 0xC4, 0xB2, 0x1B, 0x88, 0x5D, 0xD3, 0xB7, 0x4A, 0xDF, 0x4D, 0xF0, 
/*00F960:*/ 0x87, 0xA3, 0x0D, 0x5B, 0xB4, 0x69, 0x9F, 0x38, 0xE6, 0x1C, 0xB6, 0x87, 0x7F, 0x45, 0xF7, 0x36, 
/*00F970:*/ 0x65, 0x1C, 0x74, 0x7F, 0x4C, 0x79, 0xC2, 0xEB, 0x05, 0xAD, 0xAB, 0x34, 0x58, 0xF3, 0x41, 0xBF, 
/*00F980:*/ 0xFD, 0x68, 0x02, 0x03, 0xB0, 0x93, 0x08, 0x65, 0xC3, 0x79, 0x85, 0xAB, 0x15, 0x52, 0x7C, 0xB8, 
/*00F990:*/ 0x3E, 0x2C, 0x92, 0xD5, 0xAD, 0xBE, 0xFA, 0xE0, 0x16, 0x42, 0x66, 0x51, 0x0F, 0x10, 0x4F, 0x74, 
/*00F9A0:*/ 0xA0, 0xAF, 0xBB, 0xFC, 0x95, 0xCB, 0x9B, 0xC3, 0x1E, 0xAA, 0x3D, 0x3F, 0xD3, 0x37, 0xFF, 0xEE, 
/*00F9B0:*/ 0x57, 0x89, 0xDA, 0xB2, 0xEF, 0x02, 0xF1, 0x1F, 0x5D, 0x65, 0xB5, 0x0A, 0x01, 0xD7, 0x5F, 0xC0, 
/*00F9C0:*/ 0xC8, 0xC4, 0xD0, 0xA3, 0x82, 0x97, 0x72, 0x52, 0x69, 0x28, 0xA5, 0xF2, 0x7C, 0x72, 0x7A, 0xCD, 
/*00F9D0:*/ 0x1A, 0x22, 0xCB, 0x38, 0xB4, 0x1E, 0x49, 0xD5, 0xF4, 0x60, 0xD8, 0x66, 0x63, 0xD9, 0xBE, 0x5C, 
/*00F9E0:*/ 0xF3, 0xF7, 0xB5, 0x7E, 0x04, 0x47, 0x46, 0x11, 0x8E, 0x11, 0x1D, 0xA3, 0x04, 0xEA, 0xA7, 0x28, 
/*00F9F0:*/ 0x03, 0x59, 0x9A, 0x4E, 0x9E, 0xE0, 0xC6, 0x8C, 0x1A, 0x22, 0xCB, 0x38, 0x31, 0xDB, 0xF4, 0x11, 
/*00FA00:*/ 0xD2, 0x1D, 0x28, 0xFD, 0xBF, 0xB4, 0xD2, 0x8F, 0xA0, 0x4F, 0x6B, 0xA5, 0x48, 0x05, 0x13, 0xBF, 
/*00FA10:*/ 0x93, 0x60, 0x00, 0x4C, 0x9C, 0xF1, 0x52, 0x83, 0xE3, 0xA9, 0xC2, 0xC3, 0xD4, 0x56, 0x59, 0x6D, 
/*00FA20:*/ 0x83, 0x55, 0x2F, 0xE2, 0xDD, 0x61, 0xC6, 0xD6, 0xD8, 0x7C, 0x3C, 0x08, 0x4F, 0xA6, 0xC1, 0x11, 
/*00FA30:*/ 0xB2, 0x0E, 0xC0, 0x25, 0x0B, 0x91, 0x90, 0x54, 0x0B, 0xD9, 0x3A, 0x41, 0x2F, 0x13, 0xD5, 0xAE, 
/*00FA40:*/ 0x4F, 0xA6, 0xC1, 0x11, 0x57, 0xB3, 0xF9, 0x8C, 0x5A, 0x4A, 0x0B, 0x7B, 0xEC, 0x88, 0xC7, 0xDB, 
/*00FA50:*/ 0x65, 0xF8, 0xDE, 0x27, 0xAD, 0x45, 0x93, 0x08, 0x76, 0x0E, 0x7F, 0x97, 0x4F, 0xA6, 0xC1, 0x11, 
/*00FA60:*/ 0x9E, 0xBD, 0x9F, 0x16, 0xC0, 0x94, 0x54, 0xC9, 0x5D, 0xB1, 0xE3, 0x15, 0x6F, 0xEE, 0xE7, 0x2D, 
/*00FA70:*/ 0xD2, 0x1D, 0x28, 0xFD, 0x35, 0x64, 0xCB, 0xAB, 0x3E, 0x77, 0xA8, 0x9D, 0x40, 0xB3, 0x1B, 0x9E, 
/*00FA80:*/ 0xE0, 0x58, 0x7A, 0x6F, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00FA90:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_6[] = {
/*0290:*/ 0x9A, 0x45, 0xD2, 0xAA, 0x9E, 0x3A, 0xCF, 0x5B, 0xC6, 0x71, 0xAD, 0x6F, 0x58, 0x1F, 0xAC, 0x46, 
/*02A0:*/ 0x5A, 0x87, 0x35, 0x2F, 0x15, 0x5D, 0x3E, 0xDE, 0x23, 0xA4, 0x9B, 0x3E, 0xD2, 0x1D, 0x28, 0xFD, 
/*02B0:*/ 0xE0, 0x9C, 0x6D, 0x48, 0x63, 0x8F, 0xBC, 0x37, 0x31, 0xDB, 0xF4, 0x11, 0xC4, 0x28, 0x18, 0xE6, 
/*02C0:*/ 0x59, 0x72, 0x6E, 0xA4, 0x38, 0x3C, 0x18, 0x72, 0x34, 0x2E, 0x7D, 0x84, 0xA8, 0xB8, 0x38, 0x0A, 
/*02D0:*/ 0x6C, 0x3C, 0x44, 0x49, 0xC5, 0x0F, 0xC0, 0xC6, 0x53, 0x69, 0x4A, 0xC8, 0xC1, 0xF6, 0x2F, 0x66, 
/*02E0:*/ 0x9E, 0xE0, 0xC6, 0x8C, 0xF4, 0x60, 0xD8, 0x66, 0x9C, 0x26, 0xF2, 0x99, 0x04, 0xEA, 0xA7, 0x28, 
/*02F0:*/ 0x55, 0x59, 0xA8, 0xF2, 0x04, 0x47, 0x46, 0x11, 0x0F, 0x10, 0x4F, 0x74, 0x3E, 0x77, 0xA8, 0x9D, 
/*0300:*/ 0x72, 0x38, 0xA6, 0x78, 0x44, 0x09, 0xC7, 0xED, 0xC5, 0x0F, 0xC0, 0xC6, 0x64, 0xA6, 0xD4, 0xF0, 
/*0310:*/ 0xF6, 0x19, 0x5C, 0x46, 0xF4, 0x2A, 0x00, 0x0E, 0x53, 0xE5, 0xF5, 0x0D, 0xF4, 0x2A, 0x00, 0x0E, 
/*0320:*/ 0x7B, 0xF8, 0xDA, 0x1E, 0x72, 0xCE, 0xA1, 0xE6, 0x20, 0x2B, 0x8D, 0x19, 0xC9, 0x17, 0xFF, 0x0E, 
/*0330:*/ 0xE8, 0x83, 0x83, 0x7C, 0x4F, 0xA6, 0xC1, 0x11, 0x3E, 0x77, 0xA8, 0x9D, 0x88, 0x5D, 0xD3, 0xB7, 
/*0340:*/ 0xBD, 0x8A, 0x9F, 0xA9, 0xAD, 0x45, 0x93, 0x08, 0x4B, 0x70, 0xE9, 0x42, 0x72, 0xCE, 0xA1, 0xE6, 
/*0350:*/ 0xB9, 0xB0, 0x7A, 0x35, 0x78, 0xBE, 0x58, 0x61, 0x01, 0xD7, 0x5F, 0xC0, 0x48, 0xF6, 0x2D, 0x5F, 
/*0360:*/ 0xE0, 0x58, 0x7A, 0x6F, 0x91, 0x24, 0x1D, 0x9F, 0xE6, 0x1C, 0xB6, 0x87, 0x5B, 0x3A, 0xD3, 0x95, 
/*0370:*/ 0x25, 0x32, 0x51, 0x73, 0x05, 0xB0, 0x7F, 0x45, 0xF6, 0x90, 0xE9, 0xDC, 0x06, 0xFD, 0x74, 0x0A, 
/*0380:*/ 0x95, 0xCB, 0x9B, 0xC3, 0x12, 0x7A, 0x2C, 0xF2, 0xD2, 0x1D, 0x28, 0xFD, 0x05, 0xAD, 0xAB, 0x34, 
/*0390:*/ 0x22, 0xE4, 0x16, 0xC9, 0x4B, 0x91, 0x59, 0xAA, 0x6C, 0x4E, 0xC0, 0x23, 0x59, 0x6B, 0x25, 0xE6, 
/*03A0:*/ 0x91, 0x24, 0x1D, 0x9F, 0xC0, 0xA2, 0x3F, 0xEA, 0x85, 0x9D, 0xF0, 0x35, 0x12, 0x45, 0xB9, 0xF4, 
/*03B0:*/ 0x94, 0xE8, 0xA4, 0xD1, 0x17, 0x08, 0x0D, 0x3F, 0xF5, 0xF5, 0xB0, 0x30, 0x4C, 0x03, 0x12, 0x32, 
/*03C0:*/ 0xE6, 0xD3, 0x65, 0xF8, 0xE4, 0x75, 0xCD, 0x29, 0x0C, 0x48, 0x3A, 0x3A, 0x5B, 0x1A, 0x7E, 0x64, 
/*03D0:*/ 0x84, 0xE6, 0x91, 0xA6, 0x32, 0x39, 0x17, 0x0C, 0x0C, 0x48, 0x3A, 0x3A, 0xCF, 0xC9, 0xD5, 0x98, 
/*03E0:*/ 0xE8, 0x83, 0x83, 0x7C, 0xD8, 0x7C, 0x3C, 0x08, 0x19, 0x76, 0xC1, 0xDE, 0x3F, 0x17, 0x18, 0xCB, 
/*03F0:*/ 0x3C, 0x6C, 0xB3, 0x5F, 0xC6, 0x71, 0xAD, 0x6F, 0x70, 0x35, 0xAC, 0xDE, 0x84, 0xE6, 0x91, 0xA6, 
/*0400:*/ 0x02, 0x44, 0x8C, 0xB9, 0x34, 0x2E, 0x7D, 0x84, 0xE5, 0x0C, 0x47, 0x24, 0xE4, 0x4E, 0x30, 0x3A, 
/*0410:*/ 0x35, 0xC4, 0xB2, 0x1B, 0xF5, 0xB7, 0xF4, 0x43, 0x8E, 0x92, 0x63, 0xB0, 0xF0, 0x25, 0xD0, 0x02, 
/*0420:*/ 0xE0, 0x9C, 0x6D, 0x48, 0xC8, 0xF7, 0x44, 0xFE, 0x6A, 0xAB, 0x24, 0xB1, 0x1E, 0xAA, 0x3D, 0x3F, 
/*0430:*/ 0x7C, 0x77, 0x4B, 0xD7, 0xF2, 0xD1, 0x99, 0xBC, 0xFC, 0xB8, 0x3C, 0xEB, 0xE2, 0x6D, 0x41, 0xB7, 
/*0440:*/ 0x88, 0x59, 0xC4, 0x4D, 0x65, 0xF8, 0xDE, 0x27, 0x0B, 0xD9, 0x3A, 0x41, 0x30, 0x52, 0xB4, 0xEB, 
/*0450:*/ 0xAC, 0xD9, 0x82, 0x35, 0xD5, 0x80, 0xA1, 0x41, 0x04, 0xEA, 0xA7, 0x28, 0x69, 0x28, 0xA5, 0xF2, 
/*0460:*/ 0x24, 0x0B, 0x90, 0xBC, 0x38, 0x3C, 0x18, 0x72, 0x55, 0xAF, 0xCB, 0x7D, 0x8C, 0x7F, 0x26, 0x4A, 
/*0470:*/ 0x6C, 0xD3, 0xE5, 0x55, 0xC5, 0x21, 0xEF, 0xFE, 0xD5, 0x80, 0xA1, 0x41, 0x6D, 0x08, 0x98, 0x24, 
/*0480:*/ 0xDF, 0xC7, 0x1C, 0x7D, 0xAD, 0xBE, 0xFA, 0xE0, 0x32, 0x39, 0x17, 0x0C, 0xE6, 0x05, 0x3C, 0xDF, 
/*0490:*/ 0xCF, 0x7E, 0x80, 0xB6, 0x28, 0x4C, 0x01, 0x90, 0xCC, 0x79, 0x89, 0x67, 0xB2, 0x0E, 0xC0, 0x25, 
/*04A0:*/ 0x8E, 0x92, 0x63, 0xB0, 0x12, 0xD1, 0x59, 0x1B, 0x8D, 0xCA, 0x5F, 0x62, 0xDC, 0xBD, 0x76, 0x19, 
/*04B0:*/ 0x94, 0xAC, 0xDE, 0xF1, 0x03, 0x02, 0xB4, 0x2D, 0x58, 0xF3, 0x41, 0xBF, 0x0D, 0xF0, 0xAD, 0xBA, 
/*04C0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_7[] = {
/*09F8:*/ 0xA8, 0x21, 0x62, 0x44, 0x41, 0x0F, 0x82, 0xFB, 
/*0A00:*/ 0x39, 0xAA, 0xBF, 0x6C, 0x57, 0x89, 0xDA, 0xB2, 0xFA, 0xCE, 0xAF, 0xA5, 0x51, 0x07, 0x91, 0xBA, 
/*0A10:*/ 0xF4, 0x2A, 0x00, 0x0E, 0x28, 0xD3, 0xF0, 0xAA, 0x0C, 0x48, 0x3A, 0x3A, 0xF4, 0x2A, 0x00, 0x0E, 
/*0A20:*/ 0x59, 0x72, 0x6E, 0xA4, 0xBF, 0xB4, 0xD2, 0x8F, 0x76, 0x0E, 0x7F, 0x97, 0x92, 0x82, 0xF5, 0xB9, 
/*0A30:*/ 0x23, 0xA4, 0x9B, 0x3E, 0xC8, 0xF7, 0x44, 0xFE, 0x63, 0xAE, 0xE3, 0x1C, 0x03, 0x02, 0xB4, 0x2D, 
/*0A40:*/ 0x69, 0x28, 0xA5, 0xF2, 0xD8, 0x7C, 0x3C, 0x08, 0xB9, 0xB0, 0x7A, 0x35, 0x19, 0x76, 0xC1, 0xDE, 
/*0A50:*/ 0xCA, 0x62, 0xA6, 0x46, 0x8C, 0xBA, 0x04, 0x05, 0x3E, 0x2C, 0x92, 0xD5, 0x50, 0x45, 0x07, 0xF0, 
/*0A60:*/ 0xD2, 0x43, 0x93, 0xFD, 0xA0, 0x18, 0x0B, 0x31, 0x6A, 0x19, 0xF9, 0x2F, 0xA0, 0x4F, 0x6B, 0xA5, 
/*0A70:*/ 0x8D, 0x3B, 0x92, 0xB8, 0x8C, 0xBA, 0x04, 0x05, 0x34, 0x2E, 0x7D, 0x84, 0xE6, 0x1C, 0xB6, 0x87, 
/*0A80:*/ 0x92, 0x26, 0x3D, 0x12, 0xCB, 0x41, 0x4C, 0xDA, 0x58, 0xF3, 0x41, 0xBF, 0x8C, 0xBA, 0x04, 0x05, 
/*0A90:*/ 0xD5, 0x80, 0xA1, 0x41, 0x28, 0x4C, 0x01, 0x90, 0xD7, 0xE3, 0xE9, 0x28, 0x6F, 0x1B, 0x63, 0xB3, 
/*0AA0:*/ 0x6E, 0x35, 0xFA, 0x9F, 0x50, 0xEE, 0xF3, 0x99, 0x27, 0xC0, 0xD0, 0x4C, 0x3D, 0x72, 0xD9, 0x4A, 
/*0AB0:*/ 0x55, 0xAF, 0xCB, 0x7D, 0xFD, 0x68, 0x02, 0x03, 0xDB, 0xEA, 0xEC, 0x30, 0xEA, 0xA0, 0x14, 0x88, 
/*0AC0:*/ 0xDC, 0xBD, 0x76, 0x19, 0xC8, 0xF7, 0x44, 0xFE, 0x55, 0xAF, 0xCB, 0x7D, 0x55, 0xA1, 0xE1, 0x6B, 
/*0AD0:*/ 0x28, 0x4C, 0x01, 0x90, 0x16, 0xCE, 0xEE, 0xEB, 0x55, 0xAF, 0xCB, 0x7D, 0x59, 0x03, 0xA8, 0x1A, 
/*0AE0:*/ 0x53, 0xE5, 0xF5, 0x0D, 0xEF, 0x02, 0xF1, 0x1F, 0xAE, 0xC0, 0x21, 0x9D, 0x9C, 0x26, 0xF2, 0x99, 
/*0AF0:*/ 0x5B, 0x1A, 0x7E, 0x64, 0xDA, 0x4D, 0x0A, 0x23, 0xC4, 0x68, 0xAC, 0x83, 0xEB, 0x76, 0x06, 0x7B, 
/*0B00:*/ 0xDC, 0xBD, 0x76, 0x19, 0x35, 0xC4, 0xB2, 0x1B, 0x12, 0xD1, 0x59, 0x1B, 0x12, 0xD1, 0x59, 0x1B, 
/*0B10:*/ 0x0A, 0x4A, 0x75, 0x7B, 0xC8, 0xF7, 0x44, 0xFE, 0x8E, 0x92, 0x63, 0xB0, 0x70, 0xF3, 0x21, 0x92, 
/*0B20:*/ 0x22, 0xA2, 0x25, 0xBA, 0x4C, 0x2C, 0x53, 0x9D, 0x01, 0x62, 0x83, 0xE7, 0xC8, 0xF7, 0x44, 0xFE, 
/*0B30:*/ 0x12, 0x7A, 0x2C, 0xF2, 0xE6, 0x05, 0x3C, 0xDF, 0xB0, 0x93, 0x08, 0x65, 0xB9, 0xB0, 0x7A, 0x35, 
/*0B40:*/ 0x0C, 0x48, 0x3A, 0x3A, 0xC8, 0xF7, 0x44, 0xFE, 0x7E, 0x03, 0x73, 0x1D, 0x5F, 0xE8, 0xC6, 0x9E, 
/*0B50:*/ 0xC8, 0xF7, 0x44, 0xFE, 0x41, 0x0F, 0x82, 0xFB, 0x3F, 0x71, 0x9A, 0x6A, 0xB9, 0xB0, 0x7A, 0x35, 
/*0B60:*/ 0xFC, 0x8A, 0x20, 0xF0, 0xE0, 0x58, 0x7A, 0x6F, 0x63, 0xD9, 0xBE, 0x5C, 0xF3, 0x37, 0xA7, 0x4A, 
/*0B70:*/ 0x3D, 0x76, 0x22, 0xB1, 0xC9, 0x9A, 0xC6, 0xDD, 0x05, 0xAD, 0xAB, 0x34, 0xAC, 0xD9, 0x82, 0x35, 
/*0B80:*/ 0x9E, 0xD8, 0xF8, 0x66, 0xE5, 0xF7, 0xC5, 0xBD, 0x04, 0xEA, 0xA7, 0x28, 0x8E, 0x23, 0x09, 0xF3, 
/*0B90:*/ 0xC5, 0x0F, 0xC0, 0xC6, 0x85, 0x5E, 0xED, 0xBB, 0x04, 0x47, 0x46, 0x11, 0x74, 0x39, 0x6F, 0x2B, 
/*0BA0:*/ 0xB5, 0x99, 0x8F, 0xB7, 0xEB, 0x76, 0x06, 0x7B, 0x86, 0xBD, 0xE9, 0x78, 0xD2, 0x1D, 0x28, 0xFD, 
/*0BB0:*/ 0x20, 0x2B, 0x8D, 0x19, 0x65, 0xF8, 0xDE, 0x27, 0x91, 0x24, 0x1D, 0x9F, 0x31, 0xEA, 0x4D, 0xAD, 
/*0BC0:*/ 0x5E, 0x8C, 0x7B, 0xD8, 0x35, 0x64, 0xCB, 0xAB, 0x4A, 0xDF, 0x4D, 0xF0, 0x53, 0xE5, 0xF5, 0x0D, 
/*0BD0:*/ 0xA9, 0x20, 0xF4, 0x24, 0x84, 0x8E, 0xCA, 0xB6, 0xC2, 0xEF, 0x17, 0x8C, 0xB4, 0x69, 0x9F, 0x38, 
/*0BE0:*/ 0x50, 0xEE, 0xF3, 0x99, 0xF4, 0xE3, 0x73, 0xBE, 0xB6, 0x14, 0x7E, 0x68, 0xE3, 0xA9, 0xC2, 0xC3, 
/*0BF0:*/ 0x91, 0x24, 0x1D, 0x9F, 0x82, 0x97, 0x72, 0x52, 0x92, 0x26, 0x3D, 0x12, 0x3B, 0x5C, 0x56, 0x54, 
/*0C00:*/ 0xC4, 0x46, 0x11, 0x47, 0x37, 0x83, 0x14, 0x26, 0x4B, 0x91, 0x59, 0xAA, 0x6E, 0x35, 0xFA, 0x9F, 
/*0C10:*/ 0x75, 0x80, 0x94, 0x83, 0xCB, 0x53, 0xD3, 0xFF, 0x92, 0x26, 0x3D, 0x12, 0xA3, 0xAE, 0xC3, 0xFA, 
/*0C20:*/ 0xC0, 0x94, 0x54, 0xC9, 0x68, 0x36, 0xD9, 0x72, 0x32, 0x39, 0x17, 0x0C, 0xFA, 0xCE, 0xAF, 0xA5, 
/*0C30:*/ 0x10, 0x20, 0x84, 0x97, 0x01, 0xD7, 0x5F, 0xC0, 0xA7, 0x54, 0x4C, 0xAD, 0x31, 0xEA, 0x4D, 0xAD, 
/*0C40:*/ 0xC8, 0xF7, 0x44, 0xFE, 0xFA, 0xCE, 0xAF, 0xA5, 0x4D, 0x74, 0xF8, 0x85, 0x55, 0xA1, 0xE1, 0x6B, 
/*0C50:*/ 0xBE, 0x61, 0x2C, 0xF5, 0x56, 0xF8, 0x83, 0x82, 0x53, 0xE5, 0xF5, 0x0D, 0x05, 0xAD, 0xAB, 0x34, 
/*0C60:*/ 0x02, 0x44, 0x8C, 0xB9, 0x1A, 0xD8, 0xBC, 0x1F, 0x0B, 0x91, 0x90, 0x54, 0x6F, 0xEE, 0xE7, 0x2D, 
/*0C70:*/ 0x5D, 0x65, 0xB5, 0x0A, 0x2D, 0xEA, 0x0D, 0x1D, 0x04, 0xDE, 0x4C, 0x7C, 0xDC, 0xBD, 0x76, 0x19, 
/*0C80:*/ 0x3F, 0xF5, 0x3C, 0x3E, 0x70, 0xF3, 0x21, 0x92, 0xA7, 0x54, 0x4C, 0xAD, 0x01, 0xD7, 0x5F, 0xC0, 
/*0C90:*/ 0x3E, 0x77, 0xA8, 0x9D, 0x87, 0xA3, 0x0D, 0x5B, 0xE6, 0x05, 0x3C, 0xDF, 0x3F, 0x71, 0x9A, 0x6A, 
/*0CA0:*/ 0x85, 0x9D, 0xF0, 0x35, 0x93, 0x60, 0x00, 0x4C, 0xA8, 0x21, 0x62, 0x44, 0x0D, 0xF0, 0xAD, 0xBA, 
/*0CB0:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*0CC0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_8[] = {
/*1210:*/ 0x8D, 0x6C, 0x70, 0x47, 0x44, 0x09, 0xC7, 0xED, 0xC8, 0xC4, 0xD0, 0xA3, 0xDC, 0xBD, 0x76, 0x19, 
/*1220:*/ 0x38, 0x8D, 0x3D, 0x7F, 0x0C, 0xA4, 0x6C, 0xFC, 0x2F, 0x67, 0xDA, 0xAC, 0x23, 0xEB, 0x14, 0x0E, 
/*1230:*/ 0x6A, 0xAB, 0x24, 0xB1, 0xC4, 0x68, 0xAC, 0x83, 0xCB, 0x53, 0xD3, 0xFF, 0x88, 0x8D, 0xF5, 0x4B, 
/*1240:*/ 0x6C, 0x4E, 0xC0, 0x23, 0x8F, 0x08, 0x7C, 0x84, 0x06, 0x8C, 0x28, 0x9D, 0xF4, 0x2A, 0x00, 0x0E, 
/*1250:*/ 0x4A, 0xDF, 0x4D, 0xF0, 0xCC, 0x02, 0xEB, 0xA5, 0x12, 0xD1, 0x59, 0x1B, 0xFC, 0xA4, 0x4A, 0xBD, 
/*1260:*/ 0x12, 0xD1, 0x59, 0x1B, 0xD8, 0x99, 0x2C, 0xB7, 0xC0, 0x94, 0x54, 0xC9, 0x03, 0x59, 0x9A, 0x4E, 
/*1270:*/ 0xA3, 0xBD, 0x45, 0x9C, 0x30, 0x44, 0x25, 0xFF, 0x99, 0x7B, 0x6F, 0xC5, 0x2E, 0xBE, 0x99, 0x34, 
/*1280:*/ 0x4C, 0x79, 0xC2, 0xEB, 0xC3, 0x79, 0x85, 0xAB, 0x05, 0xAD, 0xAB, 0x34, 0x2D, 0xEA, 0x0D, 0x1D, 
/*1290:*/ 0x51, 0x07, 0x91, 0xBA, 0xE0, 0x32, 0x37, 0xB3, 0x2F, 0x13, 0xD5, 0xAE, 0xA9, 0x86, 0xA4, 0x12, 
/*12A0:*/ 0x8C, 0xBA, 0x04, 0x05, 0x29, 0x78, 0x60, 0x9B, 0xFC, 0xB8, 0x3C, 0xEB, 0xF0, 0x36, 0x3C, 0x9C, 
/*12B0:*/ 0xED, 0x06, 0x1B, 0xEA, 0x12, 0xD1, 0x59, 0x1B, 0xA3, 0xAE, 0xC3, 0xFA, 0xB2, 0x0E, 0xC0, 0x25, 
/*12C0:*/ 0x05, 0x7B, 0xD6, 0xA2, 0xCB, 0xCC, 0xC1, 0xC4, 0x1B, 0xBE, 0xBA, 0x74, 0xDF, 0xC7, 0x1C, 0x7D, 
/*12D0:*/ 0xBD, 0x8A, 0x9F, 0xA9, 0xD8, 0x99, 0x2C, 0xB7, 0x05, 0xAD, 0xAB, 0x34, 0x3D, 0x72, 0xD9, 0x4A, 
/*12E0:*/ 0xEB, 0x76, 0x06, 0x7B, 0xAD, 0x45, 0x93, 0x08, 0xAC, 0xD9, 0x82, 0x35, 0x62, 0x0B, 0x86, 0x44, 
/*12F0:*/ 0x6C, 0x3C, 0x44, 0x49, 0xC6, 0x71, 0xAD, 0x6F, 0x3B, 0x22, 0x07, 0x87, 0x1A, 0x22, 0xCB, 0x38, 
/*1300:*/ 0xEE, 0x5A, 0x8F, 0x21, 0xA3, 0xBD, 0x45, 0x9C, 0xCE, 0x2D, 0x8A, 0xF8, 0x01, 0xD7, 0x5F, 0xC0, 
/*1310:*/ 0x6A, 0x19, 0xF9, 0x2F, 0xAD, 0x45, 0x93, 0x08, 0xD2, 0x43, 0x93, 0xFD, 0x02, 0x6D, 0x90, 0x88, 
/*1320:*/ 0x65, 0xF8, 0xDE, 0x27, 0x77, 0xC8, 0x8F, 0x75, 0x7A, 0x1A, 0xB6, 0x8B, 0x6A, 0xAB, 0x24, 0xB1, 
/*1330:*/ 0x3E, 0x77, 0xA8, 0x9D, 0x29, 0x78, 0x60, 0x9B, 0x0B, 0x91, 0x90, 0x54, 0xC3, 0x37, 0xAD, 0x8F, 
/*1340:*/ 0x3D, 0x72, 0xD9, 0x4A, 0x3E, 0x77, 0xA8, 0x9D, 0xEE, 0x5A, 0x8F, 0x21, 0x86, 0xBD, 0xE9, 0x78, 
/*1350:*/ 0x4C, 0x79, 0xC2, 0xEB, 0x76, 0x0E, 0x7F, 0x97, 0xB0, 0xF5, 0x9F, 0x48, 0x58, 0x1F, 0xAC, 0x46, 
/*1360:*/ 0x91, 0xB3, 0x84, 0xAB, 0x6A, 0xAB, 0x24, 0xB1, 0x0E, 0xFF, 0x87, 0x5A, 0x3B, 0xFB, 0x95, 0x81, 
/*1370:*/ 0x22, 0xA7, 0xE7, 0x6E, 0x99, 0x45, 0xAA, 0x43, 0x6F, 0x1B, 0x63, 0xB3, 0x11, 0x43, 0xBF, 0x52, 
/*1380:*/ 0x77, 0xA4, 0xCE, 0x28, 0x8C, 0xBA, 0x04, 0x05, 0x55, 0xA1, 0xE1, 0x6B, 0xDC, 0xBD, 0x76, 0x19, 
/*1390:*/ 0xB9, 0xB0, 0x7A, 0x35, 0x05, 0x6E, 0x54, 0x33, 0xFC, 0xB8, 0x3C, 0xEB, 0x01, 0x62, 0x83, 0xE7, 
/*13A0:*/ 0x6A, 0x19, 0xF9, 0x2F, 0xA0, 0x4F, 0x6B, 0xA5, 0xC3, 0x68, 0x4D, 0xA0, 0xA5, 0x1F, 0xF8, 0x3B, 
/*13B0:*/ 0xC8, 0xF7, 0x44, 0xFE, 0xAE, 0xBA, 0x7D, 0xFF, 0x3E, 0xCA, 0xD9, 0x17, 0x52, 0x14, 0xC3, 0xE8, 
/*13C0:*/ 0x34, 0x2E, 0x7D, 0x84, 0xFC, 0x8A, 0x20, 0xF0, 0xF4, 0xE3, 0x73, 0xBE, 0x17, 0x08, 0x0D, 0x3F, 
/*13D0:*/ 0x02, 0x44, 0x8C, 0xB9, 0x3F, 0x17, 0x18, 0xCB, 0x7D, 0x8C, 0xFD, 0x17, 0xB5, 0x99, 0x8F, 0xB7, 
/*13E0:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0x5E, 0xAC, 0xB2, 0x86, 0x6C, 0x4E, 0xC0, 0x23, 0xC5, 0x3F, 0x56, 0x06, 
/*13F0:*/ 0xB6, 0x14, 0x7E, 0x68, 0x74, 0x48, 0x37, 0x81, 0xD8, 0x99, 0x2C, 0xB7, 0xC0, 0x00, 0x3D, 0xCA, 
/*1400:*/ 0xCA, 0x62, 0xA6, 0x46, 0x59, 0x03, 0xA8, 0x1A, 0xA0, 0x18, 0x0B, 0x31, 0x3D, 0x72, 0xD9, 0x4A, 
/*1410:*/ 0xA4, 0x60, 0x41, 0xA8, 0x16, 0x42, 0x66, 0x51, 0xAB, 0xD1, 0xD3, 0x0E, 0xCF, 0x7E, 0x80, 0xB6, 
/*1420:*/ 0x8E, 0x92, 0x63, 0xB0, 0xDF, 0xC7, 0x1C, 0x7D, 0xF4, 0xE3, 0x73, 0xBE, 0x01, 0x62, 0x83, 0xE7, 
/*1430:*/ 0xAD, 0xD2, 0xB8, 0x48, 0x60, 0x43, 0xCC, 0x0E, 0x44, 0x67, 0x6E, 0x3D, 0x76, 0x0E, 0x7F, 0x97, 
/*1440:*/ 0x05, 0x7B, 0xD6, 0xA2, 0xF5, 0xB7, 0xF4, 0x43, 0x4D, 0x01, 0x6B, 0x7A, 0x83, 0x55, 0x2F, 0xE2, 
/*1450:*/ 0x87, 0xA3, 0x0D, 0x5B, 0x70, 0xF3, 0x21, 0x92, 0x55, 0xAF, 0xCB, 0x7D, 0x8D, 0x3B, 0x92, 0xB8, 
/*1460:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_9[] = {
/*1A08:*/ 0x3B, 0x5C, 0x56, 0x54, 0x5F, 0xF2, 0xFA, 0xF6, 
/*1A10:*/ 0x33, 0x94, 0x16, 0xD9, 0x65, 0x1C, 0x74, 0x7F, 0x55, 0x59, 0xA8, 0xF2, 0xA3, 0xBD, 0x45, 0x9C, 
/*1A20:*/ 0x9A, 0x45, 0xD2, 0xAA, 0x97, 0xB2, 0x9C, 0x33, 0xEB, 0x76, 0x06, 0x7B, 0x33, 0x94, 0x16, 0xD9, 
/*1A30:*/ 0xA7, 0x54, 0x4C, 0xAD, 0xEB, 0x76, 0x06, 0x7B, 0x23, 0xA4, 0x9B, 0x3E, 0x59, 0x6B, 0x25, 0xE6, 
/*1A40:*/ 0x9E, 0x3A, 0xCF, 0x5B, 0xE6, 0x05, 0x3C, 0xDF, 0x16, 0xCE, 0xEE, 0xEB, 0x9D, 0x62, 0x7B, 0x14, 
/*1A50:*/ 0x1B, 0xA6, 0x0E, 0x00, 0xC8, 0xF7, 0x44, 0xFE, 0xEE, 0x5A, 0x8F, 0x21, 0x94, 0xAC, 0xDE, 0xF1, 
/*1A60:*/ 0x0B, 0x91, 0x90, 0x54, 0x16, 0xCE, 0xEE, 0xEB, 0x1B, 0xA6, 0x0E, 0x00, 0x03, 0x02, 0xB4, 0x2D, 
/*1A70:*/ 0x04, 0x47, 0x46, 0x11, 0x75, 0x18, 0x6F, 0xB8, 0x92, 0x82, 0xF5, 0xB9, 0x61, 0xE8, 0x92, 0xBB, 
/*1A80:*/ 0x57, 0x89, 0xDA, 0xB2, 0x04, 0x47, 0x46, 0x11, 0xC8, 0xF7, 0x44, 0xFE, 0x11, 0x68, 0xF0, 0x4A, 
/*1A90:*/ 0x4D, 0x1F, 0x00, 0xFA, 0xAD, 0x45, 0x93, 0x08, 0xE6, 0x05, 0x3C, 0xDF, 0x52, 0xE5, 0x37, 0xD4, 
/*1AA0:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0x3D, 0x72, 0xD9, 0x4A, 0xC5, 0x0F, 0xC0, 0xC6, 0xBF, 0x5B, 0x21, 0x67, 
/*1AB0:*/ 0x33, 0xD9, 0x7D, 0xD3, 0x5D, 0x20, 0x4E, 0x4E, 0x1B, 0xBE, 0xBA, 0x74, 0x1A, 0x46, 0xB5, 0xFF, 
/*1AC0:*/ 0xC4, 0xC9, 0xED, 0x05, 0x01, 0x62, 0x83, 0xE7, 0xDC, 0xBD, 0x76, 0x19, 0x1A, 0x22, 0xCB, 0x38, 
/*1AD0:*/ 0x2F, 0x1F, 0xC8, 0xD8, 0xEC, 0xC6, 0xB5, 0x4C, 0xF2, 0xD1, 0x99, 0xBC, 0xC9, 0x81, 0x66, 0xB7, 
/*1AE0:*/ 0x34, 0x2E, 0x7D, 0x84, 0x7C, 0xC3, 0x8D, 0xB5, 0xDA, 0x68, 0x24, 0x6C, 0x75, 0x18, 0x6F, 0xB8, 
/*1AF0:*/ 0xCE, 0x1C, 0x58, 0x49, 0xD4, 0x56, 0x59, 0x6D, 0xE0, 0x58, 0x7A, 0x6F, 0x7E, 0x03, 0x73, 0x1D, 
/*1B00:*/ 0x1B, 0xA6, 0x0E, 0x00, 0x3B, 0xE7, 0x29, 0xC7, 0x19, 0x1A, 0x36, 0xD0, 0x8E, 0x92, 0x63, 0xB0, 
/*1B10:*/ 0x0C, 0x48, 0x3A, 0x3A, 0x01, 0xD7, 0x5F, 0xC0, 0x01, 0x42, 0xCD, 0xC9, 0x17, 0x08, 0x0D, 0x3F, 
/*1B20:*/ 0x8C, 0xBA, 0x04, 0x05, 0x58, 0xF3, 0x41, 0xBF, 0xD2, 0x1D, 0x28, 0xFD, 0x34, 0x2E, 0x7D, 0x84, 
/*1B30:*/ 0x50, 0xEE, 0xF3, 0x99, 0x16, 0x31, 0xE8, 0x05, 0x48, 0xE6, 0x76, 0x2D, 0x91, 0x24, 0x1D, 0x9F, 
/*1B40:*/ 0x78, 0xBE, 0x58, 0x61, 0xF4, 0xE3, 0x73, 0xBE, 0x69, 0xC6, 0xF8, 0x5D, 0x35, 0x64, 0xCB, 0xAB, 
/*1B50:*/ 0x3F, 0x17, 0x18, 0xCB, 0x7B, 0x07, 0x82, 0x94, 0x5C, 0xAA, 0xAC, 0x53, 0x03, 0x59, 0x9A, 0x4E, 
/*1B60:*/ 0x35, 0x64, 0xCB, 0xAB, 0x55, 0xA1, 0xE1, 0x6B, 0x23, 0xEB, 0x14, 0x0E, 0xEB, 0x76, 0x06, 0x7B, 
/*1B70:*/ 0x29, 0xE1, 0x35, 0x00, 0xE6, 0x05, 0x3C, 0xDF, 0xB4, 0x69, 0x9F, 0x38, 0x3F, 0xF5, 0x3C, 0x3E, 
/*1B80:*/ 0xE6, 0x1C, 0xB6, 0x87, 0x01, 0xD7, 0x5F, 0xC0, 0x03, 0x02, 0xB4, 0x2D, 0x33, 0x94, 0x16, 0xD9, 
/*1B90:*/ 0x8E, 0x92, 0x63, 0xB0, 0x6A, 0xAB, 0x24, 0xB1, 0x68, 0x36, 0xD9, 0x72, 0x02, 0x44, 0x8C, 0xB9, 
/*1BA0:*/ 0x0B, 0xD2, 0x73, 0x78, 0x26, 0xAF, 0x6F, 0xC0, 0x5E, 0x8C, 0x7B, 0xD8, 0x44, 0x09, 0xC7, 0xED, 
/*1BB0:*/ 0xE3, 0xA6, 0xD3, 0x18, 0xF2, 0xD1, 0x99, 0xBC, 0xF0, 0x5F, 0xAF, 0xD7, 0x17, 0x08, 0x0D, 0x3F, 
/*1BC0:*/ 0xCA, 0xE9, 0xF0, 0x51, 0xA1, 0xDC, 0x17, 0xE0, 0x70, 0x77, 0xF6, 0x7E, 0xAB, 0x8D, 0xD1, 0x39, 
/*1BD0:*/ 0x37, 0x83, 0x14, 0x26, 0xAC, 0xD9, 0x82, 0x35, 0x84, 0xE6, 0x91, 0xA6, 0x12, 0xBC, 0x59, 0xD4, 
/*1BE0:*/ 0xCB, 0xCC, 0xC1, 0xC4, 0xD7, 0x9F, 0x82, 0x50, 0x7A, 0x1A, 0xB6, 0x8B, 0x3F, 0x86, 0x27, 0xB9, 
/*1BF0:*/ 0xC8, 0xF7, 0x44, 0xFE, 0x77, 0xC8, 0x8F, 0x75, 0x05, 0x7B, 0xD6, 0xA2, 0xE5, 0x0C, 0x47, 0x24, 
/*1C00:*/ 0x26, 0xAF, 0x6F, 0xC0, 0x1B, 0xBE, 0xBA, 0x74, 0xE6, 0xB0, 0xC1, 0x6B, 0x8C, 0x7F, 0x26, 0x4A, 
/*1C10:*/ 0x9E, 0xBD, 0x9F, 0x16, 0x01, 0xD7, 0x5F, 0xC0, 0x5B, 0x25, 0xF1, 0x26, 0x53, 0xE5, 0xF5, 0x0D, 
/*1C20:*/ 0xE0, 0x58, 0x7A, 0x6F, 0x22, 0xE4, 0x16, 0xC9, 0x32, 0x39, 0x17, 0x0C, 0x67, 0x0B, 0x9D, 0x26, 
/*1C30:*/ 0x34, 0x2E, 0x7D, 0x84, 0xDD, 0x61, 0xC6, 0xD6, 0x58, 0xF3, 0x41, 0xBF, 0x38, 0x3C, 0x18, 0x72, 
/*1C40:*/ 0xF3, 0xF7, 0xB5, 0x7E, 0x12, 0xD1, 0x59, 0x1B, 0xB4, 0x69, 0x9F, 0x38, 0x3D, 0x76, 0x22, 0xB1, 
/*1C50:*/ 0x25, 0x32, 0x51, 0x73, 0x91, 0xB3, 0x84, 0xAB, 0x92, 0x26, 0x3D, 0x12, 0x22, 0xA2, 0x25, 0xBA, 
/*1C60:*/ 0xE6, 0x05, 0x3C, 0xDF, 0xAE, 0x63, 0x36, 0xE6, 0xAD, 0x45, 0x93, 0x08, 0x3B, 0xFB, 0x95, 0x81, 
/*1C70:*/ 0x52, 0x14, 0xC3, 0xE8, 0xC3, 0x68, 0x4D, 0xA0, 0x27, 0xC0, 0xD0, 0x4C, 0xDD, 0x61, 0xC6, 0xD6, 
/*1C80:*/ 0xF9, 0xA8, 0xD0, 0xE2, 0xD8, 0x99, 0x2C, 0xB7, 0xE6, 0x1C, 0xB6, 0x87, 0x72, 0xCE, 0xA1, 0xE6, 
/*1C90:*/ 0x22, 0xA2, 0x25, 0xBA, 0xA3, 0xBD, 0x45, 0x9C, 0xFD, 0x68, 0x02, 0x03, 0x60, 0x43, 0xCC, 0x0E, 
/*1CA0:*/ 0x9E, 0xE0, 0xC6, 0x8C, 0x61, 0xE8, 0x92, 0xBB, 0x60, 0x43, 0xCC, 0x0E, 0xB5, 0x99, 0x8F, 0xB7, 
/*1CB0:*/ 0x72, 0xCE, 0xA1, 0xE6, 0x69, 0x5E, 0x78, 0x07, 0x22, 0xA2, 0x25, 0xBA, 0xA1, 0xDC, 0x17, 0xE0, 
/*1CC0:*/ 0x88, 0x5D, 0xD3, 0xB7, 0xD7, 0xE3, 0xE9, 0x28, 0x0B, 0x94, 0xDD, 0x44, 0x72, 0x5F, 0x47, 0x67, 
/*1CD0:*/ 0x3E, 0xCA, 0xD9, 0x17, 0x8E, 0xB3, 0xD6, 0xCA, 0x94, 0xAC, 0xDE, 0xF1, 0x0B, 0x94, 0xDD, 0x44, 
/*1CE0:*/ 0xC9, 0x9A, 0xC6, 0xDD, 0x5A, 0x6C, 0x52, 0x04, 0xEF, 0x02, 0xF1, 0x1F, 0xA1, 0x44, 0x3D, 0x80, 
/*1CF0:*/ 0xD2, 0x93, 0xE6, 0x24, 0xFC, 0xA4, 0x4A, 0xBD, 0x9E, 0xBD, 0x9F, 0x16, 0x3E, 0x54, 0xED, 0x1F, 
/*1D00:*/ 0x65, 0xF8, 0xDE, 0x27, 0xA0, 0x29, 0x6B, 0x19, 0xD2, 0xA0, 0x78, 0x54, 0x1A, 0x22, 0xCB, 0x38, 
/*1D10:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*1D20:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_A[] = {
/*2448:*/ 0xE5, 0x0C, 0x47, 0x24, 0xDF, 0xC7, 0x1C, 0x7D, 
/*2450:*/ 0x4D, 0x1E, 0x4D, 0x3C, 0xC8, 0xC4, 0xD0, 0xA3, 0x4C, 0x79, 0xC2, 0xEB, 0x55, 0xAF, 0xCB, 0x7D, 
/*2460:*/ 0x08, 0xBD, 0xC5, 0x11, 0x77, 0xC8, 0x8F, 0x75, 0xEB, 0x76, 0x06, 0x7B, 0x76, 0x0E, 0x7F, 0x97, 
/*2470:*/ 0xFA, 0xCE, 0xAF, 0xA5, 0x70, 0xF3, 0x21, 0x92, 0xA0, 0x3E, 0xD4, 0xB4, 0x0F, 0x10, 0x4F, 0x74, 
/*2480:*/ 0xB9, 0xB0, 0x7A, 0x35, 0xA7, 0x54, 0x4C, 0xAD, 0xD2, 0x93, 0xE6, 0x24, 0xD3, 0x81, 0x65, 0xE4, 
/*2490:*/ 0x3F, 0x86, 0x27, 0xB9, 0x52, 0x1B, 0x4B, 0xEE, 0x28, 0x4C, 0x01, 0x90, 0x87, 0xA3, 0x0D, 0x5B, 
/*24A0:*/ 0x16, 0x31, 0xE8, 0x05, 0xD8, 0x99, 0x2C, 0xB7, 0x53, 0xE5, 0xF5, 0x0D, 0x77, 0xF6, 0x5E, 0xC9, 
/*24B0:*/ 0x77, 0xA4, 0xCE, 0x28, 0x62, 0x0B, 0x86, 0x44, 0x1B, 0xA6, 0x0E, 0x00, 0xEB, 0x76, 0x06, 0x7B, 
/*24C0:*/ 0xF2, 0xD1, 0x99, 0xBC, 0x44, 0x09, 0xC7, 0xED, 0x6E, 0x35, 0xFA, 0x9F, 0x43, 0xDF, 0xC5, 0x2E, 
/*24D0:*/ 0xE1, 0x24, 0x92, 0x9E, 0xD7, 0xE3, 0xE9, 0x28, 0x0B, 0x91, 0x90, 0x54, 0x48, 0xE6, 0x76, 0x2D, 
/*24E0:*/ 0x91, 0xB3, 0x84, 0xAB, 0x31, 0xEA, 0x4D, 0xAD, 0x6F, 0xEE, 0xE7, 0x2D, 0x12, 0x7A, 0x2C, 0xF2, 
/*24F0:*/ 0x53, 0xE5, 0xF5, 0x0D, 0x01, 0x62, 0x83, 0xE7, 0x2D, 0x75, 0xCC, 0x80, 0xF4, 0xE3, 0x73, 0xBE, 
/*2500:*/ 0x72, 0xCE, 0xA1, 0xE6, 0x3B, 0x22, 0x07, 0x87, 0x2D, 0x75, 0xCC, 0x80, 0xCC, 0x79, 0x89, 0x67, 
/*2510:*/ 0x88, 0x8D, 0xF5, 0x4B, 0x2D, 0xEA, 0x0D, 0x1D, 0x76, 0x0E, 0x7F, 0x97, 0xA4, 0xF8, 0x7B, 0x5B, 
/*2520:*/ 0x43, 0x6C, 0xEF, 0x92, 0x75, 0x80, 0x94, 0x83, 0x95, 0x37, 0x3A, 0x30, 0xF3, 0x37, 0xA7, 0x4A, 
/*2530:*/ 0x87, 0xA3, 0x0D, 0x5B, 0x11, 0x68, 0xF0, 0x4A, 0xAD, 0xBE, 0xFA, 0xE0, 0x8E, 0xB3, 0xD6, 0xCA, 
/*2540:*/ 0x5D, 0x65, 0xB5, 0x0A, 0x72, 0x38, 0xA6, 0x78, 0xFA, 0xCE, 0xAF, 0xA5, 0x58, 0x1F, 0xAC, 0x46, 
/*2550:*/ 0x84, 0x8E, 0xCA, 0xB6, 0x3E, 0xF1, 0xB5, 0x10, 0x43, 0xDF, 0xC5, 0x2E, 0x8C, 0x7F, 0x26, 0x4A, 
/*2560:*/ 0x62, 0x0B, 0x86, 0x44, 0x70, 0x92, 0x08, 0xC8, 0x1B, 0xBE, 0xBA, 0x74, 0x55, 0xAF, 0xCB, 0x7D, 
/*2570:*/ 0xC8, 0xC4, 0xD0, 0xA3, 0x09, 0x0D, 0x2C, 0x7E, 0x40, 0xB3, 0x1B, 0x9E, 0x38, 0x8D, 0x3D, 0x7F, 
/*2580:*/ 0xDC, 0xBD, 0x76, 0x19, 0xC8, 0xF7, 0x44, 0xFE, 0x44, 0x4C, 0x5D, 0xB4, 0xAD, 0x45, 0x93, 0x08, 
/*2590:*/ 0xEC, 0xC6, 0xB5, 0x4C, 0xAE, 0xBA, 0x7D, 0xFF, 0x40, 0xB3, 0x1B, 0x9E, 0x19, 0x76, 0xC1, 0xDE, 
/*25A0:*/ 0x6C, 0xD3, 0xE5, 0x55, 0x38, 0x3C, 0x18, 0x72, 0x6C, 0x4E, 0xC0, 0x23, 0x0C, 0x31, 0xB7, 0x7D, 
/*25B0:*/ 0x16, 0x42, 0x66, 0x51, 0xE5, 0x26, 0x45, 0x81, 0xA4, 0xCC, 0xA3, 0x0A, 0x5B, 0x1A, 0x7E, 0x64, 
/*25C0:*/ 0x53, 0xE5, 0xF5, 0x0D, 0x3F, 0xF5, 0x3C, 0x3E, 0xF0, 0x25, 0xD0, 0x02, 0x68, 0xA7, 0x03, 0x45, 
/*25D0:*/ 0x4D, 0x1E, 0x4D, 0x3C, 0xA8, 0xB8, 0x38, 0x0A, 0x89, 0xBB, 0xCE, 0xE7, 0x4C, 0x79, 0xC2, 0xEB, 
/*25E0:*/ 0xE2, 0x9F, 0xD6, 0x27, 0x7B, 0x07, 0x82, 0x94, 0x53, 0xE5, 0xF5, 0x0D, 0x26, 0xAD, 0xDB, 0x83, 
/*25F0:*/ 0x60, 0x43, 0xCC, 0x0E, 0x53, 0xF6, 0x3D, 0xAE, 0x8E, 0x92, 0x63, 0xB0, 0x8F, 0x08, 0x7C, 0x84, 
/*2600:*/ 0x33, 0xD9, 0x7D, 0xD3, 0x32, 0x39, 0x17, 0x0C, 0x05, 0xAD, 0xAB, 0x34, 0x8C, 0x7F, 0x26, 0x4A, 
/*2610:*/ 0x46, 0xC2, 0x68, 0x74, 0x34, 0x2E, 0x7D, 0x84, 0x70, 0x35, 0xAC, 0xDE, 0x6F, 0x0B, 0xAA, 0x0C, 
/*2620:*/ 0xFC, 0x2C, 0x50, 0x09, 0xA4, 0xCC, 0xA3, 0x0A, 0xC8, 0xC4, 0xD0, 0xA3, 0x55, 0xA1, 0xE1, 0x6B, 
/*2630:*/ 0x75, 0x18, 0x6F, 0xB8, 0xE6, 0xD3, 0x65, 0xF8, 0x26, 0xAF, 0x6F, 0xC0, 0x88, 0x5D, 0xD3, 0xB7, 
/*2640:*/ 0xC4, 0x68, 0xAC, 0x83, 0x72, 0xCE, 0xA1, 0xE6, 0x7E, 0x03, 0x73, 0x1D, 0x7F, 0x7E, 0x86, 0xF1, 
/*2650:*/ 0x18, 0x3A, 0x8E, 0x81, 0x22, 0xA7, 0xE7, 0x6E, 0x9D, 0x62, 0x7B, 0x14, 0x41, 0xAB, 0xEA, 0x23, 
/*2660:*/ 0xD8, 0x99, 0x2C, 0xB7, 0xCA, 0x62, 0xA6, 0x46, 0xFC, 0x8A, 0x20, 0xF0, 0xE3, 0xA9, 0xC2, 0xC3, 
/*2670:*/ 0x88, 0x8D, 0xF5, 0x4B, 0xD2, 0xC8, 0x3B, 0x42, 0x4C, 0x2C, 0x53, 0x9D, 0x32, 0x39, 0x17, 0x0C, 
/*2680:*/ 0x5D, 0x20, 0x4E, 0x4E, 0xA8, 0xB8, 0x38, 0x0A, 0xC0, 0x00, 0x3D, 0xCA, 0x22, 0xE4, 0x16, 0xC9, 
/*2690:*/ 0xBF, 0xB4, 0xD2, 0x8F, 0x91, 0x24, 0x1D, 0x9F, 0x95, 0xCB, 0x9B, 0xC3, 0xE0, 0x58, 0x7A, 0x6F, 
/*26A0:*/ 0xC6, 0xB3, 0x24, 0x7D, 0x8E, 0x92, 0x63, 0xB0, 0xA0, 0x4F, 0x6B, 0xA5, 0xD8, 0x7C, 0x3C, 0x08, 
/*26B0:*/ 0x6D, 0x08, 0x98, 0x24, 0x8E, 0xB3, 0xD6, 0xCA, 0xE0, 0x9C, 0x6D, 0x48, 0x7A, 0x97, 0x8F, 0xDF, 
/*26C0:*/ 0x57, 0x11, 0x3A, 0x5F, 0x05, 0xAD, 0xAB, 0x34, 0x9C, 0x9C, 0x45, 0xA8, 0x33, 0x94, 0x16, 0xD9, 
/*26D0:*/ 0x77, 0xC8, 0x8F, 0x75, 0xF4, 0xE3, 0x73, 0xBE, 0xDF, 0xC7, 0x1C, 0x7D, 0xE6, 0xD3, 0x65, 0xF8, 
/*26E0:*/ 0x6A, 0x19, 0xF9, 0x2F, 0x5D, 0x65, 0xB5, 0x0A, 0x0C, 0x48, 0x3A, 0x3A, 0xC8, 0xC4, 0xD0, 0xA3, 
/*26F0:*/ 0x3F, 0x71, 0x9A, 0x6A, 0xB5, 0x99, 0x8F, 0xB7, 0xE0, 0x9C, 0x6D, 0x48, 0x30, 0x52, 0xB4, 0xEB, 
/*2700:*/ 0xE0, 0x58, 0x7A, 0x6F, 0xAD, 0x45, 0x93, 0x08, 0x59, 0x03, 0xA8, 0x1A, 0x01, 0xD7, 0x5F, 0xC0, 
/*2710:*/ 0x44, 0x09, 0xC7, 0xED, 0x43, 0x6C, 0xEF, 0x92, 0xA7, 0x54, 0x4C, 0xAD, 0x52, 0x1B, 0x4B, 0xEE, 
/*2720:*/ 0x8C, 0x7F, 0x26, 0x4A, 0xC9, 0x9A, 0xC6, 0xDD, 0xEB, 0x76, 0x06, 0x7B, 0x0D, 0xF0, 0xAD, 0xBA, 
/*2730:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*2740:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_B[] = {
/*2DB8:*/ 0x10, 0x20, 0x84, 0x97, 0xFE, 0x05, 0x3F, 0x81, 
/*2DC0:*/ 0x83, 0x55, 0x2F, 0xE2, 0x73, 0x06, 0x71, 0x53, 0x4D, 0x1E, 0x4D, 0x3C, 0x9C, 0x26, 0xF2, 0x99, 
/*2DD0:*/ 0xE1, 0x32, 0x9B, 0x77, 0x70, 0x6E, 0x67, 0xDF, 0x6C, 0xD3, 0xE5, 0x55, 0xC3, 0x68, 0x4D, 0xA0, 
/*2DE0:*/ 0x35, 0x64, 0xCB, 0xAB, 0x5B, 0x25, 0xF1, 0x26, 0xC3, 0x37, 0xAD, 0x8F, 0xA3, 0xBD, 0x45, 0x9C, 
/*2DF0:*/ 0xB5, 0x99, 0x8F, 0xB7, 0x88, 0x5D, 0xD3, 0xB7, 0xBF, 0xB4, 0xD2, 0x8F, 0x55, 0xAF, 0xCB, 0x7D, 
/*2E00:*/ 0xC9, 0x9A, 0xC6, 0xDD, 0x00, 0x31, 0x68, 0x11, 0x2D, 0xC1, 0xCA, 0x89, 0xA1, 0xDC, 0x17, 0xE0, 
/*2E10:*/ 0x4B, 0xFA, 0xF6, 0xE0, 0xA4, 0xCC, 0xA3, 0x0A, 0x88, 0x8D, 0xF5, 0x4B, 0x3B, 0x5C, 0x56, 0x54, 
/*2E20:*/ 0xF9, 0xA8, 0xD0, 0xE2, 0x51, 0x07, 0x91, 0xBA, 0x3C, 0x6C, 0xB3, 0x5F, 0xC3, 0x37, 0xAD, 0x8F, 
/*2E30:*/ 0x68, 0x36, 0xD9, 0x72, 0x0B, 0x91, 0x90, 0x54, 0x24, 0x1A, 0xBF, 0x03, 0x44, 0x09, 0xC7, 0xED, 
/*2E40:*/ 0xC8, 0xF7, 0x44, 0xFE, 0x01, 0x62, 0x83, 0xE7, 0x3D, 0x72, 0xD9, 0x4A, 0x0B, 0x91, 0x90, 0x54, 
/*2E50:*/ 0x30, 0xD9, 0x62, 0x05, 0x48, 0xE6, 0x76, 0x2D, 0x72, 0x5F, 0x47, 0x67, 0xC6, 0x4E, 0x14, 0x97, 
/*2E60:*/ 0xD8, 0x99, 0x2C, 0xB7, 0xD7, 0xAB, 0xF5, 0x95, 0x15, 0x5D, 0x3E, 0xDE, 0xAB, 0xD1, 0xD3, 0x0E, 
/*2E70:*/ 0x6E, 0x35, 0xFA, 0x9F, 0x7E, 0x03, 0x73, 0x1D, 0xF4, 0x2A, 0x00, 0x0E, 0x8D, 0xCA, 0x5F, 0x62, 
/*2E80:*/ 0x33, 0x94, 0x16, 0xD9, 0x14, 0xED, 0x2F, 0x1A, 0x53, 0xE5, 0xF5, 0x0D, 0xB4, 0x1E, 0x49, 0xD5, 
/*2E90:*/ 0xD3, 0x37, 0xFF, 0xEE, 0xE5, 0x0C, 0x47, 0x24, 0x92, 0x26, 0x3D, 0x12, 0x32, 0x39, 0x17, 0x0C, 
/*2EA0:*/ 0x35, 0x64, 0xCB, 0xAB, 0x53, 0xE5, 0xF5, 0x0D, 0x46, 0x4E, 0xB0, 0x73, 0x6C, 0x4E, 0xC0, 0x23, 
/*2EB0:*/ 0x9E, 0x3A, 0xCF, 0x5B, 0x0B, 0x94, 0xDD, 0x44, 0x17, 0x08, 0x0D, 0x3F, 0x2F, 0x67, 0xDA, 0xAC, 
/*2EC0:*/ 0x63, 0xAE, 0xE3, 0x1C, 0xFC, 0x8A, 0x20, 0xF0, 0xDF, 0xC7, 0x1C, 0x7D, 0x1B, 0xBE, 0xBA, 0x74, 
/*2ED0:*/ 0xF3, 0xF7, 0xB5, 0x7E, 0xB9, 0xD7, 0x98, 0x99, 0x8E, 0xB3, 0xD6, 0xCA, 0xDC, 0xBD, 0x76, 0x19, 
/*2EE0:*/ 0x17, 0x08, 0x0D, 0x3F, 0xD8, 0x2F, 0x7E, 0xCA, 0x01, 0xD7, 0x5F, 0xC0, 0x6C, 0x4E, 0xC0, 0x23, 
/*2EF0:*/ 0x48, 0xE6, 0x76, 0x2D, 0x6E, 0xA5, 0x40, 0xAE, 0x5D, 0x65, 0xB5, 0x0A, 0xE6, 0xD3, 0x65, 0xF8, 
/*2F00:*/ 0x7E, 0x03, 0x73, 0x1D, 0xC8, 0xF7, 0x44, 0xFE, 0x55, 0xA1, 0xE1, 0x6B, 0x93, 0x60, 0x00, 0x4C, 
/*2F10:*/ 0x3B, 0x22, 0x07, 0x87, 0xF3, 0xF7, 0xB5, 0x7E, 0x42, 0xFA, 0x83, 0x36, 0xC8, 0xC4, 0xD0, 0xA3, 
/*2F20:*/ 0x11, 0x43, 0xBF, 0x52, 0x28, 0x4C, 0x01, 0x90, 0xE0, 0x32, 0x37, 0xB3, 0x33, 0xD9, 0x7D, 0xD3, 
/*2F30:*/ 0x23, 0xEB, 0x14, 0x0E, 0x35, 0x64, 0xCB, 0xAB, 0xC9, 0x17, 0xFF, 0x0E, 0xD1, 0x40, 0xB6, 0x6C, 
/*2F40:*/ 0x2D, 0x4B, 0xA5, 0x82, 0xAD, 0x45, 0x93, 0x08, 0x1B, 0xA6, 0x0E, 0x00, 0x8E, 0x11, 0x1D, 0xA3, 
/*2F50:*/ 0x11, 0x68, 0xF0, 0x4A, 0x7E, 0x03, 0x73, 0x1D, 0x11, 0x68, 0xF0, 0x4A, 0xC8, 0xF7, 0x44, 0xFE, 
/*2F60:*/ 0x15, 0x04, 0x21, 0x64, 0xE6, 0xD3, 0x65, 0xF8, 0x55, 0xAF, 0xCB, 0x7D, 0xC9, 0x9A, 0xC6, 0xDD, 
/*2F70:*/ 0x86, 0xBD, 0xE9, 0x78, 0x59, 0x72, 0x6E, 0xA4, 0x0B, 0xD9, 0x3A, 0x41, 0x24, 0x1A, 0xBF, 0x03, 
/*2F80:*/ 0x4C, 0x79, 0xC2, 0xEB, 0x3B, 0x22, 0x07, 0x87, 0xC8, 0xF7, 0x44, 0xFE, 0xC8, 0xF7, 0x44, 0xFE, 
/*2F90:*/ 0xA9, 0x20, 0xF4, 0x24, 0x23, 0xA4, 0x9B, 0x3E, 0x30, 0x52, 0xB4, 0xEB, 0x12, 0xBC, 0x59, 0xD4, 
/*2FA0:*/ 0xFC, 0xA4, 0x4A, 0xBD, 0x0B, 0x91, 0x90, 0x54, 0x2D, 0x75, 0xCC, 0x80, 0xF3, 0xF7, 0xB5, 0x7E, 
/*2FB0:*/ 0x30, 0xC5, 0x0D, 0x6C, 0xCC, 0x79, 0x89, 0x67, 0x45, 0xCF, 0x2B, 0x5E, 0x75, 0x80, 0x94, 0x83, 
/*2FC0:*/ 0xD7, 0x9F, 0x82, 0x50, 0x5E, 0xAC, 0xB2, 0x86, 0x0C, 0xA4, 0x6C, 0xFC, 0x78, 0xBE, 0x58, 0x61, 
/*2FD0:*/ 0x16, 0xCE, 0xEE, 0xEB, 0x5D, 0x65, 0xB5, 0x0A, 0x0C, 0x48, 0x3A, 0x3A, 0xF4, 0x2A, 0x00, 0x0E, 
/*2FE0:*/ 0x68, 0x36, 0xD9, 0x72, 0x4B, 0x91, 0x59, 0xAA, 0x10, 0x20, 0x84, 0x97, 0xC4, 0x28, 0x18, 0xE6, 
/*2FF0:*/ 0x8E, 0x92, 0x63, 0xB0, 0x00, 0xBC, 0x1A, 0xC2, 0xEB, 0x76, 0x06, 0x7B, 0xEC, 0xC6, 0xB5, 0x4C, 
/*3000:*/ 0xA0, 0xAF, 0xBB, 0xFC, 0x44, 0x09, 0xC7, 0xED, 0xA3, 0x49, 0x13, 0x9C, 0xF7, 0x95, 0x36, 0x9E, 
/*3010:*/ 0x10, 0x20, 0x84, 0x97, 0x88, 0x8D, 0xF5, 0x4B, 0x7D, 0x8C, 0xFD, 0x17, 0xF0, 0x25, 0xD0, 0x02, 
/*3020:*/ 0x87, 0xA3, 0x0D, 0x5B, 0x41, 0x0F, 0x82, 0xFB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*3030:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_C[] = {
/*35F8:*/ 0x95, 0xCB, 0x9B, 0xC3, 0x96, 0x90, 0xD1, 0xAC, 
/*3600:*/ 0x45, 0xCF, 0x2B, 0x5E, 0xC6, 0x71, 0xAD, 0x6F, 0x5B, 0x1A, 0x7E, 0x64, 0x6C, 0x4E, 0xC0, 0x23, 
/*3610:*/ 0xD2, 0x93, 0xE6, 0x24, 0x3E, 0x77, 0xA8, 0x9D, 0xD9, 0x27, 0xDA, 0xA5, 0x32, 0x39, 0x17, 0x0C, 
/*3620:*/ 0x7B, 0x07, 0x82, 0x94, 0xAB, 0xBE, 0x44, 0x55, 0xEB, 0x76, 0x06, 0x7B, 0x88, 0x59, 0xC4, 0x4D, 
/*3630:*/ 0x2D, 0x13, 0x24, 0x84, 0x55, 0xA1, 0xE1, 0x6B, 0x9A, 0x45, 0xD2, 0xAA, 0x44, 0x4C, 0x5D, 0xB4, 
/*3640:*/ 0xCA, 0xE9, 0xF0, 0x51, 0x1C, 0x53, 0x14, 0x15, 0x5E, 0x8C, 0x7B, 0xD8, 0x3B, 0x22, 0x07, 0x87, 
/*3650:*/ 0xAB, 0xD1, 0xD3, 0x0E, 0x3D, 0x72, 0xD9, 0x4A, 0x57, 0x89, 0xDA, 0xB2, 0x16, 0x42, 0x66, 0x51, 
/*3660:*/ 0x79, 0xE7, 0xE8, 0x15, 0xB6, 0x45, 0x9D, 0x23, 0x3E, 0x77, 0xA8, 0x9D, 0xB9, 0xB0, 0x7A, 0x35, 
/*3670:*/ 0x3E, 0x77, 0xA8, 0x9D, 0x0C, 0x48, 0x3A, 0x3A, 0xA1, 0x44, 0x3D, 0x80, 0x48, 0xF6, 0x2D, 0x5F, 
/*3680:*/ 0x5F, 0xF2, 0xFA, 0xF6, 0xFC, 0x8A, 0x20, 0xF0, 0x7A, 0x1A, 0xB6, 0x8B, 0x01, 0x62, 0x83, 0xE7, 
/*3690:*/ 0x6A, 0xAB, 0x24, 0xB1, 0x59, 0x72, 0x6E, 0xA4, 0x7C, 0x77, 0x4B, 0xD7, 0xCF, 0x7E, 0x80, 0xB6, 
/*36A0:*/ 0x59, 0x6B, 0x25, 0xE6, 0x87, 0xA3, 0x0D, 0x5B, 0x84, 0xE6, 0x91, 0xA6, 0x12, 0xE9, 0xB6, 0xBE, 
/*36B0:*/ 0x88, 0x8D, 0xF5, 0x4B, 0x8E, 0xB3, 0xD6, 0xCA, 0x2F, 0x67, 0xDA, 0xAC, 0xC8, 0xF7, 0x44, 0xFE, 
/*36C0:*/ 0x41, 0x0F, 0x82, 0xFB, 0xC1, 0xF6, 0x2F, 0x66, 0xFD, 0x68, 0x02, 0x03, 0xDE, 0x02, 0x1C, 0xBD, 
/*36D0:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0xE8, 0x83, 0x83, 0x7C, 0x31, 0xDB, 0xF4, 0x11, 0xED, 0x06, 0x1B, 0xEA, 
/*36E0:*/ 0x27, 0xC0, 0xD0, 0x4C, 0x78, 0xBE, 0x58, 0x61, 0x84, 0x8E, 0xCA, 0xB6, 0x0C, 0x48, 0x3A, 0x3A, 
/*36F0:*/ 0x30, 0xD9, 0x62, 0x05, 0xAC, 0xD9, 0x82, 0x35, 0xBC, 0x9B, 0x2F, 0xC1, 0x59, 0x03, 0xA8, 0x1A, 
/*3700:*/ 0x72, 0xCE, 0xA1, 0xE6, 0xFD, 0x70, 0xEB, 0xC1, 0x52, 0x1B, 0x4B, 0xEE, 0x0B, 0x94, 0x45, 0xA7, 
/*3710:*/ 0x08, 0xBD, 0xC5, 0x11, 0xFC, 0xB8, 0x3C, 0xEB, 0xD5, 0x80, 0xA1, 0x41, 0xA2, 0x61, 0x35, 0x41, 
/*3720:*/ 0x3B, 0x5C, 0x56, 0x54, 0xAD, 0xBE, 0xFA, 0xE0, 0x77, 0xC8, 0x8F, 0x75, 0xC3, 0x79, 0x85, 0xAB, 
/*3730:*/ 0x3B, 0xFB, 0x95, 0x81, 0x2D, 0x4B, 0xA5, 0x82, 0x84, 0x8E, 0xCA, 0xB6, 0x65, 0xF8, 0xDE, 0x27, 
/*3740:*/ 0xC0, 0x18, 0x1D, 0xAE, 0x41, 0x0F, 0x82, 0xFB, 0x3F, 0x86, 0x27, 0xB9, 0xE2, 0x6D, 0x41, 0xB7, 
/*3750:*/ 0x28, 0x4C, 0x01, 0x90, 0xA7, 0x54, 0x4C, 0xAD, 0x03, 0x02, 0xB4, 0x2D, 0xCF, 0xC9, 0xD5, 0x98, 
/*3760:*/ 0x8C, 0x7F, 0x26, 0x4A, 0x50, 0x45, 0x07, 0xF0, 0xFC, 0xB8, 0x3C, 0xEB, 0x6C, 0x4E, 0xC0, 0x23, 
/*3770:*/ 0x9C, 0x26, 0xF2, 0x99, 0x69, 0x5E, 0x78, 0x07, 0x32, 0x39, 0x17, 0x0C, 0xD9, 0x27, 0xDA, 0xA5, 
/*3780:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0xBC, 0x9B, 0x2F, 0xC1, 0x89, 0xBB, 0xCE, 0xE7, 0x04, 0x47, 0x46, 0x11, 
/*3790:*/ 0xDB, 0x90, 0x37, 0x22, 0xB9, 0xB0, 0x7A, 0x35, 0x65, 0xF8, 0xDE, 0x27, 0xBB, 0x4B, 0x29, 0x9F, 
/*37A0:*/ 0xD3, 0x37, 0xFF, 0xEE, 0x18, 0x3A, 0x8E, 0x81, 0x87, 0xA3, 0x0D, 0x5B, 0x3B, 0x5C, 0x56, 0x54, 
/*37B0:*/ 0x3E, 0x77, 0xA8, 0x9D, 0xA8, 0x21, 0x62, 0x44, 0x55, 0xAF, 0xCB, 0x7D, 0x8D, 0xCA, 0x5F, 0x62, 
/*37C0:*/ 0x0B, 0x91, 0x90, 0x54, 0xD9, 0xB8, 0x25, 0xCB, 0x04, 0x47, 0x46, 0x11, 0xCA, 0x62, 0xA6, 0x46, 
/*37D0:*/ 0x76, 0x0E, 0x7F, 0x97, 0x5F, 0xF2, 0xFA, 0xF6, 0xC3, 0x79, 0x85, 0xAB, 0x93, 0x60, 0x00, 0x4C, 
/*37E0:*/ 0x30, 0x52, 0xB4, 0xEB, 0x95, 0xCB, 0x9B, 0xC3, 0x86, 0xBD, 0xE9, 0x78, 0x49, 0xE4, 0x72, 0xD0, 
/*37F0:*/ 0x43, 0x6C, 0xEF, 0x92, 0xBD, 0x41, 0xBE, 0x36, 0x4D, 0x74, 0xF8, 0x85, 0x91, 0xB3, 0x84, 0xAB, 
/*3800:*/ 0x6C, 0xD3, 0xE5, 0x55, 0xE6, 0x05, 0x3C, 0xDF, 0x9C, 0x26, 0xF2, 0x99, 0xD4, 0x56, 0x59, 0x6D, 
/*3810:*/ 0xE6, 0x1C, 0xB6, 0x87, 0x72, 0x38, 0xA6, 0x78, 0xD2, 0xA0, 0x78, 0x54, 0xDC, 0xBD, 0x76, 0x19, 
/*3820:*/ 0x99, 0x7B, 0x6F, 0xC5, 0x8E, 0xB3, 0xD6, 0xCA, 0x16, 0xCE, 0xEE, 0xEB, 0x0B, 0x91, 0x90, 0x54, 
/*3830:*/ 0xD8, 0x7C, 0x3C, 0x08, 0xA1, 0xDC, 0x17, 0xE0, 0x6D, 0x08, 0x98, 0x24, 0xE6, 0x05, 0x3C, 0xDF, 
/*3840:*/ 0x5F, 0xF2, 0xFA, 0xF6, 0x0B, 0x91, 0x90, 0x54, 0x95, 0xCB, 0x9B, 0xC3, 0x2F, 0x1F, 0xC8, 0xD8, 
/*3850:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*3860:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_D[] = {
/*3E28:*/ 0x59, 0x6B, 0x25, 0xE6, 0x0B, 0x91, 0x90, 0x54, 
/*3E30:*/ 0x04, 0xDE, 0x4C, 0x7C, 0x14, 0xD0, 0xDE, 0x5E, 0xE4, 0x4E, 0x30, 0x3A, 0x19, 0x1C, 0x75, 0x90, 
/*3E40:*/ 0x3D, 0x72, 0xD9, 0x4A, 0x53, 0xE5, 0xF5, 0x0D, 0x55, 0xA1, 0xE1, 0x6B, 0x9E, 0xE0, 0xC6, 0x8C, 
/*3E50:*/ 0x99, 0x7B, 0x6F, 0xC5, 0x04, 0x47, 0x46, 0x11, 0xD2, 0xA0, 0x78, 0x54, 0xCA, 0x62, 0xA6, 0x46, 
/*3E60:*/ 0x87, 0xA3, 0x0D, 0x5B, 0x8D, 0x6C, 0x70, 0x47, 0x63, 0xD9, 0xBE, 0x5C, 0x88, 0x5D, 0xD3, 0xB7, 
/*3E70:*/ 0x04, 0xEA, 0xA7, 0x28, 0x72, 0x5F, 0x47, 0x67, 0x0C, 0x36, 0xC2, 0xE3, 0xFC, 0x8A, 0x20, 0xF0, 
/*3E80:*/ 0xB9, 0xB0, 0x7A, 0x35, 0xFC, 0x2C, 0x50, 0x09, 0x95, 0xCB, 0x9B, 0xC3, 0x77, 0xF6, 0x5E, 0xC9, 
/*3E90:*/ 0xE6, 0xD3, 0x65, 0xF8, 0x00, 0x31, 0x68, 0x11, 0x7E, 0xB6, 0xC1, 0x8E, 0x06, 0x8C, 0x28, 0x9D, 
/*3EA0:*/ 0x30, 0xD9, 0x62, 0x05, 0x8E, 0xB3, 0xD6, 0xCA, 0x3E, 0x2C, 0x92, 0xD5, 0xC1, 0xF6, 0x2F, 0x66, 
/*3EB0:*/ 0x8C, 0x7F, 0x26, 0x4A, 0x4A, 0xDF, 0x4D, 0xF0, 0x05, 0x6E, 0x54, 0x33, 0x55, 0xA1, 0xE1, 0x6B, 
/*3EC0:*/ 0x04, 0xEA, 0xA7, 0x28, 0xE6, 0x05, 0x3C, 0xDF, 0x41, 0x0F, 0x82, 0xFB, 0x2B, 0xCE, 0x76, 0xE4, 
/*3ED0:*/ 0x01, 0x30, 0x5A, 0xF7, 0x34, 0x2E, 0x7D, 0x84, 0x8C, 0x6D, 0x9F, 0x7A, 0x3B, 0x22, 0x07, 0x87, 
/*3EE0:*/ 0xA3, 0xAE, 0xC3, 0xFA, 0xC0, 0xA2, 0x3F, 0xEA, 0xE6, 0xD3, 0x65, 0xF8, 0xCB, 0x53, 0xD3, 0xFF, 
/*3EF0:*/ 0xCC, 0x79, 0x89, 0x67, 0x85, 0x9D, 0xF0, 0x35, 0xBC, 0x9B, 0x2F, 0xC1, 0x91, 0x24, 0x1D, 0x9F, 
/*3F00:*/ 0xE1, 0x24, 0x92, 0x9E, 0xE1, 0x24, 0x92, 0x9E, 0x6C, 0x3C, 0x44, 0x49, 0xC0, 0x00, 0x3D, 0xCA, 
/*3F10:*/ 0xB2, 0x0E, 0xC0, 0x25, 0x50, 0x45, 0x07, 0xF0, 0x16, 0x42, 0x66, 0x51, 0x93, 0x60, 0x00, 0x4C, 
/*3F20:*/ 0x4D, 0x01, 0x6B, 0x7A, 0x01, 0x42, 0xCD, 0xC9, 0x72, 0x38, 0xA6, 0x78, 0x33, 0x94, 0x16, 0xD9, 
/*3F30:*/ 0xCF, 0x7E, 0x80, 0xB6, 0xFC, 0xB8, 0x3C, 0xEB, 0xD9, 0xB8, 0x25, 0xCB, 0xE0, 0x58, 0x7A, 0x6F, 
/*3F40:*/ 0xB9, 0xB0, 0x7A, 0x35, 0xA7, 0x54, 0x4C, 0xAD, 0x58, 0xF3, 0x41, 0xBF, 0xAB, 0xD1, 0xD3, 0x0E, 
/*3F50:*/ 0xEC, 0x88, 0xC7, 0xDB, 0xA0, 0x18, 0x0B, 0x31, 0x3E, 0xF1, 0xB5, 0x10, 0x35, 0xFF, 0xB0, 0x1A, 
/*3F60:*/ 0x70, 0x6E, 0x67, 0xDF, 0xFC, 0x8A, 0x20, 0xF0, 0x01, 0x62, 0x83, 0xE7, 0xFC, 0x8A, 0x20, 0xF0, 
/*3F70:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0xB0, 0x93, 0x08, 0x65, 0x87, 0xA3, 0x0D, 0x5B, 0x0B, 0x91, 0x90, 0x54, 
/*3F80:*/ 0x84, 0xE6, 0x91, 0xA6, 0x38, 0x3C, 0x18, 0x72, 0xD7, 0xE3, 0xE9, 0x28, 0x12, 0xE9, 0xB6, 0xBE, 
/*3F90:*/ 0x25, 0x32, 0x51, 0x73, 0x4F, 0xBE, 0x7E, 0xBA, 0xDC, 0xBD, 0x76, 0x19, 0x27, 0xC0, 0xD0, 0x4C, 
/*3FA0:*/ 0x30, 0xD9, 0x62, 0x05, 0x44, 0x09, 0xC7, 0xED, 0x48, 0xE6, 0x76, 0x2D, 0x3B, 0xE7, 0x29, 0xC7, 
/*3FB0:*/ 0x3E, 0xCA, 0xD9, 0x17, 0x01, 0x62, 0x83, 0xE7, 0xD7, 0x9F, 0x82, 0x50, 0x8E, 0x92, 0x63, 0xB0, 
/*3FC0:*/ 0x31, 0xEA, 0x4D, 0xAD, 0x3F, 0x86, 0x27, 0xB9, 0xC5, 0x0F, 0xC0, 0xC6, 0xFD, 0x72, 0xC3, 0xA8, 
/*3FD0:*/ 0xC0, 0x00, 0x3D, 0xCA, 0x72, 0x38, 0xA6, 0x78, 0x29, 0x78, 0x60, 0x9B, 0xAD, 0x45, 0x93, 0x08, 
/*3FE0:*/ 0xB5, 0x99, 0x8F, 0xB7, 0x88, 0x5D, 0xD3, 0xB7, 0x4B, 0x91, 0x59, 0xAA, 0xC0, 0x94, 0x54, 0xC9, 
/*3FF0:*/ 0x70, 0x6E, 0x67, 0xDF, 0xAB, 0xD1, 0xD3, 0x0E, 0x61, 0xE8, 0x92, 0xBB, 0x02, 0x44, 0x8C, 0xB9, 
/*4000:*/ 0xFD, 0x68, 0x02, 0x03, 0xFD, 0x68, 0x02, 0x03, 0x9E, 0xE0, 0xC6, 0x8C, 0xCC, 0x79, 0x89, 0x67, 
/*4010:*/ 0x91, 0x24, 0x1D, 0x9F, 0xA4, 0xF8, 0x7B, 0x5B, 0xA8, 0xB8, 0x38, 0x0A, 0xEC, 0xC6, 0xB5, 0x4C, 
/*4020:*/ 0xA9, 0x20, 0xF4, 0x24, 0xA8, 0x21, 0x62, 0x44, 0x33, 0x94, 0x16, 0xD9, 0xDD, 0xB8, 0xF4, 0x8F, 
/*4030:*/ 0xDB, 0x90, 0x37, 0x22, 0xC0, 0xA2, 0x3F, 0xEA, 0x8E, 0x92, 0x63, 0xB0, 0xF4, 0x2A, 0x00, 0x0E, 
/*4040:*/ 0xC3, 0x79, 0x85, 0xAB, 0x84, 0x8E, 0xCA, 0xB6, 0x12, 0xBC, 0x59, 0xD4, 0x17, 0x08, 0x0D, 0x3F, 
/*4050:*/ 0x9A, 0x45, 0xD2, 0xAA, 0xD2, 0x1D, 0x28, 0xFD, 0xC6, 0x71, 0xAD, 0x6F, 0x12, 0xF1, 0xCE, 0xFD, 
/*4060:*/ 0xFC, 0x8A, 0x20, 0xF0, 0xDF, 0xC7, 0x1C, 0x7D, 0x1A, 0x22, 0xCB, 0x38, 0x4F, 0xA6, 0xC1, 0x11, 
/*4070:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0x52, 0xE5, 0x37, 0xD4, 0x3E, 0x54, 0xED, 0x1F, 0x55, 0xAF, 0xCB, 0x7D, 
/*4080:*/ 0x5D, 0x65, 0xB5, 0x0A, 0x2E, 0x7B, 0x7B, 0xBD, 0x31, 0xAF, 0x65, 0x25, 0xC0, 0x00, 0x3D, 0xCA, 
/*4090:*/ 0x63, 0xD9, 0xBE, 0x5C, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*40A0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_E[] = {
/*4698:*/ 0x68, 0x36, 0xD9, 0x72, 0x87, 0xA3, 0x0D, 0x5B, 
/*46A0:*/ 0x0B, 0x91, 0x90, 0x54, 0x44, 0x09, 0xC7, 0xED, 0xDD, 0xB8, 0xF4, 0x8F, 0xE6, 0x1C, 0xB6, 0x87, 
/*46B0:*/ 0xC3, 0x79, 0x85, 0xAB, 0x24, 0x1A, 0xBF, 0x03, 0x59, 0x72, 0x6E, 0xA4, 0x30, 0x52, 0xB4, 0xEB, 
/*46C0:*/ 0x1A, 0x22, 0xCB, 0x38, 0xE6, 0x1C, 0xB6, 0x87, 0x53, 0xE5, 0xF5, 0x0D, 0x30, 0xC5, 0x0D, 0x6C, 
/*46D0:*/ 0xF4, 0x2A, 0x00, 0x0E, 0xC5, 0x21, 0xEF, 0xFE, 0x45, 0xCF, 0xD3, 0x8B, 0xC3, 0x37, 0xAD, 0x8F, 
/*46E0:*/ 0x78, 0xBE, 0x58, 0x61, 0x51, 0x07, 0x91, 0xBA, 0x2D, 0xC1, 0xCA, 0x89, 0x53, 0xE5, 0xF5, 0x0D, 
/*46F0:*/ 0x63, 0xD9, 0xBE, 0x5C, 0xB4, 0x1E, 0x49, 0xD5, 0x4F, 0xA6, 0xC1, 0x11, 0x87, 0xA3, 0x0D, 0x5B, 
/*4700:*/ 0x7C, 0x77, 0x4B, 0xD7, 0xE3, 0xA6, 0xD3, 0x18, 0x9D, 0x62, 0x7B, 0x14, 0x1B, 0xA6, 0x0E, 0x00, 
/*4710:*/ 0x8E, 0x92, 0x63, 0xB0, 0xC8, 0xF7, 0x44, 0xFE, 0xA1, 0x44, 0x3D, 0x80, 0xFE, 0x94, 0x13, 0x1E, 
/*4720:*/ 0x41, 0x0F, 0x82, 0xFB, 0x26, 0xAF, 0x6F, 0xC0, 0x5A, 0x6C, 0x52, 0x04, 0x4B, 0x91, 0x59, 0xAA, 
/*4730:*/ 0x0E, 0xE5, 0xEF, 0x22, 0xC9, 0x17, 0xFF, 0x0E, 0x03, 0x02, 0xB4, 0x2D, 0x43, 0xDF, 0xC5, 0x2E, 
/*4740:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0x12, 0xD1, 0x59, 0x1B, 0x22, 0xA2, 0x25, 0xBA, 0x6D, 0x08, 0x98, 0x24, 
/*4750:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0x93, 0x60, 0x00, 0x4C, 0x03, 0x59, 0x9A, 0x4E, 0x06, 0xFF, 0xC3, 0x32, 
/*4760:*/ 0x84, 0xE6, 0x91, 0xA6, 0x5B, 0x7C, 0xE7, 0xB9, 0xAD, 0xBE, 0xFA, 0xE0, 0x72, 0x38, 0xA6, 0x78, 
/*4770:*/ 0x88, 0x8D, 0xF5, 0x4B, 0x1A, 0x22, 0xCB, 0x38, 0x0B, 0x91, 0x90, 0x54, 0xC0, 0x00, 0x3D, 0xCA, 
/*4780:*/ 0x1B, 0xA6, 0x0E, 0x00, 0x2D, 0xEA, 0x0D, 0x1D, 0x86, 0xBD, 0xE9, 0x78, 0xA3, 0xBD, 0x45, 0x9C, 
/*4790:*/ 0xE6, 0xD3, 0x65, 0xF8, 0xC4, 0x68, 0xAC, 0x83, 0x95, 0xCB, 0x9B, 0xC3, 0x63, 0xD9, 0xBE, 0x5C, 
/*47A0:*/ 0xAD, 0xBE, 0xFA, 0xE0, 0x4D, 0x74, 0xF8, 0x85, 0x02, 0x44, 0x8C, 0xB9, 0xE2, 0x99, 0xC6, 0x51, 
/*47B0:*/ 0x9A, 0x45, 0xD2, 0xAA, 0x12, 0x7A, 0x2C, 0xF2, 0x00, 0x31, 0x68, 0x11, 0x04, 0xEA, 0xA7, 0x28, 
/*47C0:*/ 0xD8, 0x99, 0x2C, 0xB7, 0x12, 0x7A, 0x2C, 0xF2, 0xE5, 0x0C, 0x47, 0x24, 0xC9, 0x17, 0xFF, 0x0E, 
/*47D0:*/ 0xE6, 0xD3, 0x65, 0xF8, 0x05, 0xAD, 0xAB, 0x34, 0xDD, 0xB8, 0xF4, 0x8F, 0xB9, 0x17, 0x54, 0x7B, 
/*47E0:*/ 0x4F, 0xBE, 0x7E, 0xBA, 0x75, 0x80, 0x94, 0x83, 0x9E, 0x43, 0xAF, 0x3B, 0x01, 0x62, 0x83, 0xE7, 
/*47F0:*/ 0x38, 0x8D, 0x3D, 0x7F, 0xB9, 0xB0, 0x7A, 0x35, 0xB9, 0xB0, 0x7A, 0x35, 0xDF, 0xC7, 0x1C, 0x7D, 
/*4800:*/ 0x44, 0x09, 0xC7, 0xED, 0xEF, 0x02, 0xF1, 0x1F, 0x30, 0xC5, 0x0D, 0x6C, 0x91, 0x24, 0x1D, 0x9F, 
/*4810:*/ 0xC2, 0xEF, 0x17, 0x8C, 0x78, 0xBE, 0x58, 0x61, 0x49, 0xE4, 0x72, 0xD0, 0x72, 0x38, 0xA6, 0x78, 
/*4820:*/ 0xC5, 0x21, 0xEF, 0xFE, 0xCF, 0x7E, 0x80, 0xB6, 0x1A, 0xD8, 0xBC, 0x1F, 0xF9, 0xA8, 0xD0, 0xE2, 
/*4830:*/ 0xC3, 0x68, 0x4D, 0xA0, 0xEC, 0x88, 0xC7, 0xDB, 0x31, 0xAF, 0x65, 0x25, 0x23, 0xA4, 0x9B, 0x3E, 
/*4840:*/ 0x38, 0x3C, 0x18, 0x72, 0x65, 0x1C, 0x74, 0x7F, 0x45, 0xCF, 0x2B, 0x5E, 0x55, 0x59, 0xA8, 0xF2, 
/*4850:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0xC3, 0x68, 0x4D, 0xA0, 0x04, 0x47, 0x46, 0x11, 0x2D, 0xEA, 0x0D, 0x1D, 
/*4860:*/ 0x03, 0x02, 0xB4, 0x2D, 0xC3, 0x79, 0x85, 0xAB, 0x02, 0x6F, 0xC8, 0xEA, 0x28, 0x4C, 0x01, 0x90, 
/*4870:*/ 0xCB, 0xCC, 0xC1, 0xC4, 0x08, 0xBD, 0xC5, 0x11, 0xCE, 0x1C, 0x58, 0x49, 0x0B, 0x91, 0x90, 0x54, 
/*4880:*/ 0x89, 0xBB, 0xCE, 0xE7, 0x8E, 0x92, 0x63, 0xB0, 0x04, 0x47, 0x46, 0x11, 0xDF, 0xC7, 0x1C, 0x7D, 
/*4890:*/ 0x03, 0x02, 0xB4, 0x2D, 0x48, 0xE6, 0x76, 0x2D, 0x55, 0xAF, 0xCB, 0x7D, 0xC3, 0x37, 0xAD, 0x8F, 
/*48A0:*/ 0x43, 0xAA, 0xB9, 0x19, 0xA3, 0xAE, 0xC3, 0xFA, 0xB9, 0xB0, 0x7A, 0x35, 0x1B, 0xA6, 0x0E, 0x00, 
/*48B0:*/ 0x1A, 0x22, 0xCB, 0x38, 0x32, 0x39, 0x17, 0x0C, 0x1E, 0xAA, 0x3D, 0x3F, 0xD8, 0x7C, 0x3C, 0x08, 
/*48C0:*/ 0x3E, 0x54, 0xED, 0x1F, 0x45, 0xCF, 0x2B, 0x5E, 0x3E, 0xCA, 0xD9, 0x17, 0x15, 0x04, 0x21, 0x64, 
/*48D0:*/ 0x04, 0x47, 0x46, 0x11, 0x92, 0x82, 0xF5, 0xB9, 0xE4, 0x4E, 0x30, 0x3A, 0x11, 0x43, 0xBF, 0x52, 
/*48E0:*/ 0x30, 0x52, 0xB4, 0xEB, 0x01, 0xD7, 0x5F, 0xC0, 0x9A, 0x45, 0xD2, 0xAA, 0xEB, 0x76, 0x06, 0x7B, 
/*48F0:*/ 0x8E, 0x92, 0x63, 0xB0, 0x12, 0x7A, 0x2C, 0xF2, 0x5B, 0x25, 0xF1, 0x26, 0x8E, 0xB3, 0xD6, 0xCA, 
/*4900:*/ 0xBC, 0x9B, 0x2F, 0xC1, 0xC6, 0x71, 0xAD, 0x6F, 0x8E, 0xB3, 0xD6, 0xCA, 0x4B, 0x91, 0x59, 0xAA, 
/*4910:*/ 0x19, 0x1A, 0x36, 0xD0, 0x15, 0x5D, 0x3E, 0xDE, 0x8E, 0x23, 0x09, 0xF3, 0x45, 0xCF, 0xD3, 0x8B, 
/*4920:*/ 0x29, 0x78, 0x60, 0x9B, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*4930:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B6D2_F[] = {
/*4F78:*/ 0x53, 0xE5, 0xF5, 0x0D, 0x76, 0x0E, 0x7F, 0x97, 
/*4F80:*/ 0xFD, 0x70, 0xEB, 0xC1, 0x69, 0x28, 0xA5, 0xF2, 0x8E, 0x11, 0x1D, 0xA3, 0xA9, 0x86, 0xA4, 0x12, 
/*4F90:*/ 0x59, 0x72, 0x6E, 0xA4, 0x77, 0xC8, 0x8F, 0x75, 0xFC, 0xB8, 0x3C, 0xEB, 0x3A, 0x72, 0xF6, 0x53, 
/*4FA0:*/ 0xF6, 0x3F, 0xAB, 0xDB, 0x58, 0xF3, 0x41, 0xBF, 0x5F, 0xF2, 0xFA, 0xF6, 0x4F, 0xBE, 0x7E, 0xBA, 
/*4FB0:*/ 0x93, 0x60, 0x00, 0x4C, 0x2F, 0x1F, 0xC8, 0xD8, 0x41, 0x0F, 0x82, 0xFB, 0x3B, 0xE7, 0x29, 0xC7, 
/*4FC0:*/ 0x3D, 0x72, 0xD9, 0x4A, 0x6E, 0x35, 0xFA, 0x9F, 0xB4, 0x69, 0x9F, 0x38, 0x48, 0xF6, 0x2D, 0x5F, 
/*4FD0:*/ 0x84, 0xE6, 0x91, 0xA6, 0xF7, 0x33, 0x41, 0x1A, 0x5D, 0x20, 0x4E, 0x4E, 0xEC, 0x76, 0x94, 0x37, 
/*4FE0:*/ 0xB4, 0x69, 0x9F, 0x38, 0x6D, 0x08, 0x98, 0x24, 0xFC, 0xA4, 0x4A, 0xBD, 0x5E, 0xAC, 0xB2, 0x86, 
/*4FF0:*/ 0xA4, 0xCC, 0xA3, 0x0A, 0x77, 0xA4, 0xCE, 0x28, 0x64, 0xA6, 0xD4, 0xF0, 0x84, 0xE6, 0x91, 0xA6, 
/*5000:*/ 0xA0, 0x18, 0x0B, 0x31, 0x6C, 0xD3, 0xE5, 0x55, 0x00, 0xBC, 0x1A, 0xC2, 0xC0, 0x94, 0x54, 0xC9, 
/*5010:*/ 0xF2, 0xD1, 0x99, 0xBC, 0x05, 0xB0, 0x7F, 0x45, 0x5B, 0x1A, 0x7E, 0x64, 0x0C, 0x31, 0xB7, 0x7D, 
/*5020:*/ 0x8E, 0xB3, 0xD6, 0xCA, 0x41, 0x0F, 0x82, 0xFB, 0x9C, 0x26, 0xF2, 0x99, 0x38, 0x6D, 0xFD, 0x2D, 
/*5030:*/ 0x03, 0x59, 0x9A, 0x4E, 0x30, 0xC5, 0x0D, 0x6C, 0xAB, 0xD1, 0xD3, 0x0E, 0x6F, 0xEE, 0xE7, 0x2D, 
/*5040:*/ 0xDF, 0xC7, 0x1C, 0x7D, 0xD9, 0xB8, 0x25, 0xCB, 0x67, 0x0B, 0x9D, 0x26, 0x94, 0xE8, 0xA4, 0xD1, 
/*5050:*/ 0x3E, 0x77, 0xA8, 0x9D, 0xD2, 0x1D, 0x28, 0xFD, 0xD4, 0x56, 0x59, 0x6D, 0xE6, 0x05, 0x3C, 0xDF, 
/*5060:*/ 0x3E, 0x77, 0xA8, 0x9D, 0x58, 0xF3, 0x41, 0xBF, 0x43, 0xDF, 0xC5, 0x2E, 0x04, 0xDE, 0x4C, 0x7C, 
/*5070:*/ 0x3B, 0xFB, 0x95, 0x81, 0x38, 0x6D, 0xFD, 0x2D, 0x02, 0x6F, 0xC8, 0xEA, 0x43, 0xDF, 0xC5, 0x2E, 
/*5080:*/ 0x7B, 0x07, 0x82, 0x94, 0xE6, 0xD3, 0x65, 0xF8, 0x30, 0xC5, 0x0D, 0x6C, 0x1A, 0x22, 0xCB, 0x38, 
/*5090:*/ 0x1B, 0xBE, 0xBA, 0x74, 0x3E, 0x77, 0xA8, 0x9D, 0x7F, 0x7E, 0x86, 0xF1, 0xD2, 0xC8, 0x3B, 0x42, 
/*50A0:*/ 0xD8, 0x7C, 0x3C, 0x08, 0x15, 0x5D, 0x3E, 0xDE, 0xE0, 0x9C, 0x6D, 0x48, 0x99, 0x7B, 0x6F, 0xC5, 
/*50B0:*/ 0x4F, 0xA6, 0xC1, 0x11, 0x0C, 0x48, 0x3A, 0x3A, 0x10, 0x20, 0x84, 0x97, 0xB4, 0x1E, 0x49, 0xD5, 
/*50C0:*/ 0x57, 0x89, 0xDA, 0xB2, 0xCB, 0xCC, 0xC1, 0xC4, 0x05, 0x0A, 0xA5, 0xE5, 0xAC, 0xD9, 0x82, 0x35, 
/*50D0:*/ 0x5F, 0xF2, 0xFA, 0xF6, 0x15, 0x5D, 0x3E, 0xDE, 0xDD, 0x61, 0xC6, 0xD6, 0xF7, 0x33, 0x41, 0x1A, 
/*50E0:*/ 0xA7, 0x54, 0x4C, 0xAD, 0xFC, 0xB8, 0x3C, 0xEB, 0x1E, 0xE6, 0x3B, 0xD2, 0xA2, 0x54, 0x67, 0x83, 
/*50F0:*/ 0x8E, 0xB3, 0xD6, 0xCA, 0xF7, 0x33, 0x41, 0x1A, 0x52, 0xE5, 0x37, 0xD4, 0x1D, 0x84, 0xD9, 0x14, 
/*5100:*/ 0x43, 0x6C, 0xEF, 0x92, 0xA3, 0xAE, 0xC3, 0xFA, 0x57, 0x89, 0xDA, 0xB2, 0x6A, 0x19, 0xF9, 0x2F, 
/*5110:*/ 0x34, 0x2E, 0x7D, 0x84, 0x10, 0x20, 0x84, 0x97, 0xA8, 0x5F, 0xB1, 0x36, 0x59, 0x72, 0x6E, 0xA4, 
/*5120:*/ 0x74, 0x2F, 0xB8, 0xE3, 0x72, 0x38, 0xA6, 0x78, 0x79, 0xE7, 0x73, 0x3D, 0x88, 0x5D, 0xD3, 0xB7, 
/*5130:*/ 0x12, 0xD1, 0x59, 0x1B, 0xA4, 0xCC, 0xA3, 0x0A, 0x7E, 0xB6, 0xC1, 0x8E, 0x05, 0x7B, 0xD6, 0xA2, 
/*5140:*/ 0x3D, 0x76, 0x22, 0xB1, 0xAC, 0xD9, 0x82, 0x35, 0x53, 0xE5, 0xF5, 0x0D, 0x12, 0xBC, 0x59, 0xD4, 
/*5150:*/ 0x59, 0x72, 0x6E, 0xA4, 0x0B, 0x91, 0x90, 0x54, 0xE6, 0x05, 0x3C, 0xDF, 0xDC, 0xBD, 0x76, 0x19, 
/*5160:*/ 0xA2, 0x54, 0x67, 0x83, 0xEC, 0x88, 0xC7, 0xDB, 0x12, 0x7A, 0x2C, 0xF2, 0xC0, 0x00, 0x3D, 0xCA, 
/*5170:*/ 0xF1, 0xC8, 0xF9, 0x48, 0xD3, 0x69, 0xC4, 0x75, 0x8F, 0x08, 0x7C, 0x84, 0x16, 0x31, 0xE8, 0x05, 
/*5180:*/ 0xF2, 0xD1, 0x99, 0xBC, 0xE3, 0xA9, 0xC2, 0xC3, 0x57, 0x89, 0xDA, 0xB2, 0x3F, 0x71, 0x9A, 0x6A, 
/*5190:*/ 0x84, 0x8E, 0xCA, 0xB6, 0x01, 0xD7, 0x5F, 0xC0, 0xF6, 0x90, 0xE9, 0xDC, 0x02, 0x6D, 0x90, 0x88, 
/*51A0:*/ 0x48, 0xE6, 0x76, 0x2D, 0x12, 0xE9, 0xB6, 0xBE, 0x72, 0x38, 0xA6, 0x78, 0xA4, 0xCC, 0xA3, 0x0A, 
/*51B0:*/ 0x7D, 0x8C, 0xFD, 0x17, 0x59, 0x72, 0x6E, 0xA4, 0xE6, 0xD3, 0x65, 0xF8, 0x12, 0xD1, 0x59, 0x1B, 
/*51C0:*/ 0xD7, 0xE3, 0xE9, 0x28, 0x01, 0x62, 0x83, 0xE7, 0xE7, 0x01, 0x84, 0x50, 0x29, 0x78, 0x60, 0x9B, 
/*51D0:*/ 0xD3, 0x37, 0xFF, 0xEE, 0x3F, 0x71, 0x9A, 0x6A, 0x25, 0x32, 0x51, 0x73, 0x87, 0x35, 0xDF, 0x32, 
/*51E0:*/ 0xA9, 0x86, 0xA4, 0x12, 0x57, 0x89, 0xDA, 0xB2, 0x11, 0x43, 0xBF, 0x52, 0x00, 0x27, 0x01, 0xB8, 
/*51F0:*/ 0x48, 0xF6, 0x2D, 0x5F, 0x12, 0xD1, 0x59, 0x1B, 0x9E, 0xBD, 0x9F, 0x16, 0x0A, 0x4A, 0x75, 0x7B, 
/*5200:*/ 0x6C, 0x4E, 0xC0, 0x23, 0xD2, 0xA0, 0x78, 0x54, 0x84, 0xE6, 0x91, 0xA6, 0xC8, 0xF7, 0x44, 0xFE, 
/*5210:*/ 0x85, 0x9D, 0xF0, 0x35, 0x9C, 0x26, 0xF2, 0x99, 0x7E, 0x03, 0x73, 0x1D, 0x0C, 0x48, 0x3A, 0x3A, 
/*5220:*/ 0x41, 0x0F, 0x82, 0xFB, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*5230:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

void* Block6Data1[] = {
	B6D2_0,
	B6D2_1,
	B6D2_2,
	B6D2_3,
	B6D2_4,
	B6D2_5,
	B6D2_6,
	B6D2_7,
	B6D2_8,
	B6D2_9,
	B6D2_A,
	B6D2_B,
	B6D2_C,
	B6D2_D,
	B6D2_E,
	B6D2_F
};

void* Block6Funcs[] = {
	sub_48DC2D,
	sub_48DD35,
	sub_48DE3D,
	sub_48DF45,
	sub_48E04D,
	sub_48E155,
	sub_48E25D,
	sub_48E364,
	sub_48E46C,
	sub_48E574,
	sub_48E67C,
	sub_48E783,
	sub_48E88B,
	sub_48E993,
	sub_48EA9B,
	sub_48EBA3,
	sub_48ECAB,
	sub_48EDB3,
	sub_48EEBB,
	sub_48EFC3,
	sub_48F0CB,
	sub_48F1D3,
	sub_48F2DB,
	sub_48F3E3,
	sub_48F4EB,
	sub_48F5F3,
	sub_48F6FB,
	sub_48F803,
	sub_48F90B,
	sub_48FA13,
	sub_48FB1B,
	sub_48FC20,
	sub_48FD28,
	sub_48FE2F,
	sub_48FF37,
	sub_49003F,
	sub_490147,
	sub_49024F,
	sub_490356,
	sub_49045E,
	sub_490566,
	sub_49066E,
	sub_490776,
	sub_49087E,
	sub_490983,
	sub_490A8B,
	sub_490B93,
	sub_490C9B,
	sub_490DA3,
	sub_490EAB,
	sub_490FB3,
	sub_4910BB,
	sub_4911C3,
	sub_4912CB,
	sub_4913D3,
	sub_4914DB,
	sub_4915E3,
	sub_4916EB,
	sub_4917F3,
	sub_4918FB,
	sub_491A03,
	sub_491B0B,
	sub_491C13,
	sub_491D1B,
	sub_491E20,
	sub_491F28,
	sub_492030,
	sub_492138,
	sub_492240,
	sub_492345,
	sub_49244D,
	sub_492555,
	sub_49265C,
	sub_492764,
	sub_49286C,
	sub_492974,
	sub_492A7C,
	sub_492B81,
	sub_492C89,
	sub_492D91,
	sub_492E99,
	sub_492FA1,
	sub_4930A9,
	sub_4931B1,
	sub_4932B9,
	sub_4933C1,
	sub_4934C9,
	sub_4935D1,
	sub_4936D9,
	sub_4937E1,
	sub_4938E9,
	sub_4939F1,
	sub_493AF9,
	sub_493C01,
	sub_493D09,
	sub_493E11,
	sub_493F19,
	sub_494021,
	sub_494129,
	sub_494231,
	sub_494339,
	sub_494441,
	sub_494549,
	sub_494651,
	sub_494759,
	sub_494861,
	sub_494969,
	sub_494A71,
	sub_494B79,
	sub_494C81,
	sub_494D89,
	sub_494E91,
	sub_494F99,
	sub_4950A1,
	sub_4951A9,
	sub_4952B1,
	sub_4953B9,
	sub_4954BE,
	sub_4955C6,
	sub_4956CE,
	sub_4957D6,
	sub_4958DE,
	sub_4959E6,
	sub_495AEE,
	sub_495BF6,
	sub_495CFE,
	sub_495E06,
	sub_495F0E,
	sub_496016,
	sub_49611E,
	sub_496226,
	sub_49632E,
	sub_496436,
	sub_49653E,
	sub_496645,
	sub_49674D,
	sub_496855,
	sub_49695C,
	sub_496A64,
	sub_496B6C,
	sub_496C74,
	sub_496D7C,
	sub_496E84,
	sub_496F8C,
	sub_497094,
	sub_49719C,
	sub_4972A4,
	sub_4973AC,
	sub_4974B4,
	sub_4975BC,
	sub_4976C1,
	sub_4977C9,
	sub_4978D1,
	sub_4979D9,
	sub_497AE1,
	sub_497BE9,
	sub_497CF1,
	sub_497DF9,
	sub_497F01,
	sub_498009,
	sub_498111,
	sub_498219,
	sub_498321,
	sub_498429,
	sub_498531,
	sub_498639,
	sub_498740,
	sub_498848,
	sub_498950,
	sub_498A58,
	sub_498B5D,
	sub_498C65,
	sub_498D6D,
	sub_498E75,
	sub_498F7D,
	sub_499085,
	sub_49918D,
	sub_499295,
	sub_49939D,
	sub_4994A5,
	sub_4995AA,
	sub_4996B2,
	sub_4997BA,
	sub_4998C2,
	sub_4999CA,
	sub_499AD2,
	sub_499BDA,
	sub_499CDF,
	sub_499DE7,
	sub_499EEF,
	sub_499FF7,
	sub_49A0FF,
	sub_49A207,
	sub_49A30F,
	sub_49A417,
	sub_49A51F,
	sub_49A627,
	sub_49A72F,
	sub_49A836,
	sub_49A93E,
	sub_49AA46,
	sub_49AB4E,
	sub_49AC56,
	sub_49AD5E,
	sub_49AE66,
	sub_49AF6E,
	sub_49B076,
	sub_49B17E,
	sub_49B286,
	sub_49B38E,
	sub_49B496,
	sub_49B59E,
	sub_49B6A6,
	sub_49B7AE,
	sub_49B8B6,
	sub_49B9BE,
	sub_49BAC6,
	sub_49BBCE,
	sub_49BCD6,
	sub_49BDDE,
	sub_49BEE6,
	sub_49BFEE,
	sub_49C0F6,
	sub_49C1FB,
	sub_49C303,
	sub_49C40B,
	sub_49C512,
	sub_49C61A,
	sub_49C722,
	sub_49C82A,
	sub_49C932,
	sub_49CA3A,
	sub_49CB42,
	sub_49CC4A,
	sub_49CD52,
	sub_49CE5A,
	sub_49CF62,
	sub_49D06A,
	sub_49D172,
	sub_49D27A,
	sub_49D382,
	sub_49D48A,
	sub_49D592,
	sub_49D69A,
	sub_49D7A2,
	sub_49D8AA,
	sub_49D9B2,
	sub_49DABA,
	sub_49DBC2,
	sub_49DCCA,
	sub_49DDD2,
	sub_49DED7,
	sub_49DFDF,
	sub_49E0E7,
	sub_49E1EF,
	sub_49E2F7
};


BYTE dword_4DF3C0[] = {
/*0000:*/ 0x6B, 0x5F, 0xAD, 0x79, 0x21, 0x59, 0xAD, 0x79, 0x03, 0x67, 0x7B, 0xB2, 0xD9, 0xC2, 0xD3, 0x06, 
/*0010:*/ 0xD8, 0x07, 0x4F, 0xCB, 0xC9, 0x00, 0xF9, 0x22, 0x73, 0xF0, 0x84, 0xC3, 0xE3, 0xDA, 0xFC, 0xB7, 
/*0020:*/ 0xA9, 0x4E, 0x96, 0xDF, 0x6A, 0x56, 0xAC, 0x09, 0xD3, 0x55, 0x42, 0x46, 0x7E, 0xFB, 0x08, 0x94, 
/*0030:*/ 0xC1, 0xBD, 0x62, 0xE3, 0x30, 0x2D, 0x00, 0xE4, 0x32, 0xC6, 0xAE, 0x0B, 0x73, 0xE2, 0x7D, 0x3A, 
/*0040:*/ 0xB8, 0x0C, 0xAD, 0x79, 0x95, 0x1C, 0x9E, 0xCB, 0x4D, 0xAE, 0x9E, 0xCB, 0x19, 0xB8, 0x36, 0x7F, 
/*0050:*/ 0x08, 0x96, 0xAA, 0xB2, 0x32, 0x94, 0x1C, 0x5B, 0x50, 0x12, 0x6E, 0xBA, 0x39, 0xE6, 0x19, 0xCE, 
/*0060:*/ 0xA5, 0xC8, 0x73, 0xA6, 0x93, 0xFA, 0x49, 0x70, 0x5B, 0x43, 0xA7, 0x3F, 0x20, 0x93, 0xED, 0xED, 
/*0070:*/ 0x32, 0xCE, 0x87, 0x9A, 0xA7, 0x46, 0xE5, 0x9D, 0x1A, 0xA6, 0x4B, 0x72, 0x79, 0xFA, 0x98, 0x43, 
/*0080:*/ 0xCC, 0x3E, 0x7B, 0xB2, 0x8D, 0x72, 0x9E, 0xCB, 0x49, 0x75, 0xE0, 0xB4, 0xF1, 0xD2, 0xEF, 0xB4, 
/*0090:*/ 0xF7, 0xAB, 0x7C, 0x79, 0xD9, 0xB3, 0xCA, 0x90, 0xD9, 0x01, 0xB8, 0x71, 0x4D, 0x37, 0xCF, 0x05, 
/*00A0:*/ 0x35, 0x8B, 0xA5, 0x6D, 0xA5, 0x33, 0x9F, 0xBB, 0x04, 0xC9, 0x71, 0xF4, 0x68, 0x94, 0x3B, 0x26, 
/*00B0:*/ 0xD0, 0xAA, 0x51, 0x51, 0xD4, 0xB8, 0x33, 0x56, 0xF6, 0xB9, 0x9D, 0xB9, 0x8D, 0x4D, 0x4E, 0x88, 
/*00C0:*/ 0xCB, 0x53, 0xD3, 0x06, 0x82, 0x5F, 0x36, 0x7F, 0x14, 0xA6, 0xE0, 0xB4, 0x84, 0x0D, 0xD4, 0xCD, 
/*00D0:*/ 0x41, 0xED, 0xD4, 0xCD, 0xA3, 0xD8, 0x62, 0x24, 0xDF, 0x54, 0x10, 0xC5, 0x55, 0xFB, 0x67, 0xB1, 
/*00E0:*/ 0x83, 0xDE, 0x0D, 0xD9, 0x20, 0x25, 0x37, 0x0F, 0x4D, 0x49, 0xD9, 0x40, 0x2F, 0x47, 0x93, 0x92, 
/*00F0:*/ 0x5C, 0x4A, 0xF6, 0xE5, 0x6F, 0x42, 0x9B, 0xE2, 0xCA, 0x23, 0x35, 0x0D, 0xC0, 0xBF, 0xE6, 0x3C, 
/*0100:*/ 0x61, 0xD3, 0x4F, 0xCB, 0x2F, 0xA6, 0xAA, 0xB2, 0x9F, 0xA0, 0x7C, 0x79, 0xD4, 0xBC, 0xD4, 0xCD, 
/*0110:*/ 0x29, 0x36, 0xFE, 0xE9, 0xB5, 0xD2, 0xFE, 0xE9, 0x26, 0x6B, 0x8C, 0x08, 0xFC, 0x9C, 0xFB, 0x7C, 
/*0120:*/ 0xDF, 0xAC, 0x9E, 0x14, 0x90, 0x2F, 0xAB, 0xC2, 0x41, 0x9E, 0x45, 0x8D, 0xDE, 0x74, 0x0F, 0x5F, 
/*0130:*/ 0xA4, 0x21, 0x65, 0x28, 0x78, 0x60, 0x07, 0x2F, 0xD6, 0x5B, 0xA9, 0xC0, 0x80, 0x8C, 0x7A, 0xF1, 
/*0140:*/ 0xDA, 0x17, 0xF9, 0x22, 0xE4, 0xBD, 0x1C, 0x5B, 0xE1, 0xAC, 0xCA, 0x90, 0xD6, 0x88, 0x62, 0x24, 
/*0150:*/ 0xBF, 0xB4, 0xFE, 0xE9, 0x83, 0xC8, 0x3A, 0xE1, 0x58, 0x82, 0x3A, 0xE1, 0xF0, 0xE0, 0x4D, 0x95, 
/*0160:*/ 0xFC, 0xED, 0x27, 0xFD, 0xE6, 0x00, 0x1D, 0x2B, 0xAE, 0x0E, 0xF3, 0x64, 0x54, 0xD7, 0xB9, 0xB6, 
/*0170:*/ 0x01, 0x60, 0xD3, 0xC1, 0x99, 0xC1, 0xB1, 0xC6, 0xCD, 0x13, 0x1F, 0x29, 0xDF, 0x9C, 0xCC, 0x18, 
/*0180:*/ 0x80, 0x21, 0x8B, 0xC3, 0x88, 0x10, 0x6E, 0xBA, 0x5A, 0x25, 0xB8, 0x71, 0xEA, 0x0B, 0x10, 0xC5, 
/*0190:*/ 0xF7, 0x70, 0x8C, 0x08, 0x2A, 0x8F, 0x3A, 0xE1, 0x74, 0xC9, 0x3F, 0x74, 0x3C, 0x9F, 0x3F, 0x74, 
/*01A0:*/ 0x24, 0xEC, 0x55, 0x1C, 0x17, 0xA5, 0x6F, 0xCA, 0x20, 0xA3, 0x81, 0x85, 0xDE, 0xA4, 0xCB, 0x57, 
/*01B0:*/ 0x01, 0x44, 0xA1, 0x20, 0x48, 0x5A, 0xC3, 0x27, 0x39, 0x1C, 0x6D, 0xC8, 0x86, 0xE6, 0xBE, 0xF9, 
/*01C0:*/ 0x21, 0x7C, 0xFC, 0xB7, 0x51, 0xDD, 0x19, 0xCE, 0x92, 0x1D, 0xCF, 0x05, 0x2A, 0xCE, 0x67, 0xB1, 
/*01D0:*/ 0xDC, 0x97, 0xFB, 0x7C, 0x43, 0xFF, 0x4D, 0x95, 0xAE, 0x32, 0x3F, 0x74, 0xD7, 0xE7, 0x22, 0x68, 
/*01E0:*/ 0x24, 0x88, 0x22, 0x68, 0x7B, 0xB3, 0x18, 0xBE, 0xBA, 0x4E, 0xF6, 0xF1, 0x4E, 0x34, 0xBC, 0x23, 
/*01F0:*/ 0x6F, 0xFC, 0xD6, 0x54, 0x94, 0x59, 0xB4, 0x53, 0x63, 0x98, 0x15, 0xBC, 0x22, 0xAA, 0xC9, 0x8D, 
/*0200:*/ 0x28, 0xB1, 0x96, 0xDF, 0x97, 0xBC, 0x73, 0xA6, 0x89, 0xF6, 0xA5, 0x6D, 0x63, 0xC9, 0x0D, 0xD9, 
/*0210:*/ 0xE7, 0x23, 0x91, 0x14, 0xD2, 0x70, 0x27, 0xFD, 0x74, 0x20, 0x55, 0x1C, 0x0A, 0x39, 0x22, 0x68, 
/*0220:*/ 0x11, 0x8F, 0x72, 0xD6, 0xEA, 0xFF, 0x72, 0xD6, 0x8D, 0xA4, 0x9C, 0x99, 0x32, 0x04, 0xD6, 0x4B, 
/*0230:*/ 0xB8, 0x0C, 0xBC, 0x3C, 0xA3, 0x16, 0xDE, 0x3B, 0x33, 0xF4, 0x70, 0xD4, 0x78, 0x67, 0xA3, 0xE5, 
/*0240:*/ 0x98, 0x28, 0xAC, 0x09, 0xB1, 0x83, 0x49, 0x70, 0xE0, 0x63, 0x9F, 0xBB, 0x13, 0x00, 0x37, 0x0F, 
/*0250:*/ 0x5C, 0xDA, 0xAB, 0xC2, 0xBA, 0x23, 0x1D, 0x2B, 0x1B, 0x8F, 0x6F, 0xCA, 0x85, 0x5C, 0x18, 0xBE, 
/*0260:*/ 0x39, 0xE2, 0x72, 0xD6, 0xC9, 0x48, 0xA6, 0x4F, 0x01, 0xFC, 0xA6, 0x4F, 0xC9, 0x09, 0xEC, 0x9D, 
/*0270:*/ 0xBC, 0x73, 0x86, 0xEA, 0x69, 0x72, 0xE4, 0xED, 0xED, 0x6F, 0x4A, 0x02, 0xC1, 0x0C, 0x99, 0x33, 
/*0280:*/ 0xE2, 0x8B, 0x42, 0x46, 0x4C, 0xF9, 0xA7, 0x3F, 0xF5, 0x16, 0x71, 0xF4, 0x9E, 0x56, 0xD9, 0x40, 
/*0290:*/ 0xF8, 0x68, 0x45, 0x8D, 0x79, 0x1D, 0xF3, 0x64, 0x3B, 0x86, 0x81, 0x85, 0xD1, 0xE9, 0xF6, 0xF1, 
/*02A0:*/ 0xDB, 0x74, 0x9C, 0x99, 0x1F, 0xBB, 0xA6, 0x4F, 0x2F, 0x03, 0x02, 0xD2, 0xA5, 0x18, 0x02, 0xD2, 
/*02B0:*/ 0xE0, 0x5B, 0x68, 0xA5, 0x2B, 0x62, 0x05, 0xA2, 0x14, 0x2B, 0xA4, 0x4D, 0xDD, 0xC9, 0x77, 0x7C, 
/*02C0:*/ 0x49, 0xC0, 0x08, 0x94, 0x2A, 0x22, 0xED, 0xED, 0x73, 0x18, 0x3B, 0x26, 0xF1, 0xF9, 0x9C, 0x92, 
/*02D0:*/ 0x4F, 0x90, 0x0F, 0x5F, 0x33, 0x10, 0xB9, 0xB6, 0x8F, 0xF8, 0xCB, 0x57, 0xFB, 0xD8, 0xBC, 0x23, 
/*02E0:*/ 0x5D, 0x0E, 0xD6, 0x4B, 0x41, 0x71, 0xEC, 0x9D, 0x2B, 0xF6, 0x02, 0xD2, 0x50, 0xC1, 0x22, 0x77, 
/*02F0:*/ 0x66, 0x7C, 0x22, 0x77, 0xAE, 0x75, 0x40, 0x70, 0x6E, 0xB6, 0xEE, 0x9F, 0x1F, 0x40, 0x3D, 0xAE, 
/*0300:*/ 0xE0, 0x72, 0x62, 0xE3, 0x56, 0x99, 0x87, 0x9A, 0x4D, 0xA1, 0x51, 0x51, 0x41, 0x18, 0xF9, 0xE5, 
/*0310:*/ 0x16, 0x55, 0x65, 0x28, 0x75, 0xA8, 0xD3, 0xC1, 0x0E, 0x4C, 0xA1, 0x20, 0xB0, 0x68, 0xD6, 0x54, 
/*0320:*/ 0x48, 0xEF, 0xBC, 0x3C, 0x1A, 0xC0, 0x86, 0xEA, 0x49, 0x8D, 0x68, 0xA5, 0x8D, 0x65, 0x22, 0x77, 
/*0330:*/ 0x1F, 0x5D, 0x25, 0x07, 0x28, 0xEE, 0x2A, 0x07, 0x28, 0x08, 0x84, 0xE8, 0x2B, 0xF1, 0x57, 0xD9, 
/*0340:*/ 0x4C, 0xBA, 0x00, 0xE4, 0x0A, 0x03, 0xEA, 0x9D, 0xB0, 0x8A, 0x33, 0x56, 0xCF, 0x28, 0x9B, 0xE2, 
/*0350:*/ 0x9F, 0x4D, 0x07, 0x2F, 0xC9, 0x52, 0xB1, 0xC6, 0x7D, 0xF8, 0xC3, 0x27, 0x2A, 0x5C, 0xB4, 0x53, 
/*0360:*/ 0x47, 0xC4, 0xDE, 0x3B, 0xEA, 0xAE, 0xEB, 0xED, 0xD4, 0xE3, 0x0A, 0xA2, 0x07, 0x64, 0x40, 0x70, 
/*0370:*/ 0x66, 0x67, 0x2A, 0x07, 0x83, 0xC2, 0xE6, 0xEF, 0x83, 0x61, 0xE6, 0xEF, 0xEE, 0xB4, 0x35, 0xDE, 
/*0380:*/ 0xE2, 0xA5, 0xAE, 0x0B, 0x0E, 0x38, 0x4B, 0x72, 0x2F, 0x92, 0x9D, 0xB9, 0xE9, 0xC5, 0x35, 0x0D, 
/*0390:*/ 0xF5, 0x9A, 0xA9, 0xC0, 0x0A, 0x1A, 0x1F, 0x29, 0x4E, 0xD0, 0x6D, 0xC8, 0x50, 0xC8, 0x1A, 0xBC, 
/*03A0:*/ 0x8F, 0xEA, 0x70, 0xD4, 0x8E, 0x44, 0x4A, 0x02, 0x49, 0x01, 0xA4, 0x4D, 0xC9, 0x0E, 0xEE, 0x9F, 
/*03B0:*/ 0x24, 0xB0, 0x84, 0xE8, 0x23, 0x57, 0xE6, 0xEF, 0x03, 0x88, 0x9B, 0x31, 0x1A, 0x6C, 0x9B, 0x31, 
/*03C0:*/ 0xF2, 0x6F, 0x7D, 0x3A, 0x64, 0x79, 0x98, 0x43, 0x95, 0xEC, 0x4E, 0x88, 0x8B, 0x81, 0xE6, 0x3C, 
/*03D0:*/ 0xFB, 0x33, 0x7A, 0xF1, 0xC1, 0x52, 0xCC, 0x18, 0x3F, 0x26, 0xBE, 0xF9, 0xAE, 0x84, 0xC9, 0x8D, 
/*03E0:*/ 0x1C, 0x22, 0xA3, 0xE5, 0x06, 0xAA, 0x99, 0x33, 0x06, 0xBB, 0x78, 0x7C, 0x0C, 0x5B, 0x3D, 0xAE, 
/*03F0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};


BYTE dword_4D92CC[] = {
0x8E, 0x8C, 0xDF, 0x65, 0x0B, 0x07, 0x3A, 0x1C, 0xD9, 0xCD, 0xEC, 0xD7, 0xC1, 0xE8, 0x44, 0x63,
0xBD, 0x33, 0xD8, 0xAE, 0x8F, 0x38, 0x6E, 0x47, 0xE1, 0x8B, 0x1C, 0xA6, 0x06, 0x8C, 0x6B, 0xD2,
0x6D, 0x61, 0x01, 0xBA, 0x69, 0xAD, 0x3B, 0x6C, 0xF5, 0x65, 0xD5, 0x23, 0xC8, 0xEA, 0x9F, 0xF1,
0xDD, 0x5F, 0xF5, 0x86, 0x6C, 0xFB, 0x97, 0x81, 0x1A, 0xEE, 0x39, 0x6E, 0xDD, 0x25, 0xEA, 0x5F
};

void* off_4DDCDC[] = {
		SixBlock0,
		SixBlock1,
		SixBlock2,
		SixBlock3,
		SixBlock4,
		SixBlock5,
		SixBlock6,
		SixBlock7,
		SixBlock8,
		SixBlock9,
		SixBlockA,
		SixBlockB,
		SixBlockB,
		SixBlockD,
		SixBlockE,
		SixBlockF
};

BYTE byte_4DDBA0[] = {
0x00, 0x03, 0x0F, 0x0E, 0x02, 0x0D, 0x06, 0x0D, 0x03, 0x09, 0x03, 0x0B, 0x0C, 0x0C, 0x06, 0x01,
0x0D, 0x07, 0x04, 0x0D, 0x08, 0x0A, 0x00, 0x0B, 0x05, 0x05, 0x08, 0x0A, 0x09, 0x05, 0x0D, 0x08,
0x05, 0x0F, 0x01, 0x0C, 0x0A, 0x09, 0x04, 0x02, 0x0E, 0x06, 0x08, 0x05, 0x08, 0x07, 0x0B, 0x09,
0x05, 0x0A, 0x03, 0x00, 0x0E, 0x0C, 0x0C, 0x0D, 0x0A, 0x09, 0x08, 0x09, 0x05, 0x0D, 0x0F, 0x0C,
0x08, 0x08, 0x04, 0x0A, 0x08, 0x0F, 0x0B, 0x08, 0x05, 0x00, 0x0B, 0x0A, 0x08, 0x00, 0x01, 0x0D,
0x00, 0x04, 0x0E, 0x06, 0x0A, 0x01, 0x02, 0x04, 0x09, 0x0D, 0x03, 0x0D, 0x0C, 0x08, 0x0A, 0x0C,
0x0D, 0x0B, 0x03, 0x09, 0x09, 0x0C, 0x04, 0x0E, 0x05, 0x0C, 0x0E, 0x0B, 0x09, 0x0A, 0x05, 0x02,
0x04, 0x0A, 0x0A, 0x08, 0x09, 0x0B, 0x09, 0x09, 0x07, 0x0E, 0x00, 0x0D, 0x09, 0x05, 0x08, 0x02,
0x07, 0x05, 0x03, 0x01, 0x07, 0x00, 0x06, 0x0C, 0x0A, 0x04, 0x09, 0x0E, 0x05, 0x03, 0x01, 0x0C,
0x0E, 0x0C, 0x0C, 0x07, 0x07, 0x02, 0x0C, 0x0A, 0x08, 0x09, 0x02, 0x04, 0x0C, 0x07, 0x0A, 0x08,
0x06, 0x00, 0x03, 0x04, 0x07, 0x00, 0x0A, 0x02, 0x01, 0x05, 0x0E, 0x03, 0x00, 0x0A, 0x06, 0x03,
0x08, 0x08, 0x0F, 0x08, 0x06, 0x00, 0x0C, 0x00, 0x02, 0x00, 0x0F, 0x02, 0x01, 0x05, 0x09, 0x07,
0x00, 0x06, 0x0E, 0x0A, 0x0B, 0x09, 0x02, 0x07, 0x04, 0x0C, 0x0C, 0x0F, 0x07, 0x02, 0x0B, 0x0A,
0x0B, 0x0D, 0x0F, 0x0E, 0x06, 0x03, 0x0A, 0x04, 0x07, 0x05, 0x0C, 0x0F, 0x05, 0x0A, 0x0A, 0x06,
0x0A, 0x08, 0x05, 0x09, 0x03, 0x02, 0x04, 0x00, 0x0B, 0x02, 0x06, 0x02, 0x05, 0x0B, 0x01, 0x04,
0x09, 0x06, 0x0C, 0x01, 0x03, 0x00, 0x0C, 0x07, 0x0D, 0x03, 0x0E, 0x07,
};

BYTE dword_552CA9[] = {0x0E, 0x2A, 0x85, 0x64};


//block 6 dynamic functions
void* Block6DynamicFuncs[] = { 
sub_48D4EE,
sub_48D2A4,   
sub_482654,  
sub_48A696,
sub_48B8EB,
sub_48B4C8,
sub_47F71C,
sub_48DA6B,
sub_48A34A,
sub_48778D,
sub_48BCA8,
sub_489D38,
sub_486E92,
sub_485AD2,
sub_48A4A6,
sub_484B20,
sub_48873D,
sub_48D647,
sub_48649F,
sub_4857D3,
sub_48A2BE,
sub_48ABB6,
sub_489EBA,
sub_486D34,
sub_48AEC3,
sub_4850F1,
sub_4821A5,
sub_487EE3,
sub_4896E4,
sub_48BAC0,
sub_484F0B,
sub_48D8AF,
sub_487F9B,
sub_48B85F,
sub_485051,
sub_47F7E9,
sub_485593,
sub_48468F,
sub_4847E1,
sub_487692,
sub_482781,
sub_485315,
sub_486128,
sub_48B379,
sub_4838D4,
sub_488E61,
sub_489A35,
sub_48A589,
sub_483784,
sub_48B048,
sub_48830C,
sub_48D6F8,
sub_48363D,
sub_4808ED,
sub_4837FF,
sub_489F92,
sub_48572F,
sub_486088,
sub_48C479,
sub_484526,
sub_47FD40,
sub_4851C2,
sub_482511,
sub_4872DC,
sub_486C52,
sub_489299,
sub_485EFB,
sub_4867A8,
sub_483D1B,
sub_48D987,
sub_48D37A,
sub_482347,
sub_47FE0F,
sub_48B144,
sub_48C809,
sub_48ADAB,
sub_484DC4,
sub_48A8A9,
sub_488671,
sub_489AE0,
sub_48A3DB,
sub_488260,
sub_4859B7,
sub_485898,
sub_48BF8D,
sub_487BED,
sub_483136,
sub_485479,
sub_48B41E,
sub_489500,
sub_4853D4,
sub_480513,
sub_480753,
sub_48027A,
sub_48C558,
sub_48818D,
sub_4826EF,
sub_489C62,
sub_486362,
sub_4868CA,
sub_48C8AB,
sub_483C44,
sub_48CE93,
sub_4898DB,
sub_4806A8,
sub_48839F,
sub_484D34,
sub_48C5F7,
sub_48903D,
sub_482AC5,
sub_4879C2,
sub_4848BA,
sub_487CA9,
sub_48565C,
sub_485C4D,
sub_48AAED,
sub_482867,
sub_484BCA,
sub_483549,
sub_480ABC,
sub_48654F,
sub_489214,
sub_48A749,
sub_485280,
sub_482FB4,
sub_482EFE,
sub_47FA7F,
sub_4803F9,
sub_485CCB,
sub_48DAF1,
sub_485A3D,
sub_4840CF,
sub_487137,
sub_482930,
sub_48CAF8,
sub_48D461,
sub_484315,
sub_4833EE,
sub_48A015,
sub_488F97,
sub_483208,
sub_488CA2,
sub_487B44,
sub_4823C8,
sub_48097F,
sub_4829D3,
sub_480350,
sub_4845BB,
sub_484488,
sub_48B65C,
sub_48A993,
sub_487DEA,
sub_482E3D,
sub_488055,
sub_48349D,
sub_484E68,
sub_488108,
sub_48246C,
sub_482C9E,
sub_488475,
sub_486299,
sub_489BB2,
sub_48BED9,
sub_48DBAA,
sub_483EB0,
sub_484003,
sub_48682F,
sub_480022,
sub_487043,
sub_487383,
sub_488C12,
sub_489798,
sub_4861C8,
sub_47FCB2,
sub_48A0FB,
sub_4889F5,
sub_48A60F,
sub_48CFE9,
sub_483F62,
sub_47FBF8,
sub_48493A,
sub_48C274,
sub_4899A6,
sub_48BE35,
sub_4885F8,
sub_4836E0,
sub_487916,
sub_487445,
sub_48C973,
sub_48640A,
sub_48B2BC,
sub_488F0A,
sub_48A1B3,
sub_48C180,
sub_483349,
sub_48AF5D,
sub_483976,
sub_48CF27,
sub_489832,
sub_48BB6B,
sub_48D1F8,
sub_4832AE,
sub_48B761,
sub_48D098,
sub_47F9AE,
sub_484A99,
sub_48B9EF,
sub_488B2B,
sub_48CDAE,
sub_47FF6D,
sub_48BC05,
sub_483B62,
sub_48854E,
sub_48912A,
sub_4888F0,
sub_482B40,
sub_485E46,
sub_47F8EF,
sub_487D4D,
sub_4875A3,
sub_48C3D7,
sub_48D7F5,
sub_4874F5,
sub_486A5F,
sub_48C776,
sub_48D11F,
sub_48B1EC,
sub_48C332,
sub_484752,
sub_48CC9F,
sub_48B5B5,
sub_48AA4C,
sub_4865F8,
sub_4807FD,
sub_488AA6,
sub_480A1B,
sub_4801E3,
sub_484255,
sub_4843C4,
sub_48A7DD,
sub_48C6A1,
sub_485BB2,
sub_480491,
sub_484C97,
sub_48259B,
sub_484F93,
sub_488803,
sub_482D75,
sub_4866AC,
sub_4822B2,
sub_47FB2E,
sub_489419
};


//block 6 dynamic functions sub data
DWORD dword_4D9374 = 0xBD3CAC82;
DWORD dword_4D9370 = 0xBA510D2C;
DWORD dword_4D937C = 0xDDC1D886;
DWORD dword_4D9380 = 0xB7740927;
DWORD dword_4D93AC = 0x338F1DEE;
DWORD dword_4D93B0 = 0x182A7565;
DWORD dword_4D93A8 = 0xE4505EBF;
DWORD dword_4D9378 = 0xB8EA996B;
DWORD dword_4D93A4 = 0xE994CC65;
DWORD dword_4D9388 = 0xA7E50904;
DWORD dword_4D938C = 0xB9E1AC81;
DWORD dword_4D9394 = 0x202FC031;
DWORD dword_4D9398 = 0xD70E4E5A;
DWORD dword_4D939C = 0xE1B4BEFB;
DWORD dword_4D93A0 = 0x20CC263B;
DWORD dword_4D9390 = 0xD072C8D7;
DWORD dword_4D9384 = 0x6A073847;

DWORD unk_552CA9 = 0x64852A0E;


//block 6 dynamic functions sub functions layer 1

void* off_4DDC9C = &sub_47CFB0;
void* off_4DDCA0 = &sub_47D0EF;
void* off_4DDCA4 = &sub_47D2B5;
void* off_4DDCA8 = &sub_47D4F9;
void* off_4DDCAC = &sub_47D6CE;
void* off_4DDCB0 = &sub_47D9DB;
void* off_4DDCB4 = &sub_47DCDA;
void* off_4DDCB8 = &sub_47DE96;
void* off_4DDCBC = &sub_47E17A;
void* off_4DDCC0 = &sub_47E2FC;
void* off_4DDCC4 = &sub_47E508;
void* off_4DDCC8 = &sub_47E746;
void* off_4DDCCC = &sub_47E9B4;
void* off_4DDCD0 = &sub_47EB90;
void* off_4DDCD4 = &sub_47EE6B;
void* off_4DDCD8 = &sub_47F09F;
void* off_4DDCDC_2 = &sub_47D04F;
void* off_4DDCE0 = &sub_47D1D2;
void* off_4DDCE4 = &sub_47D3D7;
void* off_4DDCE8 = &sub_47D5E3;
void* off_4DDCEC = &sub_47D854;
void* off_4DDCF0 = &sub_47DB59;
void* off_4DDCF4 = &sub_47DDB8;
void* off_4DDCF8 = &sub_47E008;
void* off_4DDCFC = &sub_47E23B;
void* off_4DDD00 = &sub_47E402;
void* off_4DDD04 = &sub_47E627;
void* off_4DDD08 = &sub_47E87C;
void* off_4DDD0C = &sub_47EAA2;
void* off_4DDD10 = &sub_47ECFE;
void* off_4DDD14 = &sub_47EF85;
void* off_4DDD18 = &sub_47F22B;


//block 6 original dynamic call addresses

DWORD B6OriginalFuncs[] = 
{
0x48D4EE,
0x48D2A4,
0x482654,
0x48A696,
0x48B8EB,
0x48B4C8,
0x47F71C,
0x48DA6B,
0x48A34A,
0x48778D,
0x48BCA8,
0x489D38,
0x486E92,
0x485AD2,
0x48A4A6,
0x484B20,
0x48873D,
0x48D647,
0x48649F,
0x4857D3,
0x48A2BE,
0x48ABB6,
0x489EBA,
0x486D34,
0x48AEC3,
0x4850F1,
0x4821A5,
0x487EE3,
0x4896E4,
0x48BAC0,
0x484F0B,
0x48D8AF,
0x487F9B,
0x48B85F,
0x485051,
0x47F7E9,
0x485593,
0x48468F,
0x4847E1,
0x487692,
0x482781,
0x485315,
0x486128,
0x48B379,
0x4838D4,
0x488E61,
0x489A35,
0x48A589,
0x483784,
0x48B048,
0x48830C,
0x48D6F8,
0x48363D,
0x4808ED,
0x4837FF,
0x489F92,
0x48572F,
0x486088,
0x48C479,
0x484526,
0x47FD40,
0x4851C2,
0x482511,
0x4872DC,
0x486C52,
0x489299,
0x485EFB,
0x4867A8,
0x483D1B,
0x48D987,
0x48D37A,
0x482347,
0x47FE0F,
0x48B144,
0x48C809,
0x48ADAB,
0x484DC4,
0x48A8A9,
0x488671,
0x489AE0,
0x48A3DB,
0x488260,
0x4859B7,
0x485898,
0x48BF8D,
0x487BED,
0x483136,
0x485479,
0x48B41E,
0x489500,
0x4853D4,
0x480513,
0x480753,
0x48027A,
0x48C558,
0x48818D,
0x4826EF,
0x489C62,
0x486362,
0x4868CA,
0x48C8AB,
0x483C44,
0x48CE93,
0x4898DB,
0x4806A8,
0x48839F,
0x484D34,
0x48C5F7,
0x48903D,
0x482AC5,
0x4879C2,
0x4848BA,
0x487CA9,
0x48565C,
0x485C4D,
0x48AAED,
0x482867,
0x484BCA,
0x483549,
0x480ABC,
0x48654F,
0x489214,
0x48A749,
0x485280,
0x482FB4,
0x482EFE,
0x47FA7F,
0x4803F9,
0x485CCB,
0x48DAF1,
0x485A3D,
0x4840CF,
0x487137,
0x482930,
0x48CAF8,
0x48D461,
0x484315,
0x4833EE,
0x48A015,
0x488F97,
0x483208,
0x488CA2,
0x487B44,
0x4823C8,
0x48097F,
0x4829D3,
0x480350,
0x4845BB,
0x484488,
0x48B65C,
0x48A993,
0x487DEA,
0x482E3D,
0x488055,
0x48349D,
0x484E68,
0x488108,
0x48246C,
0x482C9E,
0x488475,
0x486299,
0x489BB2,
0x48BED9,
0x48DBAA,
0x483EB0,
0x484003,
0x48682F,
0x480022,
0x487043,
0x487383,
0x488C12,
0x489798,
0x4861C8,
0x47FCB2,
0x48A0FB,
0x4889F5,
0x48A60F,
0x48CFE9,
0x483F62,
0x47FBF8,
0x48493A,
0x48C274,
0x4899A6,
0x48BE35,
0x4885F8,
0x4836E0,
0x487916,
0x487445,
0x48C973,
0x48640A,
0x48B2BC,
0x488F0A,
0x48A1B3,
0x48C180,
0x483349,
0x48AF5D,
0x483976,
0x48CF27,
0x489832,
0x48BB6B,
0x48D1F8,
0x4832AE,
0x48B761,
0x48D098,
0x47F9AE,
0x484A99,
0x48B9EF,
0x488B2B,
0x48CDAE,
0x47FF6D,
0x48BC05,
0x483B62,
0x48854E,
0x48912A,
0x4888F0,
0x482B40,
0x485E46,
0x47F8EF,
0x487D4D,
0x4875A3,
0x48C3D7,
0x48D7F5,
0x4874F5,
0x486A5F,
0x48C776,
0x48D11F,
0x48B1EC,
0x48C332,
0x484752,
0x48CC9F,
0x48B5B5,
0x48AA4C,
0x4865F8,
0x4807FD,
0x488AA6,
0x480A1B,
0x4801E3,
0x484255,
0x4843C4,
0x48A7DD,
0x48C6A1,
0x485BB2,
0x480491,
0x484C97,
0x48259B,
0x484F93,
0x488803,
0x482D75,
0x4866AC,
0x4822B2,
0x47FB2E,
0x489419
};



////////////////////////////
// block 7
////////////////////////////

BYTE B7D0[] = {
/*00CF80:*/ 0x84, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0x5B, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*00CF90:*/ 0xF8, 0x55, 0x25, 0x38, 0xDB, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0xBD, 0xC5, 0x30, 0xDA, 
/*00CFA0:*/ 0xC5, 0xA6, 0x1F, 0x24, 0x44, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0x9C, 0xD9, 0x61, 0x70, 
/*00CFB0:*/ 0xF0, 0xE3, 0xB9, 0x2B, 0x47, 0xF3, 0x13, 0xEA, 0x22, 0x09, 0xCD, 0x6A, 0x8C, 0x97, 0x6F, 0xA7, 
/*00CFC0:*/ 0x6D, 0x38, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x3D, 0xAE, 0xF3, 0xB1, 
/*00CFD0:*/ 0xF8, 0x55, 0x25, 0x38, 0xD0, 0xAA, 0x73, 0x23, 0x03, 0x28, 0xA5, 0x40, 0xFD, 0xC2, 0x30, 0xDA, 
/*00CFE0:*/ 0xE5, 0xA6, 0x1F, 0x24, 0x58, 0x10, 0xA9, 0x33, 0x55, 0x82, 0x1C, 0x53, 0xBD, 0xD9, 0x61, 0x70, 
/*00CFF0:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x85, 0xFF, 0x13, 0xEA, 0x3D, 0x09, 0xCD, 0x6A, 0xCC, 0x97, 0x6F, 0xA7, 
/*00D000:*/ 0xB0, 0x39, 0x50, 0xC7, 0x3C, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x87, 0xAE, 0xF3, 0xB1, 
/*00D010:*/ 0xB1, 0x55, 0x25, 0x38, 0x99, 0xAA, 0x73, 0x23, 0x3F, 0x28, 0xA5, 0x40, 0x93, 0xC5, 0x30, 0xDA, 
/*00D020:*/ 0xE9, 0xA6, 0x1F, 0x24, 0x15, 0x10, 0xA9, 0x33, 0xE7, 0x82, 0x1C, 0x53, 0xA5, 0xD9, 0x61, 0x70, 
/*00D030:*/ 0x2E, 0xE2, 0xB9, 0x2B, 0xAA, 0xF2, 0x13, 0xEA, 0x5C, 0x09, 0xCD, 0x6A, 0x94, 0x95, 0x6F, 0xA7, 
/*00D040:*/ 0xAF, 0x39, 0x50, 0xC7, 0x19, 0x48, 0xD1, 0x0C, 0x12, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00D050:*/ 0x2D, 0x54, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 0x7D, 0x28, 0xA5, 0x40, 0xCD, 0xC5, 0x30, 0xDA, 
/*00D060:*/ 0xBE, 0xA6, 0x1F, 0x24, 0x2B, 0x11, 0xA9, 0x33, 0x8D, 0x82, 0x1C, 0x53, 0x93, 0xD9, 0x61, 0x70, 
/*00D070:*/ 0xFE, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 0x2B, 0x09, 0xCD, 0x6A, 0xCD, 0x97, 0x6F, 0xA7, 
/*00D080:*/ 0xA0, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0x68, 0xF9, 0xF1, 0x79, 0x19, 0xAE, 0xF3, 0xB1, 
/*00D090:*/ 0xEB, 0x55, 0x25, 0x38, 0xAC, 0xA8, 0x73, 0x23, 0x28, 0x28, 0xA5, 0x40, 0x18, 0xC5, 0x30, 0xDA, 
/*00D0A0:*/ 0xA3, 0xA6, 0x1F, 0x24, 0x4B, 0x10, 0xA9, 0x33, 0x14, 0x83, 0x1C, 0x53, 0xA7, 0xD8, 0x61, 0x70, 
/*00D0B0:*/ 0xED, 0xE3, 0xB9, 0x2B, 0x85, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xE2, 0x97, 0x6F, 0xA7, 
/*00D0C0:*/ 0xD2, 0x39, 0x50, 0xC7, 0x0A, 0x48, 0xD1, 0x0C, 0x6B, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00D0D0:*/ 0x68, 0x54, 0x25, 0x38, 0xD0, 0xAA, 0x73, 0x23, 0x0F, 0x28, 0xA5, 0x40, 0xAC, 0xC5, 0x30, 0xDA, 
/*00D0E0:*/ 0xFA, 0xA6, 0x1F, 0x24, 0x1D, 0x12, 0xA9, 0x33, 0xDC, 0x82, 0x1C, 0x53, 0x8C, 0xD9, 0x61, 0x70, 
/*00D0F0:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x88, 0xF3, 0x13, 0xEA, 0x36, 0x09, 0xCD, 0x6A, 0x75, 0x97, 0x6F, 0xA7, 
/*00D100:*/ 0xA2, 0x39, 0x50, 0xC7, 0x20, 0x48, 0xD1, 0x0C, 0x40, 0xF9, 0xF1, 0x79, 0x0F, 0xAC, 0xF3, 0xB1, 
/*00D110:*/ 0xD7, 0x55, 0x25, 0x38, 0xCF, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0x8E, 0xC5, 0x30, 0xDA, 
/*00D120:*/ 0xD7, 0xA6, 0x1F, 0x24, 0x4E, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0x8B, 0xD9, 0x61, 0x70, 
/*00D130:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x90, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xA1, 0x97, 0x6F, 0xA7, 
/*00D140:*/ 0x4A, 0x39, 0x50, 0xC7, 0x3F, 0x48, 0xD1, 0x0C, 0x55, 0xF9, 0xF1, 0x79, 0x4D, 0xAC, 0xF3, 0xB1, 
/*00D150:*/ 0xBB, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 0xE6, 0x28, 0xA5, 0x40, 0xF3, 0xCD, 0x30, 0xDA, 
/*00D160:*/ 0xF1, 0xA6, 0x1F, 0x24, 0xD8, 0x11, 0xA9, 0x33, 0xC1, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 
/*00D170:*/ 0x72, 0xE3, 0xB9, 0x2B, 0xF8, 0xF2, 0x13, 0xEA, 0x81, 0xF6, 0x32, 0x95, 0xC0, 0x96, 0x6F, 0xA7, 
/*00D180:*/ 0xB7, 0x39, 0x50, 0xC7, 0xB6, 0x48, 0xD1, 0x0C, 0x40, 0xF9, 0xF1, 0x79, 0xCB, 0x51, 0x0C, 0x4E, 
/*00D190:*/ 0x6B, 0x54, 0x25, 0x38, 0xCF, 0xAA, 0x73, 0x23, 0x17, 0x28, 0xA5, 0x40, 0xD5, 0xC5, 0x30, 0xDA, 
/*00D1A0:*/ 0xF3, 0xA6, 0x1F, 0x24, 0x7D, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0x97, 0x26, 0x9E, 0x8F, 
/*00D1B0:*/ 0xD2, 0xE3, 0xB9, 0x2B, 0x85, 0xF2, 0x13, 0xEA, 0x3E, 0x09, 0xCD, 0x6A, 0xC6, 0x97, 0x6F, 0xA7, 
/*00D1C0:*/ 0xB7, 0x39, 0x50, 0xC7, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00D1D0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D1[] = {
/*00D8D0:*/ 0x73, 0xC7, 0xAF, 0x38, 0xFA, 0x48, 0xD1, 0x0C, 0x0E, 0xF9, 0xF1, 0x79, 0x37, 0xAE, 0xF3, 0xB1, 
/*00D8E0:*/ 0xDF, 0x55, 0x25, 0x38, 0x90, 0xAA, 0x73, 0x23, 0x8B, 0x28, 0xA5, 0x40, 0xB9, 0xC5, 0x30, 0xDA, 
/*00D8F0:*/ 0xB7, 0xA6, 0x1F, 0x24, 0x11, 0x10, 0xA9, 0x33, 0xB6, 0x80, 0x1C, 0x53, 0xA3, 0xD9, 0x61, 0x70, 
/*00D900:*/ 0xF2, 0xE3, 0xB9, 0x2B, 0x2E, 0xF3, 0x13, 0xEA, 0x66, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 
/*00D910:*/ 0xD4, 0x39, 0x50, 0xC7, 0x37, 0x48, 0xD1, 0x0C, 0xBF, 0x06, 0x0E, 0x86, 0x43, 0xAE, 0xF3, 0xB1, 
/*00D920:*/ 0xD2, 0x55, 0x25, 0x38, 0x69, 0xA8, 0x73, 0x23, 0x2C, 0x28, 0xA5, 0x40, 0xB6, 0xC5, 0x30, 0xDA, 
/*00D930:*/ 0x38, 0xA6, 0x1F, 0x24, 0x99, 0x10, 0xA9, 0x33, 0xE2, 0x80, 0x1C, 0x53, 0xAA, 0xD9, 0x61, 0x70, 
/*00D940:*/ 0xF3, 0xE3, 0xB9, 0x2B, 0x04, 0xF2, 0x13, 0xEA, 0x2F, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*00D950:*/ 0xA0, 0x39, 0x50, 0xC7, 0x26, 0x48, 0xD1, 0x0C, 0x02, 0xF9, 0xF1, 0x79, 0x17, 0xAE, 0xF3, 0xB1, 
/*00D960:*/ 0xEB, 0x54, 0x25, 0x38, 0xC6, 0xA2, 0x73, 0x23, 0x4C, 0x28, 0xA5, 0x40, 0x73, 0xC5, 0x30, 0xDA, 
/*00D970:*/ 0xEB, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 0x2D, 0x82, 0x1C, 0x53, 0xD5, 0xD9, 0x61, 0x70, 
/*00D980:*/ 0xF7, 0xE3, 0xB9, 0x2B, 0x9E, 0xF2, 0x13, 0xEA, 0xC3, 0x09, 0xCD, 0x6A, 0xD2, 0x97, 0x6F, 0xA7, 
/*00D990:*/ 0x3A, 0x39, 0x50, 0xC7, 0x20, 0x48, 0xD1, 0x0C, 0x5B, 0xF9, 0xF1, 0x79, 0x3D, 0xAE, 0xF3, 0xB1, 
/*00D9A0:*/ 0xEB, 0x55, 0x25, 0x38, 0xD0, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0xB6, 0xC5, 0x30, 0xDA, 
/*00D9B0:*/ 0xB6, 0xA6, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 0xD4, 0x82, 0x1C, 0x53, 0x35, 0xD9, 0x61, 0x70, 
/*00D9C0:*/ 0xC2, 0xE3, 0xB9, 0x2B, 0x45, 0xF2, 0x13, 0xEA, 0x2B, 0x09, 0xCD, 0x6A, 0x99, 0x97, 0x6F, 0xA7, 
/*00D9D0:*/ 0xEA, 0x39, 0x50, 0xC7, 0x27, 0x48, 0xD1, 0x0C, 0x5B, 0xF9, 0xF1, 0x79, 0x71, 0xAE, 0xF3, 0xB1, 
/*00D9E0:*/ 0xEA, 0x55, 0x25, 0x38, 0xEA, 0xAA, 0x73, 0x23, 0x20, 0x28, 0xA5, 0x40, 0x8E, 0xC5, 0x30, 0xDA, 
/*00D9F0:*/ 0xCA, 0xA6, 0x1F, 0x24, 0xBD, 0x10, 0xA9, 0x33, 0xC8, 0x82, 0x1C, 0x53, 0x95, 0xD9, 0x61, 0x70, 
/*00DA00:*/ 0xCE, 0xE3, 0xB9, 0x2B, 0x84, 0xF2, 0x13, 0xEA, 0x11, 0x09, 0xCD, 0x6A, 0xA7, 0x97, 0x6F, 0xA7, 
/*00DA10:*/ 0xA0, 0x39, 0x50, 0xC7, 0x3D, 0x48, 0xD1, 0x0C, 0x6E, 0xF9, 0xF1, 0x79, 0x0D, 0xAE, 0xF3, 0xB1, 
/*00DA20:*/ 0xF9, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x08, 0x28, 0xA5, 0x40, 0xA6, 0xC5, 0x30, 0xDA, 
/*00DA30:*/ 0x22, 0x59, 0xE0, 0xDB, 0x5B, 0x10, 0xA9, 0x33, 0xEF, 0x82, 0x1C, 0x53, 0x3B, 0x26, 0x9E, 0x8F, 
/*00DA40:*/ 0xBB, 0xE3, 0xB9, 0x2B, 0x99, 0xF2, 0x13, 0xEA, 0x30, 0x09, 0xCD, 0x6A, 0x95, 0x96, 0x6F, 0xA7, 
/*00DA50:*/ 0xB4, 0x39, 0x50, 0xC7, 0x91, 0xB7, 0x2E, 0xF3, 0x88, 0x06, 0x0E, 0x86, 0x39, 0xAE, 0xF3, 0xB1, 
/*00DA60:*/ 0xF4, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x14, 0x28, 0xA5, 0x40, 0xCF, 0xC5, 0x30, 0xDA, 
/*00DA70:*/ 0x90, 0xA7, 0x1F, 0x24, 0x3B, 0x10, 0xA9, 0x33, 0x18, 0x82, 0x1C, 0x53, 0xEB, 0xD9, 0x61, 0x70, 
/*00DA80:*/ 0xE5, 0xE2, 0xB9, 0x2B, 0xD4, 0xF2, 0x13, 0xEA, 0x16, 0x0B, 0xCD, 0x6A, 0xD7, 0x97, 0x6F, 0xA7, 
/*00DA90:*/ 0xF0, 0x39, 0x50, 0xC7, 0x32, 0x49, 0xD1, 0x0C, 0xCB, 0xF9, 0xF1, 0x79, 0x0B, 0xAE, 0xF3, 0xB1, 
/*00DAA0:*/ 0xF4, 0x55, 0x25, 0x38, 0xD7, 0xAA, 0x73, 0x23, 0x0E, 0x28, 0xA5, 0x40, 0x5D, 0xC5, 0x30, 0xDA, 
/*00DAB0:*/ 0xE0, 0xA6, 0x1F, 0x24, 0xE5, 0xEF, 0x56, 0xCC, 0xF5, 0x82, 0x1C, 0x53, 0x8C, 0xD9, 0x61, 0x70, 
/*00DAC0:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x32, 0x09, 0xCD, 0x6A, 0xFB, 0x95, 0x6F, 0xA7, 
/*00DAD0:*/ 0xA3, 0x39, 0x50, 0xC7, 0x32, 0x48, 0xD1, 0x0C, 0x84, 0xF9, 0xF1, 0x79, 0x08, 0xAE, 0xF3, 0xB1, 
/*00DAE0:*/ 0xF9, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 0xD1, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00DAF0:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x24, 0x11, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0x88, 0xD9, 0x61, 0x70, 
/*00DB00:*/ 0xEA, 0xE3, 0xB9, 0x2B, 0x85, 0xF2, 0x13, 0xEA, 0x23, 0x09, 0xCD, 0x6A, 0xD9, 0x95, 0x6F, 0xA7, 
/*00DB10:*/ 0xA2, 0x39, 0x50, 0xC7, 0xEC, 0xB7, 0x2E, 0xF3, 0x2E, 0xF9, 0xF1, 0x79, 0x2E, 0xAE, 0xF3, 0xB1, 
/*00DB20:*/ 0xDD, 0x55, 0x25, 0x38, 0xD2, 0xAA, 0x73, 0x23, 0x12, 0x28, 0xA5, 0x40, 0xA2, 0xC5, 0x30, 0xDA, 
/*00DB30:*/ 0xF4, 0xA6, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 0x7C, 0x82, 0x1C, 0x53, 0xB4, 0xD9, 0x61, 0x70, 
/*00DB40:*/ 0x68, 0xE3, 0xB9, 0x2B, 0x5D, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xF8, 0x97, 0x6F, 0xA7, 
/*00DB50:*/ 0xBE, 0x39, 0x50, 0xC7, 0x22, 0x48, 0xD1, 0x0C, 0x6D, 0xF9, 0xF1, 0x79, 0x29, 0xAE, 0xF3, 0xB1, 
/*00DB60:*/ 0xF9, 0x55, 0x25, 0x38, 0xC0, 0xAA, 0x73, 0x23, 0x0C, 0x28, 0xA5, 0x40, 0x97, 0xC5, 0x30, 0xDA, 
/*00DB70:*/ 0x3C, 0xA6, 0x1F, 0x24, 0x04, 0x10, 0xA9, 0x33, 0x8D, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 
/*00DB80:*/ 0xF4, 0xE3, 0xB9, 0x2B, 0x56, 0x0D, 0xEC, 0x15, 0x3D, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 
/*00DB90:*/ 0x8C, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*00DBA0:*/ 0xEB, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 0x85, 0xD6, 0x5A, 0xBF, 0x94, 0xC5, 0x30, 0xDA, 
/*00DBB0:*/ 0xE6, 0xA6, 0x1F, 0x24, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00DBC0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D2[] = {
/*00E1F0:*/ 0xA0, 0x39, 0x50, 0xC7, 0x3F, 0x48, 0xD1, 0x0C, 0x79, 0xF9, 0xF1, 0x79, 0x70, 0xAE, 0xF3, 0xB1, 
/*00E200:*/ 0x8B, 0x55, 0x25, 0x38, 0x8B, 0xA8, 0x73, 0x23, 0x78, 0xD6, 0x5A, 0xBF, 0x66, 0xC4, 0x30, 0xDA, 
/*00E210:*/ 0xB4, 0xA6, 0x1F, 0x24, 0x22, 0x10, 0xA9, 0x33, 0x4B, 0x81, 0x1C, 0x53, 0x97, 0xD9, 0x61, 0x70, 
/*00E220:*/ 0x1F, 0xE3, 0xB9, 0x2B, 0x9B, 0xF2, 0x13, 0xEA, 0x28, 0x09, 0xCD, 0x6A, 0xEC, 0x97, 0x6F, 0xA7, 
/*00E230:*/ 0xA0, 0x39, 0x50, 0xC7, 0x6A, 0x48, 0xD1, 0x0C, 0x4F, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*00E240:*/ 0xEC, 0x55, 0x25, 0x38, 0xF0, 0xAB, 0x73, 0x23, 0x0A, 0x28, 0xA5, 0x40, 0x87, 0xC5, 0x30, 0xDA, 
/*00E250:*/ 0xF3, 0xA6, 0x1F, 0x24, 0x6D, 0x10, 0xA9, 0x33, 0x27, 0x7D, 0xE3, 0xAC, 0x98, 0xD9, 0x61, 0x70, 
/*00E260:*/ 0xE7, 0xE2, 0xB9, 0x2B, 0xA2, 0xF0, 0x13, 0xEA, 0xB5, 0x08, 0xCD, 0x6A, 0x0D, 0x97, 0x6F, 0xA7, 
/*00E270:*/ 0xA7, 0x39, 0x50, 0xC7, 0x32, 0x48, 0xD1, 0x0C, 0x67, 0xFB, 0xF1, 0x79, 0x33, 0xAE, 0xF3, 0xB1, 
/*00E280:*/ 0xAB, 0x55, 0x25, 0x38, 0xCA, 0xAA, 0x73, 0x23, 0x0F, 0x28, 0xA5, 0x40, 0x8D, 0xC5, 0x30, 0xDA, 
/*00E290:*/ 0xEA, 0xA6, 0x1F, 0x24, 0x49, 0x10, 0xA9, 0x33, 0x50, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 
/*00E2A0:*/ 0xC1, 0xE2, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xC9, 0x97, 0x6F, 0xA7, 
/*00E2B0:*/ 0xA2, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00E2C0:*/ 0xBF, 0x55, 0x25, 0x38, 0xCB, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0xB2, 0xC5, 0x30, 0xDA, 
/*00E2D0:*/ 0xAA, 0xA6, 0x1F, 0x24, 0x54, 0x10, 0xA9, 0x33, 0xC8, 0x82, 0x1C, 0x53, 0x99, 0xD9, 0x61, 0x70, 
/*00E2E0:*/ 0xEC, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x2E, 0x09, 0xCD, 0x6A, 0xCA, 0x97, 0x6F, 0xA7, 
/*00E2F0:*/ 0xB1, 0x39, 0x50, 0xC7, 0xEB, 0x48, 0xD1, 0x0C, 0x5B, 0xF9, 0xF1, 0x79, 0x19, 0xAE, 0xF3, 0xB1, 
/*00E300:*/ 0x37, 0xAA, 0xDA, 0xC7, 0xEF, 0xAA, 0x73, 0x23, 0x79, 0x29, 0xA5, 0x40, 0x2A, 0xC5, 0x30, 0xDA, 
/*00E310:*/ 0xC5, 0xA6, 0x1F, 0x24, 0x32, 0x10, 0xA9, 0x33, 0x96, 0x83, 0x1C, 0x53, 0x8E, 0xD9, 0x61, 0x70, 
/*00E320:*/ 0xF1, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x3C, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*00E330:*/ 0xA8, 0x39, 0x50, 0xC7, 0x5B, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x28, 0xAE, 0xF3, 0xB1, 
/*00E340:*/ 0xEC, 0x55, 0x25, 0x38, 0xCE, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0x06, 0xC5, 0x30, 0xDA, 
/*00E350:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x89, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0xEA, 0xD9, 0x61, 0x70, 
/*00E360:*/ 0xD8, 0xE3, 0xB9, 0x2B, 0x9E, 0xF2, 0x13, 0xEA, 0x28, 0x09, 0xCD, 0x6A, 0xD2, 0x97, 0x6F, 0xA7, 
/*00E370:*/ 0xDA, 0x39, 0x50, 0xC7, 0x1C, 0x48, 0xD1, 0x0C, 0x74, 0xF9, 0xF1, 0x79, 0x67, 0xAE, 0xF3, 0xB1, 
/*00E380:*/ 0xB7, 0x54, 0x25, 0x38, 0x27, 0x54, 0x8C, 0xDC, 0x04, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00E390:*/ 0xEB, 0xA6, 0x1F, 0x24, 0x75, 0x10, 0xA9, 0x33, 0xC8, 0x82, 0x1C, 0x53, 0xC3, 0xD9, 0x61, 0x70, 
/*00E3A0:*/ 0x12, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x1B, 0x08, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*00E3B0:*/ 0xAE, 0x39, 0x50, 0xC7, 0x77, 0x48, 0xD1, 0x0C, 0x24, 0xF9, 0xF1, 0x79, 0x07, 0xAE, 0xF3, 0xB1, 
/*00E3C0:*/ 0xF8, 0x55, 0x25, 0x38, 0xCD, 0xAA, 0x73, 0x23, 0x11, 0x28, 0xA5, 0x40, 0xB7, 0xC5, 0x30, 0xDA, 
/*00E3D0:*/ 0x5A, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 0xF9, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 
/*00E3E0:*/ 0xB2, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 0x28, 0x09, 0xCD, 0x6A, 0xCF, 0x97, 0x6F, 0xA7, 
/*00E3F0:*/ 0x4B, 0x3E, 0x50, 0xC7, 0x1F, 0x48, 0xD1, 0x0C, 0x49, 0xF9, 0xF1, 0x79, 0x41, 0xAF, 0xF3, 0xB1, 
/*00E400:*/ 0xA2, 0xAA, 0xDA, 0xC7, 0xD9, 0xAA, 0x73, 0x23, 0x06, 0x28, 0xA5, 0x40, 0xA8, 0xC5, 0x30, 0xDA, 
/*00E410:*/ 0xF3, 0xA6, 0x1F, 0x24, 0x0A, 0x10, 0xA9, 0x33, 0xC4, 0x83, 0x1C, 0x53, 0x9F, 0xD9, 0x61, 0x70, 
/*00E420:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x89, 0xF2, 0x13, 0xEA, 0xDD, 0xF6, 0x32, 0x95, 0xEB, 0x97, 0x6F, 0xA7, 
/*00E430:*/ 0xB8, 0x39, 0x50, 0xC7, 0xBA, 0x48, 0xD1, 0x0C, 0x7E, 0xF8, 0xF1, 0x79, 0x39, 0xAE, 0xF3, 0xB1, 
/*00E440:*/ 0xDC, 0x4C, 0x25, 0x38, 0x14, 0xB2, 0x73, 0x23, 0x23, 0x28, 0xA5, 0x40, 0x18, 0x3A, 0xCF, 0x25, 
/*00E450:*/ 0xE5, 0xA6, 0x1F, 0x24, 0x04, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0xB5, 0xD9, 0x61, 0x70, 
/*00E460:*/ 0x71, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x1B, 0x09, 0xCD, 0x6A, 0xDA, 0x97, 0x6F, 0xA7, 
/*00E470:*/ 0xAB, 0x39, 0x50, 0xC7, 0xFD, 0x48, 0xD1, 0x0C, 0x60, 0xF9, 0xF1, 0x79, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00E480:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D3[] = {
/*00EA80:*/ 0xAF, 0x39, 0x50, 0xC7, 0x21, 0x48, 0xD1, 0x0C, 0x4B, 0xF9, 0xF1, 0x79, 0x0C, 0xAE, 0xF3, 0xB1, 
/*00EA90:*/ 0xF7, 0x55, 0x25, 0x38, 0x0E, 0xAB, 0x73, 0x23, 0xA0, 0x28, 0xA5, 0x40, 0xAC, 0xC5, 0x30, 0xDA, 
/*00EAA0:*/ 0xF8, 0xA6, 0x1F, 0x24, 0xAF, 0x11, 0xA9, 0x33, 0x99, 0x81, 0x1C, 0x53, 0x0B, 0xD8, 0x61, 0x70, 
/*00EAB0:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x8C, 0xF2, 0x13, 0xEA, 0xF5, 0x08, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 
/*00EAC0:*/ 0x21, 0x39, 0x50, 0xC7, 0x79, 0x4A, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x18, 0xAE, 0xF3, 0xB1, 
/*00EAD0:*/ 0xF9, 0x55, 0x25, 0x38, 0xE3, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0xF1, 0xC7, 0x30, 0xDA, 
/*00EAE0:*/ 0xEA, 0xA6, 0x1F, 0x24, 0x0F, 0x10, 0xA9, 0x33, 0x52, 0x7D, 0xE3, 0xAC, 0x8B, 0xD9, 0x61, 0x70, 
/*00EAF0:*/ 0x1A, 0x1C, 0x46, 0xD4, 0xA4, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xCA, 0x97, 0x6F, 0xA7, 
/*00EB00:*/ 0xB1, 0x39, 0x50, 0xC7, 0x39, 0x48, 0xD1, 0x0C, 0x71, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00EB10:*/ 0xF1, 0x55, 0x25, 0x38, 0xCD, 0xAA, 0x73, 0x23, 0x0C, 0x28, 0xA5, 0x40, 0xA9, 0x3A, 0xCF, 0x25, 
/*00EB20:*/ 0xF4, 0xA6, 0x1F, 0x24, 0x12, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0xE1, 0xD9, 0x61, 0x70, 
/*00EB30:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0xF0, 0xF2, 0x13, 0xEA, 0x29, 0x09, 0xCD, 0x6A, 0xDB, 0x97, 0x6F, 0xA7, 
/*00EB40:*/ 0xA0, 0x39, 0x50, 0xC7, 0x7F, 0x48, 0xD1, 0x0C, 0x6D, 0xF9, 0xF1, 0x79, 0x31, 0xAE, 0xF3, 0xB1, 
/*00EB50:*/ 0x94, 0x55, 0x25, 0x38, 0xC3, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0x15, 0x3A, 0xCF, 0x25, 
/*00EB60:*/ 0x92, 0xA6, 0x1F, 0x24, 0xF2, 0xEF, 0x56, 0xCC, 0x2C, 0x7D, 0xE3, 0xAC, 0x92, 0xD9, 0x61, 0x70, 
/*00EB70:*/ 0xE6, 0xE3, 0xB9, 0x2B, 0xCA, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 
/*00EB80:*/ 0x59, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0x53, 0xF9, 0xF1, 0x79, 0x29, 0xAE, 0xF3, 0xB1, 
/*00EB90:*/ 0xF8, 0x55, 0x25, 0x38, 0xD1, 0xAA, 0x73, 0x23, 0x17, 0x28, 0xA5, 0x40, 0xF3, 0x3A, 0xCF, 0x25, 
/*00EBA0:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x7F, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0x44, 0xD9, 0x61, 0x70, 
/*00EBB0:*/ 0xEA, 0xE3, 0xB9, 0x2B, 0x86, 0xF2, 0x13, 0xEA, 0x07, 0x09, 0xCD, 0x6A, 0xCC, 0x97, 0x6F, 0xA7, 
/*00EBC0:*/ 0xA1, 0x39, 0x50, 0xC7, 0x31, 0x48, 0xD1, 0x0C, 0x3A, 0xFB, 0xF1, 0x79, 0x2D, 0xAE, 0xF3, 0xB1, 
/*00EBD0:*/ 0xC6, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0xBB, 0xD7, 0x5A, 0xBF, 0xAE, 0xC5, 0x30, 0xDA, 
/*00EBE0:*/ 0x1D, 0xA6, 0x1F, 0x24, 0x0C, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0xE2, 0xD9, 0x61, 0x70, 
/*00EBF0:*/ 0xB9, 0xE3, 0xB9, 0x2B, 0x60, 0x0D, 0xEC, 0x15, 0x04, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 
/*00EC00:*/ 0xC3, 0x38, 0x50, 0xC7, 0x18, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x26, 0xAF, 0xF3, 0xB1, 
/*00EC10:*/ 0xE0, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x02, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00EC20:*/ 0x87, 0xA4, 0x1F, 0x24, 0x9B, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0x25, 0x26, 0x9E, 0x8F, 
/*00EC30:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x9D, 0xF2, 0x13, 0xEA, 0x91, 0x08, 0xCD, 0x6A, 0xD0, 0x97, 0x6F, 0xA7, 
/*00EC40:*/ 0x80, 0x38, 0x50, 0xC7, 0x73, 0x48, 0xD1, 0x0C, 0x1C, 0xF9, 0xF1, 0x79, 0x36, 0xAE, 0xF3, 0xB1, 
/*00EC50:*/ 0xB7, 0x55, 0x25, 0x38, 0xB2, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0xA8, 0xC5, 0x30, 0xDA, 
/*00EC60:*/ 0x1F, 0xA7, 0x1F, 0x24, 0x18, 0x10, 0xA9, 0x33, 0x83, 0x82, 0x1C, 0x53, 0x19, 0xD9, 0x61, 0x70, 
/*00EC70:*/ 0xFF, 0xE3, 0xB9, 0x2B, 0x3E, 0xF2, 0x13, 0xEA, 0x2D, 0x09, 0xCD, 0x6A, 0xE0, 0x97, 0x6F, 0xA7, 
/*00EC80:*/ 0xB7, 0x39, 0x50, 0xC7, 0x13, 0x49, 0xD1, 0x0C, 0x6C, 0xF9, 0xF1, 0x79, 0x4A, 0xAE, 0xF3, 0xB1, 
/*00EC90:*/ 0xF9, 0x55, 0x25, 0x38, 0xC8, 0xAA, 0x73, 0x23, 0x71, 0x28, 0xA5, 0x40, 0x83, 0xC5, 0x30, 0xDA, 
/*00ECA0:*/ 0xE8, 0xA6, 0x1F, 0x24, 0x27, 0x10, 0xA9, 0x33, 0x7D, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 
/*00ECB0:*/ 0xF5, 0xE3, 0xB9, 0x2B, 0x95, 0xF2, 0x13, 0xEA, 0x1B, 0x09, 0xCD, 0x6A, 0xEA, 0x97, 0x6F, 0xA7, 
/*00ECC0:*/ 0xA2, 0x39, 0x50, 0xC7, 0x94, 0x49, 0xD1, 0x0C, 0x47, 0xF9, 0xF1, 0x79, 0x3B, 0xAE, 0xF3, 0xB1, 
/*00ECD0:*/ 0xE6, 0x55, 0x25, 0x38, 0xDB, 0xAA, 0x73, 0x23, 0x83, 0xD4, 0x5A, 0xBF, 0xBD, 0xC5, 0x30, 0xDA, 
/*00ECE0:*/ 0xF0, 0xA6, 0x1F, 0x24, 0x76, 0x10, 0xA9, 0x33, 0x8C, 0x82, 0x1C, 0x53, 0xD7, 0xD9, 0x61, 0x70, 
/*00ECF0:*/ 0xA2, 0xE3, 0xB9, 0x2B, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00ED00:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D4[] = {
/*00F330:*/ 0xA9, 0x39, 0x50, 0xC7, 0xDA, 0xB7, 0x2E, 0xF3, 0xCA, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*00F340:*/ 0x5E, 0x55, 0x25, 0x38, 0xD6, 0xAA, 0x73, 0x23, 0x5D, 0x28, 0xA5, 0x40, 0xB1, 0xC5, 0x30, 0xDA, 
/*00F350:*/ 0x22, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 0xFC, 0x82, 0x1C, 0x53, 0x1D, 0xD9, 0x61, 0x70, 
/*00F360:*/ 0xFE, 0xE3, 0xB9, 0x2B, 0x77, 0xF3, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0x6D, 0x9B, 0x6F, 0xA7, 
/*00F370:*/ 0xA0, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0xA9, 0xFA, 0xF1, 0x79, 0x23, 0xAE, 0xF3, 0xB1, 
/*00F380:*/ 0x8C, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0xC5, 0xC5, 0x30, 0xDA, 
/*00F390:*/ 0xC0, 0xA6, 0x1F, 0x24, 0x24, 0x10, 0xA9, 0x33, 0x92, 0x82, 0x1C, 0x53, 0x91, 0xD9, 0x61, 0x70, 
/*00F3A0:*/ 0xF2, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 0x23, 0x09, 0xCD, 0x6A, 0xD0, 0x97, 0x6F, 0xA7, 
/*00F3B0:*/ 0x91, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x44, 0xF8, 0xF1, 0x79, 0x64, 0xAE, 0xF3, 0xB1, 
/*00F3C0:*/ 0x85, 0x55, 0x25, 0x38, 0x83, 0xAA, 0x73, 0x23, 0x03, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 
/*00F3D0:*/ 0x0D, 0xA6, 0x1F, 0x24, 0x08, 0x10, 0xA9, 0x33, 0xD5, 0x82, 0x1C, 0x53, 0x9F, 0x26, 0x9E, 0x8F, 
/*00F3E0:*/ 0xE2, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 0xD9, 0x09, 0xCD, 0x6A, 0xD6, 0x97, 0x6F, 0xA7, 
/*00F3F0:*/ 0xB2, 0x39, 0x50, 0xC7, 0x26, 0x48, 0xD1, 0x0C, 0xCB, 0xF9, 0xF1, 0x79, 0xF9, 0xAE, 0xF3, 0xB1, 
/*00F400:*/ 0x0A, 0x55, 0x25, 0x38, 0xD2, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0x8D, 0xC5, 0x30, 0xDA, 
/*00F410:*/ 0xF2, 0xA6, 0x1F, 0x24, 0x14, 0x10, 0xA9, 0x33, 0xED, 0x82, 0x1C, 0x53, 0xBF, 0xD9, 0x61, 0x70, 
/*00F420:*/ 0xC6, 0xE2, 0xB9, 0x2B, 0x97, 0xF2, 0x13, 0xEA, 0x14, 0x0A, 0xCD, 0x6A, 0xDB, 0x97, 0x6F, 0xA7, 
/*00F430:*/ 0xE3, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x6E, 0xAE, 0xF3, 0xB1, 
/*00F440:*/ 0xB5, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x4B, 0x28, 0xA5, 0x40, 0xB5, 0xC5, 0x30, 0xDA, 
/*00F450:*/ 0xEC, 0xA6, 0x1F, 0x24, 0x08, 0x10, 0xA9, 0x33, 0xC3, 0x82, 0x1C, 0x53, 0x81, 0xD9, 0x61, 0x70, 
/*00F460:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x40, 0xF2, 0x13, 0xEA, 0x33, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*00F470:*/ 0xA8, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x1E, 0x06, 0x0E, 0x86, 0x28, 0xAE, 0xF3, 0xB1, 
/*00F480:*/ 0xF0, 0x55, 0x25, 0x38, 0xD0, 0xAA, 0x73, 0x23, 0x1E, 0x28, 0xA5, 0x40, 0xA7, 0xC5, 0x30, 0xDA, 
/*00F490:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x37, 0x10, 0xA9, 0x33, 0xCC, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 
/*00F4A0:*/ 0xC8, 0xE3, 0xB9, 0x2B, 0xA3, 0xF2, 0x13, 0xEA, 0x15, 0x0B, 0xCD, 0x6A, 0x84, 0x97, 0x6F, 0xA7, 
/*00F4B0:*/ 0x9D, 0x38, 0x50, 0xC7, 0x04, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*00F4C0:*/ 0xEE, 0x55, 0x25, 0x38, 0x8F, 0xAA, 0x73, 0x23, 0x52, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00F4D0:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x6B, 0xEF, 0x56, 0xCC, 0xE4, 0x82, 0x1C, 0x53, 0xF1, 0xD9, 0x61, 0x70, 
/*00F4E0:*/ 0x62, 0xE2, 0xB9, 0x2B, 0x92, 0xF2, 0x13, 0xEA, 0x2D, 0x09, 0xCD, 0x6A, 0xDE, 0x97, 0x6F, 0xA7, 
/*00F4F0:*/ 0xE2, 0x39, 0x50, 0xC7, 0x7C, 0x48, 0xD1, 0x0C, 0x40, 0xF9, 0xF1, 0x79, 0x37, 0xAE, 0xF3, 0xB1, 
/*00F500:*/ 0xFE, 0x55, 0x25, 0x38, 0xFB, 0xAA, 0x73, 0x23, 0x1E, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00F510:*/ 0xB9, 0xA6, 0x1F, 0x24, 0x6A, 0x10, 0xA9, 0x33, 0xDF, 0x82, 0x1C, 0x53, 0x81, 0xD9, 0x61, 0x70, 
/*00F520:*/ 0xBA, 0xE3, 0xB9, 0x2B, 0xA1, 0xF2, 0x13, 0xEA, 0xFB, 0x08, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*00F530:*/ 0x75, 0xC4, 0xAF, 0x38, 0x14, 0x48, 0xD1, 0x0C, 0x59, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00F540:*/ 0x19, 0x55, 0x25, 0x38, 0x12, 0xA9, 0x73, 0x23, 0x59, 0x29, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 
/*00F550:*/ 0xB8, 0xA6, 0x1F, 0x24, 0x13, 0x10, 0xA9, 0x33, 0xC8, 0x82, 0x1C, 0x53, 0xD6, 0xD9, 0x61, 0x70, 
/*00F560:*/ 0xE0, 0xE3, 0xB9, 0x2B, 0xFE, 0xF3, 0x13, 0xEA, 0x36, 0x09, 0xCD, 0x6A, 0x9E, 0x97, 0x6F, 0xA7, 
/*00F570:*/ 0xA1, 0x39, 0x50, 0xC7, 0x4F, 0x49, 0xD1, 0x0C, 0x45, 0xF9, 0xF1, 0x79, 0x09, 0xAE, 0xF3, 0xB1, 
/*00F580:*/ 0xF6, 0x55, 0x25, 0x38, 0xCB, 0xAA, 0x73, 0x23, 0x4E, 0x28, 0xA5, 0x40, 0xC0, 0xC5, 0x30, 0xDA, 
/*00F590:*/ 0x6E, 0xA6, 0x1F, 0x24, 0x0C, 0x10, 0xA9, 0x33, 0xA9, 0x82, 0x1C, 0x53, 0xAB, 0xD8, 0x61, 0x70, 
/*00F5A0:*/ 0x66, 0xE3, 0xB9, 0x2B, 0xC8, 0xF0, 0x13, 0xEA, 0x34, 0x09, 0xCD, 0x6A, 0x88, 0x97, 0x6F, 0xA7, 
/*00F5B0:*/ 0xAF, 0x39, 0x50, 0xC7, 0xFA, 0xB7, 0x2E, 0xF3, 0x7F, 0xF9, 0xF1, 0x79, 0x2F, 0xAE, 0xF3, 0xB1, 
/*00F5C0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D5[] = {
/*00FB60:*/ 0x15, 0x39, 0x50, 0xC7, 0xDD, 0x48, 0xD1, 0x0C, 0x22, 0xF9, 0xF1, 0x79, 0x1E, 0xAE, 0xF3, 0xB1, 
/*00FB70:*/ 0xF9, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0xF9, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 
/*00FB80:*/ 0xE5, 0xA6, 0x1F, 0x24, 0x45, 0x10, 0xA9, 0x33, 0xD1, 0x82, 0x1C, 0x53, 0x24, 0xD9, 0x61, 0x70, 
/*00FB90:*/ 0xA7, 0xE3, 0xB9, 0x2B, 0xBA, 0xF2, 0x13, 0xEA, 0x29, 0xF7, 0x32, 0x95, 0xD2, 0x97, 0x6F, 0xA7, 
/*00FBA0:*/ 0xB6, 0x39, 0x50, 0xC7, 0x4E, 0xB5, 0x2E, 0xF3, 0x5D, 0xF9, 0xF1, 0x79, 0x11, 0xAE, 0xF3, 0xB1, 
/*00FBB0:*/ 0x6E, 0xAA, 0xDA, 0xC7, 0xCB, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0xB8, 0xC5, 0x30, 0xDA, 
/*00FBC0:*/ 0x89, 0xA4, 0x1F, 0x24, 0x15, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 
/*00FBD0:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x85, 0xF2, 0x13, 0xEA, 0x36, 0x09, 0xCD, 0x6A, 0xD0, 0x97, 0x6F, 0xA7, 
/*00FBE0:*/ 0xB2, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x52, 0xF9, 0xF1, 0x79, 0x26, 0xAE, 0xF3, 0xB1, 
/*00FBF0:*/ 0xC2, 0x55, 0x25, 0x38, 0xD6, 0xAA, 0x73, 0x23, 0x04, 0x28, 0xA5, 0x40, 0x99, 0xC5, 0x30, 0xDA, 
/*00FC00:*/ 0x89, 0xA6, 0x1F, 0x24, 0x36, 0x10, 0xA9, 0x33, 0x79, 0x82, 0x1C, 0x53, 0xBD, 0xD9, 0x61, 0x70, 
/*00FC10:*/ 0xA1, 0xE3, 0xB9, 0x2B, 0xE6, 0x0C, 0xEC, 0x15, 0x37, 0x09, 0xCD, 0x6A, 0xD7, 0x97, 0x6F, 0xA7, 
/*00FC20:*/ 0xB3, 0x39, 0x50, 0xC7, 0xC4, 0xB7, 0x2E, 0xF3, 0x5D, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 
/*00FC30:*/ 0xD4, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0xBC, 0xC4, 0x30, 0xDA, 
/*00FC40:*/ 0xF5, 0xA6, 0x1F, 0x24, 0xDF, 0xEF, 0x56, 0xCC, 0xC0, 0x82, 0x1C, 0x53, 0xC6, 0xD9, 0x61, 0x70, 
/*00FC50:*/ 0x10, 0x1C, 0x46, 0xD4, 0xD0, 0xF2, 0x13, 0xEA, 0x31, 0x09, 0xCD, 0x6A, 0x55, 0x97, 0x6F, 0xA7, 
/*00FC60:*/ 0xF4, 0x39, 0x50, 0xC7, 0x07, 0x48, 0xD1, 0x0C, 0x54, 0xF9, 0xF1, 0x79, 0x3D, 0xAE, 0xF3, 0xB1, 
/*00FC70:*/ 0xE1, 0x54, 0x25, 0x38, 0x9A, 0xAA, 0x73, 0x23, 0x05, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*00FC80:*/ 0x31, 0xA7, 0x1F, 0x24, 0x31, 0x10, 0xA9, 0x33, 0x21, 0x7D, 0xE3, 0xAC, 0x14, 0xD9, 0x61, 0x70, 
/*00FC90:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x9E, 0xF2, 0x13, 0xEA, 0x0A, 0x09, 0xCD, 0x6A, 0xD1, 0x97, 0x6F, 0xA7, 
/*00FCA0:*/ 0xB4, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 0x4A, 0xF9, 0xF1, 0x79, 0xB5, 0xAE, 0xF3, 0xB1, 
/*00FCB0:*/ 0xC2, 0x58, 0x25, 0x38, 0xCB, 0xAA, 0x73, 0x23, 0xDD, 0x28, 0xA5, 0x40, 0xA8, 0xC5, 0x30, 0xDA, 
/*00FCC0:*/ 0x1D, 0xA7, 0x1F, 0x24, 0xA3, 0xED, 0x56, 0xCC, 0xDA, 0x82, 0x1C, 0x53, 0x84, 0xD9, 0x61, 0x70, 
/*00FCD0:*/ 0xF2, 0xE3, 0xB9, 0x2B, 0x99, 0xF2, 0x13, 0xEA, 0x3F, 0x08, 0xCD, 0x6A, 0xCE, 0x97, 0x6F, 0xA7, 
/*00FCE0:*/ 0x51, 0xC6, 0xAF, 0x38, 0xC4, 0x48, 0xD1, 0x0C, 0x74, 0xF9, 0xF1, 0x79, 0x55, 0xAE, 0xF3, 0xB1, 
/*00FCF0:*/ 0xF9, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 0x73, 0x28, 0xA5, 0x40, 0x35, 0xC5, 0x30, 0xDA, 
/*00FD00:*/ 0xF5, 0xA6, 0x1F, 0x24, 0xEB, 0x11, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0x81, 0xD9, 0x61, 0x70, 
/*00FD10:*/ 0x25, 0xE2, 0xB9, 0x2B, 0x86, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xEE, 0x97, 0x6F, 0xA7, 
/*00FD20:*/ 0xB6, 0x39, 0x50, 0xC7, 0x0F, 0x48, 0xD1, 0x0C, 0x58, 0xF9, 0xF1, 0x79, 0xC7, 0xAE, 0xF3, 0xB1, 
/*00FD30:*/ 0x07, 0x54, 0x25, 0x38, 0x54, 0xAA, 0x73, 0x23, 0x14, 0x28, 0xA5, 0x40, 0xA4, 0xC5, 0x30, 0xDA, 
/*00FD40:*/ 0xD4, 0xA4, 0x1F, 0x24, 0x1F, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0xDE, 0xDB, 0x61, 0x70, 
/*00FD50:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0x05, 0x0D, 0xEC, 0x15, 0x3E, 0x09, 0xCD, 0x6A, 0xF5, 0x97, 0x6F, 0xA7, 
/*00FD60:*/ 0xB1, 0x3B, 0x50, 0xC7, 0x16, 0x48, 0xD1, 0x0C, 0xD2, 0xF9, 0xF1, 0x79, 0x4A, 0x51, 0x0C, 0x4E, 
/*00FD70:*/ 0xB4, 0x55, 0x25, 0x38, 0x00, 0x55, 0x8C, 0xDC, 0x0A, 0x28, 0xA5, 0x40, 0x92, 0xC5, 0x30, 0xDA, 
/*00FD80:*/ 0xF3, 0xA6, 0x1F, 0x24, 0x56, 0x10, 0xA9, 0x33, 0xC8, 0x82, 0x1C, 0x53, 0x26, 0x26, 0x9E, 0x8F, 
/*00FD90:*/ 0x3E, 0x1C, 0x46, 0xD4, 0xA1, 0xF2, 0x13, 0xEA, 0x34, 0xF7, 0x32, 0x95, 0xD9, 0x97, 0x6F, 0xA7, 
/*00FDA0:*/ 0x04, 0x39, 0x50, 0xC7, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00FDB0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D6[] = {
/*04D8:*/ 0xA8, 0xC4, 0xAF, 0x38, 0x57, 0x48, 0xD1, 0x0C, 
/*04E0:*/ 0x5D, 0xF9, 0xF1, 0x79, 0xD0, 0xAC, 0xF3, 0xB1, 0x87, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*04F0:*/ 0x46, 0x28, 0xA5, 0x40, 0xB3, 0xC5, 0x30, 0xDA, 0xEC, 0xA6, 0x1F, 0x24, 0x04, 0x10, 0xA9, 0x33, 
/*0500:*/ 0x94, 0x82, 0x1C, 0x53, 0x80, 0xD9, 0x61, 0x70, 0x82, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*0510:*/ 0x3E, 0x09, 0xCD, 0x6A, 0xD0, 0x97, 0x6F, 0xA7, 0xCD, 0x39, 0x50, 0xC7, 0x02, 0x48, 0xD1, 0x0C, 
/*0520:*/ 0x2D, 0xFB, 0xF1, 0x79, 0x28, 0xAE, 0xF3, 0xB1, 0xE5, 0x55, 0x25, 0x38, 0x82, 0xAA, 0x73, 0x23, 
/*0530:*/ 0x08, 0x28, 0xA5, 0x40, 0xB7, 0xC5, 0x30, 0xDA, 0xEF, 0xA6, 0x1F, 0x24, 0x25, 0x10, 0xA9, 0x33, 
/*0540:*/ 0xDD, 0x82, 0x1C, 0x53, 0xB0, 0xD9, 0x61, 0x70, 0x61, 0xE3, 0xB9, 0x2B, 0xCA, 0xF2, 0x13, 0xEA, 
/*0550:*/ 0x3E, 0x09, 0xCD, 0x6A, 0xD7, 0x95, 0x6F, 0xA7, 0xE7, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*0560:*/ 0x1F, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0xF5, 0x55, 0x25, 0x38, 0xC8, 0xAA, 0x73, 0x23, 
/*0570:*/ 0x7B, 0x28, 0xA5, 0x40, 0xDF, 0xC5, 0x30, 0xDA, 0xED, 0xA6, 0x1F, 0x24, 0x3F, 0x10, 0xA9, 0x33, 
/*0580:*/ 0xF6, 0x80, 0x1C, 0x53, 0xA0, 0xD9, 0x61, 0x70, 0xA6, 0xE3, 0xB9, 0x2B, 0x1B, 0xF3, 0x13, 0xEA, 
/*0590:*/ 0x28, 0x09, 0xCD, 0x6A, 0xBC, 0x97, 0x6F, 0xA7, 0xFE, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*05A0:*/ 0xD1, 0xF9, 0xF1, 0x79, 0xBB, 0x50, 0x0C, 0x4E, 0x87, 0x55, 0x25, 0x38, 0xFE, 0xAA, 0x73, 0x23, 
/*05B0:*/ 0x04, 0x28, 0xA5, 0x40, 0xDF, 0x3A, 0xCF, 0x25, 0xD2, 0xA6, 0x1F, 0x24, 0x0C, 0x10, 0xA9, 0x33, 
/*05C0:*/ 0xCA, 0x82, 0x1C, 0x53, 0xE0, 0xD9, 0x61, 0x70, 0x8B, 0xE3, 0xB9, 0x2B, 0xAA, 0xF2, 0x13, 0xEA, 
/*05D0:*/ 0x37, 0x09, 0xCD, 0x6A, 0xF5, 0x97, 0x6F, 0xA7, 0xA1, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*05E0:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x36, 0xAE, 0xF3, 0xB1, 0xF8, 0x55, 0x25, 0x38, 0x80, 0xAA, 0x73, 0x23, 
/*05F0:*/ 0x08, 0x2A, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0xF1, 0xA6, 0x1F, 0x24, 0x2D, 0x10, 0xA9, 0x33, 
/*0600:*/ 0xCB, 0x82, 0x1C, 0x53, 0x9E, 0xD9, 0x61, 0x70, 0xFB, 0xE3, 0xB9, 0x2B, 0xB6, 0xF2, 0x13, 0xEA, 
/*0610:*/ 0x29, 0x09, 0xCD, 0x6A, 0xCB, 0x97, 0x6F, 0xA7, 0xA8, 0x39, 0x50, 0xC7, 0xF5, 0x48, 0xD1, 0x0C, 
/*0620:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x34, 0xAE, 0xF3, 0xB1, 0xF1, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*0630:*/ 0x04, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0xBE, 0xBF, 0x1F, 0x24, 0x2E, 0x10, 0xA9, 0x33, 
/*0640:*/ 0xC7, 0x82, 0x1C, 0x53, 0x45, 0x26, 0x9E, 0x8F, 0xA2, 0xE3, 0xB9, 0x2B, 0x96, 0xF2, 0x13, 0xEA, 
/*0650:*/ 0x79, 0x09, 0xCD, 0x6A, 0x9F, 0x97, 0x6F, 0xA7, 0xE0, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*0660:*/ 0x3E, 0xF9, 0xF1, 0x79, 0x29, 0xAE, 0xF3, 0xB1, 0xD4, 0x55, 0x25, 0x38, 0xFE, 0xAA, 0x73, 0x23, 
/*0670:*/ 0x04, 0x28, 0xA5, 0x40, 0xA0, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x12, 0x10, 0xA9, 0x33, 
/*0680:*/ 0x7F, 0x82, 0x1C, 0x53, 0x89, 0xD9, 0x61, 0x70, 0xA8, 0xE3, 0xB9, 0x2B, 0xDD, 0xF2, 0x13, 0xEA, 
/*0690:*/ 0x33, 0x09, 0xCD, 0x6A, 0xF4, 0x97, 0x6F, 0xA7, 0xA1, 0x39, 0x50, 0xC7, 0x11, 0x48, 0xD1, 0x0C, 
/*06A0:*/ 0x40, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0xFE, 0x55, 0x25, 0x38, 0xFD, 0xAA, 0x73, 0x23, 
/*06B0:*/ 0x37, 0x29, 0xA5, 0x40, 0x9E, 0xC5, 0x30, 0xDA, 0xF5, 0xA6, 0x1F, 0x24, 0x1F, 0x10, 0xA9, 0x33, 
/*06C0:*/ 0xC2, 0x82, 0x1C, 0x53, 0x96, 0xD9, 0x61, 0x70, 0xC2, 0xE3, 0xB9, 0x2B, 0xF7, 0xF2, 0x13, 0xEA, 
/*06D0:*/ 0x3E, 0x09, 0xCD, 0x6A, 0x72, 0x96, 0x6F, 0xA7, 0xB1, 0x39, 0x50, 0xC7, 0xAE, 0x48, 0xD1, 0x0C, 
/*06E0:*/ 0xD5, 0xF9, 0xF1, 0x79, 0x3D, 0xAE, 0xF3, 0xB1, 0xF8, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*06F0:*/ 0x30, 0x28, 0xA5, 0x40, 0xFF, 0xC5, 0x30, 0xDA, 0xD5, 0xA6, 0x1F, 0x24, 0x1F, 0x10, 0xA9, 0x33, 
/*0700:*/ 0xAA, 0x82, 0x1C, 0x53, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*0710:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D7[] = {
/*0CD0:*/ 0x9B, 0x39, 0x50, 0xC7, 0xC6, 0x49, 0xD1, 0x0C, 0x70, 0xF9, 0xF1, 0x79, 0xF4, 0x50, 0x0C, 0x4E, 
/*0CE0:*/ 0xDE, 0x55, 0x25, 0x38, 0x99, 0xAA, 0x73, 0x23, 0x13, 0x28, 0xA5, 0x40, 0xF6, 0xC5, 0x30, 0xDA, 
/*0CF0:*/ 0xBC, 0xA6, 0x1F, 0x24, 0x01, 0x04, 0xA9, 0x33, 0xE8, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 
/*0D00:*/ 0xE0, 0xE3, 0xB9, 0x2B, 0x87, 0xF4, 0x13, 0xEA, 0x24, 0x09, 0xCD, 0x6A, 0xE7, 0x97, 0x6F, 0xA7, 
/*0D10:*/ 0xA0, 0x39, 0x50, 0xC7, 0x1F, 0x48, 0xD1, 0x0C, 0x48, 0xF9, 0xF1, 0x79, 0x3B, 0xAE, 0xF3, 0xB1, 
/*0D20:*/ 0xD4, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 0x12, 0x28, 0xA5, 0x40, 0x79, 0x3A, 0xCF, 0x25, 
/*0D30:*/ 0xCB, 0xA6, 0x1F, 0x24, 0x46, 0x10, 0xA9, 0x33, 0xCA, 0x82, 0x1C, 0x53, 0x92, 0xD9, 0x61, 0x70, 
/*0D40:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 0x2C, 0x09, 0xCD, 0x6A, 0xCB, 0x97, 0x6F, 0xA7, 
/*0D50:*/ 0xAA, 0x39, 0x50, 0xC7, 0x3D, 0x48, 0xD1, 0x0C, 0x5B, 0xF9, 0xF1, 0x79, 0x28, 0xAE, 0xF3, 0xB1, 
/*0D60:*/ 0x3F, 0x55, 0x25, 0x38, 0xB2, 0xAA, 0x73, 0x23, 0xA4, 0x28, 0xA5, 0x40, 0xFD, 0xC5, 0x30, 0xDA, 
/*0D70:*/ 0xE7, 0xA6, 0x1F, 0x24, 0xB3, 0x10, 0xA9, 0x33, 0xCC, 0x82, 0x1C, 0x53, 0x81, 0xD9, 0x61, 0x70, 
/*0D80:*/ 0xFC, 0xE3, 0xB9, 0x2B, 0xAB, 0xF2, 0x13, 0xEA, 0x3F, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*0D90:*/ 0x40, 0xC6, 0xAF, 0x38, 0x34, 0x48, 0xD1, 0x0C, 0x6E, 0xF9, 0xF1, 0x79, 0x26, 0xAC, 0xF3, 0xB1, 
/*0DA0:*/ 0xF9, 0x55, 0x25, 0x38, 0xAC, 0x55, 0x8C, 0xDC, 0x42, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 
/*0DB0:*/ 0xE5, 0xA6, 0x1F, 0x24, 0x60, 0x10, 0xA9, 0x33, 0xC5, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 
/*0DC0:*/ 0xE7, 0xE3, 0xB9, 0x2B, 0x93, 0xF2, 0x13, 0xEA, 0x31, 0x09, 0xCD, 0x6A, 0xFE, 0x97, 0x6F, 0xA7, 
/*0DD0:*/ 0xE4, 0x39, 0x50, 0xC7, 0xDF, 0x48, 0xD1, 0x0C, 0x62, 0xF9, 0xF1, 0x79, 0x0B, 0xAC, 0xF3, 0xB1, 
/*0DE0:*/ 0x5E, 0x55, 0x25, 0x38, 0x85, 0xAA, 0x73, 0x23, 0x5F, 0x29, 0xA5, 0x40, 0x57, 0x3B, 0xCF, 0x25, 
/*0DF0:*/ 0xC0, 0xA6, 0x1F, 0x24, 0x17, 0x10, 0xA9, 0x33, 0xCB, 0x82, 0x1C, 0x53, 0x69, 0xD9, 0x61, 0x70, 
/*0E00:*/ 0x39, 0xE3, 0xB9, 0x2B, 0xBD, 0xF3, 0x13, 0xEA, 0xD4, 0x09, 0xCD, 0x6A, 0xF9, 0x95, 0x6F, 0xA7, 
/*0E10:*/ 0x8F, 0x39, 0x50, 0xC7, 0x0C, 0x48, 0xD1, 0x0C, 0x39, 0xF9, 0xF1, 0x79, 0x01, 0xAC, 0xF3, 0xB1, 
/*0E20:*/ 0xC5, 0x55, 0x25, 0x38, 0x75, 0x55, 0x8C, 0xDC, 0x13, 0x28, 0xA5, 0x40, 0x10, 0x3A, 0xCF, 0x25, 
/*0E30:*/ 0x5E, 0xA6, 0x1F, 0x24, 0x41, 0x11, 0xA9, 0x33, 0xB8, 0x82, 0x1C, 0x53, 0x5A, 0x24, 0x9E, 0x8F, 
/*0E40:*/ 0xF4, 0xE2, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x57, 0x08, 0xCD, 0x6A, 0xC7, 0x97, 0x6F, 0xA7, 
/*0E50:*/ 0xCF, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0x23, 0xF8, 0xF1, 0x79, 0x7A, 0xAE, 0xF3, 0xB1, 
/*0E60:*/ 0xF8, 0x55, 0x25, 0x38, 0x05, 0x55, 0x8C, 0xDC, 0x05, 0x28, 0xA5, 0x40, 0xAA, 0xC5, 0x30, 0xDA, 
/*0E70:*/ 0xEC, 0xA6, 0x1F, 0x24, 0x0A, 0x10, 0xA9, 0x33, 0xC0, 0x82, 0x1C, 0x53, 0xA4, 0xD9, 0x61, 0x70, 
/*0E80:*/ 0xFD, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 0x54, 0x09, 0xCD, 0x6A, 0xDE, 0x97, 0x6F, 0xA7, 
/*0E90:*/ 0xA1, 0x39, 0x50, 0xC7, 0x38, 0x48, 0xD1, 0x0C, 0x5A, 0xF9, 0xF1, 0x79, 0x29, 0xAE, 0xF3, 0xB1, 
/*0EA0:*/ 0xF5, 0x55, 0x25, 0x38, 0xD5, 0xAA, 0x73, 0x23, 0x1B, 0x28, 0xA5, 0x40, 0x37, 0xC5, 0x30, 0xDA, 
/*0EB0:*/ 0xD8, 0xAB, 0x1F, 0x24, 0x94, 0xEE, 0x56, 0xCC, 0x07, 0x82, 0x1C, 0x53, 0x8F, 0xD9, 0x61, 0x70, 
/*0EC0:*/ 0xD6, 0xE3, 0xB9, 0x2B, 0x8D, 0xF2, 0x13, 0xEA, 0x22, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*0ED0:*/ 0xB5, 0x39, 0x50, 0xC7, 0x28, 0x48, 0xD1, 0x0C, 0x57, 0xF9, 0xF1, 0x79, 0x1B, 0xAE, 0xF3, 0xB1, 
/*0EE0:*/ 0xC5, 0x55, 0x25, 0x38, 0x93, 0xAA, 0x73, 0x23, 0xDD, 0x28, 0xA5, 0x40, 0x89, 0xC5, 0x30, 0xDA, 
/*0EF0:*/ 0xE5, 0xA6, 0x1F, 0x24, 0x2B, 0x10, 0xA9, 0x33, 0xC3, 0x82, 0x1C, 0x53, 0x8A, 0xD9, 0x61, 0x70, 
/*0F00:*/ 0x90, 0xE0, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 0x3E, 0x09, 0xCD, 0x6A, 0x0C, 0x97, 0x6F, 0xA7, 
/*0F10:*/ 0xAF, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 0xCD, 0x06, 0x0E, 0x86, 0x14, 0xAE, 0xF3, 0xB1, 
/*0F20:*/ 0xD0, 0x5E, 0x25, 0x38, 0xC6, 0xAA, 0x73, 0x23, 0xB0, 0xD7, 0x5A, 0xBF, 0x68, 0xC4, 0x30, 0xDA, 
/*0F30:*/ 0xE7, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 0xEF, 0x82, 0x1C, 0x53, 0x3D, 0xD8, 0x61, 0x70, 
/*0F40:*/ 0x03, 0xE2, 0xB9, 0x2B, 0xD0, 0xF2, 0x13, 0xEA, 0x0A, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 
/*0F50:*/ 0xCE, 0x39, 0x50, 0xC7, 0xFB, 0x48, 0xD1, 0x0C, 0x49, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 
/*0F60:*/ 0xF4, 0x55, 0x25, 0x38, 0xB4, 0xAA, 0x73, 0x23, 0x61, 0x2A, 0xA5, 0x40, 0xFD, 0xC5, 0x30, 0xDA, 
/*0F70:*/ 0xBD, 0xA7, 0x1F, 0x24, 0x14, 0x10, 0xA9, 0x33, 0xAB, 0x82, 0x1C, 0x53, 0xC9, 0xD9, 0x61, 0x70, 
/*0F80:*/ 0x8E, 0xE3, 0xB9, 0x2B, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*0F90:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7D8[] = {
/*1478:*/ 0x0E, 0x39, 0x50, 0xC7, 0x17, 0x48, 0xD1, 0x0C, 
/*1480:*/ 0x56, 0xF9, 0xF1, 0x79, 0x54, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0x67, 0xAA, 0x73, 0x23, 
/*1490:*/ 0x0C, 0x28, 0xA5, 0x40, 0xBD, 0xC5, 0x30, 0xDA, 0x72, 0xA7, 0x1F, 0x24, 0x28, 0x11, 0xA9, 0x33, 
/*14A0:*/ 0x53, 0x82, 0x1C, 0x53, 0x8B, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x5F, 0xF0, 0x13, 0xEA, 
/*14B0:*/ 0x3C, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0xAD, 0x39, 0x50, 0xC7, 0xE6, 0xB7, 0x2E, 0xF3, 
/*14C0:*/ 0xF4, 0xF9, 0xF1, 0x79, 0xA5, 0xAF, 0xF3, 0xB1, 0xE8, 0x55, 0x25, 0x38, 0x8B, 0xA0, 0x73, 0x23, 
/*14D0:*/ 0x0B, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0xF1, 0xA6, 0x1F, 0x24, 0x01, 0x10, 0xA9, 0x33, 
/*14E0:*/ 0x79, 0x83, 0x1C, 0x53, 0x5A, 0x26, 0x9E, 0x8F, 0xD7, 0xE3, 0xB9, 0x2B, 0x8D, 0xF2, 0x13, 0xEA, 
/*14F0:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xCF, 0x97, 0x6F, 0xA7, 0x69, 0x38, 0x50, 0xC7, 0xF1, 0xB6, 0x2E, 0xF3, 
/*1500:*/ 0x53, 0xF9, 0xF1, 0x79, 0x31, 0xAE, 0xF3, 0xB1, 0x30, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*1510:*/ 0xF6, 0x28, 0xA5, 0x40, 0xB0, 0xC5, 0x30, 0xDA, 0x56, 0xA6, 0x1F, 0x24, 0x12, 0x10, 0xA9, 0x33, 
/*1520:*/ 0xFA, 0x82, 0x1C, 0x53, 0xC0, 0xD9, 0x61, 0x70, 0xEC, 0xE3, 0xB9, 0x2B, 0xA8, 0xF3, 0x13, 0xEA, 
/*1530:*/ 0x33, 0x09, 0xCD, 0x6A, 0x8F, 0x97, 0x6F, 0xA7, 0xAD, 0x39, 0x50, 0xC7, 0x7B, 0xB6, 0x2E, 0xF3, 
/*1540:*/ 0x5D, 0xF9, 0xF1, 0x79, 0x36, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0x9D, 0xAA, 0x73, 0x23, 
/*1550:*/ 0xAD, 0xD5, 0x5A, 0xBF, 0xC8, 0xC5, 0x30, 0xDA, 0xAF, 0xA6, 0x1F, 0x24, 0x61, 0x10, 0xA9, 0x33, 
/*1560:*/ 0xCB, 0x82, 0x1C, 0x53, 0x85, 0xD9, 0x61, 0x70, 0xEB, 0xE3, 0xB9, 0x2B, 0xAA, 0xF2, 0x13, 0xEA, 
/*1570:*/ 0x31, 0x09, 0xCD, 0x6A, 0xD2, 0x97, 0x6F, 0xA7, 0x18, 0x39, 0x50, 0xC7, 0x65, 0x49, 0xD1, 0x0C, 
/*1580:*/ 0x5B, 0xF9, 0xF1, 0x79, 0x33, 0xAE, 0xF3, 0xB1, 0x86, 0x55, 0x25, 0x38, 0x8E, 0xAA, 0x73, 0x23, 
/*1590:*/ 0x0B, 0x28, 0xA5, 0x40, 0x91, 0xC5, 0x30, 0xDA, 0xE0, 0xA6, 0x1F, 0x24, 0x04, 0x10, 0xA9, 0x33, 
/*15A0:*/ 0x21, 0x82, 0x1C, 0x53, 0x9B, 0xD9, 0x61, 0x70, 0x52, 0xE2, 0xB9, 0x2B, 0xFB, 0xF3, 0x13, 0xEA, 
/*15B0:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xD2, 0x97, 0x6F, 0xA7, 0xA1, 0x39, 0x50, 0xC7, 0x25, 0x48, 0xD1, 0x0C, 
/*15C0:*/ 0x66, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0x0F, 0xAA, 0xDA, 0xC7, 0xFA, 0xAA, 0x73, 0x23, 
/*15D0:*/ 0x1E, 0x28, 0xA5, 0x40, 0x61, 0x3A, 0xCF, 0x25, 0xC9, 0xA5, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*15E0:*/ 0xCB, 0x82, 0x1C, 0x53, 0xD7, 0xD9, 0x61, 0x70, 0xF2, 0xE3, 0xB9, 0x2B, 0x7A, 0xF3, 0x13, 0xEA, 
/*15F0:*/ 0x0C, 0x0B, 0xCD, 0x6A, 0x28, 0x68, 0x90, 0x58, 0xCC, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*1600:*/ 0xAF, 0xF9, 0xF1, 0x79, 0x28, 0xAE, 0xF3, 0xB1, 0xD4, 0x55, 0x25, 0x38, 0xE9, 0x54, 0x8C, 0xDC, 
/*1610:*/ 0x05, 0x28, 0xA5, 0x40, 0xA3, 0xC5, 0x30, 0xDA, 0x5A, 0xA7, 0x1F, 0x24, 0x15, 0x10, 0xA9, 0x33, 
/*1620:*/ 0x61, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xEC, 0xE3, 0xB9, 0x2B, 0x3D, 0x0D, 0xEC, 0x15, 
/*1630:*/ 0x3E, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xB1, 0x39, 0x50, 0xC7, 0x08, 0x41, 0xD1, 0x0C, 
/*1640:*/ 0x4E, 0xF9, 0xF1, 0x79, 0x2B, 0xAE, 0xF3, 0xB1, 0xE3, 0x55, 0x25, 0x38, 0xC2, 0xAA, 0x73, 0x23, 
/*1650:*/ 0x0B, 0x28, 0xA5, 0x40, 0xB9, 0xC5, 0x30, 0xDA, 0x00, 0x59, 0xE0, 0xDB, 0x03, 0x10, 0xA9, 0x33, 
/*1660:*/ 0xFD, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xD5, 0xE3, 0xB9, 0x2B, 0x48, 0xF3, 0x13, 0xEA, 
/*1670:*/ 0x2D, 0x09, 0xCD, 0x6A, 0xD1, 0x97, 0x6F, 0xA7, 0xAB, 0x39, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*1680:*/ 0x55, 0xF9, 0xF1, 0x79, 0xA8, 0xAE, 0xF3, 0xB1, 0xF7, 0x55, 0x25, 0x38, 0xC9, 0xAB, 0x73, 0x23, 
/*1690:*/ 0x15, 0x28, 0xA5, 0x40, 0xA7, 0xC5, 0x30, 0xDA, 0xF8, 0xA6, 0x1F, 0x24, 0x11, 0x10, 0xA9, 0x33, 
/*16A0:*/ 0xD7, 0x82, 0x1C, 0x53, 0x80, 0xD9, 0x61, 0x70, 0xF4, 0xE3, 0xB9, 0x2B, 0xD3, 0xF2, 0x13, 0xEA, 
/*16B0:*/ 0xA1, 0x09, 0xCD, 0x6A, 0xD4, 0x97, 0x6F, 0xA7, 0xC2, 0x38, 0x50, 0xC7, 0x2E, 0x49, 0xD1, 0x0C, 
/*16C0:*/ 0x52, 0xF9, 0xF1, 0x79, 0x0B, 0xAE, 0xF3, 0xB1, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*16D0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7D9[] = {
/*1E18:*/ 0xF0, 0xC6, 0xAF, 0x38, 0xB1, 0x49, 0xD1, 0x0C, 
/*1E20:*/ 0x47, 0xF9, 0xF1, 0x79, 0x39, 0xAE, 0xF3, 0xB1, 0xE5, 0x55, 0x25, 0x38, 0xC5, 0xAA, 0x73, 0x23, 
/*1E30:*/ 0x66, 0x28, 0xA5, 0x40, 0xED, 0xC5, 0x30, 0xDA, 0x14, 0xA7, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*1E40:*/ 0x95, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xFB, 0xE3, 0xB9, 0x2B, 0xF1, 0xF3, 0x13, 0xEA, 
/*1E50:*/ 0x2B, 0x09, 0xCD, 0x6A, 0xE8, 0x97, 0x6F, 0xA7, 0xA7, 0x39, 0x50, 0xC7, 0x04, 0x48, 0xD1, 0x0C, 
/*1E60:*/ 0x46, 0xF9, 0xF1, 0x79, 0x2B, 0xAE, 0xF3, 0xB1, 0x53, 0x54, 0x25, 0x38, 0x9B, 0x54, 0x8C, 0xDC, 
/*1E70:*/ 0x19, 0x29, 0xA5, 0x40, 0x62, 0xC5, 0x30, 0xDA, 0x8C, 0xA6, 0x1F, 0x24, 0x10, 0x10, 0xA9, 0x33, 
/*1E80:*/ 0x58, 0x82, 0x1C, 0x53, 0x12, 0xD9, 0x61, 0x70, 0xCB, 0xE3, 0xB9, 0x2B, 0x12, 0xF2, 0x13, 0xEA, 
/*1E90:*/ 0x6C, 0x09, 0xCD, 0x6A, 0xC3, 0x97, 0x6F, 0xA7, 0x5C, 0x38, 0x50, 0xC7, 0x9B, 0x48, 0xD1, 0x0C, 
/*1EA0:*/ 0xE8, 0x06, 0x0E, 0x86, 0xAC, 0xAF, 0xF3, 0xB1, 0xB8, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*1EB0:*/ 0x37, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 0xAB, 0xA5, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*1EC0:*/ 0xDC, 0x82, 0x1C, 0x53, 0x8A, 0xD9, 0x61, 0x70, 0xB3, 0xE3, 0xB9, 0x2B, 0x7F, 0x0D, 0xEC, 0x15, 
/*1ED0:*/ 0xCA, 0x09, 0xCD, 0x6A, 0xC1, 0x97, 0x6F, 0xA7, 0x74, 0x38, 0x50, 0xC7, 0x34, 0x48, 0xD1, 0x0C, 
/*1EE0:*/ 0x8D, 0xF9, 0xF1, 0x79, 0x09, 0xAE, 0xF3, 0xB1, 0x2A, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*1EF0:*/ 0x05, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 0xEA, 0xA6, 0x1F, 0x24, 0x1F, 0x10, 0xA9, 0x33, 
/*1F00:*/ 0xCA, 0x82, 0x1C, 0x53, 0x89, 0xD9, 0x61, 0x70, 0xDE, 0xE1, 0xB9, 0x2B, 0x6F, 0xF2, 0x13, 0xEA, 
/*1F10:*/ 0x2E, 0x09, 0xCD, 0x6A, 0xCF, 0x97, 0x6F, 0xA7, 0x80, 0x39, 0x50, 0xC7, 0x3F, 0x48, 0xD1, 0x0C, 
/*1F20:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x2E, 0xAE, 0xF3, 0xB1, 0xEB, 0x55, 0x25, 0x38, 0x76, 0xAB, 0x73, 0x23, 
/*1F30:*/ 0x2F, 0xD6, 0x5A, 0xBF, 0xBA, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x19, 0x10, 0xA9, 0x33, 
/*1F40:*/ 0xC3, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0xA0, 0xF2, 0x13, 0xEA, 
/*1F50:*/ 0x33, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0xAB, 0x39, 0x50, 0xC7, 0xF0, 0x48, 0xD1, 0x0C, 
/*1F60:*/ 0xAD, 0x06, 0x0E, 0x86, 0x3B, 0xAE, 0xF3, 0xB1, 0xDE, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*1F70:*/ 0x05, 0x28, 0xA5, 0x40, 0x56, 0xC5, 0x30, 0xDA, 0xA3, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*1F80:*/ 0xC8, 0x82, 0x1C, 0x53, 0xE3, 0xD9, 0x61, 0x70, 0x56, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 
/*1F90:*/ 0x38, 0x09, 0xCD, 0x6A, 0xD1, 0x97, 0x6F, 0xA7, 0xAB, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*1FA0:*/ 0x57, 0xF8, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0x92, 0x54, 0x25, 0x38, 0xEB, 0xAB, 0x73, 0x23, 
/*1FB0:*/ 0xD7, 0x28, 0xA5, 0x40, 0x94, 0xC4, 0x30, 0xDA, 0xA5, 0x59, 0xE0, 0xDB, 0x5C, 0x10, 0xA9, 0x33, 
/*1FC0:*/ 0xCB, 0x82, 0x1C, 0x53, 0x26, 0xD8, 0x61, 0x70, 0xB5, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 
/*1FD0:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0x40, 0xC6, 0xAF, 0x38, 0x85, 0xB7, 0x2E, 0xF3, 
/*1FE0:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x36, 0xAE, 0xF3, 0xB1, 0xBD, 0x55, 0x25, 0x38, 0xDB, 0xAA, 0x73, 0x23, 
/*1FF0:*/ 0x2E, 0x29, 0xA5, 0x40, 0xC5, 0xC4, 0x30, 0xDA, 0xB9, 0xA7, 0x1F, 0x24, 0x13, 0x10, 0xA9, 0x33, 
/*2000:*/ 0x4F, 0x83, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*2010:*/ 0xE9, 0xF6, 0x32, 0x95, 0x89, 0x97, 0x6F, 0xA7, 0x44, 0xC6, 0xAF, 0x38, 0x2D, 0x48, 0xD1, 0x0C, 
/*2020:*/ 0x1C, 0xF9, 0xF1, 0x79, 0xD9, 0x50, 0x0C, 0x4E, 0xF8, 0x55, 0x25, 0x38, 0x6F, 0x53, 0x8C, 0xDC, 
/*2030:*/ 0xEF, 0x28, 0xA5, 0x40, 0xBD, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x27, 0xEF, 0x56, 0xCC, 
/*2040:*/ 0xE3, 0x82, 0x1C, 0x53, 0xCE, 0xD9, 0x61, 0x70, 0x90, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*2050:*/ 0x11, 0x09, 0xCD, 0x6A, 0xF7, 0x97, 0x6F, 0xA7, 0xA2, 0x39, 0x50, 0xC7, 0x31, 0x49, 0xD1, 0x0C, 
/*2060:*/ 0x45, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0xF4, 0x55, 0x25, 0x38, 0xFA, 0x55, 0x8C, 0xDC, 
/*2070:*/ 0x62, 0x28, 0xA5, 0x40, 0x95, 0xC5, 0x30, 0xDA, 0xC1, 0xA6, 0x1F, 0x24, 0x2D, 0x11, 0xA9, 0x33, 
/*2080:*/ 0x10, 0x83, 0x1C, 0x53, 0x92, 0xD9, 0x61, 0x70, 0xC6, 0x1C, 0x46, 0xD4, 0x8A, 0xF2, 0x13, 0xEA, 
/*2090:*/ 0x2E, 0x09, 0xCD, 0x6A, 0xC7, 0x97, 0x6F, 0xA7, 0xDD, 0xC6, 0xAF, 0x38, 0x21, 0x48, 0xD1, 0x0C, 
/*20A0:*/ 0x4E, 0xF9, 0xF1, 0x79, 0x33, 0xAE, 0xF3, 0xB1, 0x05, 0xA8, 0xDA, 0xC7, 0xD0, 0xAA, 0x73, 0x23, 
/*20B0:*/ 0x0F, 0x28, 0xA5, 0x40, 0xB6, 0xC5, 0x30, 0xDA, 0xEC, 0xA6, 0x1F, 0x24, 0x8A, 0x10, 0xA9, 0x33, 
/*20C0:*/ 0xDD, 0x82, 0x1C, 0x53, 0x95, 0xD9, 0x61, 0x70, 0x0D, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 
/*20D0:*/ 0x32, 0x09, 0xCD, 0x6A, 0xC4, 0x97, 0x6F, 0xA7, 0xB3, 0x39, 0x50, 0xC7, 0x22, 0x48, 0xD1, 0x0C, 
/*20E0:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x63, 0xAC, 0xF3, 0xB1, 0xFE, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*20F0:*/ 0x0A, 0x28, 0xA5, 0x40, 0x81, 0xC5, 0x30, 0xDA, 0x6A, 0xA6, 0x1F, 0x24, 0x16, 0x10, 0xA9, 0x33, 
/*2100:*/ 0xC4, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xEC, 0xE3, 0xB9, 0x2B, 0x85, 0xF2, 0x13, 0xEA, 
/*2110:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xDB, 0x97, 0x6F, 0xA7, 0xA7, 0x39, 0x50, 0xC7, 0x3F, 0x48, 0xD1, 0x0C, 
/*2120:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*2130:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7DA[] = {
/*2828:*/ 0xB4, 0x39, 0x50, 0xC7, 0xDE, 0x49, 0xD1, 0x0C, 
/*2830:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x36, 0xAE, 0xF3, 0xB1, 0xEB, 0x55, 0x25, 0x38, 0xFF, 0xAA, 0x73, 0x23, 
/*2840:*/ 0x15, 0x28, 0xA5, 0x40, 0x11, 0xC5, 0x30, 0xDA, 0xE4, 0xA6, 0x1F, 0x24, 0x01, 0x10, 0xA9, 0x33, 
/*2850:*/ 0xC4, 0x82, 0x1C, 0x53, 0x9A, 0xD9, 0x61, 0x70, 0xF4, 0xE1, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*2860:*/ 0x0E, 0x09, 0xCD, 0x6A, 0x8E, 0x97, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*2870:*/ 0x71, 0xF9, 0xF1, 0x79, 0x33, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0x98, 0xAA, 0x73, 0x23, 
/*2880:*/ 0x04, 0x28, 0xA5, 0x40, 0x5E, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x0D, 0x10, 0xA9, 0x33, 
/*2890:*/ 0xEA, 0x81, 0x1C, 0x53, 0xBD, 0xD9, 0x61, 0x70, 0x3F, 0x1D, 0x46, 0xD4, 0xB1, 0xEB, 0x13, 0xEA, 
/*28A0:*/ 0x2E, 0x09, 0xCD, 0x6A, 0xC5, 0x95, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x23, 0x48, 0xD1, 0x0C, 
/*28B0:*/ 0x43, 0xF9, 0xF1, 0x79, 0x35, 0xAE, 0xF3, 0xB1, 0xEA, 0x55, 0x25, 0x38, 0xE3, 0xAA, 0x73, 0x23, 
/*28C0:*/ 0x8B, 0xD7, 0x5A, 0xBF, 0xB2, 0xC5, 0x30, 0xDA, 0xFF, 0xA6, 0x1F, 0x24, 0x31, 0x10, 0xA9, 0x33, 
/*28D0:*/ 0xDF, 0x82, 0x1C, 0x53, 0x8A, 0xD9, 0x61, 0x70, 0xF3, 0xE3, 0xB9, 0x2B, 0x84, 0xF2, 0x13, 0xEA, 
/*28E0:*/ 0x1F, 0x09, 0xCD, 0x6A, 0xCB, 0x97, 0x6F, 0xA7, 0xB8, 0x39, 0x50, 0xC7, 0x36, 0x48, 0xD1, 0x0C, 
/*28F0:*/ 0x4B, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xF8, 0x55, 0x25, 0x38, 0xC8, 0xAA, 0x73, 0x23, 
/*2900:*/ 0x25, 0x28, 0xA5, 0x40, 0x70, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x1B, 0x10, 0xA9, 0x33, 
/*2910:*/ 0xF8, 0x82, 0x1C, 0x53, 0xA6, 0xD9, 0x61, 0x70, 0x89, 0xE3, 0xB9, 0x2B, 0x17, 0x0C, 0xEC, 0x15, 
/*2920:*/ 0x04, 0x08, 0xCD, 0x6A, 0x9F, 0x97, 0x6F, 0xA7, 0x8A, 0x39, 0x50, 0xC7, 0x68, 0x48, 0xD1, 0x0C, 
/*2930:*/ 0x5B, 0xF9, 0xF1, 0x79, 0xCB, 0x51, 0x0C, 0x4E, 0xF8, 0x55, 0x25, 0x38, 0xC7, 0xAA, 0x73, 0x23, 
/*2940:*/ 0x6C, 0x28, 0xA5, 0x40, 0xAF, 0xC5, 0x30, 0xDA, 0x49, 0xA6, 0x1F, 0x24, 0x00, 0x10, 0xA9, 0x33, 
/*2950:*/ 0x8B, 0x83, 0x1C, 0x53, 0x65, 0x26, 0x9E, 0x8F, 0xE5, 0xE3, 0xB9, 0x2B, 0x93, 0xF2, 0x13, 0xEA, 
/*2960:*/ 0x9D, 0xF6, 0x32, 0x95, 0xE2, 0x97, 0x6F, 0xA7, 0xAF, 0x39, 0x50, 0xC7, 0x30, 0x48, 0xD1, 0x0C, 
/*2970:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x32, 0xAE, 0xF3, 0xB1, 0xFA, 0x55, 0x25, 0x38, 0x60, 0xAA, 0x73, 0x23, 
/*2980:*/ 0x45, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0xD5, 0xA6, 0x1F, 0x24, 0x33, 0x10, 0xA9, 0x33, 
/*2990:*/ 0xEC, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xED, 0xE3, 0xB9, 0x2B, 0xC0, 0xF2, 0x13, 0xEA, 
/*29A0:*/ 0x32, 0x09, 0xCD, 0x6A, 0xCB, 0x97, 0x6F, 0xA7, 0xB6, 0x39, 0x50, 0xC7, 0x39, 0x48, 0xD1, 0x0C, 
/*29B0:*/ 0x46, 0xF9, 0xF1, 0x79, 0x5B, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0xB9, 0xAA, 0x73, 0x23, 
/*29C0:*/ 0x0A, 0x28, 0xA5, 0x40, 0xB7, 0xC5, 0x30, 0xDA, 0xCE, 0xA6, 0x1F, 0x24, 0x0D, 0x10, 0xA9, 0x33, 
/*29D0:*/ 0xDD, 0x82, 0x1C, 0x53, 0x8F, 0xD9, 0x61, 0x70, 0x97, 0xE3, 0xB9, 0x2B, 0x8D, 0xF2, 0x13, 0xEA, 
/*29E0:*/ 0x38, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x2C, 0x48, 0xD1, 0x0C, 
/*29F0:*/ 0x4E, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0xE2, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*2A00:*/ 0x16, 0x28, 0xA5, 0x40, 0xB1, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x39, 0x10, 0xA9, 0x33, 
/*2A10:*/ 0xFB, 0x83, 0x1C, 0x53, 0x2C, 0xD1, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0xE4, 0xF2, 0x13, 0xEA, 
/*2A20:*/ 0x68, 0x09, 0xCD, 0x6A, 0x3F, 0x68, 0x90, 0x58, 0xBC, 0x38, 0x50, 0xC7, 0x25, 0x48, 0xD1, 0x0C, 
/*2A30:*/ 0x28, 0xF9, 0xF1, 0x79, 0x1D, 0xAE, 0xF3, 0xB1, 0xCC, 0x55, 0x25, 0x38, 0x35, 0x55, 0x8C, 0xDC, 
/*2A40:*/ 0x10, 0x28, 0xA5, 0x40, 0xB5, 0xC5, 0x30, 0xDA, 0x8B, 0xA6, 0x1F, 0x24, 0x0C, 0x10, 0xA9, 0x33, 
/*2A50:*/ 0x1B, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0x8A, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*2A60:*/ 0x1A, 0x0B, 0xCD, 0x6A, 0xEB, 0x81, 0x6F, 0xA7, 0xBA, 0x39, 0x50, 0xC7, 0x77, 0x48, 0xD1, 0x0C, 
/*2A70:*/ 0x70, 0xF9, 0xF1, 0x79, 0x27, 0xAE, 0xF3, 0xB1, 0xBF, 0x54, 0x25, 0x38, 0xC3, 0xAA, 0x73, 0x23, 
/*2A80:*/ 0x0A, 0x28, 0xA5, 0x40, 0xB7, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x11, 0x10, 0xA9, 0x33, 
/*2A90:*/ 0xCA, 0x82, 0x1C, 0x53, 0x95, 0xD9, 0x61, 0x70, 0xFF, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*2AA0:*/ 0x23, 0x09, 0xCD, 0x6A, 0xB9, 0x97, 0x6F, 0xA7, 0xAE, 0x39, 0x50, 0xC7, 0x70, 0x45, 0xD1, 0x0C, 
/*2AB0:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x35, 0xAE, 0xF3, 0xB1, 0x98, 0x55, 0x25, 0x38, 0x1A, 0x55, 0x8C, 0xDC, 
/*2AC0:*/ 0x25, 0x28, 0xA5, 0x40, 0x83, 0xC5, 0x30, 0xDA, 0xBD, 0xA6, 0x1F, 0x24, 0x15, 0x10, 0xA9, 0x33, 
/*2AD0:*/ 0xC7, 0x82, 0x1C, 0x53, 0xE7, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0xE3, 0xF0, 0x13, 0xEA, 
/*2AE0:*/ 0x00, 0x0B, 0xCD, 0x6A, 0x0D, 0x96, 0x6F, 0xA7, 0xB4, 0x39, 0x50, 0xC7, 0x3B, 0x48, 0xD1, 0x0C, 
/*2AF0:*/ 0x19, 0xF9, 0xF1, 0x79, 0x35, 0xAE, 0xF3, 0xB1, 0xE4, 0x55, 0x25, 0x38, 0xC3, 0xAA, 0x73, 0x23, 
/*2B00:*/ 0x04, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x0D, 0xF0, 0xAD, 0xBA, 
/*2B10:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*2B20:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7DB[] = {
/*30F8:*/ 0xAC, 0x39, 0x50, 0xC7, 0x78, 0x48, 0xD1, 0x0C, 
/*3100:*/ 0x58, 0xF9, 0xF1, 0x79, 0xA8, 0xAE, 0xF3, 0xB1, 0x35, 0x55, 0x25, 0x38, 0xE5, 0xA8, 0x73, 0x23, 
/*3110:*/ 0x71, 0xD7, 0x5A, 0xBF, 0xB5, 0xC5, 0x30, 0xDA, 0xEA, 0xA6, 0x1F, 0x24, 0x14, 0x10, 0xA9, 0x33, 
/*3120:*/ 0x11, 0x7D, 0xE3, 0xAC, 0x90, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0xE4, 0xF2, 0x13, 0xEA, 
/*3130:*/ 0x2C, 0x09, 0xCD, 0x6A, 0x8B, 0x97, 0x6F, 0xA7, 0xB5, 0x39, 0x50, 0xC7, 0x22, 0x48, 0xD1, 0x0C, 
/*3140:*/ 0x48, 0xF8, 0xF1, 0x79, 0x2E, 0xAE, 0xF3, 0xB1, 0xBC, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*3150:*/ 0xD2, 0xD7, 0x5A, 0xBF, 0xB4, 0xC5, 0x30, 0xDA, 0xF3, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*3160:*/ 0xD3, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x88, 0xF2, 0x13, 0xEA, 
/*3170:*/ 0x6B, 0x09, 0xCD, 0x6A, 0x92, 0x97, 0x6F, 0xA7, 0xBD, 0x39, 0x50, 0xC7, 0x3B, 0x48, 0xD1, 0x0C, 
/*3180:*/ 0x25, 0xF9, 0xF1, 0x79, 0x93, 0xAF, 0xF3, 0xB1, 0xF5, 0x55, 0x25, 0x38, 0xEF, 0xA8, 0x73, 0x23, 
/*3190:*/ 0x08, 0x28, 0xA5, 0x40, 0x70, 0x3A, 0xCF, 0x25, 0xFF, 0xA6, 0x1F, 0x24, 0x35, 0x12, 0xA9, 0x33, 
/*31A0:*/ 0xC8, 0x82, 0x1C, 0x53, 0x94, 0xD9, 0x61, 0x70, 0x05, 0xE3, 0xB9, 0x2B, 0x80, 0xF2, 0x13, 0xEA, 
/*31B0:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xC1, 0x68, 0x90, 0x58, 0xA1, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*31C0:*/ 0x5B, 0xF9, 0xF1, 0x79, 0xCE, 0xAF, 0xF3, 0xB1, 0xED, 0x55, 0x25, 0x38, 0xCF, 0xAA, 0x73, 0x23, 
/*31D0:*/ 0x4B, 0x2B, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0x4A, 0xA7, 0x1F, 0x24, 0x19, 0x10, 0xA9, 0x33, 
/*31E0:*/ 0xD5, 0x82, 0x1C, 0x53, 0x92, 0xD9, 0x61, 0x70, 0x3A, 0x1D, 0x46, 0xD4, 0xAD, 0xF2, 0x13, 0xEA, 
/*31F0:*/ 0x39, 0xF6, 0x32, 0x95, 0xE4, 0x97, 0x6F, 0xA7, 0xE0, 0xC4, 0xAF, 0x38, 0x3B, 0x48, 0xD1, 0x0C, 
/*3200:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x43, 0xAE, 0xF3, 0xB1, 0xD2, 0x55, 0x25, 0x38, 0xED, 0xAA, 0x73, 0x23, 
/*3210:*/ 0x4D, 0x28, 0xA5, 0x40, 0xB4, 0xC5, 0x30, 0xDA, 0xE8, 0xA6, 0x1F, 0x24, 0x0D, 0x10, 0xA9, 0x33, 
/*3220:*/ 0xE5, 0x82, 0x1C, 0x53, 0x3F, 0xDF, 0x61, 0x70, 0x95, 0xE3, 0xB9, 0x2B, 0x88, 0xF3, 0x13, 0xEA, 
/*3230:*/ 0x30, 0x09, 0xCD, 0x6A, 0xCF, 0x97, 0x6F, 0xA7, 0xD9, 0x39, 0x50, 0xC7, 0x30, 0x48, 0xD1, 0x0C, 
/*3240:*/ 0x3D, 0xF9, 0xF1, 0x79, 0x74, 0xAE, 0xF3, 0xB1, 0xC7, 0x55, 0x25, 0x38, 0x9C, 0xAA, 0x73, 0x23, 
/*3250:*/ 0x05, 0x28, 0xA5, 0x40, 0x94, 0xC5, 0x30, 0xDA, 0x21, 0xA4, 0x1F, 0x24, 0x42, 0x10, 0xA9, 0x33, 
/*3260:*/ 0xE9, 0x80, 0x1C, 0x53, 0x88, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 
/*3270:*/ 0x0F, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0xA2, 0x39, 0x50, 0xC7, 0xB6, 0xB5, 0x2E, 0xF3, 
/*3280:*/ 0x53, 0xF9, 0xF1, 0x79, 0x34, 0xAE, 0xF3, 0xB1, 0xF2, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 
/*3290:*/ 0x5D, 0x28, 0xA5, 0x40, 0xCC, 0xC5, 0x30, 0xDA, 0xD5, 0xA6, 0x1F, 0x24, 0xAB, 0x11, 0xA9, 0x33, 
/*32A0:*/ 0x39, 0x86, 0x1C, 0x53, 0x6B, 0xDC, 0x61, 0x70, 0xEF, 0xE3, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*32B0:*/ 0x38, 0x09, 0xCD, 0x6A, 0xFD, 0x97, 0x6F, 0xA7, 0x4F, 0x39, 0x50, 0xC7, 0x11, 0x44, 0xD1, 0x0C, 
/*32C0:*/ 0x25, 0xF9, 0xF1, 0x79, 0x39, 0xAE, 0xF3, 0xB1, 0xB7, 0x57, 0x25, 0x38, 0xFF, 0xAA, 0x73, 0x23, 
/*32D0:*/ 0xBE, 0xD7, 0x5A, 0xBF, 0xC9, 0xC5, 0x30, 0xDA, 0xEF, 0xA7, 0x1F, 0x24, 0x0F, 0x10, 0xA9, 0x33, 
/*32E0:*/ 0xE2, 0x82, 0x1C, 0x53, 0xFE, 0xD9, 0x61, 0x70, 0x99, 0xE1, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*32F0:*/ 0x29, 0x09, 0xCD, 0x6A, 0x37, 0x97, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x21, 0x48, 0xD1, 0x0C, 
/*3300:*/ 0x56, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0x24, 0xAA, 0xDA, 0xC7, 0xD6, 0xAA, 0x73, 0x23, 
/*3310:*/ 0x04, 0x28, 0xA5, 0x40, 0xB1, 0xC5, 0x30, 0xDA, 0xC0, 0xA6, 0x1F, 0x24, 0x15, 0x10, 0xA9, 0x33, 
/*3320:*/ 0xDA, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xFE, 0xE3, 0xB9, 0x2B, 0x97, 0xF2, 0x13, 0xEA, 
/*3330:*/ 0x47, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x25, 0x48, 0xD1, 0x0C, 
/*3340:*/ 0xFE, 0x07, 0x0E, 0x86, 0x73, 0xAE, 0xF3, 0xB1, 0xF4, 0x55, 0x25, 0x38, 0xCD, 0xAA, 0x73, 0x23, 
/*3350:*/ 0x06, 0x28, 0xA5, 0x40, 0x9B, 0xC5, 0x30, 0xDA, 0xA7, 0xA6, 0x1F, 0x24, 0x0E, 0x10, 0xA9, 0x33, 
/*3360:*/ 0x98, 0x80, 0x1C, 0x53, 0x24, 0xD8, 0x61, 0x70, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*3370:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7DC[] = {
/*3928:*/ 0xB9, 0x39, 0x50, 0xC7, 0x0C, 0x48, 0xD1, 0x0C, 
/*3930:*/ 0xBB, 0x07, 0x0E, 0x86, 0x32, 0xAE, 0xF3, 0xB1, 0xDF, 0x55, 0x25, 0x38, 0xC7, 0xAA, 0x73, 0x23, 
/*3940:*/ 0xBA, 0xD7, 0x5A, 0xBF, 0x0D, 0xC5, 0x30, 0xDA, 0x77, 0x59, 0xE0, 0xDB, 0x13, 0x10, 0xA9, 0x33, 
/*3950:*/ 0x93, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xE1, 0xE0, 0xB9, 0x2B, 0xF2, 0xF2, 0x13, 0xEA, 
/*3960:*/ 0x1F, 0x09, 0xCD, 0x6A, 0xB5, 0x97, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x68, 0x48, 0xD1, 0x0C, 
/*3970:*/ 0x13, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0x14, 0xA9, 0xDA, 0xC7, 0xD8, 0xAA, 0x73, 0x23, 
/*3980:*/ 0x76, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 0xE5, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*3990:*/ 0xFF, 0x82, 0x1C, 0x53, 0x93, 0xD9, 0x61, 0x70, 0x8B, 0xE3, 0xB9, 0x2B, 0x33, 0xF2, 0x13, 0xEA, 
/*39A0:*/ 0x18, 0x09, 0xCD, 0x6A, 0xDE, 0x97, 0x6F, 0xA7, 0xAD, 0x39, 0x50, 0xC7, 0xA4, 0xB7, 0x2E, 0xF3, 
/*39B0:*/ 0xD5, 0xFA, 0xF1, 0x79, 0x57, 0xAE, 0xF3, 0xB1, 0xCE, 0x54, 0x25, 0x38, 0x83, 0xAB, 0x73, 0x23, 
/*39C0:*/ 0xB0, 0x28, 0xA5, 0x40, 0xAB, 0xC5, 0x30, 0xDA, 0xEC, 0xA6, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*39D0:*/ 0xC2, 0x82, 0x1C, 0x53, 0xC1, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x88, 0xF2, 0x13, 0xEA, 
/*39E0:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xE9, 0x97, 0x6F, 0xA7, 0x7D, 0x39, 0x50, 0xC7, 0x48, 0x48, 0xD1, 0x0C, 
/*39F0:*/ 0x83, 0xF9, 0xF1, 0x79, 0x86, 0xAC, 0xF3, 0xB1, 0xE0, 0xAA, 0xDA, 0xC7, 0xD3, 0xAA, 0x73, 0x23, 
/*3A00:*/ 0x10, 0x28, 0xA5, 0x40, 0xAF, 0xC5, 0x30, 0xDA, 0xB5, 0xA6, 0x1F, 0x24, 0x27, 0x10, 0xA9, 0x33, 
/*3A10:*/ 0x83, 0x7C, 0xE3, 0xAC, 0x9E, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 
/*3A20:*/ 0x30, 0x09, 0xCD, 0x6A, 0xF2, 0x96, 0x6F, 0xA7, 0xAB, 0x39, 0x50, 0xC7, 0xEE, 0x48, 0xD1, 0x0C, 
/*3A30:*/ 0xB9, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0xD6, 0xAA, 0x73, 0x23, 
/*3A40:*/ 0xD1, 0x28, 0xA5, 0x40, 0x12, 0xC4, 0x30, 0xDA, 0x2A, 0xA7, 0x1F, 0x24, 0xDD, 0xEF, 0x56, 0xCC, 
/*3A50:*/ 0x6B, 0x82, 0x1C, 0x53, 0xA5, 0xD9, 0x61, 0x70, 0x1A, 0x1C, 0x46, 0xD4, 0xA4, 0xF2, 0x13, 0xEA, 
/*3A60:*/ 0x0A, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xA2, 0x39, 0x50, 0xC7, 0xD9, 0x48, 0xD1, 0x0C, 
/*3A70:*/ 0x49, 0xF9, 0xF1, 0x79, 0x8F, 0xAE, 0xF3, 0xB1, 0xC0, 0x55, 0x25, 0x38, 0xB4, 0xAA, 0x73, 0x23, 
/*3A80:*/ 0x04, 0x28, 0xA5, 0x40, 0xB9, 0xC5, 0x30, 0xDA, 0xAA, 0xA6, 0x1F, 0x24, 0x0B, 0x10, 0xA9, 0x33, 
/*3A90:*/ 0xC0, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xB5, 0xE3, 0xB9, 0x2B, 0x06, 0xF2, 0x13, 0xEA, 
/*3AA0:*/ 0x07, 0x09, 0xCD, 0x6A, 0xCD, 0x97, 0x6F, 0xA7, 0xA1, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*3AB0:*/ 0x25, 0xF9, 0xF1, 0x79, 0x15, 0xAE, 0xF3, 0xB1, 0xE1, 0x55, 0x25, 0x38, 0xEE, 0xAA, 0x73, 0x23, 
/*3AC0:*/ 0x55, 0x28, 0xA5, 0x40, 0x88, 0xC7, 0x30, 0xDA, 0xEE, 0xA6, 0x1F, 0x24, 0xCF, 0x10, 0xA9, 0x33, 
/*3AD0:*/ 0x9F, 0x88, 0x1C, 0x53, 0x8F, 0xD9, 0x61, 0x70, 0x0D, 0xE2, 0xB9, 0x2B, 0x8A, 0xF2, 0x13, 0xEA, 
/*3AE0:*/ 0x1C, 0x09, 0xCD, 0x6A, 0xA9, 0x95, 0x6F, 0xA7, 0xA0, 0x39, 0x50, 0xC7, 0x2C, 0x48, 0xD1, 0x0C, 
/*3AF0:*/ 0xE6, 0x06, 0x0E, 0x86, 0x68, 0xAE, 0xF3, 0xB1, 0xFB, 0x55, 0x25, 0x38, 0xCB, 0xAA, 0x73, 0x23, 
/*3B00:*/ 0x0F, 0x28, 0xA5, 0x40, 0xE4, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x59, 0x10, 0xA9, 0x33, 
/*3B10:*/ 0xD3, 0x82, 0x1C, 0x53, 0xE9, 0xD9, 0x61, 0x70, 0xE5, 0xE3, 0xB9, 0x2B, 0xD7, 0xF2, 0x13, 0xEA, 
/*3B20:*/ 0x39, 0x09, 0xCD, 0x6A, 0x26, 0x96, 0x6F, 0xA7, 0x83, 0x2F, 0x50, 0xC7, 0x6A, 0x48, 0xD1, 0x0C, 
/*3B30:*/ 0xC3, 0xF9, 0xF1, 0x79, 0x55, 0xAE, 0xF3, 0xB1, 0xAE, 0x54, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*3B40:*/ 0x04, 0x28, 0xA5, 0x40, 0xA9, 0xC5, 0x30, 0xDA, 0xE0, 0xA6, 0x1F, 0x24, 0xD1, 0x11, 0xA9, 0x33, 
/*3B50:*/ 0xDF, 0x82, 0x1C, 0x53, 0x8E, 0xD9, 0x61, 0x70, 0x22, 0xF8, 0xB9, 0x2B, 0x72, 0xF2, 0x13, 0xEA, 
/*3B60:*/ 0x3E, 0x09, 0xCD, 0x6A, 0x30, 0x97, 0x6F, 0xA7, 0xB2, 0x39, 0x50, 0xC7, 0x1F, 0x4A, 0xD1, 0x0C, 
/*3B70:*/ 0x4E, 0xF9, 0xF1, 0x79, 0x81, 0xAF, 0xF3, 0xB1, 0xE1, 0x55, 0x25, 0x38, 0x55, 0xAA, 0x73, 0x23, 
/*3B80:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*3B90:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7DD[] = {
/*4168:*/ 0xCC, 0x39, 0x50, 0xC7, 0xDF, 0x48, 0xD1, 0x0C, 
/*4170:*/ 0x5B, 0xF9, 0xF1, 0x79, 0xF4, 0x51, 0x0C, 0x4E, 0xAA, 0x55, 0x25, 0x38, 0x7E, 0xAA, 0x73, 0x23, 
/*4180:*/ 0x0E, 0xD7, 0x5A, 0xBF, 0x83, 0xC5, 0x30, 0xDA, 0x79, 0xA7, 0x1F, 0x24, 0x03, 0x10, 0xA9, 0x33, 
/*4190:*/ 0xDF, 0x82, 0x1C, 0x53, 0x92, 0xD9, 0x61, 0x70, 0xED, 0x1F, 0x46, 0xD4, 0x85, 0xF2, 0x13, 0xEA, 
/*41A0:*/ 0x82, 0x09, 0xCD, 0x6A, 0xC9, 0x97, 0x6F, 0xA7, 0x8F, 0x39, 0x50, 0xC7, 0x38, 0x48, 0xD1, 0x0C, 
/*41B0:*/ 0x5B, 0xF9, 0xF1, 0x79, 0x2E, 0xAC, 0xF3, 0xB1, 0xA6, 0x55, 0x25, 0x38, 0xFA, 0xAA, 0x73, 0x23, 
/*41C0:*/ 0x37, 0x28, 0xA5, 0x40, 0xAB, 0xC5, 0x30, 0xDA, 0x19, 0x58, 0xE0, 0xDB, 0x1E, 0x10, 0xA9, 0x33, 
/*41D0:*/ 0xDE, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xD4, 0xE3, 0xB9, 0x2B, 0x87, 0xF2, 0x13, 0xEA, 
/*41E0:*/ 0x34, 0x09, 0xCD, 0x6A, 0xFE, 0x97, 0x6F, 0xA7, 0x98, 0x39, 0x50, 0xC7, 0x36, 0x48, 0xD1, 0x0C, 
/*41F0:*/ 0x58, 0xF9, 0xF1, 0x79, 0x38, 0xAE, 0xF3, 0xB1, 0x75, 0x55, 0x25, 0x38, 0x89, 0xAA, 0x73, 0x23, 
/*4200:*/ 0x07, 0x2A, 0xA5, 0x40, 0xC5, 0xC7, 0x30, 0xDA, 0xF5, 0xA6, 0x1F, 0x24, 0x68, 0x12, 0xA9, 0x33, 
/*4210:*/ 0xB0, 0x82, 0x1C, 0x53, 0x88, 0xD9, 0x61, 0x70, 0xD1, 0xE3, 0xB9, 0x2B, 0x89, 0xF2, 0x13, 0xEA, 
/*4220:*/ 0xD3, 0xF7, 0x32, 0x95, 0xD6, 0x97, 0x6F, 0xA7, 0x2E, 0x20, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*4230:*/ 0x57, 0xF9, 0xF1, 0x79, 0x31, 0xAE, 0xF3, 0xB1, 0xF6, 0x55, 0x25, 0x38, 0xD7, 0xAA, 0x73, 0x23, 
/*4240:*/ 0x04, 0x28, 0xA5, 0x40, 0xB2, 0xC5, 0x30, 0xDA, 0x63, 0x5B, 0xE0, 0xDB, 0xFA, 0x10, 0xA9, 0x33, 
/*4250:*/ 0xCB, 0x82, 0x1C, 0x53, 0xC7, 0xD9, 0x61, 0x70, 0x10, 0x1C, 0x46, 0xD4, 0xA1, 0xF3, 0x13, 0xEA, 
/*4260:*/ 0x77, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0x8E, 0x39, 0x50, 0xC7, 0x34, 0x48, 0xD1, 0x0C, 
/*4270:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x03, 0xAF, 0xF3, 0xB1, 0xFE, 0x55, 0x25, 0x38, 0x3C, 0xAA, 0x73, 0x23, 
/*4280:*/ 0x78, 0x2A, 0xA5, 0x40, 0xED, 0xC5, 0x30, 0xDA, 0xE4, 0xA6, 0x1F, 0x24, 0x0A, 0x10, 0xA9, 0x33, 
/*4290:*/ 0x17, 0x83, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xEB, 0xE3, 0xB9, 0x2B, 0x84, 0xF2, 0x13, 0xEA, 
/*42A0:*/ 0x3B, 0x08, 0xCD, 0x6A, 0x85, 0x96, 0x6F, 0xA7, 0xBA, 0x39, 0x50, 0xC7, 0x1A, 0x48, 0xD1, 0x0C, 
/*42B0:*/ 0x5B, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0x81, 0x55, 0x25, 0x38, 0x5F, 0xAB, 0x73, 0x23, 
/*42C0:*/ 0x9D, 0x2A, 0xA5, 0x40, 0xD3, 0xCF, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x32, 0x10, 0xA9, 0x33, 
/*42D0:*/ 0xEA, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xA2, 0xE2, 0xB9, 0x2B, 0xA6, 0xF2, 0x13, 0xEA, 
/*42E0:*/ 0x32, 0x09, 0xCD, 0x6A, 0x8F, 0x97, 0x6F, 0xA7, 0xA1, 0x39, 0x50, 0xC7, 0x46, 0x48, 0xD1, 0x0C, 
/*42F0:*/ 0xE3, 0xF8, 0xF1, 0x79, 0x6F, 0xAE, 0xF3, 0xB1, 0xF6, 0x55, 0x25, 0x38, 0xCC, 0xAA, 0x73, 0x23, 
/*4300:*/ 0x08, 0x28, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0xEB, 0xA6, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*4310:*/ 0xCA, 0x82, 0x1C, 0x53, 0x84, 0xD9, 0x61, 0x70, 0xFB, 0xE3, 0xB9, 0x2B, 0x26, 0xF2, 0x13, 0xEA, 
/*4320:*/ 0x3E, 0x09, 0xCD, 0x6A, 0xDB, 0x97, 0x6F, 0xA7, 0xAB, 0x39, 0x50, 0xC7, 0x0F, 0x48, 0xD1, 0x0C, 
/*4330:*/ 0x9A, 0x06, 0x0E, 0x86, 0x36, 0xAE, 0xF3, 0xB1, 0xF8, 0x55, 0x25, 0x38, 0x86, 0xAA, 0x73, 0x23, 
/*4340:*/ 0x03, 0x28, 0xA5, 0x40, 0xCC, 0xC5, 0x30, 0xDA, 0xF2, 0xA6, 0x1F, 0x24, 0x16, 0x10, 0xA9, 0x33, 
/*4350:*/ 0xEA, 0x82, 0x1C, 0x53, 0xAB, 0xD9, 0x61, 0x70, 0xF3, 0xE3, 0xB9, 0x2B, 0x9E, 0xF2, 0x13, 0xEA, 
/*4360:*/ 0x2E, 0x01, 0xCD, 0x6A, 0xA1, 0x97, 0x6F, 0xA7, 0x8B, 0x39, 0x50, 0xC7, 0x27, 0x48, 0xD1, 0x0C, 
/*4370:*/ 0x52, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xFA, 0x55, 0x25, 0x38, 0x9B, 0xAA, 0x73, 0x23, 
/*4380:*/ 0x05, 0x28, 0xA5, 0x40, 0xAC, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x24, 0x10, 0xA9, 0x33, 
/*4390:*/ 0xDE, 0x82, 0x1C, 0x53, 0x90, 0xD9, 0x61, 0x70, 0xFD, 0xE3, 0xB9, 0x2B, 0x9C, 0xF2, 0x13, 0xEA, 
/*43A0:*/ 0xBB, 0x08, 0xCD, 0x6A, 0x6C, 0x97, 0x6F, 0xA7, 0x8B, 0x39, 0x50, 0xC7, 0x27, 0x48, 0xD1, 0x0C, 
/*43B0:*/ 0x41, 0xF9, 0xF1, 0x79, 0x40, 0x51, 0x0C, 0x4E, 0xFE, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*43C0:*/ 0x0F, 0x28, 0xA5, 0x40, 0x4C, 0xC4, 0x30, 0xDA, 0xF0, 0xA6, 0x1F, 0x24, 0x00, 0x10, 0xA9, 0x33, 
/*43D0:*/ 0x04, 0x7D, 0xE3, 0xAC, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*43E0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B7DE[] = {
/*4A08:*/ 0xA9, 0x39, 0x50, 0xC7, 0x53, 0x48, 0xD1, 0x0C, 
/*4A10:*/ 0x66, 0xF9, 0xF1, 0x79, 0x68, 0xAE, 0xF3, 0xB1, 0x98, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*4A20:*/ 0x03, 0x28, 0xA5, 0x40, 0xEA, 0xC5, 0x30, 0xDA, 0xD5, 0xA6, 0x1F, 0x24, 0x08, 0x10, 0xA9, 0x33, 
/*4A30:*/ 0x32, 0x81, 0x1C, 0x53, 0x84, 0xD9, 0x61, 0x70, 0xEA, 0xE3, 0xB9, 0x2B, 0x93, 0xF2, 0x13, 0xEA, 
/*4A40:*/ 0x05, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xEC, 0x39, 0x50, 0xC7, 0x27, 0x48, 0xD1, 0x0C, 
/*4A50:*/ 0x76, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xE8, 0x55, 0x25, 0x38, 0xA3, 0xAB, 0x73, 0x23, 
/*4A60:*/ 0x09, 0x28, 0xA5, 0x40, 0x0C, 0xC4, 0x30, 0xDA, 0xEB, 0xA4, 0x1F, 0x24, 0x37, 0x12, 0xA9, 0x33, 
/*4A70:*/ 0xC7, 0x82, 0x1C, 0x53, 0xA6, 0xD9, 0x61, 0x70, 0x07, 0xE3, 0xB9, 0x2B, 0x9E, 0xF2, 0x13, 0xEA, 
/*4A80:*/ 0x25, 0x09, 0xCD, 0x6A, 0x9B, 0x69, 0x90, 0x58, 0xDF, 0x39, 0x50, 0xC7, 0xC4, 0xB7, 0x2E, 0xF3, 
/*4A90:*/ 0x23, 0xF9, 0xF1, 0x79, 0x79, 0xAE, 0xF3, 0xB1, 0xD7, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*4AA0:*/ 0x73, 0x28, 0xA5, 0x40, 0xB4, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*4AB0:*/ 0xF8, 0x82, 0x1C, 0x53, 0x8A, 0xD9, 0x61, 0x70, 0x27, 0xE3, 0xB9, 0x2B, 0x04, 0xF2, 0x13, 0xEA, 
/*4AC0:*/ 0x4F, 0x0B, 0xCD, 0x6A, 0x80, 0x97, 0x6F, 0xA7, 0x80, 0x39, 0x50, 0xC7, 0x36, 0x48, 0xD1, 0x0C, 
/*4AD0:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x6D, 0xAE, 0xF3, 0xB1, 0x4C, 0x55, 0x25, 0x38, 0xDE, 0xAA, 0x73, 0x23, 
/*4AE0:*/ 0x28, 0x28, 0xA5, 0x40, 0xBA, 0xC5, 0x30, 0xDA, 0x91, 0xA7, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*4AF0:*/ 0xE6, 0x83, 0x1C, 0x53, 0x48, 0x26, 0x9E, 0x8F, 0x46, 0xE3, 0xB9, 0x2B, 0x87, 0xF2, 0x13, 0xEA, 
/*4B00:*/ 0xD6, 0xF6, 0x32, 0x95, 0xC0, 0x97, 0x6F, 0xA7, 0xF0, 0x38, 0x50, 0xC7, 0x20, 0x48, 0xD1, 0x0C, 
/*4B10:*/ 0xED, 0xF8, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xF1, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*4B20:*/ 0x0B, 0x28, 0xA5, 0x40, 0x89, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x00, 0x10, 0xA9, 0x33, 
/*4B30:*/ 0xC8, 0x82, 0x1C, 0x53, 0x9C, 0xD9, 0x61, 0x70, 0xDC, 0xE3, 0xB9, 0x2B, 0x5E, 0x0D, 0xEC, 0x15, 
/*4B40:*/ 0xFB, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0x8A, 0x39, 0x50, 0xC7, 0x06, 0x48, 0xD1, 0x0C, 
/*4B50:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x2F, 0x44, 0x0C, 0x4E, 0x2A, 0xAA, 0xDA, 0xC7, 0x7B, 0xAB, 0x73, 0x23, 
/*4B60:*/ 0x15, 0x28, 0xA5, 0x40, 0x80, 0xC4, 0x30, 0xDA, 0xF3, 0xA4, 0x1F, 0x24, 0x6A, 0x10, 0xA9, 0x33, 
/*4B70:*/ 0x81, 0x82, 0x1C, 0x53, 0x84, 0xD9, 0x61, 0x70, 0x29, 0x1C, 0x46, 0xD4, 0x89, 0xF2, 0x13, 0xEA, 
/*4B80:*/ 0x3F, 0x09, 0xCD, 0x6A, 0x8C, 0x97, 0x6F, 0xA7, 0xAE, 0x39, 0x50, 0xC7, 0x34, 0x48, 0xD1, 0x0C, 
/*4B90:*/ 0x57, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xE8, 0x55, 0x25, 0x38, 0xC1, 0xAA, 0x73, 0x23, 
/*4BA0:*/ 0x46, 0x28, 0xA5, 0x40, 0xAA, 0xC5, 0x30, 0xDA, 0xE7, 0xA6, 0x1F, 0x24, 0x1C, 0x10, 0xA9, 0x33, 
/*4BB0:*/ 0xB8, 0x82, 0x1C, 0x53, 0x8F, 0xD9, 0x61, 0x70, 0x74, 0xE0, 0xB9, 0x2B, 0x83, 0xF2, 0x13, 0xEA, 
/*4BC0:*/ 0x2A, 0x09, 0xCD, 0x6A, 0x4C, 0x96, 0x6F, 0xA7, 0xA9, 0x39, 0x50, 0xC7, 0xB1, 0x48, 0xD1, 0x0C, 
/*4BD0:*/ 0x58, 0xF9, 0xF1, 0x79, 0x1C, 0xAE, 0xF3, 0xB1, 0xFB, 0x55, 0x25, 0x38, 0x56, 0xAA, 0x73, 0x23, 
/*4BE0:*/ 0x0F, 0x28, 0xA5, 0x40, 0xB4, 0xC4, 0x30, 0xDA, 0xEE, 0xA6, 0x1F, 0x24, 0x1F, 0x10, 0xA9, 0x33, 
/*4BF0:*/ 0xDD, 0x82, 0x1C, 0x53, 0xDA, 0xD9, 0x61, 0x70, 0xF0, 0xE3, 0xB9, 0x2B, 0x87, 0xF2, 0x13, 0xEA, 
/*4C00:*/ 0xFF, 0xF6, 0x32, 0x95, 0x36, 0x96, 0x6F, 0xA7, 0xAF, 0x39, 0x50, 0xC7, 0x3F, 0x48, 0xD1, 0x0C, 
/*4C10:*/ 0x36, 0xF9, 0xF1, 0x79, 0x11, 0xAF, 0xF3, 0xB1, 0x33, 0x55, 0x25, 0x38, 0xBC, 0xAA, 0x73, 0x23, 
/*4C20:*/ 0x04, 0x28, 0xA5, 0x40, 0x9A, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x01, 0x10, 0xA9, 0x33, 
/*4C30:*/ 0xBF, 0x82, 0x1C, 0x53, 0x83, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0xFC, 0xF2, 0x13, 0xEA, 
/*4C40:*/ 0x32, 0x09, 0xCD, 0x6A, 0xD8, 0x97, 0x6F, 0xA7, 0xCC, 0x3B, 0x50, 0xC7, 0x2E, 0x48, 0xD1, 0x0C, 
/*4C50:*/ 0x4E, 0xF9, 0xF1, 0x79, 0x35, 0xAE, 0xF3, 0xB1, 0xFA, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*4C60:*/ 0x04, 0x28, 0xA5, 0x40, 0xAF, 0xC5, 0x30, 0xDA, 0xCB, 0xA6, 0x1F, 0x24, 0x08, 0x10, 0xA9, 0x33, 
/*4C70:*/ 0xC4, 0x82, 0x1C, 0x53, 0x1F, 0xD9, 0x61, 0x70, 0xC1, 0xE3, 0xB9, 0x2B, 0xBB, 0xF2, 0x13, 0xEA, 
/*4C80:*/ 0x3C, 0x09, 0xCD, 0x6A, 0xD4, 0x97, 0x6F, 0xA7, 0xB3, 0x39, 0x50, 0xC7, 0x09, 0x48, 0xD1, 0x0C, 
/*4C90:*/ 0x5D, 0xF9, 0xF1, 0x79, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*4CA0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B7DF[] = {
/*5308:*/ 0xB9, 0x39, 0x50, 0xC7, 0x42, 0xB7, 0x2E, 0xF3, 
/*5310:*/ 0x5A, 0xF9, 0xF1, 0x79, 0x15, 0xAE, 0xF3, 0xB1, 0xF9, 0x55, 0x25, 0x38, 0x5B, 0xAB, 0x73, 0x23, 
/*5320:*/ 0x43, 0x28, 0xA5, 0x40, 0xB4, 0xC5, 0x30, 0xDA, 0x94, 0xA6, 0x1F, 0x24, 0x39, 0x12, 0xA9, 0x33, 
/*5330:*/ 0xC2, 0x82, 0x1C, 0x53, 0x8E, 0xD9, 0x61, 0x70, 0xA2, 0xE3, 0xB9, 0x2B, 0xEB, 0xF2, 0x13, 0xEA, 
/*5340:*/ 0x55, 0x09, 0xCD, 0x6A, 0xBE, 0x97, 0x6F, 0xA7, 0xB7, 0x39, 0x50, 0xC7, 0x68, 0x48, 0xD1, 0x0C, 
/*5350:*/ 0xD9, 0xF9, 0xF1, 0x79, 0x5D, 0xAF, 0xF3, 0xB1, 0x2F, 0x55, 0x25, 0x38, 0x9A, 0xAA, 0x73, 0x23, 
/*5360:*/ 0xD8, 0xD7, 0x5A, 0xBF, 0xBB, 0xC5, 0x30, 0xDA, 0xE9, 0xA6, 0x1F, 0x24, 0x1A, 0x12, 0xA9, 0x33, 
/*5370:*/ 0xC9, 0x82, 0x1C, 0x53, 0x82, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x47, 0xF2, 0x13, 0xEA, 
/*5380:*/ 0xA5, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xF9, 0xC6, 0xAF, 0x38, 0x23, 0x48, 0xD1, 0x0C, 
/*5390:*/ 0x5B, 0xF9, 0xF1, 0x79, 0x3B, 0xAE, 0xF3, 0xB1, 0xF6, 0x55, 0x25, 0x38, 0xEA, 0xAA, 0x73, 0x23, 
/*53A0:*/ 0x19, 0x28, 0xA5, 0x40, 0xF1, 0xC4, 0x30, 0xDA, 0xB9, 0xA6, 0x1F, 0x24, 0x0F, 0x10, 0xA9, 0x33, 
/*53B0:*/ 0x9B, 0x81, 0x1C, 0x53, 0xE7, 0xD9, 0x61, 0x70, 0x89, 0xE3, 0xB9, 0x2B, 0x79, 0xF2, 0x13, 0xEA, 
/*53C0:*/ 0x03, 0x09, 0xCD, 0x6A, 0xD9, 0x97, 0x6F, 0xA7, 0xB1, 0x39, 0x50, 0xC7, 0x74, 0x48, 0xD1, 0x0C, 
/*53D0:*/ 0x4B, 0xF8, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0xF1, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*53E0:*/ 0x73, 0x29, 0xA5, 0x40, 0xBB, 0xC5, 0x30, 0xDA, 0x9C, 0xA6, 0x1F, 0x24, 0x57, 0x10, 0xA9, 0x33, 
/*53F0:*/ 0xF2, 0x82, 0x1C, 0x53, 0x94, 0xD9, 0x61, 0x70, 0x50, 0xE0, 0xB9, 0x2B, 0x15, 0xF2, 0x13, 0xEA, 
/*5400:*/ 0x45, 0x09, 0xCD, 0x6A, 0x8E, 0x97, 0x6F, 0xA7, 0xAD, 0x39, 0x50, 0xC7, 0x3C, 0x48, 0xD1, 0x0C, 
/*5410:*/ 0x4C, 0xF9, 0xF1, 0x79, 0x3A, 0xAE, 0xF3, 0xB1, 0x9D, 0x55, 0x25, 0x38, 0xD9, 0xAA, 0x73, 0x23, 
/*5420:*/ 0x20, 0x28, 0xA5, 0x40, 0xB8, 0xC4, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0xCB, 0x12, 0xA9, 0x33, 
/*5430:*/ 0xF8, 0x82, 0x1C, 0x53, 0x5E, 0x26, 0x9E, 0x8F, 0xFD, 0xE3, 0xB9, 0x2B, 0xF2, 0xF0, 0x13, 0xEA, 
/*5440:*/ 0x69, 0x09, 0xCD, 0x6A, 0x0D, 0x6A, 0x90, 0x58, 0xA9, 0x39, 0x50, 0xC7, 0x3B, 0x48, 0xD1, 0x0C, 
/*5450:*/ 0x4C, 0xF9, 0xF1, 0x79, 0x2C, 0xAE, 0xF3, 0xB1, 0xB3, 0x55, 0x25, 0x38, 0xD8, 0xAA, 0x73, 0x23, 
/*5460:*/ 0x23, 0x28, 0xA5, 0x40, 0xB5, 0xC5, 0x30, 0xDA, 0xBF, 0xA6, 0x1F, 0x24, 0x0F, 0x10, 0xA9, 0x33, 
/*5470:*/ 0xC2, 0x82, 0x1C, 0x53, 0x5E, 0xD8, 0x61, 0x70, 0x67, 0x1C, 0x46, 0xD4, 0xB3, 0xF2, 0x13, 0xEA, 
/*5480:*/ 0x32, 0x08, 0xCD, 0x6A, 0xCF, 0x97, 0x6F, 0xA7, 0xAC, 0x39, 0x50, 0xC7, 0x2D, 0x48, 0xD1, 0x0C, 
/*5490:*/ 0x5D, 0xF9, 0xF1, 0x79, 0x4D, 0xAC, 0xF3, 0xB1, 0x88, 0x54, 0x25, 0x38, 0x8E, 0xAA, 0x73, 0x23, 
/*54A0:*/ 0x10, 0x28, 0xA5, 0x40, 0x30, 0xC5, 0x30, 0xDA, 0xCC, 0xA6, 0x1F, 0x24, 0x19, 0x10, 0xA9, 0x33, 
/*54B0:*/ 0x93, 0x82, 0x1C, 0x53, 0xDE, 0xDA, 0x61, 0x70, 0x2A, 0xE1, 0xB9, 0x2B, 0x8B, 0xF2, 0x13, 0xEA, 
/*54C0:*/ 0x3C, 0x09, 0xCD, 0x6A, 0xEF, 0x97, 0x6F, 0xA7, 0xA3, 0x39, 0x50, 0xC7, 0x6E, 0x48, 0xD1, 0x0C, 
/*54D0:*/ 0x57, 0xF9, 0xF1, 0x79, 0x09, 0xAE, 0xF3, 0xB1, 0xE5, 0x55, 0x25, 0x38, 0x85, 0xAA, 0x73, 0x23, 
/*54E0:*/ 0x10, 0x28, 0xA5, 0x40, 0xC9, 0xC5, 0x30, 0xDA, 0xDB, 0xA6, 0x1F, 0x24, 0x4E, 0x10, 0xA9, 0x33, 
/*54F0:*/ 0xC2, 0x82, 0x1C, 0x53, 0x19, 0xD9, 0x61, 0x70, 0x0F, 0xE3, 0xB9, 0x2B, 0xBC, 0xF2, 0x13, 0xEA, 
/*5500:*/ 0x0B, 0x09, 0xCD, 0x6A, 0x9E, 0x96, 0x6F, 0xA7, 0xA7, 0x39, 0x50, 0xC7, 0x27, 0x48, 0xD1, 0x0C, 
/*5510:*/ 0x4C, 0xF9, 0xF1, 0x79, 0x24, 0xAE, 0xF3, 0xB1, 0xA7, 0x55, 0x25, 0x38, 0x6C, 0xAA, 0x73, 0x23, 
/*5520:*/ 0x16, 0x28, 0xA5, 0x40, 0x22, 0xC4, 0x30, 0xDA, 0xF3, 0xA6, 0x1F, 0x24, 0x02, 0x10, 0xA9, 0x33, 
/*5530:*/ 0xCA, 0x82, 0x1C, 0x53, 0x8A, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x81, 0xF2, 0x13, 0xEA, 
/*5540:*/ 0x30, 0x09, 0xCD, 0x6A, 0x07, 0x93, 0x6F, 0xA7, 0x24, 0x39, 0x50, 0xC7, 0x3A, 0x48, 0xD1, 0x0C, 
/*5550:*/ 0xBF, 0xF9, 0xF1, 0x79, 0xE3, 0x51, 0x0C, 0x4E, 0xE9, 0x55, 0x25, 0x38, 0xAA, 0xAA, 0x73, 0x23, 
/*5560:*/ 0x5F, 0x28, 0xA5, 0x40, 0xEE, 0xC5, 0x30, 0xDA, 0xE6, 0xA6, 0x1F, 0x24, 0x17, 0x10, 0xA9, 0x33, 
/*5570:*/ 0xC6, 0x82, 0x1C, 0x53, 0x94, 0xD9, 0x61, 0x70, 0xFC, 0xE3, 0xB9, 0x2B, 0x7F, 0x0D, 0xEC, 0x15, 
/*5580:*/ 0x3F, 0x09, 0xCD, 0x6A, 0xD2, 0x97, 0x6F, 0xA7, 0xA9, 0x39, 0x50, 0xC7, 0x2F, 0x48, 0xD1, 0x0C, 
/*5590:*/ 0x0E, 0xF9, 0xF1, 0x79, 0x06, 0xAE, 0xF3, 0xB1, 0xE9, 0x55, 0x25, 0x38, 0xBD, 0x54, 0x8C, 0xDC, 
/*55A0:*/ 0xA3, 0x28, 0xA5, 0x40, 0xC8, 0xC5, 0x30, 0xDA, 0xEB, 0x58, 0xE0, 0xDB, 0xAA, 0xEF, 0x56, 0xCC, 
/*55B0:*/ 0xD8, 0x82, 0x1C, 0x53, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*55C0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

void* B7Array[] = {
	B7D0,
	B7D1,
	B7D2,
	B7D3,
	B7D4,
	B7D5,
	B7D6,
	B7D7,
	B7D8,
	B7D9,
	B7DA,
	B7DB,
	B7DC,
	B7DD,
	B7DE,
	B7DF
};

BYTE B7StackArray[] = {
0xA4, 0x39, 0x50, 0xC7, 0x2A, 0x48, 0xD1, 0x0C, 0x5E, 0xF9, 0xF1, 0x79, 0x3E, 0xAE, 0xF3, 0xB1,
0xFD, 0x55, 0x25, 0x38, 0xDD, 0xAA, 0x73, 0x23, 0x00, 0x28, 0xA5, 0x40, 0xBE, 0xC5, 0x30, 0xDA,
0xE3, 0xA6, 0x1F, 0x24, 0x07, 0x10, 0xA9, 0x33, 0xCF, 0x82, 0x1C, 0x53, 0x87, 0xD9, 0x61, 0x70,
0xF8, 0xE3, 0xB9, 0x2B, 0x8E, 0xF2, 0x13, 0xEA, 0x3B, 0x09, 0xCD, 0x6A, 0xDD, 0x97, 0x6F, 0xA7
};


/////////////////////////
// block 8
/////////////////////////

BYTE B8D0[] = {/*00CEC8:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 
/*00CED0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*00CEE0:*/ 0x01, 0x01, 0x05, 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 
/*00CEF0:*/ 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*00CF00:*/ 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 
/*00CF10:*/ 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*00CF20:*/ 0x01, 0x05, 0x01, 0x01, 0x04, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 
/*00CF30:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x05, 
/*00CF40:*/ 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*00CF50:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00CF60:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00CF70:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D1[] = {
/*00D7F8:*/ 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 
/*00D800:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*00D810:*/ 0x05, 0x05, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x05, 
/*00D820:*/ 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00D830:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00D840:*/ 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 
/*00D850:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00D860:*/ 0x04, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*00D870:*/ 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 0x04, 
/*00D880:*/ 0x04, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00D890:*/ 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*00D8A0:*/ 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x01, 0x01, 0x05, 0x01, 
/*00D8B0:*/ 0x01, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00D8C0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D2[] = {
/*00E128:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 
/*00E130:*/ 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 
/*00E140:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00E150:*/ 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00E160:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 
/*00E170:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x05, 
/*00E180:*/ 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x04, 0x04, 
/*00E190:*/ 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00E1A0:*/ 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*00E1B0:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x05, 0x01, 0x04, 0x04, 0x01, 0x01, 
/*00E1C0:*/ 0x01, 0x01, 0x04, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00E1D0:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00E1E0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D3[] = {
/*00E9C8:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 
/*00E9D0:*/ 0x01, 0x04, 0x04, 0x04, 0x04, 0x01, 0x05, 0x01, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 
/*00E9E0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*00E9F0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00EA00:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 
/*00EA10:*/ 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00EA20:*/ 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 
/*00EA30:*/ 0x04, 0x05, 0x04, 0x01, 0x04, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00EA40:*/ 0x04, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00EA50:*/ 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00EA60:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00EA70:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

BYTE B8D4[] = {
/*00F268:*/ 0x01, 0x01, 0x04, 0x04, 0x05, 0x01, 0x01, 0x01, 
/*00F270:*/ 0x04, 0x04, 0x01, 0x04, 0x01, 0x05, 0x01, 0x04, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00F280:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00F290:*/ 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x05, 0x04, 0x01, 0x01, 0x01, 
/*00F2A0:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00F2B0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00F2C0:*/ 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x04, 
/*00F2D0:*/ 0x04, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00F2E0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x05, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 0x01, 
/*00F2F0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00F300:*/ 0x04, 0x01, 0x01, 0x05, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00F310:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00F320:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D5[] = {
/*00FAA8:*/ 0x05, 0x04, 0x01, 0x01, 0x04, 0x04, 0x04, 0x01, 
/*00FAB0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FAC0:*/ 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FAD0:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 
/*00FAE0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*00FAF0:*/ 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x05, 0x01, 0x04, 0x01, 
/*00FB00:*/ 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 
/*00FB10:*/ 0x01, 0x05, 0x04, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 
/*00FB20:*/ 0x05, 0x01, 0x01, 0x05, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 
/*00FB30:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00FB40:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00FB50:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D6[] = {
/*00FDC8:*/ 0x04, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 
/*00FDD0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FDE0:*/ 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FDF0:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x01, 0x04, 0x04, 
/*00FE00:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00FE10:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00FE20:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*00FE30:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 
/*00FE40:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FE50:*/ 0x01, 0x01, 0x01, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00FE60:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D7[] = {
/*00FE70:*/ 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*00FE80:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FE90:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*00FEA0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FEB0:*/ 0x01, 0x04, 0x01, 0x05, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x04, 0x05, 0x05, 0x05, 0x05, 
/*00FEC0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x04, 0x05, 0x04, 0x05, 0x01, 
/*00FED0:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FEE0:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x04, 
/*00FEF0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x05, 
/*00FF00:*/ 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x05, 0x05, 0x01, 0x01, 0x04, 
/*00FF10:*/ 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0xF0, 0xAD, 0xBA, 
/*00FF20:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D8[] = {
/*00FF38:*/ 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*00FF40:*/ 0x04, 0x05, 0x04, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x05, 0x01, 0x01, 
/*00FF50:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x05, 0x01, 0x01, 0x04, 0x04, 0x05, 0x01, 
/*00FF60:*/ 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 
/*00FF70:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FF80:*/ 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 
/*00FF90:*/ 0x04, 0x01, 0x04, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*00FFA0:*/ 0x05, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*00FFB0:*/ 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 
/*00FFC0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x0D, 0xF0, 0xAD, 0xBA, 
/*00FFD0:*/ 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 
/*00FFE0:*/ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8D9[] = {
/*1D30:*/ 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*1D40:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 0x04, 0x01, 0x01, 0x05, 0x05, 0x01, 0x04, 0x01, 0x01, 
/*1D50:*/ 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 
/*1D60:*/ 0x04, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 
/*1D70:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 
/*1D80:*/ 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*1D90:*/ 0x01, 0x01, 0x05, 0x04, 0x05, 0x05, 0x05, 0x04, 0x04, 0x01, 0x04, 0x05, 0x01, 0x04, 0x04, 0x04, 
/*1DA0:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*1DB0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*1DC0:*/ 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*1DD0:*/ 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x04, 0x01, 0x01, 
/*1DE0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 
/*1DF0:*/ 0x01, 0x01, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*1E00:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DA[] = {
/*2750:*/ 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 
/*2760:*/ 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x05, 0x01, 0x01, 0x05, 0x01, 0x05, 0x04, 0x01, 0x05, 
/*2770:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*2780:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 
/*2790:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*27A0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*27B0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*27C0:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*27D0:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x01, 0x05, 0x05, 
/*27E0:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*27F0:*/ 0x01, 0x05, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 
/*2800:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*2810:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DB[] = {
/*3040:*/ 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*3050:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*3060:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x04, 0x04, 
/*3070:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 
/*3080:*/ 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 
/*3090:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 
/*30A0:*/ 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 
/*30B0:*/ 0x05, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 
/*30C0:*/ 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 
/*30D0:*/ 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x0D, 0xF0, 0xAD, 0xBA, 
/*30E0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DC[] = {
/*3870:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*3880:*/ 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*3890:*/ 0x01, 0x01, 0x04, 0x01, 0x05, 0x05, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*38A0:*/ 0x05, 0x01, 0x04, 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x05, 
/*38B0:*/ 0x01, 0x04, 0x05, 0x04, 0x04, 0x01, 0x05, 0x05, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 
/*38C0:*/ 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x01, 
/*38D0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x04, 0x01, 0x05, 0x04, 0x01, 0x05, 
/*38E0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*38F0:*/ 0x04, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x01, 0x04, 0x05, 0x01, 0x04, 
/*3900:*/ 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*3910:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DD[] = {
/*40B0:*/ 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 
/*40C0:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*40D0:*/ 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 
/*40E0:*/ 0x04, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x05, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*40F0:*/ 0x01, 0x01, 0x04, 0x05, 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x05, 
/*4100:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*4110:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 
/*4120:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 
/*4130:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 
/*4140:*/ 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*4150:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DE[] = {
/*4940:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*4950:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 
/*4960:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 
/*4970:*/ 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x04, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 
/*4980:*/ 0x05, 0x01, 0x05, 0x04, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 
/*4990:*/ 0x01, 0x01, 0x04, 0x04, 0x01, 0x05, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
/*49A0:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x05, 
/*49B0:*/ 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*49C0:*/ 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*49D0:*/ 0x05, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 
/*49E0:*/ 0x01, 0x01, 0x01, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*49F0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

BYTE B8DF[] = {
/*5240:*/ 0x01, 0x05, 0x04, 0x01, 0x04, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
/*5250:*/ 0x01, 0x01, 0x05, 0x04, 0x05, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x05, 0x05, 0x01, 
/*5260:*/ 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x04, 0x01, 0x04, 
/*5270:*/ 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 
/*5280:*/ 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 0x05, 0x01, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x04, 
/*5290:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01, 0x05, 0x01, 
/*52A0:*/ 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x01, 
/*52B0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x05, 
/*52C0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 
/*52D0:*/ 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x04, 0x01, 
/*52E0:*/ 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x04, 0x01, 0x01, 0xBA, 0x0D, 0xF0, 0xAD, 0xBA, 
/*52F0:*/ 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0xAB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};


void* B8Array[] = {
	B8D0,
	B8D1,
	B8D2,
	B8D3,
	B8D4,
	B8D5,
	B8D6,
	B8D7,
	B8D8,
	B8D9,
	B8DA,
	B8DB,
	B8DC,
	B8DD,
	B8DE,
	B8DF
};