///////////////////////////////////////////
//
// nanomites emulator for armadillo 4.20
// written by AndreaGeddon
//
///////////////////////////////////////////
#include <windows.h>
#include "core.h"

#define PROCESS_NAME	"emul.exe"

typedef struct _THREADS {
	DWORD	ThreadId;
	HANDLE	ThreadHandle;
} THREADS;

int WINAPI WinMain(HINSTANCE Instance, HINSTANCE PreInst, LPSTR CmdLine, int CmdShow)
{
	STARTUPINFO Si;
	PROCESS_INFORMATION Pi;
	DEBUG_EVENT Event;
	BOOL FirstBreak = TRUE, DebugLoop = TRUE;
	DWORD Continue;
	CONTEXT Context;
	THREADS	Threads[32];		//warning
	int j, NumberOfThreads = 0;
	////////////////////
	//block 1 vars
	////////////////////
	DWORD ebp1178h;
	DWORD ebp1174h;
	DWORD ebp1170h;
	DWORD ebp116Ch;
	DWORD ebp1168h;
	DWORD ebp1164h;
	DWORD ebp1160h;
	DWORD ebp115Ch;
	DWORD ebp1158h;
	DWORD ebp1154h;
	DWORD ebp1150h;
	DWORD ebp114Ch;
	DWORD ebp1148h;
	DWORD ebp1144h;
	DWORD ebp1140h;
	DWORD ebp113Ch;
	DWORD ebp1138h;
	/////////////////////
	// block 2 vars
	/////////////////////
	DWORD ebp146Ch;
	DWORD ebp1198h;		//first param in block 2
	/////////////////////
	// block 3
	/////////////////////
	DWORD ebp119Ch, ebp13B0h;
	/////////////////////
	// block 4
	/////////////////////
	DWORD ebp1474h, ebp1470h, ebp1190h;
	/////////////////////
	// block 5
	/////////////////////
	DWORD ebp147Ch, ebp13BCh, ebp1480h, ebp1484h, ebp1478h, ebp13A8h, ebp1488h;
	/////////////////////
	// block 7
	////////////////////

	//
	// create debugged process
	//
	memset(&Si, NULL, sizeof(STARTUPINFO));
	memset(&Pi, NULL, sizeof(PROCESS_INFORMATION));

	CreateProcess(PROCESS_NAME, NULL, NULL, NULL, TRUE, DEBUG_PROCESS, NULL, NULL,
					&Si, &Pi);

	Threads[NumberOfThreads].ThreadHandle = Pi.hThread;
	Threads[NumberOfThreads].ThreadId = Pi.dwThreadId;
	NumberOfThreads++;

	//
	// debug cycle for debugged process
	//
	while(DebugLoop)
	{
		WaitForDebugEvent(&Event, INFINITE);

		switch(Event.dwDebugEventCode)
		{
			case EXCEPTION_DEBUG_EVENT:
				switch(Event.u.Exception.ExceptionRecord.ExceptionCode)
				{
					case EXCEPTION_BREAKPOINT:
						if(FirstBreak)
						{
							//
							// this is first breakpoint in the process, do nothing
							//
							FirstBreak = FALSE;
							Continue = DBG_CONTINUE;
						}
						else
						{
							//
							// fixup context.eip
							//
///////////////////////////////////////////
// asm emulation routine
///////////////////////////////////////////
							////////////////////////////
							// block 1
							////////////////////////////
							__asm
							{
				                 mov     dword ptr [ebp1178h], 10h
				                 mov     eax, ds:B1V1
				                 xor     eax, ds:B1V2
				                 xor     eax, ds:B1V3
				                 mov     [ebp1174h], eax
				                 mov     ecx, ds:B1V4
				                 xor     ecx, ds:B1V5
				                 xor     ecx, ds:B1V6
				                 mov     [ebp1170h], ecx
				                 mov     edx, ds:B1V7
				                 xor     edx, ds:B1V8
				                 xor     edx, ds:B1V9
				                 mov     [ebp116Ch], edx
				                 mov     eax, ds:B1V10
				                 xor     eax, ds:B1V11
				                 xor     eax, ds:B1V12
				                 mov     [ebp1168h], eax
				                 mov     ecx, ds:B1V13
				                 xor     ecx, ds:B1V14
				                 xor     ecx, ds:B1V15
				                 mov     [ebp1164h], ecx
				                 mov     edx, ds:B1V16
				                 xor     edx, ds:B1V17
				                 xor     edx, ds:B1V18
				                 mov     [ebp1160h], edx
				                 mov     eax, ds:B1V1
				                 xor     eax, ds:B1V4
				                 xor     eax, ds:B1V7
				                 xor     eax, ds:B1V19
				                 mov     [ebp115Ch], eax
				                 mov     ecx, ds:B1V2
				                 xor     ecx, ds:B1V5
				                 xor     ecx, ds:B1V8
				                 xor     ecx, ds:B1V16
				                 mov     [ebp1158h], ecx
				                 mov     edx, ds:B1V10
				                 xor     edx, ds:B1V13
				                 xor     edx, ds:B1V16
				                 xor     edx, ds:B1V17
				                 mov     [ebp1154h], edx
				                 mov     eax, ds:B1V11
				                 xor     eax, ds:B1V14
				                 xor     eax, ds:B1V17
				                 xor     eax, ds:B1V1
				                 mov     [ebp1150h], eax
				                 mov     ecx, ds:B1V1
				                 xor     ecx, ds:B1V13
				                 xor     ecx, ds:B1V4
				                 mov     [ebp114Ch], ecx
           						 mov     edx, ds:B1V2
				                 xor     edx, ds:B1V11
				                 xor     edx, ds:B1V7
				                 mov     [ebp1148h], edx
				                 mov     eax, ds:B1V4
				                 xor     eax, ds:B1V10
				                 xor     eax, ds:B1V16
				                 mov     [ebp1144h], eax
				                 mov     ecx, ds:B1V5
				                 xor     ecx, ds:B1V8
				                 xor     ecx, ds:B1V10
				                 mov     [ebp1140h], ecx
				                 mov     edx, ds:B1V1
				                 xor     edx, ds:B1V5
				                 xor     edx, ds:B1V10
				                 xor     edx, ds:B1V13
				                 mov     [ebp113Ch], edx
				                 mov     eax, ds:B1V2
				                 xor     eax, ds:B1V7
				                 xor     eax, ds:B1V11
				                 xor     eax, ds:B1V14
				                 mov     [ebp1138h], eax
							}
							////////////////////////////
							// end block 1
							////////////////////////////
							//
							// find thread handle and fixup
							//
							for(j = 0; j < NumberOfThreads; j++)
							{
								if(Event.dwThreadId == Threads[j].ThreadId)
								{
									break;
								}
							}
							memset(&Context, NULL, sizeof(CONTEXT));
							Context.ContextFlags = CONTEXT_FULL | CONTEXT_DEBUG_REGISTERS;
							GetThreadContext(Threads[j].ThreadHandle, &Context);
							//initialization
							ebp13B0h = Context.Eip;

							////////////////////////////
							// block 2
							////////////////////////////
							ebp146Ch = 0;
							ebp1198h = Block2Func1(&(Context.Eip), 4, 0xffffffff);

							////////////////////////////
							// block 3
							////////////////////////////
							__asm
							{
				                 mov     eax, [ebp1198h]
				                 xor     edx, edx
				                 mov     ecx, 10h
				                 div     ecx
				                 mov     [ebp119Ch], edx
				                 mov     edx, [ebp13B0h]
				                 push    edx
				                 mov     eax, [ebp119Ch]
				                 call    ds:Block3Func1Data1[eax*4]
				                 add     esp, 4
				                 mov     [ebp146Ch], eax
							}

							/////////////////////////////
							// block 4
							/////////////////////////////
							__asm
							{
				                 mov     dword ptr [ebp1470h], 0
				                 mov     ecx, [ebp119Ch]
				                 mov     edx, dword ptr Block4Data1[ecx*4]
				                 mov     [ebp1190h], edx
B4Label1:
				                 mov     eax, [ebp1470h]
				                 cmp     eax, [ebp1190h]
				                 jge     B4Label5
				                 mov     eax, [ebp1190h]
				                 sub     eax, [ebp1470h]
				                 cdq
				                 sub     eax, edx
				                 sar     eax, 1
				                 mov     ecx, [ebp1470h]
				                 add     ecx, eax
				                 mov     [ebp1474h], ecx
				                 mov     edx, [ebp119Ch]
				                 mov     eax, dword ptr Block4Data2[edx*4]
				                 mov     ecx, [ebp1474h]
				                 mov     edx, [ebp146Ch]
				                 cmp     edx, [eax+ecx*4]
				                 jbe     B4Label3
				                 mov     eax, [ebp1474h]
				                 add     eax, 1
				                 mov     [ebp1470h], eax
				                 jmp     B4Label4
B4Label3:
				                 mov     ecx, [ebp1474h]
				                 mov     [ebp1190h], ecx
B4Label4:
				                 jmp     B4Label1
B4Label5:
								 nop
							}
							////////////////////////////
							// block 5
							////////////////////////////
							__asm
							{
				                 mov     edx, [ebp119Ch]
				                 mov     eax, dword ptr Block4Data2[edx*4]
				                 mov     ecx, [ebp1470h]
				                 mov     edx, [eax+ecx*4]
				                 cmp     edx, [ebp146Ch]
				                 jnz     ContinueDebugging
							}
							////////////////////////////
							// block 6
							////////////////////////////
							ebp13A8h = Context.EFlags;
							ebp13BCh = 0;
							__asm
							{
				                 mov     eax, [ebp119Ch]
				                 mov     ecx, dword ptr Block6Data1[eax*4]
				                 mov     edx, [ebp1470h]
				                 mov     eax, [ecx+edx*4]
				                 mov     [ebp1488h], eax
				                 mov     ecx, [ebp13A8h] ; eflags
				                 and     ecx, 0FD7h
				                 mov     [ebp1478h], ecx
				                 mov     edx, [ebp1488h]
				                 and     edx, 0FF000000h
				                 shr     edx, 18h
				                 mov     [ebp1484h], edx
				                 mov     eax, [ebp1488h]
				                 and     eax, 0FFFFFFh
				                 mov     [ebp1480h], eax
				                 mov     ecx, [ebp13BCh]
				                 push    ecx
				                 mov     edx, [ebp1478h]
				                 push    edx             ; eflags
				                 mov     eax, [ebp1480h]
				                 push    eax
				                 mov     ecx, [ebp1484h]
				                 call    Block6Funcs[ecx*4]
				                 add     esp, 0Ch
				                 mov     [ebp147Ch], eax
				                 mov     edx, [ebp147Ch]
				                 and     edx, 1
				                 test    edx, edx
				                 jz      SkipSecondCalculus
							}

							///////////////////////////////
							// block 7
							///////////////////////////////
							__asm
							{
//SecondCalculus:
				                 mov     eax, [ebp119Ch]
				                 mov     ecx, dword ptr B7Array[eax*4]
				                 mov     eax, [ebp1470h]
				                 xor     edx, edx
				                 mov     esi, 10h
				                 div     esi
				                 mov     eax, [ebp1470h]
				                 mov     ecx, [ecx+eax*4]
//				                 xor     ecx, [ebp+edx*4-1174h]
								 xor	 ecx, dword ptr [B7StackArray+edx*4]
				                 mov     edx, [ebp13B0h]
				                 add     edx, ecx
				                 mov     [ebp13B0h], edx
								 jmp	 ContinueDebugging
							}
							///////////////////////////////
							// block 8
							///////////////////////////////
							__asm
							{
SkipSecondCalculus:
				                 mov     eax, [ebp119Ch]
					             mov     ecx, dword ptr B8Array[eax*4]
				                 mov     edx, [ebp1470h]
				                 xor     eax, eax
				                 mov     al, [ecx+edx]
				                 mov     ecx, [ebp13B0h]
				                 add     ecx, eax
				                 mov     [ebp13B0h], ecx
							}

///////////////////////////////////////////
// end new asm emulation routine
///////////////////////////////////////////
ContinueDebugging:
							Context.Eip = ebp13B0h;
							SetThreadContext(Threads[j].ThreadHandle, &Context);   ///
							Continue = DBG_CONTINUE;
							break;
						}
						break;

					default:
						Continue = DBG_EXCEPTION_NOT_HANDLED;
				}
				break;

			case CREATE_THREAD_DEBUG_EVENT:
				Threads[NumberOfThreads].ThreadId = Event.dwThreadId;
				Threads[NumberOfThreads].ThreadHandle = Event.u.CreateThread.hThread;
				NumberOfThreads++;
				Continue = DBG_CONTINUE;
				break;

			case EXIT_PROCESS_DEBUG_EVENT:
				MessageBox(NULL, "Exit process", "End", MB_OK);
				DebugLoop = FALSE;
				Continue = DBG_CONTINUE;
				break;

			default:
				Continue = DBG_CONTINUE;
				break;
		}
		ContinueDebugEvent(Event.dwProcessId, Event.dwThreadId, Continue);
	}
	return 0;
}




