#include "HDLCore.h"
#include "ThreadLocator.h"
#include "LocateThreadByWindow.h"

bool LocateThreadByWindow::LocateThread(DWORD& ThreadID)
{
	WindowIdentifier Identifier;
	
	// Loop through the window identifiers, until no more are available
	for(DWORD Index = 0; GetWindowIdentifier(Index, Identifier); Index++) {
		//HWND Window = FindWindow(Identifier.WindowClass, Identifier.WindowTitle);
		HWND Window = FindWindow(NULL, VictimWindowName);

		if(Window) {
			ThreadID = GetWindowThreadProcessId(Window, NULL);
			return true;
		}
	}

	return false;
}

LPCTSTR LocateThreadByWindow::GetErrorMessage()
{
	return ErrorLocatingWindow;
}