#include <tchar.h>
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <shlobj.h>
#include "resource.h"


HINSTANCE	hInst;

#define APPNAME		"AutoRuns"

BOOL GetTreeviewTextRecurse( HWND hTree, HTREEITEM hItem, int depth, char ** text )
{
	char	*	ptr = *text;

	while ( hItem )  {
		HTREEITEM	hNext;
		TV_ITEM		item;
		int			j;

		// Add item
		for ( j = 0; j < depth; ++j )  {
			memcpy( ptr, "+ ", 2 );
			ptr += 2;
		}
		item.hItem = hItem;
		item.mask = TVIF_TEXT;
		item.pszText = ptr;
		item.cchTextMax = MAX_PATH;
		TreeView_GetItem( hTree, &item ); 
		ptr = strchr( ptr, 0 );
		memcpy( ptr, "\r\n", 2 );
		ptr += 2;

		// If item has children recurse
		hNext = TreeView_GetChild( hTree, hItem );
		if ( hNext )  {
			*text = ptr;
			GetTreeviewTextRecurse( hTree, hNext, depth+1, text );
			ptr = *text;
		}

		// Go to sibling
		hItem = TreeView_GetNextSibling( hTree, hItem); 
	}
	*text = ptr;
	return TRUE;
}
BOOL GetTreeviewText( HWND hTree, char * text )
{
	HTREEITEM	hItem = TreeView_GetRoot( hTree );
	BOOL		ok;

	ok = GetTreeviewTextRecurse( hTree, hItem, 0, &text );
	*text = '\0';

	return ok;
}


/******************************************************************************
*
*	FUNCTION:	CopyToClipboard
*
*	PURPOSE:	Copy window contents to clipboard
*
*****************************************************************************/
BOOL CopyToClipboard( HWND hTree )
{
	HGLOBAL		hMem;
	char	*	Text;

	// Get clipboard
	if ( ! OpenClipboard( hTree ) )
		return FALSE;
	EmptyClipboard();
	
	// Get text
	hMem = GlobalAlloc( GMEM_MOVEABLE|GMEM_DDESHARE, MAX_PATH*100 );
	Text = GlobalLock( hMem );

	GetTreeviewText( hTree, Text );

	GlobalUnlock( hMem );

	// Set clipboard data
	SetClipboardData( CF_TEXT, hMem );
	return CloseClipboard();
}




/******************************************************************************
*
*	FUNCTION:	RegeditJump
*
*	PURPOSE:	Opens Regedit and navigates the desired key
*
*****************************************************************************/
BOOL RegeditJump( const TCHAR * RegPath )
{
	int			pos;
	const TCHAR	* ch;
	HWND		hTreeview, hRegedit;
	TCHAR		*value = _tcsrchr( RegPath, '\\' ) + 1;
	HDC			hdcSceeen = CreateDC( TEXT("DISPLAY"), NULL, NULL, NULL ); 
	DWORD		numColors = GetDeviceCaps( hdcSceeen, NUMCOLORS );

	DeleteDC( hdcSceeen );

	// Open RegEdit
	hRegedit = FindWindow( TEXT("RegEdit_RegEdit"), NULL );
	if ( hRegedit == NULL )  {
		SHELLEXECUTEINFO info;
		memset( &info, 0, sizeof info );
		info.cbSize = sizeof info;
		info.fMask	= SEE_MASK_NOCLOSEPROCESS; 
		info.lpVerb	= TEXT("open"); 
		info.lpFile	= TEXT("regedit.exe"); 
		info.nShow	= SW_SHOWNORMAL; 
		ShellExecuteEx( &info );
		WaitForInputIdle( info.hProcess, INFINITE );
		hRegedit = FindWindow( TEXT("RegEdit_RegEdit"), NULL );
	} 
	if ( hRegedit == NULL )
		return FALSE;

	ShowWindow( hRegedit, SW_SHOW );
	SetForegroundWindow( hRegedit );

	// Get treeview
	hTreeview = FindWindowEx( hRegedit, NULL, TEXT("SysTreeView32"), NULL );
	SetForegroundWindow( hTreeview );
	SetFocus( hTreeview );

	// Close it up
	for ( pos = 0; pos < 30; ++pos )  {
		UINT vk = VK_LEFT;
		SendMessage( hTreeview, WM_KEYDOWN, vk, 0 );
	}

	// wait for slow displays - 
	// Regedit takes a while to open keys with lots of subkeys
	// when running at high color depths 
	if ( numColors > 256 )
		Sleep( 750 ); 

	// Open path
	SendMessage( hTreeview, WM_KEYDOWN, VK_RIGHT, 0 );
	for ( ch = RegPath; ch < value  &&  *ch; ++ch )  {
		if ( *ch == '\\' )  {
			UINT vk = VK_RIGHT;
			SendMessage( hTreeview, WM_KEYDOWN, vk, 0 );

			// wait for slow displays - 
			// Regedit takes a while to open keys with lots of subkeys
			// when running at high color depths 
			if ( numColors > 256 )
				Sleep( 750 ); 

		} else {
			UINT vk = toupper(*ch);

			SendMessage( hTreeview, WM_CHAR, vk, 0 );
		}
	}

	// If its a value select the value
	if ( value ) {
		UINT vk = VK_HOME;

		hTreeview = FindWindowEx( hRegedit, NULL, TEXT("SysListView32"), NULL );
		SetForegroundWindow( hTreeview );
		SetFocus( hTreeview );
		Sleep(1000); // have to wait for Regedit to update listview
		SendMessage( hTreeview, WM_KEYDOWN, vk, 0 );

		for ( ch = value; *ch; ++ch )  {
			UINT vk = toupper(*ch);

			SendMessage( hTreeview, WM_CHAR, vk, 0 );
		}
	}

	SetForegroundWindow( hRegedit );
	SetFocus( hRegedit );
	return TRUE;
}



BOOL GetLinkInfo( HWND hWnd, const TCHAR * LinkName, char * TargetPath )
{
	HRESULT			hres;
	IShellLink *	psl;
	IPersistFile *	ppf;

	CoInitialize( NULL );

	// Call CoCreateInstance to obtain the IShellLink
	// Interface pointer. 
	hres = CoCreateInstance( &CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, 
								&IID_IShellLink, (LPVOID *)&psl );
	if ( ! SUCCEEDED( hres ) )
		return FALSE;

	// The IShellLink Interface supports the IPersistFile
	// interface. Get an interface pointer to it.
	hres = psl->lpVtbl->QueryInterface( psl, &IID_IPersistFile, (LPVOID *)&ppf );
	if ( SUCCEEDED( hres ) )  {
		WORD wsz[MAX_PATH];

#if UNICODE
		_tcscpy( wsz, LinkName );
#else
		// Convert the given link name string to wide character string.
		MultiByteToWideChar( CP_ACP, 0, LinkName, -1, wsz, MAX_PATH );
#endif

		// Load the file.
		hres = ppf->lpVtbl->Load( ppf, wsz, STGM_READ );
		if ( SUCCEEDED( hres ) )  {
			// Resolve the link by calling the Resolve() interface function.
			hres = psl->lpVtbl->Resolve( psl, hWnd, SLR_ANY_MATCH | SLR_NO_UI );
			if ( SUCCEEDED( hres ) )  {
				WIN32_FIND_DATA wfd;
				hres = psl->lpVtbl->GetPath( psl, TargetPath, MAX_PATH, &wfd, SLGP_SHORTPATH );
				if ( ! SUCCEEDED(hres) )
					return FALSE;
			}
		}
		ppf->lpVtbl->Release( ppf );
	}
	psl->lpVtbl->Release( psl );

	return TRUE;
}




HTREEITEM AddNode( HWND hTree, HTREEITEM hParent, TCHAR * text, TCHAR * path )
{
	TV_INSERTSTRUCT		tvi = { 0 };

	if ( path )
		path = _tcsdup( path );

	tvi.hParent			= hParent; 
	tvi.hInsertAfter	= TVI_LAST; 
    tvi.item.mask		= TVIF_TEXT | TVIF_PARAM;
	tvi.item.pszText	= text;
	tvi.item.lParam		= (LPARAM) path;

	return TreeView_InsertItem( hTree, &tvi ); 
}


TCHAR * RegLocation( HKEY hive, const TCHAR * key, const TCHAR * value )
{
	static TCHAR	buf[ 500 ];
	const TCHAR * h = TEXT("?");

	switch ( (DWORD)hive )  {
		case (DWORD)HKEY_LOCAL_MACHINE:		h = TEXT("HKEY_LOCAL_MACHINE");	break;
		case (DWORD)HKEY_CURRENT_USER:		h = TEXT("HKEY_CURRENT_USER");	break;
	}
	_stprintf( buf, TEXT("%s\\%s\\%s"), h, key, value );
	return buf;
}

void RegistryValue( HWND hTree, HKEY hive, const TCHAR * key, const TCHAR * value )
{
	HKEY		hKey;
	DWORD		nb;
	HTREEITEM	hParent = AddNode( hTree, NULL, RegLocation(hive,key,value), RegLocation(hive,key,TEXT("")) );

	if ( RegOpenKeyEx( hive, key, 0, KEY_READ, &hKey ) == ERROR_SUCCESS )
	{
		TCHAR valuebuf[400];
		nb = sizeof valuebuf;
		if ( RegQueryValueEx( hKey, value, 0, NULL, (char *)valuebuf, &nb ) == ERROR_SUCCESS )
		{
			TCHAR * p = valuebuf;
			while ( *p )  {
				TCHAR * end = _tcschr( p, ',' );
				if ( end )
					*end = '\0';

				AddNode( hTree, hParent, p, RegLocation(hive,key,value) );

				if ( end )
					p = end + 1;
				else
					p = TEXT("");
			}
		}
		RegCloseKey( hKey );
	}
}


void RegistryKey( HWND hTree, HKEY hive, const TCHAR * key )
{
	HKEY		hKey;
	DWORD		i;
	HTREEITEM	hParent = AddNode( hTree, NULL, RegLocation(hive,key,TEXT("")), RegLocation(hive,key,TEXT("")) );

	if ( RegOpenKeyEx( hive, key, 0, KEY_READ, &hKey ) == ERROR_SUCCESS )
	{
		for ( i = 0;; ++i )  {
			TCHAR		name[ 260 ];
			TCHAR		valuebuf[ 400 ];
			DWORD		nbname, nb;

			nbname = sizeof name;
			nb = sizeof valuebuf;
			if ( RegEnumValue( hKey, i, name, &nbname, 0, NULL, (char *)valuebuf, &nb ) != ERROR_SUCCESS )
				break;

			AddNode( hTree, hParent, valuebuf, RegLocation(hive,key,name) );
		}
		RegCloseKey( hKey );
	}
}


void EnumFiles( HWND hTree, HTREEITEM hParent, TCHAR * path )
{
	TCHAR		*	pathend;
	HANDLE			hFind;
	WIN32_FIND_DATA	info;

	pathend = _tcschr( path, TEXT('\0') );
	*pathend = '\\';
	_tcscpy( pathend+1, TEXT("*") );

	hFind = FindFirstFile( path, &info );
	if ( hFind != INVALID_HANDLE_VALUE )  {
		do {
			char	linkpath[300];
			if ( info.cFileName[0] == '.' )
				continue;
			_tcscpy( pathend+1, info.cFileName );
			if ( _tcslen(path) >= 4  &&  _tcsicmp( _tcschr(path,0)-4, TEXT(".lnk") ) == 0  &&
				 GetLinkInfo( hTree, path, linkpath ) )  
			{
				TCHAR ptr[500];
#if UNICODE
				_stprintf( ptr, TEXT("%s -> %S"), info.cFileName, linkpath );
#else
				_stprintf( ptr, TEXT("%s -> %s"), info.cFileName, linkpath );
#endif
				pathend[0] = '\0';
				AddNode( hTree, hParent, ptr, path );
			} else {
				AddNode( hTree, hParent, info.cFileName, path );
			}
		} while ( FindNextFile( hFind, &info ) );
		FindClose( hFind );
	}
}


void StartupFolder( HWND hTree, HKEY hive, const TCHAR * key, const TCHAR * value )
{
	HKEY			hKey;
	DWORD			nb;
	TCHAR			path[300];

	// Get path to Startup folder
	if ( RegOpenKeyEx( hive, key, 0, KEY_READ, &hKey ) != ERROR_SUCCESS )
		return;

	nb = sizeof path;
	if ( RegQueryValueEx( hKey, value, 0, NULL, (char *)path, &nb ) == ERROR_SUCCESS )  {
		HTREEITEM	hParent;
		hParent = AddNode( hTree, NULL, path, path );
		EnumFiles( hTree, hParent, path );
	}
	RegCloseKey( hKey );
}


#if !UNICODE
void WinIni( HWND hTree )
{
	TCHAR		path[ 260 ];
	TCHAR		line[ 260 ];
	FILE	*	fp;
	HTREEITEM	hParent;
	BOOL		inSection = FALSE;

	GetWindowsDirectory( path, sizeof path/sizeof path[0] );
	_tcscat( path, "\\win.ini" );

	hParent = AddNode( hTree, NULL, path, path );

	fp = fopen( path, "rt" );
	if ( fp == NULL )
		return;

	while ( fgets( line, sizeof line, fp ) )  {
		if ( line[0] == '[' )
			inSection = strnicmp( line, "[windows]", 9 ) == 0;
		else if ( inSection )  {
			char * list;
			if ( strnicmp( line, "load=", 5 ) == 0 )
				list = line+5;
			else if ( strnicmp( line, "run=", 4 ) == 0  )
				list = line+4;
			else
				list = NULL;
			if ( list )  {
				while ( *list )  {
					TCHAR * end = _tcschr( list, ',' );
					if ( end == NULL )
						end = _tcschr( list, '\n' );
					if ( end )
						*end = '\0';

					AddNode( hTree, hParent, list, path );

					if ( end )
						list = end + 1;
					else
						list = TEXT("");
				}
			}		
		}
	}
	fclose( fp );
}
#endif


void FillTree( HWND hTree )
{
	// Userinit is first
	RegistryValue( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon"), 
					TEXT("Userinit") );
	
	// System run-once is second, and must complete before proceeding
	RegistryKey( hTree,	
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnce") );
	RegistryKey( hTree,	HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx") );

	// Everything from here on starts virtually simultaneously
	RegistryValue( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows NT\\CurrentVersion\\Windows"), 
					TEXT("Run") );
	RegistryKey( hTree,	
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run") );
	RegistryKey( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\Run") );

	StartupFolder( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"),
					TEXT("Common Startup") );
	StartupFolder( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"),
					TEXT("Common AltStartup") );
	StartupFolder( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"),
					TEXT("Startup") );

#if 0
	// This doesn't seem to do anything.  I think it was mixed up with the one below.
	RegistryValue( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Windows"),
					TEXT("Load") );
#endif

	// Several users said we needed this one too
	RegistryValue( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows NT\\CurrentVersion\\Windows"),
					TEXT("Load") );

	// Back Orifice uses these:
	RegistryKey( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunServices") );
	RegistryKey( hTree,
					HKEY_LOCAL_MACHINE,
					TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce") );
	RegistryKey( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\RunServices") );
	RegistryKey( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce") );


#if 0
	// This doesn't appear to be even work
	RegistryValue( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows NT\\CurrentVersion\\Winlogon"), 
					TEXT("Userinit") );
#endif

	// user run-once comes last
	RegistryKey( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce") );
	RegistryKey( hTree,
					HKEY_CURRENT_USER,
					TEXT("Software\\Microsoft\\Windows\\CurrentVersion\\RunOnceEx") );

#if !UNICODE
	// Stuff in win.ini
	WinIni( hTree );
#endif
}


LONG CALLBACK MainDialog( HWND hDlg, UINT message, UINT wParam, LONG lParam )
{
	switch ( message ) {
		case WM_INITDIALOG:
			// Create listview with columns
			FillTree( GetDlgItem( hDlg, IDC_TREE ) );
			break;

		case WM_NOTIFY:
			if ( ((NMHDR *)lParam)->code == TVN_SELCHANGED )
				EnableWindow( GetDlgItem(hDlg,IDC_JUMP), TRUE );
			break;

		case WM_COMMAND:
			switch (wParam) {
				case IDOK:
				case IDCANCEL:
					EndDialog( hDlg, 0 );
					return TRUE;

				case IDC_COPY:
					CopyToClipboard( GetDlgItem(hDlg,IDC_TREE) );
					MessageBox( hDlg, APPNAME " information has been copied to your ClipBoard.",
								APPNAME, MB_OK|MB_ICONINFORMATION );
					break;

				case IDC_JUMP:  {
					HTREEITEM		hItem = TreeView_GetSelection( GetDlgItem(hDlg,IDC_TREE) );
					TV_ITEM			tvi;
					const TCHAR *	path;

					tvi.hItem = hItem;
					tvi.mask  = TVIF_PARAM;
					TreeView_GetItem( GetDlgItem(hDlg,IDC_TREE), &tvi );
					path = (TCHAR *)tvi.lParam;
					if ( path )
						if ( _tcsncmp( path, TEXT("HKEY"), 4 ) == 0 )  {
							RegeditJump( path );
						} else if ( _tcsicmp( _tcschr( path, '\0' )-7, TEXT("WIN.INI") ) == 0 )  {
							SHELLEXECUTEINFO	se = { sizeof se, 0 };
							se.fMask;
							se.hwnd		= hDlg;
							se.lpVerb	= TEXT("open");
							se.lpFile	= path;
							se.nShow	= SW_SHOWNORMAL;
							ShellExecuteEx( &se );
						} else {
							SHELLEXECUTEINFO	se = { sizeof se, 0 };
							se.fMask;
							se.hwnd		= hDlg;
							se.lpVerb	= TEXT("explore");
							se.lpFile	= path;
							se.nShow	= SW_SHOWNORMAL;
							ShellExecuteEx( &se );
						}
					break;
				}

				case IDC_REFRESH:
					EnableWindow( GetDlgItem(hDlg,IDC_JUMP), FALSE );
					TreeView_DeleteAllItems( GetDlgItem( hDlg, IDC_TREE ) );
					FillTree( GetDlgItem( hDlg, IDC_TREE ) );
					break;
			}
			break; 

		case WM_CLOSE:	
			EndDialog( hDlg, 0 );
			return TRUE;
	}

	return DefWindowProc( hDlg, message, wParam, lParam );
}



int CALLBACK WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
        				LPSTR lpCmdLine, int nCmdShow )
{
	WNDCLASSEX				wndclass;

	InitCommonControls();

	hInst = hInstance;

	memset( &wndclass, 0, sizeof wndclass );
	wndclass.cbSize			= sizeof( WNDCLASSEX );
	wndclass.style          = CS_HREDRAW | CS_VREDRAW;
	wndclass.cbClsExtra     = 0;
	wndclass.cbWndExtra     = DLGWINDOWEXTRA;
	wndclass.hInstance      = hInst;
	wndclass.hIcon          = LoadIcon(hInst, TEXT("APPICON"));
	wndclass.hIconSm		= LoadIcon(hInst, TEXT("APPICON"));
	wndclass.hCursor        = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground  = (HBRUSH)(COLOR_BTNFACE+1);
	wndclass.lpszMenuName   = NULL;
	wndclass.lpfnWndProc    = MainDialog;
	wndclass.lpszClassName  = TEXT("Autoruns");
	RegisterClassEx( &wndclass );

	DialogBox( hInst, TEXT("MainDialog"), NULL, MainDialog );

	return 0;
}