//======================================================================
// 
//  Filemon.h
//
//  Copyright (C) 1996-1999 Mark Russinovich and Bryce Cogswell
//
//======================================================================

//----------------------------------------------------------------------
// 
// Filemon Types
//
//----------------------------------------------------------------------


//
// Print macro that only turns on when debugging is on
//
#if DBG
#define DbgPrint(arg)  DbgPrint( "%x: ", KeGetCurrentThread()); \
                       DbgPrint arg
#else
#define DbgPrint(arg) 
#endif

//
// The name of the System process, in which context we're called in our 
// DriverEntry
//
#define SYSNAME    "System"

//
// NT Final Build number
//
#define NT4FINAL        1381

//
// Maximum amount of memory grabbed 
//
#define MAXMEMORY       1000000

//
// Maximum path length of pathname. This is larger than Win32 maxpath
// because network drives have leading paths
//
#define MAXPATHLEN      1024

//
// Length of process name (rounded up to next DWORD)
//
#define PROCNAMELEN     32

//
// Maximum length of NT process name
//
#define NT_PROCNAMELEN  16

//
// Maximum seperate filter components 
//
#define MAXFILTERS      64

//
// Length of buffer for error string
//
#define ERRORLEN        64


//
// Structure for device specific data that keeps track of what
// drive and what filesystem device are hooked 
//
typedef struct {
   FILE_SYSTEM_TYPE Type;
   PDEVICE_OBJECT   FileSystem;
   unsigned         LogicalDrive;
   BOOLEAN          Hooked;
} HOOK_EXTENSION, *PHOOK_EXTENSION;         


//
// Structure for the fileobject/name hash table
//
typedef struct _nameentry {
   PFILE_OBJECT		FileObject;
   PCHAR		FullPathName;
   struct _nameentry 	*Next;
} HASH_ENTRY, *PHASH_ENTRY;

//
// Structure for a completion routine work item
//
typedef struct _filemonwork {
    WORK_QUEUE_ITEM WorkItem;
    ULONG          Sequence;
    LARGE_INTEGER  TimeResult;
    CHAR           ErrString[ERRORLEN];
} FILEMON_WORK, *PFILEMON_WORK;


//
// Number of hash buckets in the hash table
//
#define NUMHASH		0x100

//
// Hash function. Basically chops the low few bits of the file object
//
#define HASHOBJECT(_fileobject)		(((ULONG)_fileobject)>>5)%NUMHASH


//
// Structure for keeping linked lists of output buffers
//
typedef struct _log {
    ULONG           Len;
    struct _log   * Next;
    CHAR            Data[ LOGBUFSIZE ];
} LOG_BUF, *PLOG_BUF;


//
// A check to see if a fastio table extends to a specific entry
//
#define FASTIOPRESENT( _hookExt, _call )                                                      \
    (_hookExt->FileSystem->DriverObject->FastIoDispatch &&                                    \
     (((ULONG)&_hookExt->FileSystem->DriverObject->FastIoDispatch->_call -                    \
       (ULONG) &_hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch <    \
       (ULONG) _hookExt->FileSystem->DriverObject->FastIoDispatch->SizeOfFastIoDispatch )) && \
      hookExt->FileSystem->DriverObject->FastIoDispatch->_call )

//
// Time stamp start macro
//
#define TIMESTAMPSTART()                                                       \
        if( TimeIsDuration ) timeStampStart = KeQueryPerformanceCounter(NULL); \
        else                 KeQuerySystemTime( &timeResult )

#define TIMESTAMPSTOP()                                                        \
        if( TimeIsDuration ) {                                                 \
            timeStampComplete = KeQueryPerformanceCounter(NULL);               \
            timeResult.QuadPart = timeStampComplete.QuadPart - timeStampStart.QuadPart; \
        }

//
// Macro for getting the path name
//
#define GETPATHNAME(_IsCreate)                                                  \
        fullPathName = ExAllocatePool( NonPagedPool, MAXPATHLEN );              \
        if( fullPathName ) {                                                    \
            FilemonGetFullPath( _IsCreate, FileObject, hookExt, fullPathName ); \
        }   

#define FREEPATHNAME()                                   \
        if ( fullPathName ) ExFreePool( fullPathName )


//----------------------------------------------------------------------
//
// NT Types 
//
//----------------------------------------------------------------------

//
// We define these so that we can build the source with the NT 4 DDK. We
// picked any random #define that was introduced in the NT5DDK header file
// as our key.
//
#ifndef MDL_64_BIT_VA

#define IRP_MJ_POWER                          0x16
#define IRP_MJ_PNP                            0x1b
#define IRP_MN_QUERY_LEGACY_BUS_INFORMATION   0x18
#define NT5DDK 0

VOID NTAPI ProbeForWrite(PVOID Address, 
                         ULONG Length, 
                         ULONG Alignment );
#else
#define NT5DDK 1
#endif


//
// Undocumented ntoskrnl variable
//
extern PSHORT           NtBuildNumber;

//
// For the definitions in Winioctl.h
//
#undef DEVICE_TYPE
typedef UCHAR  BYTE;
typedef USHORT WORD;
typedef ULONGLONG DWORDLONG;
typedef ULONG  DWORD;
typedef PVOID SID;

//
// So that we can pick up NT 5.0 IOCTLs in WINIOCTL.h
//
#undef _WIN32_WINNT
#define _WIN32_WINNT 0x0500

//
// Totally undocumented named pipe file system control codes
//
#define FSCTL_PIPE_ASSIGN_EVENT          0x110000
#define FSCTL_PIPE_DISCONNECT            0x110004
#define FSCTL_PIPE_QUERY_EVENT           0x110010
#define FSCTL_PIPE_LISTEN                0x110008
#define FSCTL_PIPE_IMPERSONATE           0x11001C
#define FSCTL_PIPE_WAIT                  0x110018
#define FSCTL_PIPE_QUERY_CLIENT_PROCESS  0x110024
#define FSCTL_PIPE_SET_CLIENT_PROCESS    0x110020
#define FSCTL_PIPE_PEEK                  0x11400C
#define FSCTL_PIPE_INTERNAL_READ         0x116000
#define FSCTL_PIPE_INTERNAL_WRITE        0x119FF8
#define FSCTL_PIPE_TRANSCEIVE            0x11C017
#define FSCTL_PIPE_INTERNAL_TRANSCEIVE   0x11DFFF

//
// Undocumented mail slot file system controls
//
#define FSCTL_MAILSLOT_PEEK              0xC4003

//
// Undocumented network redirector control
//
#define FSCTL_NETWORK_SET_CONFIGURATION_INFO 0x140199
#define FSCTL_NETWORK_GET_CONFIGURATION_INFO 0x14019E
#define FSCTL_NETWORK_ENUMERATE_CONNECTIONS  0x1401A7
#define FSCTL_NETWORK_GET_CONNECTION_INFO    0x1401A3
#define FSCTL_NETWORK_DELETE_CONNECTION      0x1401AC
#define FSCTL_NETWORK_GET_STATISTICS         0x1401D0
#define FSCTL_NETWORK_SET_DOMAIN_NAME        0x1401E0
#define FSCTL_NETWORK_REMOTE_BOOT_INIT_SCRT  0x1403E8

//
// Named pipe and mail slot prefix names
//
#define NAMED_PIPE_PREFIX                "\\\\.\\Pipe"
#define NAMED_PIPE_PREFIX_LENGTH         (sizeof(NAMED_PIPE_PREFIX)-1)

#define MAIL_SLOT_PREFIX                "\\\\.\\MailSlot"
#define MAIL_SLOT_PREFIX_LENGTH         (sizeof(MAIL_SLOT_PREFIX)-1)

//
// Common file control block header, copied from 
// the file system development kit header file, NTIFS.H
//
typedef struct _FSRTL_COMMON_FCB_HEADER {

    CSHORT NodeTypeCode;
    CSHORT NodeByteSize;

    //
    //  General flags available to FsRtl.
    //

    UCHAR Flags;

    //
    //  Indicates if fast I/O is possible or if we should be calling
    //  the check for fast I/O routine which is found via the driver
    //  object.
    //

    UCHAR IsFastIoPossible; // really type FAST_IO_POSSIBLE

    //
    //  Second Flags Field
    //

    UCHAR Flags2;

    //
    //  The following reserved field should always be 0
    //

    UCHAR Reserved;

    PERESOURCE Resource;

    PERESOURCE PagingIoResource;

    LARGE_INTEGER AllocationSize;
    LARGE_INTEGER FileSize;
    LARGE_INTEGER ValidDataLength;

} FSRTL_COMMON_FCB_HEADER;
typedef FSRTL_COMMON_FCB_HEADER *PFSRTL_COMMON_FCB_HEADER;


// 
// Directory control structure
//
typedef struct {
    ULONG Length;
    PUNICODE_STRING FileName;
    FILE_INFORMATION_CLASS FileInformationClass;
    ULONG FileIndex;
} QUERY_DIRECTORY, *PQUERY_DIRECTORY;

//
// Lock control data structure
//
typedef struct {
    PLARGE_INTEGER Length;
    ULONG Key;
    LARGE_INTEGER ByteOffset;
} LOCK_CONTROL, *PLOCK_CONTROL;

//
// File name information 
//
#if !NT5DDK
typedef struct _FILE_NAME_INFORMATION {
    ULONG FileNameLength;
    WCHAR FileName[1];
} FILE_NAME_INFORMATION, *PFILE_NAME_INFORMATION;
#endif

