//======================================================================
// 
//  Regmon.h
//
//  Copyright (C) 1996, 1997 Mark Russinovich and Bryce Cogswell
//
//  Typedefs and defines.
// 
//======================================================================

//
// Basic types
//
typedef unsigned int    UINT;
typedef char            CHAR;
typedef char *          PCHAR;
typedef PVOID           POBJECT;

//
// The maximum length of Registry values that will be copied
//
#define MAXVALLEN      256

//
// Maximum seperate filter components 
//
#define MAXFILTERS     64

//
// The maximum registry path length that will be copied
//
#define MAXPATHLEN     1024

//
// Maximum length of data that will be copied to the "other" field in the display
//
#define MAXDATALEN     32

//
// Length of process name buffer. Process names are at most 16 characters so
// we take into account a trailing NULL.
//
#define MAXPROCNAMELEN  20

//
// Maximum length of NT process name
//
#define NT_PROCNAMELEN  16

//
// Maximum length of root keys that we will produce abbreviations for
 //
#define MAXROOTLEN      128

//
// Maximum amount of memory that will be grabbed
//
#define MAXMEM          1000000

//
// Invalid handle
//
#define INVALID_HANDLE_VALUE  ((HANDLE) -1)

//
// Convenient mutex macros
//
#define MUTEX_INIT(v)      KeInitializeMutex( &v, 0 )
#define MUTEX_ACQUIRE(v)   KeWaitForMutexObject( &v, Executive, KernelMode, FALSE, NULL )
#define MUTEX_RELEASE(v)   KeReleaseMutex( &v, FALSE )

//
// Definition for system call service table
//
typedef struct _SRVTABLE {
	PVOID           *ServiceTable;
	ULONG           LowCall;        
	ULONG           HiCall;
	PVOID		    *ArgTable;
} SRVTABLE, *PSRVTABLE;

//
// Structure for our name hash table
//
typedef struct _nameentry {
   POBJECT              Object;
   PCHAR                FullPathName;
   struct _nameentry    *Next;
} HASH_ENTRY, *PHASH_ENTRY;

//
// Structure for keeping linked lists of output buffers
//
typedef struct _log {
    ULONG               Len;
    struct _log *       Next;
    char                Data[ LOGBUFSIZE ];
} LOG_BUF, *PLOG_BUF;

//
// Rootkey name translation structure
//
typedef struct _rootkey {
    CHAR                RootName[256];
    CHAR                RootShort[32];
    ULONG               RootNameLen;
} ROOTKEY, *PROOTKEY;

//
// Number of hash buckets
//
#define NUMHASH         0x100
#define HASHOBJECT(_regobject)          (((ULONG)_regobject)>>2)%NUMHASH

//
// Definition for Registry function prototypes not included in NTDDK.H
//
NTSYSAPI
NTSTATUS
NTAPI ZwDeleteValueKey( IN HANDLE, IN PUNICODE_STRING );
NTSYSAPI
NTSTATUS
NTAPI ZwLoadKey( IN POBJECT_ATTRIBUTES, IN POBJECT_ATTRIBUTES );
NTSYSAPI
NTSTATUS
NTAPI ZwUnloadKey( IN POBJECT_ATTRIBUTES );

//
// Definition for ObQueryNameString call
//
NTSYSAPI
NTSTATUS
NTAPI ObQueryNameString( POBJECT Object, PUNICODE_STRING Name, ULONG MaximumLength, PULONG ActualLength );

//
// For displaying messages to the Blue Screen
//
NTSYSAPI
NTSTATUS
NTAPI ZwDisplayString( PUNICODE_STRING Text );


//
// Undocumented ntoskrnl function for checking user buffer validity
//
VOID NTAPI ProbeForWrite(PVOID Address, 
                         ULONG Length, 
                         ULONG Alignment );

//
// This are Win2K definitions that are included only in the Win2K
// version of NTDDK.H. So that it works on NT 4, Regmon is built with
// the NT 4 DDK and we have to include these definitions ourselves
//
enum {
    KeyNameInformation = 3
};
typedef struct _KEY_NAME_INFORMATION {
    ULONG   NameLength;
    WCHAR   Name[1];            // Variable length string
} KEY_NAME_INFORMATION, *PKEY_NAME_INFORMATION;


//
// Pointer to the image of the system service table
//
extern PSRVTABLE KeServiceDescriptorTable;


//
// Extract transfer type
//
#define IOCTL_TRANSFER_TYPE( _iocontrol)   (_iocontrol & 0x3)

