// Keyfile generator for Kwazy Webbit's Pacme by TSCube 07/05/2000
#include <stdio.h>
#include <string.h>

int check();
int generate(char* name);

int main(void)
{
	char name[100];
	puts("Keyfile generator for Kwazy Webbit's Pacme by TSCube 07/05/2000\n");
	printf ("Name : ");
	gets(name);

	if (strlen(name)==0)
	{
		puts("Too lazy to type your name ?");
		return 1;
	}

	if(generate(name)==1)
	{
		puts("Error while creating keyfile 'kwazyweb.bit'");
		return 1;
	}

	puts("Keyfile 'kwazyweb.bit' created !\n");
	puts("<enter> to finish");
	getchar();

	return 0;
}


//////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

int generate(char* name)
{
	FILE* file;
	unsigned char keyfile[100];
	unsigned char magic[18] = 
	{
		0xA9,0xAB,0xA5,0x10,0x54,0x3F,0x30,0x55,0x65,0x16,0x56,0xBE,
		0xF3,0xEA,0xE9,0x50,0x55,0xAF
	};
	char somme;

	somme=0;
	for (unsigned int i=0;i<strlen(name);i++) somme = somme+name[i];

	for (i=0;i<18;i++) magic[i]=magic[i]^somme;
	
	keyfile[0] = strlen(name);

	for (i=0;i<strlen(name);i++) keyfile[i+1] = name[i];
	for (i=0;i<18;i++) keyfile[strlen(name)+1+i] = magic[i];

	file = fopen("kwazyweb.bit","w");

	if (file==NULL) return 1;

	fwrite(keyfile,sizeof(char),strlen(name)+19,file);
	fclose(file);

	return 0;
}



/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
int check(void)
{
	unsigned char keyfile[25] = 
	{
		0x06,'T','S','C','u','b','e',
		0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
		0x0D,0x0E,0x0F,0x10,0x11,0x12
	};


	unsigned char magic[177] = 
	{
		0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
		0x2a,0x2a,0x2a,0x2a,0x43,0x2a,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
		0x2a,0x2e,0x2e,0x2e,0x2a,0x2a,0x2a,0x2a,0x2e,0x2a,0x2e,0x2a,
		0x2a,0x2a,0x2a,0x2e,0x2e,0x2e,0x2a,0x2e,0x2e,0x2e,0x2e,0x2a,
		0x2e,0x2a,0x2e,0x2e,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
		0x2a,0x2a,0x2e,0x2a,0x2e,0x2e,0x2a,0x2e,0x2e,0x2e,0x2e,0x2a,
		0x2e,0x2e,0x2e,0x2a,0x2e,0x2e,0x2e,0x2a,0x2a,0x2e,0x2a,0x2a,
		0x2a,0x2a,0x2e,0x2a,0x2e,0x2a,0x2e,0x2e,0x2e,0x2a,0x2a,0x2a,
		0x2a,0x2e,0x2a,0x2e,0x2e,0x2e,0x2e,0x2a,0x2e,0x2a,0x2a,0x2a,
		0x2a,0x2a,0x2a,0x2a,0x2e,0x2e,0x2a,0x2e,0x2a,0x2a,0x2a,0x2e,
		0x2e,0x2a,0x2e,0x2e,0x2e,0x2e,0x2e,0x2a,0x2e,0x2a,0x2e,0x2e,
		0x2a,0x2a,0x2a,0x2e,0x2a,0x2a,0x2e,0x2a,0x2a,0x2a,0x2e,0x2a,
		0x2e,0x2e,0x2e,0x2a,0x2a,0x2a,0x2a,0x2e,0x2e,0x2e,0x2e,0x2a,
		0x58,0x2e,0x2e,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
		0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x00
	};

	unsigned char* ptrmagic = &magic[16];

	char somme=0;
	for (int i=0;i<keyfile[0];i++) somme = somme+keyfile[i+1];

	for (i=keyfile[0]+1;i<=keyfile[0]+18;i++) keyfile[i]=keyfile[i]^somme;

	for (i=0;i<18;i++)
	{
		int index=keyfile[0]+1;
		int j=8;
		while (j>=0)
		{
			j=j-2;
			char al = keyfile[index+i];
			al = al >> j; // al = al / 2^j
			al = al & 0x03;
			al = al | al;

			unsigned char* ptrmagic_tmp = ptrmagic;
			switch(al)
			{
			case 0:
				ptrmagic = ptrmagic - 16;
				break;
			case 1:
				ptrmagic = ptrmagic+1;
				break;
			case 2:
				ptrmagic = ptrmagic+16;
				break;
			default:
				ptrmagic = ptrmagic-1;
				break;
			};

			if (*ptrmagic==0x2A)
			{
				puts("NOT registered !");
				return 1;
			}

			if (*ptrmagic==0x58) // 'X'
			{
				puts("REGISTERED !!!");
				return 1;
			}

			*ptrmagic=0x43; // 'C'
			*ptrmagic_tmp = 0x20;

		}
	
	}
	
	return 0;

}


