#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "resource.h"

BOOL CALLBACK DialogProc (HWND, UINT, WPARAM, LPARAM) ;
HINSTANCE hInst;
int generate(HWND);

int WINAPI WinMain (HINSTANCE hInstance, 
					HINSTANCE hPrevInstance,
                    PSTR szCmdLine, 
					int iCmdShow)
{
	hInst = hInstance;
	DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_DIALOG1),NULL,(DLGPROC)DialogProc,0);
	return 0;
}


BOOL CALLBACK DialogProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{	

	switch (message)
	{    
	case WM_CLOSE:
		EndDialog(hwnd,0);
		return 1 ;
		break;

	
	case WM_COMMAND:
		 switch (LOWORD(wParam))
		 {
		 case IDC_GENERATE :
			 generate(hwnd);
			 break;
		 
		 case IDC_ABOUT :
			 MessageBox(hwnd,"Keygen template","About",MB_ICONINFORMATION);
			 break;
		 
		 }
		 return 1;
		 break;
		 
	case WM_INITDIALOG:
		RECT DlgRect;
		RECT DesktopRect;
		HWND hwindow;

		SendMessage( hwnd, WM_SETICON, TRUE,(LPARAM)LoadIcon(hInst, MAKEINTRESOURCE(IDI_TSC)));
			 
		// center window (based on source code by Iczelion) :
		GetWindowRect(hwnd,&DlgRect); // retrieves the dimensions of the bounding rectangle of the specified window
		hwindow = GetDesktopWindow(); 
		GetWindowRect(hwindow,&DesktopRect); // returns the handle of the Windows desktop window
			 
		int DlgHeight = DlgRect.bottom - DlgRect.top;
		int DlgWidth = DlgRect.right - DlgRect.left;
		int x=(DesktopRect.right+DesktopRect.left-DlgWidth)/2;
		int y =(DesktopRect.bottom+DesktopRect.top-DlgHeight)/2;
		MoveWindow(hwnd,x,y,DlgWidth,DlgHeight,FALSE);
			 
		return 1 ;
		break;
	 
	}
     return 0;
}


///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////

int generate(HWND hwnd)
{
	char name[100];
	char serial[100];

	GetDlgItemText(hwnd,IDC_NAME,name,100);

	if (strlen(name)==0)
	{
		MessageBox(hwnd,"Please type your name !","Error",MB_ICONEXCLAMATION);
		return 1;
	}

	unsigned int i;
	for (i=0;i<strlen(name);i++) serial[i] = name[i]+1;
	serial[i] = 0x00;

	SetDlgItemText(hwnd,IDC_SERIAL,serial);

	return 0;
}