// Offset Patcher source code
// (C) 20/02/2000 By TSC

#include <windows.h>
#include <string.h>
#include "resource.h"

BOOL CALLBACK DialogProc (HWND, UINT, WPARAM, LPARAM) ;
int patch(HWND);
DWORD getCrc32(HANDLE);

int WINAPI WinMain (HINSTANCE hInstance, 
					HINSTANCE hPrevInstance,
                    PSTR szCmdLine, 
					int iCmdShow)
{
	
	LoadIcon(hInstance,MAKEINTRESOURCE(IDI_PATCHER)); 
	DialogBoxParam(
		hInstance,
		MAKEINTRESOURCE(IDD_DIALOG1),
		NULL,
		(DLGPROC)DialogProc,0);

	return 0;
}


BOOL CALLBACK DialogProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{	
	switch (message)
	{    
	case WM_CLOSE: // close dialogbox
		EndDialog(hwnd,0);
		return 1 ;
          
     case WM_COMMAND:
		 switch (LOWORD(wParam))
		 {
		 case IDC_PATCH : // "patch" button
			 patch(hwnd);
			 break;


		case IDC_ABOUT : // "about" button
			 MessageBox(hwnd,"(C) 07/02/2000 by TSC","Patch for notepad",MB_ICONINFORMATION);
			 break;
		 }
		 return 1;
		 
		 case WM_INITDIALOG:
			 CheckDlgButton(hwnd,IDC_BACKUP,BST_CHECKED);

			 RECT DlgRect;
			 RECT DesktopRect;
			 HWND hwindow;
			 
			 // center window (based on source code by Iczelion) :
			 GetWindowRect(hwnd,&DlgRect); // retrieves the dimensions of the bounding rectangle of the specified window
			 hwindow = GetDesktopWindow(); 
			 GetWindowRect(hwindow,&DesktopRect); // returns the handle of the Windows desktop window
			 
			 int DlgHeight = DlgRect.bottom - DlgRect.top;
			 int DlgWidth = DlgRect.right - DlgRect.left;
			 int x=(DesktopRect.right+DesktopRect.left-DlgWidth)/2;
			 int y =(DesktopRect.bottom+DesktopRect.top-DlgHeight)/2;
			 MoveWindow(hwnd,x,y,DlgWidth,DlgHeight,FALSE);
			 
			 return 1 ;
	 
	}
     return 0;
}


/////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////


int patch(HWND hwnd)
{
	char* szName = "notepad.exe";
	char* szNameBackup = "notepad.exe.bak";
	BYTE patched[4]=   {0x54,0x53,0x43,0x21}; // patched bytes
	LONG offset[4]=    {0x70,0x71,0x72,0x73}; // offsets of bytes to patch
	DWORD number=4; // you can't use strlen() because patch[] may contain several 0x00  !
	DWORD crc32 = 0x5A66BCFE; // crc32 of file

	// check CRC32 of file :
	HANDLE hFile = CreateFile(
		szName,
		GENERIC_READ | GENERIC_WRITE, 
		FILE_SHARE_READ, 
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL);
                    
    if ( hFile == INVALID_HANDLE_VALUE )
    {
        MessageBox(hwnd,"I can't access file notepad.exe !","CRC error",MB_ICONEXCLAMATION);
        return 1;
    }

	if (getCrc32(hFile) != crc32)
	{
		MessageBox(hwnd,"Incorrect version or file already patched !","CRC error",MB_ICONEXCLAMATION);
		CloseHandle(hFile);
		return 1;
	}

	
	// create backup :
	if (IsDlgButtonChecked(hwnd,IDC_BACKUP)==BST_CHECKED)
	{
		
		if (!CopyFile(szName,szNameBackup,FALSE))
		{
			MessageBox(hwnd,"I can't find notepad.exe !","Backup error",MB_ICONEXCLAMATION);
			CloseHandle(hFile);
			return 1;
		}
	}


	// Patch file
	DWORD nbWritten; // not used

 	for (DWORD i=0;i<number;i++)
	{
		SetFilePointer(hFile,offset[i],NULL,FILE_BEGIN); // rewind

		if(!WriteFile(hFile,&patched[i],1,&nbWritten,NULL))
		{
			MessageBox(hwnd,"Error while patching !","Patch aborted",MB_ICONEXCLAMATION);
			CloseHandle(hFile);
			if (IsDlgButtonChecked(hwnd,IDC_BACKUP)==BST_CHECKED) CopyFile(szNameBackup,szName,FALSE);
			return 1;
		}
	}

	CloseHandle(hFile);
	MessageBox(hwnd,"Patch successfull !","Patch",MB_ICONINFORMATION);
	return 1;

}


////////////////////////////////////////////////////////////////
// compute the CRC32 from a file
//
// argument : HANDLE of file
// return value : CRC32 of that file or 0 if error
//
// (based on source code by Craig Bruce (05-Dec-1994))
DWORD getCrc32(HANDLE hFile)
{
	//generate CRC constant table :
	DWORD crcTable[256];
	DWORD crcTmp1;
    
	for (int i=0; i<256; i++)
    {
        crcTmp1 = i;
        for (int j=8; j>0; j--)
        {
            if (crcTmp1&1) crcTmp1 = (crcTmp1 >> 1) ^ 0xEDB88320L;
            else crcTmp1 >>= 1;
        }

        crcTable[i] = crcTmp1;
    }


	//getfilesize :
	DWORD fileSize = GetFileSize(hFile,NULL);
	if (fileSize == 0xFFFFFFFF) return 0;


	//Compute CRC32 : 
	HANDLE hFileMapping = CreateFileMapping(
		hFile,
		NULL,PAGE_READONLY,
		0,
		0,
		NULL);
		
	if (!hFileMapping) return 0;

	BYTE* ptr = (BYTE*)MapViewOfFile(
		hFileMapping,
		FILE_MAP_READ,
		0,
		0,
		0);

	if (!ptr)
	{
		CloseHandle(hFileMapping);
		return 0;
	}

	BYTE* ptr_tmp = ptr; // save base pointer
	DWORD crcTmp2= 0xFFFFFFFF;

	while(fileSize--)
	{
		crcTmp2 = ((crcTmp2>>8) & 0x00FFFFFF) ^ crcTable[ (crcTmp2^(*ptr)) & 0xFF ];
		ptr++;
	}

	UnmapViewOfFile(ptr_tmp);
	CloseHandle(hFileMapping);
	return (crcTmp2^0xFFFFFFFF);
}

