; Authors   : Christoph Gabler
; Procedure : Simple COM dumper
; Date      : 26.3.2000
; Notice    : This tiny generic unpacker should demonstrate the working
;             of the dumping process and the hooking of interrupts.

code segment
org  100h
assume cs:code,ds:code
.386p

OWN_IDT:

Mov Ah, 9
Mov Dx, Offset Message1
Int 21h

Mov Bh, 00
Mov Bl, DS:byte ptr [80h]
Mov DS:byte ptr [81h+Bx], 0
Cmp Bl, 0
Je syntax_error

Mov Ah, 9
Mov Dx, Offset Message3
Int 21h

; [1] - Save old int21h, hook int21h
Push Ds
Push 0
Pop Ds
Mov Ax, DS:word ptr [4*21h]
Mov CS:word ptr [Oldint21], Ax
Mov Ax, DS:word ptr [4*21h+2]
Mov CS:word ptr [Oldint21+2], Ax
Mov DS:word ptr [4*21h], offset INT21_Handler
Mov DS:word ptr [4*21h+2], Cs
Pop Ds

; [2] - Software breakpoint (execute file in order to break after decryption)

                mov     word ptr InfoBlock+2, 80h
                mov     word ptr InfoBlock+4, CS

                mov     word ptr InfoBlock+6, 5Ch
                mov     word ptr InfoBlock+8, CS

                mov     word ptr InfoBlock+10, 6Ch
                mov     word ptr InfoBlock+12, CS

                mov     AX, CS
                cli
                mov     SS, AX
                mov     SP, offset StackStart
                sti

                mov     BX, offset StackStart
                mov     AH, 4Ah
                int     21h

                push    CS
                pop     ES

                mov     CS:[SaveSS], SS
                mov     CS:[SaveSP], SP

                mov     DX, 82h
                mov     BX, offset InfoBlock
                mov     BP, 66h
                mov     AX, 04B00h
                int     21h
                Jc      error_file
                back_error:
Continue:
                cli
                mov     SS, CS:[SaveSS]
                mov     SP, CS:[SaveSP]
                sti

                push    CS
                pop     DS


; [3] - Restore int21h
Push Ds
Push 0
Pop Ds
Mov Ax, CS:word ptr [Oldint21]
Mov DS:word ptr [4*21h], Ax
Mov Ax, CS:word ptr [Oldint21+2]
Mov DS:word ptr [4*21h+2], Ax
Pop Ds

Cmp DS:byte ptr [Dump_eccoured], 0
Jne dump_did_eccour
Mov Ah, 9
Mov Dx, Offset Message6
Int 21h
dump_did_eccour:
Mov Ax, 4C00h
Int 21h

INT21_Handler:
Cmp Ah, 9
Je Avoid_screen
Cmp Ah, 2
Je Avoid_screen
Cmp Ah, 4Ch
Je Dump_process
Cmp Ah, 0
Je Dump_process
Jmp Execute_Old_INT21
Dump_process:
Push Cs
Pop Ds
Mov Ah, 3Ch                   ; create file "unpacked.com"
Xor Cx, Cx                    ; attribute 00000000b
Mov Dx, Offset filename       ; fname
PushF
Call CS:dword ptr [Oldint21]  ; call old INT21h
Mov Di, Ax

Mov Ah, 40h                   ; write to file
Pop Dx                        ; get return IP
Pop Ds                        ; get return CS
Push Ds Dx
Mov Cx, -1                    ; write 65kb
Mov Bx, Di                    ; handle
Mov Dx, 100h                  ; dump from CS:100h
PushF
Call CS:dword ptr [Oldint21]  ; call old INT21h

Mov Ah, 3Eh                   ; close file
Mov Bx, Di                    ; handle
PushF
Call CS:dword ptr [Oldint21]  ; call old INT21h

Mov CS:byte ptr [Dump_eccoured], 1
Push Cs
Pop Ds
Mov Ah, 9
Mov Dx, offset Message5
PushF
Call CS:dword ptr [Oldint21]   ; call old INT21h
Jmp Continue

Execute_Old_INT21:
db 0EAh
Oldint21 dd 0

Avoid_screen: Iret

error_file:
Mov Ah, 9
Mov Dx, Offset Message4
Int 21h
Jmp back_error

syntax_error:
Mov Ah, 9
Mov Dx, Offset Message2
Int 21h
Int 20h

Message1 db 'Simple com file dumper by Christoph Gabler',0Dh,0Ah,'$'
Message2 db 'Usage : Please specify a file to dump!',0Dh,0Ah,'$'
Message3 db 0Dh,0Ah,' Unpacking file...',0Dh,0Ah,'$'
Message4 db 'Error : Could not execute file!',0Dh,0Ah,'$'
Message5 db ' Breakpoint reached',0Dh,0Ah
         db ' Dumping "UNPACKED.COM" to disk... Done!',0Dh,0Ah,'$'
Message6 db 0Dh,0Ah,'Error : No dump eccoured! (propably exit by INT20h)',0Dh,0Ah,'$'

Dump_eccoured   db 0
SaveSP          dw 0
SaveSS          dw 0
Filename        db 'UNPACKED.COM', 0
InfoBlock       dw 0
                dd 0
                dd 0
                dd 0
StackStart      equ $+200h 


Code Ends
End OWN_IDT
