; iceload: NuMega SoftICE helper to load PE DLLs and break on DllMain
;
; usage: iceload [-r]|[-n] file.dll
;        iceload file.exe
;
; the optional -r switch will force the DLL to relocate
; (or not load if it cannot due to lack of relocations)
;
; the optional -n switch will notify SoftICE about the DLL
; but will not load it, instead one should start up the target
; app which uses the DLL. this switch obviously cannot be used
; with -r
;
; 2000/03/03	The Owl		created
; 2000/03/06	G-RoM		added GUI, Code reorganisation
; 2000/03/07	The Owl		fixed exe loading from commandline
; 2000/03/09	G-RoM		Changed NMTrans loading to make nmtrans
;                               preferred imagebase free for DLL to load.
; 2000/03/10	The Owl,G-RoM	-n switch
; 2000/03/10	G-RoM		Added status box writing.
; 2000/03/11	G-RoM		"enhanced" a bit the command line parser.
; 2000/03/14    G-RoM		Optimised rsrc and changed code accordingly.
;				Added some error checking about NMTRANS DLL.
; 2000/03/20	Muffin		added iceload.ini to remember last directory
; 2000/03/21	Muffin		fixed a lil bug which allowed to open non
;				existing file
; 2000/03/21	Muffin		added restore last screen position
; 2000/03/23	G-RoM		Optimizations.
; 2000/03/24	Muffin		added cmd line argument option, load exports
;				and save softice history
; 2000/03/25	Muffin		added Tooltips to Toolbar
; 2000/03/29	The Owl		rewrite + bugfixes
; 2000/05/02	Muffin		added keyboard acclerators, hey ho the_rain :)
;				CTRL+O = Open PE
;				CTRL+X = Exit
;				CTRL+R = Run
;				CTRL+L = Load exports
;				CTRL+S = Save SI history
;				CTRL+A = About
; 2000/11/14	The Owl		fixed HandleDLL (GetCommandLineA trashes ecx)
; 2001/02/17	The Owl		handle long file name for target

		BITS 32
		%include "win32n.inc"
		%include "kernel32.inc"
		%include "user32.inc"
		%include "comctl32.inc"
		%include "comdlg32.inc"

		%include "iceload.inc"

		%include "nmtrans.inc"

;
; global Definitions
;
global _main

;
 SEGMENT .bss 	USE32 CLASS=BSS
;
Pstart		RESB	STARTUPINFO_size
Pinfo		RESB	PROCESSINFORMATION_size
oReloc		RESD	1
oBase		RESD	1
fCmdArgs	RESD	1
fIsMinimized	RESD	1
filename        RESD    1
modinfo		RESB	ModuleLoadRecord_size
BlockHeader     RESB    0x1000
__Source        RESB    256
HexBuffer       RESB    16
IniDirBuffer	RESB	256
;
Align 4
;
hInst		RESD	1
hToolBar        RESD    1
hMain		RESD	1
hAccel		RESD	1
IL_wc		RESB	WNDCLASSEX_size
IL_msg		RESB	MSG_size
IL_ofn		RESB	OPENFILENAME_size
IL_ButtonBar	RESB	TBBUTTON_size*9
;


;
 SEGMENT .data	USE32 CLASS=DATA
;
HTable                  DB      '0123456789ABCDEF',0
;
strFilter		DB	'Executable Files',0,'*.exe;*.dll',0
                        DB      'All files',0,'*.*',0,0
strTitle		DB	'Choose Executable..',0
strDefExt		DB	'*.exe',0
strFilter2		DB	'Log Files',0,'*.log;*.txt',0
                        DB      'All files',0,'*.*',0,0
strDefLogExt		DB	'*.log',0
;
CR_LF                   DB      0Dh,0Ah,0h
LoadedFile		DB	'Loaded ',0
NotifiedWinice		DB	'SoftICE Notified',0
Running                 DB      'Running ',0
Missing			DB	' is missing or target is not a PE !!', 0
strExpLoaded		DB	'Exports loaded for: ',0
strErrExpLoaded		DB	'Error loading exports !!',0
strSiHistSaved		DB	'SoftICE history saved',0
strErrSiHistSaved	DB	'Error saving SoftICE history !!',0

;
NMLIB                   DB      'NMTRANS.DLL',0
NMLoadRecord		DB	'NmSymGetModuleLoadRecord',0
NMSetBreak		DB      'DevIO_SetWLDRBreak',0
NMLoadExports		DB      'NmSymLoadExports',0
NMCreateLog		DB      'NmSymCreateLogFile',0
;
IL_Class:
strAppName		DB	'iceload',0
strIniFile		DB	'iceload.ini',0
strLastFile		DB	'LastFile',0
strLastDir		DB	'LastDir',0
strLastPos		DB	'LastPos',0
;
strTTOpenFile		DB	'Open PE file', 0
strTTRun		DB	'Load/Run PE file',0
strTTLoadExports	DB	'Load DLL exports',0
strTTSaveHist		DB	'Save SoftICE history',0
strExit			DB	'No you wont hit this button now :)', 0
strAbout		DB	'About', 0

TT_Strings_Table:
pszTTOpenFile		DD	strTTOpenFile
pszTTRun		DD	strTTRun
pszTTAbout		DD	strAbout
pszTTExit		DD	strExit
pszTTLoadExports	DD	strTTLoadExports
pszTTSaveHist		DD	strTTSaveHist

;

 SEGMENT .text USE32 CLASS=CODE
;
_main:
	call	ParseCmdLine
	cmp	dword [filename],byte 0
	jz	GUI

	push	dword [filename]
	call	InitNmTransData
	test	eax,eax
	jz	.exit

	cmp	dword [modinfo+ModuleLoadRecord.Type],byte 2
	jz	.exe

	call	HandleDLL
	jmp	short .exit

.exe:
	push	dword [filename]
	call	LaunchEXE

.exit:
	push	byte 0
	call	ExitProcess


;
;Gui Code.
;
;
;
GUI:
	call	InitCommonControls	; Force COMCTL32 Import

	push	byte 0
	call	GetModuleHandleA
	mov	[hInst], eax
	
	call	InitGUI
	test	eax,eax
	jz	_main.exit

.msg_loop:
	xor	eax, eax
	push	eax
	push	eax
	push	eax
	push	dword IL_msg
    	call 	GetMessageA
	test	eax, eax
	jz	_main.exit

	push	dword IL_msg
	push	dword [hAccel]
	push	dword [hMain]
	call	TranslateAcceleratorA
	test	eax, eax
	jnz	.msg_loop

	push	dword IL_msg
	push	dword [hMain]
	call	IsDialogMessage
	test	eax, eax
	jnz	.msg_loop
	
	push	dword IL_msg
    	call 	TranslateMessage

	push	dword IL_msg
    	call 	DispatchMessageA
	jmp	short .msg_loop


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
InitGUI:
	mov	[IL_wc+WNDCLASSEX.hInstance], eax
	mov	dword [IL_wc+WNDCLASSEX.cbSize], WNDCLASSEX_size
	mov	dword [IL_wc+WNDCLASSEX.style], CS_HREDRAW + CS_VREDRAW
	mov	dword [IL_wc+WNDCLASSEX.lpfnWndProc], DlgProc
	mov	dword [IL_wc+WNDCLASSEX.cbClsExtra],0
	mov	dword [IL_wc+WNDCLASSEX.cbWndExtra],DLGWINDOWEXTRA

; load main icon from resource
	push	dword ICON_MAIN
	push	eax
	call 	LoadIconA
	mov	[IL_wc+WNDCLASSEX.hIcon], eax
	mov	[IL_wc+WNDCLASSEX.hIconSm], eax

; load a default cursor
	push	dword IDC_ARROW
	push	byte 0
  	call 	LoadCursorA
	mov	[IL_wc+WNDCLASSEX.hCursor], eax
	mov	dword [IL_wc+WNDCLASSEX.hbrBackground], COLOR_WINDOW
	mov	dword [IL_wc+WNDCLASSEX.lpszMenuName], 0
	mov	dword [IL_wc+WNDCLASSEX.lpszClassName], IL_Class

	push	dword IL_wc
	call 	RegisterClassExA
	test	eax, eax
	jnz	.1

	retn

.1:
	xor	eax, eax
	push	eax
	push	eax
	push	eax
	push	dword IL_Class
	push	dword [hInst]
	call	CreateDialogParamA
	mov	[hMain], eax		; We have now owner

	mov	eax, IL_ButtonBar
	mov	[eax+0*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
 	mov	[eax+0*TBBUTTON_size+TBBUTTON.fsStyle], byte TBSTYLE_SEP     ; Type

	mov	[eax+1*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
 	mov	[eax+1*TBBUTTON_size+TBBUTTON.idCommand], dword IL_OPEN      ; Type

	mov	[eax+2*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
 	mov	[eax+2*TBBUTTON_size+TBBUTTON.fsStyle], byte TBSTYLE_SEP     ; Type

	mov	[eax+3*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
 	mov	[eax+3*TBBUTTON_size+TBBUTTON.idCommand], dword IL_RUN       ; Type
	mov	[eax+3*TBBUTTON_size+TBBUTTON.iBitmap], byte 1

	mov	[eax+4*TBBUTTON_size+TBBUTTON.idCommand], dword IL_LOAD_EXP  ; Type
	mov	[eax+4*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
	mov	[eax+4*TBBUTTON_size+TBBUTTON.iBitmap], byte 4

	mov	[eax+5*TBBUTTON_size+TBBUTTON.idCommand], dword IL_SAVE_SIHIST  ; Type
	mov	[eax+5*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
	mov	[eax+5*TBBUTTON_size+TBBUTTON.iBitmap], byte 5

	mov	[eax+6*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
 	mov	[eax+6*TBBUTTON_size+TBBUTTON.fsStyle], byte TBSTYLE_SEP     ; Type

 	mov	[eax+7*TBBUTTON_size+TBBUTTON.idCommand], dword IL_ABOUT     ; Type
	mov	[eax+7*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
	mov	[eax+7*TBBUTTON_size+TBBUTTON.iBitmap], byte 2

	mov	[eax+8*TBBUTTON_size+TBBUTTON.idCommand], dword IL_EXIT      ; Type
	mov	[eax+8*TBBUTTON_size+TBBUTTON.fsState], byte TBSTATE_ENABLED ; State
	mov	[eax+8*TBBUTTON_size+TBBUTTON.iBitmap], byte 3

	push	byte TBBUTTON_size
	push	byte 16
	push	byte 16
	push	byte 16
	push	byte 16
	push	byte 09
	push	dword IL_ButtonBar
	push	dword IL_TOOLBAR
	push	dword [hInst]
	push	byte 04
	push	byte 00
	push	dword TBSTYLE_TOOLTIPS+WS_CHILD
	push	dword [hMain]
	call	CreateToolbarEx
	mov	[hToolBar], eax

	push	byte TRUE
	push	eax
	call	ShowWindow

	push	byte  FALSE
	push	dword IL_RUN
	push	dword TB_ENABLEBUTTON
	push	dword [hToolBar]
	call	SendMessageA

	push	dword IDR_ACCELERATOR
	push	dword [hInst]
	call	LoadAcceleratorsA
	mov	[hAccel], eax

	xor	eax, eax
	inc	eax

	retn


;-------------------------------------------------------------------------------
; cmdline parsing
; 1. find end of own file name
; 2. extract dll/exe file name from the end of the command line
; 3. if found and it's a DLL check for cmdline switches
;-------------------------------------------------------------------------------
ParseCmdLine:
	push	ecx
	push	edi

	call	GetCommandLineA
	mov	edi,eax
	mov	al,[edi]
	or	ecx,byte -1
	cmp	al,'"'			; long file name?
	jnz	.find_tail

	inc	edi
	repnz	scasb			; find terminating "
	dec	edi

.find_tail:
	inc	edi
	cmp	[edi],byte 0
	jz	.ret

	cmp	[edi],byte ' '
	jnz	.find_tail

	xor	eax, eax
	lea	ecx,[eax-1]
	repnz	scasb
	not	ecx
	dec	ecx

	dec	edi
	dec	edi			; edi: last char of cmdline
	mov	al,' '
	std				; search backwards
	repe	scasb			; find space at the end of the cmdline

	cmp	byte [edi+1],'"'	; long file name for target?
	jnz	.short_name

	mov	byte [edi+1],al
	mov	al,'"'
	
.short_name:
	repne	scasb			; find space separating params
	cld
	jne	.ret

	inc	edi
	inc	edi			; edi: beginning of the file name

	mov	[filename],edi

.ret:
	pop	edi
	pop	ecx
	retn


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
InitNmTransData:
	push	ebp
	mov	ebp, esp
	sub	esp, 4
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx

	push	dword NMLIB
	call	LoadLibraryA            ; Load NMTrans
	test	eax, eax
	jz	near .exit

	mov	[ebp-4], eax

	push	dword NMLoadRecord
	push	dword [ebp-4]
	call	GetProcAddress          ; Get GetModuleRecord Address
	test	eax, eax
	jz      .freeexit

	push	dword modinfo
	push    dword [ebp+08h]
	call	eax			; _NmSymGetModuleLoadRecord
	add	esp,byte 8
	test	eax,eax
	jz	.freeexit

; see what sort of file it is, we're using nmtrans and its IDs
; 2: PE exe
; 3: PE dll
; then we notify softice to watch for this dll load and to break at DllMain
	mov	ebx,[modinfo+ModuleLoadRecord.Type]
	cmp	ebx,byte 2		; exe?
	jz	.EXE

	xor	eax, eax
	cmp	ebx,byte 3		; dll?
	jnz	.freeexit

.EXE:
	movzx	ebx,word [modinfo+0x134]
	push	ebx
	push	byte 1			; flag: set BPX on entry point
	movzx	eax,word [modinfo+0x132]
	push	eax
	push	dword [modinfo+ModuleLoadRecord.EntryRVA]
	push	dword modinfo+ModuleLoadRecord.ModName
	push	dword NMSetBreak
	push	dword [ebp-4]
	call	GetProcAddress		; Get SetBreakPoint Address
	test	eax, eax
	jz	.freeexit

	call	eax			; _DevIO_SetWLDRBreak
	add	esp, byte 5*4
	xor	eax, eax
	inc	eax

.freeexit:
	push	eax
	push	dword [ebp-4]
	call	FreeLibrary		; Free NmTrans
	pop	eax

.exit:
	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	add	esp, byte 4
	pop	ebp
	retn	04h


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
HandleDLL:
	push	ecx
	push	edi

; check for optional -r switch and allocate (reserve) memory at the dll's
; base so that it will have to be relocated
	call	GetCommandLineA
	mov	edi,[filename]
	mov	ecx,edi
	sub	ecx,eax
	mov	al,'-'
	std
	repnz	scasb
	cld
	xor	eax, eax
	jecxz	.load

	cmp	dword [edi],' -r '
	jnz	.noreloc

	push	dword BlockHeader
	push	dword [filename]
	call	GrabHeader

	push	dword BlockHeader
	call	CheckPE
	add	eax, BlockHeader
	mov	eax, [eax+34h]		; ImageBase
	jmp	short .load

.noreloc:
; check for optional -n switch and exit if specified, this way we will have
; notified softice by now but will not load the DLL ourselves thus won't
; trigger the BPX set by softice. instead the user should start up an app
; that loads his target DLL and off he goes...
	cmp	dword [edi],' -n '
	jz	.ret

; here should come some dire warning about bad cmdline... oh well, next time

.load:
	push	eax
	push	dword [filename]
	Call	LoadDLL

.ret:
	pop	edi
	pop	ecx
	retn


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
LoadDLL:
	push	ebp
	mov	ebp, esp
	sub	esp, byte 4
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx

	xor	eax, eax
	mov	[ebp-4], eax
	cmp	dword [ebp+0Ch], byte 0
	jz	.noreloc

	push	byte PAGE_NOACCESS
	push	dword MEM_RESERVE
	push	dword 0x1000
	push	dword [ebp+0Ch]
	call	VirtualAlloc
	mov	[ebp-4], eax

.noreloc:
	push	dword [ebp+08h]
	call	LoadLibraryA

	push	eax
	call	FreeLibrary

	cmp	dword [ebp-4],byte 0
	jz	.exit

	push	dword MEM_RELEASE
	push	byte 0
	push	dword [ebp-4]
	call	VirtualFree
.exit:
	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	add	esp, byte 4
	pop	ebp
	retn	08h


;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
LaunchEXE:
	push	ebp
	mov	ebp,esp
	sub	esp, dword 256
	push	edi

	lea	edi, [ebp - 256]
	push	dword [ebp+8]
	push	edi
	call	lstrcpyA			;copy path+exe to buff

	cmp	byte [fCmdArgs], 1		;cmd arg checkbox checked?
	jnz	near .no_cmdargs

	push	edi
	call	lstrlenA

	lea	edi, [edi +  eax ]		;point to end of buff
	mov	dword [edi], ' '
	inc 	edi

	lea	eax, [eax - 255]
	neg	eax				;calc max chars
	push	eax
	push	edi
	push	dword IL_ARGUMENTS
	push	dword [ebp+40]
	call	GetDlgItemTextA

.no_cmdargs:
	mov	dword [Pstart+STARTUPINFO.cb], STARTUPINFO_size
	xor	eax, eax
	lea	edi, [ebp - 256]

	push 	dword Pinfo
	push	dword Pstart
	push 	eax
	push 	eax
	push 	byte 30h
	push 	eax
	push 	eax
	push 	eax
	push 	edi				;[ebp+8]
	push 	eax
	call 	CreateProcessA

	pop	edi
	add	esp, dword 256
	pop	ebp
	retn	4


;-------------------------------------------------------------------------------
;esp+4 : hwnd:DWORD
;esp+8 : wmsg:DWORD
;esp+c : wparam:DWORD
;esp+10: lparam:DWORD
;-------------------------------------------------------------------------------
DlgProc:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx

	mov	eax, [ebp+0Ch]

	cmp	eax, byte WM_CREATE
	jz	.wmcreate

	cmp     eax, WM_COMMAND  	; Control used ?
	jz      near .wmcommand

	cmp	eax, byte WM_DESTROY	; Window closed ?
	jz	near .wmdestroy

	cmp	eax, byte WM_CLOSE	; Window closed ?
	jz	near .wmclose

	cmp	eax, WM_SIZE
	jz	near .wm_size
	
	cmp	eax, WM_NOTIFY
	jz	near .wm_notify
	jmp	near .ReturnZERO

.wmcreate:
	push	dword [ebp+08]
	call	CenterWindow

	push	dword [ebp+08]
	call	RestoreLastPos
	call	GetLastFile

 	mov	dword [IL_ofn+OPENFILENAME.lStructSize], OPENFILENAME_size
	mov	eax, [ebp+08h]
	mov	[IL_ofn+OPENFILENAME.hwndOwner], eax
	mov	eax, [hInst]
	mov	[IL_ofn+OPENFILENAME.hInstance], eax
	mov	dword [IL_ofn+OPENFILENAME.lpstrFilter], strFilter
	mov	dword [IL_ofn+OPENFILENAME.lpstrFile], __Source
	mov	dword [IL_ofn+OPENFILENAME.nMaxFile], 256
	mov	dword [IL_ofn+OPENFILENAME.Flags], OFN_HIDEREADONLY | OFN_FILEMUSTEXIST
	mov	dword [IL_ofn+OPENFILENAME.lpstrDefExt], strDefExt
	xor	eax, eax
	mov	[oBase], eax
	mov	[oReloc], eax
	jmp	.ReturnZERO

.wmcommand:
	movzx	eax, word [ebp+10h]
	
	cmp	eax, IL_OPEN
	jz	.ilc_open

	cmp	eax, IL_RUN
	jz	near .ilc_run

	cmp	eax, IL_LOAD_EXP
	jz	near .ilc_loadexp

	cmp	eax, IL_SAVE_SIHIST
	jz	near .ilc_save_sihist

	cmp	eax, IL_EXIT
	jz	near .ilc_exit

	cmp	eax, IL_ABOUT
	jz	near .ilc_about

	cmp	eax, IL_RELOC
	jz	near .ilc_reloc

	cmp	eax, IL_CKB_ARGS
	jz	near .ilc_args
	jmp	near .ReturnZERO

.wm_notify:
	push	dword [ebp+14h]		;lparam
	call	SetToolbarTTs
	jmp	near .ReturnZERO

.ilc_open:
	push	dword IL_ofn
	call	GetOpenFileNameA
	test	eax, eax
	jz	near .ReturnZERO

	push	dword __Source
	Call	InitNmTransData
	test	eax, eax
	jz	near .Err_nmtrans

	call	UpdateIni

	push	byte 0
	push	dword LoadedFile
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	byte 1
	push	dword __Source
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	dword BlockHeader
	push	dword __Source
	call	GrabHeader

	push	dword BlockHeader
	call	CheckPE
	add	eax, BlockHeader
	mov	eax, [eax+34h]		; ImageBase
	mov	[oBase], eax

	push	dword HexBuffer
	push	dword [oBase]
	call	Dword2Hex

	push	dword HexBuffer
	push	dword IL_RELOCBASE
	push    dword [ebp+08h]
	call	SetDlgItemTextA

	push	byte 1
	push	dword NotifiedWinice
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	byte  TRUE
	push	dword IL_RUN
	push	dword TB_ENABLEBUTTON
	push	dword [hToolBar]
	call	SendMessageA

	push	dword IL_RELOC
	push    dword [ebp+08h]
	call	GetDlgItem

	mov	bl, [modinfo+ModuleLoadRecord.Type]

	push	byte 02h
	xor	byte [esp], bl
	push	eax
	call	EnableWindow

	push	dword IL_CKB_ARGS
	push    dword [ebp+08h]
	call	GetDlgItem

	push	byte 03h
	xor	byte [esp], bl
	push	eax
	call	EnableWindow
	jmp	.ReturnZERO

.ilc_exit:
	jmp	.wmclose

.ilc_loadexp:
	push	dword [ebp+08h]
	call	LoadExports
	jmp	.ReturnZERO

.ilc_save_sihist:
	push	dword [ebp+08h]
	call	SaveSIHist
	jmp	.ReturnZERO

.ilc_run:
	push	byte  0
	push	dword IL_RUN
	push	dword TB_GETSTATE
	push	dword [hToolBar]
	call	SendMessageA

	cmp	eax, TBSTATE_ENABLED
	jnz	near .ReturnZERO

	push	dword __Source
	Call	InitNmTransData
	test	eax, eax
	jz	near .Err_nmtrans

	push	byte 0
	push	dword Running
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	byte 1
	push	dword __Source
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	cmp	byte [modinfo+ModuleLoadRecord.Type], 3
	jz	.DealWithDLL

	cmp	byte [modinfo+ModuleLoadRecord.Type], 2
	jnz	near .ReturnZERO

	push 	dword __Source
	call	LaunchEXE
	jmp	.ReturnZERO

.DealWithDLL:
	mov	dword [oBase], 0
	cmp	byte [oReloc], 1
	jnz	.NoReloc

	push	byte 16
	push	dword HexBuffer
	push	dword IL_RELOCBASE
	push    dword [ebp+08h]
	call	GetDlgItemTextA

	push	dword HexBuffer
	call	Hex2Dec
	mov	[oBase], eax

.NoReloc:
	push	dword [oBase]
	push	dword __Source
	call	LoadDLL
	jmp	.ReturnZERO

.ilc_about:
	push	byte 0
	push	dword AboutProc
	push	dword [ebp+8]
	push	dword ILABOUT
	push	dword [hInst]
	call    DialogBoxParamA

	push	dword [ebp+8]
	call	UpdateWindow
	jmp	.ReturnZERO

.ilc_reloc:
	xor	dword [oReloc], byte 1

	push	dword IL_RELOCBASE
	push    dword [ebp+08h]
	call	GetDlgItem

	push	dword [oReloc]
	push	eax
	call	EnableWindow
	jmp	.ReturnZERO

.ilc_args:
	xor	dword [fCmdArgs], byte 1

	push	dword IL_ARGUMENTS
	push    dword [ebp+08h]
	call	GetDlgItem

	push	dword [fCmdArgs]
	push	eax
	call	EnableWindow
	jmp	.ReturnZERO

.Err_nmtrans:
	push	byte 0
	push	dword NMLIB
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	byte 1
	push	dword Missing
	push	dword IL_STATUS
	push	dword [ebp+08h]
	Call	TextBoxWrite

	push	byte  FALSE
	push	dword IL_RUN
	push	dword TB_ENABLEBUTTON
	push	dword [hToolBar]
	call	SendMessageA
	jmp	.ReturnZERO

.wm_size:
	mov	byte [fIsMinimized], 0
	cmp	word [ebp+10h], SIZE_MINIMIZED
	jnz	.ReturnZERO

	mov	byte [fIsMinimized], 1
	jmp	.ReturnZERO

.wmclose:
	push	dword [ebp+08h]
	call	SaveCurrentPos			;save screen pos to ini

	push	byte 0
	push	dword [ebp+08h]
	call	EndDialog

.wmdestroy:
	push	byte 0
	call	PostQuitMessage

.ReturnZERO:
	push	dword [ebp+14h]
 	push	dword [ebp+10h]
 	push	dword [ebp+0Ch]
 	push	dword [ebp+08h]
	call	DefWindowProcA

.EndDlgProc:
	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	pop	ebp
	retn	10h


AboutProc:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx

	mov	eax, [ebp+0Ch]

	cmp	eax, WM_INITDIALOG
	jz	.AboutCreate

	cmp	eax, WM_COMMAND
	jnz	.Default

	mov	eax, [ebp+10h]
	cmp	eax, IDBOK
	jz 	.AboutEnd

	cmp	eax, byte IDOK
	jz 	.AboutEnd

	cmp	eax, byte IDCANCEL
	jnz 	.Default

.AboutEnd:
	push	byte TRUE
	push	dword [ebp+08h]
	call	EndDialog
	xor	eax, eax
	inc	eax
	jmp	.Return

.AboutCreate:
	push	dword [ebp+08h]
	call	CenterWindow
	jmp	.Return

.Default:
      	xor     eax, eax

.Return:
	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	pop	ebp
	retn	10h


;
; Convert an hexstring to dword value.
;

;
;esp+4 : String hex To convert
;
;eax=HEX value
;
Hex2Dec:
	push	esi
	push	edx

	mov	esi, [esp+04+08h]
	xor	edx, edx

HexConvert:
	xor	eax, eax
	lodsb
	test	eax, eax
	jz	EndHex2Dec

	sub	al, '0'
	cmp	al, 9h
	jle	WasDigit

	sub	al, 'A'-('0'+0Ah)

WasDigit:
	shl	edx, 4
	add	edx, eax
	jmp	short HexConvert

EndHex2Dec:
	mov	eax, edx

	pop	edx
	pop	esi
	retn	04h


;
; Convert a Dword to its Hex String.
;

;
;esp+4 : Value to Convert.
;esp+8 : Buffer where to Store.
;
Dword2Hex:
	push	edi
	push	ecx
	push	ebx

	mov	eax, [esp+04h+0Ch]
	mov	edi, [esp+08h+0Ch]

 	mov	ecx,4
 	xor	ebx,ebx

Convert_it:
 	rol	eax,8      ; rotate 8 bits
 	push	eax
 	xor	bh,bh
 	mov	bl,al
 	mov	dl,al
 	shr	bl,4
 	mov	al,[ebx+HTable]
 	stosb
 	mov	bl,dl
 	and	bl,0Fh
 	mov	al,[ebx+HTable]
 	stosb
 	pop	eax
 	dec	ecx
 	jnz	Convert_it

	pop	ebx
	pop	ecx
	pop	edi
	retn	08h


;
; Center the given window on the screen.
;
CenterWindow:
	push	ebp
	mov	ebp, esp
	sub	esp, byte RECT_size
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx

	call	GetDesktopWindow

	lea	edi, [ebp-RECT_size]
	push	edi
	push	eax
	call	GetWindowRect

	push	dword [edi+RECT.right]
	push	dword [edi+RECT.bottom]

	push	edi
	push	dword [ebp+08h]
	call	GetWindowRect

	mov	eax, [edi+RECT.bottom]
	sub	eax, [edi+RECT.top]
	pop	ecx
	sub	ecx, eax	           ; save EAX
	shr	ecx, 1

	mov	ebx, [edi+RECT.right]
	sub	ebx, [edi+RECT.left]
	pop	edx
	sub	edx, ebx
	shr	edx, 1

	push	byte TRUE
	push	eax
	push	ebx
	push	ecx
	push	edx
	push	dword [ebp+08h]
	call	MoveWindow

	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	add	esp, byte RECT_size
	pop	ebp
	retn	04h


;
; Write to TextBox.
;

;
;esp+4 : hwnd.
;esp+8 : TextBox ID.
;esp+c : String
;esp+10: \n or not
;
TextBoxWrite:
	push	ebp
	mov	ebp, esp
	sub	esp, byte 4
	pushad

	push	dword [ebp+0Ch]
	push	dword [ebp+08h]
	Call	GetDlgItem
	mov	[ebp-4], eax

	push	eax
	call	GetWindowTextLengthA	; Get edit text length

	push	eax
	push    eax
	push    dword EM_SETSEL
	push    dword [ebp-4]
	call    SendMessageA		; Set Caret to last char

	push    dword [ebp+10h]
	push    byte FALSE
	push    dword EM_REPLACESEL
	push    dword [ebp-4]
	call    SendMessageA		; Append new text

	push	dword [ebp-4]
	call	SetFocus		; Set Focus to Edit Child

	cmp	[ebp+14h], byte 1       ; Add Return chars ?
	jnz	.EndTextWrite

	push	byte 0
	push	dword CR_LF
	push	dword [ebp+0Ch]
	push	dword [ebp+08h]
	call	TextBoxWrite

.EndTextWrite:
	popad
	add	esp, byte 4
	pop	ebp
	ret  	10h


; utility functions to check/load PE headers
;
;Grab PE header.
;

;
;esp+4 : FileName
;esp+8 : hPEBuffer
;
;eax=1, 0 otherwise.
;
GrabHeader:
	push	ebp
	mov	ebp, esp
	sub	esp, byte 4
	push	esi
	push	edi
	push	ecx
	push	edx
	push	ebx
;
; Open file.
;
	xor	eax, eax
	push 	eax
	push 	eax
	push 	byte OPEN_EXISTING
	push 	eax
	push 	byte FILE_SHARE_READ
	push 	dword GENERIC_READ
	push 	dword [ebp+08h] 		; offset FileName
	call 	CreateFileA			; open file in read/write mode
	inc	eax
	jz	.EndReal

	dec	eax

	push 	eax			; Save Handle
;
; Read 1024 bytes (grab header).
;
	push 	byte 0
	lea	ebx, [ebp-4]
	push 	ebx
	push 	dword 1000h
	push 	dword [ebp+0Ch]
	push 	eax
	call 	ReadFile
	pop	ebx
	push	eax

;
; Close File.
;
	push	ebx
	call 	CloseHandle			; Close File
	pop	eax

.EndReal:
	pop	ebx
	pop	edx
	pop	ecx
	pop	edi
	pop	esi
	add	esp, byte 4
	pop	ebp
	retn  	08h


;
; Check if buffer contains a Valid PE structure.
;

;
;esp+4 : buffer
;
;eax contains PE start on success, 0 otherwise.
;
CheckPE:
	push 	esi

	mov  	esi, [esp+04h+04h]	; Load buffer

	xor  	eax, eax
	cmp  	word [esi], 'MZ'       	; check MZ sig.
	jnz  	.EndCheckPE

	push 	esi
  	add  	esi, byte 3ch
	lodsd
  	pop  	esi
  	cmp  	word [esi+eax], 'PE'    ; check  PE signature
  	jz   	.EndCheckPE

	xor  	eax, eax

.EndCheckPE:
	pop  	esi
	retn	04h


;iceload.ini stuff.
;
; GetLastFile: reads LastFile and LastDir from %windir%\iceload.ini
;
GetLastFile:
	push	ebp
	mov	ebp, esp
	pushad

	push	dword strIniFile		;iceload.ini
	push	dword 256
	push	dword __Source
	push	byte 0				;defstring
	push	dword strLastFile		;"LastFile"
	push	dword strAppName		;"iceload"
	call	GetPrivateProfileStringA

	push	dword strIniFile		;iceload.ini
	push	dword 256
	push	dword IniDirBuffer
	push	byte 0				;defstring
	push	dword strLastDir		;"LastDir"
	push	dword strAppName		;"iceload"
	call	GetPrivateProfileStringA
	test	eax, eax
	jz	.EndGetLastFile

	mov	dword [IL_ofn+OPENFILENAME.lpstrInitialDir], IniDirBuffer

.EndGetLastFile:

	popad
	pop	ebp
	ret


;
; UpdateIni: writes LastFile and LastDir to %windir%\iceload.ini
;
UpdateIni:
	push	ebp
	mov	ebp, esp
	pushad

	push	dword __Source			;fullpath+filename
	call	lstrlenA
	mov	ecx, eax
	mov	edi, dword __Source
	add	edi, eax
	mov	al,'\'
	std
	repnz	scasb				;reverse scan for '\'
	cld
	mov	edi, dword __Source + 2
	add	edi, ecx			;edi = file w/o path

	push	ecx				;save pos

	push	dword strIniFile		;iceload.ini
	push	edi
	push	dword strLastFile		;"LastFile"
	push	dword strAppName		;"iceload"
	call	WritePrivateProfileStringA

	pop	ecx
	mov	al, [__Source + 2 + ecx]
	mov	byte [__Source + 2 + ecx],0	;replace 1. letter of filename w/ 0
	push	eax
	push	ecx

	push	dword strIniFile		;iceload.ini
	push	dword __Source
	push	dword strLastDir		;"LastDir"
	push	dword strAppName		;"iceload"
	call	WritePrivateProfileStringA

	pop	ecx
	pop	eax
	mov	[__Source + 2 + ecx],al		;restore 1. letter

	popad
	pop	ebp
	ret


;
; SaveCurrentPos: writes LastPos of dialog to %windir%\iceload.ini
;

SaveCurrentPos:
	push	ebp
	mov	ebp, esp
	sub	esp, byte RECT_size + 20
	pushad

	cmp	byte [fIsMinimized], 1
	jz	near .EndSaveCurrentPos

	lea	esi, [ebp-RECT_size]
	push	esi
	push	dword [ebp+08h]
	call	GetWindowRect

	lea	edi, [ebp-RECT_size-20]

	push	edi					;buffer
	push	dword [esi+RECT.left]
	call	Dword2Hex
	mov	byte [edi+8], ','
	add	edi, byte 9

	push	edi					;buffer
	push	dword [esi+RECT.top]
	call	Dword2Hex
	mov	byte [edi+8], 0

	lea	edi, [ebp-RECT_size-20]
	push	dword strIniFile			;iceload.ini
	push	edi
	push	dword strLastPos			;"LastPos"
	push	dword strAppName			;"iceload"
	call	WritePrivateProfileStringA

.EndSaveCurrentPos:
	popad
	add	esp, byte RECT_size + 20
	pop	ebp
	retn	04h


;
; RestoreLastPos: reads LastPos from %windir%\iceload.ini and moves dlg
;

RestoreLastPos:
	push	ebp
	mov	ebp, esp
	sub	esp, byte RECT_size + 20
	pushad

	lea	edi, [ebp-RECT_size-20]
	push	dword strIniFile		;iceload.ini
	push	byte 18
	push	edi
	push	byte 0				;defstring
	push	dword strLastPos		;"LastDir"
	push	dword strAppName		;"iceload"
	call	GetPrivateProfileStringA
	test	eax, eax
	jz	.EndRestorePos

	lea	edi, [ebp-RECT_size]
	lea	esi, [ebp-RECT_size-20]

	mov	byte [esi +  8], 0
	push	esi
	call	Hex2Dec
	mov	dword [edi+RECT.left], eax

	add	esi, byte 9
	mov	byte [esi +  8], 0
	push	esi
	call	Hex2Dec
	mov	dword [edi+RECT.top], eax


	lea	edi, [ebp-RECT_size]
	push	byte TRUE
	push	dword 257
	push	dword 390
	push	dword [edi+RECT.top]
	push	dword [edi+RECT.left]
	push	dword [ebp+08h]
	call	MoveWindow

.EndRestorePos:
	popad
	add	esp, byte RECT_size + 20
	pop	ebp
	retn	04h


;
; LoadExports: loads exports of a pe to winice
;
%define hDlg 	 		ebp + 8
%define hNMLib 			ebp - 4
%define strFname 		ebp - (4 + 256)
%define ofn  	 		ebp - (4 + 256 + OPENFILENAME_size)
LoadExports:
	push	ebp
	mov	ebp, esp
	sub	esp, dword (4 + 256 + OPENFILENAME_size)	;func ptr + buff + ofn struct

	lea	esi, [ofn]					;OPENFILENAME struct
	mov	edi, esi
	mov	ecx, (OPENFILENAME_size+256)
	xor	eax,eax
	rep	stosb

	lea	edi, [strFname]					;str buff

 	mov	dword [esi+OPENFILENAME.lStructSize], OPENFILENAME_size
	mov	eax, [hDlg]
	mov	[esi+OPENFILENAME.hwndOwner], eax
	mov	eax, [hInst]
	mov	[esi+OPENFILENAME.hInstance], eax
	mov	dword [esi+OPENFILENAME.lpstrFilter], strFilter
	mov	dword [esi+OPENFILENAME.lpstrFile], edi
	mov	dword [esi+OPENFILENAME.nMaxFile], 256
	mov	dword [esi+OPENFILENAME.Flags], OFN_HIDEREADONLY | OFN_FILEMUSTEXIST
	mov	dword [esi+OPENFILENAME.lpstrDefExt], strDefExt

	push	esi
	call	GetOpenFileNameA
	test	al, al
	jz	near .EndLoadExp

	push	dword NMLIB
	call	LoadLibraryA            ;load nmtrans.dll
	test	eax, eax
	jz	near .EndLoadExp

	mov	[hNMLib], eax

	push	dword NMLoadExports
	push	dword [hNMLib]
	call	GetProcAddress          ;get NmSymLoadExports address
	test	eax, eax
	jz      near .EndFreeLib

	push	dword [esi+OPENFILENAME.lpstrFile]
	call	eax			;call NmSymLoadExports
	add	esp, byte 4
	test	al, al
	jz      near .ErrTextOut

	push	byte 1
	push	dword strExpLoaded
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite		;"Exports loaded for:"
	push	byte 1
	push	dword [esi+OPENFILENAME.lpstrFile]
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite
	jmp	near .EndFreeLib

.ErrTextOut:
	push	byte 1
	push	dword strErrExpLoaded
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite		;"Error loading exports !!"

.EndFreeLib:
	push	dword [hNMLib]
	call	FreeLibrary		;free dll

.EndLoadExp:

	add	esp, dword (4 + 256 + OPENFILENAME_size)
	pop	ebp
	retn	04h


;
; SaveSIHist: save winice history to a log file
;
SaveSIHist:
	push	ebp
	mov	ebp, esp
	sub	esp, dword (4 + 256 + OPENFILENAME_size)	;func ptr + buff + ofn struct


	lea	esi, [ofn]					;OPENFILENAME struct
	mov	edi, esi
	mov	ecx, OPENFILENAME_size+256
	xor	eax ,eax
	rep	stosb

	lea	edi, [strFname]					;str buff

 	mov	dword [esi+OPENFILENAME.lStructSize], OPENFILENAME_size
	mov	eax, [hDlg]
	mov	[esi+OPENFILENAME.hwndOwner], eax
	mov	eax, [hInst]
	mov	[esi+OPENFILENAME.hInstance], eax
	mov	dword [esi+OPENFILENAME.lpstrFilter], strFilter2
	mov	dword [esi+OPENFILENAME.lpstrFile], edi
	mov	dword [esi+OPENFILENAME.nMaxFile], 256
	mov	dword [esi+OPENFILENAME.Flags], OFN_HIDEREADONLY
	mov	dword [esi+OPENFILENAME.lpstrDefExt], strDefLogExt

	push	esi
	call	GetSaveFileNameA
	test	al, al
	jz	near .EndSaveSiHist	;did user push cancel?

	push	dword NMLIB
	call	LoadLibraryA            ;load nmtrans.dll
	test	eax, eax
	jz	near .EndSaveSiHist

	mov	[hNMLib], eax

	push	dword NMCreateLog
	push	dword [hNMLib]
	call	GetProcAddress          ;get NmSymCreateLogFile address
	test	eax, eax
	jz      near .EndSaveFreeLib

	push    byte -1
	push    byte 0
	push    dword [esi+OPENFILENAME.lpstrFile]
	call    eax			;call NmSymCreateLogFile
	add     esp, byte 0Ch
	test	al, al
	jz      near .ErrSaveTextOut
	push	byte 1
	push	dword strSiHistSaved
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite		;"SoftIce history saved"

	push	byte 1
	push	dword [esi+OPENFILENAME.lpstrFile]
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite
	jmp	near .EndSaveFreeLib

.ErrSaveTextOut:
	push	byte 1
	push	dword strErrSiHistSaved
	push	dword IL_STATUS
	push	dword [hDlg]
	Call	TextBoxWrite		;"Error saving SoftIce history !!"

.EndSaveFreeLib:
	push	dword [hNMLib]
	call	FreeLibrary		;free dll

.EndSaveSiHist:

	add	esp, dword (4 + 256 + OPENFILENAME_size)
	pop	ebp
	retn	04h

%undef hDlg
%undef hNMLib
%undef strFname
%undef ofn


;
; SetToolbarTTs: set the proper Tooltiptext for the button in the toolbar
;
%define lpParam	ebp + 8
SetToolbarTTs:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	
	mov	esi, [lpParam]				;TOOLTIPTEXT->NMHDR

	cmp	dword [esi+NMHDR.code], TTN_NEEDTEXT
	jnz	near .EndSetToolBarTTs

	mov	eax, [esi+NMHDR.idFrom]
	sub	eax, 1000
	mov	edi, TT_Strings_Table
	mov	edi, [edi + eax * 4]
	mov	[esi+0Ch], edi				;set tooltip text

.EndSetToolBarTTs:
	xor	eax, eax
	pop	edi
	pop	esi
	pop	ebp
	retn	04h
%undef lpParam
