; Author    : Christoph Gabler
; Procedure : Set own Interrupt descriptor table (IDT)
; Date      : 25.3.2000
; Notice    : Requires realmode to work

code segment
org  100h
assume cs:code,ds:code
.386p

OWN_IDT:

SMSW AX                ; Get Machine Status Word and store in AX.
TEST AL,1
JNE  NO_RM             ; Jump if CPU not in Real Mode.

Mov Ah, 9
Mov Dx, Offset Message1
Int 21h
                
; [1] - Make a copy of the current IDT (for restoring and usage)
Push Ds
Push 0
Pop Ds
Mov Di, offset New_IDT
Xor Si, Si
Mov Cx, 400h
Repz
Movsb
Pop Ds

; [2] - Set new interrupts on our IDT (invisible to victim progs)

Mov DS:word ptr [New_IDT+4], offset INT1_Handler
Mov DS:word ptr [New_IDT+6], Cs

; [3] - Calculate offset to our IDT and set our it
Sub Ecx, Ecx
Mov Cx, Ds
Shl Ecx, 4
Xor Eax, Eax
Mov Ax, offset New_IDT
Add Ecx, Eax
Mov DS:dword ptr [IDT_Pointer+2], Ecx
Mov Bx, offset IDT_Pointer
Lidt [Bx]

; [4] - Our hidden interrupt eccours

Int 1

; [5] - Restore old IDT

Mov DS:dword ptr [IDT_Pointer+2], 0  ; 0000:0000 (normal IDT pointer in rm)
Mov Bx, offset IDT_Pointer
Lidt [Bx]

Int 20h

Message1 db 'Setting own IDT...$'
Message2 db ' breakpoint eccoured.',0Dh,0Ah,'$'
Message3 db 'No realmode, cannot set own IDT.$'
IDT_Pointer db 3,0FFh,0,0,0,0
New_IDT db 400h dup (0)

Int1_Handler:
Mov Ah, 9
Mov Dx, Offset Message2
Int 21h
Iret

NO_RM:
Mov Ah, 9
Mov Dx, Offset Message3
Int 21h
Int 20h

Code Ends
End OWN_IDT
