; ASProtect(tm) API-Emulator Dll  (c) by VAG //VSL '2000 ARR.
; ASProtect is a trademark of Alexey Solodovnikov
;
; Engine version 1.04 at 12-aug-2000, 20:30
;----------------------------------------------
; General overview:
;
;  All api functions availble via call to api `gate` routines
; (ASProt1 or ASProt2) These gates will return `ready to use` value (like
; trial days counter) or pointer to real api routine
;
; Api-gate routines scan thru APITABLE to find requested dispatcher/value
;
; Supported api's functions (by value):
;
;   -1    -   number of trial days left              (val) (rare) (* UNDOC *)
;    0    -   number of trial executions left        (val) (rare) (* UNDOC *)
;    1    -   0                                      (val) (rare) (* UNDOC *)
;    2    -   0                                      (val) (rare) (* UNDOC *)
;    3    -   null-proc (ret)                        (used by VB) (* UNDOC *)
;    4    -   decrypt code fragments (simple return `all ok`)
;    5    -   return pointer to registration information
;    6    -   allocate memory block                               (* UNDOC *)
;    7    -   free memory block                                   (* UNDOC *)
;    8    -   number of trial days left
;    9    -   number of trial executions left
;   10    -   copy registration info. into buffer                 (* UNDOC *)
;
;----------------------------------------------

;ShowMess = 1          ;Show info about all api requests
;InvokeDebugger = 1    ;Generate INT3 on each api function
ASPack21 = 1          ;Use ASPack2.1-style GetMem/FreeMem interface
UseFirstApi  = 1      ;Use common api
;UseSecondApi = 1      ;Use VB api. Don't uncomment it here, see make.bat

_trialDays    equ     10                ;Emulated number of trial days
_trialExecs   equ     10                ;Emulated number of trial executions
_regName      equ     'ASAP'            ;Emulated regname (comment for unreg)

Public  ASProt1
Public  ASProt2

.386p
.Model Flat, StdCall
;[-->>> Data segment];
.Data
MsgH    db    'ASProtect API',0
Msg1    db    'API load request!',0
Msg2    db    'API function request!',0
fmt     db    '@ %lX, id: %ld',0
fmt2    db    'Malloc: Len: %lX, State: %lX',0
fmt3    db    'Free: @: %lX, Len: %lX',0
buf     db    50 dup (?)

;[API-Routines table]
;[Don't modify or re-order!]
APIConst      equ   -1
MIN_API=-1
MAX_API=10
trialDays     dd    _trialDays           ;API_TRIALDAYS
APITABLE:
trialExecs    dd    _trialExecs          ;API_TRIALEXECS
              dd    0                    ;API_ZERO1
              dd    0                    ;API_ZERO2
              dd    api3                 ;API_NULL
              dd    api4                 ;API_DECRYPTCODE
              dd    api5                 ;API_GETREGINFOPTR
ifdef ASPack21
              dd    api6                 ;API_GETMEM
              dd    api7                 ;API_FREEMEM
else
              dd    api6a                ;API_GETMEM  - ASPack <= 2.001
              dd    api7a                ;API_FREEMEM - ASPack <= 2.001
endif
              dd    api8                 ;API_GETTRIALDAYS
              dd    api9                 ;API_GETTRIALEXECS
              dd    api10                ;API_GETREGINFOSTR
;

ifdef _regName
  regNamePtr  dd    offset regName
  regName     db    _regName,0
else
  regNamePtr  dd    0                    ;Return `unregistered`
endif

;[MMM: MiniMemoryManager ;)]
MAXMEMORY     equ   200         ;handlers
memsz         dd    ?
MaxMem        dd    8
MemPool       dd    MAXMEMORY dup (?,?)


;[-->>> Code segment];
.Code
Locals
NoSmart
        db  0Dh,0Ah,'      Generic ASProtect''s API Emulator (C) VAG //VAGSoft Lab. 2000, ARR.',0Dh,0Ah,0Dh,0Ah
;;
;DLL Load/Unload handling routine
LStart  proc  hInstDLL:dword, reason:dword, unused:dword
        cmp   reason,1   ; == DLL_PROCESS_ATTACH
        jne   @@NotLoad
ifdef ShowMess
        call  MessageBoxA, 0,\
          offset Msg1, offset MsgH, 0
endif
;Return `All ok`
        mov   eax,1
@@Ret:
        ret
@@NotLoad:
        jnb   @@Ret       ; != DLL_PROCESS_DETACH
        call  MemClean
        jmp   @@Ret
LStart  endp
;;
;ASProtect api emulator via GetProcAddress,-1,func
;Return value or address of function's dispatcher
ASProt1 proc  ;hModule:dword, lpProcName:dword
;        cmp   [hModule],APIConst
ifdef UseFirstApi
        cmp   dword ptr [esp+4],APIConst
        jne   @@NotApi
ifdef ShowMess
        push  dword ptr [esp+8]         ;fn
        push  dword ptr [esp+4]         ;ret addr
        push  offset fmt
        push  offset buf
        call  wsprintfA
        add   esp,4+4+4+4
        call  MessageBoxA,0,offset buf, offset MsgH, 0
endif
        mov   eax,[esp+8]
        cmp   al,MIN_API
        jl    @@RetOk
        cmp   al,MAX_API
        jg    @@RetOk
        mov   eax,dword ptr APITABLE[eax*4]
@@RetOk:
endif
        ret   2*4
ifdef UseFirstApi
@@NotApi:
        jmp   GetProcAddress
endif
ASProt1 endp
;;
;ASProtect api emulator via random function (always from DllFunctionCall ???)
;Return value or address of function's dispatcher
ASProt2 proc  ;p:dword
ifdef UseSecondApi
        push  eax
        mov   eax,[esp+4+4]
ifdef ShowMess
        pushad
        mov   ebx,[eax+4]
        push  dword ptr [ebx]
        push  dword ptr [esp+4+8*4+4]
        push  offset fmt
        push  offset buf
        call  wsprintfA
        add   esp,4+4+4+4
        call  MessageBoxA,0,offset buf, offset MsgH, 0
        popad
endif
        push  eax
        mov   eax,[eax]
        cmp   dword ptr [eax],APIConst
        pop   eax
        jne   @@NotApi
        mov   eax,[eax+4]
        mov   eax,[eax]
        cmp   al,MIN_API
        jl    @@RetOk
        cmp   al,MAX_API
        jg    @@RetOk
        mov   eax,dword ptr [APITABLE+eax*4]
@@RetOk:
        add   esp,4              ;Pop first eax
endif
        ret   1*4
ifdef UseSecondApi
@@NotApi:
        pop   eax
        jmp   DllFunctionCall
endif
ASProt2 endp
;;
;;
api3    proc  ;x:dword
;Dummy function
ifdef InvokeDebugger
        int 3
endif
        ret   1*4
api3    endp
;;
api4    proc  ;lpkey:dword,keysize:dword
;Decrypt encrypted fragments of image
ifdef InvokeDebugger
        int 3
endif
        mov   al,1                      ;Return Ok
        ret   2*4
api4    endp
;;
api5    proc
;Return pointer to RegName string
ifdef InvokeDebugger
        int 3
endif
        mov   eax,regNamePtr
        ret
api5    endp
;;
api6    proc  ;memsize:dword
;Allocate block of memory
ifdef InvokeDebugger
        int 3
endif
        cmp   MaxMem,MAXMEMORY*8
        jae   @@NoMem
        push  ebx
        push  ecx
        push  edx
        push  dword ptr [esp+8+8]       ;len
        mov   eax,[esp]
        mov   memsz,eax
        push  40h                       ;PAGE_EXECUTE_READWRITE
        push  1000h                     ;MEM_COMMIT
        push  dword ptr [esp+20+8]      ;Size
        push  0                         ;Region
        call  VirtualAlloc
        pop   edx
        pop   ecx
ifdef ShowMess
        pushad
        push  eax                       ;code
        push  memsz
        push  offset fmt2
        push  offset buf
        call  wsprintfA
        add   esp,4+4+4+4
        call  MessageBoxA,0,offset buf, offset MsgH, 0
        popad
endif
        or    eax,eax
        jz    @@NoMemClr
        mov   ebx,MaxMem
        mov   MemPool[ebx],eax
        pop   MemPool[ebx+4]
        add   MaxMem,8
        pop   ebx
        jmp   @@Ok
@@NoMemClr:
        pop   eax
        pop   eax
@@NoMem:
        xor   eax,eax            ;return error
@@Ok:   ret   1*4
api6    endp
;;
api6a   proc ;lpout:dword,memsize:dword
;Allocate block of memory, old style (ASPack prior to 2.1)
        push  dword ptr [esp+8] ;Size
        call  api6
        mov   edx,[esp+4]       ;Result
        mov   [edx],eax
        ret   2*4
api6a   endp
;;
api7    proc  ;memsize:dword,lppmem:dword
;Free block of memory
ifdef InvokeDebugger
        int 3
endif
        push  edi
        mov   eax,[esp+8]
        mov   eax,[eax]                 ;mem
ifdef ShowMess
        pushad
        push  dword ptr [esp+8*4+8+4]   ;len
        push  eax
        push  offset fmt3
        push  offset buf
        call  wsprintfA
        add   esp,4+4+4+4
        call  MessageBoxA,0,offset buf, offset MsgH, 0
        popad
endif
        mov   edi,MaxMem
@@Find: sub   edi,8
        jz    @@ErrClr
        cmp   MemPool[edi],eax
        jne   @@Find
FreeMem:
        push  ecx
        push  edx
        push  4000h                     ;MEM_DECOMMIT
        push  MemPool[edi+4]
        push  MemPool[edi]
        call  VirtualFree
        pop   edx
        pop   ecx
        sub   MaxMem,8
@@Copy: cmp   edi,MaxMem
        je    @@ErrClr
        push  MemPool[edi+8]
        push  MemPool[edi+8+4]
        pop   MemPool[edi+4]
        pop   MemPool[edi]
        add   edi,8
        jmp   @@Copy
@@ErrClr:
        pop   edi
@@Fin:
        ret   2*4
api7    endp
;;
api7a   proc  ;memsize:dword,lppmem:dword
        jmp   api7
api7a   endp
;;
MemClean proc
;Internal: Free all allocated memory
@@FreeAll:
        mov   edi,MaxMem
        sub   edi,8
        jz    @@Fin
        push  0
        push  0
        push  offset @@FreeAll
        push  edi
        jmp   FreeMem
@@Fin:  ret
MemClean endp
;;
api8    proc
;Get trial days count
ifdef InvokeDebugger
        int 3
endif
        mov   eax,trialDays
        ret
api8    endp
;;
api9    proc
;Get trial execs count
ifdef InvokeDebugger
        int 3
endif
        mov   eax,trialExecs
        ret
api9    endp
;;
api10   proc  ;lpout:dword,unk:dword
;Copy reginfo into buffer and return his length
ifdef InvokeDebugger
        int 3
endif
        push  esi
        push  edi
        mov   esi,regNamePtr
        mov   edi,[esp+4+4+4]
        xor   eax,eax
        mov   [edi],al
        or    esi,esi
        jz    @@Skip
@@Copy: movsb
        inc   eax
        cmp   byte ptr [edi-1],0
        jne   @@Copy
        dec   eax
@@Skip:
        pop   edi
        pop   esi
        ret   2*4
api10   endp
;;
;;
Extrn   GetProcAddress  : proc
ifdef UseSecondApi
Extrn   DllFunctionCall : proc
endif
Extrn   MessageBoxA     : proc
Extrn   wsprintfA       : proc
Extrn   VirtualAlloc    : proc
Extrn   VirtualFree     : proc

        End   LStart
