;
; Author: Christoph Gabler
; Release date: 28th July 2001
; Title: Generic Unpacker Win32 (GUW32)
; Version: 1.0 beta8
; Music while coding: Fear Factory, Dismember, Cannibal Corpse
; Source comments: Mostly included, no tabs (source is debugger-output style)
; Requirements: Windows95/98/Me (ring0 tracer), protected PE file
; Compiler: Tasm32 & Tlink32 version 1.6.71.0
;


;[TO DO LISTING]
; - ring0 tracer: Emulate SIDT or redirect IDT
; - ring0/3 tracer: Include multi thread tracing to unpack peshield
; - ring3 tracer: Find correct OEP when tracing Asprotect *regged*
; - ring0/3 tracer: Write state machine to emulate the trapflag and be able
;                   to trace tELock, Krypton...
; - ring0 tracer: Fix int30h bug to trace also PM16 instead of stepping over
; - loader: Write dll and dos exe/com support (v86 is also ready to be traced)
; - include a peeditor
;


.386p
Locals
Jumps
.Model Flat, StdCall

Extrn GetOpenFileNameA             :PROC
Extrn CreateFileA                  :PROC
Extrn MessageBoxA                  :PROC
Extrn SetFilePointer               :PROC
Extrn ReadFile                     :PROC
Extrn GlobalAlloc                  :PROC
Extrn GlobalLock                   :PROC
Extrn GetFileSize                  :PROC
Extrn CloseHandle                  :PROC
Extrn GlobalFree                   :PROC
Extrn WriteFile                    :PROC
Extrn DeleteFileA                  :PROC
Extrn MoveFileA                    :PROC
Extrn CopyFileA                    :PROC
Extrn timeGetTime                  :PROC
Extrn ExitProcess                  :PROC

Extrn CreateProcessA               :PROC
Extrn ResumeThread                 :PROC
Extrn ReadProcessMemory            :PROC
Extrn WriteProcessMemory           :PROC
Extrn TerminateProcess             :PROC
Extrn GetThreadContext             :PROC
Extrn SetThreadContext             :PROC
Extrn GetCurrentProcess            :PROC
Extrn GetCommandLineA              :PROC
Extrn SetPriorityClass             :PROC
Extrn LoadLibraryA                 :PROC
Extrn GetProcAddress               :PROC
Extrn VirtualProtect               :PROC
Extrn VirtualAlloc                 :PROC
Extrn VirtualFree                  :PROC

Extrn GetModuleHandleA             :PROC
Extrn LoadBitmapA                  :PROC
Extrn BeginPaint                   :PROC
Extrn SetWindowTextA               :PROC
Extrn CreateCompatibleDC           :PROC
Extrn SelectObject                 :PROC
Extrn GetObjectA                   :PROC
Extrn BitBlt                       :PROC
Extrn GetClientRect                :PROC
Extrn SetClassLongA                :PROC
Extrn GetStdHandle                 :PROC
Extrn WriteConsoleA                :PROC
Extrn DeleteDC                     :PROC
Extrn DeleteObject                 :PROC
Extrn EndPaint                     :PROC
Extrn SetFocus                     :PROC
Extrn SendMessageA                 :PROC
Extrn PeekMessageA                 :PROC
Extrn SetDlgItemTextA              :PROC
Extrn LoadIconA                    :PROC
Extrn LoadCursorA                  :PROC
Extrn SetCursor                    :PROC
Extrn EndDialog                    :PROC
Extrn GetDlgItem                   :PROC
Extrn RedrawWindow                 :PROC
Extrn DialogBoxParamA              :PROC
Extrn CheckDlgButton               :PROC
Extrn IsDlgButtonChecked           :PROC

.const

; 
; PE file structure
; 

; pe file header (always 0 till 18h)
; begin: 'PE',0,0
pe_signature    equ 0   ; +0  = PE signature ('PE',0,0) [dword]
machine         equ 4   ; +4  = CPU machine type the file was made for [word]
number_sections equ 6   ; +6  = Number of sections [word]
timedatestamp   equ 8   ; +8  = Time/Date the file has been created [dword]
pointer_symbols equ 0Ch ; +C  = Pointer to symboltable [dword]
number_symbols  equ 10h ; +10 = Number of symbols (used for debugging) [dword]
header2_size    equ 14h ; +14 = Size of optional header [word]
file_flags      equ 16h ; +16 = Flags describing the file type [word]

; pe optional header (18h till ...header2_size)
; begin: PE,0,0
entry_point     equ 28h ; +28 = Pointer to entry point (rva) [dword]
image_base      equ 34h ; +34 = Image base, objects will be loaded here
                        ;       +RVA in VA [dword]
section_align   equ 38h ; +38 = Multiplied with number is sections start
                        ;       in memory and vsize [dword]
file_align      equ 3Ch ; +3C = Multiplied with this number is sections start
                        ;       in file and rawsize [dword]
image_size      equ 50h ; +50 = Size of pe headers+sections, virtualsize
                        ;       -> alligned to section_align [dword]
size_headers    equ 54h ; +54 = Size of all headers together
                        ;       also file offset to first section [dword]
exec_type       equ 58h ; +58 = Info about executable type [dword]
data_directory  equ 5Ch ; +5C = Array containing rva [dword], size [dword]
                        ;       of several structures

; image data directory (data_directory till sectiontable start)
; begin: 'PE',0,0
data_ptr      equ 18h+data_directory+4
export_table  equ data_ptr+0   ; [rva/size] Export table
import_table  equ data_ptr+8   ; [rva/size] Import table
resource      equ data_ptr+10h ; [rva/size] Resource
exception     equ data_ptr+18h ; [rva/size] Exception
security      equ data_ptr+20h ; [rva/size] Exception
relocations   equ data_ptr+28h ; [rva/size] Relocations
debug_data    equ data_ptr+30h ; [rva/size] Debug data
description   equ data_ptr+38h ; [rva/size] Description
global_ptr    equ data_ptr+40h ; [rva/size] Global pointer
tls_table     equ data_ptr+48h ; [rva/size] Thread local storage table
load_config   equ data_ptr+50h ; [rva/size] Load configuration
bound_import  equ data_ptr+58h ; [rva/size] Bound import
iat           equ data_ptr+60h ; [rva/size] Import table adress

; import directory entry
importlookup equ 0 ; RVA to import look up table, contains name of import [dword]
timestamp    equ 4 ; Set to zero until bound, then it is time/date of dll [dword]
forwardchain equ 8 ; Index of firt forwarder reference [dword]
dll_name     equ 0Ch ; RVA pointer to ascii dll name [dword]
iat_rva      equ 10h ; RVA pointer to import adress table [dword]

; pe section header (18h+header2_size till ... (28h bytes per section))
; begin: begin of sectiontable
section_name  equ 0   ; OFFS+0  = Name of the section [8 bytes]
section_size  equ 8   ; OFFS+C  = Sectionsize aligned to section_align [dword]
section_rva   equ 0Ch ; OFFS+8  = Section is loaded in memory (rva) [dword] 
section_size2 equ 10h ; OFFS+10 = Sectionsize aligned to file_align [dword]
section_start equ 14h ; OFFS+14 = Offset to section start in file [dword]
section_flags equ 24h ; OFFS+24 = Is section code/data/data? and r/w [dword]

; 
; Exception handler structures
; 

; exception record
; begin: exception_record offset
exception_code   equ 0  ; Exception reason, why did an exception occour? [dword]
exception_flags  equ 4  ; Zero means exception is continueable [dword]
exception_record equ 8  ; Pointer to structure "exception_record" [dword]
exception_eip    equ 0Ch; Offset where exception occoured [dword]
number_paras     equ 10h; Number of parameters associated with the exc. [dword]
exception_info   equ 14h; Additional dwords which describe the exception (below)

; additional thread information
; begin: exception_context offset
victim_gs     equ 8Ch   ; GS
victim_fs     equ 90h   ; FS
victim_es     equ 94h   ; ES
victim_ds     equ 98h   ; DS
victim_edi    equ 09Ch  ; EDI
victim_esi    equ 0A0h  ; ESI
victim_ebx    equ 0A4h  ; EBX
victim_edx    equ 0A8h  ; EDX
victim_ecx    equ 0ACh  ; ECX
victim_eax    equ 0B0h  ; EAX
victim_ebp    equ 0B4h  ; EBP
victim_eip    equ 0B8h  ; EIP
victim_cs     equ 0BCh  ; CS
victim_flags  equ 0C0h  ; EFLAGS
victim_esp    equ 0C4h  ; ESP
victim_ss     equ 0C8h  ; SS

; dialog and resource def.
IDC_edit    equ 3000
IDC_button  equ 3001
IDC_exit    equ 3002
IDC_B1      equ 1000 ; [start] button
IDC_B2      equ 1001 ; [about] button
IDC_B3      equ 1002 ; [exit] button
IDC_box     equ 1003 ; edit_box...
IDC_B4      equ 1004 ; [options] button
IDM_gettext equ 32000
IDM_clear   equ 32001
IDM_exit    equ 32002

.data ; initialized data
ofn_struct  dd 04ch, 0, 0, ofn_filter, 0 ,0, 0
            dd filename
            dw 0200h, 0
            dd 0, 0, 0, 0 ,01000h, 0, 0, 0, 0, 0
ofn_filter  db 'crypted/compressed executable', 0,'*.exe;*.dll', 0,'all files', 0,'*.*', 0, 0
filename    db  255d dup (?)
filename3 db 'Unpacked.exe',0
newfilename db 'UNPACKED.EXE',0
newfilename2 db 'UNPACKED_.EXE',0 ; created by imprec
sign        db '[UG2001]'
handle      dd  0
handle2     dd  0
cancel_guw  db  0
current_section dw 0
huh         dd 0
read_temp   db 8 dup (0)
current_fpointer dd 0
current_rsize    dd 0

ep_section  dw 0
ep_offset   dd 0
active_open db 0
filesize    dd 0
pefilesize  dd 0
removesize  dd 0
image       dd 0
image2      dd 0
time_counter   dd 0
dos_reloc_offs dd 0
lib_name    db 'imprec.dll',0
func_name   db 'RebuildImport',0
po_eax      dd 0
am_ecx      dd 0
save_idt    db (200h) dup (0)

processinfo:
process_handle dd 0         ; handle to opened process
thread_handle  dd 0         
process_id     dd 0         ; global process identifier
thread_id      dd 0         

startupinfo dd ?
temp_id dd 200h dup (0)

; 
; BEGIN .data and .const of GUI 
; 

DlgName      db 'CG_UG2001',0
options_name db 'SPAIN_HOLLAND_2001',0
about_name   db 'about_dlg',0
tracer_name  db 'tracer_dlg',0
tracer_name2 db 'tracer_dlg2',0
tracer_name3 db 'tracer_dlg3',0
exc_name     db 'exc_dlg',0
exc_name2    db 'exc_dlg2',0
exc_name3    db 'exc_dlg3',0
window_name  db 'GUW32 v1.0',0
window_stage1 db 'OEP reached!',0
window_name2 db 'tracer ready...',0
window_name3 db 'synchronizing...',0
window_name4 db '>TRACING wait!',0
window_name5 db '00000000',0
window_name6 db 'Unpacking error',0
edit_text3   db 'File name: '
edit_patch3  dd 30h dup (0)

edit_text4   db 'Entrypoint rva: '
                edit_patch4  db '            ',0

edit_text5   db 'Imagebase: '
                edit_patch5  db '            ',0

edit_text6   db 'Number sections: '
                edit_patch6  db '            ',0

edit_text7   db 'Image size: '
                edit_patch7  db '            ',0

edit_text8_  db 'EP into section: ['
edit_text8   db 'Cryptor section: ['
                    edit_patch8 db ':C:C:C:C]',0

edit_text9   db 'Detected cryptor: '
                edit_patch9  db '               ',0

edit_text10  db 'Elapsed time: '
                edit_patch10 db '00:00 min', 0

sectionsel   dd -1
check_box1   equ 1337
check_box2   equ 13370
check_box3   equ 13371
check_box4   equ 13372
check_box5   equ 13373
unpack_button equ 2000
unpack_dlg    equ 2001
unpack_dlg2   equ 2002
unpack_dlg3   equ 2003
unpack_dlg4   equ 2004
unpack_dlg5   equ 2005
unpack_dlg6   equ 2006
unpack_dlg7   equ 2007
remove_sec   db 1
create_importtable db 1

; structure borrowed from win32.inc ;P
RECT    struc
        rcLeft          dd ?
        rcTop           dd ?
        rcRight         dd ?
        rcBottom        dd ?
RECT    ends

RECT2: ; fix options redraw bug with rect2
        RELeft          dd 0
        RETop           dd 0
        RERight         dd 0
        REBottom        dd 150h

cursor_moved db 0
Xpos         dw 0
Ypos         dw 0
hIcon        dd 0  ; handle to icon
hIcon2       dd 0  ;
flag_tracer_gui db 0

PAINTSTRUCT STRUC
PShdc         dd               ?
PSfErase      dd               ?
PSrcPaint     db               size RECT dup(?)
PSfRestore    dd               ?
PSfIncUpdate  dd               ?
PSrgbReserved db               16 dup(?)
PAINTSTRUCT ENDS

BITMAP STRUCT
bmType       dword ?
bmWidth      dword ?
bmHeight     dword ?
bmWidthBytes dword ?
bmPlanes     word  ?
bmBitsPixel  word  ?
bmBits       dword ?
BITMAP ENDS

lpPaint PAINTSTRUCT <?>
lpvObject BITMAP  <?>

hInstance  dd ?
hBitmap    dd ? ; handles to bitmaps in rc
hBitmap2   dd ?
hBitmap3   dd ?
hBitmap4   dd ?
hBitmap5   dd ?
hBitmap6   dd ?
hBitmap7   dd ?
hDC        dd ?
hMemDC     dd ?
BitBltLeft dd ?
BitBltTop  dd ?

xMousePos  dd ?
yMousePos  dd ?
RedrawPic  dd ?

IIRL       dd ?
IIRT       dd ?
IIRW       dd ?
IIRH       dd ?

detect_0  db 'Unknown',0 
detect_1  db 'Aspack 2.11d',0
detect_2  db 'BJFnt 1.3',0
detect_3  db 'Aspack',0
detect_4  db 'Asprotect 1.1',0
detect_5  db 'Asprotect 1.2',0
detect_6  db 'Lamecrypt 1.0',0
detect_7  db 'PC-Guard',0
detect_8  db 'PCPEC alpha',0
detect_9  db 'PCShrinker',0
detect_10 db 'PECompact',0
detect_11 db 'PECrypt32 1.02',0
detect_12 db 'PELockNT 2.04',0
detect_13 db 'PEMangle 1.0',0
detect_14 db 'PE-PaCK 1.0',0
detect_15 db 'UPX < 0.72',0
detect_16 db 'UPX > 0.72   ',0
detect_17 db 'Winkript 1.0',0
detect_18 db 'YodaCrypt 1.2',0
detect_19 db 'YodaCrypt 1.1',0
detect_20 db 'Crunch V2',0
detect_21 db 'Neolite',0
detect_22 db 'SPEC b3',0
detect_23 db 'VGCrypt 0.75b',0
detect_24 db 'PENightmare2',0
detect_25 db 'PE Ninja 1.0',0
detect_26 db 'Noodlecrypt 2.0',0
detect_27 db 'tElock 0.71',0
detect_28 db 'PESHiELD 0.25',0
detect_29 db 'WWPack32',0
detect_30 db 'PKLite32',0
detect_31 db 'Shrinker 3.4',0
detect_32 db 'CodeCrypt 0.164',0
detect_33 db 'PENightmare2',0
detect_34 db 'Armadillo??',0
detect_35 db 'Stone''s pepack',0
detect_36 db 'VBOWatch 2.0',0
detect_37 db 'TimeLock',0
detect_38 db 'XCR 0.11',0
detect_39 db 'DBPE 1.5',0
detect_40 db 'PEX 0.99',0
detect_41 db 'Krypton 0.2',0

; 
; END .data/.cont/?data of GUI 
; 

;++
; IDT ring0 tracer engine exception and trapflag setup
;
; The following part is used as loader for the main tracer engine
; which will be written into our victim process and then single
; step tru the victim thread.
;--
tf_exc_setup_ring0:

Call $+5                   ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

Push end_tf_exc_setup - real_tf_exc_setup ; size of mem to allocate
Push 0
Call [ebp+api_GlobalAlloc] ; EAX on return=pointer to freed mem area

Lea Esi, [ebp+real_tf_exc_ring0]
Mov Edi, Eax
Mov Ecx, end_handler_ring0 - real_tf_exc_ring0
Cld
Repz
Movsb
Jmp Eax ; jump to our allocated mem where we moved the real tf/exc setup

real_tf_exc_ring0:
Call $+5                    ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

Mov [delta_offset+Ebp], Ebp
Mov [ring3_fs+Ebp], Fs

; signal main thread we are ready to rock and allocated ourself somewhere else
Mov Ecx, [back_jump2+Ebp]
Mov dword ptr [Ecx+4], 1

; idle loop ... wait for other thread
Mov Eax, [Ebp+wait_idle2]   ; used for idling till writeprocess occours (cannot read from other thread here...)
sync_rewrite2:
Cmp Eax, dword ptr [Ecx]
Je sync_rewrite2

Cmp [Ebp+use_own_vector], 0
Je reentrance

; hook intcallgate32 to do vmmcalls
Mov Eax, dword ptr [idt_pointer+2+Ebp]
Lea Ebx, [Ebp+vxdcall_gate]        ; ebx=pointer to new int handler
Mov Ecx, [Eax+5*8]
Mov Edx, [Eax+5*8+4]
Mov [Eax+5*8], Bx                  ; low word of pointer to interrupt 5
Shr Ebx, 4*4                       ; bx=high word of ebx
Mov [Eax+6+5*8], Bx                ; high word of pointer to interrupt 5
Int 5

vxdcall_gate:
Mov [Eax+5*8], Ecx                 ; restore old vector
Mov [Eax+5*8+4], Edx
Lea Esi, [Ebp+handler_ring0]       ; pointer to int handler
Mov Eax, 1                         ; which int to hook
Mov Edi, end_handler_ring0 - handler_ring0
db 0CDh, 20h, 80h, 0, 1, 0         ; VMMCall Hook_PM_Fault
Lea Eax, [Ebp+reentrance]
Mov dword ptr [Esp], Eax           ; fix reentrance crap
Iret
reentrance:

db 0B8h ; Mov Eax, back_jump2
back_jump2 dd 0

; enable trapflag
PushFD
Bts word ptr [Esp], 8
PopFD

; return to victim program
Jmp Eax


; EDI (pointer to int entry stack)
;
; +0  EIP
; +4  CS
; +8  EFLAGS
; +C  ESP
; +10 SS
; +14 ES
; +18 DS

; ESI (pointer to pushed thread registers)
;
; +0  EDI
; +4  ESI
; +8  EBP
; +10 EBX
; +14 EDX
; +18 ECX
; +1C EAX

; Our set up segment registers
;
; DS  codesegment of traced thread
; ES  stacksegment of traced thread
; SS  vmm datasegment

handler_ring0:
Sti
PushFD
PushAD
Push ES DS

Mov Esi, Ebp                ; ESI=pointer to pushed thread registers
db 0BDh                     ; EBP=instruction pointer
delta_offset dd 0
Lea Edi, [Esi+24h]          ; EDI=pointer to int entry stack
Mov Ecx, [Edi+0Ch]          ; ECX=stack pointer of traced thread
Mov Edx, [Edi]              ; EDX=next eip to traced thread
Push dword ptr [Edi+10h]
Pop Es                      ; ES=stack segment of traced thread

Bts word ptr [Edi+8], 8     ; Always enable trapflag (for popf/iret)

Cmp Edx, [Ebp+api_ExitProcess]
Je exit_reached             ; Check for ExitProcess API

Call generic_oep_seeker     ; input:edx (eip), output:eax (true/false)
Cmp Eax, 1
Je oep_retrieved

Push dword ptr [Edi+4]      
Pop Ds                      ; DS=codesegment of traced thread

Lea Eax, [Edi+10h]
Lar Eax, ss:[Eax]           ; load the access rights of the stack selector
Bt  Eax, 16h
Jc stack_32                 ; jump if SS is a 32b selector
Shl Ecx, 4*4                ; use sp instead of esp
Shr Ecx, 4*4
stack_32:

Mov ss:[Ebp+current_pm], 4  ; set length to dword
Lea Eax, [Edi+4]
Lar Eax, ss:[Eax]           ; load the access rights of the codesegment
Bt  Eax, 16h
Jc pm32                     ; jump if in pm32
Mov ss:[Ebp+current_pm], 2  ; set length to word
pm32:

Cmp Edx, ss:[Ebp+reenable_int]
Jne not_within
Mov ss:[Ebp+reenable_int], -1
Mov Eax, ss:[int_save+ebp]     ; restore all overwritten bytes
Mov ss:[Edx-9], Eax
Mov Eax, ss:[int_save+4+ebp]
Mov ss:[Edx-9+4], Eax
Mov Eax, ss:[int_save+8+ebp]
Mov ss:[Edx-9+8], Eax
Sub Edx, 9
Mov ss:[Edi], Edx              ; fix return eip

Inc [Ebp+saved_byte2] ;<

not_within:

; check for a return from seh reached
Cmp ss:[Ebp+current_pm], 4
Jne not_logged
Cmp Edx, ss:[Ebp+thread_context_seh]
Je returned_seh
Cmp ss:[Edi], 20000000h
Ja not_logged
jmp not_returned_seh
returned_seh:

Mov Eax, es:[Ecx+8]                   ; get seh_context
Bts ss:word ptr [Eax+victim_flags], 8 ; enable TF in the context
Mov Ebx, Edx
Mov Edx, ss:[Eax+victim_eip]          ; get the eip

Call generic_oep_seeker               ; check if next eip might be the oep
Cmp Eax, 1                            ; (we must do this because int1 will occour one mnemonic too late)
Je oep_retrieved
Btr word ptr ss:[Edi+8], 8
Mov Edx, Ebx
not_returned_seh:

; log pointer_to_seh activity
Push Fs
db 68h ;Push dword
ring3_fs dd 0
Pop Fs
Mov Eax, fs:[0]
Cmp ss:[fs_seh+ebp], Eax
Je pointer_seh_untouched
Mov ss:[fs_seh+ebp], Eax         ; save changed stack chain
Mov Eax, es:[Ecx+4]              ; get pointer to the handler at victim_esp+4
Mov ss:[pointer_to_seh+ebp], Eax ; save it
Lea Eax, [seh_ring3_handler+ebp]
Mov es:[Ecx+4], Eax              ; put our handler to catch seh exceptions
pointer_seh_untouched:
Pop Fs
not_logged:

; emulate interrupts (catch intgate to trace the handler)
Cmp Edx, 20000000h   ; temporary solution!
Jb no_interrupt      ; better: trace also PM16, PM32 + PM16 stack... -> int30h

Mov Eax, es:[Ecx]
Mov Ebx, ss:[Eax]                  ; save dword*3
Mov ss:[Ebp+int_save], Ebx
Mov Ebx, ss:[Eax+4]                  
Mov ss:[Ebp+int_save+4], Ebx
Mov Ebx, ss:[Eax+8]
Mov ss:[Ebp+int_save+8], Ebx

Mov ss:[Eax], 0BA0F669Ch           ; write stuff there which will turn on TF
Mov ss:[Eax+4], 9D08242Ch
Mov ss:[Eax+8], 0FFFF9090h

Lea Eax, [Eax+9]
Mov ss:[reenable_int+ebp], Eax
Btr word ptr ss:[Edi+8], 8 ; disable trapflag
no_interrupt:

; emulate PushFD instruction (hide trapflag from victim thread)
Cmp ds:byte ptr [Edx], 9Ch
Jne no_pushfd                 
Mov Ebx, ss:dword ptr [Edi+8]   ; get (e)flags
Btr Bx, 8                       ; remove TF
Sub Ecx, ss:[Ebp+current_pm]    ; substract mode dependent length of (e)flags
Mov ss:dword ptr [Edi+0Ch], Ecx ; correct esp/sp
Inc Edx                         ; next initial point must point beyond the emulated pushfd
Cmp ss:[Ebp+current_pm], 4
Je write_eflags
Mov es:word ptr [Ecx], Bx       ; write flags to stack pointer
jmp no_pushfd
write_eflags:
Mov es:dword ptr [Ecx], Ebx     ; write eflags to stack pointer
no_pushfd:  

Mov ss:[Edi], Edx               ; write new thread return EIP
return_vmm:
Pop DS ES
PopAD
PoPFD
Ret

handler_catch_int:
PushAD

Lea Edi, [Ebp+24h]          ; EDI=pointer to int entry stack
Mov Edx, [Edi]              ; EDX=next eip to traced thread
Call $+5                    ; EBP=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

Cmp [int_save+ebp], -1
Je _return_vmm

Bts word ptr [Edi+8], 8     ; Enable TF to trace interrupt
Mov Eax, [int_save+ebp]     ; Restore all overwritten bytes
Mov [Edx-9], Eax
Mov Eax, [int_save+4+ebp]
Mov [Edx-9+4], Eax
Mov Eax, [int_save+8+ebp]
Mov [Edx-9+8], Eax
Mov [Edi], Edx              ; Fix return eip
Mov [int_save+ebp], -1

_return_vmm:
PopAD
Ret

oep_retrieved:
Push SS
Pop Ds
Mov Ebx, [ebp+back_jump2]       ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx+4], Edx      ; write retrieved OEP
Btr word ptr [Edi+8], 8         ; turn off trapflag to avoid nesting during ring switch
Lea Ebx, [Ebp+sync_thread_oep]
Mov [Edi], Ebx
jmp return_vmm
sync_thread_oep:                ; wait for other process (can only sync. when beeing in ring3)
Call $+5                        ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1
Call [Ebp+api_GetCurrentProcess]
Call [Ebp+api_SetPriorityClass], Eax, 40h ; set thread to idle (speed increase)
Mov Ebx, [ebp+back_jump2]       ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx], 0deadc0deh ; sign for other thread
jmp $                           ; wait now for other thread                           

ret_ring3:
Mov [Edi], Edx

PopAD ; restore all thread regs
PopFD

direct_return_r3:
Bts word ptr [Esp+8], 8    ; always turn on TF
Iret

second_ring0: 
Mov word ptr [Ebp+handler_ring0], 3C81h
Mov Ebx, [Eax-victim_eip]  ; get return eip
Mov [Esp], Ebx
Mov Ebx, [Eax-victim_esp]
Mov [Esp+0Ch], Ebx
Jmp ret_ring3

switch_ring:
Mov Esp, Edi           ; fix stack (pushad/add 50h) 

Mov dword ptr [Esp], Ebx

Mov Ebx, [ebp+back_jump2]       ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx], 0deadc0deh ; sign for other thread
Mov dword ptr [Ebx+4], Edx      ; write retrieved OEP

Btr word ptr [Esp+8],8 ; turn off trapflag to avoid nesting during ring switch
Mov Eax, Esp           ; pointer to saved area
Iret                   ; switch selector

exit_reached:
Push SS
Pop Ds
Mov Ebx, [ebp+back_jump2]       ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx+4], Edx      ; write retrieved OEP
Btr word ptr [Edi+8], 8         ; turn off trapflag to avoid nesting during ring switch
Lea Ebx, [Ebp+sync_thread_exit]
Mov [Edi], Ebx
jmp return_vmm
sync_thread_exit:                ; wait for other process (can only sync. when beeing in ring3)
Call $+5                         ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1
Call [Ebp+api_GetCurrentProcess]
Call [Ebp+api_SetPriorityClass], Eax, 40h ; set thread to idle (speed increase)
Mov Ebx, [ebp+back_jump2]       ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx], 00FB1C1A0h ; sign for other thread (termination flag)
jmp $                           ; wait now for other thread                           

seh_ring3_handler:
db 68h ; push dword
pointer_to_seh dd 0
PushFD 
Bts word ptr [Esp], 8
PopFD
Ret

int_sel dd 0
int_save dd 0,0,0
reenable_int dd -1
intx_handler dd 0
intx_selector dd 0
pm_fault_01 dd 0
idt_pointer  dd 0,0
wait_idle2   dd 0
thread_context_seh dd 0
temp2 dd 0
fs_seh dd 0
saved_byte2 db 0
thread_return dd 0
current_pm dd 0
use_own_vector db 1

;++
; Tracer engine exception and trapflag setup
;
; The following part is used as loader for the main tracer engine
; which will be written into our victim process and then single
; step tru the victim thread.
;--
tf_exc_setup:

Call $+5                   ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

Push end_tf_exc_setup - real_tf_exc_setup ; size of mem to allocate
Push 0
Call [ebp+api_GlobalAlloc] ; EAX on return=pointer to freed mem area

Lea Esi, [ebp+real_tf_exc_setup]
Mov Edi, Eax
Mov Ecx, end_tf_exc_setup - real_tf_exc_setup
Cld
Repz
Movsb
Jmp Eax ; jump to our allocated mem where we moved the real tf/exc setup

real_tf_exc_setup:
jmp end_handler_ring0

; shared data by both exception handlers

api_GlobalAlloc dd 0
api_SetWindowTextA dd 0
api_MessageBoxA dd 0
api_ReadProcessMemory dd 0
api_EndDialog   dd 0
api_GetCurrentProcess dd 0
api_ExitProcess dd 0
api_VirtualProtect dd 0
api_VirtualAlloc dd 0
api_VirtualFree dd 0
api_LoadLibraryA dd 0
api_GetModuleHandleA dd 0
api_GetProcAddress dd 0
api_CreateProcessA dd 0
api_MoveFileA dd 0
api_CopyFileA dd 0
api_SetPriorityClass dd 0
api_GlobalLock dd 0

section_bpm   dd 0
section_bpm_offset dd 0
api_emulation db 0

tracer_exit1  db 'Aborted',0
tracer_exit2  db 'The program has been terminated before a second entrypoint was reached.',0

;++
; Convert hex to displayable hex
; Entry:
;       EDX           - input dword
; Return:
;       [EAX]         - output
;--
hexconvert:
Mov Cl, 18h
_hexloop:
Push Edx
Shr Edx, Cl ; 18h, 10h, 8h
Push Dx
And DL,0F0h
Db 0C0h,0EAh,04h
Cmp Dl,09h
Ja _char
End__char:
Add Dl,30h
Call _writedown
Pop Dx
And Dl,0Fh
Cmp Dl,09h
Ja _char2
End__char2:
Add Dl,30h
Call _writedown
Pop Edx
Sub Cl, 8
Cmp Cl, -8
Jne _hexloop
Ret
_char: Add Dl,7
Jmp End__char
_char2: Add Dl,7
Jmp End__char2
_writedown:
Mov byte ptr [Eax], Dl
Inc Eax
Ret

;++
; Generic OEP seeker
; Return:
;         EAX         - 1=OEP reached 0=OEP not reached
;--
generic_oep_seeker:

db 81h, 7Fh, 4              ; Cmp [Edi+4], dword
thread_selector dd 0        ; check if current CS=thread CS
r3_patch: Jne no_oep_found

db 81h, 0FAh ; Cmp Edx, dword
oep_our_code dd -1
Ja no_oep_found

db 81h, 0FAh ; Cmp Edx, dword
oep_begin_section dd 0
Jb last_instr

db 81h, 0FAh ; Cmp Edx, dword
oep_end_section dd 0
Ja last_instr
no_oep_found:
Xor Eax, Eax
Ret

last_instr:

; check for entry point faking (uncomplete)
Cmp byte ptr [Edx], 0C3h ; ret
Je no_oep_found
Cmp byte ptr [Edx], 0C2h ; ret byte
Je no_oep_found
Cmp byte ptr [Edx], 0CFh ; retf
Je no_oep_found
Cmp dword ptr [Edx+5], 00000CC2h
Je no_oep_found

; check if section has been decrypted
Mov Ebx, [ebp+section_bpm_offset]
Mov Eax, [ebp+section_bpm]
Cmp Eax, [Ebx]
Je no_oep_found 

Mov Eax, 1
Cmp Edx, 00401097h
Je crc_1
return_engine:
Ret

crc_1:
Cmp word ptr [Edx+2Dh], 0C633h
Jne return_engine
Mov word ptr [Edx+2Dh], 9090h
Jmp return_engine

end_handler_ring0:

Call $+5                    ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

; signal main thread we are ready to rock and allocated ourself somewhere else
Mov Ecx, [back_jump+ebp]
Mov dword ptr [Ecx+4], 1

; idle loop ... wait for other thread
Mov Eax, [Ebp+wait_idle1]   ; used for idling till writeprocess occours (cannot read from other thread here...)
sync_rewrite:
Cmp Eax, dword ptr [Ecx]
Je sync_rewrite

Mov word ptr [r3_patch+Ebp], 9090h   ; do not check for other selector like in r0

; set unhandled exception filter
Lea Eax, [Ebp+exception_handler]
Push Eax
Push dword ptr FS:0
Mov FS:0, Esp

; reserve stack and fake the entry seg:esp=exc api
Sub Esp, 200h
Mov Eax, [fake_exc+Ebp]
Mov [Esp], Eax

db 0B8h ; Mov Eax, back_jump
back_jump dd 0

; enable trapflag
PushFD
Pop Ebx
Or Bh, 00000001b   ; enable TF (bit 8)
Push Ebx
PopFD

; return to victim program
Jmp Eax

;++
; Tracer engine
;
; In fact this is our exception handler which will follow every instruction
; beeing executed in the victim thread. The tracer emulates API calls if
; any are traced into and also waits for a original entry point to be reached.
;--
exception_handler:

Mov Eax, Ebp                      ; save ebp (eax not neccassary to be saved)

Call $+5                          ; Ebp=instruction pointer (delta offset)
Pop Ebp
Sub Ebp, offset $-1

Call save_kernel_regs                  ; save most regs for freqasm

Mov Edi, dword ptr [Esp+4]             ; exception_record
Mov Esi, dword ptr [Esp+0Ch]           ; exception_context

Cmp dword ptr [ebp+kernel_freqasm], 0
Jne emulate_thread_exc
Cmp dword ptr [edi+exception_flags], 0 ; continuable exception / nested
Mov Edx, offset fatal_1                ; if an exception occours in our
Jne exit_fault                         ; exceptionhandler...exit with dbg info
Cmp dword ptr [api_offset+ebp], 0                       
Jne emulate_api                        ; stepped over victim api call?
Cmp dword ptr [edi+exception_code], 80000004h
Mov Edx, offset fatal_2                ; filter singlestepping
Jne standard_exc

continue_exc_handling:

Cmp [ebp+eip_flag], 0
Je _no_write_eip
Call write_current_eip
jmp _no_am_alive
_no_write_eip:

Inc word ptr [ebp+alive_ready]
Cmp [ebp+alive_ready], 0C000h
Jne _no_am_alive
Mov [ebp+alive_ready], 0
Lea Eax, [Ebp+am_alive_status-1]
_seek2:
Inc Eax
Cmp byte ptr [Eax], 0
Jne _seek2
Mov Dl, [ebp+alive_status_byte]
Mov [Eax], Dl
_alive3:
Mov Dl, [Eax+1]
Cmp Dl, 1
Je _alive2
Mov [ebp+alive_status_byte], Dl
Mov byte ptr [Eax+1], 0
jmp _alive4
_alive2:
Lea Eax, [Ebp+am_alive_status]
jmp _alive3
_alive4:
Lea Eax, [Ebp+am_alive_status]
Call [ebp+api_SetWindowTextA], [ebp+temp1], eax
_no_am_alive:

;- check if traced into api call
Mov Edx, [esi+victim_eip]
db 81h, 0FAh ; Cmp Edx, dword
end_all_sections dd 0C913379h ; compare (dword is patched of course)
Jb tf_return_kernel

rewrite_api:
Cmp Edx, 20000000h
Jb tf_return_kernel

Mov Eax, [esi+victim_esp]   ; it is neccassary to use the last esp because
Mov Edx, [Eax]              ; some api calls have a push as first instr.....                         
Push Edx
Cmp [ebp+report_flag], 0
Je no_report_api
Call report_api_call
no_report_api:
Pop Ecx

; check if traced into exitprocess api
Mov Edx, [esi+victim_eip]
Cmp Edx, [Ebp+api_ExitProcess]
Jne no_exitprocess 
Lea Eax, [ebp+temp1]
Call [api_EndDialog+Ebp], Eax, 0 
Mov Ebx, [ebp+back_jump]       ; get pointer to EP
Mov dword ptr [Ebx], 0FB1C1A0h ; sign for other thread (termination flag)
Jmp $ ; wait for other thread to close this thread and main process + gui
no_exitprocess:

; check for createprocess, dump if found
Cmp Edx, [Ebp+api_CreateProcessA]
Jne terminate_api

PushAD
Lea Eax, [tracer_dump1+Ebp]
Lea Ebx, [tracer_dump2+Ebp]
Call [ebp+api_MessageBoxA], 0, Ebx, Eax, 10h
Mov Eax, [esi+victim_esp]
Mov Eax, [eax+8] ; ds:esp+8 = file
Lea Ebx, [ebp+createp_dump]
Inc byte ptr [Ebx+9]
Call [ebp+api_CopyFileA], Eax, Ebx, 1 ; (overwrite if exist)
PopAD

terminate_api: Mov Al, byte ptr [Ecx]    ; save byte for later
Mov byte ptr [ebp+api_emulation], Al     ; save
cc_write_error: Mov byte ptr [Ecx], 0CCh ; insert bp (int3)
Mov dword ptr [ebp+api_offset], Ecx      ; save pointer
jmp return_kernel

emulate_api:
Mov Edx, dword ptr [ebp+api_offset]  ; get pointer where we put cc
Mov Al, byte ptr [ebp+api_emulation] ; get saved byte
Mov byte ptr [Edx], Al               ; and replace
Mov dword ptr [esi+victim_eip], Edx  ; point to that eip
Mov dword ptr [ebp+api_offset], 0    ;

tf_return_kernel:

Mov Edx, [esi+victim_eip]
Cmp [Ebp+flag_oep1], 1
Jne search_oep
Cmp [Edx], 4300B8C3h
Jne continue_tr
Cmp [Edx+4], 01EB0000h
Jne continue_tr
Mov Eax, [esi+victim_esp]
Mov Edx, [Eax]
Mov [esi+victim_eip], Edx
jmp oep_reached

search_oep:
Call generic_oep_seeker
Cmp Eax, 0
Je continue_tr

oep_reached:
Mov Ebx, [ebp+back_jump]        ; get pointer to EP (not oep ;)
Mov dword ptr [Ebx], 0deadc0deh ; sign for other thread
Mov dword ptr [Ebx+4], Edx      ; write retrieved OEP
Mov FS:dword ptr [0], 0         ; signal standard exc handler

Call [Ebp+api_GetCurrentProcess]
Call [Ebp+api_SetPriorityClass], Eax, 40h    ; set thread to idle (speed increase)
jmp $                                        ; wait for other process
continue_tr:

; emulate interrupts (some int handler switch modes)
Cmp byte ptr [Edx], 0CDh
Jne no_int
Mov Ecx, Edx
Add Ecx, 2                     ; break after int mnemonic
jmp terminate_api              ; put int3 at ecx, save it before...
no_int:

; emulate PushFD instruction (hide trapflag from victim thread)
Mov Edx, [Esi+victim_eip]
Cmp byte ptr [Edx], 9Ch
Jne no_psfd
Sub dword ptr [Esi+victim_esp], 4 ; dword
Mov Ebx, [Esi+victim_esp]         ; current esp pointer
Mov Eax, [Esi+victim_flags]
Mov [Ebx], Eax                    ; place victim flags without TF there
Inc dword ptr [Esi+victim_eip]
no_psfd:

; check for stack corruption
Cmp [Edx], 8BFC658Bh
Jne stack_aspr_sw
Add dword ptr [esi+victim_eip], 3
stack_aspr_sw:
Cmp [Edx], 0EBCF00C6h
Jne write_kern_lck
Cmp [esi+victim_eax], 0A0000000h
Jb write_kern_lck
Add dword ptr [esi+victim_eip], 3
write_kern_lck:
Cmp [Edx], 83EC8B55h
Jne no_stack_shrn
Mov Ecx, [esi+victim_esp]
Mov Ecx, [Ecx]
Cmp [Edx+4], 3D8304ECh
Je terminate_api
no_stack_shrn:

Mov [ebp+log_eip], Edx  ; save eip for last_eip feature
Or byte ptr [esi+victim_flags+1], 00000001b   ; enable TF (bit 8)

; detect modifications to our exception handler pointer at FS:0 (uncomplete)
Cmp dword ptr [Edx], 26896764h ; mov fs:reg, reg
Mov Eax, 6
Je _mnemonic_fs
Cmp word ptr [Edx], 8f64h      ; pop dword fs:0/reg
Mov Eax, 7
Je _mnemonic_fs2
Cmp word ptr [Edx], 8964h      ; mov fs:0, reg
Mov Eax, 3
Je _mnemonic_fs3
Cmp dword ptr [Edx], 068F6764h ; pop fs:reg, reg (eax=6)
Mov Eax, 6
Je _mnemonic_fs4
jmp return_kernel

_mnemonic_fs4:
Cmp word ptr [Edx+4], 0
Jne return_kernel
jmp __mnemonic_fs3 ;<<

_mnemonic_fs2:
Cmp dword ptr [Edx+2], 00000005h     ; pop dword fs:0
Je __mnemonic_fs3
Mov Bl, byte ptr [Edx+2]
Cmp byte ptr [Edx+2], 7              ; reg
Ja return_kernel
Mov Eax, 3
__mnemonic_fs3:
Add dword ptr [Esi+victim_esp], 4    ; add dword cause of POP dword instr.
Jmp _mnemonic_fs

_mnemonic_fs3:
Mov Bl, byte ptr [Edx+2]
Cmp Bl, 40h
Jae return_kernel                    ; really mov fs:reg, reg?
And Bl, 0Fh
Cmp Bl, 0Dh
Jne _mnemonic_fs
Mov Eax, 7

_mnemonic_fs:
Add dword ptr [Esi+victim_eip], Eax ; jump over fs modification
Mov Eax, [Esi+victim_esp]
Mov Eax, [Eax+4]
Mov [ebp+thread_exc_handler], Eax   ; save thread exc handler

return_kernel:

Call restore_kernel_regs
Xor Eax, Eax  ; flag freqasm to continue execution after exception
Ret           ; return to kernel

report_api_call: ;edx=at begin must be EIP to report
Lea Eax, [report_msg4+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_cs+esi]
Lea Eax, [report_msg3+ebp-4]
Call hexconvert
Mov Edx, dword ptr [victim_cs+esi]
Lea Eax, [report_msg3X+ebp-4]
Call hexconvert
Mov Edx, dword ptr [victim_cs+esi]
Lea Eax, [report_msg4X+ebp-4]
Call hexconvert

Mov Edx, [Ebp+log_eip]
Lea Eax, [report_msg5+ebp]
Call hexconvert
Mov Edx, [victim_eip+esi]
Push Edx
Lea Eax, [report_msg6+ebp]
Call hexconvert
Pop Eax

; check for known api function names
Cmp Eax, [Ebp+api_MessageBoxA]
Lea Esi, [Ebp+report_api1]
Je done_api_resolve
Cmp Eax, [Ebp+api_ReadProcessMemory]
Lea Esi, [Ebp+report_api2]
Je done_api_resolve
Cmp Eax, [Ebp+api_EndDialog]
Lea Esi, [Ebp+report_api3]
Je done_api_resolve
Cmp Eax, [Ebp+api_GetCurrentProcess]
Lea Esi, [Ebp+report_api4]
Je done_api_resolve
Cmp Eax, [Ebp+api_GlobalAlloc]
Lea Esi, [Ebp+report_api5]
Je done_api_resolve
Cmp Eax, [Ebp+api_SetWindowTextA]
Lea Esi, [Ebp+report_api6]
Je done_api_resolve
Cmp Eax, [Ebp+api_ExitProcess]
Lea Esi, [Ebp+report_api7]
Je done_api_resolve
Cmp Eax, [Ebp+api_VirtualProtect]
Lea Esi, [Ebp+report_api8]
Je done_api_resolve
Cmp Eax, [Ebp+api_VirtualAlloc]
Lea Esi, [Ebp+report_api9]
Je done_api_resolve
Cmp Eax, [Ebp+api_VirtualFree]
Lea Esi, [Ebp+report_api10]
Je done_api_resolve
Cmp Eax, [Ebp+api_LoadLibraryA]
Lea Esi, [Ebp+report_api11]
Je done_api_resolve
Cmp Eax, [Ebp+api_GetModuleHandleA]
Lea Esi, [Ebp+report_api12]
Je done_api_resolve
Cmp Eax, [Ebp+api_GetProcAddress]
Lea Esi, [Ebp+report_api13]
Je done_api_resolve
Cmp Eax, [Ebp+api_CreateProcessA]
Lea Esi, [Ebp+report_api14]
Je done_api_resolve
Cmp Eax, [Ebp+api_MoveFileA]
Lea Esi, [Ebp+report_api15]
Je done_api_resolve
Cmp Eax, [Ebp+api_CopyFileA]
Lea Esi, [Ebp+report_api16]
Je done_api_resolve
Cmp Eax, [Ebp+api_SetPriorityClass]
Lea Esi, [Ebp+report_api17]
Je done_api_resolve
Cmp Eax, [Ebp+api_GlobalLock]
Lea Esi, [Ebp+report_api18]
Je done_api_resolve

Lea Esi, [Ebp+report_api0]

done_api_resolve:
Lea Edi, [report_msg7+ebp]
Mov Ecx, 29d
Cld                      ; increase not decrease
Repz                     ; repeat till cx=0
Movsb                    ; set byte at ds:esi to es:edi

Mov dword ptr [ebp+report_msg3-4],  ' :nr'
Mov dword ptr [ebp+report_msg3X-4], ' :yr'  
Mov dword ptr [ebp+report_msg4X-4], ' :yr'  
Lea Eax, [Ebp+report_msg1]
Lea Ebx, [Ebp+report_msg2]
Push 0
Push Eax
Push Ebx
Push 0
Call [api_MessageBoxA+Ebp]
ret

standard_exc:

Mov Eax, [ebp+thread_exc_handler]
Cmp Eax, 0
Je exit_fault

Mov Ebx, dword ptr [Esp]
Mov [Ebp+kernel_freqasm], Ebx ; save kernel return address

Call restore_kernel_regs

; enable trapflag
PushFD
Pop Ebx
Or Bh, 00000001b   ; enable TF (bit 8)
Push Ebx
PopFD
Jmp Eax  ; return to thread exc handler

; an exception (usually) trapflag int1 occoured within an
; emulated exception handler
emulate_thread_exc:

Cmp dword ptr [Edi+exception_code], 80000004h ; our trapflag exception?
Jne standard_exc  ; if a "nested" or multipe exception occoured (that is an
                  ; exception in the active SEH) we will jump to new handler 

Mov Eax, [Ebp+kernel_freqasm]  ; get VA of freqasm_return_from_handler
Cmp Eax, [Esi+victim_eip]      ; check if this address has been traced into
Jne continue_exc_handling

Mov [Ebp+kernel_freqasm], 0    ; flag out_of_seh
Mov Eax, [Esi+victim_esp]
Mov Ecx, dword ptr [Eax+0Ch-4] ; exception_context from victim_handler
Mov Ecx, [Ecx+victim_eip]      ; get "victim_victim_eip" (eip return from emulated thread)
jmp terminate_api              ; put int3 at ecx, save it before...

debug_write_next_eip:          ; only used for debugging the ring3 tracer
Mov Edx, [esi+victim_eip] 
Lea Eax, [Ebp+error_except1]
Push Eax
Call hexconvert
Pop Eax
Push 0
Push eax
Push eax
Push 0
Call [api_MessageBoxA+Ebp]
Ret

write_current_eip:
PushAD
Mov Edx, dword ptr [esi+victim_eip]  ; get current eip
Lea Eax, [ebp+current_eip]
Call hexconvert
Lea Eax, [ebp+current_eip]
Call [ebp+api_SetWindowTextA], [ebp+temp1], eax
PopAD
Ret

save_kernel_regs:
Mov [kernel_ebp+ebp], eax ; save regs for freqasm/kernel
Mov [kernel_edi+ebp], edi
Mov [kernel_esi+ebp], esi
Mov [kernel_ecx+ebp], ecx
Mov [kernel_edx+ebp], edx
Ret

restore_kernel_regs:
Mov edi, [kernel_edi+ebp]
Mov esi, [kernel_esi+ebp]
Mov edx, [kernel_edx+ebp]
Mov ecx, [kernel_ecx+ebp]
Mov ebp, [kernel_ebp+ebp] ; restore regs for freqasm/kernel
Ret

;- (exit handler) if a non continuable fault or a non-tf exception occours
exit_fault:
; check if terminate api called...
Lea Ecx, [terminate_api+Ebp]
Lea Eax, [tracer_exit1+Ebp]
Lea Ebx, [tracer_exit2+Ebp]
Cmp Ecx, dword ptr [victim_eip+esi]
Je exit_tracer

; check if could not write to process
Lea Ecx, [cc_write_error+Ebp]
Lea Eax, [tracer_exit1+Ebp]
Lea Ebx, [tracer_write1+Ebp]
Cmp Ecx, dword ptr [victim_eip+esi]
Je exit_tracer

Push Edx
Mov Edx, dword ptr [esi+victim_eip]
Mov Edx, [Edx]
Lea Eax, [patch_exc10+8+ebp]
Call hexconvert                     
Mov Edx, dword ptr [esi+victim_eip]
Mov Edx, [Edx+8]
Lea Eax, [patch_exc10+ebp]
Call hexconvert                   

Mov Edx, dword ptr [victim_cs+esi]
Lea Eax, [patch_exc1+ebp-4]
Call hexconvert
Mov dword ptr [patch_exc1 -4 +ebp], ' ta ' ; at 
Mov Edx, dword ptr [victim_eip+esi]
Lea Eax, [patch_exc2+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_eax+esi]
Lea Eax, [patch_exc3+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_ebx+esi]
Lea Eax, [patch_exc4+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_ecx+esi]
Lea Eax, [patch_exc5+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_edx+esi]
Lea Eax, [patch_exc6+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_ebp+esi]
Lea Eax, [patch_exc7+ebp]
Call hexconvert
Mov Edx, dword ptr [victim_flags+esi]
Lea Eax, [patch_exc8+ebp]
Call hexconvert
Mov Edx, Esi
Pop Esi ; ESI=points to traceback msg
Add Esi, Ebp
Lea Edi, [patch_exc9+ebp]
Mov Ecx, 18d
Cld                      ; increase not decrease
Repz                     ; repeat till cx=0
Movsb                    ; set byte at ds:esi to es:edi

Lea Eax, [Ebp+error_except1]
Lea Ebx, [Ebp+error_except2]
exit_tracer:
Push 0
Push Eax
Push Ebx
Push 0
Call [api_MessageBoxA+Ebp]
Lea eax, [ebp+temp1]
Call [api_EndDialog+Ebp], eax, 0 

Mov Ebx, [ebp+back_jump] ; get pointer to EP
Mov dword ptr [Ebx], 0C0FEE00h ; sign for other thread (termination flag)
Jmp $ ; wait for other thread to close this thread and main process + gui

kernel_ebp dd 0
kernel_edi dd 0
kernel_esi dd 0
kernel_edx dd 0
kernel_ecx dd 0
api_offset    dd 0
fake_exc      dd 0
temp1         dd 0
wait_idle1    dd 0
log_eip       dd 0
current_eip   db '00000000',0
flag_oep1     db 0
eip_flag      db 0
report_flag   db 0
thread_exc_handler dd 0
kernel_freqasm dd 0
am_alive_status db 0,'TRACING',0,1
alive_ready dw 0
alive_status_byte db '>'
image_base_saved  dd 0

error_except1 db 'FATAL EXCEPTION ERROR',0
error_except2 db 'Unhandled exception occoured at '
                                  patch_exc1  db '0000:'
                                       patch_exc2  db '00000000',0Dh,0Ah
              db 'EAX='
         patch_exc3 db '00000000','  EBX='
                    patch_exc4 db '00000000','  ECX='
                              patch_exc5 db '00000000','  EDX='
                                        patch_exc6 db '00000000','  ',0Dh,0Ah
              db 'EBP='
         patch_exc7 db '00000000','  EFLAGS='
                                patch_exc8 db '00000000','  ',0Dh,0Ah
              db 'Fault traceback: '
                     patch_exc9 db 'Other exception... ['
                     patch_exc10 db '0000000000000000]',0

fatal_1       db 'Nested exceptions '
fatal_2       db 'Standard exception'

report_msg1   db 'Reporting API',0
report_msg2   db 0Dh,0Ah,'Thread API call entry: '
report_msg3X  db '0000:'
report_msg5        db '00000000',0Dh,0Ah
              db 'Thread API call return: '
report_msg3   db '0000:'
report_msg4        db '00000000',0Dh,0Ah
              db 'API entry: '
report_msg4X  db '0000:'
report_msg6        db '00000000',0Dh,0Ah
              db 'Function name: '
report_msg7   db 30d dup (0)

report_api0   db 'Unknown',0
report_api1   db 'MessageBox',0
report_api2   db 'ReadProcessMemory',0
report_api3   db 'EndDialog',0
report_api4   db 'GetCurrentProcess',0
report_api5   db 'GlobalAlloc',0
report_api6   db 'SetWindowText',0
report_api7   db 'ExitProcess',0
report_api8   db 'VirtualProtect',0
report_api9   db 'VirtualAlloc',0
report_api10  db 'VirtualFree',0
report_api11  db 'LoadLibrary',0
report_api12  db 'GetModuleHandle',0
report_api13  db 'GetProcAddress',0
report_api14  db 'CreateProcessA',0 
report_api15  db 'MoveFileA',0 
report_api16  db 'CopyFileA',0 
report_api17  db 'SetPriorityClass',0
report_api18  db 'GlobalLock',0

tracer_write1 db 'Failed to emulate API calls, write error occoured.',0
createp_dump  db 'UNPACKED00.exe',0
tracer_dump1  db 'Possible unpacked file found',0
tracer_dump2  db 'A call to CreateProcess was reached.',0Dh,0Ah
              db 'This usually means that a cryptor has written the',0Dh,0Ah
              db 'decrypted file to disk. GUW32 has created a copy',0Dh,0Ah
              db 'of this file (UNPACKED01.EXE).',0


end_tf_exc_setup:

cursor_setting:
Mov byte ptr [cursor_set+1], 107d
compare_patch:
Cmp [sectionsel], 0
Je cursor_set
Mov byte ptr [cursor_set+1], 108d
jmp $+2
cursor_set:Push 107d
Push [hInstance]
Call LoadCursorA
Call SetCursor, Eax
Ret

; call api, jmp [iat dword] -> get current VA of API for tracer engine
addr_MessageBoxA:       Call MessageBoxA
addr_ReadProcessMemory: Call ReadProcessMemory
addr_EndDialog:         Call EndDialog
addr_GetCurrentProcess: Call GetCurrentProcess
addr_GlobalAlloc:       Call GlobalAlloc
addr_SetWindowTextA:    Call SetWindowTextA
addr_ExitProcess:       Call ExitProcess
addr_VirtualProtect:    Call VirtualProtect
addr_VirtualAlloc:      Call VirtualAlloc
addr_VirtualFree:       Call VirtualFree
addr_LoadLibraryA:      Call LoadLibraryA
addr_GetModuleHandleA:  Call GetModuleHandleA
addr_GetProcAddress:    Call GetProcAddress
addr_CreateProcessA:    Call CreateProcessA
addr_MoveFileA:         Call MoveFileA
addr_CopyFileA:         Call CopyFileA
addr_SetPriorityClass:  Call SetPriorityClass
addr_GlobalLock:        Call GlobalLock

; error messages
error_open  db  'Error occoured',0,'Could not open file, probably already in use.',0
error_allocate db 'Fatal error occoured',0,'Could not allocate neccassary memory for file.',0Dh,0Ah
               db 'At least 5 MB of free RAM is required.',0
error_LE     db 'Wrong filetype',0,'This file is a Linear Executable and not a PE.',0
error_NE     db 'Wrong filetype',0,'This file is a New Executable and not a PE.',0
error_MZ     db 'Wrong filetype',0,'This file is a standard DOS executable and not a PE.',0
error_writeprocess  db 'Fatal error occoured',0,'Failed to write to process.',0
error_mem0     db 'Not enough free RAM',0
error_mem1     db 'There has not been enough free memory to resize all sections.',0Dh,0Ah
               db 'UNPACKED.EXE will probably be bigger then it should be!',0Dh,0Ah
               db 'To avoid this, free up more memory next time.',0
error_imprec0  db 'IMPREC.DLL error',0
error_imprec1  db 'Failed to rebuild importtable! UNPACKED.EXE created anyway',0
error_imprec2  db 'IMPREC.DLL error',0,'Failed to open/load ImpREC.DLL, put the file into the current directory.',0
error_sice0    db 'SoftICE loaded',0
error_sice1    db 'When SoftICE is loaded, GUW32 cannot unpack executables which',0Dh,0Ah
               db 'do not run under SoftICE either! You should unload it!',0
error_trapflag db 'Tracer warning',0,'A debugger was found which might cause tracing problems.',0
error_detect1  db 'Warning',0
error_detect2  db 'Does not seem to be protected by Unknown 1.2c! Continue anyway?',0
error_general  db 'General program error',0,'An invalid instruction has been executed within the main code!',0Dh,0Ah
               db 'GUW32 is unable to continue. The place of the exception was at '
error_general0 db '0000:'
error_general1 db '00000000',0
error_nt0      db 'Windows NT or Windows 2000 found!',0
error_nt1      db 'GUW32 ring0 tracer cannot yet operate under these operationsystems!',0Dh,0Ah
               db 'The ring3 tracer will be used instead, please notice the following:',0Dh,0Ah
               db ' - the ring3 tracer is very slow',0Dh,0Ah
               db ' - cannot unpack as much cryptors as the ring0 one can (see support.txt)',0Dh,0Ah
               db ' - executables which do not run from Win2000/NT can of course not be unpacked',0


error_retrieve db 'Failed to retrieve pointer to pm_fault vector table',0,'Either you are not running from Windows 9x/Me',0Dh,0Ah
               db 'or another debugger/tool is loaded (e.g. Icedump or Frogsice) - please unload first and try again!',0

pre_save_alloc db (end_tf_exc_setup - tf_exc_setup) dup (0) ; for presaving ep

.code

CHRiSTOPH:

; user selects file
Call GetOpenFileNameA, offset ofn_struct
Mov active_open, 0
Cmp filename, 0
Je no_inp9

file_specified:

; Calculate offsets to currently relocated api calls (for exception handler)
Call calc_virtual_api
Call test_trapflag ; check if TF can be set, check for sice loaded

; set unhandled exception filter
Push offset exception_handler3
Push dword ptr FS:0
Mov FS:0, Esp
Call test_r0_tracer

; open the file
Call CreateFileA, offset filename, 80000000h+40000000h, 0, 0, 3, 80h, 0
Mov DS:dword ptr [handle], Eax
Cmp Eax, -1
Mov Edx, offset error_open
Je error_msg

; set file pointer to reloc offset in dos header
Call SetFilePointer, [handle], 3Ch, 0, 0

;read the reloc offset dword
Call ReadFile, [handle], offset dos_reloc_offs, 4, offset huh, 0

;set pointer to begin of file
Call SetFilePointer, [handle], 0, 0, 0

; get and save size of whole file
Push 0
Push handle
Call GetFileSize
Mov filesize, Eax
Cmp Eax, DS:dword ptr [dos_reloc_offs]
Ja ok_reloc
Mov dos_reloc_offs, 0
ok_reloc:

;allocate memory for whole file
Sub Eax, [dos_reloc_offs]; EAX=size of pe header+sections
Mov pefilesize, Eax
Push [filesize]          ; size of mem to allocate
Push 0
Call GlobalAlloc         ; EAX on return=pointer to freed mem area
Cmp Eax, 0
Mov Edx, offset error_allocate
Je error_msg

Mov [image], Eax

;read whole file except of DOS stub into allocated mem
Call ReadFile, [handle], [image], [filesize], offset huh, 0
Mov [huh], 0
Call CloseHandle, [handle]      ; close file

;EBP=points to mem area for the rest of the thread
Mov Ebp, [image]
Add Ebp, [dos_reloc_offs]

;check the type of the executable file
Cmp DS:dword ptr [Ebp], 0000454Ch   ; 0,0,E,L (LE Signature)
Mov Edx, offset error_LE
Je  error_msg                       ; LE - Executable
Cmp DS:dword ptr [Ebp], 3C05454Eh   ; E,N,0,0 (NE Signature)
Mov Edx, offset error_NE
Je  error_msg                       ; NE - Executable
Cmp DS:dword ptr [Ebp], 00004550h   ; 0,0,E,P (PE Signature)
Mov Edx, offset error_MZ
Jne error_msg                       ; Anything else (most likely dos then)

Call setup_bpm_oep          ; find a writable section for bpm (->OEP seeker)
Call setup_OEP_seeker

; set up dlg text for up coming info dialog
Call traverse_file
Push offset return_from_first

info_dlg_set:
Mov Edx, [Ebp+entry_point]
Mov Eax, offset edit_patch4
Call hexconvert
Mov Edi, offset edit_patch4
Call str_zeroout
Mov byte ptr [Edi], 'h'

Mov Edx, [Ebp+image_base]
Mov Eax, offset edit_patch5
Call hexconvert
Mov Edi, offset edit_patch5
Call str_zeroout
Mov word ptr [Edi], 0068h

Xor Edx, Edx
Mov Dx, [Ebp+number_sections]
Call hex2dec
Mov Edx, Ebx
Mov Eax, offset edit_patch6
Call hexconvert
Mov Edi, offset edit_patch6
Call str_zeroout

Mov Edx, [Ebp+image_size]
Mov Eax, offset edit_patch7
Call hexconvert
Mov Edi, offset edit_patch7
Call str_zeroout
Mov word ptr [Edi], 0068h

Mov Dx, [ep_section]
Call pointer_to_section
Mov Edi, offset edit_patch8
Mov Esi, Ecx
Mov Ecx, 8  ; section name length
PushAD
Cld
Repz
Movsb
PopAD
Dec Edi
next_zero:
Inc Edi
Dec Ecx
Cmp Ecx, -1
Je done_zero
Cmp byte ptr [Edi], 0
Jne next_zero
Mov byte ptr [Edi], 20h
Jmp next_zero
done_zero:
Ret
return_from_first:

;detect and display some known packers/cryptors
Mov Eax, [ep_offset]

Cmp [Eax], 0002E860h ;aspack 2.11d
Mov Esi, offset detect_1
Jne _cryp_a
Cmp [Eax+4], 09EB0000h
Je cryptor_packer_found
_cryp_a:

Cmp [Eax], 4D3A03EBh ;bjfnt 1.3
Mov Esi, offset detect_2
Je cryptor_packer_found

Cmp word ptr [Eax], 0E860h ;aspack x.xx
Mov Esi, offset detect_3
Jne _cryp_b
Cmp byte ptr [Eax+6], 0EBh
Je cryptor_packer_found
_cryp_b:

Cmp [Eax], 04D9E960h ;aspr 1.1
Mov Esi, offset detect_4
Jne _cryp_c
Cmp word ptr [Eax+4], 0
Je cryptor_packer_found
_cryp_c:

Cmp [Eax], 001BE860h ;aspr 1.2
Mov Esi, offset detect_5
Jne _cryp_d
Cmp word ptr [Eax+5], 0E900h
Je cryptor_packer_found
_cryp_d:

Cmp [Eax], 0BB9C6660h ;lamecrypt 1.0
Mov Esi, offset detect_6
Je cryptor_packer_found

Cmp [Eax], 00E85055h  ;pcguard
Mov Esi, offset detect_7
Jne _cryple_d
Mov remove_sec, 0 ; do not remove last section
jmp cryptor_packer_found
_cryple_d:

Cmp [Eax+1Ah], 890BE983h  ;PCPEC
Mov Esi, offset detect_8
Je cryptor_packer_found

Cmp word ptr [Eax], 609Ch ;PCShrinker
Mov Esi, offset detect_9
Jne _cryp_e
Cmp word ptr [Eax+7], 0AD01h
Jne _cryp_e
Mov remove_sec, 0 ; do not remove last section
jmp cryptor_packer_found
_cryp_e:

Cmp [Eax], 006806EBh ;PECompact
Mov Esi, offset detect_10
Jne _cryp_f
Cmp [Eax+7], 0E8609CC3h
Je cryptor_packer_found
_cryp_f:

Cmp [Eax+5], 05EB835Bh ;pecrypt32
Mov Esi, offset detect_11
Je cryptor_packer_found

Cmp [Eax], 20CD03EBh ;pelocknt
Mov Esi, offset detect_12
Je cryptor_packer_found

Cmp [Eax], 00BE9C60h ;pemangle
Mov Esi, offset detect_13
Je cryptor_packer_found

Cmp dword ptr [Eax], 0000E860h ;pe-pack
Mov Esi, offset detect_14
Jne _cryp_g
Cmp [Eax+4], 835D0000h
Je cryptor_packer_found
_cryp_g:

Cmp [Eax], 3DE88358h ;upx<0.72
Mov Esi, offset detect_15
Jne _cryp_g2
Mov remove_sec, 0
jmp cryptor_packer_found
_cryp_g2:

Cmp word ptr [Eax+6], 0BE8Dh ;upx>0.72
Mov Esi, offset detect_16
Jne _cryp_h
Mov remove_sec, 0
Mov Ebx, Ebp
Mov Ecx, 2000d
_cryp_h2:
Inc Ebx
Cmp [Ebx], ':dI$'
Je _crypt_h3
loop _cryp_h2
Jmp cryptor_packer_found
_crypt_h3:
Add Ebx, 9
Mov Ecx, 6
Mov Edx, offset detect_16+4
_cryp_h4:
Cmp byte ptr [Ebx], 20h
Je _cryp_h5
Mov Al, [Ebx]
Mov [Edx], Al
Inc Edx
Inc Ebx
loop _cryp_h4
jmp cryptor_packer_found
_cryp_h5:
Mov byte ptr [Edx], 0
jmp cryptor_packer_found
_cryp_h:

Cmp [Eax], 0B88BC033h ;winkript
Mov Esi, offset detect_17
Je cryptor_packer_found

Cmp [Eax+6], 0F3ED815Dh ;yc12
Mov Esi, offset detect_18
Je cryptor_packer_found

Cmp [Eax+6], 08AED815Dh ;yc11
Mov Esi, offset detect_19
Je cryptor_packer_found

Cmp [Eax+0Ah], 6055C58Bh ;crunchv2
Mov Esi, offset detect_20
Je cryptor_packer_found

Cmp dword ptr [Eax], 0000AAE9h ;neolite
Mov Esi, offset detect_21
Je cryptor_packer_found

Cmp [Eax], 4550535Bh ;specb3
Mov Esi, offset detect_22
Je cryptor_packer_found

Cmp [Eax], 0ECE8559Ch ;vgcrypt075b
Mov Esi, offset detect_23
Je cryptor_packer_found

Cmp [Eax+0E9h], 0CDB5FF50h ;penightmare2
Mov Esi, offset detect_24
Je cryptor_packer_found

Cmp [Eax], 90909090h ;peninja10
Mov Esi, offset detect_25
Je cryptor_packer_found

Cmp [Eax], 0E89A01EBh ;noodlecr2
Mov Esi, offset detect_26
Jne _cryp_l
Cmp dword ptr [Eax+4], 00000076h
Jne _cryp_l
Mov [flag_oep1], 1
jmp cryptor_packer_found
_cryp_l:

Cmp [Eax], 10EDE860h ;telock071
Mov Esi, offset detect_27
Je cryptor_packer_found

Cmp [Eax], 002BE860h ;peshield025
Mov Esi, offset detect_28
Je cryptor_packer_found

Cmp [Eax], 0E88B5553h ;wwpack32
Mov Esi, offset detect_29
Jne _cryp_m
Mov Dx, 2 ; fix bug if first section not packed
Call pointer_to_section
Mov Ebx, [Eax]
Mov [section_bpm], Ebx
Mov Eax, [Ecx+section_rva]
Add Eax, [Ebp+image_base]
Mov [section_bpm_offset], Eax
jmp cryptor_packer_found
_cryp_m:

Cmp dword ptr [Eax+0Ah], 00000068h ;pklite32
Mov Esi, offset detect_30
Je cryptor_packer_found

Cmp dword ptr [Eax+18h], 8B04C483h ;shrinker34
Mov Esi, offset detect_31
Je cryptor_packer_found

Cmp dword ptr [Eax], 00032EE9h     ;codecrypt
Mov Esi, offset detect_32
Je cryptor_packer_found

Cmp dword ptr [Eax+0Dh], 202474FFh ;penight2
Mov Esi, offset detect_33
Je cryptor_packer_found

Cmp dword ptr [Eax+0Fh], 0000A164h ;armadillo
Mov Esi, offset detect_34
Je cryptor_packer_found

Cmp dword ptr [Eax+12h], 353295FFh ;stnpepak
Mov Esi, offset detect_35
Je cryptor_packer_found

Cmp dword ptr [Eax+1Ah], 3FC0C0ACh ;vbowatch
Mov Esi, offset detect_36
Je cryptor_packer_found

Cmp dword ptr [Eax], 0C00BC00Bh    ;timelock
Mov Esi, offset detect_37
Je cryptor_packer_found

Cmp dword ptr [Eax+0Bh], 01013881h ;xcr
Mov Esi, offset detect_38
Je cryptor_packer_found

Cmp dword ptr [Eax+20h], 000027B9h ;dbpe
Mov Esi, offset detect_39
Je cryptor_packer_found

Cmp dword ptr [Eax], 0000F5E9h     ;pex
Mov Esi, offset detect_40
Je cryptor_packer_found

Cmp dword ptr [Eax], 0E9240C8Bh    ;krypton
Mov Esi, offset detect_41
Je cryptor_packer_found

Mov Esi, offset detect_0 ; unknown packer/cryptor
cryptor_packer_found:

Push Esi
Xor Ecx, Ecx
_cryp_cx:
Inc Esi
Inc Ecx
Cmp byte ptr [Esi], 0
Jne _cryp_cx
Pop Esi

Mov Edi, offset edit_patch9
Cld
Repz
Movsb

Call EndDialog, [temp1], 0
Call DialogBoxParamA, hInstance, offset tracer_name, 0, offset tracer_proc, 0
re_back:

Mov Ebp, [image]
Add Ebp, [dos_reloc_offs] ; fix ebp (was overwritten by dlg)

Call make_section_writable

Mov [flag_tracer_gui], 2
Call DialogBoxParamA, hInstance, offset tracer_name2, 0, offset about_proc, 0
Cmp [cancel_guw], 1
Je termination_flagged
Call SetWindowTextA, [temp1], offset window_name3

; check if output file locked
try_new_file:
Call CreateFileA, offset newfilename, 80000000h+40000000h, 0, 0, 2, 80h, 0
Cmp Eax, -1
Jne file_not_locked
Cmp byte ptr [filename3+6], 'e'
Jne inc_it
Mov word ptr [filename3+6], '10'
Mov word ptr [newfilename+6], '10'
Mov word ptr [newfilename2+6], '10'
Jmp try_new_file
inc_it:
Inc byte ptr [filename3+7]
Inc byte ptr [newfilename+7]
Inc byte ptr [newfilename2+7]
Jmp try_new_file
file_not_locked:
Call CloseHandle, Eax
Call DeleteFileA, offset newfilename

; create a suspended process
Call CreateProcessA, offset filename, 0, 0, 0, 0, 4, 0, 0, offset startupinfo, offset processinfo

Mov Ebx, dword ptr [tf_exc_setup]
Mov [wait_idle1], Ebx  ; save dword at entry for synchronization with other thread later..
Mov [wait_idle2], Ebx
Mov Eax, Cs
Mov [thread_selector], Eax ; used for r0 tracer

; Save all data at entrypoint of file to current process
Mov Eax, [Ebp+image_base]
Mov [image_base_saved], Eax
Add Eax, [Ebp+entry_point]
Mov [back_jump], Eax                 ; jmp to EP after tf/exc has been setup
Mov [back_jump2], Eax
Push 0
Cmp [use_own_vector], 1
Je _use_1
Push end_tf_exc_setup - tf_exc_setup ; number of bytes to read
jmp over__use1
_use_1:
Push end_handler_ring0 - tf_exc_setup_ring0 ; number of bytes to read
over__use1:
Push offset pre_save_alloc           ; read to this offset
Push Eax                             ; VA of our created process to read from
Push [process_handle]                ; opened process handle
Call ReadProcessMemory

; attach our single step routine
Mov Eax, [back_jump]                 ; (get imagebase+entrypoint rva we stored)
Push 0
Cmp [use_own_vector], 1
Je use_1
Push end_tf_exc_setup - tf_exc_setup ; number of bytes to read
Push offset tf_exc_setup             ; write from this offset
jmp over_use_1
use_1:
Push end_handler_ring0 - tf_exc_setup_ring0 ; number of bytes to read
Push offset tf_exc_setup_ring0       ; write from this offset

Mov Edx, FS:[0]
Mov [fs_seh], Edx                    ; save seh stack chain for pointer to se handler

over_use_1:
Push Eax                             ; VA of our created process to write to
Push [process_handle]                ; opened process handle
Call WriteProcessMemory
Cmp Eax, 0
Mov Edx, offset error_writeprocess
Je error_msg

Call timeGetTime                     ; eax=current time
Mov [time_counter], Eax

; resume thread now
Call ResumeThread, dword ptr [thread_handle]

sync_victim:
Mov Eax, [back_jump] ; ep va
Add Eax, 4
Push 0
Push 4                               ; number of bytes to read
Push offset read_temp                ; read to this offset
Push Eax                             ; VA of our created process to read from
Push [process_handle]                ; opened process handle
Call ReadProcessMemory
Cmp dword ptr [read_temp], 1
Jne sync_victim

Push 0
Cmp [use_own_vector], 1
Je ___use_1
Push end_tf_exc_setup - tf_exc_setup ; number of bytes to write
jmp over___use_1
___use_1:
Push end_handler_ring0 - tf_exc_setup_ring0 ; number of bytes to write
over___use_1:

Push offset pre_save_alloc           ; write from this offset
Push [back_jump]                     ; VA of our created process to write to
Push [process_handle]                ; opened process handle
Call WriteProcessMemory

Call SetWindowTextA, [temp1], offset window_name4
Call GetCurrentProcess
Call SetPriorityClass, eax, 40h  ; set current thread to idle, for big speed increase

; wait till we traced tru the whole code...
idle_loop:

Cmp [use_own_vector], 0
Je _no_am_alive0
Inc word ptr [alive_ready]
Cmp [alive_ready], 2
Jne _no_am_alive0
Mov [alive_ready], 0
Mov Eax, offset am_alive_status-1
_seek20:
Inc Eax
Cmp byte ptr [Eax], 0
Jne _seek20
Mov Dl, [alive_status_byte]
Mov [Eax], Dl
_alive30:
Mov Dl, [Eax+1]
Cmp Dl, 1
Je _alive20
Mov [alive_status_byte], Dl
Mov byte ptr [Eax+1], 0
jmp _alive40
_alive20:
Mov Eax, offset am_alive_status
jmp _alive30
_alive40:
Call SetWindowTextA, [temp1], offset am_alive_status
_no_am_alive0:

Call PeekMessageA, offset temp_id, [temp1], 0, 0, 1 ; suspress "not responding" cause no control to dlg
Push 0
Push 8                               ; number of bytes to read
Push offset read_temp                ; read to this offset
Push [back_jump]                     ; VA of our created process to read from
Push [process_handle]                ; opened process handle
Call ReadProcessMemory
Cmp Eax, 0
Je tracer_terminated                 ; if tracer process gpf'd, quit too
Cmp dword ptr [read_temp], 00FB1C1A0h
Je termination_exit
Cmp dword ptr [read_temp], 0C0FEE00h
Je termination_exc
Cmp dword ptr [read_temp], 0deadc0deh
Jne idle_loop

Call GetCurrentProcess
Call SetPriorityClass, Eax, 20h ; set thread priority back to normal

Call SetWindowTextA, [temp1], offset window_stage1

;setup overlay writing
Mov Dx, [number_sections+ebp]
Call pointer_to_section
Mov Ebx, [Ecx+section_size2]
Add Eax, Ebx
Add Ebx, [Ecx+section_start]
Mov Ecx, [filesize]
Sub Ecx, Ebx
Mov [po_eax], Eax
Mov [am_ecx], Ecx

; allocate mem for decrypted thread
Push 02000000h          ; size of mem to allocate (use to store from other proccess)
Push 0                  ; (try to reserve 32mb ram for vsize)
Call GlobalAlloc        ; EAX on return=pointer to freed mem area
Cmp Eax, 0
Jne done_allocate
Push 01000000h          ; size of mem to allocate (use to store from other proccess)
Push 0                  ; (try 16mb if 32mb does not fit)
Call GlobalAlloc        ; EAX on return=pointer to freed mem area
Cmp Eax, 0
Jne done_allocate
Push 00500000h          ; size of mem to allocate (use to store from other proccess)
Push 0                  ; (try 5mb)
Call GlobalAlloc        ; EAX on return=pointer to freed mem area
Cmp Eax, 0
Mov Edx, offset error_allocate
Je error_msg
done_allocate:
Mov [image2], Eax

;create new file
Push 0
Push 80h                                ;attrib
Push 2                                  ;create file
Push 0
Push 0
Push 80000000h + 40000000h              ;r/w
Push offset newfilename                 ;filename to proceed with
Call CreateFileA                        ;EAX on return=file handle
Mov [handle2], Eax

;write to file
Push 0
Push offset huh
Push [dos_reloc_offs]                   ; ammount of bytes to write
Push [image]                            ; pointer to data to be written
Push [handle2]                          ; handle
Call WriteFile

;remove last section (97% that is protection code section)
Call remove_section

;add small personal sign
Cmp dword ptr [Ebp+number_symbols], 0
Jne no_perssign
Mov Esi, offset sign
Lea Edi, [Ebp+timedatestamp]
Mov Ecx, 8
Cld                      ; increase not decrease
Repz                     ; repeat till cx=0
Movsb                    ; set byte at ds:esi to es:edi
no_perssign:

; fix entrypoint
Mov Eax, dword ptr [read_temp+4]
Sub Eax, [Ebp+image_base]
Mov [Ebp+entry_point], Eax ; rva of OEP

;rebuild header (write all sections...)
Call write_sections

;set pointer to begin of PE header where we will then write rest
Push 0
Push 0
Push [dos_reloc_offs]
Push [handle2]
Call SetFilePointer

Mov Dx, 1
Call pointer_to_section
Mov Eax, dword ptr [Ecx+section_start] ; <- using section1 rawsize better then
Sub Eax, [dos_reloc_offs]              ;    using size_headers

;write to file fixed pe header & section table
Push 0
Push offset huh
Push Eax                                 ; ammount of bytes to write
Push Ebp                                 ; pointer to data to be written
Push [handle2]                           ; handle
Call WriteFile

;close new file
Call CloseHandle, [handle2]
Call GlobalFree, [image2]                ; deallocate second mem area

; Rebuild imports using MackT's imprec.dll
Cmp create_importtable, 1
Jne use_old_it
Call LoadLibraryA, offset lib_name       ; load the dll
Cmp Eax, 0
Mov Edx, offset error_imprec2
Je error_msg
Call GetProcAddress, Eax, offset func_name  ; get VA of export func in mem
; call export function
Call Eax, dword ptr [process_id], dword ptr [Ebp+entry_point], dword 0, offset newfilename
Cmp Eax, 0
Jne no_errormsg
Call MessageBoxA, 0, offset error_imprec1, offset error_imprec0, 30h
Mov Ebp, [image]
Add Ebp, [dos_reloc_offs]
jmp use_old_it

no_errormsg:
Call DeleteFileA, offset newfilename
Call MoveFileA, offset newfilename2, offset newfilename

; setup up stuff for displaying last info dlg
use_old_it:

Call timeGetTime
Mov Edx, Eax
Sub Edx, [time_counter]

Call hex2dec ;ebx=dec ouput of min.
Mov Edx, Ebx
Shr Edx, 4*3

Cmp Edx, 0
Je time_less_sec
Mov Ecx, Edx
Xor Edx, Edx
Mov Eax, Edx
Sub Ebx, Ebx
schmandmaul:
Inc Eax
Inc Ebx
Cmp Ebx, 0Ah
Jne rumtata
hurratata:
Xor Ebx, Ebx
Add Eax, 6
Sub Ecx, 6
Cmp Eax, 60h
Jne rumtata
Xor Eax, Eax
Inc Edx
rumtata:
Loop schmandmaul 
Mov Ebx, Edx     ;edx=minutes eax=seconds

Push Eax
Mov Ax, Bx
And Bl, 0F0h
Shr Bl, 4
Add Bl, 30h
Mov [edit_patch10], Bl
And Al, 0Fh
Add Al, 30h
Mov [edit_patch10+1], Al
Pop Ebx
Mov Ax, Bx
And Bl, 0F0h
Shr Bl, 4
Add Bl, 30h
Mov [edit_patch10+3], Bl
And Al, 0Fh
Add Al, 30h
Mov [edit_patch10+4], Al
jmp time_above_sec
time_less_sec:
Inc byte ptr [edit_patch10+4]

time_above_sec:
Call TerminateProcess, [process_handle], 0
Call EndDialog, [temp1], 0
Call CreateFileA, offset newfilename, 80000000h+40000000h, 0, 0, 3, 80h, 0
Mov [handle], Eax

Mov Eax, [dos_reloc_offs]
Add Eax, image_size
Call SetFilePointer, [handle], Eax, 0, 0
Lea Eax, [Ebp+image_size]
Call ReadFile, [handle], Eax, 4, offset huh, 0

Call GetFileSize, [handle], 0
Mov [filesize], Eax

; write overlay if existing
Call SetFilePointer, [handle], Eax, 0, 0 ; pointer to EOF
Push 0
Push offset huh
Push [am_ecx]                           ; ammount of bytes to write
Push [po_eax]                           ; pointer to data to be written
Push [handle]                           ; handle
Call WriteFile
Mov Eax, [am_ecx]
Add [filesize], Eax ; new size=size+overlay

Call CloseHandle, [handle]
Mov Esi, offset filename3
Mov Edi, offset edit_patch3
Mov Ecx, 13d
Cld
Repz
Movsb
Call traverse_continue
Mov Esi, offset edit_text8_
Mov Edi, offset edit_text8
Mov Ecx, 18d
Cld
Repz
Movsb

; seek for new ep section
Mov Edi, [ebp+entry_point]
_setup_oep0:
Xor Edx, Edx
setup_oep0:
Inc Edx
Push Edx
Call pointer_to_section
Pop Edx
Cmp Edi, dword ptr [Ecx+section_rva]
Je _check_oep0
Cmp Edi, dword ptr [Ecx+section_rva]
Jb setup_oep0
_check_oep0:
Mov Eax, [Ecx+section_rva]
Add Eax, [Ecx+section_size]
Cmp Edi, Eax
Jae setup_oep0 ; edx=section number which holds current EP
Mov [ep_section], Dx

Call info_dlg_set
Mov [flag_tracer_gui], 1
Call DialogBoxParamA, hInstance, offset tracer_name3, 0, offset about_proc, 0

termination_flagged:
Call TerminateProcess, [process_handle], 0
Call EndDialog, [temp1], 0
Call restore_old_int
Call GlobalFree, [image]     ;deallocate mem area
Call ExitProcess, 0

termination_exc:
Call EndDialog, [temp1], 0
Call DialogBoxParamA, hInstance, offset exc_name, 0, offset exc_proc, 0
jmp termination_flagged

termination_exit:
Call EndDialog, [temp1], 0
Call DialogBoxParamA, hInstance, offset exc_name2, 0, offset exc_proc, 0
jmp termination_flagged

tracer_terminated:
Call GlobalFree, [image]     ;deallocate mem area
Call EndDialog, [temp1], 0
Call restore_old_int
Call DialogBoxParamA, hInstance, offset exc_name3, 0, offset exc_proc, 0
Call ExitProcess, 0

restore_old_int: 
Cmp [use_own_vector], 0
Je return_immid

; hook intcallgate32 to do vmmcalls
Mov Eax, dword ptr [idt_pointer+2]
Mov Ebx, offset vxdcall_gate2      ; ebx=pointer to new int handler
Mov Ecx, [Eax+5*8]
Mov Edx, [Eax+5*8+4]
Mov [Eax+5*8], Bx                  ; low word of pointer to interrupt 5
Shr Ebx, 4*4                       ; bx=high word of ebx
Mov [Eax+6+5*8], Bx                ; high word of pointer to interrupt 5
Int 5

vxdcall_gate2:
Mov [Eax+5*8], Ecx                 ; restore old vector
Mov [Eax+5*8+4], Edx
Mov Esi, [pm_fault_01]             ; pointer to old int handler
Mov Eax, 1                         ; which int to hook
db 0CDh, 20h, 80h, 0, 1, 0         ; VMMCall Hook_PM_Fault
Mov Eax, offset return_immid
Mov dword ptr [Esp], Eax           ; fix reentrance crap
Iret
return_immid: Ret

;++
; Write error message handler
; Entry:
;       EDX     - pointer to error message + caption 
;--
error_msg:
Mov Ebx, Edx
_seek:
Inc Ebx
Cmp DS:byte ptr [Ebx-1], 0
Je _found
jmp _seek
_found:
Call MessageBoxA, 0, ebx, edx, 30h
exit_program:
Call GlobalFree, image     ;deallocate mem
Call GlobalFree, image2    ;deallocate second mem area
Call CloseHandle, handle   ;close file
Call TerminateProcess, [process_handle], 0
Call EndDialog, [temp1], 0
Call restore_old_int
Call ExitProcess, -1

;++
; Get import function VA for 'direct' API calling
; Entry:
;        None
; Return:
;        api_xxxxx    - Set to direct pointer to api call
;  
; When we want to use api calls from our singlestep exception
; handler which occours within another process, we first need
; to calculate the direct calling offsets by using the relocated
; api calls from the peloader at our main process.
;--
calc_virtual_api:
Mov Eax, dword ptr [addr_MessageBoxA+1]; CALL+1 ->dword
Add Eax, offset addr_MessageBoxA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_MessageBoxA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_ReadProcessMemory+1]; CALL+1 ->dword
Add Eax, offset addr_ReadProcessMemory +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_ReadProcessMemory, Eax         ; save it for our handler

Mov Eax, dword ptr [addr_EndDialog+1]; CALL+1 ->dword
Add Eax, offset addr_EndDialog +5 ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_EndDialog, Eax            ; save it for our handler

Mov Eax, dword ptr [addr_GetCurrentProcess+1]; CALL+1 ->dword
Add Eax, offset addr_GetCurrentProcess +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_GetCurrentProcess, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_GlobalAlloc+1]; CALL+1 ->dword
Add Eax, offset addr_GlobalAlloc +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_GlobalAlloc, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_SetWindowTextA+1]; CALL+1 ->dword
Add Eax, offset addr_SetWindowTextA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_SetWindowTextA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_ExitProcess+1]; CALL+1 ->dword
Add Eax, offset addr_ExitProcess +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_ExitProcess, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_VirtualProtect+1]; CALL+1 ->dword
Add Eax, offset addr_VirtualProtect +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_VirtualProtect, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_VirtualAlloc+1]; CALL+1 ->dword
Add Eax, offset addr_VirtualAlloc +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_VirtualAlloc, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_VirtualFree+1]; CALL+1 ->dword
Add Eax, offset addr_VirtualFree +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_VirtualFree, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_LoadLibraryA+1]; CALL+1 ->dword
Add Eax, offset addr_LoadLibraryA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_LoadLibraryA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_GetModuleHandleA+1]; CALL+1 ->dword
Add Eax, offset addr_GetModuleHandleA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_GetModuleHandleA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_GetProcAddress+1]; CALL+1 ->dword
Add Eax, offset addr_GetProcAddress +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_GetProcAddress, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_CreateProcessA+1]; CALL+1 ->dword
Add Eax, offset addr_CreateProcessA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_CreateProcessA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_MoveFileA+1]; CALL+1 ->dword
Add Eax, offset addr_MoveFileA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_MoveFileA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_CopyFileA+1]; CALL+1 ->dword
Add Eax, offset addr_CopyFileA +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_CopyFileA, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_SetPriorityClass+1]; CALL+1 ->dword
Add Eax, offset addr_SetPriorityClass +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_SetPriorityClass, Eax               ; save it for our handler

Mov Eax, dword ptr [addr_GlobalLock+1]; CALL+1 ->dword
Add Eax, offset addr_GlobalLock +5    ; + $ + 5 byte (call mnemonic)
Mov Ebx, dword ptr [Eax+2]             ; JMP [xx] ->dword pointer to pointer (at +2)
Mov Eax, dword ptr [Ebx]               ; final pointer to import object
Mov api_GlobalLock, Eax               ; save it for our handler
Ret

;++
; Calculate pointer to sectiontable x in memory and file offset to section
; Entry:
;        DX     - number of section to point to
; Return:
;        EAX    - pointer to specified section
;        ECX    - pointer to specified sectiontable
; 
;--
pointer_to_section:
Push Dx
Lea Ecx, [Ebp+18h]
Mov Ebx, dword ptr [Ebp+header2_size]  
And Ebx, 0000FFFFh
Add Ecx, Ebx                           ; ecx=pointer to first section
And Edx, 0000FFFFh
Dec Dx
Mov Eax, 28h                           ; length of a sectiontable
Imul Edx                               ; eax=eax*dx
Add Ecx, Eax                           ; ecx=pointer to sectiontable x
Mov Eax, dword ptr [section_start+Ecx] ; eax=file offset to section
Add Eax, Ebp
Sub Eax, dword ptr [dos_reloc_offs]    ; eax=mem offset to section start
Pop Dx
ret

;++
; Remove last section
;--
remove_section:
Cmp remove_sec, 0
Je no_remove
Mov Dx, word ptr [Ebp+number_sections] ; last section
Call pointer_to_section  ; ecx returns our favourite value

Mov Ebx, [ecx+section_size] ; get virtual size of last section
Sub [ebp+image_size], Ebx   ; for nt/2k we must substract that from image_size
Mov Edi, Ecx
Dec word ptr [number_sections+Ebp] ; decrease number_sections
Xor Eax, Eax
Mov Ecx, 28h             ; size of one single sectiontable
Cld                      ; increase not decrease
Repz                     ; repeat till cx=0
Stosb                    ; set byte in al to es:edi
no_remove: Ret

test_r0_tracer:
Cmp [use_own_vector], 0
Je return_im
Sidt fword ptr [idt_pointer]
Mov Eax, [idt_pointer+2]
idt_access_fault: Mov Eax, [Eax]

; hook intcallgate32 to do vmmcalls
Mov Eax, dword ptr [idt_pointer+2]
Mov Ebx, offset vxdcall_gate3      ; ebx=pointer to new int handler
Mov Ecx, [Eax+5*8]
Mov Edx, [Eax+5*8+4]
Mov [Eax+5*8], Bx                  ; low word of pointer to interrupt 5
Shr Ebx, 4*4                       ; bx=high word of ebx
Mov [Eax+6+5*8], Bx                ; high word of pointer to interrupt 5
Int 5

vxdcall_gate3:
Mov [Eax+5*8], Ecx                 ; restore old vector
Mov [Eax+5*8+4], Edx
Mov Eax, 1                         ; which int to unhook
db 0CDh, 20h, 7Eh, 0, 1, 0         ; VMMCall Get_Fault_Hook_Addrs (esi)
Mov [pm_fault_01], Esi
Mov Eax, offset return_immid
Mov dword ptr [Esp], Eax           ; fix reentrance crap
Iret

jmp return_im
nt_2k_bypass:
Mov [use_own_vector], 0
return_im:
Ret

;++
; Test if trapflag is working correctly
;
; Entry:
;       None
;
; If you are single stepping within an debugger... the TF might not
; work correctly. This procedure will check it.
;++
test_trapflag:


;Push offset exception_handler2 ; set exc
;Push dword ptr FS:0
;Mov FS:dword ptr [0], Esp
;Mov Ebp, 04243484Bh        ; 'BCHK'
;Mov Ax, 4
;Int 3       
return_from_test:
;Add Esp, 8
;Cmp Al, 4
;Jne no_sice
;Call MessageBoxA, 0, offset error_sice1, offset error_sice0, 30h
;no_sice:

Push offset exception_handler2 ; set exc
Push dword ptr FS:0
Mov FS:dword ptr [0], Esp
PushFD                         ; enable tf
Pop Eax
Mov Ebx, Eax
Or Ah, 00000001b
Push Eax
PopFD

Mov Edx, offset error_trapflag
jmp error_msg                  ; bp will occour now if no debugger
return_from_tf:                ; exception_context will point eip here
Push Ebx
PopFD
Pop dword ptr FS:[0]
Pop Eax
Ret

exception_handler2:
Mov Eax, [Esp]
Mov [thread_context_seh], Eax          ; save offset in kernel to ret_from_seh
Mov Esi, dword ptr [Esp+0Ch]           ; exception_context
Mov dword ptr [esi+victim_eip], offset return_from_tf
Xor Eax, Eax  ; flag freqasm to continue execution after exception
Ret           ; return to kernel

exception_handler4:
Mov Esi, dword ptr [Esp+0Ch]           ; exception_context
Mov dword ptr [esi+victim_eip], offset return_from_test
Xor Eax, Eax  ; flag freqasm to continue execution after exception
Ret           ; return to kernel


exception_handler3:
Mov Esi, dword ptr [Esp+0Ch]
Cmp dword ptr [victim_eip+esi], offset mem_allocate_error
Je bypass_mem
Cmp dword ptr [victim_eip+esi], offset idt_access_fault
Je nt_2k_idt

Mov Edx, dword ptr [victim_cs+esi]
Mov Eax, offset error_general0-4
Call hexconvert
Mov dword ptr [error_general0-4], ' ta ' ; at 
Mov Edx, dword ptr [victim_eip+esi]
Mov Eax, offset error_general1
Call hexconvert
Mov Edx, offset error_general
jmp error_msg

bypass_mem:

Call MessageBoxA, 0, offset error_mem1, offset error_mem0, 30h

Mov dword ptr [victim_eip+esi], offset end_unitialized_sect
Xor Eax, Eax
Ret

nt_2k_idt:
Call MessageBoxA, 0, offset error_nt1, offset error_nt0, 30h
Mov dword ptr [victim_eip+esi], offset nt_2k_bypass
Xor Eax, Eax
Ret


traverse_file:
Mov Eax, offset filename
Xor Ecx, Ecx
@@1:
Cmp byte ptr [Eax], 0
Je @@2
Inc Eax
Jmp @@1
@@2:
Cmp byte ptr [Eax], '\'
Je @@3
Dec Eax
Inc Ecx
Jmp @@2
@@3: Inc Eax
Mov Esi, Eax
Mov Edi, offset edit_patch3
Cld
Repz
Movsb
traverse_continue:
Mov word ptr [Edi-1], '( '
Add Edi, 2
Mov byte ptr [Edi-1], 20h
Mov Edx, [filesize]
Call hex2dec

Mov Edx, Ebx
Dec Edi
Mov Eax, Edi
Call hexconvert ;edx=dec output to convert

Call str_zeroout
Mov dword ptr [Edi], 'tyb '      ; byt
Mov dword ptr [Edi+4], ' )se'    ;es)
Mov byte ptr [Edi+7], 0
Ret

;++
; Remove zerores from string (4 bits 0)
; Entry:
;        EDI    - pointer to 8 byte string
;--
str_zeroout:
Mov Eax, Edi
Mov Ecx, 8
remove_zeroes:
Cmp byte ptr [Eax], 30h
Jne done_zeroes
Dec Ecx
Inc Eax
Cmp Ecx, 0
Jne remove_zeroes
done_zeroes:
Add Edi, 8
Cmp Ecx, 8
Je __ret_str
Sub Edi, 8
Mov Esi, Eax
Cld
Push Ecx
Mov Edx, Edi
Repz
Movsb
Pop Ecx
Push Edi
Mov Edi, Edx
Add Edi, Ecx
Mov Edx, 8
Sub Edx, Ecx
Mov Ecx, Edx
Mov Al, 20h
Repz
Stosb
Pop Edi
__ret_str:
Ret

;++
; Hexadecimal to Decimal converter
; Entry:
;        EDX    - input (hex)
; Return:
;        EBX    - output (dec)
; 
;--
hex2dec:
Xor Ebx, Ebx
Cmp Edx, 0
Je return_dec
Mov Ecx, Edx
_hex2dec:
Inc Ebx
Push Ecx
Mov Cl, 20h
_check_mod:
Mov Eax, Ebx
Sub Cl, 4
Shl Eax, Cl
Shr Eax, 1Ch
Cmp Al, 0Ah
Je mod_16
Cmp Cl, 0
Jne _check_mod
Pop Ecx
jmp no_mod
mod_16:
Mov Eax, 60000000h
Shr Eax, Cl
Add Ebx, Eax
Pop Ecx
no_mod:
Dec Ecx
Jne _hex2dec
return_dec:
Ret

;++
; Write sections from traced process
;
; Entry:
;       None
;
; Will write all sections from victim process alligned to mem offsets
; to their corresponding file allignments to a portable executable.
;++

write_sections: 

; preset raw and virtual allignment in header
Mov dword ptr [Ebp+section_align], 1000h ; vsize = 1000h * x
Mov dword ptr [Ebp+file_align], 200h     ; rsize = 200h  * x

;set pointer to file_offset section 1 in header
Mov Dx, 1
Call pointer_to_section
Mov Esi, Eax

; check if currently enough space in section table for another object
Mov Eax, dword ptr [Ecx+section_start]  ;>, Eax ; fix section 1 raw_offset
PushAD
Mov Dx, [Ebp+number_sections]
Call pointer_to_section ; get info for last section
Add Ecx, 28h*2 ; ECX=points to end of last section + another section
Sub Esi, Ecx
Cmp Esi, 0F0000000h
Jb no_need_update
PopAD
Add Eax, [Ebp+file_align]
Cmp Eax, 200h
Ja no_need2
Add Eax, [Ebp+file_align]
no_need2:
Mov dword ptr [Ecx+section_start], Eax
jmp _no_need
no_need_update:
PopAD
_no_need:
Mov [current_fpointer], Eax

write_sections_loop:
Inc [current_section] ; next section to proceed with

; set filepointer to raw_offset to write to
Call SetFilePointer, [handle2], [current_fpointer], 0, 0

; read from process (section x)
Mov Dx, [current_section]
Call pointer_to_section ; eax=pointer to first section, ecx=table..
Mov Ebx, dword ptr [Ecx+section_size]  ; use vsize of section as size
Cmp Ebx, dword ptr [Ecx+section_size2] ; compare to raw size
Jae vsize_bigger
Mov Ebx, dword ptr [Ecx+section_size2] ; use raw size
Mov dword ptr [Ecx+section_size], Ebx  ; fix
vsize_bigger:

; align proper section vsize, src reg=ebx
PushAD
Push Ecx
Xor Edx, Edx
Mov Eax, Ebx
Mov Ecx, 1000h
Idiv Ecx                     ; divide eax, ecx   result in eax:edx
Cmp Edx, 0
Je dont_incr
Inc Eax
dont_incr:
Shl Eax, 4*3                 ; shift 12 bits left
Pop Ecx
Mov [Ecx+section_size], Eax  ; set correctly alligned vsize
PopAD

Mov [Ecx+section_size2], Ebx ; set fsize to vsize (for compressors)
Push Ebx
Mov Eax, dword ptr [Ecx+section_rva]
Add Eax, [Ebp+image_base]    ; eax=where to read from in other process
Mov Ecx, [image2]            ; ecx=where to read to in current process
Call ReadProcessMemory, [process_handle], Eax, Ecx, Ebx, 0

Pop Ecx                      ; ecx=unresized raw size
Mov Edx, Ecx
Cmp Ecx, 0
Je end_unitialized_sect
Mov Eax, [image2]            ; eax=offset to begin of section we red
Add Eax, Ecx
Dec Eax
alligner_1:
mem_allocate_error: Cmp byte ptr [Eax], 0
Jne end_unitialized_sect
Dec Eax
Dec Edx
Loop alligner_1
end_unitialized_sect:        ; edx=resized section raw size
Push Edx
Mov Dx, [current_section]
Call pointer_to_section      ; eax=pointer to first section, ecx=table..
Pop Edx
Mov [Ecx+section_size2], Edx

; align proper section raw_offset, src reg=edx
PushAD
Mov Eax, Edx
Xor Edx, Edx
Mov Ecx, 200h
Idiv Ecx                     ; divide eax, ecx   result in eax:edx
Cmp Edx, 0
Je dont_incr2
Inc Eax
dont_incr2:
Mov Ebx, Eax
Mov Eax, 2
Imul Ebx                     ; multiply ebx, eax  result in eax:edx
Shl Eax, 4*2                 ; shift 1 byte left
Add [current_fpointer], Eax  ; add filepointer offset for raw_offset
Mov [current_rsize], Eax
PopAD

; fix raw_offset to section (in case of compressed file)
Mov Dx, [current_section]
Inc Dx
Cmp Dx, [Ebp+number_sections]
Ja _no_fpointer
Call pointer_to_section ; eax=pointer to first section, ecx=table..
Mov Eax, [current_fpointer]
Mov [Ecx+section_start], Eax
_no_fpointer:

;write to file, section x
Push 0
Push offset huh
Push [current_rsize]                    ; ammount of bytes to write
Push [image2]                           ; pointer to data to be written
Push handle2                            ; handle
Call WriteFile

Mov Ax, [current_section]
Cmp Ax, [ebp+number_sections]
Jb write_sections_loop
Ret

;++
; Make section of EP writable (virtualprotect caused crc failures sometimes)
;
; Entry:
;       None
;
; For the case that a decryptor section of a cryptor has not set itself
; writable. This is necassary for our api emulator to set breakpoints.
; Using virtualprotect to make it writable caused a few cryptors to
; display a wrong CRC error, that's why this is done thisway...
;++
make_section_writable:
Call CreateFileA, offset filename, 80000000h+40000000h, 0, 0, 3, 80h, 0
Mov [handle], Eax
Mov Dx, [ep_section]
Call pointer_to_section ;ecx returns mem offset to section table start
Cmp byte ptr [Ecx+section_flags], 20h
Je update_section
Cmp byte ptr [Ecx+section_flags+3], 60h
Jne do_nothing_sec
update_section:
Mov dword ptr [Ecx+section_flags], 0C0000040h
Mov Eax, [Ecx+section_start]
Mov Ebx, Ebp
Sub Ebx, [dos_reloc_offs]
Call WriteFile, [handle], Ebx, Eax, offset huh, 0
do_nothing_sec:
Call CloseHandle, [handle]   ;close file
Ret

;++
; Setup generic OEP seeker
;
; Entry:
;       None
;
; Used to setup our generic original entry point seek engine.
;++
setup_OEP_seeker:
Push Edi
Mov Edi, [ebp+entry_point]
_setup_oep:
Xor Edx, Edx
setup_oep:
Inc Edx
Push Edx
Call pointer_to_section
Pop Edx
Cmp Edi, dword ptr [Ecx+section_rva]
Je _check_oep
Cmp Edi, dword ptr [Ecx+section_rva]
Jb setup_oep
_check_oep:
Mov Eax, [Ecx+section_rva]
Add Eax, [Ecx+section_size]
Cmp Edi, Eax
Jae setup_oep ; edx=section number which holds current EP

; check if EP in last section, if not, then do not remove last section
Cmp Dx, [ebp+number_sections]
Je ep_in_last_section
Mov remove_sec, 0
ep_in_last_section:

Mov [ep_section], Dx
Call pointer_to_section ;eax=pointer to section start in mem
Mov Ebx, [Ecx+section_rva]
Push Edi
Sub Edi, Ebx
Add Eax, Edi
Pop Edi
Mov [ep_offset], Eax
Cmp byte ptr [Eax], 68h
Jne no_bypass_12
Cmp byte ptr [Eax+5], 0C3h
Jne no_bypass_12
Mov Edi, dword ptr [Eax+1]
Sub Edi, [Ebp+image_base]
Mov [ebp+entry_point], Edi
jmp _setup_oep

no_bypass_12:
Cmp word ptr [Eax], 0074h 
Jne no_bypass_pck
Cmp byte ptr [Eax+2], 0E9h
Jne no_bypass_pck
Add Edi, [Eax+3]
Add Edi, 7
Mov [ebp+entry_point], Edi
jmp _setup_oep

no_bypass_pck:
Mov Eax, [Ecx+section_rva]
Add Eax, [Ebp+image_base]
Mov [oep_begin_section], Eax
Mov Ebx, [Ecx+section_size]
Cmp Ebx, [Ecx+section_size2]
Ja add_vsize
Add Eax, [Ecx+section_size2]
jmp _add_rawsize
add_vsize:
Add Eax, Ebx
_add_rawsize:
Mov [oep_end_section], Eax
Pop Edi

; use current DX
Call pointer_to_section        ; eax=pointer to section start in mem
Mov Eax, [Ebp+image_base]
Add Eax, [Ecx+section_rva]
Add Eax, [Ecx+section_size]    ; eax=imagebase+section rva+section vsize
Mov [oep_our_code], Eax        ; for OEP seeker

; set up last section ending
Mov Dx, [Ebp+number_sections] ; get last section
Call pointer_to_section ;eax=pointer to section start in mem
Mov Eax, [Ebp+image_base]
Add Eax, [Ecx+section_rva]
Add Eax, [Ecx+section_size] ;eax=imagebase+section rva+section vsize
Mov [end_all_sections], Eax  ; for api checking
;>Mov [oep_our_code], Eax      ; for OEP seeker
Ret

;++
; Find writable section for generic_OEP_seeker
;
; Entry:
;       None
;
; This will save some info required to check if a section has been changed
; during tracing. This will then flag the OEP seeker that an original
; entry point can be reached in future.
;++
setup_bpm_oep:
Xor Esi, Esi
Mov Si, [ebp+number_sections]
Mov Edx, 1
setup_bpm:
Push Edx
Call pointer_to_section
Pop Edx
Cmp word ptr [Ecx+section_flags], 4   ;read/write
Je is_writable
Cmp word ptr [Ecx+section_flags], 8   ;write/copy
Je is_writable
Cmp word ptr [Ecx+section_flags], 40h ;execute/read/write
Je is_writable
Cmp word ptr [Ecx+section_flags], 80h ;execute/write/copy
Je is_writable
Cmp byte ptr [Ecx+section_flags+3], 0C0h ;comb
Je is_writable
Cmp byte ptr [Ecx+section_flags+3], 0E0h ;comb 2
Je is_writable
Inc Edx
Cmp Esi, Edx
Jne setup_bpm
Mov Dx, 1    ; umm, no writable section reached, anyway, using first one
Call pointer_to_section
is_writable: ; eax=pointer to section start
Mov Ebx, [Eax]
Mov [section_bpm], Ebx
Mov Eax, [Ecx+section_rva]
Add Eax, [Ebp+image_base]
Mov [section_bpm_offset], Eax
Ret

include gui.inc ; include the graphical user interface

End CHRiSTOPH

