// Import REConstructor DLL v1.01 (C) 2001 MackT/uCF
///////////////////////////////////////////////////////////////////////
// Class for the tracer level1 (disasm)
///////////////////////////////////////////////////////////////////////
// You're allowed to use parts of this code if you mention my name.
///////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Export.h"
#include "Disasm.h"


typedef BYTE byte;


//*******************
// TABLES of opcodes
//*******************
asminstdata asm86[] =
{ {"add",0x00,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,1},
  {"add",0x01,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,2},
  {"add",0x01,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,3},
  {"add",0x02,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,4},
  {"add",0x03,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,5},
  {"add",0x03,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,6},
  {"add",0x04,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,7},
  {"add",0x05,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,8},
  {"add",0x05,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,9},
  {"push",0x06,PROC_FROM8086,0,ARG_REG_ES,ARG_NONE,ARG_NONE,10},
  {"pop",0x07,PROC_FROM8086,0,ARG_REG_ES,ARG_NONE,ARG_NONE,11},
  {"or",0x08,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,12},
  {"or",0x09,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,13},
  {"or",0x09,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,14},
  {"or",0x0a,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,15},
  {"or",0x0b,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,16},
  {"or",0x0b,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,17},
  {"or",0x0c,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,18},
  {"or",0x0d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,19},
  {"or",0x0d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,20},
  {"push",0x0e,PROC_FROM8086,0,ARG_REG_CS,ARG_NONE,ARG_NONE,21},
  {NULL,0x0f,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,22},  //subtable 0x0f
  {"adc",0x10,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,23},
  {"adc",0x11,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,24},
  {"adc",0x11,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,25},
  {"adc",0x12,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,26},
  {"adc",0x13,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,27},
  {"adc",0x13,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,28},
  {"adc",0x14,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,29},
  {"adc",0x15,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,30},
  {"adc",0x15,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,31},
  {"push",0x16,PROC_FROM8086,0,ARG_REG_SS,ARG_NONE,ARG_NONE,32},
  {"pop",0x17,PROC_FROM8086,0,ARG_REG_SS,ARG_NONE,ARG_NONE,33},
  {"sbb",0x18,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,34},
  {"sbb",0x19,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,35},
  {"sbb",0x19,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,36},
  {"sbb",0x1a,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,37},
  {"sbb",0x1b,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,38},
  {"sbb",0x1b,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,39},
  {"sbb",0x1c,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,40},
  {"sbb",0x1d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,41},
  {"sbb",0x1d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,42},
  {"push",0x1e,PROC_FROM8086,0,ARG_REG_DS,ARG_NONE,ARG_NONE,43},
  {"pop",0x1f,PROC_FROM8086,0,ARG_REG_DS,ARG_NONE,ARG_NONE,44},
  {"and",0x20,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,45},
  {"and",0x21,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,46},
  {"and",0x21,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,47},
  {"and",0x22,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,48},
  {"and",0x23,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,49},
  {"and",0x23,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,50},
  {"and",0x24,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,51},
  {"and",0x25,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,52},
  {"and",0x25,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,53},
  {"es:",0x26,PROC_FROM8086,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,54},
  {"daa",0x27,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,55},
  {"sub",0x28,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,56},
  {"sub",0x29,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,57},
  {"sub",0x29,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,58},
  {"sub",0x2a,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,59},
  {"sub",0x2b,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,60},
  {"sub",0x2b,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,61},
  {"sub",0x2c,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,62},
  {"sub",0x2d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,63},
  {"sub",0x2d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,64},
  {"cs:",0x2e,PROC_FROM8086,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,65},
  {"das",0x2f,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,66},
  {"xor",0x30,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,67},
  {"xor",0x31,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,68},
  {"xor",0x31,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,69},
  {"xor",0x32,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,70},
  {"xor",0x33,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,71},
  {"xor",0x33,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,72},
  {"xor",0x34,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,73},
  {"xor",0x35,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,74},
  {"xor",0x35,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,75},
  {"ss:",0x36,PROC_FROM8086,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,76},
  {"aaa",0x37,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,77},
  {"cmp",0x38,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,78},
  {"cmp",0x39,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,79},
  {"cmp",0x39,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,80},
  {"cmp",0x3a,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,81},
  {"cmp",0x3b,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,82},
  {"cmp",0x3b,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,83},
  {"cmp",0x3c,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,84},
  {"cmp",0x3d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,85},
  {"cmp",0x3d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,86},
  {"ds:",0x3e,PROC_FROM8086,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,87},
  {"aas",0x3f,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,88},
  {"inc",0x40,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_NONE,ARG_NONE,89},
  {"inc",0x40,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_NONE,ARG_NONE,90},
  {"inc",0x41,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_CX,ARG_NONE,ARG_NONE,91},
  {"inc",0x41,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_CX,ARG_NONE,ARG_NONE,92},
  {"inc",0x42,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DX,ARG_NONE,ARG_NONE,93},
  {"inc",0x42,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DX,ARG_NONE,ARG_NONE,94},
  {"inc",0x43,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BX,ARG_NONE,ARG_NONE,95},
  {"inc",0x43,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BX,ARG_NONE,ARG_NONE,96},
  {"inc",0x44,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SP,ARG_NONE,ARG_NONE,97},
  {"inc",0x44,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SP,ARG_NONE,ARG_NONE,98},
  {"inc",0x45,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BP,ARG_NONE,ARG_NONE,99},
  {"inc",0x45,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BP,ARG_NONE,ARG_NONE,100},
  {"inc",0x46,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SI,ARG_NONE,ARG_NONE,101},
  {"inc",0x46,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SI,ARG_NONE,ARG_NONE,102},
  {"inc",0x47,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DI,ARG_NONE,ARG_NONE,103},
  {"inc",0x47,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DI,ARG_NONE,ARG_NONE,104},
  {"dec",0x48,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_NONE,ARG_NONE,105},
  {"dec",0x48,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_NONE,ARG_NONE,106},
  {"dec",0x49,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_CX,ARG_NONE,ARG_NONE,107},
  {"dec",0x49,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_CX,ARG_NONE,ARG_NONE,108},
  {"dec",0x4a,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DX,ARG_NONE,ARG_NONE,109},
  {"dec",0x4a,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DX,ARG_NONE,ARG_NONE,110},
  {"dec",0x4b,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BX,ARG_NONE,ARG_NONE,111},
  {"dec",0x4b,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BX,ARG_NONE,ARG_NONE,112},
  {"dec",0x4c,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SP,ARG_NONE,ARG_NONE,113},
  {"dec",0x4c,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SP,ARG_NONE,ARG_NONE,114},
  {"dec",0x4d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BP,ARG_NONE,ARG_NONE,115},
  {"dec",0x4d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BP,ARG_NONE,ARG_NONE,116},
  {"dec",0x4e,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SI,ARG_NONE,ARG_NONE,117},
  {"dec",0x4e,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SI,ARG_NONE,ARG_NONE,118},
  {"dec",0x4f,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DI,ARG_NONE,ARG_NONE,119},
  {"dec",0x4f,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DI,ARG_NONE,ARG_NONE,120},
  {"push",0x50,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_NONE,ARG_NONE,121},
  {"push",0x50,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_NONE,ARG_NONE,122},
  {"push",0x51,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_CX,ARG_NONE,ARG_NONE,123},
  {"push",0x51,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_CX,ARG_NONE,ARG_NONE,124},
  {"push",0x52,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DX,ARG_NONE,ARG_NONE,125},
  {"push",0x52,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DX,ARG_NONE,ARG_NONE,126},
  {"push",0x53,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BX,ARG_NONE,ARG_NONE,127},
  {"push",0x53,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BX,ARG_NONE,ARG_NONE,128},
  {"push",0x54,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SP,ARG_NONE,ARG_NONE,129},
  {"push",0x54,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SP,ARG_NONE,ARG_NONE,130},
  {"push",0x55,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BP,ARG_NONE,ARG_NONE,131},
  {"push",0x55,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BP,ARG_NONE,ARG_NONE,132},
  {"push",0x56,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SI,ARG_NONE,ARG_NONE,133},
  {"push",0x56,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SI,ARG_NONE,ARG_NONE,134},
  {"push",0x57,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DI,ARG_NONE,ARG_NONE,135},
  {"push",0x57,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DI,ARG_NONE,ARG_NONE,136},
  {"pop",0x58,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_NONE,ARG_NONE,137},
  {"pop",0x58,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_NONE,ARG_NONE,138},
  {"pop",0x59,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_CX,ARG_NONE,ARG_NONE,139},
  {"pop",0x59,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_CX,ARG_NONE,ARG_NONE,140},
  {"pop",0x5a,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DX,ARG_NONE,ARG_NONE,141},
  {"pop",0x5a,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DX,ARG_NONE,ARG_NONE,142},
  {"pop",0x5b,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BX,ARG_NONE,ARG_NONE,143},
  {"pop",0x5b,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BX,ARG_NONE,ARG_NONE,144},
  {"pop",0x5c,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SP,ARG_NONE,ARG_NONE,145},
  {"pop",0x5c,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SP,ARG_NONE,ARG_NONE,146},
  {"pop",0x5d,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BP,ARG_NONE,ARG_NONE,147},
  {"pop",0x5d,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BP,ARG_NONE,ARG_NONE,148},
  {"pop",0x5e,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SI,ARG_NONE,ARG_NONE,149},
  {"pop",0x5e,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SI,ARG_NONE,ARG_NONE,150},
  {"pop",0x5f,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DI,ARG_NONE,ARG_NONE,151},
  {"pop",0x5f,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DI,ARG_NONE,ARG_NONE,152},
  {"pusha",0x60,PROC_FROM80286,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,153},
  {"pushad",0x60,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,154},
  {"popa",0x61,PROC_FROM80286,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,155},
  {"popad",0x61,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,156},
  {"bound",0x62,PROC_FROM80286,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,157},
  {"arpl",0x63,PROC_FROM80286,FLAGS_PMODE|FLAGS_16BIT|FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,158},
  {"fs:",0x64,PROC_FROM80386,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,159},
  {"gs:",0x65,PROC_FROM80386,FLAGS_SEGPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,160},
  {"",0x66,PROC_FROM80386,FLAGS_OPERPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,161},
  {"",0x67,PROC_FROM80386,FLAGS_ADDRPREFIX,ARG_NONE,ARG_NONE,ARG_NONE,162},
  {"push",0x68,PROC_FROM80286,FLAGS_OMODE16,ARG_IMM,ARG_NONE,ARG_NONE,163},
  {"push",0x68,PROC_FROM80386,FLAGS_OMODE32,ARG_IMM,ARG_NONE,ARG_NONE,164},
  {"imul",0x69,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_IMM,165},
  {"push",0x6a,PROC_FROM80286,0,ARG_IMM8,ARG_NONE,ARG_NONE,166},
  {"imul",0x6b,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_IMM8,167},
  {"insb",0x6c,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,168},
  {"insw",0x6d,PROC_FROM80286,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,169},
  {"insd",0x6d,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,170},
  {"outsb",0x6e,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,171},
  {"outsw",0x6f,PROC_FROM80286,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,172},
  {"outsd",0x6f,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,173},
  {"jo",0x70,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,174},
  {"jno",0x71,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,175},
  {"jc",0x72,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,176},
  {"jnc",0x73,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,177},
  {"jz",0x74,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,178},
  {"jnz",0x75,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,179},
  {"jbe",0x76,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,180},
  {"ja",0x77,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,181},
  {"js",0x78,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,182},
  {"jns",0x79,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,183},
  {"jpe",0x7a,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,184},
  {"jpo",0x7b,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,185},
  {"jl",0x7c,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,186},
  {"jge",0x7d,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,187},
  {"jle",0x7e,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,188},
  {"jg",0x7f,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,189},
  {NULL,0x80,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,190},  //subtable 0x80
  {NULL,0x81,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,191},  //subtable 0x81
  {NULL,0x82,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,192},  //subtable 0x82
  {NULL,0x83,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,193},  //subtable 0x83
  {"test",0x84,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,194},
  {"test",0x85,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,195},
  {"test",0x85,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,196},
  {"xchg",0x86,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,197},
  {"xchg",0x87,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,198},
  {"xchg",0x87,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,199},
  {"mov",0x88,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,200},
  {"mov",0x89,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG,ARG_NONE,201},
  {"mov",0x89,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG,ARG_NONE,202},
  {"mov",0x8a,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG,ARG_MODRM,ARG_NONE,203},
  {"mov",0x8b,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,204},
  {"mov",0x8b,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,205},
  {"mov",0x8c,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM,ARG_SREG,ARG_NONE,206},
  {"lea",0x8d,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,207},
  {"lea",0x8d,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,208},
  {"mov",0x8e,PROC_FROM8086,FLAGS_MODRM,ARG_SREG,ARG_MODRM,ARG_NONE,209},
  {"pop",0x8f,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,210},
  {"pop",0x8f,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,211},
  {"nop",0x90,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,212},
  {"xchg",0x91,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_CX,ARG_NONE,213},
  {"xchg",0x91,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_CX,ARG_NONE,214},
  {"xchg",0x92,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_DX,ARG_NONE,215},
  {"xchg",0x92,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_DX,ARG_NONE,216},
  {"xchg",0x93,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_BX,ARG_NONE,217},
  {"xchg",0x93,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_BX,ARG_NONE,218},
  {"xchg",0x94,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_SP,ARG_NONE,219},
  {"xchg",0x94,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_SP,ARG_NONE,220},
  {"xchg",0x95,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_BP,ARG_NONE,221},
  {"xchg",0x95,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_BP,ARG_NONE,222},
  {"xchg",0x96,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_SI,ARG_NONE,223},
  {"xchg",0x96,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_SI,ARG_NONE,224},
  {"xchg",0x97,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_REG_DI,ARG_NONE,225},
  {"xchg",0x97,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_REG_DI,ARG_NONE,226},
  {"cbw",0x98,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,227},
  {"cwde",0x98,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,228},
  {"cwd",0x99,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,229},
  {"cdq",0x99,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,230},
  {"callf",0x9a,PROC_FROM8086,FLAGS_CALL|FLAGS_OMODE16,ARG_FADDR,ARG_NONE,ARG_NONE,231},
  {"callf",0x9a,PROC_FROM80386,FLAGS_CALL|FLAGS_OMODE32,ARG_FADDR,ARG_NONE,ARG_NONE,232},
  {"wait",0x9b,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,233},
  {"pushf",0x9c,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,234},
  {"pushfd",0x9c,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,235},
  {"popf",0x9d,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,236},
  {"popfd",0x9d,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,237},
  {"sahf",0x9e,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,238},
  {"lahf",0x9f,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,239},
  {"mov",0xa0,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_MEMLOC,ARG_NONE,240},
  {"mov",0xa1,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_MEMLOC,ARG_NONE,241},
  {"mov",0xa1,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_MEMLOC,ARG_NONE,242},
  {"mov",0xa2,PROC_FROM8086,FLAGS_8BIT,ARG_MEMLOC,ARG_REG_AL,ARG_NONE,243},
  {"mov",0xa3,PROC_FROM8086,FLAGS_OMODE16,ARG_MEMLOC,ARG_REG_AX,ARG_NONE,244},
  {"mov",0xa3,PROC_FROM80386,FLAGS_OMODE32,ARG_MEMLOC,ARG_REG_AX,ARG_NONE,245},
  {"movsb",0xa4,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,246},
  {"movsw",0xa5,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,247},
  {"movsd",0xa5,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,248},
  {"cmpsb",0xa6,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,249},
  {"cmpsw",0xa7,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,250},
  {"cmpsd",0xa7,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,251},
  {"test",0xa8,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,252},
  {"test",0xa9,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,253},
  {"test",0xa9,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,254},
  {"stosb",0xaa,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,255},
  {"stosw",0xab,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,256},
  {"stosd",0xab,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,257},
  {"lodsb",0xac,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,258},
  {"lodsw",0xad,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,259},
  {"lodsd",0xad,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,260},
  {"scasb",0xae,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,261},
  {"scasw",0xaf,PROC_FROM8086,FLAGS_OMODE16,ARG_NONE,ARG_NONE,ARG_NONE,262},
  {"scasd",0xaf,PROC_FROM80386,FLAGS_OMODE32,ARG_NONE,ARG_NONE,ARG_NONE,263},
  {"mov",0xb0,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,264},
  {"mov",0xb1,PROC_FROM8086,FLAGS_8BIT,ARG_REG_CL,ARG_IMM8,ARG_NONE,265},
  {"mov",0xb2,PROC_FROM8086,FLAGS_8BIT,ARG_REG_DL,ARG_IMM8,ARG_NONE,266},
  {"mov",0xb3,PROC_FROM8086,FLAGS_8BIT,ARG_REG_BL,ARG_IMM8,ARG_NONE,267},
  {"mov",0xb4,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AH,ARG_IMM8,ARG_NONE,268},
  {"mov",0xb5,PROC_FROM8086,FLAGS_8BIT,ARG_REG_CH,ARG_IMM8,ARG_NONE,269},
  {"mov",0xb6,PROC_FROM8086,FLAGS_8BIT,ARG_REG_DH,ARG_IMM8,ARG_NONE,270},
  {"mov",0xb7,PROC_FROM8086,FLAGS_8BIT,ARG_REG_BH,ARG_IMM8,ARG_NONE,271},
  {"mov",0xb8,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM,ARG_NONE,272},
  {"mov",0xb8,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM,ARG_NONE,273},
  {"mov",0xb9,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_CX,ARG_IMM,ARG_NONE,274},
  {"mov",0xb9,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_CX,ARG_IMM,ARG_NONE,275},
  {"mov",0xba,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DX,ARG_IMM,ARG_NONE,276},
  {"mov",0xba,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DX,ARG_IMM,ARG_NONE,277},
  {"mov",0xbb,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BX,ARG_IMM,ARG_NONE,278},
  {"mov",0xbb,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BX,ARG_IMM,ARG_NONE,279},
  {"mov",0xbc,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SP,ARG_IMM,ARG_NONE,280},
  {"mov",0xbc,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SP,ARG_IMM,ARG_NONE,281},
  {"mov",0xbd,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_BP,ARG_IMM,ARG_NONE,282},
  {"mov",0xbd,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_BP,ARG_IMM,ARG_NONE,283},
  {"mov",0xbe,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_SI,ARG_IMM,ARG_NONE,284},
  {"mov",0xbe,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_SI,ARG_IMM,ARG_NONE,285},
  {"mov",0xbf,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_DI,ARG_IMM,ARG_NONE,286},
  {"mov",0xbf,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_DI,ARG_IMM,ARG_NONE,287},
  {NULL,0xc0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,288},  //subtable 0xc0
  {NULL,0xc1,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,289},  //subtable 0xc1
  {"ret",0xc2,PROC_FROM8086,FLAGS_16BIT|FLAGS_RET,ARG_IMM,ARG_NONE,ARG_NONE,290},
  {"ret",0xc3,PROC_FROM8086,FLAGS_RET,ARG_NONE,ARG_NONE,ARG_NONE,291},
  {"les",0xc4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,292},
  {"les",0xc4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,293},
  {"lds",0xc5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,294},
  {"lds",0xc5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,295},
  {"mov",0xc6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,296},
  {"mov",0xc7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,297},
  {"mov",0xc7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,298},
  {"enter",0xc8,PROC_FROM80286,FLAGS_16BIT,ARG_IMM16_A,ARG_IMM8,ARG_NONE,299},
  {"leave",0xc9,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,300},
  {"retf",0xca,PROC_FROM8086,FLAGS_16BIT|FLAGS_RET,ARG_IMM,ARG_NONE,ARG_NONE,301},
  {"retf",0xcb,PROC_FROM8086,FLAGS_RET,ARG_NONE,ARG_NONE,ARG_NONE,302},
  {"int 3",0xcc,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,303},
  {"int",0xcd,PROC_FROM8086,FLAGS_8BIT,ARG_IMM8,ARG_NONE,ARG_NONE,304},
  {"into",0xce,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,305},
  {"iret",0xcf,PROC_FROM8086,FLAGS_RET,ARG_NONE,ARG_NONE,ARG_NONE,306},
  {NULL,0xd0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,307},  //subtable 0xd0
  {NULL,0xd1,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,308},  //subtable 0xd1
  {NULL,0xd2,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,309},  //subtable 0xd2
  {NULL,0xd3,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,310},  //subtable 0xd3
  {"aam",0xd4,PROC_FROM8086,FLAGS_8BIT,ARG_IMM8,ARG_NONE,ARG_NONE,311},
  {"aad",0xd5,PROC_FROM8086,FLAGS_8BIT,ARG_IMM8,ARG_NONE,ARG_NONE,312},
  {"setalc",0xd6,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,313}, //UNDOCUMENTED
  {"xlat",0xd7,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,314},
  {NULL,0xd8,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,315},  //subtable 0xd8
  {NULL,0xd9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,316},  //subtable 0xd9
  {NULL,0xda,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,317},  //subtable 0xda
  {NULL,0xdb,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,318},  //subtable 0xdb
  {NULL,0xdc,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,319},  //subtable 0xdc
  {NULL,0xdd,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,320},  //subtable 0xdd
  {NULL,0xde,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,321},  //subtable 0xde
  {NULL,0xdf,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,322},  //subtable 0xdf
  {"loopnz",0xe0,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,323},
  {"loopz",0xe1,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,324},
  {"loop",0xe2,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,325},
  {"jcxz",0xe3,PROC_FROM8086,FLAGS_CJMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,326},
  {"in",0xe4,PROC_FROM8086,FLAGS_8BIT,ARG_REG_AL,ARG_IMM8,ARG_NONE,327},
  {"in",0xe5,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_IMM8,ARG_NONE,328},
  {"in",0xe5,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_IMM8,ARG_NONE,329},
  {"out",0xe6,PROC_FROM8086,FLAGS_8BIT,ARG_IMM8,ARG_REG_AL,ARG_NONE,330},
  {"out",0xe7,PROC_FROM8086,FLAGS_OMODE16,ARG_IMM8,ARG_REG_AX,ARG_NONE,331},
  {"out",0xe7,PROC_FROM80386,FLAGS_OMODE32,ARG_IMM8,ARG_REG_AX,ARG_NONE,332},
  {"call",0xe8,PROC_FROM8086,FLAGS_CALL|FLAGS_OMODE16,ARG_RELIMM,ARG_NONE,ARG_NONE,333},
  {"call",0xe8,PROC_FROM80386,FLAGS_CALL|FLAGS_OMODE32,ARG_RELIMM,ARG_NONE,ARG_NONE,334},
  {"jmp",0xe9,PROC_FROM8086,FLAGS_JMP|FLAGS_OMODE16,ARG_RELIMM,ARG_NONE,ARG_NONE,335},
  {"jmp",0xe9,PROC_FROM80386,FLAGS_JMP|FLAGS_OMODE32,ARG_RELIMM,ARG_NONE,ARG_NONE,336},
  {"jmp",0xea,PROC_FROM8086,FLAGS_JMP|FLAGS_OMODE16,ARG_FADDR,ARG_NONE,ARG_NONE,337},
  {"jmp",0xea,PROC_FROM80386,FLAGS_JMP|FLAGS_OMODE32,ARG_FADDR,ARG_NONE,ARG_NONE,338},
  {"jmp",0xeb,PROC_FROM8086,FLAGS_JMP,ARG_RELIMM8,ARG_NONE,ARG_NONE,339},
  {"in",0xec,PROC_FROM8086,0,ARG_REG_AL,ARG_16REG_DX,ARG_NONE,340},
  {"in",0xed,PROC_FROM8086,FLAGS_OMODE16,ARG_REG_AX,ARG_16REG_DX,ARG_NONE,341},
  {"in",0xed,PROC_FROM80386,FLAGS_OMODE32,ARG_REG_AX,ARG_16REG_DX,ARG_NONE,342},
  {"out",0xee,PROC_FROM8086,0,ARG_16REG_DX,ARG_REG_AL,ARG_NONE,343},
  {"out",0xef,PROC_FROM8086,FLAGS_OMODE16,ARG_16REG_DX,ARG_REG_AX,ARG_NONE,344},
  {"out",0xef,PROC_FROM80386,FLAGS_OMODE32,ARG_16REG_DX,ARG_REG_AX,ARG_NONE,345},
  {"lock:",0xf0,PROC_FROM8086,FLAGS_PREFIX,ARG_NONE,ARG_NONE,ARG_NONE,346},
  {"smi",0xf1,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,347},  //UNDOCUMENTED/AMD ?
  {"repne:",0xf2,PROC_FROM8086,FLAGS_PREFIX,ARG_NONE,ARG_NONE,ARG_NONE,348},
  {"rep:",0xf3,PROC_FROM8086,FLAGS_PREFIX,ARG_NONE,ARG_NONE,ARG_NONE,349},
  {"hlt",0xf4,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,350},
  {"cmc",0xf5,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,351},
  {NULL,0xf6,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,352},  //subtable 0xf6
  {NULL,0xf7,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,353},  //subtable 0xf7
  {"clc",0xf8,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,354},
  {"stc",0xf9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,355},
  {"cli",0xfa,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,356},
  {"sti",0xfb,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,357},
  {"cld",0xfc,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,358},
  {"std",0xfd,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,359},
  {NULL,0xfe,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,360},  //subtable 0xfe
  {NULL,0xff,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,361},  //subtable 0xff
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

//Subtables needed - 0x0f, 0x80, 0x81, 0x82, 0x83, 0xc0, 0xc1,           ***done!
// 0xd0, 0xd1, 0xd2, 0xd3, 0xf6, 0xf7, 0xfe, 0xff                        ***done!
// 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf - FPU instructions
// 0x0f subtables : 0x00, 0x01, 0x18, 0x71, 0x72, 0x73, 0xae, 0xba, 0xc7 ***done!
//nb some instructions change when they have a segment overrider eg xlat.
// - how will this go in ?
//need to check undocumented instructions/amd insts- args/size/etc
//- setalc, smi

// subtable 0x0f
asminstdata asm86sub0f[]=
{ {NULL,0x00,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,1000}, //subtable 0x0f/0x00
  {NULL,0x01,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,1001}, //subtable 0x0f/0x01
  {"lar",0x02,PROC_FROM80286,FLAGS_PMODE|FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,1002},
  {"lar",0x02,PROC_FROM80386,FLAGS_PMODE|FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,1003},
  {"lsl",0x03,PROC_FROM80286,FLAGS_PMODE|FLAGS_MODRM|FLAGS_OMODE16,ARG_REG,ARG_MODRM,ARG_NONE,1004},
  {"lsl",0x03,PROC_FROM80386,FLAGS_PMODE|FLAGS_MODRM|FLAGS_OMODE32,ARG_REG,ARG_MODRM,ARG_NONE,1005},
  {"clts",0x06,PROC_FROM80286,FLAGS_PMODE,ARG_NONE,ARG_NONE,ARG_NONE,1006},
  {"invd",0x08,PROC_FROM80486,0,ARG_NONE,ARG_NONE,ARG_NONE,1007},
  {"wbinvd",0x09,PROC_FROM80486,0,ARG_NONE,ARG_NONE,ARG_NONE,1008},
  {"cflsh",0x0a,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,1009},
  {"ud2",0x0b,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,1010},
  {"movups",0x10,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1011},
  {"movups",0x11,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XMMMODRM,ARG_XREG,ARG_NONE,1012},
  {"movlps",0x12,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1013},
  {"movlps",0x13,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XMMMODRM,ARG_XREG,ARG_NONE,1014},
  {"unpcklps",0x14,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1015},
  {"unpckhps",0x15,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1016},
  {"movhps",0x16,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1017},
  {"movhps",0x17,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XMMMODRM,ARG_XREG,ARG_NONE,1018},
  {NULL,0x18,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,1019}, // subtable 0x0f/0x18
  {"mov",0x20,PROC_FROM80386,FLAGS_MODRM|FLAGS_32BIT,ARG_MODREG,ARG_CREG,ARG_NONE,1020},
  {"mov",0x21,PROC_FROM80386,FLAGS_MODRM|FLAGS_32BIT,ARG_MODREG,ARG_DREG,ARG_NONE,1021},
  {"mov",0x22,PROC_FROM80386,FLAGS_MODRM|FLAGS_32BIT,ARG_CREG,ARG_MODREG,ARG_NONE,1022},
  {"mov",0x23,PROC_FROM80386,FLAGS_MODRM|FLAGS_32BIT,ARG_DREG,ARG_MODREG,ARG_NONE,1023},
  {"mov",0x24,PROC_80386|PROC_80486,FLAGS_MODRM|FLAGS_32BIT,ARG_MODREG,ARG_TREG_67,ARG_NONE,1024},
  {"mov",0x26,PROC_80386|PROC_80486,FLAGS_MODRM|FLAGS_32BIT,ARG_MODREG,ARG_TREG,ARG_NONE,1025},
  {"movaps",0x28,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1026},
  {"movaps",0x29,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XMMMODRM,ARG_XREG,ARG_NONE,1027},
  {"cvtpi2ps",0x2a,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_MMXMODRM,ARG_NONE,1028},
  {"movntps",0x2b,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XMMMODRM,ARG_XREG,ARG_NONE,1029},
  {"cvttps2pi",0x2c,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_XMMMODRM,ARG_NONE,1030},
  {"cvtps2pi",0x2d,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_XMMMODRM,ARG_NONE,1031},
  {"ucomiss",0x2e,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1032},
  {"comiss",0x2f,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1033},
  {"wrmsr",0x30,PROC_FROMPENTIUM,0,ARG_NONE,ARG_NONE,ARG_NONE,1034},
  {"rdtsc",0x31,PROC_FROMPENTIUM,0,ARG_NONE,ARG_NONE,ARG_NONE,1035},
  {"rdmsr",0x32,PROC_FROMPENTIUM,0,ARG_NONE,ARG_NONE,ARG_NONE,1036},
  {"rdpmc",0x33,PROC_FROMPENTPRO,0,ARG_NONE,ARG_NONE,ARG_NONE,1037},
  {"sysenter",0x34,PROC_FROMPENTIUM2,0,ARG_NONE,ARG_NONE,ARG_NONE,1038},
  {"sysexit",0x35,PROC_FROMPENTIUM2,0,ARG_NONE,ARG_NONE,ARG_NONE,1039},
  {"cmovo",0x40,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1040},
  {"cmovno",0x41,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1041},
  {"cmovc",0x42,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1042},
  {"cmovnc",0x43,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1043},
  {"cmovz",0x44,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1044},
  {"cmovnz",0x45,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1045},
  {"cmovbe",0x46,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1046},
  {"cmova",0x47,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1047},
  {"cmovs",0x48,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1048},
  {"cmovns",0x49,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1049},
  {"cmovpe",0x4a,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1050},
  {"cmovpo",0x4b,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1051},
  {"cmovl",0x4c,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1052},
  {"cmovge",0x4d,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1053},
  {"cmovle",0x4e,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1054},
  {"cmovg",0x4f,PROC_FROMPENTPRO,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1055},
  {"movmskps",0x50,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_REG,ARG_XMMMODRM,ARG_NONE,1056},
  {"sqrtps",0x51,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1057},
  {"rsqrtps",0x52,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1058},
  {"rcpps",0x53,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1059},
  {"andps",0x54,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1060},
  {"andnps",0x55,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1061},
  {"orps",0x56,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1062},
  {"xorps",0x57,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1063},
  {"addps",0x58,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1064},
  {"mulps",0x59,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1065},
  {"subps",0x5c,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1066},
  {"minps",0x5d,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1067},
  {"divps",0x5e,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1068},
  {"maxps",0x5f,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,1069},
  {"punpcklbw",0x60,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1070},
  {"punpcklwd",0x61,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1071},
  {"punpckldq",0x62,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1072},
  {"packsswb",0x63,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1073},
  {"pcmpgtb",0x64,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1074},
  {"pcmpgtw",0x65,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1075},
  {"pcmpgtd",0x66,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1076},
  {"packuswb",0x67,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1077},
  {"punpckhbw",0x68,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1078},
  {"punpckhwd",0x69,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1079},
  {"punpckhdq",0x6a,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1080},
  {"packssdw",0x6b,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1081},
  {"movd",0x6e,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MODRM,ARG_NONE,1082},
  {"movq",0x6f,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1083},
  {"pshuf",0x70,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_IMM8,1084},
  {NULL,0x71,PROC_FROMPENTMMX,0,ARG_NONE,ARG_NONE,ARG_NONE,1085}, //subtable 0x0f/0x71
  {NULL,0x72,PROC_FROMPENTMMX,0,ARG_NONE,ARG_NONE,ARG_NONE,1086}, //subtable 0x0f/0x72
  {NULL,0x73,PROC_FROMPENTMMX,0,ARG_NONE,ARG_NONE,ARG_NONE,1087}, //subtable 0x0f/0x73
  {"pcmpeqb",0x74,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1088},
  {"pcmpeqw",0x75,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1089},
  {"pcmpeqd",0x76,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1090},
  {"emms",0x77,PROC_FROMPENTMMX,0,ARG_NONE,ARG_NONE,ARG_NONE,1091},
  {"movd",0x7e,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MODRM,ARG_MREG,ARG_NONE,1092},
  {"movq",0x7f,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_MREG,ARG_NONE,1093},
  {"jo",0x80,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1094},
  {"jno",0x81,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1095},
  {"jc",0x82,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1096},
  {"jnc",0x83,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1097},
  {"jz",0x84,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1098},
  {"jnz",0x85,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1099},
  {"jbe",0x86,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1100},
  {"ja",0x87,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1101},
  {"js",0x88,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1102},
  {"jns",0x89,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1103},
  {"jpe",0x8a,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1104},
  {"jpo",0x8b,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1105},
  {"jl",0x8c,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1106},
  {"jge",0x8d,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1107},
  {"jle",0x8e,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1108},
  {"jg",0x8f,PROC_FROM80386,FLAGS_CJMP,ARG_RELIMM,ARG_NONE,ARG_NONE,1109},
  {"seto",0x90,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1110},
  {"setno",0x91,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1111},
  {"setc",0x92,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1112},
  {"setnc",0x93,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1113},
  {"setz",0x94,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1114},
  {"setnz",0x95,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1115},
  {"setbe",0x96,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1116},
  {"seta",0x97,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1117},
  {"sets",0x98,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1118},
  {"setns",0x99,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1119},
  {"setpe",0x9a,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1120},
  {"setpo",0x9b,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1121},
  {"setl",0x9c,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1122},
  {"setge",0x9d,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1123},
  {"setle",0x9e,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1124},
  {"setg",0x9f,PROC_FROM80386,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,1125},
  {"push",0xa0,PROC_FROM80386,0,ARG_REG_FS,ARG_NONE,ARG_NONE,1126},
  {"pop",0xa1,PROC_FROM80386,0,ARG_REG_FS,ARG_NONE,ARG_NONE,1127},
  {"cpuid",0xa2,PROC_FROM80486,0,ARG_NONE,ARG_NONE,ARG_NONE,1128},
  {"bt",0xa3,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_NONE,1129},
  {"shld",0xa4,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_IMM8,1130},
  {"shld",0xa5,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_REG_CL,1131},
  {"push",0xa8,PROC_FROM80386,0,ARG_REG_GS,ARG_NONE,ARG_NONE,1132},
  {"pop",0xa9,PROC_FROM80386,0,ARG_REG_GS,ARG_NONE,ARG_NONE,1133},
  {"rsm",0xaa,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,1134},
  {"bts",0xab,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_NONE,1135},
  {"shrd",0xac,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_IMM8,1136},
  {"shrd",0xad,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_REG_CL,1137},
  {NULL,0xae,PROC_FROMPENTIUM2,0,ARG_NONE,ARG_NONE,ARG_NONE,1138}, //subtable 0x0f/0xae
  {"imul",0xaf,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1139},
  {"cmpxchg",0xb0,PROC_FROM80486,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,1140},
  {"cmpxchg",0xb1,PROC_FROM80486,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_NONE,1141},
  {"lss",0xb2,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1142},
  {"btr",0xb3,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_NONE,1143},
  {"lfs",0xb4,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1144},
  {"lgs",0xb5,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1145},
  {"movzx",0xb6,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM8,ARG_NONE,1146},
  {"movzx",0xb7,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM16,ARG_NONE,1147},
  {"ud1",0xb9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,1148},
  {NULL,0xba,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,1149}, //subtable 0x0f/0xba
  {"btc",0xbb,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_REG,ARG_NONE,1150},
  {"bsf",0xbc,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1151},
  {"bsr",0xbd,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM,ARG_NONE,1152},
  {"movsx",0xbe,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM8,ARG_NONE,1153},
  {"movsx",0xbf,PROC_FROM80386,FLAGS_MODRM,ARG_REG,ARG_MODRM16,ARG_NONE,1154},
  {"xadd",0xc0,PROC_FROM80486,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG,ARG_NONE,1155},
  {"xadd",0xc1,PROC_FROM80486,FLAGS_MODRM,ARG_MODRM,ARG_NONE,ARG_NONE,1156},
  {NULL,0xc2,PROC_FROMPENTIUM2,0,ARG_NONE,ARG_NONE,ARG_NONE,1157}, //subtable 0x0f/0xc7
  {"pinsrw",0xc4,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MODRM,ARG_IMM8,1158},
  {"pextrw",0xc5,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_REG,ARG_MMXMODRM,ARG_IMM8,1159},
  {"shufps",0xc6,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_IMM8,1160},
  {NULL,0xc7,PROC_FROMPENTMMX,0,ARG_NONE,ARG_NONE,ARG_NONE,1161}, //subtable 0x0f/0xc7
  {"bswap",0xc8,PROC_FROM80486,FLAGS_32BIT,ARG_REG_AX,ARG_NONE,ARG_NONE,1162},
  {"bswap",0xc9,PROC_FROM80486,FLAGS_32BIT,ARG_REG_CX,ARG_NONE,ARG_NONE,1163},
  {"bswap",0xca,PROC_FROM80486,FLAGS_32BIT,ARG_REG_DX,ARG_NONE,ARG_NONE,1164},
  {"bswap",0xcb,PROC_FROM80486,FLAGS_32BIT,ARG_REG_BX,ARG_NONE,ARG_NONE,1165},
  {"bswap",0xcc,PROC_FROM80486,FLAGS_32BIT,ARG_REG_SP,ARG_NONE,ARG_NONE,1166},
  {"bswap",0xcd,PROC_FROM80486,FLAGS_32BIT,ARG_REG_BP,ARG_NONE,ARG_NONE,1167},
  {"bswap",0xce,PROC_FROM80486,FLAGS_32BIT,ARG_REG_SI,ARG_NONE,ARG_NONE,1168},
  {"bswap",0xcf,PROC_FROM80486,FLAGS_32BIT,ARG_REG_DI,ARG_NONE,ARG_NONE,1169},
  {"psrlw",0xd1,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1170},
  {"psrld",0xd2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1171},
  {"psrlq",0xd3,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1172},
  {"pmullw",0xd5,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1173},
  {"pmovmskb",0xd7,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_REG,ARG_MMXMODRM,ARG_NONE,1174},
  {"psubusb",0xd8,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1175},
  {"psubusw",0xd9,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1176},
  {"pminub",0xda,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1177},
  {"pand",0xdb,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1178},
  {"paddusb",0xdc,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1179},
  {"paddusw",0xdd,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1180},
  {"pmaxub",0xde,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1181},
  {"pandn",0xdf,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1182},
  {"pavgb",0xe0,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1183},
  {"psraw",0xe1,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1184},
  {"psrad",0xe2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1185},
  {"pavgw",0xe3,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1186},
  {"pmulhuw",0xe4,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1187},
  {"pmulhw",0xe5,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1188},
  {"movntq",0xe7,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_MREG,ARG_NONE,1189},
  {"psubsb",0xe8,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1190},
  {"psubsw",0xe9,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1191},
  {"pminsw",0xea,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1192},
  {"por",0xeb,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1193},
  {"paddsb",0xec,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1194},
  {"paddsw",0xed,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1195},
  {"pmaxsw",0xee,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1196},
  {"pxor",0xef,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1197},
  {"psllw",0xf1,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1198},
  {"pslld",0xf2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1199},
  {"psllq",0xf3,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1200},
  {"pmaddwd",0xf5,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1201},
  {"psadbw",0xf6,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1202},
  {"maskmovq",0xf7,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1203},
  {"psubb",0xf8,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1204},
  {"psubw",0xf9,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1205},
  {"psubd",0xfa,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1206},
  {"paddb",0xfc,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1207},
  {"paddw",0xfd,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1208},
  {"paddd",0xfe,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MREG,ARG_MMXMODRM,ARG_NONE,1209},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x80
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub80[]=
{ {"add",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2000},
  {"or",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2001},
  {"adc",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2002},
  {"sbb",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2003},
  {"and",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2004},
  {"sub",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2005},
  {"xor",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2006},
  {"cmp",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,2007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x81
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub81[]=
{ {"add",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3000},
  {"add",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3001},
  {"or",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3002},
  {"or",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3003},
  {"adc",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3004},
  {"adc",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3005},
  {"sbb",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3006},
  {"sbb",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3007},
  {"and",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3008},
  {"and",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3009},
  {"sub",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3010},
  {"sub",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3011},
  {"xor",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3012},
  {"xor",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3013},
  {"cmp",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,3014},
  {"cmp",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,3016},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x82
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub82[]=
{ {"add",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4000},
  {"or",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4001},
  {"adc",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4002},
  {"sbb",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4003},
  {"and",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4004},
  {"sub",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4005},
  {"xor",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4006},
  {"cmp",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_SIMM8,ARG_NONE,4007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x83
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub83[]=
{ {"add",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5000},
  {"add",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5001},
  {"or",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5002},
  {"or",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5003},
  {"adc",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5004},
  {"adc",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5005},
  {"sbb",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5006},
  {"sbb",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5007},
  {"and",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5008},
  {"and",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5009},
  {"sub",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5010},
  {"sub",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5011},
  {"xor",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5012},
  {"xor",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5013},
  {"cmp",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_SIMM8,ARG_NONE,5014},
  {"cmp",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_SIMM8,ARG_NONE,5015},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xc0
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subc0[]=
{ {"rol",0x0,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6000},
  {"ror",0x1,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6001},
  {"rcl",0x2,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6002},
  {"rcr",0x3,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6003},
  {"shl",0x4,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6004},
  {"shr",0x5,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6005},
  {"sal",0x6,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6006},
  {"sar",0x7,PROC_FROM80286,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,6007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xc1
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subc1[]=
{ {"rol",0x0,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7000},
  {"rol",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7001},
  {"ror",0x1,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7002},
  {"ror",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7003},
  {"rcl",0x2,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7004},
  {"rcl",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7005},
  {"rcr",0x3,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7006},
  {"rcr",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7007},
  {"shl",0x4,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7008},
  {"shl",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7009},
  {"shr",0x5,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7010},
  {"shr",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7011},
  {"sal",0x6,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7012},
  {"sal",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7013},
  {"sar",0x7,PROC_FROM80286,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM8,ARG_NONE,7014},
  {"sar",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM8,ARG_NONE,7015},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd0
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd0[]=
{ {"rol",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8000},
  {"ror",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8001},
  {"rcl",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8002},
  {"rcr",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8003},
  {"shl",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8004},
  {"shr",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8005},
  {"sal",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8006},
  {"sar",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM_1,ARG_NONE,8007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd1
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd1[]=
{ {"rol",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9000},
  {"rol",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9001},
  {"ror",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9002},
  {"ror",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9003},
  {"rcl",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9004},
  {"rcl",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9005},
  {"rcr",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9006},
  {"rcr",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9007},
  {"shl",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9008},
  {"shl",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9009},
  {"shr",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9010},
  {"shr",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9011},
  {"sal",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9012},
  {"sal",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9013},
  {"sar",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM_1,ARG_NONE,9014},
  {"sar",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM_1,ARG_NONE,9015},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd2
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd2[]=
{ {"rol",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10000},
  {"ror",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10001},
  {"rcl",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10002},
  {"rcr",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10003},
  {"shl",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10004},
  {"shr",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10005},
  {"sal",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10006},
  {"sar",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_REG_CL,ARG_NONE,10007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd3
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd3[]=
{ {"rol",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11000},
  {"rol",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11001},
  {"ror",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11002},
  {"ror",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11003},
  {"rcl",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11004},
  {"rcl",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11005},
  {"rcr",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11006},
  {"rcr",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11007},
  {"shl",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11008},
  {"shl",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11009},
  {"shr",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11010},
  {"shr",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11011},
  {"sal",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11012},
  {"sal",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11013},
  {"sar",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_REG_CL,ARG_NONE,11014},
  {"sar",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_REG_CL,ARG_NONE,11015},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xf6
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subf6[]=
{ {"test",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,12000},
  {"test",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_IMM8,ARG_NONE,12001},
  {"not",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12002},
  {"neg",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12003},
  {"mul",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12004},
  {"imul",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12005},
  {"div",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12006},
  {"idiv",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,12007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xf7
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subf7[]=
{ {"test",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,13000},
  {"test",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,13001},
  {"test",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_IMM,ARG_NONE,13002},
  {"test",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_IMM,ARG_NONE,13003},
  {"not",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13004},
  {"not",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13005},
  {"neg",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13006},
  {"neg",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13007},
  {"mul",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13008},
  {"mul",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13009},
  {"imul",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13010},
  {"imul",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13011},
  {"div",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13012},
  {"div",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13013},
  {"idiv",0x7,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,13014},
  {"idiv",0x7,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,13015},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xfe
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subfe[]=
{ {"inc",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,14000},
  {"dec",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_8BIT,ARG_MODRM,ARG_NONE,ARG_NONE,14001},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xff
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subff[]=
{ {"inc",0x0,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,15000},
  {"inc",0x0,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,15001},
  {"dec",0x1,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,15002},
  {"dec",0x1,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,15003},
  {"call",0x2,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16|FLAGS_CALL,ARG_MODRM,ARG_NONE,ARG_NONE,15004},
  {"call",0x2,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32|FLAGS_CALL,ARG_MODRM,ARG_NONE,ARG_NONE,15005},
  {"call",0x3,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16|FLAGS_CALL,ARG_MODRM_FPTR,ARG_NONE,ARG_NONE,15006},
  {"call",0x3,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32|FLAGS_CALL,ARG_MODRM_FPTR,ARG_NONE,ARG_NONE,15007},
  {"jmp",0x4,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16|FLAGS_JMP,ARG_MODRM,ARG_NONE,ARG_NONE,15008},
  {"jmp",0x4,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32|FLAGS_JMP,ARG_MODRM,ARG_NONE,ARG_NONE,15009},
  {"jmp",0x5,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16|FLAGS_JMP,ARG_MODRM_FPTR,ARG_NONE,ARG_NONE,15010},
  {"jmp",0x5,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32|FLAGS_JMP,ARG_MODRM_FPTR,ARG_NONE,ARG_NONE,15011},
  {"push",0x6,PROC_FROM8086,FLAGS_MODRM|FLAGS_OMODE16,ARG_MODRM,ARG_NONE,ARG_NONE,15012},
  {"push",0x6,PROC_FROM80386,FLAGS_MODRM|FLAGS_OMODE32,ARG_MODRM,ARG_NONE,ARG_NONE,15013},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x00
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f00[]=
{ {"sldt",0x0,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16000},
  {"str",0x1,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16001},
  {"lldt",0x2,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16002},
  {"ltr",0x3,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16003},
  {"verr",0x4,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16004},
  {"verw",0x5,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,16005},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x01
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f01[]=
{ {"sgdt",0x0,PROC_FROM80286,FLAGS_MODRM,ARG_MODRM_S,ARG_NONE,ARG_NONE,17000},
  {"sidt",0x1,PROC_FROM80286,FLAGS_MODRM,ARG_MODRM_S,ARG_NONE,ARG_NONE,17001},
  {"lgdt",0x2,PROC_FROM80286,FLAGS_MODRM,ARG_MODRM_S,ARG_NONE,ARG_NONE,17002},
  {"lidt",0x3,PROC_FROM80286,FLAGS_MODRM,ARG_MODRM_S,ARG_NONE,ARG_NONE,17003},
  {"smsw",0x4,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,17004},
  {"lmsw",0x6,PROC_FROM80286,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,17005},
  {"invlpg",0x7,PROC_FROM80486,FLAGS_MODRM|FLAGS_16BIT,ARG_MODRM,ARG_NONE,ARG_NONE,17006},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x18
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f18[]=
{ {"prefetchnta",0x0,PROC_FROMPENTIUM2,FLAGS_MODRM,ARG_MODRM,ARG_NONE,ARG_NONE,18000},
  {"prefetcht0",0x1,PROC_FROMPENTIUM2,FLAGS_MODRM,ARG_MODRM,ARG_NONE,ARG_NONE,18001},
  {"prefetcht1",0x2,PROC_FROMPENTIUM2,FLAGS_MODRM,ARG_MODRM,ARG_NONE,ARG_NONE,18002},
  {"prefetcht2",0x3,PROC_FROMPENTIUM2,FLAGS_MODRM,ARG_MODRM,ARG_NONE,ARG_NONE,18003},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x71
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f71[]=
{ {"psrlw",0x2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,19000},
  {"psraw",0x4,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,19001},
  {"psllw",0x6,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,19002},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x72
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f72[]=
{ {"psrld",0x2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,20000},
  {"psrad",0x4,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,20001},
  {"pslld",0x6,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,20002},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0x73
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0f73[]=
{ {"psrlq",0x2,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,21000},
  {"psllq",0x6,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MMXMODRM,ARG_IMM8,ARG_NONE,21001},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0xae
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0fae[]=
{ {"fxsave",0x0,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MODRMM512,ARG_NONE,ARG_NONE,22000},
  {"fxrstor",0x1,PROC_FROMPENTMMX,FLAGS_MODRM|FLAGS_32BIT,ARG_MODRMM512,ARG_NONE,ARG_NONE,22001},
  {"ldmxcsr",0x2,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MODRM,ARG_NONE,ARG_NONE,22002},
  {"stmxcsr",0x3,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_MODRM,ARG_NONE,ARG_NONE,22003},
  {"sfence",0x7,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_NONEBYTE,ARG_NONE,ARG_NONE,22004},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0xba
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0fba[]=
{ {"bt",0x4,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_IMM8,ARG_NONE,23000},
  {"bts",0x5,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_IMM8,ARG_NONE,23001},
  {"btr",0x6,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_IMM8,ARG_NONE,23002},
  {"btc",0x7,PROC_FROM80386,FLAGS_MODRM,ARG_MODRM,ARG_IMM8,ARG_NONE,23003},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0xc2
// -num is the follow up byte
asminstdata asm86sub0fc2[]=
{ {"cmpeqps",0x0,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24000},
  {"cmpltps",0x1,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24001},
  {"cmpleps",0x2,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24002},
  {"cmpunordps",0x3,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24003},
  {"cmpneqps",0x4,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24004},
  {"cmpnltps",0x5,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24005},
  {"cmpnleps",0x6,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24006},
  {"cmpordps",0x7,PROC_FROMPENTIUM2,FLAGS_MODRM|FLAGS_32BIT,ARG_XREG,ARG_XMMMODRM,ARG_NONE,24007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0x0f/0xc7
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86sub0fc7[]=
{ {"cmpxch8b",0x1,PROC_FROMPENTIUM,FLAGS_MODRM,ARG_MODRMQ,ARG_NONE,ARG_NONE,25000},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// FPU Instructions

// subtable 0xd8/ modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd8a[]=
{ {"fadd",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26000},
  {"fmul",0x1,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26001},
  {"fcom",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26002},
  {"fcomp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26003},
  {"fsub",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26004},
  {"fsubr",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26005},
  {"fdiv",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26006},
  {"fdivr",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,26007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd8/ modrm = 0xc0-0xff
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subd8b[]=
{ {"fadd",0x18,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27000},
  {"fmul",0x19,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27001},
  {"fcom",0x1a,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27002},
  {"fcomp",0x1b,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27003},
  {"fsub",0x1c,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27004},
  {"fsubr",0x1d,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27005},
  {"fdiv",0x1e,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27006},
  {"fdivr",0x1f,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,27007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd9/modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subd9a[]=
{ {"fld",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,28000},
  {"fst",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,28001},
  {"fstp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SREAL,ARG_NONE,ARG_NONE,28002},
  {"fldenv",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_PTR,ARG_NONE,ARG_NONE,28003},
  {"fldcw",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WORD,ARG_NONE,ARG_NONE,28004},
  {"fstenv",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_PTR,ARG_NONE,ARG_NONE,28005},
  {"fstcw",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WORD,ARG_NONE,ARG_NONE,28006},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd9/ modrm = 0xc0-0xcf
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subd9b[]=
{ {"fld",0x18,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,29000},
  {"fxch",0x19,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,29001},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xd9/ modrm = 0xd0-0xff
asminstdata asm86subd9c[]=
{ {"fnop",0xd0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30000},
  {"fchs",0xe0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30001},
  {"fabs",0xe1,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30002},
  {"ftst",0xe4,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30003},
  {"fxam",0xe5,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30004},
  {"fld1",0xe8,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30005},
  {"fldl2t",0xe9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30006},
  {"fldl2e",0xea,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30007},
  {"fldpi",0xeb,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30008},
  {"fldlg2",0xec,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30009},
  {"fldln2",0xed,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30010},
  {"fldz",0xee,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30011},
  {"f2xm1",0xf0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30012},
  {"fyl2x",0xf1,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30013},
  {"fptan",0xf2,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30014},
  {"fpatan",0xf3,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30015},
  {"fxtract",0xf4,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30016},
  {"fprem1",0xf5,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,30017},
  {"fdecstp",0xf6,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30018},
  {"fincstp",0xf7,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30019},
  {"fprem",0xf8,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30020},
  {"fyl2xp1",0xf9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30021},
  {"fsqrt",0xfa,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30022},
  {"fsincos",0xfb,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,30023},
  {"frndint",0xfc,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30024},
  {"fscale",0xfd,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,30025},
  {"fsin",0xfe,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,30026},
  {"fcos",0xff,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,30027},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xda/ modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdaa[]=
{ {"fiadd",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31000},
  {"fimul",0x1,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31001},
  {"ficom",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31002},
  {"ficomp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31003},
  {"fisub",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31004},
  {"fisubr",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31005},
  {"fidiv",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31006},
  {"fidivr",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,31007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xda/ modrm = 0xc0-0xdf
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subdab[]=
{ {"fmovb",0x18,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,32000},
  {"fmove",0x19,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,32001},
  {"fmovbe",0x1a,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,32002},
  {"fmovu",0x1b,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,32003},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xda/ modrm = 0xe0-0xff
asminstdata asm86subdac[]=
{ {"fucompp",0xe9,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,33000},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdb/modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdba[]=
{ {"fild",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,34000},
  {"fist",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,34001},
  {"fistp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_SINT,ARG_NONE,ARG_NONE,34002},
  {"fld",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_EREAL,ARG_NONE,ARG_NONE,34003},
  {"fstp",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_EREAL,ARG_NONE,ARG_NONE,34004},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdb/ modrm = 0xc0-0xff
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subdbb[]=
{ {"fcmovnb",0x18,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35000},
  {"fcmovne",0x19,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35001},
  {"fcmovnbe",0x1a,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35002},
  {"fcmovnu",0x1b,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35003},
  {"fucomi",0x1d,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35004},
  {"fcomi",0x1e,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,35005},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdb/ modrm = 0xe0-0xff
asminstdata asm86subdbc[]=
{ {"feni",0xe0,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,36000},
  {"fdisi",0xe1,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,36001},
  {"fclex",0xe2,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,36002},
  {"finit",0xe3,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,36003},
  {"fsetpm",0xe4,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,36004},
  {"frstpm",0xe5,PROC_FROM80286,0,ARG_NONE,ARG_NONE,ARG_NONE,36005},
  {"frint2",0xec,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,36006},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdc/ modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdca[]=
{ {"fadd",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37000},
  {"fmul",0x1,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37001},
  {"fcom",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37002},
  {"fcomp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37003},
  {"fsub",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37004},
  {"fsubr",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37005},
  {"fdiv",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37006},
  {"fdivr",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,37007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdc/ modrm = 0xc0-0xff
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subdcb[]=
{ {"fadd",0x18,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38000},
  {"fmul",0x19,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38001},
  {"fcom2",0x1a,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38002},
  {"fcomp3",0x1b,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38003},
  {"fsub",0x1c,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38004},
  {"fsubr",0x1d,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38005},
  {"fdiv",0x1e,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38006},
  {"fdivr",0x1f,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,38007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdd/modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdda[]=
{ {"fld",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,39000},
  {"fst",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,39001},
  {"fstp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_DREAL,ARG_NONE,ARG_NONE,39002},
  {"frstor",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_PTR,ARG_NONE,ARG_NONE,39003},
  {"fsave",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_PTR,ARG_NONE,ARG_NONE,39004},
  {"fstsw",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WORD,ARG_NONE,ARG_NONE,39005},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdd/ modrm = 0xc0-0xff
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subddb[]=
{ {"ffree",0x18,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,40000},
  {"fxch4",0x19,PROC_FROM8086,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,40001},
  {"fst",0x1a,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,40002},
  {"fstp",0x1b,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,40003},
  {"fucom",0x1c,PROC_FROM80386,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,40004},
  {"fucomp",0x1d,PROC_FROM80386,0,ARG_FREG,ARG_NONE,ARG_NONE,40005},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xde/ modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdea[]=
{ {"fiadd",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41000},
  {"fimul",0x1,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41001},
  {"ficom",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41002},
  {"ficomp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41003},
  {"fisub",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41004},
  {"fisubr",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41005},
  {"fidiv",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41006},
  {"fidivr",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,41007},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xde/ modrm = 0xc0-0xdf
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subdeb[]=
{ {"faddp",0x18,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42000},
  {"fmulp",0x19,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42001},
  {"fcomp5",0x1a,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42002},
  {"fsubrp",0x1c,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42003},
  {"fsubp",0x1d,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42004},
  {"fdivrp",0x1e,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42005},
  {"fdivp",0x1f,PROC_FROM8086,0,ARG_FREG,ARG_REG_ST0,ARG_NONE,42006},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xde/ modrm = 0xd8-0xdf
asminstdata asm86subdec[]=
{ {"fcompp",0xd9,PROC_FROM8086,0,ARG_NONE,ARG_NONE,ARG_NONE,43000},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdf/modrm = 0x00-0xbf
// - num is encoding of modrm bits 5,4,3 only
asminstdata asm86subdfa[]=
{ {"fild",0x0,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,44000},
  {"fist",0x2,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,44001},
  {"fistp",0x3,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_WINT,ARG_NONE,ARG_NONE,44002},
  {"fbld",0x4,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_BCD,ARG_NONE,ARG_NONE,44003},
  {"fild",0x5,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_LINT,ARG_NONE,ARG_NONE,44004},
  {"fbstp",0x6,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_BCD,ARG_NONE,ARG_NONE,44005},
  {"fistp",0x7,PROC_FROM8086,FLAGS_MODRM,ARG_MODRM_LINT,ARG_NONE,ARG_NONE,44006},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdf/ modrm = 0xc0-0xff
// - num is mod bits 7,6 only + bits 5,4,3 (ie modrm/8)
asminstdata asm86subdfb[]=
{ {"ffreep",0x18,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,45000},
  {"fxch7",0x19,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,45001},
  {"fstp8",0x1a,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,45002},
  {"fstp9",0x1b,PROC_FROM8086,0,ARG_FREG,ARG_NONE,ARG_NONE,45003},
  {"fucomip",0x1d,PROC_FROMPENTPRO,0,ARG_REG_ST0,ARG_FREG,ARG_NONE,45004},
  {"fcomip",0x1e,PROC_FROMPENTPRO,0,ARG_FREG,ARG_NONE,ARG_NONE,45005},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// subtable 0xdf/ modrm = 0xe0-0xff
asminstdata asm86subdfc[]=
{ {"fstsw",0xe0,PROC_FROM8086,FLAGS_16BIT,ARG_REG_AX,ARG_NONE,ARG_NONE,46000},
  {"fstdw",0xe1,PROC_FROM80386,0,ARG_REG_AX,ARG_NONE,ARG_NONE,46001},
  {"fstsg",0xe2,PROC_FROM80386,0,ARG_REG_AX,ARG_NONE,ARG_NONE,46002},
  {"frinear",0xe2,PROC_FROM80386,0,ARG_NONE,ARG_NONE,ARG_NONE,46003},
  {NULL,0x00,0,0,ARG_NONE,ARG_NONE,ARG_NONE,0}  //end marker - processor=0 & opcode=0
};

// Group all sub-table into this structure
asmtable tables86[]=
{ {asm86,TABLE_MAIN,0,0,0,0xff,0,0xff,0},
  {asm86sub0f,TABLE_EXT,0x0f,0,0,0xff,0,0xff,1},
  {asm86sub80,TABLE_EXT,0x80,0,8,0x07,0,0xff,0},
  {asm86sub81,TABLE_EXT,0x81,0,8,0x07,0,0xff,0},
  {asm86sub82,TABLE_EXT,0x82,0,8,0x07,0,0xff,0},
  {asm86sub83,TABLE_EXT,0x83,0,8,0x07,0,0xff,0},
  {asm86subc0,TABLE_EXT,0xc0,0,8,0x07,0,0xff,0},
  {asm86subc1,TABLE_EXT,0xc1,0,8,0x07,0,0xff,0},
  {asm86subd0,TABLE_EXT,0xd0,0,8,0x07,0,0xff,0},
  {asm86subd1,TABLE_EXT,0xd1,0,8,0x07,0,0xff,0},
  {asm86subd2,TABLE_EXT,0xd2,0,8,0x07,0,0xff,0},
  {asm86subd3,TABLE_EXT,0xd3,0,8,0x07,0,0xff,0},
  {asm86subf6,TABLE_EXT,0xf6,0,8,0x07,0,0xff,0},
  {asm86subf7,TABLE_EXT,0xf7,0,8,0x07,0,0xff,0},
  {asm86subfe,TABLE_EXT,0xfe,0,8,0x07,0,0xff,0},
  {asm86subff,TABLE_EXT,0xff,0,8,0x07,0,0xff,0},
  {asm86sub0f00,TABLE_EXT2,0x0f,0x00,8,0x07,0,0xff,1},
  {asm86sub0f01,TABLE_EXT2,0x0f,0x01,8,0x07,0,0xff,1},
  {asm86sub0f18,TABLE_EXT2,0x0f,0x18,8,0x07,0,0xff,1},
  {asm86sub0f71,TABLE_EXT2,0x0f,0x71,8,0x07,0,0xff,1},
  {asm86sub0f72,TABLE_EXT2,0x0f,0x72,8,0x07,0,0xff,1},
  {asm86sub0f73,TABLE_EXT2,0x0f,0x73,8,0x07,0,0xff,1},
  {asm86sub0fae,TABLE_EXT2,0x0f,0xae,8,0x07,0,0xff,1},
  {asm86sub0fba,TABLE_EXT2,0x0f,0xba,8,0x07,0,0xff,1},
  {asm86sub0fc2,TABLE_EXT2,0x0f,0xc2,0,0x00,0,0xff,1},
  {asm86sub0fc7,TABLE_EXT2,0x0f,0xc7,8,0x07,0,0xff,1},
  {asm86subd8a,TABLE_EXT,0xd8,0,8,0x07,0,0xbf,0},
  {asm86subd8b,TABLE_EXT,0xd8,0,8,0x1f,0xc0,0xff,0},
  {asm86subd9a,TABLE_EXT,0xd9,0,8,0x07,0,0xbf,0},
  {asm86subd9b,TABLE_EXT,0xd9,0,8,0x1f,0xc0,0xff,0},
  {asm86subd9c,TABLE_EXT,0xd9,0,1,0xff,0xc0,0xff,1},
  {asm86subdaa,TABLE_EXT,0xda,0,8,0x07,0,0xbf,0},
  {asm86subdab,TABLE_EXT,0xda,0,8,0x1f,0xc0,0xff,0},
  {asm86subdac,TABLE_EXT,0xda,0,1,0xff,0xc0,0xff,1},
  {asm86subdba,TABLE_EXT,0xdb,0,8,0x07,0,0xbf,0},
  {asm86subdbb,TABLE_EXT,0xdb,0,8,0x1f,0xc0,0xff,0},
  {asm86subdbc,TABLE_EXT,0xdb,0,1,0xff,0xc0,0xff,1},
  {asm86subdca,TABLE_EXT,0xdc,0,8,0x07,0,0xbf,0},
  {asm86subdcb,TABLE_EXT,0xdc,0,8,0x1f,0xc0,0xff,0},
  {asm86subdda,TABLE_EXT,0xdd,0,8,0x07,0,0xbf,0},
  {asm86subddb,TABLE_EXT,0xdd,0,8,0x1f,0xc0,0xff,0},
  {asm86subdea,TABLE_EXT,0xde,0,8,0x07,0,0xbf,0},
  {asm86subdeb,TABLE_EXT,0xde,0,8,0x1f,0xc0,0xff,0},
  {asm86subdec,TABLE_EXT,0xde,0,1,0xff,0xc0,0xff,1},
  {asm86subdfa,TABLE_EXT,0xdf,0,8,0x07,0,0xbf,0},
  {asm86subdfb,TABLE_EXT,0xdf,0,8,0x1f,0xc0,0xff,0},
  {asm86subdfc,TABLE_EXT,0xdf,0,1,0xff,0xc0,0xff,1},
  {NULL,0,0,0,0,0,0,0,0}
};




// Default constructor
CDisasm::CDisasm(DWORD img_base, DWORD limit_start, DWORD limit_end, DWORD pid, DWORD max_depth,
				 CExport *exports, int nb_exports)
{
	m_img_base = img_base;
	m_limit_start = limit_start;
	m_limit_end = limit_end;
	m_pid = pid;
	m_max_depth = max_depth;
	m_exports = exports;
	m_nb_exports = nb_exports;
}

// Returns increase in length of instruction due to argtype
BYTE CDisasm::GetArgLength(argtype a, BYTE modrmbyte, BYTE sibbyte, DWORD flgs,
						   BOOL omode32)   //NB modrm to add
{
	BYTE rm;
	switch(a)
	{
	case ARG_IMM:
		if (flgs&FLAGS_8BIT)
			return 1;
		if (flgs&FLAGS_16BIT)
			return 2;
		else
			return 4;
	case ARG_NONEBYTE:
		return 1;
	case ARG_RELIMM:
	case ARG_MEMLOC:
		//		if(options.mode16)
		//			return 2;
		//		else
		return 4;
	case ARG_RELIMM8:
	case ARG_SIMM8:
	case ARG_IMM8:
	case ARG_IMM8_IND:
		return 1;
	case ARG_IMM32:
		return 4;
	case ARG_IMM16_A:
	case ARG_IMM16:
	case ARG_MEMLOC16:
		return 2;
	case ARG_FADDR:
		//		if(options.mode16)
		//			return 4;
		//		else
		return 6;
	case ARG_MODREG:
	case ARG_MMXMODRM:
	case ARG_XMMMODRM:
	case ARG_MODRM8:
	case ARG_MODRM16:
	case ARG_MODRM_S:
	case ARG_MODRMM512:
	case ARG_MODRMQ:
	case ARG_MODRM_SREAL:
	case ARG_MODRM_PTR:
	case ARG_MODRM_WORD:
	case ARG_MODRM_SINT:
	case ARG_MODRM_EREAL:
	case ARG_MODRM_DREAL:
	case ARG_MODRM_WINT:
	case ARG_MODRM_LINT:
	case ARG_MODRM_BCD:
	case ARG_MODRM_FPTR:
	case ARG_MODRM:
		rm=(byte)((modrmbyte&0xc0)>>6);
		switch(rm)
		{
		case 0:
//			if (options.mode32)
			{
				if ((modrmbyte&0x07)==5)
					return 5; // disp32
				if ((modrmbyte&0x07)==4)
				{
					if((sibbyte&0x07)==5)
						return 6;
					return 2; //sib byte - need to check if r=5 also.
				}
			}
//			else
//				if ((modrmbyte&0x07)==6)
//					return 3;
				break;
		case 1:
//			if(options.mode32)
			{
				if((modrmbyte&0x07)==4)
				{
					return 3; //sib byte
				}
			}
			return 2; // disp8
		case 2:
//			if(options.mode32)
			{
				if((modrmbyte&0x07)==4)
					return 6; //sib byte
				return 5; // disp32
			}
//			else
//				return 3; // disp16
		case 3:
			return 1;
		}
		return 1;
		default:
			break;
	}
	return 0;
}

void CDisasm::SetMaxDepth(int max_depth)
{
	m_max_depth = max_depth;
}


asminstdata* CDisasm::DecodeInstr(BYTE* code, DWORD *offset, BYTE tab_type, int depth)
{
	static int id_table;
	static DWORD tmp;
	static asminstdata *instr;
	static BYTE opcode;
	id_table = 0;
	tmp = *offset;

	// Stop recursion for a depth greater than 5
	if (depth > 5)
	{
		return (NULL);
	}

	// Get the correct opcode depending of the table type
	switch (tab_type)
	{
	case TABLE_MAIN:
		opcode = code[tmp];
		break;
	case TABLE_EXT:
		opcode = code[tmp+1];
		break;
	case TABLE_EXT2:
		opcode = code[tmp+2];
		break;
	}

	// Look for the opcode
	while ( (instr=tables86[id_table].table) )
	{
		if (tab_type == tables86[id_table].type &&
			opcode >= tables86[id_table].minlim &&
			opcode <= tables86[id_table].maxlim)
		{
			// Check limit
			if ((tab_type == TABLE_EXT || tab_type == TABLE_EXT2) &&
				code[tmp] != tables86[id_table].extnum)
			{
				id_table++;
				continue;
			}
			if (tab_type == TABLE_EXT2 &&
				code[tmp+1] != tables86[id_table].extnum2)
			{
				id_table++;
				continue;
			}

			// Applied divisor and mask to the opcode
			if (tables86[id_table].divisor)
			{
				opcode /= tables86[id_table].divisor;
			}
			if (tables86[id_table].mask)
			{
				opcode &= tables86[id_table].mask;
			}

			// Look for opcode
			while (instr->processor || instr->instbyte)
			{
				// We are in mode 32 bits only
				if (!(instr->flags & FLAGS_OMODE16) &&
					instr->instbyte == opcode)
				{
					// Found
					if (instr->name)
					{
						switch (tab_type)
						{
						case TABLE_EXT:
//							(*offset)++;
							break;
						case TABLE_EXT2:
							(*offset)++;
							break;
						}

						return (instr);
					}

					// NULL name -> continue searching by recursion
					if (tab_type == TABLE_MAIN)
					{
						return (DecodeInstr(code, offset, TABLE_EXT, depth+5));
					}
					return (DecodeInstr(code, offset, TABLE_EXT2, depth+5));
				}

				instr++;
			}
		}

		id_table++;
	}

	return (NULL);
}


// Trace instruction by instruction until we get an address which may belong to the
// original IAT.
////////////////////////////////////////////////////////////////////////////////////////////
// It follows any jmp, jnz, jg ... by recursion (with a limit of recursion of course)
// and stop on any ret.
//
BOOL CDisasm::Trace(DWORD rva, DWORD size, DWORD& ptr_func, char *buffer,
					DWORD buffer_length, WORD *ordinal, int *lib_index, BOOL hardcore,
					DWORD depth)
{
	// Play with process
	// Play with process by dumping
	m_handle=OpenProcess(PROCESS_ALL_ACCESS, FALSE, m_pid);
	if (!m_handle)
	{
		return (FALSE);
	}

	BOOL result;
	unsigned char *tracing_buffer = new unsigned char[size];

	result = Trace2(rva, size, ptr_func, buffer, buffer_length, ordinal, lib_index,
					hardcore, depth, tracing_buffer);


	// End of playing with process
	CloseHandle(m_handle);
	delete[] tracing_buffer;
	return (result);
}

BOOL CDisasm::Trace2(DWORD rva, DWORD size, DWORD& ptr_func, char *buffer,
					 DWORD buffer_length, WORD *ordinal, int *lib_index, BOOL hardcore,
					 DWORD depth, unsigned char *tracing_buffer)
{
	static int val;
	static int i;
	DWORD current_offset = 0;
	static DWORD offset;
	static asminstdata *instr;
	static DWORD dwCheckSize;
	static DWORD ptr_func2;
	static BOOL  ptr_check;
	static BOOL  go_recursion;

	// Can be stopped by pressing SHIFT+PAUSE
	if (::GetAsyncKeyState(VK_SHIFT)<0 && ::GetAsyncKeyState(VK_F12)<0)
	{
		*lib_index = -2;
		return (FALSE);
	}

	// Limit recursion
	if (depth >= m_max_depth)
	{
		return (FALSE);
	}

	// Ok, now read the whole header
	DWORD dwOldProtect;
	if (!VirtualProtectEx(m_handle, (void*)rva, size, PAGE_READWRITE, &dwOldProtect))
	{
		return (FALSE);
	}
	if (!ReadProcessMemory( m_handle, (void*)rva, (LPVOID)tracing_buffer, size, &dwCheckSize) || dwCheckSize != size)
	{
		VirtualProtectEx(m_handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
		return (FALSE);
	}

	VirtualProtectEx(m_handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
	// End of dumping

	while ( (current_offset+2) < size )
	{
		offset = current_offset;

		// Decode instruction
		instr = DecodeInstr(tracing_buffer, &offset, TABLE_MAIN, 0);
		// Unkown instruction -> continue tracing to the next byte
		if (!instr)
		{
			current_offset++;
			continue;
		}

		// Go to next offset
		offset++;

		if (::GetAsyncKeyState(VK_CONTROL)<0)
		{
			char ttmp[256];
			sprintf(ttmp, "rva:%X offs:%X opc:%X length:%X instr:%s", rva, current_offset, tracing_buffer[current_offset], GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
					GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
					GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE),
					instr->name);
			MessageBox(0, ttmp, "OO", 0);
		}

		// We got a "ret" so tracing is over
		if (stricmp(instr->name, "ret") == 0)
		{
			return (FALSE);
		}

		// Get the attached address to the instruction
		//
		// We only take care about jump and stack operations
		if ( ((instr->flags & (FLAGS_CJMP | FLAGS_JMP | FLAGS_CALL)) ||
			 (stricmp(instr->name, "push") == 0)) &&
			GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) > 0)
		{
			ptr_check = FALSE;

			switch (instr->arg1)
			{
			// Relative address
			case ARG_RELIMM8:
				val = *((char*)(tracing_buffer+offset));
				ptr_func = rva + offset + 1 + val;
				break;
			// Immediate address
			case ARG_IMM8:
				ptr_func = *((BYTE*)(tracing_buffer+offset));
				break;
			// Immediate address
			case ARG_IMM16:
				ptr_func = *((WORD*)(tracing_buffer+offset));
				break;
			// Relative address
			case ARG_RELIMM:
				val = *((int*)(tracing_buffer+offset));
				ptr_func = rva + offset + 4 + val;
				ptr_check = TRUE;
				break;
			// Immediate address
			case ARG_IMM:
				ptr_func = *((DWORD*)(tracing_buffer+offset));
				ptr_check = TRUE;
				break;
			// Redirected address
			case ARG_MODRM:
				ptr_func2 = *((DWORD*)(tracing_buffer+offset+1));
				ptr_func = 0;

				if (hardcore && ptr_func2 >= m_limit_start && ptr_func2 <= m_limit_end)
				{
					// Ok, now read the pointer
					if (VirtualProtectEx(m_handle, (void*)ptr_func2, sizeof(DWORD), PAGE_READWRITE, &dwOldProtect))
					{
						if (ReadProcessMemory( m_handle, (void*)ptr_func2, (LPVOID)&ptr_func, sizeof(DWORD), &dwCheckSize) && dwCheckSize == sizeof(DWORD))
						{
							ptr_check = TRUE;
						}

						VirtualProtectEx(m_handle, (void*)ptr_func2, sizeof(DWORD), dwOldProtect, &dwCheckSize);
					}
				}

				break;
			default:
				ptr_func = 0;
				break;
			}

			if (::GetAsyncKeyState(VK_CONTROL)<0)
			{
				char ttmp[256];
				sprintf(ttmp, "rva:%X offs:%X opc:%X length:%X instr:%s val:%X", rva, current_offset, tracing_buffer[current_offset], GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
						GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
						GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE),
						instr->name, ptr_func);
				MessageBox(0, ttmp, "OO", 0);
			}
			// Increase the pointer of the memory block to trace
			current_offset = offset +
				GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE);


			// If we have a "push", we MUST have a "ret" just after else do not consider
			// it.
			if (stricmp(instr->name, "push") == 0)
			{
				asminstdata *tmp_instr;
				DWORD tmp_offset = current_offset;
				// Decode instruction
				tmp_instr = DecodeInstr(tracing_buffer, &tmp_offset, TABLE_MAIN, 0);

				// It's not a "ret" => continue tracing
				if (!tmp_instr || !(tmp_instr->flags & FLAGS_RET))
				{
					ptr_func = 0;
					continue;
				}
			}

			go_recursion = TRUE;
			if (ptr_func && ptr_check)
			{
				for (i=0; i<m_nb_exports; i++)
				{
					if (m_exports[i].GetNearestProcName((void*)ptr_func, buffer,
						buffer_length, ordinal))
					{
/*//						if (::GetAsyncKeyState(VK_CONTROL)<0)
						{
							char tur[256];
							sprintf(tur, "FOUND at:%08X", rva+current_offset);
							MessageBox(0, tur, "OK", 0);
						}*/
						// Do not consider a CALL!
//						if ( !(instr->flags & (FLAGS_CALL)) )
						{
							*lib_index = i;
							return (TRUE);
						}

						go_recursion = FALSE;
						break;
					}
				}
			}

			// The pointer belongs to the process so go for recursion
			if (go_recursion && ptr_func >= m_limit_start && ptr_func <= m_limit_end)
			{
				if (::GetAsyncKeyState(VK_CONTROL)<0)
				{
					MessageBox(0, "IN", "OK", 0);
				}
				// If it's a conditional jump or a call
				if (instr->flags & (FLAGS_CJMP | FLAGS_CALL))
				{
					DWORD new_rva = ptr_func;
					if (Trace2(new_rva, size, ptr_func, buffer, buffer_length, ordinal, lib_index,
						  hardcore, depth+1, tracing_buffer))
					{
						return (TRUE);
					}

					// ReRead the memory :-( ... Usefull because we use only one memory block
					if (VirtualProtectEx(m_handle, (void*)rva, size, PAGE_READWRITE, &dwOldProtect))
					{
						if (!ReadProcessMemory( m_handle, (void*)rva, (LPVOID)tracing_buffer, size, &dwCheckSize) || dwCheckSize != size)
						{
							// End of playing with process
							VirtualProtectEx(m_handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
							return (FALSE);
						}

						VirtualProtectEx(m_handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
					}
					else
					{
						return (FALSE);
					}

				}
				// If we have a jump, count the recursion and stop to trace here
				else
				if (instr->flags & (FLAGS_JMP))
				{
					DWORD new_rva = ptr_func;
					return (Trace2(new_rva, size, ptr_func, buffer, buffer_length, ordinal, lib_index,
						hardcore, depth+1, tracing_buffer));
				}
			}


		}
		else
		{
			current_offset = offset + 
				GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE);
		}

	}	// while (...)

	return (FALSE);
}

// Trace from rva (OEP) to find the first call which can belong to the original IAT.
// It return TRUE with the RVA filled in ptr_func and FALSE else.
////////////////////////////////////////////////////////////////////////////////////////////
BOOL CDisasm::LookForIAT(DWORD rva, DWORD size, DWORD& ptr_func, DWORD depth)
{
	int val;
	DWORD current_offset = 0;
	DWORD offset;
	asminstdata *instr;
	DWORD dwCheckSize;
	HANDLE handle;
	BOOL  ptr_check;
	unsigned char *tracing_buffer = 0;

	// Limit recursion
	if (depth >= m_max_depth)
	{
		return (FALSE);
	}

	tracing_buffer = new unsigned char[size];
	// Play with process by dumping
	handle=OpenProcess(PROCESS_ALL_ACCESS, FALSE, m_pid);
	if (!handle)
	{
		delete[] tracing_buffer;
		return (FALSE);
	}

	DWORD dwOldProtect;
	if (!VirtualProtectEx(handle, (void*)rva, size, PAGE_READWRITE, &dwOldProtect))
	{
		CloseHandle(handle);
		delete[] tracing_buffer;
		return (FALSE);
	}

	// Ok, now read the whole header
	if (!ReadProcessMemory( handle, (void*)rva, (LPVOID)tracing_buffer, size, &dwCheckSize) || dwCheckSize != size)
	{
		VirtualProtectEx(handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
		CloseHandle(handle);
		delete[] tracing_buffer;
		return (FALSE);
	}

	VirtualProtectEx(handle, (void*)rva, size, dwOldProtect, &dwCheckSize);
	CloseHandle(handle);
	// End of dumping

	while ( (current_offset+2) < size )
	{
		offset = current_offset;

		// Decode instruction
		instr = DecodeInstr(tracing_buffer, &offset, TABLE_MAIN, 0);
		// Unknown instruction -> continue tracing to the next byte
		if (!instr)
		{
			current_offset++;
			continue;
		}

		// Go to next offset
		offset++;

/*			{
				char ttmp[256];
				sprintf(ttmp, "rva:%X offs:%X opc:%X length:%X instr:%s", rva, current_offset, tracing_buffer[current_offset], GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
						GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
						GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE),
						instr->name);
				MessageBox(0, ttmp, "OO", 0);
			}*/

		// We got a "ret" so tracing is over
		if (stricmp(instr->name, "ret") == 0)
		{
			delete[] tracing_buffer;
			return (FALSE);
		}

		// Get the attached address to the instruction
		//
		// We only take care about jump and stack operations
		if ( (instr->flags & (FLAGS_CJMP | FLAGS_JMP | FLAGS_CALL)) &&
			GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) > 0)
		{
			ptr_check = FALSE;

			switch (instr->arg1)
			{
			// Relative address
			case ARG_RELIMM8:
				val = *((BYTE*)(tracing_buffer+offset));
				ptr_func = rva + offset + 1 + val;
				break;
			// Immediate address
			case ARG_IMM8:
				ptr_func = *((BYTE*)(tracing_buffer+offset));
				break;
			// Immediate address
			case ARG_IMM16:
				ptr_func = *((WORD*)(tracing_buffer+offset));
				break;
			// Relative address
			case ARG_RELIMM:
				val = *((DWORD*)(tracing_buffer+offset));
				ptr_func = rva + offset + 4 + val;
//				ptr_check = TRUE;
				break;
			// Immediate address
			case ARG_IMM:
				ptr_func = *((DWORD*)(tracing_buffer+offset));
//				ptr_check = TRUE;
				break;
			// Redirected address
			case ARG_MODRM:
				ptr_func = *((DWORD*)(tracing_buffer+offset+1));
				ptr_check = TRUE;
				break;
			default:
				ptr_func = 0;
				break;
			}

			// ARG_MODRM only!!!
			if (ptr_func && ptr_check && ptr_func >= m_limit_start && ptr_func <= m_limit_end)
			{
				delete[] tracing_buffer;
				return (TRUE);
			}

			// Increase the pointer of the memory block to trace
			current_offset = offset +
				GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE);

			// The pointer belongs to the process so go for recursion if it's a jump
			if ((instr->flags & (FLAGS_CJMP | FLAGS_JMP | FLAGS_CALL)) &&
				ptr_func >= m_limit_start && ptr_func <= m_limit_end)
			{
				DWORD new_rva = ptr_func;
				if (LookForIAT(new_rva, size, ptr_func, depth+1))
				{
					delete[] tracing_buffer;
					return (TRUE);
				}
//				depth++;
			}
		}
		else
		{
			current_offset = offset + 
				GetArgLength(instr->arg1, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg2, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE) +
				GetArgLength(instr->arg3, tracing_buffer[offset], tracing_buffer[offset+1], instr->flags, TRUE);
		}

	}	// while (...)

	delete[] tracing_buffer;
	return (FALSE);
}

