#include "stdafx.h"
#include "Export.h"


// Default constructor
CExport::CExport()
{
	m_hmod = 0;
	m_table_nameordinals = 0;
	m_ptr_exp = 0;
}

// Default destructor
CExport::~CExport()
{
	Clean();
}

// Clean all allocated memory
void CExport::Clean()
{
	if (m_hmod)
	{
		m_hmod = 0;
	}

	if (m_table_nameordinals)
	{
		delete[] m_table_nameordinals;
		m_table_nameordinals = 0;
	}
}

// Return the HMODULE of the export
HMODULE CExport::GetHandle()
{
	return (m_hmod);
}

// Create an export from its name
//
// Returned values:
// ----------------
// .	-1 : Can't open the process
// .	 0 : Module has no export
// .	 1 : All is OK.
// .	 2 : OK partially because we couldn't read the module at all
int CExport::Create(char *lib_name, DWORD pid, DWORD base, DWORD size)
{
	int    ret_val = 1;
	DWORD *ptr_name, i;
	WORD  *ptr_ord;
	Clean();

	// Get the PE infos of the library
	m_hmod = (HMODULE)base;
	m_pe_file.m_buffer = new unsigned char[size];
	m_pe_file.m_size = size;

	HANDLE handle = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pid);
	DWORD dwCheckSize;
	if (!handle)
	{
		// Can't open the process
//		MessageBox(0, "Can't open the process", "argh", 0);
		return (-1);
	}
	ReadProcessMemory(handle, (LPCVOID)base, (LPVOID)m_pe_file.m_buffer, size, &dwCheckSize);
	if (dwCheckSize != size)
	{
		// Can't read the whole module
/*		char toto[256];
		sprintf(toto, "%X %X (read:%X)", base, size, dwCheckSize);
		MessageBox(0, "Can't read the whole module", toto, 0);*/
		ret_val = 2;
	}
	CloseHandle(handle);
	
	m_pe_file.UpdatePEVars(false);
	// VERY IMPORTANT!!!!!!!!!!!
	m_pe_file.m_nt_header->imageBase = base;

	// No export??
	if ( !(m_ptr_exp=(IMAGE_EXPORT_DIRECTORY*)(m_pe_file.m_directories[ExportDataDirectory].RVA)) )
	{
		return (0);
	}

	m_ptr_exp = (IMAGE_EXPORT_DIRECTORY*)((DWORD)m_ptr_exp+m_pe_file.m_buffer);

	// Initialize the ordinal table for all function names
	m_table_nameordinals = new DWORD[m_ptr_exp->NumberOfFunctions];
	memset(m_table_nameordinals, 0, sizeof(DWORD)*m_ptr_exp->NumberOfFunctions);

	// Fill the ordinal table with points to function name
	ptr_name = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfNames);
	ptr_ord = (WORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfNameOrdinals);
	for (i=0; i<m_ptr_exp->NumberOfNames; i++)
	{
		m_table_nameordinals[*ptr_ord] = (DWORD)m_pe_file.m_buffer + (DWORD)(*((DWORD*)ptr_name));
		ptr_name++;
		ptr_ord++;
	}

	strcpy(m_fullpath_libname, lib_name);
	return (ret_val);
}

// Return the name of the module
char* CExport::GetLibName()
{
	if (m_hmod)
	{
		return ((char*)( (DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->Name ));
	}

	return (NULL);
}

// Return the full path name of the module
char* CExport::GetFullLibName()
{
	if (m_hmod)
	{
		return (m_fullpath_libname);
	}

	return (NULL);
}


// Check if an address belongs to the module
BOOL CExport::CheckInterval(void *address)
{
	DWORD addr = (DWORD)address;
	if (!m_hmod)
	{
//		MessageBox(0, "Library not loaded", "OK", 0);
		// No library loaded
		return (FALSE);
	}

/*	if (stricmp(GetLibName(), "kernel32.dll") == 0)
	{
		if ( addr<m_pe_file.m_nt_header->imageBase)
		{
			return (FALSE);
		}
	}
	else*/
	{
		if ( addr<m_pe_file.m_nt_header->imageBase ||
			addr>(m_pe_file.m_nt_header->imageBase+m_pe_file.m_nt_header->imageSize) )
		{
	//		MessageBox(0, "Wrong interval", "OK", 0);
			return (FALSE);
		}
	}
	return (TRUE);
}

// Return the number of export functions of the module
DWORD CExport::GetNumberOfFunction()
{
	if (!m_hmod)
	{
		// No library loaded
		return (0);
	}

	return (m_ptr_exp->NumberOfFunctions);
}

// Return the name of a function by its ordinal
BOOL CExport::GetProcNameByIndex(DWORD index, WORD *ordinal, char *buffer,
								 DWORD buffer_length)
{
	DWORD *ptr_func, tmp;

	if (!m_hmod)
	{
		// No library loaded
		return (FALSE);
	}

	if (index >= m_ptr_exp->NumberOfFunctions)
	{
		// Wrong index
		return (FALSE);
	}

	if (buffer_length <= 1)
	{
//		MessageBox(0, "Buffer too small", "OK", 0);
		// Wrong parameters!
		return (FALSE);
	}

	// Trace all function addresses and find a name if it exists
	ptr_func = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfFunctions);

	tmp = (DWORD)m_pe_file.m_nt_header->imageBase+*ptr_func;
	*ordinal = (WORD)(index+m_ptr_exp->Base);
	if (m_table_nameordinals[index])
	{
		if ( buffer_length >= (1+strlen((char*)(m_table_nameordinals[index]))) )
		{
			strcpy(buffer, (char*)(m_table_nameordinals[index]));
		}
		else
		{
			memcpy(buffer, (void*)(m_table_nameordinals[index]), buffer_length-1);
			buffer[buffer_length-1] = 0;
		}
	}
	else
	{
		strcpy(buffer, "");
	}
	return (TRUE);
}

// Reverse of GetProcAddress
BOOL CExport::GetProcName(void *address, char *buffer, DWORD buffer_length, WORD *ordinal)
{

	unsigned int i;
	DWORD *ptr_func, tmp, addr = (DWORD)address;
	int priority = 0;

	if (!CheckInterval(address))
	{
		// No library loaded or false interval
		return (FALSE);
	}
	if (buffer_length <= 1)
	{
//		MessageBox(0, "Buffer too small", "OK", 0);
		// Wrong parameters!
		return (FALSE);
	}

	// Trace all function addresses and find a name if it exists
	// If two functions points to the same address, give the priority to the name than the
	// ordinal
	ptr_func = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfFunctions);
	for (i=0; i<m_ptr_exp->NumberOfFunctions; i++)
	{
		tmp = (DWORD)m_pe_file.m_nt_header->imageBase+*ptr_func;
		if (addr == tmp)
		{
			if (m_table_nameordinals[i])
			{
				if (priority<2)
				{
					*ordinal = (WORD)(i+m_ptr_exp->Base);
					priority = 2;
					if ( buffer_length >= (1+strlen((char*)(m_table_nameordinals[i]))) )
					{
						strcpy(buffer, (char*)(m_table_nameordinals[i]));
					}
					else
					{
						memcpy(buffer, (void*)(m_table_nameordinals[i]), buffer_length-1);
						buffer[buffer_length-1] = 0;
					}
				}
			}
			else
			{
				if (priority<1)
				{
					*ordinal = (WORD)(i+m_ptr_exp->Base);
					priority = 1;
					strcpy(buffer, "");
				}
			}
		}
/*		else
		{
			// Don't forget to check the real pointer with GetProcAddress!
			// Example for <CreateProcessA>!!!!!
			if (m_table_nameordinals[i])
			{
				tmp = (DWORD)GetProcAddress(m_hmod, (char*)m_table_nameordinals[i]);
				if (tmp && addr == tmp)
				{
					if (priority<2)
					{
						*ordinal = (WORD)(i+m_ptr_exp->Base);
						priority = 2;
						if ( buffer_length >= (1+strlen((char*)(m_table_nameordinals[i]))) )
						{
							strcpy(buffer, (char*)(m_table_nameordinals[i]));
						}
						else
						{
							memcpy(buffer, (void*)(m_table_nameordinals[i]), buffer_length-1);
							buffer[buffer_length-1] = 0;
						}
					}
				}
			}
		}*/

		ptr_func++;
	}

	if (priority)
	{
		return (TRUE);
	}
	return (FALSE);
}

// For testing if a module has API with same function address
void CExport::WriteExport(char *filename)
{
	FILE *f;
	char buffer[256];
	unsigned int i, j;
	DWORD *ptr_func, *ptr_func2, tmp, tmp2;
	WORD ordinal;
	bool *mark = new bool[m_ptr_exp->NumberOfFunctions];
	for (i=0; i<m_ptr_exp->NumberOfFunctions; i++)
	{
		mark[i] = false;
	}

	f = fopen(filename, "w");

	// Trace all function addresses and find a name if it exists
	ptr_func = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfFunctions);
	for (i=0; i<m_ptr_exp->NumberOfFunctions; i++, ptr_func++)
	{
		if (mark[i])
			continue;
		tmp = (DWORD)m_pe_file.m_buffer+*ptr_func;
		buffer[0] = '\0';
		ordinal = (WORD)(i+m_ptr_exp->Base);
		sprintf(buffer+strlen(buffer), "addr:%08X ord:%04X ", tmp, ordinal);
		if (m_table_nameordinals[i])
		{
			sprintf(buffer+strlen(buffer), "name:%s \n", (char*)(m_table_nameordinals[i]));
		}
		else
		{
			strcat(buffer, "- \n");
		}
		fprintf(f, buffer);

		for (j=i+1, ptr_func2 = ptr_func+1; j<m_ptr_exp->NumberOfFunctions; j++, ptr_func2++)
		{
			tmp2 = (DWORD)m_pe_file.m_buffer+*ptr_func2;
			if (tmp == tmp2)
			{
				mark[j] = true;
				ordinal = (WORD)(j+m_ptr_exp->Base);
				buffer[0] = '\0';
				sprintf(buffer+strlen(buffer), "addr:%08X ord:%04X ", tmp2, ordinal);
				if (m_table_nameordinals[j])
				{
					sprintf(buffer+strlen(buffer), "name:%s \n", (char*)(m_table_nameordinals[j]));
				}
				else
				{
					strcat(buffer, "- \n");
				}

				fprintf(f, buffer);
			}
		}

		fprintf(f, "\n");
	}

	delete[] mark;
	fclose(f);
}

// Return the nearest export function (for ASProtect for example which does not redirect
// to the start of the export function)
BOOL CExport::GetNearestProcName(void *address, char *buffer, DWORD buffer_length,
								 WORD *ordinal)
{
	BOOL found = false;
	DWORD *ptr_func, tmp, addr = (DWORD)address, i, min, min_address = 0;

	if (!CheckInterval(address))
	{
		// No library loaded or false interval
		return (FALSE);
	}

	if (buffer_length <= 1)
	{
//		MessageBox(0, "Buffer too small", "OK", 0);
		// Wrong parameters!
		return (FALSE);
	}

	// Trace all function addresses and find a name if it exists
	ptr_func = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfFunctions);
	for (i=0; i<m_ptr_exp->NumberOfFunctions; i++)
	{
		tmp = (DWORD)m_pe_file.m_nt_header->imageBase+*ptr_func;
		if (addr >= tmp && tmp > min_address)
		{
			found = true;
			min = i;
			min_address = tmp;
		}
		ptr_func++;
	}

	if (found)
	{
		*ordinal = (WORD)(min+m_ptr_exp->Base);
		if (m_table_nameordinals[min])
		{
			if ( buffer_length >= (1+strlen((char*)(m_table_nameordinals[min]))) )
			{
				strcpy(buffer, (char*)(m_table_nameordinals[min]));
			}
			else
			{
				memcpy(buffer, (void*)(m_table_nameordinals[min]), buffer_length-1);
				buffer[buffer_length-1] = 0;
			}
		}
		else
		{
			strcpy(buffer, "");
		}
		return (TRUE);
	}

	return (FALSE);
}

// Return the Base of all Ordinals
DWORD CExport::GetBase()
{
	return (m_ptr_exp->Base);
}

// Check if the module forwards a function from another module
BOOL CExport::GetForward(char *mod, char *name, char *buffer, DWORD buffer_length,
						 WORD *ordinal)
{
	if (!name)
	{
		return (FALSE);
	}

	char mod2[256];
	unsigned int i, j;
	DWORD *ptr_func;
	char *str;
	DWORD limit = (DWORD)m_pe_file.m_buffer + (DWORD)m_pe_file.m_nt_header->imageSize;
	strcpy(mod2, mod);
	str = strrchr(mod2, '.');
	if (str)
	{
		*str = '\0';
	}

	if (buffer_length <= 1)
	{
//		MessageBox(0, "Buffer too small", "OK", 0);
		// Wrong parameters!
		return (FALSE);
	}

	limit -= strlen(name)+1;

	// Trace all function addresses and find a name if it exists
	ptr_func = (DWORD*)((DWORD)m_pe_file.m_buffer + (DWORD)m_ptr_exp->AddressOfFunctions);
	for (i=0; i<m_ptr_exp->NumberOfFunctions; i++)
	{
		str = (char*)((DWORD)m_pe_file.m_buffer+*ptr_func);
		j = 0;
		mod = mod2;
		while ((DWORD)str < (DWORD)limit)
		{
			char a, b;
			if (*str >= 'a' && *str <= 'z')
			{
				a = *str - ('a'-'A');
			}
			else
			{
				a = *str;
			}

			if (*mod >= 'a' && *mod <= 'z')
			{
				b = *mod - ('a'-'A');
			}
			else
			{
				b = *mod;
			}

			if (a != b)
			{
				break;
			}

			j++;
			str++;
			mod++;
		}

		if (j >= strlen(mod) && *str == '.' &&
			stricmp(str+1, name) == 0)
		{
			*ordinal = (WORD)(i+m_ptr_exp->Base);
			if (m_table_nameordinals[i])
			{
				if ( buffer_length >= (1+strlen((char*)(m_table_nameordinals[i]))) )
				{
					strcpy(buffer, (char*)(m_table_nameordinals[i]));
				}
				else
				{
					memcpy(buffer, (void*)(m_table_nameordinals[i]), buffer_length-1);
					buffer[buffer_length-1] = 0;
				}
			}
			else
			{
				strcpy(buffer, "");
			}
			return (TRUE);
		}

		ptr_func++;
	}

	return (FALSE);
}
