// Import REConstructor DLL v1.01 (C) 2001 MackT/uCF
///////////////////////////////////////////////////////////////////////
// Class for containing import functions
//
// (STL was used)
///////////////////////////////////////////////////////////////////////
// You're allowed to use parts of this code if you mention my name.
///////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "import.h"

char spt[256];

// Constructor
CImport::CImport()
{
	m_module_list.clear();
	m_nb_functions = 0;
}

// Destructor
CImport::~CImport()
{
	DeleteAll();
}

void CImport::DeleteAll()
{
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();

	while (my_iterator1 != m_module_list.end())
	{
		((*my_iterator1).second).thunk_list.clear();

		my_iterator1++;
	}

	m_module_list.clear();
}

bool CImport::AddFunction(char *module_name, DWORD rva, WORD ordinal, char *name,
						  void **view, bool valid/* = true*/, bool force/* = false*/)
{
	DWORD first_thunk;

	// Look for the associated module
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	while (my_iterator1 != m_module_list.end())
	{
		if (rva >= (*my_iterator1).second.first_thunk &&
			rva < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			first_thunk = (*my_iterator1).second.first_thunk;
			break;
		}
		my_iterator1++;
	}
	// No module found
	if (my_iterator1 == m_module_list.end())
	{
		return (false);
	}

	// The thunk does not exist!
	if ( m_module_list[(*my_iterator1).second.first_thunk].thunk_list.find(rva) == m_module_list[(*my_iterator1).second.first_thunk].thunk_list.end() )
	{
		return (false);
	}

	// We must force overwritting else return false
	if (!force && m_module_list[(*my_iterator1).second.first_thunk].thunk_list[rva].valid)
	{
		return (false);
	}

	*view = m_module_list[(*my_iterator1).second.first_thunk].thunk_list[rva].view;

/*	// The current thunk was already valid!
	if (m_module_list[first_thunk].thunk_list[rva].valid)
	{
		return (true);
	}*/

	MyImpThunk my_thunk;
	strcpy(my_thunk.name, name);
	strcpy(my_thunk.module_name, module_name);
	my_thunk.ordinal = ordinal;
	my_thunk.rva = rva;
	my_thunk.valid = valid;
	my_thunk.view = m_module_list[(*my_iterator1).second.first_thunk].thunk_list[rva].view;

	m_module_list[(*my_iterator1).second.first_thunk].thunk_list[rva] = my_thunk;
	return (true);
}

bool CImport::AddModule(char *module_name, DWORD first_thunk, DWORD nb_thunks,
						void *view/*= NULL*/, bool valid/* = true*/)
{
	MyImpThunk my_thunk;
	MyImpModule my_module;
	DWORD rva, i;
	bool quit = false;
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();

	strcpy(my_thunk.name, "");
	my_thunk.ordinal = 0;
	my_thunk.view = NULL;
	my_thunk.valid = false;

	my_module.first_thunk = first_thunk;
	my_module.nb_thunks = nb_thunks;
	my_module.view = view;
	my_module.valid = valid;
	strcpy(my_module.name, module_name);

	while (my_iterator1 != m_module_list.end())
	{
		if (first_thunk >= (*my_iterator1).second.first_thunk &&
			first_thunk < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			quit = true;
		}
		if (first_thunk+nb_thunks*4 >= (*my_iterator1).second.first_thunk &&
			first_thunk+nb_thunks*4 < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			quit = true;
		}
		if ((*my_iterator1).second.first_thunk >= first_thunk &&
			(*my_iterator1).second.first_thunk < first_thunk+nb_thunks*4)
		{
//			(*my_iterator1).second.first_thunk = first_thunk;
			my_module.first_thunk = first_thunk;
	 		quit = true;
		}
		if ((*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4 >= first_thunk &&
			(*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4 < first_thunk+nb_thunks*4)
		{
/*			m_module_list[(*my_iterator1).second.first_thunk].nb_thunks =
				(
				first_thunk+nb_thunks*4-
				(*my_iterator1).second.first_thunk
				)/4;*/
			my_module.nb_thunks = 
				(
				first_thunk+nb_thunks*4-
				(*my_iterator1).second.first_thunk
				)/4;

			quit = true;
		}
		if (quit)
		{
			my_module.thunk_list = (*my_iterator1).second.thunk_list;
			m_module_list[first_thunk] = my_module;
			for (rva=m_module_list[first_thunk].first_thunk, i=0; i<m_module_list[first_thunk].nb_thunks; rva+=4, i++)
			{
				if (m_module_list[first_thunk].thunk_list.find(rva) == m_module_list[first_thunk].thunk_list.end())
				{
					my_thunk.rva = rva;
					m_module_list[m_module_list[first_thunk].first_thunk].thunk_list[rva] = my_thunk;
					m_nb_functions++;
				}
			}
			break;
		}

		my_iterator1++;
	}

	// The module already exists!
	if (quit || m_module_list.find(first_thunk) != m_module_list.end())
	{
		return (false);
	}

	my_module.first_thunk = first_thunk;
	my_module.nb_thunks = nb_thunks;
	my_module.valid = valid;
	strcpy(my_module.name, module_name);
	my_module.thunk_list.clear();

	m_module_list[first_thunk] = my_module;
	for (rva=first_thunk, i=0; i<nb_thunks; rva+=4, i++)
	{
		my_thunk.rva = rva;
		m_module_list[first_thunk].thunk_list[rva] = my_thunk;
	}
	m_nb_functions += nb_thunks;
	return (true);
}

bool CImport::DeleteModule(DWORD first_thunk)
{
	// The module already exists!
	if ( m_module_list.find(first_thunk) != m_module_list.end())
	{
		m_nb_functions -= (*(m_module_list.find(first_thunk))).second.thunk_list.size();
		(*(m_module_list.find(first_thunk))).second.thunk_list.clear();
		m_module_list.erase(first_thunk);
		return (true);
	}

	return (false);
}

void CImport::ShowAll()
{
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	ImpThunkList::iterator my_iterator2;

	while (my_iterator1 != m_module_list.end())
	{
		if (::GetAsyncKeyState(VK_SHIFT)<0)
		{
			return;
		}
		MessageBox(0, ((*my_iterator1).second).name, "Mod", 0);
		my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
		while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
		{
			if (::GetAsyncKeyState(VK_SHIFT)<0)
			{
				return;
			}
			if (::GetAsyncKeyState(VK_CONTROL)<0)
			{
				break;
			}
			MessageBox(0, ((*my_iterator2).second).name, "Func", 0);
			my_iterator2++;
		}

		my_iterator1++;
	}
}

DWORD CImport::GetNbModules()
{
	return (m_module_list.size());
}

DWORD CImport::GetNbFunctions()
{
	return (m_nb_functions);
}

bool CImport::SetModuleValidity(DWORD rva, bool valid)
{
	// Look for the associated module
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	while (my_iterator1 != m_module_list.end())
	{
		if (rva >= (*my_iterator1).second.first_thunk &&
			rva < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			break;
		}
		my_iterator1++;
	}
	// No module found
	if (my_iterator1 == m_module_list.end())
	{
		return (false);
	}

	(*my_iterator1).second.valid = valid;
	return (true);
}

bool CImport::SetModuleName(DWORD rva, char *module_name)
{
	// Look for the associated module
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	while (my_iterator1 != m_module_list.end())
	{
		if (rva >= (*my_iterator1).second.first_thunk &&
			rva < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			break;
		}
		my_iterator1++;
	}
	// No module found
	if (my_iterator1 == m_module_list.end())
	{
		return (false);
	}

	strcpy((*my_iterator1).second.name, module_name);
	return (true);
}

void* CImport::GetModuleView(DWORD rva)
{
	// Look for the associated module
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	while (my_iterator1 != m_module_list.end())
	{
		if (rva >= (*my_iterator1).second.first_thunk &&
			rva < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			break;
		}
		my_iterator1++;
	}
	// No module found
	if (my_iterator1 == m_module_list.end())
	{
		return (NULL);
	}
	
	return ((*my_iterator1).second.view);
}

bool CImport::SetModuleView(DWORD first_thunk, void *view)
{
	// The module already exists!
	if ( m_module_list.find(first_thunk) != m_module_list.end())
	{
		(*(m_module_list.find(first_thunk))).second.view = view;
		return (true);
	}

	return (false);
}

bool CImport::SetFunctionView(DWORD rva, void *view)
{
	DWORD first_thunk;

	// Look for the associated module
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	while (my_iterator1 != m_module_list.end())
	{
		if (rva >= (*my_iterator1).second.first_thunk &&
			rva < (*my_iterator1).second.first_thunk+(*my_iterator1).second.nb_thunks*4)
		{
			first_thunk = (*my_iterator1).second.first_thunk;
			break;
		}
		my_iterator1++;
	}
	// No module found
	if (my_iterator1 == m_module_list.end())
	{
		return (false);
	}

	// The thunk does not exist!
	if ( m_module_list[(*my_iterator1).second.first_thunk].thunk_list.find(rva) == m_module_list[(*my_iterator1).second.first_thunk].thunk_list.end() )
	{
		return (false);
	}

	MyImpThunk my_thunk = m_module_list[first_thunk].thunk_list[rva];
	my_thunk.view = view;
	m_module_list[first_thunk].thunk_list[rva] = my_thunk;
	return (true);
}

ImpModuleList CImport::GetModel()
{
	return (m_module_list);
}

void CImport::UpdateValidity()
{
	ImpModuleList::iterator my_iterator1 = m_module_list.begin();
	ImpThunkList::iterator my_iterator2;
	bool valid;

	while (my_iterator1 != m_module_list.end())
	{
		if ( !((*my_iterator1).second).valid )
		{
			valid = true;
			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				if ( !((*my_iterator2).second).valid )
				{
					valid = false;
					break;
				}
				my_iterator2++;
			}

			if (valid)
			{
				(*my_iterator1).second.valid = true;
			}
		}

		my_iterator1++;
	}
}
