/* 
	===== CImport Class =====
*/

#ifndef __IMPORT_H__
#define __IMPORT_H__

#include <map>
#include <string>

typedef struct _MyImpThunk
{
	char			module_name[_MAX_PATH];
	char			name[_MAX_PATH];
	DWORD			rva;
	WORD			ordinal;
	bool			valid;
	void*			view;
} MyImpThunk;

typedef	std::map<DWORD, MyImpThunk>	ImpThunkList;

typedef struct _MyModule
{
	char			name[_MAX_PATH];
	DWORD			first_thunk;
	ImpThunkList	thunk_list;
	DWORD			nb_thunks;
	bool			valid;
	void*			view;
} MyImpModule;

typedef	std::map<DWORD, MyImpModule>	ImpModuleList;

class CImport
{
public:
	CImport();
	~CImport();

	bool	AddFunction(char *module_name, DWORD rva, WORD ordinal, char *name,
						void **view, bool valid = true, bool force = false);
	bool	AddModule(char *module_name, DWORD first_thunk, DWORD nb_thunks,
					  void *view = NULL, bool valid = true);
	bool	DeleteModule(DWORD first_thunk);
	void	ShowAll();
	DWORD	GetNbModules();
	DWORD	GetNbFunctions();
	void	DeleteAll();
	bool	SetModuleName(DWORD rva, char *module_name);
	bool	SetModuleValidity(DWORD rva, bool valid);
	void*	GetModuleView(DWORD rva);
	bool	SetModuleView(DWORD first_thunk, void *view);
	bool	SetFunctionView(DWORD rva, void *view);
	void	UpdateValidity();

	ImpModuleList	CImport::GetModel();

protected:
	ImpModuleList	m_module_list;
	DWORD			m_nb_functions;
};

#endif
