// Import REConstructor DLL v1.01 (C) 2001 MackT/uCF
///////////////////////////////////////////////////////////////////////
// Main class for rebuilding import
///////////////////////////////////////////////////////////////////////
// You're allowed to use parts of this code if you mention my name.
///////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ImpREC.h"
#include "Disasm.h"

// Constructor
CImpREC::CImpREC()
{
}

// Destructor
CImpREC::~CImpREC() 
{
	if (m_exports)
	{
		delete[] m_exports;
		m_exports = 0;
	}
}

// Initialize all what we need
BOOL CImpREC::Init()
{
	if (!InitAPIs())
		return FALSE;
	m_exports = 0;

	// Get the old editbox proc for replacing the new one
	m_importbyordinal = false;
	m_tracer_buffer_size = 0x100;
	m_tracer_max_recursion = 5;
	m_limitstart = 0x00400000;
	m_limitend   = 0xFFFFFFFF;

	m_newsection = false;

	m_imports.DeleteAll();
	m_proc_mods.clear();
	m_proc_hmods.clear();
	m_proc_szmods.clear();

	// Delete the buffer which will contain the pe_header of the target
	m_pe_header.SetIsModule(false);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// Main function for rebuilding imports
BOOL CImpREC::DoJob(DWORD pid, DWORD oep_rva, DWORD iat_rva, DWORD nb_recursion, char *filename)
{
	m_pid = pid;
	m_oep = oep_rva;
	m_tracer_max_recursion = nb_recursion;
	strcpy(m_dump_filename, filename);

	if (!LoadProcess())
	{
		MessageBox(0, "Can't load the process!", "ImpREC error", 0);
		return (FALSE);
	}

	if (!FindOriginalIAT(iat_rva))
	{
		MessageBox(0, "Can't find the original IAT", "ImpREC error", 0);
		return (FALSE);
	}

//	MessageBox(0, "Start search", "ImpREC", 0);
	Search();

//	m_imports.ShowAll();

//	MessageBox(0, "Start trace all", "ImpREC", 0);
	TraceAll();

//	MessageBox(0, "Start arrange", "ImpREC", 0);
	UltraArrange();

//	MessageBox(0, "Start fix", "ImpREC", 0);
	if (!FixDump())
	{
		MessageBox(0, "Can't fix the dump", "ImpREC error", 0);
		return (FALSE);
	}

	return (TRUE);
}


// Load process infos
BOOL CImpREC::LoadProcess() 
{
	unsigned int ii;
	char proc_name[256];
	int  i, j;
	BOOL found = FALSE;

	char string[256];
	MODULEENTRY32 module;
	module.dwSize=sizeof(MODULEENTRY32);
	HANDLE snap;

	if (m_exports)
	{
		delete[] m_exports;
		m_exports = 0;
	}
	m_proc_mods.clear();
	m_proc_hmods.clear();
	m_proc_szmods.clear();
	m_imports.DeleteAll();

	// Now list all associated modules
	if (m_nt_os)
	{
		// We need to get the name of the process which we got the PID
		HMODULE hMods[1024];
		HANDLE hProcess;

		// Get the list of process identifiers.
		DWORD aProcesses[1024], cbNeeded, cProcesses;
		if ( !MyEnumProcesses( aProcesses, sizeof(aProcesses), &cbNeeded ) )
			return FALSE;
		// Calculate how many process identifiers were returned.
		cProcesses = cbNeeded / sizeof(DWORD);

		for (i=0; i<cProcesses; i++)
		{
			char szProcessName[_MAX_PATH] = "unknown";

			// Get a handle to the process.
			HANDLE hProcess = OpenProcess(	PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
											FALSE, aProcesses[i] );

			// Get the process name.
			if ( hProcess )
			{
				HMODULE hMod;
				DWORD cbNeeded;

				if (MyEnumProcessModules(	hProcess, &hMod, sizeof(hMod), &cbNeeded) )
				{
					MyGetModuleFileNameEx( hProcess, hMod, szProcessName, 
									   sizeof(szProcessName) );

					if (m_pid == aProcesses[i])
					{
						strcpy(proc_name, szProcessName);
						found = TRUE;
						break;
					}
				}

				CloseHandle( hProcess );
			}

		}

		if (!found)
		{
			return (FALSE);
		}

		// Get a list of all the modules in this process.
		hProcess = OpenProcess(  PROCESS_QUERY_INFORMATION |
										PROCESS_VM_READ,
										FALSE, m_pid );

		if (MyEnumProcessModules(hProcess, hMods, sizeof(hMods), &cbNeeded))
		{
			for (ii=0; ii<(cbNeeded / sizeof(HMODULE)); ii++)
			{
				char szModName[_MAX_PATH];

				// Get the full path to the module's file.
				if (MyGetModuleFileNameEx(hProcess, hMods[ii], szModName, sizeof(szModName)))
				{
					// Get the full infos of the module
					MODULEINFO mod_info;
					MyGetModuleInformation(hProcess, hMods[ii], &mod_info, sizeof(MODULEINFO));

					strcpy(string, szModName);
					CharLower(string);
					if (stricmp(string, proc_name) != 0)
					{
						m_proc_mods.push_back(string);
						m_proc_hmods.push_back((DWORD)(mod_info.lpBaseOfDll));
						m_proc_szmods.push_back((DWORD)(mod_info.SizeOfImage));
					}
					else
					{
						m_imgbase = (DWORD)(mod_info.lpBaseOfDll);
						m_imgsize = (DWORD)(mod_info.SizeOfImage);
						m_pe_header.LoadPEVars(szModName);
					}
				}
			}
		}
		CloseHandle( hProcess );
	}
	else
	{
		// We need to get the name of the process which we got the PID

		// Snapshot of working task
		PROCESSENTRY32 proc;
		proc.dwSize=sizeof(PROCESSENTRY32);

		snap=(*MyCreateToolhelp32Snapshot)(TH32CS_SNAPPROCESS,0);
		if (snap==0)
		{
			return FALSE;
		}

		// Read the first process
		if (MyProcess32First(snap,&proc))
		{
			if (m_pid == proc.th32ProcessID)
			{
				strcpy(proc_name, proc.szExeFile);
				found = TRUE;
			}
			else
			{
				// While there is a process, read this
				while (MyProcess32Next(snap,&proc))
				{
					if (m_pid == proc.th32ProcessID)
					{
						strcpy(proc_name, proc.szExeFile);
						found = TRUE;
						break;
					}
				}
			}
		}
		CloseHandle(snap);

		if (!found)
		{
			return FALSE;
		}

		snap=MyCreateToolhelp32Snapshot(TH32CS_SNAPMODULE, m_pid);
		if (snap==0)
		{
			return FALSE;
		}

		// Read First Module
		if (MyModule32First(snap,&module))
		{
			strcpy(string, module.szExePath);
			CharLower(string);
			if (stricmp(string, proc_name) != 0)
			{
				char mackt[_MAX_PATH];
				strcpy(mackt, string);
				m_proc_mods.push_back(mackt);
				m_proc_hmods.push_back((DWORD)(module.modBaseAddr));
				m_proc_szmods.push_back((DWORD)(module.modBaseSize));
			}
			else
			{
				m_imgbase = (DWORD)module.modBaseAddr;
				m_imgsize = module.modBaseSize;
				m_pe_header.LoadPEVars(module.szExePath);
			}

			// Loop on next Module
			while (MyModule32Next(snap,&module))
			{
				strcpy(string, module.szExePath);
				CharLower(string);
				if (stricmp(string, proc_name) != 0)
				{
					char mackt[_MAX_PATH];
					strcpy(mackt, string);
					m_proc_mods.push_back(mackt);
					m_proc_hmods.push_back((DWORD)(module.modBaseAddr));
					m_proc_szmods.push_back((DWORD)(module.modBaseSize));
				}
				else
				{
					m_imgbase = (DWORD)module.modBaseAddr;
					m_imgsize = module.modBaseSize;
					m_pe_header.LoadPEVars(module.szExePath);
				}
			}
		}

		CloseHandle(snap);
	}

	// Build all attached exports
	j = 0;
	m_nb_exports = m_proc_mods.size();
	m_exports = new CExport[m_nb_exports];
	for (i=0; i<m_nb_exports; i++)
	{
		if (m_exports[j].Create( (char*)(m_proc_mods[i].c_str()),m_pid,
								 m_proc_hmods[i], m_proc_szmods[i] ) >= 1)
		{
			j++;
		}
	}
	m_nb_exports = j;

	return (TRUE);
}

// Init all needed API for playing with processes and modules
BOOL CImpREC::InitAPIs()
{
	// Try to load "PSAPI.DLL" if possible for NT/2000 OS
	m_psapi_hmod = LoadLibrary("psapi.dll");

	if (m_psapi_hmod)
	{
		MyEnumProcesses = (FUNC_NT1)GetProcAddress(m_psapi_hmod, "EnumProcesses");
		if (!MyEnumProcesses)
			goto W9xOS;
		MyEnumProcessModules = (FUNC_NT2)GetProcAddress(m_psapi_hmod, "EnumProcessModules");
		if (!MyEnumProcessModules)
			goto W9xOS;
		MyGetModuleInformation = (FUNC_NT3)GetProcAddress(m_psapi_hmod, "GetModuleInformation");
		if (!MyGetModuleInformation)
			goto W9xOS;
		MyGetModuleFileNameEx = (FUNC_NT4)GetProcAddress(m_psapi_hmod, "GetModuleFileNameExA");
		if (!MyGetModuleFileNameEx)
			goto W9xOS;
		MyGetProcessMemoryInfo = (FUNC_NT5)GetProcAddress(m_psapi_hmod, "GetProcessMemoryInfo");
		if (!MyGetProcessMemoryInfo)
			goto W9xOS;

		m_nt_os = true;
		return (TRUE);
	}

W9xOS:
	// else try "TOOLHELP32"
	HMODULE hmod;
	hmod = LoadLibrary("kernel32.dll");
	if (hmod)
	{
		MyCreateToolhelp32Snapshot = (FUNC1)GetProcAddress(hmod, "CreateToolhelp32Snapshot");
		if (!MyCreateToolhelp32Snapshot)
		{
			goto ERROR_OS;
		}
		MyProcess32First = (FUNC2)GetProcAddress(hmod, "Process32First");
		if (!MyProcess32First)
		{
			goto ERROR_OS;
		}
		MyProcess32Next = (FUNC2)GetProcAddress(hmod, "Process32Next");
		if (!MyProcess32Next)
		{
			goto ERROR_OS;
		}
		MyModule32First = (FUNC3)GetProcAddress(hmod, "Module32First");
		if (!MyModule32First)
		{
			goto ERROR_OS;
		}
		MyModule32Next = (FUNC3)GetProcAddress(hmod, "Module32Next");
		if (!MyModule32Next)
		{
			goto ERROR_OS;
		}
		MyHeap32ListFirst = (FUNC4)GetProcAddress(hmod, "Heap32ListFirst");
		if (!MyHeap32ListFirst)
		{
			goto ERROR_OS;
		}
		MyHeap32ListNext = (FUNC4)GetProcAddress(hmod, "Heap32ListNext");
		if (!MyHeap32ListNext)
		{
			goto ERROR_OS;
		}
		MyHeap32First = (FUNC5)GetProcAddress(hmod, "Heap32First");
		if (!MyHeap32First)
		{
			goto ERROR_OS;
		}
		MyHeap32Next = (FUNC6)GetProcAddress(hmod, "Heap32Next");
		if (!MyHeap32Next)
		{
			goto ERROR_OS;
		}

		// Toolhelp32 API'S library loaded successfully
		FreeLibrary(hmod);
		m_nt_os = false;
		return (TRUE);
	}

ERROR_OS:
	// Impressive error!!! Hehe :-)
	return (FALSE);
}

// Add an import function
BOOL CImpREC::AddImp(DWORD rva, char *mod_name, WORD ordinal, char *proc_name,
					 bool valid/* = true */, bool force/* = false */)
{
	static DWORD item = 0;
	return (m_imports.AddFunction(mod_name, rva, ordinal, proc_name, (void**)&item, valid, force));
}

// Search button was clicked
void CImpREC::Search() 
{
	int   nb_imp=0, nb_wrong_imp=0;
	DWORD iat_rva, iat_size;
	DWORD ii, old_ii;
	unsigned char *IAT_buffer=0;
	HANDLE handle;
	DWORD dwCheckSize;
	int i;

	void *func_address;
	char proc_name[256];
	WORD ordinal;

	if (!m_exports)
	{
		return;
	}

	// Get the IAT of the process
	iat_rva = m_iat_rva+m_imgbase;
	iat_size = m_iat_size;

	IAT_buffer = new unsigned char[iat_size];
	// Play with process by dumping
	handle=OpenProcess(PROCESS_ALL_ACCESS,TRUE,m_pid);
	if (!handle)
	{
		delete[] IAT_buffer;
		return;
	}
	// Ok, now read the whole header
	DWORD dwOldProt;
	if (!VirtualProtectEx( handle, (LPVOID)iat_rva, iat_size, PAGE_READWRITE, &dwOldProt ))
	{
		CloseHandle(handle);
		delete[] IAT_buffer;
		return;
	}

	if (!ReadProcessMemory( handle, (LPVOID)iat_rva, (LPVOID)IAT_buffer, iat_size, &dwCheckSize) || dwCheckSize != iat_size)
	{
		VirtualProtectEx( handle, (LPVOID)iat_rva, iat_size, dwOldProt, &dwCheckSize );
		CloseHandle(handle);
		delete[] IAT_buffer;
		return;
	}

	VirtualProtectEx( handle, (LPVOID)iat_rva, iat_size, dwOldProt, &dwCheckSize );
	// End of dumping
	CloseHandle(handle);

	// Prepare import structure
	old_ii = 0;
	for (ii=0; ii<iat_size; ii+=4)
	{
		func_address = (void*)(*(DWORD*)(IAT_buffer+ii));
		if (!func_address)
		{
			if (ii-old_ii>=4)
			{
				m_imports.AddModule( "?", old_ii+iat_rva-m_imgbase, (ii-old_ii)/4, NULL, false);
				for (i=0; i<(ii-old_ii)/4; i++)
				{
					void *view;
					char str[256];
					sprintf(str, "%08X", (void*)(*(DWORD*)(IAT_buffer+old_ii+i*4)));
					m_imports.AddFunction("?", old_ii+iat_rva-m_imgbase+i*4, 0, str, &view, false);
				}
			}
			old_ii = ii+4;
		}
	}
	if (ii-old_ii>=4)
	{
		m_imports.AddModule("?", old_ii+iat_rva-m_imgbase, (ii-old_ii)/4, NULL, false);
		for (i=0; i<(ii-old_ii)/4; i++)
		{
			void *view;
			char str[256];
			sprintf(str, "%08X", (void*)(*(DWORD*)(IAT_buffer+old_ii+i*4)));
			m_imports.AddFunction("?", old_ii+iat_rva-m_imgbase+i*4, 0, str, &view, false);
		}
	}

	// Go for the search
	old_ii = 0;
	for (ii=0; ii<iat_size; ii+=4)
	{
		func_address = (void*)(*(DWORD*)(IAT_buffer+ii));

		// Non-Null DWORD found
		if (func_address)
		{
			// Look for address in our export datas
			for (i=0; i<m_nb_exports; i++)
			{
				// Export found
				if (m_exports[i].GetProcName(func_address, proc_name, 256, &ordinal))
				{
					if (AddImp(iat_rva+ii-m_imgbase, m_exports[i].GetLibName(), ordinal, proc_name))
					{
						nb_imp++;
					}
					break;
				}
			}

			// No export found in modules
			if (i >= m_nb_exports)
			{
				nb_wrong_imp++;
			}
		}
	}
	delete[] IAT_buffer;

	ValidateImport();
}

// Fix a dumped file
BOOL CImpREC::FixDump() 
{
	CPEFile pe_file;
//	char buffer[256];
//	char tmp[256];
	char ext[5];
	int nb_mod = 0, rest;
	int nb, nb_wrong=0;
	DWORD offset, iid_rva, ascii_rva, iid_offset, ascii_offset;
	DWORD total_length, iid_length;
//	DWORD oep;

	ImpModuleList modlist = m_imports.GetModel();
	ImpModuleList::iterator my_iterator1;
	ImpThunkList::iterator my_iterator2;

/*	// Get the RVA to put the Image Import Descriptor
	GetDlgItemText(IDC_IID_RVA, tmp, 256);
	sscanf(tmp, "%X", &iid_rva);

	// Correct parity value of address
	if (iid_rva%2)
	{
		iid_rva++;
		sprintf(tmp, "%08X", iid_rva);
		SetDlgItemText(IDC_IID_RVA, tmp);
		UpdateData(FALSE);
		MessageBox("RVA of new import must be pair. It was automatically fixed", "Note!");
	}*/

	nb_mod = m_imports.GetNbModules();
	nb = 0;
	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		if ( !((*my_iterator1).second).valid)
		{
			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				if ( !((*my_iterator2).second).valid)
				{
					nb_wrong++;
				}

				nb++;
				my_iterator2++;
			}
		}

		my_iterator1++;
	}

	if (nb_mod == 0)
	{
		MessageBox(0, "No import has been found", "ImpREC", 0);
		return (TRUE);
	}

	// Load the Dumped file
	if (!pe_file.LoadExecutable(m_dump_filename))
	{
		return (FALSE);
	}

	// Add a new section?
//	if (m_newsection)
	{
		DWORD new_sz;
		if (pe_file.AddSection(".GUW32", GetImportSize(), &iid_rva, &new_sz, 0xC0000040))
		{
			// Do not forget to fix the Image Size
			pe_file.m_nt_header->imageSize = iid_rva + new_sz;
		}
		else
		{
			return (FALSE);
		}
	}

	// Check bounds
	if (!pe_file.RVA2Offset(iid_rva, &iid_offset))
	{
		return (FALSE);
	}

	iid_length = nb_mod*(5*4); // <- 5*4 = size of iid
	total_length = iid_length + (5*4); // + a blank
	ascii_rva = iid_rva + iid_length + (5*4);
	ascii_offset = iid_offset + iid_length + (5*4);

	// Invalid new import RVA
	if (iid_offset >= (DWORD)(pe_file.m_size))
	{
		return (FALSE);
	}
	if (ascii_offset >= (DWORD)(pe_file.m_size))
	{
		return (FALSE);
	}

	// Fix the Directories IID
//	pe_file.m_nt_header->entryPoint = m_oep;
	pe_file.m_directories[ImportDataDirectory].RVA = iid_rva;
	pe_file.m_directories[ImportDataDirectory].size = nb_mod*(5*4);

	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		if (!pe_file.RVA2Offset(((*my_iterator1).second).first_thunk, &offset))
		{
			return (FALSE);
		}
		if (((*my_iterator1).second).valid)
		{
			// Fill the IID
			// OriginalFirstThunk
			*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
			iid_rva += 4;
			iid_offset += 4;
			// TimeDateStamp
			*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
			iid_rva += 4;
			iid_offset += 4;
			// ForwarderChain
			*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
			iid_rva += 4;
			iid_offset += 4;
			// Name of the DLL
			*((DWORD*)(pe_file.m_buffer+iid_offset)) = ascii_rva;
			iid_rva += 4;
			iid_offset += 4;
			// First Thunk
			*((DWORD*)(pe_file.m_buffer+iid_offset)) = ((*my_iterator1).second).first_thunk;
			iid_rva += 4;
			iid_offset += 4;

			// Copy the module name
			strcpy((char*)(pe_file.m_buffer+ascii_offset), ((*my_iterator1).second).name);
			ascii_rva += strlen(((*my_iterator1).second).name)+1;
			ascii_offset += strlen(((*my_iterator1).second).name)+1;
			total_length += strlen(((*my_iterator1).second).name)+1;

			// Alignment
			rest = total_length%2;
			if (rest)
			{
				rest = 2-rest;
				ascii_rva += rest;
				ascii_offset += rest;
				total_length += rest;
			}

			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				if (((*my_iterator2).second).valid)
				{
					if (!pe_file.RVA2Offset(((*my_iterator2).second).rva, &offset))
					{
						return (FALSE);
					}

					// Import by function name
					if (!m_importbyordinal && strlen(((*my_iterator2).second).name) > 0)
					{
						// Point the IAT function pointer to this string
						*((DWORD*)(pe_file.m_buffer+offset)) = ascii_rva;

						// Fill the ASCII function name
						if ((ascii_offset+strlen(((*my_iterator2).second).name)+1+2) >= (DWORD)(pe_file.m_size))
						{
							return (FALSE);
						}

						// Hint (1 short = ordinal)
						*((unsigned short*)(pe_file.m_buffer+ascii_offset)) = (WORD)((*my_iterator2).second).ordinal;
						ascii_rva += 2;
						ascii_offset += 2;
						// Copy the function name
						strcpy((char*)(pe_file.m_buffer+ascii_offset), ((*my_iterator2).second).name);
						ascii_rva += strlen(((*my_iterator2).second).name)+1;
						ascii_offset += strlen(((*my_iterator2).second).name)+1;
						total_length += strlen(((*my_iterator2).second).name)+1+2;

						// Alignment
						rest = total_length%2;
						if (rest)
						{
							rest = 2-rest;
							ascii_rva += rest;
							ascii_offset += rest;
							total_length += rest;
						}
					}
					// Import by ordinal
					else
					{
						// Fill the IAT function with the ordinal followed by 0x8000
						*((DWORD*)(pe_file.m_buffer+offset)) = 0x80000000 | ((*my_iterator2).second).ordinal;
					}
				}
				my_iterator2++;
			}
		}

		my_iterator1++;
	}

	// Finish the IID
	*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
	iid_rva += 4;
	iid_offset += 4;
	*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
	iid_rva += 4;
	iid_offset += 4;
	*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
	iid_rva += 4;
	iid_offset += 4;
	*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
	iid_rva += 4;
	iid_offset += 4;
	*((DWORD*)(pe_file.m_buffer+iid_offset)) = 0;
	iid_rva += 4;
	iid_offset += 4;

	// Save the results
	strcpy(ext, m_dump_filename+strlen(m_dump_filename)-4);
	strcpy(m_dump_filename+strlen(m_dump_filename)-4, "_");
	strcat(m_dump_filename, ext);
	if (pe_file.SaveExecutable(m_dump_filename))
	{
		return (TRUE);
	}

	return (FALSE);
}

// Trace into a redirected IAT pointer
void* CImpREC::Trace(void *ptr, char *buffer, DWORD buffer_length,
					 WORD *ordinal, int *lib_index, int max_recursion)
{
	DWORD func_address;

	// Always test if it's not already a real pointer!
	{
		int i;
		for (i=0; i<m_nb_exports; i++)
		{
			if (m_exports[i].CheckInterval(ptr))
			{
				if (m_exports[i].GetProcName(ptr, buffer, buffer_length, ordinal))
				{
					*lib_index = i;
					return (ptr);
				}
				else
				{
					return (NULL);
				}
			}
		}
	}

	CDisasm ds(m_imgbase, m_limitstart, m_limitend, m_pid, max_recursion, m_exports, m_nb_exports);
	if (ds.Trace((DWORD)ptr, m_tracer_buffer_size, func_address, buffer, buffer_length,
		ordinal, lib_index, TRUE, 0))
	{
		return ((void*)func_address);
	}

	return (NULL);
}

void CImpREC::TraceAll() 
{
	ImpModuleList modlist = m_imports.GetModel();
	ImpModuleList::iterator my_iterator1 = modlist.begin();
	ImpThunkList::iterator my_iterator2;
	DWORD func_address, to_trace;
	char proc_name[256];
	int  lib_index = -1;
	DWORD nb_imp = 0, nb_wrong = 0;
	WORD  ordinal;

	while (my_iterator1 != modlist.end())
	{
		if ( !((*my_iterator1).second).valid )
		{
			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				if ( !((*my_iterator2).second).valid )
				{
					sscanf(((*my_iterator2).second).name, "%X", &to_trace);

					// Hardcore tracing in it
					CDisasm ds(m_imgbase, m_limitstart, m_limitend, m_pid, m_tracer_max_recursion, m_exports, m_nb_exports);
					if (ds.Trace(to_trace, m_tracer_buffer_size, func_address, proc_name, 256,
						&ordinal, &lib_index, TRUE, 0))
					{
						nb_imp++;
						AddImp(((*my_iterator2).second).rva, m_exports[lib_index].GetLibName(), ordinal, proc_name, true, true);
					}
					else
					{
						nb_wrong++;
						if (lib_index == -2)
						{
							break;
						}
					}
				}

				my_iterator2++;
			}
		}

		my_iterator1++;
	}

	ValidateImport();
}

// Returns the size of the new import datas by simulating its reconstruction
DWORD CImpREC::GetImportSize()
{
	int nb_mod = 0, rest;
	int nb;
	DWORD total_length;

	ImpModuleList modlist = m_imports.GetModel();
	ImpModuleList::iterator my_iterator1;
	ImpThunkList::iterator my_iterator2;

	// Mode count ON
	nb_mod = m_imports.GetNbModules();
	if (nb_mod == 0)
	{
		return (0);
	}

	nb = 0;
	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		if ( !((*my_iterator1).second).valid)
		{
			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				nb++;
				my_iterator2++;
			}
		}

		my_iterator1++;
	}

	total_length = nb_mod*(5*4) + (5*4); // + a blank

	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		if (((*my_iterator1).second).valid)
		{
			total_length += strlen(((*my_iterator1).second).name)+1;

			// Alignment
			rest = total_length%2;
			if (rest)
			{
				rest = 2-rest;
				total_length += rest;
			}

			my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
			while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
			{
				if (((*my_iterator2).second).valid)
				{
					// Import by function name
					if (!m_importbyordinal && strlen(((*my_iterator2).second).name) > 0)
					{
						total_length += strlen(((*my_iterator2).second).name)+1+2;

						// Alignment
						rest = total_length%2;
						if (rest)
						{
							rest = 2-rest;
							total_length += rest;
						}
					}
					// Import by ordinal
					else
					{
					}
				}
				my_iterator2++;
			}
		}

		my_iterator1++;
	}

	return (total_length);
}

// Check, modify and validate import
void CImpREC::ValidateImport()
{
	ImpModuleList modlist;
	ImpModuleList::iterator my_iterator1;
	ImpThunkList::iterator my_iterator2;
	bool  first_output = true;
	DWORD old_rva = 0;
	DWORD old_ord;
	char  *old_str_mod = NULL;
	char  *old_proc_name = NULL;
	int   i;
	int   invalid = 0, first_invalid = -1;

	// We are going to cut forward
	modlist = m_imports.GetModel();
	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		if ( !((*my_iterator1).second).valid )
		{
			for (i=0, my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
				 my_iterator2 != ((*my_iterator1).second).thunk_list.end();)
			 {
				// The function is invalid
				if ( !((*my_iterator2).second).valid )
				{
					// If the 2 modules are not the same and the rva's follow themselves
					// => Incorrect IAT!!
					if (i!=0 &&
						stricmp(old_str_mod, ((*my_iterator2).second).module_name)!=0 &&
						((*my_iterator2).second).rva==old_rva+4)
					{
						invalid++;
						if (first_invalid == -1)
						{
							first_invalid = i;
						}
					}

					old_rva = ((*my_iterator2).second).rva;
					old_str_mod = ((*my_iterator2).second).module_name;

					i++;
					my_iterator2++;
					continue;
				}

				// The function is valid
				// If the 2 modules are not the same and the rva's follow themselves
				// => Incorrect IAT!!
				if (i!=0 &&
					stricmp(old_str_mod, ((*my_iterator2).second).module_name)!=0 &&
					((*my_iterator2).second).rva==old_rva+4)
				{
					invalid++;
					if (first_invalid == -1)
					{
						first_invalid = i;
					}
				}

				if (i!=0 && strlen(old_str_mod)>0)
				{
					if (stricmp(old_str_mod, ((*my_iterator2).second).module_name)!=0)

					// If the 2 modules are not the same and the rva's follow themselves
					// => Incorrect IAT!!
					if (stricmp(old_str_mod, ((*my_iterator2).second).module_name)!=0 &&
						((*my_iterator2).second).rva==old_rva+4 &&
						strlen(((*my_iterator2).second).name)>0)
					{
						// Try to solve the pb by checking forward pointers
						int j, ind = -1, old_ind = -1;

						// Get both index of each modules
						for (j=0; j<m_nb_exports; j++)
						{
							if (stricmp(((*my_iterator2).second).module_name,
								m_exports[j].GetLibName()) == 0)
							{
								ind = j;
								break;
							}
						}
						if (ind >= 0)
						{
							for (j=0; j<m_nb_exports; j++)
							{
								if (stricmp(old_str_mod, m_exports[j].GetLibName()) == 0)
								{
									old_ind = j;
									break;
								}
							}
							if (old_ind >= 0)
							{
								char new_proc_name[256];
								WORD new_ord;

								// Look at forward exports
								if (m_exports[old_ind].GetForward(((*my_iterator2).second).module_name,
									((*my_iterator2).second).name,
									new_proc_name, 256, &new_ord))
								{
									AddImp(((*my_iterator2).second).rva,
										m_exports[old_ind].GetLibName(),
										new_ord, new_proc_name, true, true);

									if (first_output)
									{
										first_output = false;
									}
									invalid--;

									modlist = m_imports.GetModel();
									my_iterator1 = modlist.begin();
									i=0;
									my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
									continue;
								}

								if (m_exports[ind].GetForward(old_str_mod, old_proc_name,
									new_proc_name, 256, &new_ord))
								{
									AddImp(old_rva, m_exports[ind].GetLibName(), new_ord, new_proc_name, true, true);

									if (first_output)
									{
										first_output = false;
									}
									invalid--;

									modlist = m_imports.GetModel();
									my_iterator1 = modlist.begin();
									i=0;
									my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
									continue;
								}

								// If we're here, the IAT can't be solve by forwarding export functions
								///////////////////////////////////////////////////////////////////////

							}			// if (old_ind >= 0)
						}				// if (ind >= 0)

					}
				}

				old_rva = ((*my_iterator2).second).rva;
				old_ord = ((*my_iterator2).second).ordinal;
				old_proc_name = ((*my_iterator2).second).name;
				old_str_mod = ((*my_iterator2).second).module_name;
				i++;
				my_iterator2++;
			}
		}

		my_iterator1++;
	}
	
	// We are going to update module name of each thunks
	modlist = m_imports.GetModel();
	my_iterator1 = modlist.begin();
	while (my_iterator1 != modlist.end())
	{
		first_output = true;
		old_str_mod = NULL;
		my_iterator2 = ((*my_iterator1).second).thunk_list.begin();
		while (my_iterator2 != ((*my_iterator1).second).thunk_list.end())
		{
			if ( !((*my_iterator2).second).valid ||
				(old_str_mod &&
				stricmp( old_str_mod, ((*my_iterator2).second).module_name) != 0) )
			{
				first_output = false;
				break;
			}
			old_str_mod = ((*my_iterator2).second).module_name;
			my_iterator2++;
		}

		((*my_iterator1).second).valid = first_output;
		m_imports.SetModuleValidity(((*my_iterator1).second).first_thunk, first_output);
		if (first_output && old_str_mod)
		{
			m_imports.SetModuleName(((*my_iterator1).second).first_thunk, old_str_mod);
			strcpy(((*my_iterator1).second).name, old_str_mod);
		}

		my_iterator1++;
	}
}

// Find the original IAT with the OEP
BOOL CImpREC::FindOriginalIAT(DWORD iat_rva)
{
	DWORD func_address, oep;
	int i;
	BOOL found = FALSE;

	if (!m_exports)
	{
		return (FALSE);
	}

	// If we have the RVA which can contain the original IAT
	if (iat_rva)
	{
		func_address = iat_rva + m_pe_header.m_nt_header->imageBase;
		found = TRUE;
	}
	// Else try to find it by tracing into the OEP for the first API call
	else
	{
		oep = m_oep;
		CDisasm ds(m_imgbase, m_limitstart, m_limitend, m_pid, m_tracer_max_recursion, m_exports, m_nb_exports);
		ds.SetMaxDepth(m_tracer_max_recursion);

		found = ds.LookForIAT((DWORD)(m_pe_header.m_nt_header->imageBase+oep), m_tracer_buffer_size,
							  func_address, 0);
	}

	// Ok we got something, now check if it's valid
	if (found)
	{
		i = m_pe_header.FindSectionIndex(func_address - m_pe_header.m_nt_header->imageBase);
		if (i >= 0)
		{
			// All is ok, now try to reduce the range of the orignal IAT
			bool   double_zero;
			DWORD  dwCheckSize;
			DWORD  sec_start = m_pe_header.m_sections[i].RVA;
			DWORD  sec_size = m_pe_header.m_sections[i].misc.virtualSize;
			BYTE*  tmp_section = new BYTE[m_pe_header.m_sections[i].misc.virtualSize];
			HANDLE handle;

			handle=OpenProcess(PROCESS_ALL_ACCESS, FALSE, m_pid);
			if (handle)
			{
				if (ReadProcessMemory( handle, (void*)(sec_start+m_imgbase),
									   (LPVOID)tmp_section, sec_size ,
									   &dwCheckSize)
					&& dwCheckSize == sec_size)
				{
					int j;

					j = (func_address-m_imgbase)-m_pe_header.m_sections[i].RVA;
					double_zero = false;
					while (j>=4 && (*((DWORD*)(tmp_section+j))==0) ||
						(*((DWORD*)(tmp_section+j))>=m_limitstart && *((DWORD*)(tmp_section+j))<=m_limitend))
					{
						if (*((DWORD*)(tmp_section+j))==0)
						{
							if (double_zero)
							{
								break;
							}
							double_zero = true;
						}
						else
						{
							double_zero = false;
						}

						j-=4;
					}
					if (j>0)
					{
//						if (!double_zero)
						{
							j+=4;
						}
						sec_start += j;
					}

					double_zero = false;
					j = (func_address-m_imgbase)-m_pe_header.m_sections[i].RVA;
					while (j<sec_size && (*((DWORD*)(tmp_section+j))==0) ||
						(*((DWORD*)(tmp_section+j))>=m_limitstart && *((DWORD*)(tmp_section+j))<=m_limitend))
					{
						if (*((DWORD*)(tmp_section+j))==0)
						{
							if (double_zero)
							{
								break;
							}
							double_zero = true;
						}
						else
						{
							double_zero = false;
						}

						j+=4;
					}
					if (j<sec_size)
					{
						if (!double_zero)
						{
							j-=4;
						}
						sec_size = j+m_pe_header.m_sections[i].RVA-sec_start;
					}

				}
				CloseHandle(handle);
			}
			delete[] tmp_section;

			m_iat_rva = sec_start;
			m_iat_size = sec_size;
			return (TRUE);

		}	// if (i >= 0)
		else
		{
		}

	}	// if (ds.LookForIAT(...))
	else
	{
	}

	// Nothing found :-(
	return (FALSE);
}

void CImpREC::UltraArrange() 
{
	ImpModuleList modlist = m_imports.GetModel();
	ImpModuleList::iterator my_iterator1 = modlist.begin();
	ImpThunkList::iterator my_iterator2;

	while (my_iterator1 != modlist.end())
	{
		// We have an invalid module => Kill it!
		if ( !((*my_iterator1).second).valid )
		{
			m_imports.DeleteModule(((*my_iterator1).second).first_thunk);
		}

		my_iterator1++;
	}
}
