#ifndef __WATCOMC__
#error You only can use this version of the API with WATCOM C
#endif
#include <i86.h>
#include <dos.h>

#define MIDASUSED

#ifdef MIDASUSED
#include <midasdll.h>
#endif


long use16only;

unsigned long *framebuffer=0; // You put the frame in that buffer.
long screensize;     // Size of the screen in bytes.
long screenx,screeny; // Size of the screen in pixels.
long byteperpixel;


typedef  unsigned char          boolean;
typedef  unsigned char          byte;
typedef  unsigned short int     word;
typedef  unsigned long int      dword;


#define NULL 0
typedef struct { word Segment;                 // real mode segment (offset is 0)
                 word Selector;                // pmode selector
               } REALMODEPTR;
typedef struct { dword edi;
                 dword esi;
                 dword ebp;
                 dword reserved;
                 dword ebx;
                 dword edx;
                 dword ecx;
                 dword eax;
                 word flags;
                 word es,ds,fs,gs,ip,cs,sp,ss;
               } RMREGS;

typedef struct { word ModeAttributes;
                 byte WindowAAttributes;
                 byte WindowBAttributes;
                 word WindowGranularity;
                 word WindowSize;
                 word StartSegmentWindowA;
                 word StartSegmentWindowB;
                 void (*WindowPositioningFunction)(int page);
                 word BytesPerScanLine;

                 // VBE v1.0/1.1 opciok:
                 word PixelWidth;
                 word PixelHeight;
                 byte CharacterCellPixelWidth;
                 byte CharacterCellPixelHeight;
                 byte NumberOfMemoryPlanes;
                 byte BitsPerPixel;
                 byte NumberOfBanks;
                 byte MemoryModelType;
                 byte SizeOfBank;
                 byte NumberOfImagePages;
                 byte Reserved1;

                 // VBE v1.2+ opciok:
                 byte RedMaskSize;
                 byte RedFieldPosition;
                 byte GreenMaskSize;
                 byte GreenFieldPosition;
                 byte BlueMaskSize;
                 byte BlueFieldPosition;
                 byte ReservedMaskSize;
                 byte ReservedFieldPosition;
                 byte DirectColourModeInfo;

                 // VBE v2.0+ opciok:
                 dword PhysicalAddress;
                 byte Reserved2[212];
               } VESAMODEINFOBLOCK;
VESAMODEINFOBLOCK modeinfo;

REALMODEPTR VESAmodeinfo_rmptr;
VESAMODEINFOBLOCK far *VESAmodeinfo_pmptr=NULL;

long bytesperscanline;
char *lfbptr; // Points to the video memory if VBE 2.0 detected.Otherwise
 // we have to bank.
long vbeversion=0; // 0 means: We havenot try to set the video mode yet.
                   // 1 menas: VBE 1.2 (no LINEAR framebuffer)
                   // 2 means: VBE 2.0
long truecolor;   // 0 = 16 bit/pixel
                  // 1 = 32 bit/pixel

void setmodeold(int x,int y); // for version 1.2 of VBE
long zbufferneed;


static void far *AllocateDOSMEM(REALMODEPTR *rp,dword size)
{ void far *ptr=NULL;
  union REGS regs;

  // paragraph-ra kerekites:
  size= ((size + 15) & 0xfffffff0);
  memset(&regs,0,sizeof(regs));
  regs.w.ax=0x100;
  // page-ekre konvertalas:
  regs.w.bx= (word)(size>>4);
  int386(0x31,&regs,&regs);
  if(regs.x.cflag == 0)
  { rp->Segment= regs.w.ax;
    rp->Selector= regs.w.dx;
    ptr= MK_FP(regs.w.dx,0);
  }
  return (ptr);
}

static void FreeDOSMEM(REALMODEPTR *rp)
{ union REGS regs;

  regs.w.ax= 0x101;
  regs.w.dx= rp->Selector;
  int386(0x31,&regs,&regs);
}

#define UWORD unsigned short
char * map_physical_memory(unsigned long rp,unsigned long bytes_to_allocate)
{
        char            *ptr;
        union REGS      regs;

        memset(&regs,0,sizeof(regs));
        regs.w.ax = 0x800;
        regs.w.bx = (UWORD)((rp >> 16) & 0xffff);
        regs.w.cx = (UWORD)((rp) &0xffff);
        regs.w.si = (UWORD)((bytes_to_allocate >> 16) & 0xffff);
        regs.w.di = (UWORD)((bytes_to_allocate) & 0xffff);
        int386(0x31,&regs,&regs);
        if(regs.x.cflag == 0)
        {       //Everything OK.
                ptr = (char *)((regs.w.bx << 16) | (regs.w.cx));
        }
        return(ptr);
}

void GetVESAModeInfo(word vmode)
{ union REGS regs;
  struct SREGS sregs;
  RMREGS rmregs;
  boolean ok= 0;

  if((VESAmodeinfo_pmptr= (VESAMODEINFOBLOCK far *)AllocateDOSMEM(&VESAmodeinfo_rmptr,sizeof(VESAMODEINFOBLOCK))))
  { memset(&rmregs,0,sizeof(rmregs));
    rmregs.es= VESAmodeinfo_rmptr.Segment;
    rmregs.ds= VESAmodeinfo_rmptr.Segment;
    rmregs.edi= 0;
    rmregs.eax= 0x4f01;
    rmregs.ecx= vmode;
    memset(&regs,0,sizeof(regs));
    memset(&sregs,0,sizeof(sregs));
    segread(&sregs);
    regs.x.eax= 0x300;
    regs.x.ebx= 0x10;
    regs.x.edi= (dword)&rmregs;
    VESAmodeinfo_pmptr->PhysicalAddress= 0;
    int386x(0x31,&regs,&regs,&sregs);
//    memcpy(&modeinfo,VESAmodeinfo_pmptr,sizeof(modeinfo)); <- suxx
    modeinfo=VESAmodeinfo_pmptr[0];
  }
}

void FreeVESAModeInfoBlock(void)
{ FreeDOSMEM(&VESAmodeinfo_rmptr);
}

dword getmodenumber(dword Xres,dword Yres,dword bpp)
{ register dword i= 0x4100 - 1;

  do
  GetVESAModeInfo(++i);
  while ((i < 0x4170) &&
         !((VESAmodeinfo_pmptr->PixelWidth == Xres) &&
           (VESAmodeinfo_pmptr->PixelHeight == Yres) &&
           (VESAmodeinfo_pmptr->BitsPerPixel == bpp)));
  if(i < 0x4170) return i; else return 0;
}

dword getmodenumberold(dword Xres,dword Yres,dword bpp)
{ register dword i= 0x100 - 1;

  do
  GetVESAModeInfo(++i);
  while ((i < 0x170) &&
         !((VESAmodeinfo_pmptr->PixelWidth == Xres) &&
           (VESAmodeinfo_pmptr->PixelHeight == Yres) &&
           (VESAmodeinfo_pmptr->BitsPerPixel == bpp)));
  if(i < 0x170) return i; else return 0;
}

void settextmode() {
 struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

    memset(&rmregs,0,sizeof(rmregs));
    rmregs.es= VESAmodeinfo_rmptr.Segment;
    rmregs.ds= VESAmodeinfo_rmptr.Segment;
    rmregs.eax= 3;
    memset(&regs,0,sizeof(regs));
    memset(&sregs,0,sizeof(sregs));
    segread(&sregs);
    regs.x.eax= 0x300;
    regs.x.ebx= 0x10;
    regs.x.edi= (dword)&rmregs;
    int386x(0x31,&regs,&regs,&sregs);
 };

// You have to call this to initialize VIDEO and select video mode.
void setmode(int x,int y) {
 long a;
 long mode;
 char *videomemory;
 struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

 if (!use16only)
   mode=getmodenumber(x,y,32);
   else mode=0;

 if (!mode) { // VBE 2.0 32bit/pixel not supportted
  mode=getmodenumber(x,y,16); // try 16 bit/pixel
  if (!mode) { // 16 bit/pixel not supported too. Try VBE 1.2
   setmodeold(x,y);
   return;
   } else {
   truecolor=0; // use VBE 2.0 16 bit/pixel
   byteperpixel=2;
   };

  } else {
  truecolor=1; /// use VBE 2.0 32 bit/pixel
  byteperpixel=4;
  };

  screensize=(unsigned long)(x*y*byteperpixel);
  videomemory=map_physical_memory(modeinfo.PhysicalAddress,screensize);
//  videomemory=modeinfo.PhysicalAddress;
  lfbptr=videomemory;

  screenx=x;
  screeny=y;

  if (framebuffer) {
   free(framebuffer);
   };
  if (zbufferneed) {
    framebuffer=(unsigned long *)malloc(x*y*8);
    }
  else {
    framebuffer=(unsigned long *)malloc(x*y*4);
    };

  bytesperscanline=modeinfo.BytesPerScanLine;
  segread(&sregs);

    memset(&rmregs,0,sizeof(rmregs));
    rmregs.es= VESAmodeinfo_rmptr.Segment;
    rmregs.ds= VESAmodeinfo_rmptr.Segment;
    rmregs.edi= 0;
    rmregs.eax= 0x4f02;
    rmregs.ebx= mode;
    memset(&regs,0,sizeof(regs));
    memset(&sregs,0,sizeof(sregs));
    segread(&sregs);
    regs.x.eax= 0x300;
    regs.x.ebx= 0x10;
    regs.x.edi= (dword)&rmregs;
    int386x(0x31,&regs,&regs,&sregs);

//  printf("%d\n",(long)videomemory);
  vbeversion=2;
  return;
  };


void setmodeold(int x,int y) {
 long a;
 long mode;
 char *videomemory;
 struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

 if (!use16only)
   mode=getmodenumberold(x,y,32);
   else mode=0;

 if (!mode) {
   mode=getmodenumberold(x,y,16);
   if (!mode) {
     printf("Nonsupported video mode");
     exit(0);
     }
   else {
     truecolor=3;
     };
   }
 else {
   truecolor=2;
   };


  screenx=x;
  screeny=y;
  if (framebuffer) {
   free(framebuffer);
   };
  if (zbufferneed) {
    framebuffer=(unsigned long *)malloc(x*y*8);
    }
  else {
    framebuffer=(unsigned long *)malloc(x*y*4);
    };

  bytesperscanline=modeinfo.BytesPerScanLine;

  segread(&sregs);
  memset(&rmregs,0,sizeof(rmregs));
  rmregs.es= VESAmodeinfo_rmptr.Segment;
  rmregs.ds= VESAmodeinfo_rmptr.Segment;
  rmregs.edi= 0;
  rmregs.eax= 0x4f02;
  rmregs.ebx= mode;
  memset(&regs,0,sizeof(regs));
  memset(&sregs,0,sizeof(sregs));
  segread(&sregs);
  regs.x.eax= 0x300;
  regs.x.ebx= 0x10;
  regs.x.edi= (dword)&rmregs;
  int386x(0x31,&regs,&regs,&sregs);

//  printf("%d\n",(long)videomemory);


 vbeversion=1;
 };



void quit(char *message) {
// if (installed) uninstalltimer();  <- do it yourself
// settextmode();
 if (message[0]) {
  printf("%s\n",message);
  };
 exit(0);
 };


extern start(int argc,char *argv[]);
void main(int argc,char *argv[]) {
 start(argc,argv);
 };

void screenfreshasm();
#pragma aux screenfreshasm =                                  \
        "cld"\
        "mov edi,lfbptr"\
        "push es"\
        "push ds"\
        "pop es"\
        "mov esi,framebuffer" \
        "mov ecx,screenx"\
        "imul ecx,screeny"\
        "rep movsd"\
        "pop es"\
        modify exact [ecx edi esi ecx]

void screenfreshconvertasm();
#pragma aux screenfreshconvertasm = \
        "cld"\
        "mov edi,lfbptr"\
        "push es"\
        "push ds"\
        "pop es"\
        "mov esi,framebuffer" \
        "mov ecx,screeny"\
        "laby:"\
        "push ecx"\
        "mov ecx,320"\
        "push edi"\
        "labx:"\
        "lodsd"\
        "mov ebx,eax"\
        "mov edx,eax"\
        "and eax,0f8h"\
        "and ebx,0fc00h"\
        "and edx,0f80000h"\
        "shr eax,3"\
        "shr ebx,5"\
        "shr edx,8"\
        "or eax,ebx"\
        "or eax,edx"\
        "stosw"\
        "dec ecx"\
        "jne labx"\
        "pop edi"\
        "add edi,bytesperscanline"\
        "pop ecx"\
        "dec ecx"\
        "jne laby"\
        "pop es"\
        modify exact [ecx edi esi ecx edx ebx]



void setbank(long a) {
 union REGS regs;
 RMREGS rmregs;

    memset(&rmregs,0,sizeof(rmregs));
    memset(&regs,0,sizeof(regs));

    rmregs.eax=0x4f05;
    rmregs.ebx=0;
    rmregs.edx=a;

    regs.x.eax= 0x300;
    regs.x.ebx= 0x10;
    regs.x.edi= (dword)&rmregs;
    int386(0x31,&regs,&regs);

 };


long addr;
long addrmekkora;
long kepcim;

void copyaddrasm();
#pragma aux copyaddrasm = \
 "cld"\
 "push ds"\
 "pop es"\
 "mov edi,addr"\
 "mov esi,kepcim"\
 "add edi,0a0000h"\
 "mov ecx,addrmekkora"\
 "rep movsd"\
        modify exact [ecx edi esi ecx edx ebx]

void copyaddrconvertasm();
#pragma aux copyaddrconvertasm = \
 "cld"\
 "push ds"\
 "pop es"\
 "mov edi,addr"\
 "mov esi,kepcim"\
 "add edi,0a0000h"\
 "mov ecx,addrmekkora"\
 "labx:"\
 "lodsd"\
 "mov ebx,eax"\
 "mov edx,eax"\
 "and eax,0f8h"\
 "and ebx,0fc00h"\
 "and edx,0f80000h"\
 "shr eax,3"\
 "shr ebx,5"\
 "shr edx,8"\
 "or eax,ebx"\
 "or eax,edx"\
 "stosw"\
 "dec ecx"\
 "jne labx"\
\
        modify exact [ecx edi esi ecx edx ebx]

void screenfreshold() {
 long y,d;
 long bank=0;

 addr=0;
 kepcim=(long)framebuffer;

// memset(kepcim,255,1280*8);

 setbank(0);
 for(y=0;y<screeny;y++) {
    if (addr+1280<0x10000) {

      addrmekkora=320;
      copyaddrasm();

      addr+=bytesperscanline;
      kepcim+=1280;
      if (addr>=0x10000) {
         bank++;
         addr-=0x10000;
         setbank(bank);
         };
      }
    else {
      addrmekkora=(0x10000-addr)>>2;
      copyaddrasm();
      addr+=addrmekkora*4;
      kepcim+=addrmekkora*4;
      addrmekkora=320-addrmekkora;

      bank++;
      addr-=0x10000;
      setbank(bank);

      copyaddrasm();
      addr+=bytesperscanline-(320-addrmekkora)*4;
      kepcim+=addrmekkora*4;
      };
    };

 };

void screenfreshconvertold() {
 long y,d;
 long bank=0;

 addr=0;
 kepcim=(long)framebuffer;

// memset(kepcim,255,1280*8);

 setbank(0);
 for(y=0;y<screeny;y++) {
    if (addr+640<0x10000) {

      addrmekkora=320;
      copyaddrconvertasm();

      addr+=bytesperscanline;
      kepcim+=1280;
      if (addr>=0x10000) {
         bank++;
         addr-=0x10000;
         setbank(bank);
         };
      }
    else {
      addrmekkora=(0x10000-addr)>>1;
      copyaddrconvertasm();
      addr+=addrmekkora*2;
      kepcim+=addrmekkora*4;
      addrmekkora=320-addrmekkora;

      bank++;
      addr-=0x10000;
      setbank(bank);

      copyaddrconvertasm();
      addr+=bytesperscanline-(320-addrmekkora)*2;
      kepcim+=addrmekkora*4;
      };
    };

 };


void screenfresh() {
 switch (truecolor) {
   case 1:      // vbe 2.0 32 bit
        screenfreshasm();
        break;
   case 0:     // vbe 1.2 32 bit
        screenfreshconvertasm();
        break;
   case 2:     // vbe 1.2 32 bit
        screenfreshold();
        break;
   case 3:
        screenfreshconvertold();
        break;
   };
 };

void messagez() {
 };

char ktb[256];
char ktbstay[256];

long b;
void __interrupt __far keyirq() {
 b=inp(0x60);
 if (b>127) {
  ktb[b-128]=0;
  } else {
  ktb[b]=1;
  ktbstay[b]=1;
  };
 outp(32,32);
 };

void (__interrupt __far *oldkey)();
void initkey() {
 memset(&ktb,0,sizeof(ktb));
 memset(&ktbstay,0,sizeof(ktbstay));
 oldkey=_dos_getvect(9);
 _dos_setvect(9,keyirq);
 };
void uninitkey() {
 _dos_setvect(9,oldkey);
 };


void (__interrupt __far *oldtimer)();

long clock;

#ifndef MIDASUSED

void __interrupt __far timerirq() {
 clock++;
 outp(32,32);
 };

void settimer(long a) {
 outp(0x43,0x36);
 outp(0x40,(1197000/a)&255);
 outp(0x40,(1197000/a)>>8);
 };


void installtimer(long timer) {
 clock=0;
 oldtimer=_dos_getvect(8);
 _dos_setvect(8,timerirq);
 settimer(timer);
 };

void uninstalltimer() {
 _dos_setvect(8,oldtimer);
 outp(0x43,0x36);
 outp(0x40,0);
 outp(0x40,0);
 };

#else

void MIDAS_CALL timerirq(void) {
 clock++;
 };


void installtimer(long timer) {
 MIDASsetTimerCallbacks(timer*1000,FALSE,timerirq,0,0);
 };

void uninstalltimer() {
 MIDASremoveTimerCallbacks();
 };

#endif


long gettickcount() {
 return clock;
 };

void settickcount(long lock) {
 clock=lock;
 };

void clearframebufferasm();
#pragma aux clearframebufferasm = \
 "mov edi,framebuffer"\
 "mov ecx,screenx"\
 "imul ecx,screeny"\
 "cld"\
 "xor eax,eax"\
 "rep stosd"\
 modify exact [ecx edi esi ecx eax]

void clearframebuffer() {
 clearframebufferasm();
 };

void subtickcount(long a) {
 clock-=a;
 };

void presskey() {
 getch();
 };

void clearzbuffer() {
 memset(&framebuffer[screenx*screeny],0,screenx*screeny*4);
 };

void initmouse() {
// struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

    memset(&rmregs,0,sizeof(rmregs));
    rmregs.eax= 0;
    memset(&regs,0,sizeof(regs));
    regs.x.eax= 0x300;
    regs.x.ebx= 0x33;
    regs.x.edi= (dword)&rmregs;
    int386(0x31,&regs,&regs);
    rmregs.eax= 7;
    rmregs.ecx= 0;
    rmregs.edx= 4000;
    int386(0x31,&regs,&regs);

 };

long mousex,mousey,mousebuttons;

void setmouseposition() {
 struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

    memset(&rmregs,0,sizeof(rmregs));
    rmregs.es= VESAmodeinfo_rmptr.Segment;
    rmregs.ds= VESAmodeinfo_rmptr.Segment;

    rmregs.eax= 4;
    rmregs.ecx= mousex;
    rmregs.edx= mousey;

    memset(&regs,0,sizeof(regs));
    memset(&sregs,0,sizeof(sregs));
    segread(&sregs);
    regs.x.eax= 0x300;
    regs.x.ebx= 0x33;
    regs.x.edi= (dword)&rmregs;
    int386x(0x31,&regs,&regs,&sregs);

 };

void getmouseinfo() {
 struct SREGS sregs;
 union REGS regs;
 RMREGS rmregs;

    memset(&rmregs,0,sizeof(rmregs));
    rmregs.es= VESAmodeinfo_rmptr.Segment;
    rmregs.ds= VESAmodeinfo_rmptr.Segment;

    rmregs.eax= 3;
    memset(&regs,0,sizeof(regs));
    memset(&sregs,0,sizeof(sregs));
    segread(&sregs);
    regs.x.eax= 0x300;
    regs.x.ebx= 0x33;
    regs.x.edi= (dword)&rmregs;
    int386x(0x31,&regs,&regs,&sregs);

    mousex=rmregs.ecx;
    mousey=rmregs.edx;
    mousebuttons=rmregs.ebx;

 };
