#include <windows.h>
#include <ddraw.h>
#include <stdio.h>

HINSTANCE instance;
HWND hWndMain;
LPDIRECTDRAW            lpDD;
RECT fdat;
float idoallando;
long frame;

char ktb[256],ktbstay[256];


DWORD    transtype = DDBLTFAST_SRCCOLORKEY;

LPDIRECTDRAWSURFACE     lpFrontBuffer;
LPDIRECTDRAWSURFACE     lpBackBuffer;
DDSURFACEDESC lokk;


HWND consolwin,consoledit;

char *consolduma;

long succ=0;
long screenx,screeny;
long *framebuffer=NULL;
long *scr;
long bytesperscanline;
long active=1;

long truecolor;

long FAR PASCAL MainWndproc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
long FAR PASCAL consolwndproc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );


void restoresurfaces() {
    lpBackBuffer->lpVtbl->Restore(lpBackBuffer);
    lpFrontBuffer->lpVtbl->Restore(lpFrontBuffer);
 };


int dderror(char *mivolt) {
 char teljeserror[2048];
 strcpy(teljeserror,"Some problames occured \nin DirectDraw:\n");
 strcat(teljeserror,mivolt);
 MessageBox(0,teljeserror,"DirecDraw error",MB_OK);
 return 0;
 };
int reserror() {
 MessageBox(0,"Non supported video mode.","DirecDraw error",MB_OK);
 return 0;
 };



void flip( void )
{
    HRESULT     ddrval;

    // Flip the surfaces
    while( 1 )
    {
        ddrval = lpFrontBuffer->lpVtbl->Flip( lpFrontBuffer, NULL, 0 );
        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
           restoresurfaces();
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        { // We haev to wait more, if WASSTILLDRAWING
            break;
        }
    }
};


int surfaces() {

    DDCAPS          ddcaps;
    HRESULT         ddrval;
    DDSURFACEDESC   ddsd;
    DDSCAPS         ddscaps;

    memset( &ddsd, 0, sizeof( ddsd ) );
    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS
      | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    ddrval = lpDD->lpVtbl->CreateSurface( lpDD, &ddsd, &lpFrontBuffer, NULL );
    if( ddrval != DD_OK )
        return dderror("CreateSurface FrontBuffer Failed!");
    // The frontbuffer is the video memory


    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpFrontBuffer->lpVtbl->GetAttachedSurface(
                lpFrontBuffer,
                &ddscaps,
                &lpBackBuffer );
    if( ddrval != DD_OK )
        return dderror("GetAttachedSurface Failed!");

   // We attach backbuffer. We use double buffer.

  memcpy(&lokk,&ddsd,sizeof(ddsd));
  // We save the directdrawsurfacedest, because we wanna lock it later.

 return 0;
 };


void screenfresh() {
 HRESULT hres;

 while(1) {
  hres=lpBackBuffer->lpVtbl->Lock(lpBackBuffer,NULL,&lokk,DDLOCK_WAIT,NULL);
  if (hres==DD_OK) break;
  lpBackBuffer->lpVtbl->Restore(lpBackBuffer);
  };
  // When we lock the surface, the kernel doesnot run
 scr=lokk.lpSurface;
 bytesperscanline=lokk.lPitch;

   if (!truecolor) {
    if (lokk.ddpfPixelFormat.dwGBitMask==0x7e0) { // Check, out,
      // is the DX driver support 16bit/pixel HIcolor or 15bit/pixel
      // if we dont have TRUE COLOR MODE.
     truecolor=0;
     } else {
     truecolor=2;
     };
    };


 __asm { // We copy the framebuffer to the screen
  cld
  push es
  push ds
  pop es
  mov edi,scr
  mov esi,framebuffer
  mov edx,screeny

  cmp truecolor,0
  je convert
  cmp truecolor,2
  je convert15

  ciky:      // user has truecolor compatible card, we copy the data easily.
  push edi
  mov ecx,screenx
  rep movsd
  pop edi
  add edi,bytesperscanline
  dec edx
  jne ciky
  pop es
  jmp exitproc

  convert:  // User`s card supports 16 bit/pixel mode by with directx

  ciky2:
  push edx
  push edi
  mov ecx,screenx

  cikx2:
  lodsd
  mov edx,eax
  mov ebx,eax
  and eax,0xf8
  and ebx,0xfc00
  and edx,0xf80000
  shr eax,3
  shr ebx,5
  shr edx,8
  or eax,ebx
  or eax,edx
  stosw
  dec ecx
  jne cikx2

  pop edi
  pop edx
  add edi,bytesperscanline
  dec edx
  jne ciky2

  pop es
  jmp exitproc

  convert15: // User`s card supports 15bit/pixel mode with directx

  ciky3:
  push edx
  push edi
  mov ecx,screenx

  cikx3:
  lodsd
  mov edx,eax
  mov ebx,eax
  and eax,0xf8
  and ebx,0xf800
  and edx,0xf80000
  shr eax,3
  shr ebx,6
  shr edx,9
  or eax,ebx
  or eax,edx
  stosw
  dec ecx
  jne cikx3

  pop edi
  pop edx
  add edi,bytesperscanline
  dec edx
  jne ciky3
  pop es

  exitproc:
  };

 lpBackBuffer->lpVtbl->Unlock(lpBackBuffer,NULL);
 flip(); // This will change the picture start address
};



void quit() {
 exit(0);
 };


void messagez() { // We have to push messages to the window message handling procs.
       MSG msg;
        while( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
        {

                TranslateMessage(&msg);
                DispatchMessage(&msg);

        };

};

long zbufferneed=0; // This will be changed by the APP, if we need
                   // a ZBUFFER after the framebuffer

void setmode(long x,long y) {
 DestroyWindow(consolwin);
 messagez();
 free(consolduma);

 screenx=x;
 screeny=y;
    hWndMain = CreateWindowEx(0,  // WS_EX_TOPMOST,
        "SutyiClass",
        "Archee",
        WS_VISIBLE | // so we don't have to call ShowWindow
        WS_POPUP,    // non-app window
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        instance,
        NULL );
    UpdateWindow( hWndMain );

    // ddinit

   succ=DirectDrawCreate(NULL,&lpDD,NULL);
   if (succ!=DD_OK) return dderror("DirectDrawCreate");

   // DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE for demoz
   succ=lpDD->lpVtbl->SetCooperativeLevel( lpDD, hWndMain,  DDSCL_FULLSCREEN | DDSCL_EXCLUSIVE);
   if (succ!=DD_OK) return dderror("SetCooperativeLevel");

   succ = lpDD->lpVtbl->SetDisplayMode( lpDD, screenx, screeny,32);
    // try true color mode first. On TSENG sux only 24 bit/pixel truecolor
    // mode allowed, fuck, we use hicolor on that.

   if (succ!=DD_OK) {
    succ = lpDD->lpVtbl->SetDisplayMode( lpDD, screenx, screeny,16);
     // Try hicolor.
    truecolor=0; // We dont know yet, 15bit/pixel or 16bit/pixel
    } else {
    truecolor=1;
    };

   surfaces();

   if (framebuffer) free(framebuffer);
   if (zbufferneed) {
    framebuffer=malloc((screenx*screeny<<3)+5120);
    } else {
    framebuffer=malloc((screenx*screeny<<2)+5120);
    };
 };

extern void start(int argc,char *argv[]);

void createconsol() {
    consolduma=malloc(0x10000);
    consolduma[0]=0;
    consolwin = CreateWindow(  // WS_EX_TOPMOST,
        "SutyiClass2",
        "Archee",
//        WS_VISIBLE | // so we don't have to call ShowWindow
        WS_CAPTION|WS_MINIMIZEBOX,    // non-app window
        0,
        0,
//        GetSystemMetrics(SM_CXSCREEN),
//        GetSystemMetrics(SM_CYSCREEN),
        CW_USEDEFAULT,CW_USEDEFAULT,
        NULL,
        NULL,
        instance,
        NULL );
    consoledit=CreateWindow("edit","",WS_CHILD|WS_VISIBLE|ES_MULTILINE,
        0,0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        consolwin,NULL,instance,NULL);

    ShowWindow(consolwin,SW_SHOWNORMAL);
    UpdateWindow( consolwin );

    messagez();
 };

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
                        int nCmdShow ) {

       WNDCLASS wc;
       instance=hInstance;

       wc.style = CS_DBLCLKS;
       wc.lpfnWndProc = MainWndproc;
       wc.cbClsExtra = 0;
       wc.cbWndExtra = 0;
       wc.hInstance = hInstance;
       wc.hIcon = NULL;
       wc.hCursor = NULL;
       wc.hbrBackground = NULL;
       wc.lpszMenuName =  0;
       wc.lpszClassName = "SutyiClass";
       RegisterClass( &wc );
       wc.style = CS_DBLCLKS;
       wc.lpfnWndProc = consolwndproc;
       wc.cbClsExtra = 0;
       wc.cbWndExtra = 0;
       wc.hInstance = hInstance;
       wc.hIcon = NULL;
       wc.hCursor = NULL;
       wc.hbrBackground = NULL;
       wc.lpszMenuName =  0;
       wc.lpszClassName = "SutyiClass2";
       RegisterClass( &wc );

       createconsol();

       start(0,0); // Call da app
   };

void cprintf(char *e) {
/* long a,n;
 n=0;
 for(a=0;e[a];a++) {
    if (e[a]!=10) {
     e[n++]=e[a];
     };
    };
 e[n]=0;*/
 strcat(consolduma,e);
 SetWindowText(consoledit,consolduma);
 messagez();
 };

void altf4hit();

// here comes the window message handling proc
long FAR PASCAL MainWndproc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT ps;
    HDC         hdc;
    UINT        cmd;

    switch( message )
    {

    case WM_CREATE:
        break;
     case WM_ACTIVATEAPP:
      active=wParam; // If the user changed to annother TASK, we cannot
                    // write to the vidoe memory, because we dont want
                    // to fuck up its display
      break;

    case WM_SETCURSOR:
            SetCursor(NULL);
        return TRUE;


    case WM_PAINT:
        hdc = BeginPaint( hWnd, &ps );
        EndPaint( hWnd, &ps );
        // We donwanna draw anything with GDI, but it is avaiable
        // when using directdraw in any video mode.
        return 1;

    case WM_DESTROY:
        altf4hit();
        PostQuitMessage(0);
        break;
    case WM_KEYUP:
     ktb[(lParam>>16)&255]=0;
     break;
    case WM_KEYDOWN:

        ktb[(lParam>>16)&255]=1;
        ktbstay[(lParam>>16)&255]=1;

//        return 0; // NO ALT+TAB !

        break;

    default:
        break;
    }
    return DefWindowProc(hWnd, message, wParam, lParam);

} /* MainWndproc */

long keypressed=0;

long FAR PASCAL consolwndproc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT ps;
    HDC         hdc;
    UINT        cmd;

    switch( message )
    {
    case WM_PAINT:
        hdc = BeginPaint( hWnd, &ps );
        EndPaint( hWnd, &ps );
        return 1;

    case WM_KEYDOWN:
     keypressed=1;
     return 1;

    case WM_DESTROY:
        break;
    }
    return DefWindowProc(hWnd, message, wParam, lParam);
};

void initkey() {
 memset(ktb,0,sizeof(ktb));
 memset(ktbstay,0,sizeof(ktbstay));
 };
void uninitkey() {
 };
void uninstalltimer() {
 };

long timersub;
float timermult=0.0182;
void settimer(long ha) {
 timermult=(float)ha/1000;
 timersub=GetTickCount()*timermult;
 };
void installtimer(long a) {
 timersub=GetTickCount()*timermult;
 settimer(a);
 };
long gettickcount() {
 return GetTickCount()*timermult-timersub;
 };
void settickcount(long a) {
 timersub=GetTickCount()*timermult-a;
 };

void clearframebuffer() {
 __asm {
  push es
  push ds
  pop es
  mov edi,framebuffer
  mov ecx,screenx
  imul ecx,screeny
  xor eax,eax
  cld
  rep stosd
  pop es
  };
 };
void clearzbuffer() {
 __asm {
  push es
  push ds
  pop es
  mov ecx,screenx
  imul ecx,screeny
  lea edi,[ecx*4]
  add edi,framebuffer
  xor eax,eax
  cld
  rep stosd
  pop es
  };
 };

void subtickcount(long a) {
 timersub+=a;
 };

void presskey() {
 long a;
 keypressed=0;
 while(!keypressed) messagez();
 };
