// what source (c) '96/97 Niklas Beisert
// this header must stay at top of this file.
// you may only look at the source, you may not use it.
// you may not release anything containing this code or derivatives.
// you may modify for personal needs or experiments.
// you may use the algorithms in non commercial productions if you credit me.

#include <string.h>
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

void musicpoll();
void musicpause();
void musicunpause();

static HWND hwin;
static int mini;
static int mode16;
static int fullscr;
int playrate=44100;
int stereo=1;
int bit16=1;
int silence;
int interpolate=1;
int qmixer=1;
static int internalconv;
static HINSTANCE hinst;

unsigned short videogetcol16(int r, int g, int b)
{
  r=(r>255)?255:(r<0)?0:r;
  g=(g>255)?255:(g<0)?0:g;
  b=(b>255)?255:(b<0)?0:b;
  if (mode16)
    return ((r>>3)<<11)|((g>>2)<<5)|(b>>3);
  else
    return ((r>>3)<<10)|((g>>3)<<5)|(b>>3);
}

int videoinit()
{
  SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_HIGHEST);
  SetWindowText(hwin, "what");
  return 1;
}

void videoclose()
{
}

void videoput16(void *buf)
{
  char bibuf[sizeof (BITMAPINFOHEADER)+12];
  BITMAPINFO &bi=*(BITMAPINFO*)&bibuf;
  BITMAPINFOHEADER &bih=bi.bmiHeader;
  bih.biSize=sizeof(bih);
  bih.biWidth=320;
  bih.biHeight=-240;
  bih.biPlanes=1;
  bih.biBitCount=16;
  bih.biCompression=BI_BITFIELDS;
  bih.biSizeImage=0;
  bih.biXPelsPerMeter=0;
  bih.biYPelsPerMeter=0;
  bih.biClrUsed=0;
  bih.biClrImportant=0;
  if (mode16)
  {
    ((unsigned long*)bi.bmiColors)[0]=0xF800;
    ((unsigned long*)bi.bmiColors)[1]=0x07E0;
    ((unsigned long*)bi.bmiColors)[2]=0x001F;
  }
  else
  {
    ((unsigned long*)bi.bmiColors)[0]=0x7C00;
    ((unsigned long*)bi.bmiColors)[1]=0x03E0;
    ((unsigned long*)bi.bmiColors)[2]=0x001F;
  }
  musicpoll();
  HDC dc=GetDC(hwin);
  RECT r;
  GetClientRect(hwin, &r);
  StretchDIBits(dc, 0, 0, r.right, r.bottom, 0, 0, 320, 240, buf, &bi, DIB_RGB_COLORS, SRCCOPY);
  ReleaseDC(hwin,dc);
}

extern "C" void puttc32init(void *buf, void *rt, void *gt, void *bt);
#pragma aux puttc32init parm [edx] [ecx] [ebx] [eax]

extern "C" void puttc32(void *dst, long off, int l);
#pragma aux puttc32 parm [eax] [esi] [edi] modify [eax ebx ecx edx esi edi]

static int tabrgb[3][257];

void videoput32(void *buf)
{
  if (internalconv)
  {
    puttc32init(buf, tabrgb[0]+1, tabrgb[1]+1, tabrgb[2]+1);
    puttc32(buf, 0, 320*240);
    videoput16(buf);
    return;
  }
  char bibuf[sizeof (BITMAPINFOHEADER)+12];
  BITMAPINFO &bi=*(BITMAPINFO*)&bibuf;
  BITMAPINFOHEADER &bih=bi.bmiHeader;
  bih.biSize=sizeof(bih);
  bih.biWidth=320;
  bih.biHeight=-240;
  bih.biPlanes=1;
  bih.biBitCount=32;
  bih.biCompression=BI_BITFIELDS;
  bih.biSizeImage=0;
  bih.biXPelsPerMeter=0;
  bih.biYPelsPerMeter=0;
  bih.biClrUsed=0;
  bih.biClrImportant=0;
  ((unsigned long*)bi.bmiColors)[0]=0x00FF0000;
  ((unsigned long*)bi.bmiColors)[1]=0x0000FF00;
  ((unsigned long*)bi.bmiColors)[2]=0x000000FF;
  musicpoll();
  HDC dc=GetDC(hwin);
  RECT r;
  GetClientRect(hwin, &r);
  StretchDIBits(dc, 0, 0, r.right, r.bottom, 0, 0, 320, 240, buf, &bi, DIB_RGB_COLORS, SRCCOPY);
  ReleaseDC(hwin,dc);
}

static int keyflag;

int keyhit()
{
  return keyflag;
}

void demoproc();

static volatile int threadended;

unsigned long CALLBACK newthread(void *)
{
  demoproc();
  threadended=1;
  PostMessage(hwin, WM_CLOSE, 0, 0);
  return 0;
}

static int pauseclick;

long CALLBACK WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
  switch (message)
  {
  case WM_CREATE:
    unsigned long tid;
    CreateThread(0, 4096, newthread, 0, 0, &tid);
    break;
  case WM_DESTROY:
    keyflag=1;
    while (!threadended);
    PostQuitMessage(0);
    break;
  case WM_KEYDOWN:
    if (wParam==VK_ESCAPE)
      keyflag=1;
    break;
  case WM_RBUTTONDOWN:
    ShowWindow(hwin, SW_MINIMIZE);
    break;
  case WM_LBUTTONDOWN:
    pauseclick=!pauseclick;
    if (pauseclick)
      musicpause();
    else
      musicunpause();
    break;
  case WM_ENTERSIZEMOVE:
  case WM_ENTERMENULOOP:
    musicpause();
    break;
  case WM_EXITSIZEMOVE:
  case WM_EXITMENULOOP:
    musicunpause();
    break;
  case WM_SIZE:
    if (wParam==SIZE_MINIMIZED)
    {
      musicpause();
      mini=1;
    }
    else
    if (mini)
    {
      musicunpause();
      mini=0;
    }
    break;
  }

  return DefWindowProc(hWnd, message, wParam, lParam);
}


BOOL CALLBACK setupproc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
  case WM_INITDIALOG:
    CheckDlgButton(hWnd, 103, mode16);
    CheckDlgButton(hWnd, 105, fullscr);
    CheckDlgButton(hWnd, 121, stereo);
    CheckDlgButton(hWnd, 122, silence);
    CheckDlgButton(hWnd, 104, internalconv);
    CheckDlgButton(hWnd, 107, interpolate);
    CheckDlgButton(hWnd, 106, qmixer);
    CheckDlgButton(hWnd, 100, bit16);
    SetDlgItemInt(hWnd, 110, playrate, 0);
    SendMessage(GetDlgItem(hWnd, 110), CB_ADDSTRING, 0, (LPARAM)"22050");
    SendMessage(GetDlgItem(hWnd, 110), CB_ADDSTRING, 0, (LPARAM)"32000");
    SendMessage(GetDlgItem(hWnd, 110), CB_ADDSTRING, 0, (LPARAM)"44100");
    SendMessage(GetDlgItem(hWnd, 110), CB_ADDSTRING, 0, (LPARAM)"48000");
    return 1;
  case WM_COMMAND:
    switch (wParam)
    {
    case IDOK:
      BOOL intok;
      playrate=GetDlgItemInt(hWnd, 110, &intok, 0);
      if (!intok)
        break;
      if (playrate>48000)
        break;
      if (playrate<8000)
        break;
      mode16=IsDlgButtonChecked(hWnd, 103);
      fullscr=IsDlgButtonChecked(hWnd, 105);
      stereo=IsDlgButtonChecked(hWnd, 121);
      silence=IsDlgButtonChecked(hWnd, 122);
      internalconv=IsDlgButtonChecked(hWnd, 104);
      interpolate=IsDlgButtonChecked(hWnd, 107);
      qmixer=IsDlgButtonChecked(hWnd, 106);
      bit16=IsDlgButtonChecked(hWnd, 100);
      EndDialog(hWnd,0);
      return 1;
    case IDCANCEL:
      EndDialog(hWnd,1);
      return 1;
    }
    break;
  }
  return 0;
}


BOOL CALLBACK aboutproc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  switch (message)
  {
  case WM_INITDIALOG:
    return 1;
  case WM_COMMAND:
    switch (wParam)
    {
    case IDOK:
      EndDialog(hWnd,0);
      return 1;
    case IDCANCEL:
      EndDialog(hWnd,1);
      return 1;
    case 118:
      DialogBox(hinst, MAKEINTRESOURCE(101), hWnd, (BOOL CALLBACK (*)())setupproc);
      return 1;
    }
    break;
  }
  return 0;
}


static BOOL doInit(int nCmdShow)
{
  if (DialogBox(hinst, MAKEINTRESOURCE(100), 0, (BOOL CALLBACK (*)())aboutproc))
    return 0;

  tabrgb[0][0]=tabrgb[1][0]=tabrgb[2][0]=0;
  int i;
  for (i=0; i<256; i++)
  {
    tabrgb[0][i+1]=videogetcol16(i,0,0);
    tabrgb[1][i+1]=videogetcol16(0,i,0);
    tabrgb[2][i+1]=videogetcol16(0,0,i);
  }

  WNDCLASS wc;

  wc.style=CS_HREDRAW|CS_VREDRAW;
  wc.lpfnWndProc=WindowProc;
  wc.cbClsExtra=0;
  wc.cbWndExtra=0;
  wc.hInstance=hinst;
  wc.hIcon=LoadIcon(hinst, MAKEINTRESOURCE(151));
  wc.hCursor=LoadCursor(0, IDC_ARROW);
  wc.hbrBackground=0;
  wc.lpszMenuName=0;
  wc.lpszClassName="what";
  RegisterClass(&wc);

  RECT r;
  r.top=CW_USEDEFAULT;
  r.left=CW_USEDEFAULT;
  r.right=320+2*GetSystemMetrics(SM_CXSIZEFRAME);
  r.bottom=240+2*GetSystemMetrics(SM_CYSIZEFRAME)+GetSystemMetrics(SM_CYCAPTION)-GetSystemMetrics(SM_CYBORDER);
  unsigned long style=WS_OVERLAPPED|WS_MINIMIZEBOX|WS_SYSMENU|WS_SIZEBOX|WS_MAXIMIZEBOX;
  unsigned long styleex=0;
  if (fullscr)
  {
    r.top=0;
    r.left=0;
    r.right=GetSystemMetrics(SM_CXSCREEN);
    r.bottom=GetSystemMetrics(SM_CYSCREEN);
    style=WS_POPUP;
    styleex=WS_EX_TOPMOST;
  }

  hwin = CreateWindowEx(styleex,"what","initializing what, please wait", style, r.left, r.top, r.right, r.bottom, 0, 0, hinst, 0);

  if (!hwin)
    return 0;

  if (nCmdShow==SW_MINIMIZE)
    mini=1;
  ShowWindow(hwin, nCmdShow);
  UpdateWindow(hwin);

  return 1;
}



int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  hinst=hInstance;
  MSG msg;

  lpCmdLine=lpCmdLine;
  hPrevInstance=hPrevInstance;

  if (!doInit(nCmdShow))
    return 0;

  while (GetMessage(&msg, 0, 0, 0))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return msg.wParam;
}
