#ifndef DIRECTXCONVERSION_H
#define DIRECTXCONVERSION_H

// Set up the types necessary
#ifndef HRESULT
#define HRESULT long
#endif
#ifndef DWORD
#define DWORD unsigned long
#define BYTE unsigned char
#define BOOL int
#define TRUE 1
#define FALSE 0
#define PASCAL __stdcall
#endif

// Fast (relatively) routines for doing a frame.
//////////////////////////////////////////////////////

// Call this to obtain the memory area for writing a
// frame.
// Returns a pointer to 320x200 graphics buffer and the 
// amount you should increment to your pointers after
// doing each line (Often 0)
HRESULT HrStartFrame(BYTE* &pbBuffer,DWORD &dwLineOfs);

// Call this when the frame is finished.
HRESULT HrFinishFrame();


// Slow frame routine
//////////////////////////////////////////////////////

// Call this to copy your standard 320x200 64,000 bye
// buffer into the next frame.
HRESULT HrNewFrame(BYTE* pbBuffer);


// Utility functions and variables
//////////////////////////////////////////////////////

// Call this to set the palette from a 768-byte palette
// buffer of the format r,g,b,r,g,b,... where each colour
// goes from 0-255.
void SetPalette(BYTE* bPalette);

// Your function must poll this variable. If it is set
// true, you must set it false and exit.
extern volatile BOOL sg_fThreadQuit;

// The frame count is provided for information; this is
// total frame count since the start of the program. 
extern int sg_iFrameCount;

//////////////////////////////////////////////////////
#endif // DIRECTXCONVERSION_H
